"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parsePhraseyCliConfigOptions = exports.PhraseyCliConfigOptionFlags = void 0;
const commander_1 = require("commander");
const path_1 = __importDefault(require("path"));
const log_1 = require("./log");
exports.PhraseyCliConfigOptionFlags = {
    configFile: new commander_1.Option("-p --config-file <path>", "Path to config file"),
    configFormat: new commander_1.Option("-f --config-format <format>", "Config file format"),
};
const parsePhraseyCliConfigOptions = (
// eslint-disable-next-line @typescript-eslint/no-explicit-any
options) => {
    if (!options.configFile) {
        log_1.log.error(`Missing argument: ${log_1.pico.bold("config-file")}.`);
        log_1.log.ln();
        process.exit(1);
    }
    const configFile = path_1.default.resolve(process.cwd(), options.configFile);
    const cwd = path_1.default.dirname(configFile);
    const configFormat = options.configFormat;
    if (!configFormat) {
        log_1.log.error(`Missing argument: ${log_1.pico.bold("config-format")}.`);
        log_1.log.ln();
        process.exit(1);
    }
    return {
        cwd,
        config: {
            file: configFile,
            format: configFormat,
        },
    };
};
exports.parsePhraseyCliConfigOptions = parsePhraseyCliConfigOptions;
