"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchCommand = void 0;
const commander_1 = require("commander");
const __1 = require("../../");
const log_1 = require("../utils/log");
const parseConfigOptions_1 = require("../utils/parseConfigOptions");
exports.WatchCommand = new commander_1.Command()
    .name("watch")
    .description("Watch and build the project.")
    .addOption(parseConfigOptions_1.PhraseyCliConfigOptionFlags.configFile)
    .addOption(parseConfigOptions_1.PhraseyCliConfigOptionFlags.configFormat)
    .action(async (options) => {
    const configOptions = (0, parseConfigOptions_1.parsePhraseyCliConfigOptions)(options);
    await __1.PhraseyWatcher.create({
        phrasey: {
            cwd: configOptions.cwd,
            log: log_1.log,
            source: "watch",
        },
        builder: {
            config: configOptions.config,
        },
        watcher: {
            buildAllTranslations: true,
        },
    });
});
