"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BuildCommand = void 0;
const commander_1 = require("commander");
const __1 = require("../../");
const log_1 = require("../utils/log");
const parseConfigOptions_1 = require("../utils/parseConfigOptions");
exports.BuildCommand = new commander_1.Command()
    .name("build")
    .description("Build the project.")
    .addOption(parseConfigOptions_1.PhraseyCliConfigOptionFlags.configFile)
    .addOption(parseConfigOptions_1.PhraseyCliConfigOptionFlags.configFormat)
    .action(async (options) => {
    const configOptions = (0, parseConfigOptions_1.parsePhraseyCliConfigOptions)(options);
    const result = await __1.PhraseyBuilder.build({
        phrasey: {
            cwd: configOptions.cwd,
            log: log_1.log,
            source: "build",
        },
        builder: {
            config: configOptions.config,
        },
    });
    if (!result.success) {
        log_1.log.error("Build failed.");
        log_1.log.logErrors(result.error);
        log_1.log.ln();
        process.exit(1);
    }
    log_1.log.success("Build succeeded.");
    log_1.log.ln();
});
