"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyCldrJson = void 0;
const path_1 = __importDefault(require("path"));
const promises_1 = __importDefault(require("fs/promises"));
class PhraseyCldrJson {
    static parse(module, subpath) {
        return __awaiter(this, void 0, void 0, function* () {
            // "package.json" to avoid searching entrypoint of the module
            const dir = path_1.default.dirname(require.resolve(`${module}/package.json`));
            const path = path_1.default.resolve(dir, subpath);
            const cached = PhraseyCldrJson.cache.get(path);
            if (cached) {
                return cached;
            }
            const content = yield promises_1.default.readFile(path, "utf-8");
            const data = JSON.parse(content);
            return data;
        });
    }
}
exports.PhraseyCldrJson = PhraseyCldrJson;
PhraseyCldrJson.cache = new Map();
