"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyZSchema = exports.PhraseyZSchemaKey = void 0;
const zod_1 = require("zod");
const utils_1 = require("../utils");
exports.PhraseyZSchemaKey = zod_1.z.object({
    name: zod_1.z.string().regex(utils_1.PhraseyIdentifierRegex),
    description: zod_1.z.string().optional(),
    parameters: zod_1.z.array(zod_1.z.string().regex(utils_1.PhraseyIdentifierRegex)).optional(),
});
exports.PhraseyZSchema = zod_1.z.object({
    keys: zod_1.z.array(exports.PhraseyZSchemaKey),
});
