import { PhraseyContentFormatter } from "./contentFormats";
import { PhraseyLocaleType, PhraseyLocales } from "./locales";
import { PhraseyResult } from "./result";
import { PhraseySchema } from "./schema";
import { PhraseyTranslationStringFormatter } from "./translationStringFormat";
import { PhraseyZSchemaKeyType } from "./z";
export interface PhraseyTranslationStringPart {
    type: "string" | "parameter";
    value: string;
}
export type PhraseyTranslationStringParts = PhraseyTranslationStringPart[];
export interface PhraseyTranslationStringSet {
    state: "set" | "fallback";
    parts: PhraseyTranslationStringParts;
}
export interface PhraseyTranslationStringUnset {
    state: "unset";
}
export type PhraseyTranslationStringValue = PhraseyTranslationStringSet | PhraseyTranslationStringUnset;
export type PhraseyTranslationState = PhraseyTranslationStringSet["state"] | PhraseyTranslationStringUnset["state"];
export interface PhraseyTranslationSerialized {
    locale: PhraseyLocaleType;
    extras: Record<string, any>;
    keys: Record<string, any>;
}
export interface PhraseyTranslationJson {
    locale: PhraseyLocaleType;
    extras: Record<string, any>;
    keys: Record<string, PhraseyTranslationStringValue>;
}
export declare class PhraseyTranslation {
    path: string;
    schema: PhraseySchema;
    locale: PhraseyLocaleType;
    extras: Record<string, any>;
    fallback: string[];
    keys: Map<string, PhraseyTranslationStringValue>;
    stats: PhraseyTranslationStats;
    constructor(path: string, schema: PhraseySchema, locale: PhraseyLocaleType, extras: Record<string, any>, fallback: string[]);
    setKey(key: string, value: PhraseyTranslationStringValue): void;
    getKey(key: string): PhraseyTranslationStringValue | undefined;
    hasKey(key: string): boolean;
    keysCount(): number;
    serialize(stringFormatter: PhraseyTranslationStringFormatter): PhraseyTranslationSerialized;
    json(): PhraseyTranslationJson;
    static create(path: string, schema: PhraseySchema, formatter: PhraseyContentFormatter, locales: PhraseyLocales, globalFallback: string[]): Promise<PhraseyResult<PhraseyTranslation, Error>>;
    static parseTranslationKeyValue(key: PhraseyZSchemaKeyType, content: string): PhraseyResult<PhraseyTranslationStringPart[], Error>;
}
export interface PhraseyTranslationStatsJsonExtendedState {
    keys: string[];
    count: number;
    percent: number;
}
export interface PhraseyTranslationStatsJson {
    set: PhraseyTranslationStatsJsonExtendedState;
    fallback: PhraseyTranslationStatsJsonExtendedState;
    unset: PhraseyTranslationStatsJsonExtendedState;
    total: number;
    isBuildable: boolean;
    isStandaloneBuildable: boolean;
}
export declare class PhraseyTranslationStats {
    set: Set<string>;
    fallback: Set<string>;
    unset: Set<string>;
    total: number;
    process(key: string, value: PhraseyTranslationStringValue): void;
    unprocess(key: string, value: PhraseyTranslationStringValue): void;
    json(): PhraseyTranslationStatsJson;
    get isBuildable(): boolean;
    get isStandaloneBuildable(): boolean;
    get setCount(): number;
    get fallbackCount(): number;
    get unsetCount(): number;
    get setPercent(): number;
    get fallbackPercent(): number;
    get unsetPercent(): number;
}
