"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyTransformer = void 0;
const fs_extra_1 = require("fs-extra");
const errors_1 = require("./errors");
const result_1 = require("./result");
class PhraseyTransformer {
    static async transform(path, formatter, schema) {
        const content = await (0, result_1.PhraseySafeRunAsync)(async () => await (0, fs_extra_1.readFile)(path, { encoding: "utf-8" }));
        if (!content.success)
            return content;
        const parsed = (0, result_1.PhraseySafeRun)(() => formatter.deserialize(content.data));
        if (!parsed.success)
            return parsed;
        const transformed = schema.safeParse(parsed.data);
        if (!transformed.success) {
            return {
                success: false,
                error: new errors_1.PhraseyValidationError(`Parsing "${path}" failed due to validation errors`, transformed.error),
            };
        }
        return {
            success: true,
            data: transformed.data,
        };
    }
}
exports.PhraseyTransformer = PhraseyTransformer;
