"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseySchema = void 0;
const contentFormats_1 = require("./contentFormats");
const transformer_1 = require("./transformer");
const z_1 = require("./z");
class PhraseySchema {
    z;
    keys = new Map();
    constructor(z) {
        this.z = z;
    }
    init() {
        for (const x of this.z.keys) {
            this.keys.set(x.name, x);
        }
    }
    key(name) {
        return this.keys.get(name);
    }
    keysCount() {
        return this.keys.size;
    }
    json() {
        return {
            z: this.z,
            keys: Object.fromEntries(this.keys.entries()),
        };
    }
    static async create(path, format) {
        const z = await transformer_1.PhraseyTransformer.transform(path, contentFormats_1.PhraseyContentFormats.resolve(format), z_1.PhraseyZSchema);
        if (!z.success)
            return z;
        const schema = new PhraseySchema(z.data);
        schema.init();
        return { success: true, data: schema };
    }
}
exports.PhraseySchema = PhraseySchema;
