"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseySafeRunAsync = exports.PhraseySafeRun = void 0;
const PhraseySafeRun = (fn) => {
    try {
        const data = fn();
        return { success: true, data };
    }
    catch (error) {
        return PhraseyParseRunError(error);
    }
};
exports.PhraseySafeRun = PhraseySafeRun;
const PhraseySafeRunAsync = async (fn) => {
    try {
        const data = await fn();
        return { success: true, data };
    }
    catch (error) {
        return PhraseyParseRunError(error);
    }
};
exports.PhraseySafeRunAsync = PhraseySafeRunAsync;
const PhraseyParseRunError = (error) => {
    if (error instanceof Error) {
        return {
            success: false,
            error,
        };
    }
    return {
        success: false,
        error: new Error(`${error}`),
    };
};
