export interface PhraseyLoggerOptions {
    tag?: string;
    write: (text: string) => void;
    writeError: (error: unknown) => void;
}
export type PhraseyLogLevel = "success" | "info" | "warn" | "error";
export declare class PhraseyLogger {
    readonly options: PhraseyLoggerOptions;
    constructor(options: PhraseyLoggerOptions);
    success(text: string): void;
    info(text: string): void;
    warn(text: string): void;
    error(text: string, error?: unknown): void;
    logErrors(errors: unknown | unknown[]): void;
    grayed(text: string): void;
    ln(): void;
    log(level: PhraseyLogLevel, text: string): void;
    write(text: string): void;
    writeError(error: unknown): void;
    inherit(tag: string): PhraseyLogger;
    _level(level: PhraseyLogLevel): string;
    _prefix(level: PhraseyLogLevel): string;
    static console(tag?: string): PhraseyLogger;
}
