"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
const path_1 = __importDefault(require("path"));
const promises_1 = require("fs/promises");
const phrasey_1 = require("phrasey");
const builder_1 = require("./builder");
class PhraseyLocaleBuilderOptionsError extends Error {
    constructor(option) {
        super(`phrasey-locales-builder: Missing or invalid "${option}" value in options`);
    }
}
const hooks = {
    beforeLocalesParsing: ({ phrasey, options, log }) => __awaiter(void 0, void 0, void 0, function* () {
        const { displayLocaleCode, outputFile, outputFormat } = options;
        if (typeof displayLocaleCode !== "string") {
            throw new PhraseyLocaleBuilderOptionsError("displayLocaleCode");
        }
        if (typeof outputFile !== "string") {
            throw new PhraseyLocaleBuilderOptionsError("outputFile");
        }
        if (typeof outputFormat !== "string") {
            throw new PhraseyLocaleBuilderOptionsError("outputFormat");
        }
        const outputFilePath = phrasey.path(outputFile);
        const locales = yield builder_1.PhraseyLocaleBuilder.build({
            displayLocaleCode,
        });
        const formatter = phrasey_1.PhraseyContentFormats.resolve(outputFormat);
        const content = formatter.serialize(locales);
        yield (0, promises_1.writeFile)(outputFilePath, content);
        log.success(`Generated "${path_1.default.resolve(phrasey.cwd, outputFilePath)}".`);
    }),
};
module.exports = hooks;
