<div align="center">
<img src="app/src/main/ic_launcher-playstore.png"
    alt="Get it on F-Droid"
    height="75">
<h1>freeDictionary</h1>
</div>

[![Android CI](https://github.com/yamin8000/freeDictionaryApp/actions/workflows/android.yml/badge.svg)](https://github.com/yamin8000/freeDictionaryApp/actions/workflows/android.yml)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=yamin8000_freeDictionaryApp&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=yamin8000_freeDictionaryApp)
[![CodeFactor](https://www.codefactor.io/repository/github/yamin8000/freedictionaryapp/badge)](https://www.codefactor.io/repository/github/yamin8000/freedictionaryapp)

**freeDictionary** is a simple Android application
for [freeDictionaryAPI](https://dictionaryapi.dev/) a reincarnation
of https://github.com/yamin8000/Owl2

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/io.github.yamin8000.owl)

## Preview

### Featured on [TechDoc](https://www.youtube.com/watch?v=vlf0jEFHR74&t=59s)

<table>
<tr>
<td><img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/1.jpg" alt="preview" width="200"/></td>
<td><img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/2.jpg" alt="preview" width="200"/></td>
<td><img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/3.jpg" alt="preview" width="200"/></td>
</tr>
<tr>
<td align="center">Dark</td>
<td align="center">Light</td>
<td align="center">OLED</td>
</tr>
</table>

More screenshots [here](./screenshots).

## Compatibility

> [!important]
> **SDK21+** or **Android 5.0+**

## Usage

Just use the search input to search the word.

## Download

- GitHub releases: [here](https://github.com/yamin8000/freeDictionaryApp/releases)
- F-Droid: [here](https://f-droid.org/packages/io.github.yamin8000.owl)
- IzzyOnDroid: [here](https://apt.izzysoft.de/fdroid/index/apk/io.github.yamin8000.owl)
- Bazaar: [here](https://cafebazaar.ir/app/io.github.yamin8000.owl)

## Features

- English to English dictionary
- Definition of the word
- Example of the word usage if available
- Synonyms/Antonyms of the work if available
- Pronunciation of the word, both IPA text and audio using TTS
- Save searched data for offline uses
- Search for a random word

## Tech Stack

- Kotlin(JVM)
- Compose UI
- Material3/Material You
- Clean Architecture
- Dependency Injection with Hilt/Dagger
- MVI / MVVM
- Retrofit, Moshi with KSP, Coil
- Datastore, Room with KSP

## License

> [!important]
> freeDictionaryApp is licensed under the **[GNU General Public License v3.0](./LICENSE)**  
> Permissions of this strong copyleft license are conditioned on making  
> available complete source code of licensed works and modifications,  
> which include larger works using a licensed work, under the same  
> license. Copyright and license notices must be preserved. Contributors  
> provide an express grant of patent rights.
