package io.github.wiiznokes.gitnote.ui.component

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.RowScope
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.imePadding
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.safeDrawing
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.material3.surfaceColorAtElevation
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.dp
import io.github.wiiznokes.gitnote.ui.utils.conditional

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun AppPage(
    title: String,
    titleStyle: TextStyle = MaterialTheme.typography.titleLarge,
    onBackClick: (() -> Unit)? = null,
    onBackClickEnabled: Boolean = true,
    verticalArrangement: Arrangement.Vertical = Arrangement.Top,
    horizontalAlignment: Alignment.Horizontal = Alignment.Start,
    disableVerticalScroll: Boolean = false,
    contentWindowInsets: WindowInsets = WindowInsets.safeDrawing,
    actions: @Composable RowScope.() -> Unit = {},
    bottomBar: @Composable () -> Unit = {},
    content: @Composable ColumnScope.() -> Unit
) {

    Scaffold(
        modifier = Modifier
            .imePadding(),
        contentWindowInsets = contentWindowInsets,
        topBar = {
            TopAppBar(
                actions = actions,
                title = {
                    Text(
                        text = title,
                        overflow = TextOverflow.Ellipsis,
                        maxLines = 1,
                        style = titleStyle
                    )
                },
                navigationIcon = {
                    onBackClick?.let {
                        IconButton(
                            onClick = it,
                            enabled = onBackClickEnabled
                        ) {
                            SimpleIcon(
                                imageVector = Icons.AutoMirrored.Filled.ArrowBack,
                            )
                        }
                    }
                },
                colors = TopAppBarDefaults.topAppBarColors(
                    containerColor = MaterialTheme.colorScheme.surfaceColorAtElevation(15.dp)
                )
            )
        },
    ) { paddingValues ->

        Column(
            modifier = Modifier
                .fillMaxSize()
                .padding(paddingValues)
        ) {
            Column(
                modifier = Modifier
                    .fillMaxSize()
                    .weight(1f)
                    .conditional(!disableVerticalScroll) {
                        verticalScroll(rememberScrollState())
                    },
                verticalArrangement = verticalArrangement,
                horizontalAlignment = horizontalAlignment
            ) {
                content()

            }
            bottomBar()
        }
    }
}
