# Traditional T9
Цей посібник пояснює, як налаштувати та використовувати Traditional T9 у різних ситуаціях. Для інструкцій з встановлення та інформації про версії "lite" і "full" зверніться до [Інструкції з встановлення](https://github.com/sspanak/tt9/blob/master/docs/installation.md) на GitHub. Також рекомендуємо ознайомитися з [головною сторінкою репозиторію](https://github.com/sspanak/tt9), де розміщено весь вихідний код, посібник для розробників, політику конфіденційності та додаткову документацію.

## Початкове налаштування
Після встановлення спочатку потрібно увімкнути Traditional T9 як клавіатуру Android. Для цього натисніть на іконку запуску. Якщо потрібно виконати будь-яку дію, всі інші параметри, окрім Початкового налаштування, будуть відключені, і з’явиться напис: "TT9 вимкнено". Перейдіть до Початкового налаштування і увімкніть його.

_Якщо ви не бачите іконку відразу після встановлення, перезавантажте телефон, і вона має з’явитися. Це може статися через те, що Android намагається заощадити заряд батареї, не оновлюючи список щойно встановлених додатків._

### Використання на телефоні з сенсорним екраном
На сенсорних пристроях також рекомендується вимкнути системну перевірку правопису. Її не можна використовувати під час введення тексту за допомогою цифрових клавіш, тому вимкнення цієї функції може заощадити заряд батареї.

Ще одна проблема в тому, що може з’явитися спливаюче вікно "Додати слово", яке додає слова до системної клавіатури (зазвичай, Gboard), а не до словника Traditional T9. Щоб уникнути таких ситуацій, потрібно вимкнути системну перевірку правопису.

Якщо потрібно виконати цей крок, елемент "Системна перевірка правопису" буде активним на екрані Початкового налаштування. Натисніть його, щоб відключити цю системну функцію. Якщо такого елемента немає, тоді нічого додатково робити не потрібно.

Після завершення налаштування перегляньте розділ [Екранна клавіатура](#екранна-клавіатура) для отримання додаткових порад і прийомів.

### Увімкнення Режиму прогнозування
Режим прогнозування потребує завантаження мовного словника для пропонування слів. Ви можете налаштувати мови та завантажити їх словники в Налаштуваннях → [Мови](#мовні-налаштування). Якщо ви забудете завантажити якийсь словник, Traditional T9 зробить це автоматично під час введення. Додаткову інформацію дивіться [нижче](#мовні-налаштування).

#### Примітки для телефонів нижнього класу
Завантаження словника може перевантажити телефони нижнього класу. Під час використання версії TT9 "lite" це призведе до скасування операції Android. Якщо завантаження займає більше 30 секунд, підключіть зарядний пристрій або забезпечте, щоб екран залишався ввімкненим під час завантаження.

Цього можна уникнути, використовуючи версію "full".

#### Примітки для Android 13 або новішої версії
За замовчуванням сповіщення для нових додатків вимкнені. Рекомендується увімкнути їх, щоб отримувати повідомлення про оновлення словників, і коли ви оберете їх встановлення, TT9 покаже процес завантаження. Нові оновлення виходять максимум раз на місяць, тож не варто хвилюватися про надмірні сповіщення.

Ви можете увімкнути сповіщення, перейшовши до Налаштування → Мови та вмикнувши Сповіщення словника.

_Якщо ви вирішите залишити їх вимкненими, TT9 продовжить працювати без проблем, але словниками доведеться керувати вручну._

## Гарячі клавіші

Всі гарячі клавіші можна переналаштувати або відключити в Налаштуваннях → Клавіатура → Вибір гарячих клавіш.

### Клавіші введення

#### Клавіша попередньої пропозиції (за замовчуванням: D-pad Left):
Вибрати попереднє слово/букву в пропозиції.

#### Клавіша наступної пропозиції (за замовчуванням: D-pad Right):
Вибрати наступне слово/букву в пропозиції.

#### Клавіша фільтрації пропозицій (за замовчуванням: D-pad Up):
_Тільки в режимі прогнозування._

- **Одинарне натискання**: Відфільтрувати список пропозицій, залишивши лише ті, що починаються з поточного слова. Не важливо, чи є це повним словом чи ні. Наприклад, введіть "remin" і натисніть Фільтр. Це залишить всі слова, що починаються з "remin": "remin", "remind", "reminds", "reminded", "reminding" тощо.
- **Подвійне натискання**: Розширити фільтр до повної пропозиції. Наприклад, введіть "remin" і натисніть Фільтр двічі. Спочатку відфільтрується за "remin", а потім фільтр розшириться до "remind". Ви можете продовжувати розширювати фільтр до найдовшого слова у словнику.

Фільтрація також корисна для введення невідомих слів. Наприклад, щоб ввести "Anakin", якого немає у словнику, почніть з "A", потім натисніть Фільтр, щоб приховати "B" та "C". Далі натисніть клавішу 6. Оскільки фільтр увімкнено, крім справжніх слів, буде доступно всі можливі комбінації для 1+6: "A..." + "m", "n", "o". Виберіть "n" і натисніть Фільтр, щоб підтвердити свій вибір і отримати "An". Тепер натискання клавіші 2 надасть "An..." + "a", "b" і "c". Оберіть "a" і продовжуйте, поки не отримаєте "Anakin".

Коли фільтрація увімкнена, основний текст стане жирним та курсивним.

#### Клавіша скидання фільтру (за замовчуванням: D-pad Down):
_Тільки в режимі прогнозування._

Скинути фільтр пропозицій, якщо він застосований.

#### D-pad Center (OK або ENTER):
- Коли пропозиції відображаються, вводить поточну пропозицію.
- В іншому випадку виконує дію за замовчуванням для поточного застосунку (наприклад, надсилає повідомлення, переходить на URL або просто додає новий рядок).

_**Примітка:** Кожен застосунок самостійно вирішує, що робити при натисканні OK, і TT9 не має контролю над цим._

_**Примітка 2:** Для відправлення повідомлень через OK у месенджерах потрібно увімкнути їхнє налаштування "Відправка за ENTER" або подібне. Якщо такого налаштування немає, додаток, ймовірно, не підтримує відправлення таким способом. У цьому випадку використовуйте застосунок KeyMapper з [Play Store](https://play.google.com/store/apps/details?id=io.github.sds100.keymapper) або з [F-droid](https://f-droid.org/packages/io.github.sds100.keymapper/). Він може виявляти чати та імітувати натискання на кнопку надсилання повідомлення після натискання або утримання апаратної клавіші. Ознайомтеся з [посібником швидкого запуску](https://docs.keymapper.club/quick-start/) для отримання додаткової інформації._

#### Клавіша 0:
- **У режимі 123:**
  - **Натискання:** вводить "0".
  - **Утримування:** вводить спеціальні/математичні символи.
- **У режимі ABC:**
  - **Натискання:** вводить пробіл, новий рядок або спеціальні/математичні символи.
  - **Утримування:** вводить "0".
- **У режимі Прогнозування:**
  - **Натискання:** вводить пробіл, новий рядок або спеціальні/математичні символи.
  - **Подвійне натискання:** вводить символ, призначений у налаштуваннях режиму Прогнозування (за замовчуванням ".").
  - **Утримування:** вводить "0".
- **У режимі Чонджиін (Корейська):**
  - **Натискання:** вводить "ㅇ" та "ㅁ".
  - **Утримування:** вводить пробіл, новий рядок, "0" або спеціальні/математичні символи.

#### Клавіша 1:
- **У режимі 123:**
  - **Натискання:** вводить "1".
  - **Утримування:** вводить знаки пунктуації.
- **У режимі ABC:**
  - **Натискання:** вводить знаки пунктуації.
  - **Утримування:** вводить "1".
- **У режимі Прогнозування:**
  - **Натискання:** вводить знаки пунктуації.
  - **Кілька натискань:** вводить емодзі.
  - **Утримування:** вводить "1".
- **У режимі Чонджиін (Корейська):**
  - **Натискання:** вводить голосну "ㅣ".
  - **Утримування:** вводить знаки пунктуації.
  - **Утримування, потім натискань:** вводить емодзі.

#### Клавіші 2 до 9:
- **У режимі 123:** вводить відповідне число.
- **У режимах ABC та Прогнозування:** вводить букву або утримує для введення відповідного числа.

### Функціональні клавіші

#### Клавіша Додати слово:
Додає нове слово до словника для поточної мови.

#### Клавіша Видалити (Назад, Del або Backspace):
Просто видаляє текст.

Якщо на вашому телефоні є спеціальна клавіша "Del" або "Очистити", нічого додатково налаштовувати в Налаштуваннях не потрібно, якщо тільки ви не хочете мати додаткову клавішу Backspace. У цьому випадку автоматично буде обрана порожня опція: "--".

На телефонах із поєднаною функцією "Видалити"/"Назад", ця клавіша вибирається автоматично. Однак ви можете призначити функцію "Backspace" іншій клавіші, тож "Назад" буде тільки повертати назад.

_**Примітка:** Використання "Назад" як backspace не працює у всіх додатках, особливо Firefox, Spotify і Termux. Вони можуть повністю контролювати клавішу та змінювати її функцію, тобто вона виконує задумане розробниками. На жаль, нічого не можна зробити, оскільки "Назад" має особливу роль в Android і його використання обмежене системою._

_**Примітка 2:** Утримання клавіші "Назад" завжди запускає стандартну дію системи (тобто показує список запущених додатків)._

_У таких випадках можна призначити іншу клавішу (всі інші клавіші повністю доступні) або використовувати екранну клавішу видалення._

#### Клавіша Наступний режим введення (за замовчуванням: натискання #):
Перемикає режими введення (АБВ → Прогнозування → 123).

_Режим прогнозування недоступний у полях паролів._

_У полях, де дозволено лише числа, зміна режиму неможлива. У таких випадках клавіша повертається до своєї основної функції (тобто вводить "#")._

#### Клавіша Інструменти буфера обміну:
Відображає панель інструментів буфера обміну, яка дозволяє вибирати, вирізати, копіювати та вставляти текст. Панель можна закрити, повторно натиснувши клавішу "✱" або, у більшості додатків, клавішу «Назад». Докладніше див. [нижче](#інструменти-буфера-обміну).

#### Клавіша Наступна мова (за замовчуванням: утримання #):
Змінити мову введення, якщо в налаштуваннях увімкнено кілька мов.

#### Клавіша Вибрати клавіатуру:
Відкриває діалог Змінити клавіатуру Android, де можна вибрати одну з усіх встановлених клавіатур.

#### Клавіша Shift (за замовчуванням: натискання ✱):
- **Під час введення тексту:** перемикає між великими та малими буквами.
- **Під час введення спеціальних символів за допомогою клавіші 0**: відображає наступну групу символів.

#### Клавіша Відкрити налаштування:
Відкриває екран налаштувань. Тут можна вибрати мови для введення, налаштувати гарячі клавіші клавіатури, змінити вигляд застосунку або покращити сумісність із телефоном.

#### Клавіша Скасування:
Скасовує останню дію. Аналогічно натисканню Ctrl+Z на комп’ютері або Cmd+Z на Mac.

_Історію скасування дій керують самі додатки, а не Traditional T9. Це означає, що скасування може бути недоступним у деяких додатках._

#### Клавіша Повтору:
Повторює останню скасовану дію. Аналогічно натисканню Ctrl+Y або Ctrl+Shift+Z на комп’ютері або Cmd+Y на Mac.

_Як і скасування, команда повтору може бути недоступною в деяких додатках._

#### Клавіша Голосове введення:
Активує голосове введення на телефонах, які це підтримують. Дивіться [нижче](#голосове-введення) для отримання додаткової інформації.

#### Клавіша Список команд / Палета команд / (за замовчуванням: утримання ✱):
Відображає список усіх команд (або функцій).

Багато телефонів мають лише дві або три "вільні" кнопки, які можна використовувати як гарячі клавіші. Однак у Traditional T9 набагато більше функцій, тому просто не вистачає місця для всіх них на клавіатурі. Палета команд вирішує цю проблему, дозволяючи викликати додаткові функції (або команди) за допомогою комбінацій клавіш.

Нижче наведено список можливих команд:
- **Відкрити екран налаштувань (комбінація за замовчуванням: утримання ✱, клавіша 1).** Те ж саме, що натискання [Відкрити налаштування](#клавіша-відкрити-налаштування).
- **Додати слово (комбінація за замовчуванням: утримання ✱, клавіша 2).** Те ж саме, що натискання [Додати слово](#клавіша-додати-слово).
- **Голосове введення (комбінація за замовчуванням: утримання ✱, клавіша 3).** Те ж саме, що натискання [Голосове введення](#клавіша-голосове-введення).
- **Скасувати (комбінація за замовчуванням: утримання ✱, клавіша 4).** Те ж саме, що натискання [Клавіша Скасування](#клавіша-скасування).
- **Інструменти буфера обміну (комбінація за замовчуванням: утримання ✱, клавіша 5).** Те ж саме, що натискання [Інструменти буфера обміну](#клавіша-інструменти-буфера-обміну).
- **Повторити (комбінація за замовчуванням: утримання ✱, клавіша 6).** Те ж саме, що натискання [Клавіша Повтору](#клавіша-повтору).
- **Вибір іншої клавіатури (комбінація за замовчуванням: утримання ✱, клавіша 8).** Те ж саме, що натискання [Вибрати клавіатуру](#клавіша-вибрати-клавіатуру).

_Ця клавіша не працює, коли Розкладка екрана встановлена на "Віртуальна клавіатура", оскільки всі клавіші для всіх можливих функцій вже доступні на екрані._

## Голосове введення
Функція голосового введення дозволяє перетворювати мову на текст, подібно до Gboard. Як і всі інші клавіатури, Traditional T9 самостійно не виконує розпізнавання мовлення; замість цього воно звертається до системи телефону.

_Кнопка голосового введення прихована на пристроях, які не підтримують цю функцію._

### Пристрої з Google
На пристроях з Google Services TT9 використовує інфраструктуру Google для перетворення голосу на текст. У Android 12 або нижче для цього потрібне з’єднання з Wi-Fi або ввімкнені мобільні дані. У Android 13 або вище TT9 може виконувати розпізнавання мовлення як онлайн, так і офлайн, використовуючи мовні пакети пристрою. Для офлайн-режиму завантажте потрібні мови з: Налаштування Android → Система → Розпізнавання на пристрої → Додати мову.

_Мовні пакети, встановлені для Google Voice, інших голосових помічників або клавіатур, не гарантують сумісність з Traditional T9. Рекомендується встановлювати глобальні пакети через екран "Розпізнавання на пристрої"._

### Пристрої без Google
На пристроях без Google, якщо є додаток голосового помічника або вбудована клавіатура підтримує голосове введення, буде використано доступну опцію. Але цей метод значно слабший за Google: не працює у шумному середовищі та зазвичай розпізнає лише прості фрази, як-от "відкрити календар" або "увімкнути музику".

### Інші пристрої
Інші телефони без Google зазвичай не підтримують голосове введення. Китайські телефони не мають можливостей розпізнавання мовлення через політику безпеки Китаю. На таких пристроях ви можете спробувати активувати підтримку голосового введення, встановивши додаток Google (назва пакета: "com.google.android.googlequicksearchbox"). Або спробуйте Google Go: "com.google.android.apps.searchlite".

## Екранна клавіатура
На телефонах лише з сенсорним екраном доступна повнофункціональна екранна клавіатура, яка вмикається автоматично. Якщо з якоїсь причини ваш телефон не був розпізнаний як пристрій із сенсорним екраном, увімкніть клавіатуру, перейшовши в Налаштування → Зовнішній вигляд → Екранна розкладка та вибравши "Віртуальна клавіатура".

Якщо у вас є як сенсорний екран, так і апаратна клавіатура, і ви хочете мати більше місця на екрані, вимкніть програмні клавіші в Налаштуваннях → Зовнішній вигляд.

Також рекомендується вимкнути спеціальну функцію кнопки "Назад", яка працює як "Backspace". Вона корисна лише для апаратної клавіатури. Це зазвичай відбувається автоматично, але якщо ні, перейдіть до Налаштування → Клавіатура → Вибрати гарячі клавіші → Клавіша Backspace, а потім виберіть опцію "--".

### Огляд віртуальних клавіш
Екранна клавіатура працює так само, як цифрова клавіатура телефону з фізичними клавішами. Якщо клавіша виконує лише одну функцію, вона має одну мітку (або значок), що вказує на цю функцію. Якщо клавіша виконує другу функцію при натисканні та утриманні, вона матиме дві мітки (або значки).

Нижче описані клавіші з більше ніж однією функцією.

#### Права клавіша F2 (друга клавіша зверху в правому ряду)
_Лише в режимі передбачення._

- **Натиснути:** Фільтрує список пропозицій. Як працює фільтрація слів, див. [вище](#клавіша-фільтрації-пропозицій-за-замовчуванням-d-pad-up).
- **Утримувати:** Очищає фільтр, якщо він активний.

#### Права клавіша F3 (третя клавіша зверху в правому ряду)
- **Натиснути:** Відкриває параметри копіювання, вставки та редагування тексту.
- **Утримувати:** Активує голосове введення.

#### Ліва клавіша F4 (нижня ліва клавіша)
- **Натиснути:** Перемикає режими введення (АБВ → Прогнозування → 123).
- **Утримувати:** Змінити мову введення, якщо в налаштуваннях увімкнено кілька мов.
- **Горизонтальний свайп:** Перемикається на останню використану клавіатуру, відмінну від TT9.
- **Вертикальний свайп:** Відкриває діалог зміни клавіатури Android, де можна вибрати серед усіх встановлених клавіатур.

_На клавіші з’явиться невеликий значок глобуса, якщо ви активували більше однієї мови в Налаштуваннях → Мови. Значок вказує, що мову можна змінити, утримуючи клавішу._

### Зміна розміру панелі клавіатури під час введення
Іноді екранна клавіатура може займати забагато місця, через що не видно, що ви вводите або елементи додатка. Якщо це так, можна змінити розмір, утримуючи та перетягуючи клавішу Налаштування/Палети команд або переміщуючи Рядок стану (де відображається поточна мова або режим введення). Коли висота стає занадто малою, розкладка автоматично змінюється на "Функціональні клавіші" або "Тільки список пропозицій". Відповідно, при збільшенні розміру розкладка змінюється на "Віртуальна клавіатура". Також можна двічі натиснути на рядок стану для миттєвого згортання чи розгортання.

_Зміна розміру Traditional T9 також змінює розмір поточного додатка. Це є обчислювально важким процесом, тому може викликати мерехтіння або пригальмовування на багатьох телефонах, навіть на потужніших._

### Зміна висоти клавіш
Можна також змінити висоту клавіш на екрані. Для цього перейдіть у Налаштування → Зовнішній вигляд → Висота клавіш на екрані та налаштуйте її за бажанням.

Значення за замовчуванням 100% забезпечує гарний баланс між розміром кнопок і зайнятим простором на екрані. Однак, якщо у вас великі пальці, можливо, ви захочете трохи збільшити значення, а якщо використовуєте TT9 на більшому екрані, наприклад, на планшеті, можна зменшити.

_Якщо вільного простору на екрані обмаль, TT9 автоматично зменшить висоту, щоб залишити достатньо місця для поточного додатка, навіть якщо це не передбачено в налаштуваннях._

## Інструменти буфера обміну
На панелі інструментів буфера обміну можна вибирати, вирізати, копіювати та вставляти текст, як на клавіатурі комп’ютера. Щоб вийти з панелі, можна натиснути клавішу "✱" або клавішу "Назад" (крім веббраузерів, Spotify та деяких інших додатків). Також можна натиснути будь-яку буквну клавішу на екранній клавіатурі.

Нижче наведено список можливих команд для роботи з текстом:
1. Вибрати попередній символ (як Shift+Ліворуч на клавіатурі комп’ютера)
2. Скасувати вибір
3. Вибрати наступний символ (як Shift+Праворуч)
4. Вибрати попереднє слово (як Ctrl+Shift+Ліворуч)
5. Вибрати все
6. Вибрати наступне слово (як Ctrl+Shift+Праворуч)
7. Вирізати
8. Копіювати
9. Вставити

Для зручнішого редагування клавіші Backspace, пробіл і OK також активні.

## Екран налаштувань
На екрані налаштувань можна вибрати мови для введення, налаштувати гарячі клавіші клавіатури, змінити зовнішній вигляд застосунку або покращити сумісність із телефоном.

### Як відкрити налаштування?

#### Спосіб 1
Натисніть на значок запуску Traditional T9.

#### Спосіб 2 (за допомогою сенсорного екрана)
- Натисніть на текстове або числове поле, щоб увімкнути TT9.
- Використовуйте кнопку з зображенням шестерні на екрані.

#### Спосіб 3 (за допомогою апаратної клавіатури)
- Почніть вводити в текстовому або числовому полі, щоб увімкнути TT9.
- Відкрийте список команд за допомогою кнопки інструментів на екрані або натиснувши призначену гарячу клавішу [За замовчуванням: утримання ✱].
- Натисніть клавішу 2.

### Навігація в Налаштуваннях
Якщо ваш пристрій має апаратну клавіатуру, є два способи навігації в налаштуваннях.

1. Використовуйте клавіші Вгору/Вниз для прокручування та ОК для відкриття або активації параметра.
2. Натискайте клавіші 1-9 для вибору відповідного параметра, а для відкриття/активації двічі натискайте на них. Двічі натиснути можна незалежно від того, де ви перебуваєте на екрані. Наприклад, навіть якщо ви на початку, подвійне натискання клавіші 3 активує третій параметр. Нарешті, клавіша 0 є зручним ярликом для прокрутки до кінця, але не відкриває останній параметр.

### Мовні налаштування

#### Завантаження словника
Після ввімкнення однієї або декількох нових мов необхідно завантажити відповідні словники для Прогнозуючого режиму. Після завантаження словник залишатиметься там, доки ви не скористаєтеся одним із параметрів "видалити". Це означає, що можна вмикати та вимикати мови без необхідності перезавантаження їхніх словників щоразу. Завантажте лише один раз, лише вперше.

Це також означає, що якщо вам потрібно почати використовувати мову X, можна безпечно вимкнути всі інші мови, завантажити лише словник X (і заощадити час!), а потім знову ввімкнути всі мови, які ви використовували раніше.

Майте на увазі, що перезавантаження словника скидає популярність пропозицій до заводських налаштувань. Однак не варто хвилюватися, зазвичай це майже не вплине на порядок пропозицій, якщо ви не використовуєте часто незвичайні слова.

#### Автоматичне завантаження словника

Якщо ви пропустили або забули завантажити словник у Налаштуваннях, це відбудеться автоматично, коли ви перейдете в додаток, де можна вводити текст, і увімкнете Прогнозуючий режим. Вас буде попереджено про необхідність зачекати до завершення, після чого можна розпочинати введення.

Якщо ви видалите один або кілька словників, вони НЕ завантажаться автоматично. Потрібно зробити це вручну. Автоматично завантажаться лише словники для нововвімкнених мов.

#### Видалення словника
Якщо ви припинили використовувати мови X або Y, можна їх вимкнути, а також скористатися параметром "Видалити невибране", щоб звільнити місце.

Щоб видалити все незалежно від вибору, використовуйте параметр "Видалити все".

У всіх випадках ваші додані слова будуть збережені й відновлені, щойно ви перезавантажите відповідний словник.

#### Додані слова
Опція «Експорт» дозволяє створити файл CSV з усіма доданими словами для всіх мов. Потім цей CSV-файл можна використати для покращення Traditional T9! Перейдіть на GitHub і поділіться словами в [новому запиті](https://github.com/sspanak/tt9/issues) або [pull request](https://github.com/sspanak/tt9/pulls). Після перевірки та затвердження слова буде включено до наступної версії.

З опцією "Імпорт" можна імпортувати раніше експортований CSV-файл. Однак існують певні обмеження:
- Можна імпортувати лише слова, що складаються з літер. Апострофи, тире, інші знаки пунктуації або спеціальні символи заборонені.
- Емодзі не дозволені.
- Один CSV-файл може містити максимум 250 слів.
- Можна імпортувати до 1000 слів, тобто максимум 4 файли по 250 слів. Понад цю межу ви все ще можете додавати слова під час введення.

Використовуючи "Видалити", можна знайти та видалити неправильно написані слова або ті, які ви не хочете бачити у словнику.

### Налаштування сумісності
Для кількох додатків або пристроїв можна ввімкнути спеціальні параметри, які допоможуть Traditional T9 працювати краще з ними. Вони знаходяться в кінці кожного екрана налаштувань, у розділі Сумісності.

#### Альтернативний метод прокрутки пропозицій
_У: Налаштування → Зовнішній вигляд._

На деяких пристроях у Прогнозуючому режимі може виникати проблема, коли не вдається прокрутити список до кінця, або потрібно кілька разів прокручувати назад і вперед, щоб з’явилася остання пропозиція. Проблема іноді виникає на Android 9 або раніше. Увімкніть цей параметр, якщо ви стикаєтеся з цією проблемою.

#### Завжди поверх інших
_У: Налаштування → Зовнішній вигляд._

На деяких телефонах, особливо Sonim XP3plus (XP3900), Traditional T9 може не з’являтися, коли ви починаєте вводити текст, або частково перекривається м’якими клавішами. В інших випадках навколо нього можуть бути білі смуги. Проблема може виникнути в одному конкретному застосунку або у всіх. Щоб уникнути цього, увімкніть опцію «Завжди поверх інших».

#### Перерахувати нижній відступ
_У: Налаштування → Зовнішній вигляд._

Android 15 запровадив функцію "від краю до краю", яка іноді може спричинити появу зайвого порожнього простору під клавішами клавіатури. Увімкніть цю опцію, щоб нижній відступ обчислювався для кожного застосунку й видалявся, якщо він не потрібен.

На пристроях Samsung Galaxy з Android 15 або після оновлення до нього ця опція може спричинити накладання TT9 на системну панель навігації, особливо якщо вона налаштована на 2 або 3 кнопки. Якщо це станеться, вимкніть опцію, щоб залишити достатньо місця для панелі навігації.

#### Захист від повторення натискань
_У: Налаштування → Клавіатура._

Телефони CAT S22 Flip і Qin F21 відомі своїми неякісними клавіатурами, які швидко зношуються і починають реєструвати кілька натискань при одному дотику. Ви можете помітити це під час введення тексту або навігації по меню телефону.

Для телефонів CAT рекомендоване значення — 50–75 мс. Для Qin F21 спробуйте з 20–30 мс. Якщо проблема не зникає, збільшіть значення трохи, але намагайтеся тримати його якомога нижчим.

_**Примітка:** Чим вище встановлене значення, тим повільніше доведеться вводити текст. TT9 ігноруватиме дуже швидкі натискання клавіш._

_**Примітка 2:** Крім того, на телефонах Qin також можуть виникати проблеми з виявленням тривалих натискань. На жаль, у цьому випадку нічого не можна зробити._

#### Показувати текст під час введення
_У: Налаштування → Клавіатура._

Якщо у вас виникають труднощі з введенням тексту у Deezer або Smouldering Durtles, тому що пропозиції швидко зникають, перш ніж ви їх побачите, вимкніть цю опцію. Це змусить поточне слово залишатися прихованим, поки ви не натиснете OK або Пробіл, або не торкнетеся списку пропозицій.

Проблема виникає через те, що Deezer і Smouldering Durtles іноді змінюють введений вами текст, що спричиняє некоректну роботу TT9.

#### Панелі стікерів та емодзі в Telegram/Snapchat не відкриваються
Це трапляється, якщо ви використовуєте один із малих розмірів макетів. Наразі немає постійного вирішення, але ви можете використати наступний обхідний шлях:
- Перейдіть до Налаштування → Зовнішній вигляд і увімкніть Екранну цифрову клавіатуру.
- Поверніться до чату та натисніть кнопку емодзі або стікерів. Тепер вони повинні з’явитися.
- Після цього ви можете повернутися до налаштувань і вимкнути екранну цифрову клавіатуру. Панелі емодзі та стікерів залишатимуться доступними, поки ви не перезапустите застосунок або телефон.

#### Traditional T9 не з’являється відразу в деяких програмах
Якщо ви відкрили програму, де можна вводити текст, але TT9 не з’являється автоматично, просто почніть вводити текст, і він з’явиться. Альтернативно, натискання гарячих клавіш для зміни [режиму вводу](#клавіша-наступний-режим-введення-за-замовчуванням-натискання) або [мови](#клавіша-наступна-мова-за-замовчуванням-утримання) також може змусити TT9 з’явитися, коли він прихований.

На деяких пристроях TT9 може залишатися невидимим, незалежно від того, що ви робите. У таких випадках вам потрібно увімкнути [Завжди поверх інших](#завжди-поверх-інших).

**Довге пояснення.** Причина цієї проблеми в тому, що Android в першу чергу розроблений для пристроїв з сенсорним екраном. Тому він очікує, що ви доторкнетеся до текстового/цифрового поля, щоб показати клавіатуру. Можливо змусити TT9 з’являтися без цього підтвердження, але в деяких випадках Android може забути приховати його, коли потрібно. Наприклад, він може залишатися видимим після набору телефонного номера або після відправлення тексту в полі пошуку.

З цієї причини, щоб дотримуватися очікуваних стандартів Android, контроль залишається за вами. Просто натисніть клавішу, щоб «доторкнутися» до екрана та продовжити введення тексту.

#### На Qin F21 Pro утримування клавіші 2 або 8 підвищує або знижує гучність замість введення цифри
Щоб зменшити цю проблему, перейдіть до Налаштування → Зовнішній вигляд і увімкніть «Значок статусу». TT9 має автоматично виявити Qin F21 і ввімкнути налаштування, але якщо автоматичне виявлення не спрацює або ви вимкнули значок з якоїсь причини, потрібно залишити його увімкненим, щоб усі клавіші працювали належним чином.

**Довге пояснення.** Qin F21 Pro (і можливо F22) має програму для швидких клавіш, яка дозволяє призначати функції підвищення та зниження гучності цифровим клавішам. За замовчуванням диспетчер швидких клавіш увімкнений, і утримування клавіші 2 збільшує гучність, а клавіші 8 — зменшує її. Проте, коли немає значка статусу, диспетчер вважає, що клавіатура неактивна, і регулює гучність замість того, щоб дозволити Traditional T9 обробляти клавішу та вводити цифру. Тож увімкнення значка просто обходить диспетчер швидких клавіш, і все працює належним чином.

#### Загальні проблеми на телефонах Xiaomi
Xiaomi додала кілька нестандартних дозволів на своїх телефонах, що перешкоджає нормальній роботі віртуальної клавіатури Traditional T9 на екрані. Точніше, клавіші «Відкрити Налаштування» та «Додати слово» можуть не виконувати свої функції. Щоб це виправити, потрібно надати дозволи «Відображення спливаючого вікна» та «Відображення спливаючого вікна у фоновому режимі» для TT9 у налаштуваннях телефону. [Цей посібник](https://parental-control.flashget.com/how-to-enable-display-pop-up-windows-while-running-in-the-background-on-flashget-kids-on-xiaomi) для іншої програми пояснює, як це зробити.

Також дуже рекомендується надати дозвіл «Постійне сповіщення». Це схоже на дозвіл «Сповіщення», введений в Android 13. Дивіться [вище](#примітки-для-android-13-або-новішої-версії) для отримання додаткової інформації, чому це потрібно.

_Проблеми з Xiaomi були обговорені в [цьому випуску на GitHub](https://github.com/sspanak/tt9/issues/490)._

#### Голосове введення займає дуже багато часу для зупинки
Це [відоме питання](https://issuetracker.google.com/issues/158198432) в Android 10, яке Google так і не виправив. Неможливо виправити це на боці TT9. Щоб зупинити операцію голосового введення, зберігайте тишу кілька секунд. Android автоматично вимикає мікрофон, коли не може виявити жодної мови.

## Часті запитання

#### Чому ви не додаєте мову X?
Я із задоволенням би додав, але мені потрібна ваша допомога. Підтримувати понад 40 мов самостійно неможливо. Оскільки я не володію вашою мовою, мені складно знаходити надійні ресурси в інтернеті — і саме тут ви можете допомогти.
Насправді понад 90% мов було додано за участі або за допомогою ентузіастів-носіїв мови.

Щоб додати нову мову, мені потрібен список слів із перевіреним правописом, бажано з офіційного чи академічного джерела (наприклад, «Великий словник мови X»). Такі списки забезпечують найвищу якість підказок під час набору тексту.

Якщо такого словника немає, можна надати будь-який безкоштовний список слів для завантаження. Зазвичай достатньо 300–500 тисяч слів, але якщо в мові багато відмін і форм (час, рід, число тощо), може знадобитися до мільйона.

#### У мові XYZ є помилки або відсутні слова. Чому ви їх не виправите?
Як уже сказано вище, я не розмовляю вашою мовою і можу навіть не знати про ці помилки. Але з вашою допомогою ми можемо їх виправити й зробити словник кращим для всіх.

#### Чи можете ви додати функцію X?
Ні.

У кожного свої вподобання. Дехто хоче більші клавіші, дехто — інший порядок розташування, інші хочуть клавішу швидкого введення для ".com", а дехто сумує за своїм старим телефоном або клавіатурою. Але, будь ласка, зрозумійте, що я працюю над цим проєктом добровільно у свій вільний час. Виконати тисячі різних побажань, багато з яких суперечать одне одному, просто неможливо.

Генрі Форд колись сказав: "Клієнт може отримати будь-який колір, який забажає, якщо цей колір чорний." Так само Traditional T9 — це простий, ефективний і безкоштовний інструмент, який ви отримуєте таким, яким він є.

#### Чому б вам не зробити його схожим на Sony Ericsson, Xperia, Nokia C2, Samsung або іншу програмну клавіатуру?
Ні.

Traditional T9 не призначений для того, щоб бути заміною або копією інших клавіатур. Він має унікальний дизайн, натхненний переважно Nokia 3310 і 6303i. І хоча він передає відчуття класичних телефонів, він не намагається бути точною копією будь-якого пристрою.

#### Вам слід скопіювати Touchpal, адже це найкраща клавіатура у світі!
Ні, не слід. Дивіться попередні пункти.

Колись, у 2015 році, Touchpal дійсно був однією з найкращих клавіатур, бо не мав реальних конкурентів. Але з того часу ситуація змінилася. Ось порівняння Traditional T9 і Touchpal:

_**Traditional T9**_
- Поважає вашу конфіденційність.
- Не містить реклами та є повністю безкоштовним.
- Підтримує широкий спектр пристроїв: кнопкові телефони, телевізори з апаратними клавіатурами, а також смартфони та планшети, що працюють лише з сенсорним екраном.
- Пропонує правильне 12-кнопкове розташування T9 для кожної мови.
- Надає покращені пропозиції слів. Наприклад, якщо ви намагаєтесь ввести текстонім (textonym) "go in", клавіатура навчиться не пропонувати "go go" або "in in", а саме ту фразу, яку ви мали на увазі.
- Все, що ви вводите, залишається на вашому телефоні. Жодна інформація нікуди не надсилається.
- Є відкритим вихідним кодом, що дозволяє вам переглядати весь вихідний код і словники, допомагати у вдосконаленні проєкту (багато користувачів уже допомогли з виправленням помилок і додаванням нових мов та перекладів) або навіть створювати власну модифікацію відповідно до ваших вподобань.
- Має чистий і добре читаємий дизайн, який гармонійно вписується в систему. Тут немає зайвих елементів, які відволікають від процесу введення тексту.
- Повільне завантаження словника.

_**Touchpal**_
- Агресивно вимагає доступу до всього вашого пристрою та контактів; створює випадкові файли в системі; зрештою, його видалили з Play Store, бо він поводився як вірус.
- Наповнений рекламою.
- Підтримує лише пристрої з сенсорним екраном.
- Не є справжньою T9-клавіатурою. Пропонує T9-розкладку лише для деяких мов. Крім того, деякі розкладки неправильні (наприклад, у болгарській мові бракує літери, а деякі літери переплутані між клавішами 8 і 9).
- При введенні текстонімів один за одним пропонує лише останнє вибране слово. Наприклад, якщо ви намагаєтеся ввести "go in", клавіатура покаже або "go go", або "in in".
- Хмарні підказки можуть покращити точність, але для цього вам і всім іншим користувачам потрібно надсилати весь введений текст на сервери Touchpal для обробки.
- Закритий вихідний код. Немає можливості дізнатися, що відбувається у фоновому режимі.
- Містить безліч тем, кольорів, GIF-анімацій та інших відволікаючих елементів, які не стосуються введення тексту.
- Швидке завантаження словника. У цьому пункті Touchpal перемагає.

Якщо ви не погоджуєтеся або хочете висловити свою думку, приєднуйтеся до [відкритого обговорення](https://github.com/sspanak/tt9/issues/647) на GitHub. Просто пам’ятайте про повагу до інших користувачів. Публікація ненависті не буде толеруватися.

#### Android попередив мене, що клавіатура може збирати мої персональні дані, включно з номерами банківських карток і паролями
Це стандартне попередження Android, яке з’являється під час встановлення та активації будь-якої клавіатури, а не лише Traditional T9. Можете бути певні, що всі введені дані залишаються на вашому пристрої. Механізм введення повністю відкритий; ви можете переглянути його код на GitHub та переконатися, що ваша конфіденційність надійно захищена.

_Якщо у вас усе ж залишилися занепокоєння, будь ласка, ознайомтеся з Політикою конфіденційності застосунку._

#### Мій банківський застосунок не приймає Traditional T9
Це не є проблемою TT9. Банки часто обмежують використання нестандартних або відкритих клавіатур, оскільки не бажають ризикувати та припускають, що вони можуть бути ненадійними. Деякі навіть пропонують власні клавіатури, блокуючи стандартну клавіатуру Google — Gboard. На жаль, у такому випадку єдиним варіантом є перехід на стандартну клавіатуру пристрою.

#### Вібрація не працює (лише для пристроїв із сенсорним екраном)
Режими енергозбереження, оптимізації та функція "Не турбувати" можуть блокувати вібрацію. Переконайтеся, що жоден із цих параметрів не ввімкнено у Системних налаштуваннях вашого пристрою. На деяких пристроях можна налаштувати оптимізацію батареї для кожного додатка окремо через Налаштування системи → Додатки. Якщо ваш пристрій підтримує цю функцію, вимкніть оптимізацію для TT9.

Ще однією причиною, через яку вібрація може не працювати, є її вимкнення на рівні системи. Перевірте, чи є у вашому пристрої опції "Вібрація при торканні" або "Вібрація при натисканні клавіш" у Налаштування системи → Спеціальні можливості, та активуйте їх. Пристрої Xiaomi та OnePlus дозволяють ще більш детально налаштовувати вібрацію. Переконайтеся, що всі необхідні параметри увімкнені.

Зрештою, вібрація може ненадійно працювати на деяких пристроях. Для її виправлення знадобляться додаткові дозволи та доступ до функцій пристрою. Проте, оскільки TT9 — це клавіатура, що перш за все зберігає конфіденційність, вона не запитуватиме таких дозволів.

#### Мені потрібно використовувати розкладку QWERTY (лише для пристроїв із сенсорним екраном)
Traditional T9 — це клавіатура T9, і, як така, вона не має розкладки на кшталт QWERTY.

Якщо ви ще навчаєтеся користуватися T9 і час від часу потрібно повертатися до QWERTY, або ви вважаєте більш зручним вводити нові слова за допомогою QWERTY, проведіть пальцем угору по лівій клавіші F4, щоб перейти до іншої клавіатури. Дивіться [огляд віртуальних клавіш](#огляд-віртуальних-клавіш) для отримання додаткової інформації.

Більшість інших клавіатур дозволяють повернутися до Traditional T9, утримуючи пробіл або клавішу «зміни мови». Перевірте відповідний посібник або інструкцію для отримання додаткової інформації.

#### Я не можу змінити мову на сенсорному телефоні
Спочатку переконайтеся, що ви активували всі потрібні мови в Налаштуваннях → Мови. Потім утримуйте [ліву клавішу F4](#ліва-клавіша-f4-нижня-ліва-клавіша), щоб змінити мову.

#### Я не можу додати скорочення, такі як "I've" чи "don't", до словника
Усі скорочення для всіх мов уже доступні як окремі слова, тому вам не потрібно нічого додавати. Це забезпечує максимальну гнучкість — ви можете комбінувати будь-яке слово з будь-яким скороченням і значно економити місце для зберігання.

Наприклад, ви можете набрати 've, натиснувши: 183; або 'll, використовуючи: 155. Це означає: "I'll" = 4155 і "we've" = 93183. Також можна набрати "google.com", натиснувши: 466453 (google) 1266 (.com).

Складніший приклад французькою: "Qu'est-ce que c'est" = 781 (qu'), 378123 (est-ce), 783 (que), 21378 (c'est).

_Винятки з правила — це "can't" та "don't" в англійській мові. Тут 't не є окремим словом, але ви все одно можете набрати їх, як описано вище._