# Traditional T9
Этот мануал объясняет, как настроить и использовать Традиционный T9 в различных сценариях. Для инструкций по установке и информации о версиях "lite" и "full", пожалуйста, обратитесь к [Руководству по установке](https://github.com/sspanak/tt9/blob/master/docs/installation.md) на GitHub. Наконец, вы можете ознакомиться с [главной страницей репозитория](https://github.com/sspanak/tt9), где содержится весь исходный код, руководство для разработчиков, политика конфиденциальности и дополнительная документация.

## Начальная настройка
После установки вам нужно сначала включить Традиционный T9 как клавиатуру Android. Для этого нажмите на значок запуска. Если необходимо предпринять какие-либо действия, все опции, кроме Начальной Настройки, будут отключены, и появится надпись: "TT9 отключен". Перейдите в Начальную Настройку и включите его.

_Если вы не видите значок сразу после установки, перезапустите телефон, и он должен появиться. Это связано с тем, что Android пытается сэкономить заряд батареи, не обновляя список недавно установленных приложений._

### Использование на телефоне только с сенсорным экраном
На устройствах с сенсорным экраном также настоятельно рекомендуется отключить системную проверку орфографии. Она не может быть использована при наборе с помощью цифровых клавиш, поэтому отключение сэкономит заряд батареи.

Еще одна проблема заключается в том, что может появляться сбивающий с толку диалоговое окно "Добавить слово", которое добавляет слова в словарь системной клавиатуры (обычно это Gboard), а не в словарь Традиционного T9. Опять же, чтобы избежать таких ситуаций, необходимо отключить системную проверку орфографии.

Если вам нужно выполнить этот шаг, пункт "Системная проверка орфографии" на экране Начальной Настройки будет активен. Нажмите на него, чтобы отключить системный компонент. Если такого пункта нет, то вам больше ничего не нужно делать.

Когда настройка завершена, ознакомьтесь с разделом [Экранная клавиатура](#экранная-клавиатура) для получения дополнительных советов и трюков.

### Включение режима Предсказания
Режим Предсказания требует загрузки языкового словаря для предложения слов. Вы можете включать и загружать словари на экране Настроек → [Языки](#языковые-настройки). В случае, если вы забыли загрузить какой-либо словарь, Традиционный T9 сделает это автоматически, когда вы начнете набирать текст. Более подробную информацию смотрите [ниже](#языковые-настройки).

#### Примечания для слабых телефонов
Загрузка словарей может перегружать слабые телефоны. При использовании версии TT9 "lite" это может привести к тому, что Android прервёт операцию. Если загрузка занимает больше 30 секунд, подключите зарядное устройство или убедитесь, что экран остаётся включённым во время загрузки.

Вы можете избежать этого, используя вместо этого версию "full".

#### Примечания для Android 13 или выше
По умолчанию уведомления для недавно установленных приложений отключены. Рекомендуется их включить. Таким образом, вы получите уведомление, когда будут обновления словарей, и как только вы решите их установить, TT9 покажет прогресс загрузки. Новые обновления выпускаются не чаще одного раза в месяц, поэтому не беспокойтесь о чрезмерном количестве уведомлений.

Вы можете включить уведомления, перейдя в Настройки → Языки и включив Уведомления о словарях.

_Если вы решите оставить уведомления отключёнными, TT9 продолжит работать без проблем, но вам придётся управлять словарями вручную._

## Горячие клавиши

Все горячие клавиши можно переназначить или отключить в Настройках → Клавиатура → Выбрать Горячие Клавиши.

### Клавиши набора

#### Клавиша Предыдущего предложения (По умолчанию: Влево на D-pad):
Выбрать предыдущее слово или предложение буквы.

#### Клавиша Следующего предложения (По умолчанию: Вправо на D-pad):
Выбрать следующее слово или предложение буквы.

#### Клавиша Фильтра предложений (По умолчанию: Вверх на D-pad):
_Только в режиме Предсказания._

- **Однократное нажатие**: Отфильтровать список предложений, оставив только те, что начинаются с текущего слова. Не имеет значения, является ли оно полным или нет. Например, наберите "remin" и нажмите Фильтр. Будут оставлены все слова, начинающиеся на "remin": "remin", "remind", "reminds", "reminded", "reminding" и так далее.
- **Двойное нажатие**: Расширить фильтр до полного предложения. Например, наберите "remin" и дважды нажмите Фильтр. Сначала будет отфильтровано по "remin", затем фильтр расширится до "remind". Вы можете продолжать расширять фильтр, пока не достигнете самого длинного слова в словаре.

Фильтрация также полезна при наборе неизвестных слов. Допустим, вы хотите набрать "Anakin", которого нет в словаре. Начните с "A", затем нажмите Фильтр, чтобы скрыть "B" и "C". Теперь нажмите клавишу 6. Поскольку фильтр включён, в дополнение к реальным словам из словаря будут предложены все возможные комбинации для 1+6: "A..." + "m", "n", "o". Выберите "n" и нажмите Фильтр, чтобы подтвердить свой выбор и получить "An". Теперь нажатие клавиши 2 даст "An..." + "a", "b" и "c". Выберите "a" и продолжайте, пока не наберёте "Anakin".

Когда фильтр включён, базовый текст будет выделен жирным курсивом.

#### Клавиша Сброса фильтра (По умолчанию: Вниз на D-pad):
_Только в режиме Предсказания._

Очистить фильтр предложений, если он применён.

#### Центральная клавиша D-pad (OK или ENTER):
- Когда отображаются предложения, ввести текущее выбранное предложение.
- В противном случае, выполнить действие по умолчанию для текущего приложения (например, отправить сообщение, перейти по URL или просто ввести новую строку).

_**Примечание:** Каждое приложение само решает, что делать при нажатии OK, и TT9 не контролирует это._

_**Примечание 2:** Чтобы отправлять сообщения с помощью OK в приложениях для обмена сообщениями, вам нужно включить настройку "Отправлять с помощью ENTER" или аналогичную по названию. Если в приложении такой настройки нет, скорее всего, оно не поддерживает отправку сообщений таким образом. В этом случае используйте приложение KeyMapper из [Play Store](https://play.google.com/store/apps/details?id=io.github.sds100.keymapper) или из [F-droid](https://f-droid.org/packages/io.github.sds100.keymapper/). KeyMapper может обнаруживать чат-приложения и симулировать касание кнопки отправки сообщения при нажатии или удержании аппаратной кнопки. Ознакомьтесь с [кратким руководством по началу работы](https://docs.keymapper.club/quick-start/) для получения дополнительной информации._

#### Клавиша 0:
- **В режиме 123:**
  - **Нажатие:** ввести "0".
  - **Удержание:** ввести специальные/математические символы.
- **В режиме ABC:**
  - **Нажатие:** ввести пробел, новую строку или специальные/математические символы.
  - **Удержание:** ввести "0".
- **В режиме Предсказания:**
  - **Нажатие:** ввести пробел, новую строку или специальные/математические символы.
  - **Двойное нажатие:** ввести символ, назначенный в настройках режима Предсказания (по умолчанию: ".").
  - **Удержание:** ввести "0".
- **В режиме Чонджиин (Корейский):**
  - **Нажатие:** ввести "ㅇ" и "ㅁ".
  - **Удержание:** ввести пробел, новую строку, "0" или специальные/математические символы.

#### Клавиша 1:
- **В режиме 123:**
  - **Нажатие:** ввести "1".
  - **Удержание:** ввести знаки препинания.
- **В режиме ABC:**
  - **Нажатие:** ввести знаки препинания.
  - **Удержание:** ввести "1".
- **В режиме Предсказания:**
  - **Нажатие:** ввести знаки препинания.
  - **Многократное нажатие:** ввести эмодзи.
  - **Удержание:** ввести "1".
- **В режиме Чонджиин (Корейский):**
  - **Нажатие:** ввести гласную "ㅣ".
  - **Удержание:** ввести знаки препинания.
  - **Удержание, затем нажатие:** ввести эмодзи.

#### Клавиши 2-9:
- **В режиме 123:** введите соответствующую цифру
- **В режимах ABC и Предсказания:** введите букву или удерживайте для ввода соответствующей цифры.

### Функциональные клавиши

#### Клавиша добавления слова:
Добавляет новое слово в словарь текущего языка.

#### Клавиша удаления (Назад, Del или Backspace):
Просто удаляет текст.

Если у вашего телефона есть специальная клавиша «Del» или «Clear», вам не нужно настраивать ничего в Настройках, если только вы не хотите иметь ещё одну клавишу Backspace. В этом случае пустая опция: «--» будет выбрана автоматически.

На телефонах с объединённой клавишей «Del»/«Назад», эта клавиша будет выбрана автоматически. Однако вы можете назначить функцию «Backspace» другой клавише, чтобы клавиша «Назад» только возвращала назад.

_**Примечание:** Использование клавиши «Назад» как Backspace не работает во всех приложениях, особенно в Firefox, Spotify и Termux. Эти приложения могут полностью контролировать клавишу и переназначать её функцию по своему усмотрению. К сожалению, ничего с этим нельзя сделать, так как клавиша «Назад» играет особую роль в Android, и её использование ограничено системой._

_**Примечание 2:** Удерживание клавиши «Назад» всегда вызывает действие по умолчанию системы (например, показывает список запущенных приложений)._

_В этих случаях можно назначить другую клавишу (все остальные клавиши полностью функциональны) или использовать экранную клавишу Backspace._

#### Клавиша смены режима ввода (по умолчанию: нажмите #):
Переключение режимов ввода (АБВ → Предиктивный → 123).

_Предсказание недоступно в полях пароля._

_В полях, где можно вводить только числа, смена режима невозможна. В таких случаях клавиша возвращается к своей стандартной функции (т.е. ввод «#»)._

#### Клавиша инструменты буфера обмена:
Открывает панель инструментов буфера обмена, которая позволяет выделять, вырезать, копировать и вставлять текст. Закрыть панель можно, повторно нажав клавишу «✱» или, в большинстве приложений, клавишу «Назад». Подробнее см. [ниже](#инструменты-буфера-обмена).

#### Клавиша смены языка (по умолчанию: удерживайте #):
Сменить язык ввода, если в настройках включено несколько языков.

#### Клавиша выбора клавиатуры:
Открывает диалог смены клавиатуры Android, где можно выбрать любую установленную клавиатуру.

#### Клавиша Shift (по умолчанию: нажмите ✱):
- **При вводе текста:** переключает между строчными и прописными буквами.
- **При вводе спецсимволов с клавиши 0:** показывает следующую группу символов.

#### Клавиша настроек:
Открывает экран настроек. Здесь можно выбрать языки для ввода, настроить горячие клавиши клавиатуры, изменить внешний вид приложения или улучшить совместимость с вашим телефоном.

#### Клавиша Отмены:
Отменяет последнее действие. Аналогично нажатию Ctrl+Z на компьютере или Cmd+Z на Mac.

_История отмен управляется самими приложениями, а не Traditional T9. Это означает, что функция отмены может быть недоступна в некоторых приложениях._

#### Клавиша Повтора:
Повторяет последнее отменённое действие. Аналогично нажатию Ctrl+Y или Ctrl+Shift+Z на компьютере или Cmd+Y на Mac.

_Как и в случае с отменой, команда повтора может быть недоступна в некоторых приложениях._

#### Клавиша голосового ввода:
Активирует голосовой ввод на телефонах, которые его поддерживают. Подробнее см. [ниже](#голосовой-ввод).

#### Клавиша списка команд / также известна как Пульт команд / (по умолчанию: удерживайте ✱):
Отображает список всех команд (или функций).

У многих телефонов есть только две или три «свободные» клавиши, которые можно использовать как горячие клавиши. Однако в Traditional T9 доступно намного больше функций, что означает, что просто нет места для всех этих функций на клавиатуре. Пульт команд решает эту проблему, позволяя вызывать дополнительные функции (или команды) с помощью комбинаций клавиш.

Ниже приведён список возможных команд:
- **Показать экран настроек (Комбинация по умолчанию: удерживайте ✱, клавиша 1).** То же, что и нажатие [Настроек](#клавиша-настроек).
- **Добавить слово (Комбинация по умолчанию: удерживайте ✱, клавиша 2).** То же, что и нажатие [Добавить слово](#клавиша-добавления-слова).
- **Голосовой ввод (Комбинация по умолчанию: удерживайте ✱, клавиша 3).** То же, что и нажатие [Голосовой ввод](#клавиша-голосового-ввода).
- **Отменить (Комбинация по умолчанию: удерживайте ✱, клавиша 4).** То же, что и нажатие [Клавиша Отмены](#клавиша-отмены).
- **Менеджер буфера обмена (Комбинация по умолчанию: удерживайте ✱, клавиша 5).** То же, что и нажатие [Менеджер буфера обмена](#клавиша-инструменты-буфера-обмена).
- **Повторить (Комбинация по умолчанию: удерживайте ✱, клавиша 6).** То же, что и нажатие [Клавиша Повтора](#клавиша-повтора).
- **Выбрать другую клавиатуру (Комбинация по умолчанию: удерживайте ✱, клавиша 8).** То же, что и нажатие [Выбор клавиатуры](#клавиша-выбора-клавиатуры).

_Эта клавиша не выполняет никаких функций, если макет экрана установлен на «Виртуальная клавиатура», так как все клавиши для всех возможных функций уже доступны на экране._

## Голосовой ввод
Функция голосового ввода позволяет преобразовывать речь в текст, аналогично Gboard. Как и все остальные клавиатуры, Traditional T9 не выполняет распознавание речи самостоятельно; вместо этого она передаёт задачу вашему телефону.

_Кнопка голосового ввода скрыта на устройствах, которые не поддерживают эту функцию._

### Устройства с Google
На устройствах с сервисами Google TT9 использует инфраструктуру Google для преобразования речи в текст. В Android 12 и ниже необходимо подключение к Wi-Fi или включенные мобильные данные. В Android 13 и выше TT9 может выполнять распознавание речи как онлайн, так и офлайн, используя языковые пакеты устройства. Для работы в офлайн-режиме убедитесь, что вы загрузили нужные языки: Настройки Android → Система → Распознавание на устройстве → Добавить язык.

_Языковые пакеты, установленные для Google Voice, других голосовых помощников или клавиатур, не гарантированно работают с Traditional T9. Рекомендуется устанавливать глобальные пакеты через экран "Распознавание на устройстве"._

### Устройства без Google
На устройствах без Google, если есть голосовой помощник или встроенная клавиатура поддерживает голосовой ввод, будет использован доступный вариант. Однако этот метод значительно менее точен, чем у Google. Он не работает в шумной обстановке и обычно распознаёт только простые фразы, такие как «открыть календарь» или «воспроизвести музыку».

### Другие устройства
Другие телефоны без Google, как правило, не поддерживают голосовой ввод. Китайские телефоны не имеют возможности распознавания речи из-за местной политики безопасности. На таких устройствах можно попытаться включить поддержку голосового ввода, установив приложение Google (имя пакета: "com.google.android.googlequicksearchbox") или Google Go ("com.google.android.apps.searchlite").

## Экранная клавиатура
На телефонах с только сенсорным экраном доступна полностью функциональная экранная клавиатура, которая включается автоматически. Если по какой-то причине ваш телефон не был распознан как имеющий сенсорный экран, включите её, перейдя в Настройки → Внешний вид → Макет на экране и выбрав «Виртуальная цифровая клавиатура».

Если у вас есть как сенсорный экран, так и аппаратная клавиатура, и вы хотите освободить больше места на экране, отключите программные клавиши в Настройки → Внешний вид.

Также рекомендуется отключить специальное поведение клавиши «Назад», когда она работает как Backspace. Это полезно только для аппаратной клавиатуры. Обычно это происходит автоматически, но если нет, перейдите в Настройки → Клавиатура → Выбор горячих клавиш → Клавиша Backspace и выберите опцию «--».

### Обзор виртуальных клавиш
Экранная клавиатура работает так же, как цифровая клавиатура телефона с физическими клавишами. Если клавиша выполняет одну функцию, на ней будет одна метка (или значок), указывающая эту функцию. Если клавиша выполняет вторичную функцию при удерживании, на ней будут две метки (или значка).

Ниже приведено описание клавиш с более чем одной функцией.

#### Правая клавиша F2 (вторая клавиша сверху в правом ряду)
_Только в предиктивном режиме._

- **Нажать:** Фильтрует список предложений. Подробнее о фильтрации слов см. [выше](#клавиша-фильтра-предложений-по-умолчанию-вверх-на-d-pad).
- **Удерживать:** Сбрасывает фильтр, если он активен.

#### Правая клавиша F3 (третья клавиша сверху в правом ряду)
- **Нажать:** Открывает параметры копирования, вставки и редактирования текста.
- **Удерживать:** Активирует голосовой ввод.

#### Левая клавиша F4 (нижняя левая клавиша)
- **Нажать:** Переключает режимы ввода (АБВ → Предиктивный → 123).
- **Удерживать:** Сменить язык ввода, если в настройках включено несколько языков.
- **Горизонтальный свайп:** Переключается на последнюю использованную клавиатуру, кроме TT9.
- **Вертикальный свайп:** Открывает диалог выбора клавиатуры Android, где можно выбрать среди всех установленных клавиатур.

_На клавише появится небольшой значок глобуса, если вы включили более одного языка в Настройки → Языки. Значок указывает, что можно изменить язык, удерживая клавишу._

### Изменение размера панели клавиатуры во время набора текста
В некоторых случаях вы можете заметить, что Виртуальная клавиатура занимает слишком много места на экране, мешая видеть вводимый текст или элементы приложения. В этом случае вы можете изменить её размер, удерживая и перетаскивая клавишу Настройки/Пульт команд или перетаскивая строку состояния (где отображается текущий язык или режим ввода). Когда высота становится слишком маленькой, макет автоматически переключается на «Функциональные клавиши» или «Только список предложений». При увеличении высоты макет переключится на «Виртуальная клавиатура». Также можно дважды нажать на строку состояния для мгновенного минимизирования или максимизирования.

_Изменение размера Traditional T9 также изменяет размер текущего приложения. Оба процесса требуют значительных вычислительных ресурсов. Это может вызвать мерцание или задержки на многих телефонах, даже на более мощных._

### Изменение высоты клавиш
Также можно изменить высоту экранных клавиш. Для этого перейдите в Настройки → Внешний вид → Высота клавиш на экране и настройте её по своему усмотрению.

Значение по умолчанию 100% является хорошим балансом между размером кнопок и занимаемым экранным пространством. Однако, если у вас большие пальцы, вы можете немного увеличить этот параметр, а если вы используете TT9 на большом экране, например, на планшете, вы можете уменьшить его.

_Если доступное экранное пространство ограничено, TT9 проигнорирует этот параметр и автоматически уменьшит высоту, чтобы оставить достаточно места для текущего приложения._

## Инструменты буфера обмена
В панели инструментов буфера обмена можно выделять, вырезать, копировать и вставлять текст, как на клавиатуре компьютера. Чтобы выйти из панели, нажмите клавишу «✱» или клавишу «Назад» (кроме веб-браузеров, Spotify и некоторых других приложений). Также можно нажать любую буквенную клавишу на экранной клавиатуре.

Ниже приведён список возможных текстовых команд:
1. Выделить предыдущий символ (аналогично Shift+Left на компьютерной клавиатуре)
2. Снять выделение
3. Выделить следующий символ (аналогично Shift+Right)
4. Выделить предыдущее слово (аналогично Ctrl+Shift+Left)
5. Выделить всё
6. Выделить следующее слово (аналогично Ctrl+Shift+Right)
7. Вырезать
8. Копировать
9. Вставить

Для удобства редактирования клавиши Backspace, Пробел и OK также активны.

## Экран настроек
На экране настроек вы можете выбрать языки для ввода, настроить горячие клавиши клавиатуры, изменить внешний вид приложения или улучшить совместимость с вашим телефоном.

### Как получить доступ к настройкам?

#### Способ 1
Нажмите на значок приложения Traditional T9.

#### Способ 2 (с использованием сенсорного экрана)
- Нажмите на текстовое или числовое поле, чтобы активировать TT9.
- Используйте экранную кнопку шестерёнки.

#### Способ 3 (с использованием физической клавиатуры)
- Начните ввод текста или цифр в поле, чтобы активировать TT9.
- Откройте список команд, используя экранную кнопку инструментов или нажав назначенную горячую клавишу [по умолчанию: удерживайте ✱].
- Нажмите клавишу 2.

### Навигация по настройкам
Если у вас устройство с аппаратной клавиатурой, есть два способа навигации по настройкам.

1. Используйте клавиши Вверх/Вниз для прокрутки и клавишу OK для открытия или активации опции.
2. Нажмите клавиши 1-9, чтобы выбрать соответствующую опцию, и нажмите их дважды, чтобы открыть/активировать её. Двойное нажатие сработает, независимо от того, где вы находитесь на экране. Например, даже если вы находитесь вверху, двойное нажатие клавиши 3 активирует третью опцию. Наконец, клавиша 0 — это удобный ярлык для прокрутки до конца, но она не открывает последнюю опцию.

### Языковые настройки

#### Загрузка словаря
После включения одного или нескольких новых языков необходимо загрузить соответствующие словари для режима предсказания. После загрузки словарь останется в памяти до тех пор, пока вы не воспользуетесь одной из опций удаления. Это означает, что вы можете включать и отключать языки, не загружая их словари каждый раз. Делайте это только один раз, только при первом включении.

Это также означает, что если вам нужно начать использовать язык X, вы можете безопасно отключить все другие языки, загрузить только словарь X (и сэкономить время!), а затем снова включить все языки, которые использовали раньше.

Имейте в виду, что повторная загрузка словаря сбросит популярность предложений до заводских настроек. Однако беспокоиться не стоит. В большинстве случаев вы не заметите значительных изменений в порядке предложений, если не используете часто редкие слова.

#### Автоматическая загрузка словаря

Если вы пропустили или забыли загрузить словарь через экран настроек, это произойдёт автоматически позже, когда вы откроете приложение, в котором можно вводить текст, и переключитесь в режим предсказания. Вас попросят подождать, пока загрузка завершится, и затем вы сможете начать вводить текст.

Если вы удалите один или несколько словарей, они НЕ будут загружаться автоматически. Вам придётся делать это вручную. Автоматически будут загружаться только словари для вновь включённых языков.

#### Удаление словаря
Если вы перестали использовать языки X или Y, вы можете отключить их и также воспользоваться опцией «Удалить невыбранные», чтобы освободить место на устройстве.

Чтобы удалить все словари, независимо от выбора, используйте опцию «Удалить все».

Во всех случаях ваши добавленные вручную слова будут сохранены и восстановлены после повторной загрузки соответствующего словаря.

#### Добавленные слова
Опция «Экспорт» позволяет создать файл CSV со всеми добавленными словами для всех языков. Затем вы можете использовать этот файл CSV, чтобы улучшить Traditional T9! Перейдите на GitHub и поделитесь словами в [новом issue](https://github.com/sspanak/tt9/issues) или [pull request](https://github.com/sspanak/tt9/pulls). После проверки и одобрения они будут включены в следующую версию.

С помощью опции «Импорт» вы можете импортировать ранее экспортированный CSV. Однако есть некоторые ограничения:
- Можно импортировать только слова, состоящие из букв. Апострофы, дефисы, другие знаки препинания или специальные символы не допускаются.
- Эмодзи не допускаются.
- Один CSV-файл может содержать максимум 250 слов.
- Вы можете импортировать до 1000 слов, что означает, что вы можете импортировать максимум 4 файла по 250 слов. После достижения этого лимита вы всё равно сможете добавлять слова во время ввода.

С помощью опции «Удалить» вы можете искать и удалять опечатки или другие слова, которые вы не хотите сохранять в словаре.

### Параметры совместимости
Для нескольких приложений или устройств возможно включить специальные опции, которые сделают Traditional T9 более совместимым с ними. Эти параметры можно найти в конце каждого экрана настроек в разделе Совместимость.

#### Альтернативный метод прокрутки предложений
_Раздел: Настройки → Внешний вид._

На некоторых устройствах в режиме предсказания вы можете столкнуться с невозможностью прокрутить список до конца или необходимостью несколько раз прокручивать список туда и обратно, пока не появится последнее предложение. Эта проблема иногда возникает на Android 9 и более ранних версиях. Включите эту опцию, если сталкиваетесь с такой проблемой.

#### Всегда сверху
_Раздел: Настройки → Внешний вид._

На некоторых телефонах, особенно Sonim XP3plus (XP3900), Traditional T9 может не отображаться, когда вы начинаете вводить текст, или быть частично скрытым за сенсорными клавишами. В других случаях могут появляться белые полосы вокруг него. Проблема может возникать в одном конкретном приложении или во всех. Чтобы предотвратить это, включите опцию «Всегда сверху».

#### Пересчитать нижний отступ
_Раздел: Настройки → Внешний вид._

Android 15 представил функцию "от края до края", которая иногда может вызывать появление лишнего пустого пространства под клавишами клавиатуры. Включите эту опцию, чтобы нижний отступ пересчитывался для каждого приложения и удалялся, если он не нужен.

На устройствах Samsung Galaxy с Android 15 или обновлённых до него эта опция может привести к наложению TT9 на системную навигационную панель, особенно если она настроена на 2 или 3 кнопки. Если это произойдёт, отключите опцию, чтобы освободить место для панели навигации.

#### Защита от повторных нажатий
_Раздел: Настройки → Клавиатура._

Телефоны CAT S22 Flip и Qin F21 известны низким качеством клавиатур, которые со временем быстро изнашиваются и начинают регистрировать несколько нажатий за одно нажатие клавиши. Вы можете заметить это при вводе текста или навигации по меню телефона.

Для телефонов CAT рекомендуется установить значение 50-75 мс. Для Qin F21 попробуйте с 20-30 мс. Если проблема сохраняется, немного увеличьте значение, но старайтесь держать его как можно ниже.

_**Примечание:** Чем выше значение, тем медленнее вам придётся набирать текст. TT9 будет игнорировать очень быстрые нажатия клавиш._

_**Примечание 2:** Кроме того, телефоны Qin могут не определять длительные нажатия. К сожалению, в этом случае ничего нельзя сделать._

#### Показывать текст при ввод
_В: Настройки → Клавиатура._

Если у вас возникают проблемы с набором текста в Deezer или Smouldering Durtles, потому что предложения исчезают слишком быстро, прежде чем вы их увидите, отключите эту опцию. Это приведёт к тому, что текущее слово останется скрытым, пока вы не нажмёте OK или Пробел, или не коснётесь списка предложений.

Проблема возникает из-за того, что Deezer и Smouldering Durtles иногда изменяют введённый текст, что приводит к сбоям в работе TT9.

#### Не открываются панели стикеров и эмодзи в Telegram/Snapchat
Это происходит, если вы используете один из маленьких макетов. В настоящее время нет постоянного решения, но можно воспользоваться следующим обходным путём:
- Перейдите в Настройки → Внешний вид и включите Экранную цифровую клавиатуру.
- Вернитесь в чат и нажмите кнопку эмодзи или стикеров. Они теперь появятся.
- Теперь вы можете вернуться в настройки и отключить экранную цифровую клавиатуру. Панели стикеров и эмодзи останутся доступными, пока вы не перезапустите приложение или телефон.

#### Traditional T9 не появляется сразу в некоторых приложениях
Если вы открыли приложение, где можно вводить текст, но TT9 не появляется автоматически, просто начните вводить, и он появится. Альтернативно, нажатие горячих клавиш для смены [режима ввода](#клавиша-смены-режима-ввода-по-умолчанию-нажмите) или [языка](#клавиша-смены-языка-по-умолчанию-удерживайте) также может вызвать TT9, если он скрыт.

На некоторых устройствах TT9 может оставаться невидимым, что бы вы ни делали. В таких случаях вам придётся включить [Всегда сверху](#всегда-сверху).

**Длинное объяснение.** Проблема заключается в том, что Android в основном предназначен для устройств с сенсорным экраном. Поэтому он ожидает, что вы коснётесь текстового/числового поля, чтобы отобразить клавиатуру. Можно настроить TT9 так, чтобы он появлялся без этого подтверждения, но в некоторых случаях Android забудет скрыть его, когда это необходимо. Например, он может остаться видимым после того, как вы набрали номер телефона или отправили текст в поисковом поле.

По этим причинам, чтобы соответствовать стандартам Android, управление остаётся в ваших руках. Просто нажмите клавишу, чтобы "коснуться" экрана и продолжайте ввод текста.

#### На Qin F21 Pro удерживание клавиши 2 или 8 увеличивает или уменьшает громкость вместо набора числа
Чтобы решить эту проблему, перейдите в Настройки → Внешний вид и включите «Значок состояния». TT9 должен автоматически обнаружить Qin F21 и включить настройки, но если автоопределение не сработало или вы отключили значок по какой-либо причине, вам необходимо включить его, чтобы все клавиши работали корректно.

**Длинное объяснение.** Qin F21 Pro (и, возможно, F22) имеет приложение горячих клавиш, которое позволяет назначать функции увеличения и уменьшения громкости на цифровые клавиши. По умолчанию менеджер горячих клавиш включён, и удерживание клавиши 2 увеличивает громкость, удерживание клавиши 8 — уменьшает. Однако, когда нет значка состояния, менеджер предполагает, что клавиатура не активна, и регулирует громкость, вместо того чтобы позволить Traditional T9 обрабатывать клавиши для набора чисел. Поэтому включение значка обходит менеджер горячих клавиш, и всё работает нормально.

#### Общие проблемы на телефонах Xiaomi
Xiaomi ввела несколько нестандартных разрешений на своих телефонах, которые мешают корректной работе виртуальной экранной клавиатуры Traditional T9. Точнее, клавиши «Показать настройки» и «Добавить слово» могут не выполнять свои функции. Чтобы исправить это, необходимо предоставить TT9 разрешения «Отображать всплывающее окно» и «Отображать всплывающее окно в фоновом режиме» в настройках вашего телефона. [Этот гид](https://parental-control.flashget.com/how-to-enable-display-pop-up-windows-while-running-in-the-background-on-flashget-kids-on-xiaomi) для другого приложения объясняет, как это сделать.

Также настоятельно рекомендуется предоставить разрешение «Постоянное уведомление». Это похоже на разрешение «Уведомления», добавленное в Android 13. См. [выше](#примечания-для-android-13-или-выше), чтобы узнать, почему это необходимо.

_Проблемы с Xiaomi обсуждаются в [этом issue GitHub](https://github.com/sspanak/tt9/issues/490)._

#### Голосовой ввод долго не завершается
Это [известная проблема](https://issuetracker.google.com/issues/158198432) на Android 10, которую Google так и не исправил. Устранить её на стороне TT9 невозможно. Чтобы завершить голосовой ввод, оставайтесь молчаливыми несколько секунд. Android автоматически отключает микрофон, когда не может обнаружить речь.

## Часто задаваемые вопросы

#### Почему вы не добавите язык X?
Я бы с радостью добавил, но мне нужна ваша помощь. Поддерживать более 40 языков в одиночку невозможно. Поскольку я не говорю на вашем языке, мне сложно искать надёжные ресурсы в интернете — и здесь вы можете помочь.
На самом деле, более 90% языков были добавлены при участии или с помощью энтузиастов-носителей.

Чтобы добавить новый язык, мне нужен список слов с проверенной орфографией, желательно из официального или академического источника (например, «Большой словарь языка X»). Такие списки обеспечивают наилучшие подсказки при наборе текста.

Если такого словаря нет, вы можете предоставить список слов, доступный для бесплатной загрузки. Оптимально — 300–500 тысяч слов, но если язык имеет много склонений или форм (по времени, роду, числу и т.д.), может потребоваться около миллиона слов.

#### В языке XYZ есть ошибки или отсутствующие слова. Почему вы их не исправите?
Как уже сказано выше, я не говорю на вашем языке и могу просто не замечать этих ошибок. Но с вашей помощью мы сможем их исправить и сделать словарь лучше для всех.

#### Вы не можете добавить функцию X?
Нет.

У каждого свои предпочтения. Кто-то хочет клавиши побольше, кто-то – в другом порядке, кто-то – горячую клавишу для ввода «.com», а кто-то скучает по своему старому телефону или клавиатуре. Но, пожалуйста, поймите, что я работаю над этим проектом добровольно в свое свободное время. Невозможно удовлетворить тысячи разных пожеланий, некоторые из которых противоречат друг другу.

Генри Форд однажды сказал: «Покупатель может выбрать любой цвет, при условии, что он будет черным». Так же и Traditional T9 – это простой, эффективный и бесплатный продукт, и он остается таким, как есть.

#### Вы не можете сделать его более похожим на Sony Ericsson, Xperia, Nokia C2, Samsung или другую программную клавиатуру?
Нет.

Traditional T9 не предназначен для того, чтобы быть заменой или клоном какого-либо приложения. Он имеет уникальный дизайн, вдохновленный в первую очередь Nokia 3310 и 6303i. И хотя он передает ощущение классических телефонов, он предлагает свой собственный опыт, который не копирует ни одно устройство полностью.

#### Вам стоит скопировать Touchpal, ведь это лучшая клавиатура в мире!
Нет, не стоит. См. предыдущие пункты.

Когда-то, в 2015 году, Touchpal действительно был одной из лучших клавиатур, так как у него не было серьезных конкурентов. Но с тех пор многое изменилось. Посмотрите сравнение Traditional T9 и Touchpal:

_**Traditional T9**_
- Уважает вашу конфиденциальность.
- Не содержит рекламы и полностью бесплатен.
- Поддерживает широкий спектр устройств: телефоны с кнопками, телевизоры с аппаратными клавиатурами, а также смартфоны и планшеты с сенсорным экраном.
- Предлагает полноценную 12-клавишную раскладку T9 для всех языков.
- Обеспечивает улучшенные подсказки слов. Например, если вы пытаетесь ввести выражение с текстонимами, например «go in», клавиатура запомнит правильный вариант и не будет предлагать «go go» или «in in».
- Все, что вы набираете, остается на вашем устройстве. Никакие данные никуда не отправляются.
- Это проект с открытым исходным кодом, что позволяет вам просматривать весь исходный код и словари, вносить вклад в развитие проекта (многие пользователи помогли исправить ошибки и добавить новые языки и переводы) или даже создать свою модифицированную версию в соответствии с вашими предпочтениями.
- Имеет чистый, удобочитаемый дизайн, который хорошо сочетается с системой. Здесь нет ненужных элементов, отвлекающих от набора текста.
- Скорость загрузки словаря низкая.

_**Touchpal**_
- Агрессивно требует доступ ко всему вашему устройству и контактам, записывает случайные файлы в систему; в итоге был удален из Play Store, так как вел себя как вирус.
- Полон рекламы.
- Поддерживает только сенсорные устройства.
- Не является полноценной T9-клавиатурой. Он предлагает T9-раскладку только для некоторых языков. Кроме того, некоторые раскладки некорректны (например, в болгарской раскладке отсутствует буква, а некоторые буквы поменяны местами на клавишах 8 и 9).
- При наборе текстонимов подряд Touchpal предлагает только последнее выбранное слово. Например, если вы хотите ввести «go in», он покажет либо «go go», либо «in in».
- Облачные подсказки могли бы улучшить точность. Однако для этого все пользователи должны отправлять все, что они вводят, на серверы Touchpal для обработки.
- Закрытый исходный код. Невозможно проверить, что приложение делает в фоновом режиме.
- Включает множество тем, цветов, GIF-анимаций и других отвлекающих элементов, не относящихся к набору текста.
- Скорость загрузки словаря высокая. В этом пункте Touchpal выигрывает.

Если вы не согласны или хотите объяснить свою точку зрения, присоединяйтесь к [открытому обсуждению](https://github.com/sspanak/tt9/issues/647) на GitHub. Просто будьте уважительны к другим пользователям. Сообщения с ненавистью не будут допускаться.

#### Android предупредил меня о том, что клавиатура может собирать мои персональные данные, включая номера банковских карт и пароли
Это стандартное предупреждение Android, которое отображается при установке и активации любой клавиатуры, а не только Traditional T9. Можете быть уверены, что всё, что вы вводите, остаётся на вашем устройстве. Механизм ввода полностью с открытым исходным кодом; вы можете ознакомиться с его кодом на GitHub и убедиться, что ваша конфиденциальность надёжно защищена.

_Если у вас всё же остаются сомнения, пожалуйста, ознакомьтесь с Политикой конфиденциальности приложения._

#### Моё банковское приложение не принимает Traditional T9
Это не является проблемой TT9. Банки часто ограничивают использование нестандартных или открытых клавиатур, поскольку не хотят рисковать и предполагают, что они могут быть небезопасными. Некоторые идут ещё дальше и предоставляют собственные клавиатуры, блокируя даже стандартную клавиатуру Google — Gboard. К сожалению, в данном случае единственным вариантом является переключение на стандартную клавиатуру устройства.

#### Вибрация не работает (только сенсорные экраном)
Функции энергосбережения, оптимизации и режим "Не беспокоить" могут блокировать вибрацию. Проверьте в системных настройках вашего устройства, активированы ли какие-либо из этих параметров. На некоторых устройствах можно настроить параметры оптимизации батареи отдельно для каждого приложения через Системные настройки → Приложения. Если ваше устройство поддерживает это, отключите оптимизацию для TT9.

Еще одна причина, по которой вибрация может не работать, — она может быть отключена на системном уровне. Проверьте, есть ли в вашем устройстве параметры "Вибрация при касании" или "Вибрация при нажатии клавиш" в Системные настройки → Специальные возможности, и включите их. Устройства Xiaomi и OnePlus позволяют более детально управлять вибрацией. Убедитесь, что все соответствующие настройки включены.

В конечном итоге вибрация может не работать на некоторых устройствах. Для исправления этой проблемы потребуется больше разрешений и доступ к дополнительным функциям устройства. Однако, поскольку TT9 является клавиатурой, ориентированной на конфиденциальность, он не будет запрашивать такой доступ.

#### Мне нужно использовать раскладку QWERTY (только сенсорные устройства)
Traditional T9 — это клавиатура типа T9, и, соответственно, она не предоставляет раскладку, похожую на QWERTY.

Если вы всё ещё учитесь использовать T9 и вам нужно иногда переключаться, или вам удобнее вводить новые слова с помощью QWERTY, проведите вверх по клавише Left F4, чтобы переключиться на другую клавиатуру. См. [обзор виртуальных клавиш](#обзор-виртуальных-клавиш) для получения дополнительной информации.

Большинство других клавиатур позволяет переключиться обратно на Traditional T9, удерживая пробел или клавишу «смены языка». Подробнее см. в соответствующем руководстве или инструкции.

#### Я не могу сменить язык на телефоне с сенсорным экраном
Сначала убедитесь, что вы включили все нужные языки в Настройки → Языки. Затем удерживайте [левую клавишу F4](#левая-клавиша-f4-нижняя-левая-клавиша), чтобы сменить язык.

#### Я не могу добавить сокращения, такие как "I've" или "don't", в словарь
Все сокращения во всех языках уже доступны как отдельные слова, поэтому вам не нужно ничего добавлять. Это обеспечивает максимальную гибкость — позволяет комбинировать любые слова с любыми сокращениями и экономит значительное количество памяти.

Например, вы можете набрать 've, нажав: 183; или 'll, используя: 155. Это означает: "I'll" = 4155 и "we've" = 93183. Вы также можете вводить, например, "google.com", нажав: 466453 (google) 1266 (.com).

Более сложный пример на французском: "Qu'est-ce que c'est" = 781 (qu'), 378123 (est-ce), 783 (que), 21378 (c'est).

_Исключения из этого правила — "can't" и "don't" в английском языке. Здесь 't — это не отдельное слово, но вы все равно можете вводить их, как описано выше._