/**
 * @license BSD-3-Clause
 * Copyright (c) 2024, ッツ Reader Authors
 * All rights reserved.
 */

export const baseHeaderClasses = 'relative h-12 bg-gray-700 text-white xl:h-10';
export const pHeaderMat = 'p-2.5';
export const pxScreen = 'px-4 md:px-8 lg:max-w-4xl xl:max-w-none 2xl:max-w-6xl mx-auto';
export const opacityHeaderIcon = 'opacity-60 hover:opacity-100 transition-opacity';
export const pHeaderFa = 'p-4 xl:p-3';
export const nTranslateXHeaderFa = '-translate-x-4 xl:-translate-x-3';
export const translateXHeaderFa = 'translate-x-4 xl:translate-x-3';
export const inputClasses =
  'mt-1 block w-full px-0.5 bg-background-color border-0 border-b-2 border-gray-400/50 focus:ring-0 focus:border-black transition';
export const buttonClasses =
  'inline-block no-underline font-medium rounded min-w-[32px] sm:min-w-[64px] px-4 leading-9 cursor-pointer text-cyan-900';
export const baseIconClasses = `flex justify-center select-none items-center h-12 w-12 cursor-pointer text-xl xl:h-10 xl:w-10 xl:text-lg ${pHeaderMat} ${opacityHeaderIcon}`;
