// ignore_for_file: avoid_print

import 'dart:io';

import 'package:exif_reader/exif_reader.dart';

Future<void> main(List<String> arguments) async {
  for (final filename in arguments) {
    print('read $filename ..');

    final fileBytes = await File(filename).readAsBytes();
    final exif = await readExifFromBytes(fileBytes);

    if (exif.warnings.isNotEmpty) {
      print('Warnings:');
      for (final warning in exif.warnings) {
        print('  $warning');
      }
    }

    if (exif.tags.isEmpty) {
      print('No EXIF information found');
      return;
    }

    final latRef = exif.tags['GPS GPSLatitudeRef']?.toString();
    var latVal = gpsValuesToFloat(exif.tags['GPS GPSLatitude']?.values);
    final lngRef = exif.tags['GPS GPSLongitudeRef']?.toString();
    var lngVal = gpsValuesToFloat(exif.tags['GPS GPSLongitude']?.values);

    if (latRef == null || latVal == null || lngRef == null || lngVal == null) {
      print('GPS information not found');
      return;
    }

    if (latRef == 'S') {
      latVal *= -1;
    }

    if (lngRef == 'W') {
      lngVal *= -1;
    }

    print('lat = $latVal');
    print('lng = $lngVal');
  }
}

double? gpsValuesToFloat(IfdValues? values) {
  if (values == null || values is! IfdRatios) {
    return null;
  }

  double sum = 0.0;
  double unit = 1.0;

  for (final v in values.ratios) {
    sum += v.toDouble() * unit;
    unit /= 60.0;
  }

  return sum;
}
