# Contributing to OpenPhotoFrame

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features

## Contributor License Agreement (CLA)

By contributing to OpenPhotoFrame, you agree that your contributions will be licensed under its **GNU General Public License v3.0**.

However, to allow the project owner to offer commercial licenses (Dual Licensing) and ensure the long-term sustainability of the project, we require all contributors to sign a **Contributor License Agreement (CLA)**.

*   **What this means:** You keep the copyright to your code, but you give the project owner the right to use it, including the right to relicense it (e.g., for commercial customers).
*   **How to sign:** When you open a Pull Request, a bot will automatically ask you to agree to the CLA if you haven't already.

## Pull Request Process

1.  Ensure any install or build dependencies are removed before the end of the layer when doing a build.
2.  Update the README.md with details of changes to the interface, this includes new environment variables, exposed ports, useful file locations and container parameters.
3.  You may merge the Pull Request in once you have the sign-off of two other developers, or if you do not have permission to do that, you may request the second reviewer to merge it for you.

## Any questions?

Feel free to open an issue to discuss!
