package ly.david.musicsearch.ui.common.screen

import app.cash.paging.PagingData
import kotlinx.coroutines.flow.Flow
import ly.david.musicsearch.shared.domain.image.ImageMetadata
import ly.david.musicsearch.shared.domain.image.MusicBrainzImageMetadataRepository
import ly.david.musicsearch.shared.domain.image.ImageMetadataWithCount
import ly.david.musicsearch.shared.domain.image.ImagesSortOption
import ly.david.musicsearch.shared.domain.network.MusicBrainzEntityType

class NoOpMusicBrainzImageMetadataRepository : MusicBrainzImageMetadataRepository {
    override suspend fun getAndSaveImageMetadata(
        mbid: String,
        entity: MusicBrainzEntityType,
        forceRefresh: Boolean,
    ): ImageMetadataWithCount {
        error("Not used")
    }

    override suspend fun saveImageMetadata(
        mbid: String,
        entity: MusicBrainzEntityType,
        itemsCount: Int,
    ) {
        // No-op
    }

    override fun observeAllImageMetadata(
        mbid: String?,
        query: String,
        sortOption: ImagesSortOption,
    ): Flow<PagingData<ImageMetadata>> {
        error("Not used")
    }

    override fun observeCountOfAllImageMetadata(): Flow<Long> {
        error("Not used")
    }
}
