package ly.david.musicsearch.shared.feature.details.label

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import ly.david.musicsearch.shared.domain.common.ifNotEmpty
import ly.david.musicsearch.shared.domain.common.ifNotNull
import ly.david.musicsearch.shared.domain.common.ifNotNullOrEmpty
import ly.david.musicsearch.shared.domain.details.LabelDetailsModel
import ly.david.musicsearch.shared.domain.network.MusicBrainzItemClickHandler
import ly.david.musicsearch.shared.feature.details.area.AreaSection
import ly.david.musicsearch.shared.feature.details.utils.DetailsTabUi
import ly.david.musicsearch.shared.feature.details.utils.DetailsTabUiState
import ly.david.musicsearch.ui.common.text.TextWithHeading
import ly.david.musicsearch.ui.common.theme.LocalStrings

@Composable
internal fun LabelDetailsTabUi(
    label: LabelDetailsModel,
    modifier: Modifier = Modifier,
    detailsTabUiState: DetailsTabUiState = DetailsTabUiState(),
    filterText: String = "",
    onCollapseExpandExternalLinks: () -> Unit = {},
    onCollapseExpandAliases: () -> Unit = {},
    onItemClick: MusicBrainzItemClickHandler = { _, _ -> },
) {
    val strings = LocalStrings.current

    DetailsTabUi(
        detailsModel = label,
        detailsTabUiState = detailsTabUiState,
        modifier = modifier,
        filterText = filterText,
        onCollapseExpandExternalLinks = onCollapseExpandExternalLinks,
        onCollapseExpandAliases = onCollapseExpandAliases,
        entityInfoSection = {
            type.ifNotEmpty {
                TextWithHeading(
                    heading = strings.type,
                    text = it,
                    filterText = filterText,
                )
            }
            labelCode?.ifNotNull {
                TextWithHeading(
                    heading = strings.labelCode,
                    text = strings.lc(it),
                    filterText = filterText,
                )
            }

            ipis.ifNotNullOrEmpty {
                TextWithHeading(
                    heading = strings.ipi,
                    text = it.joinToString(", "),
                    filterText = filterText,
                )
            }

            isnis.ifNotNullOrEmpty {
                TextWithHeading(
                    heading = strings.isni,
                    text = it.joinToString(", "),
                    filterText = filterText,
                )
            }

            lifeSpan.run {
                begin.ifNotEmpty {
                    TextWithHeading(
                        heading = strings.founded,
                        text = it,
                        filterText = filterText,
                    )
                }
                end.ifNotEmpty {
                    TextWithHeading(
                        heading = strings.defunct,
                        text = it,
                        filterText = filterText,
                    )
                }
            }

            AreaSection(
                areaListItemModel = area,
                filterText = filterText,
                onItemClick = onItemClick,
            )
        },
    )
}
