from selenium import webdriver
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.common.action_chains import ActionChains
from selenium.webdriver.support.ui import WebDriverWait
from webdriver_manager.chrome import ChromeDriverManager
import time
import os

def link_phrase_includes_squigglies(phrase):
    return "{" in phrase 

# TODO: For testing only.
count = 0
max_clicks = 3

dirname = os.path.dirname(__file__)
output_file_name = os.path.join(dirname, "../app/src/main/java/ly.david.musicsearch.android.app/data/network/RelationshipHeaders.kt")
with open(output_file_name, "w", encoding="utf-8") as output_file:

    output_file.write("package ly.david.musicsearch.android.app.data.network\n\n")
    output_file.write("/**\n")
    output_file.write("// TODO: Deal with attributes\n")
    output_file.write(" * Generated by scrape_relationships.py Selenium script using data from https://musicbrainz.org/relationships.\n")
    output_file.write(" */\n")

    output_file.write("internal val relationshipHeaders = hashMapOf(\n\n")

    browser = webdriver.Chrome(ChromeDriverManager().install())
    browser.get("https://musicbrainz.org/relationships")
    relationship_links = browser.find_elements_by_xpath("//table[@class = 'wikitable']//td/a")
    for relationship_link in relationship_links:

        # Write link as comment.
        output_file.write("    // {}\n".format(relationship_link.get_attribute("href")))

        ActionChains(browser).key_down(Keys.CONTROL).click(relationship_link).key_up(Keys.CONTROL).perform()
        browser.switch_to.window(browser.window_handles[1])

        # Since some pages do not have any relationship types, we rely on the existence of this element.
        back_link = WebDriverWait(browser, timeout=3).until(lambda d: d.find_element_by_xpath("//div[@id = 'content']//small/a"))

        try:
            browser.find_element_by_id("showAll").click()
        except:
            output_file.write("    // No relationships.\n")

        relationship_types = browser.find_elements_by_class_name("reldetails")
        for relationship_type in relationship_types:
            all_info = relationship_type.text
            all_info_parts = all_info.split("\n")
            forward_link_phrase = all_info_parts[0].split(": ")[-1]
            reverse_link_phrase = all_info_parts[1].split(": ")[-1]
            uuid = all_info_parts[6].split(": ")[-1] # TODO: Doesn't work for some ~5 types

            # If this relationship type depends on attributes for its link phrase, then we will comment it out until we can support it.
            # That means, we won't display text that includes `{}` in it. We'd rather just display the default `type` returned from API.
            uuid_to_link_phrase = "\"{}\" to (\"{}\" to \"{}\"),\n".format(uuid, forward_link_phrase, reverse_link_phrase)
            if link_phrase_includes_squigglies(forward_link_phrase) or link_phrase_includes_squigglies(reverse_link_phrase):
                uuid_to_link_phrase = "// " + uuid_to_link_phrase

            output_file.write("    " + uuid_to_link_phrase)

        # Space out the different relationship types.
        output_file.write("\n")

        browser.close()
        browser.switch_to.window(browser.window_handles[0])

        # TODO: temp
        # count += 1
        # if count >= max_clicks:
        #     break

        # To make sure we don't make too many requests in a short timeframe.
        time.sleep(1)
    browser.close()
    output_file.write(")\n")


