# Paging

Paging is a cross-cutting concern that exists in every layer of my app (UI, ViewModel, domain, data).

The [official docs](https://developer.android.com/topic/libraries/architecture/paging/v3-overview#architecture)
recommends putting `Flow<PagingData>` in the ViewModel layer,
whereas I'm currently in the process of moving this out of this layer and into the repository (data) layer.

I guess the main advantage of this approach would allow us to insert separators in the ViewModel.
```kotlin
flow.map { pagingData ->
    pagingData
        .insertSeparators { before: SearchHistoryListItemModel?, _: SearchHistoryListItemModel? ->
            if (before == null) Header() else null
        }
}
```

For multiplatform, I'm uncertain on whether I will keep Android ViewModels in the near future.
So, the more logic I can extract from them, the better.
