package ly.david.musicsearch.shared.strings

import cafe.adriel.lyricist.LanguageTag

data class AppStrings(
    val theme: String,
    val light: String,
    val dark: String,
    val system: String,
    val area: String,
    val artist: String,
    val event: String,
    val genre: String,
    val instrument: String,
    val label: String,
    val place: String,
    val recording: String,
    val release: String,
    val releaseGroup: String,
    val series: String,
    val work: String,
    val works: String,
    val url: String,
    val urls: String,
    val collection: String,
    val back: String,
    val openInBrowser: String,
    val refresh: String,
    val refreshXTab: (String) -> String,
    val filter: String,
    val cancel: String,
    val clearFilter: String,
    val searchMusicbrainz: String,
    val search: String,
    val database: String,
    val history: String,
    val images: String,
    val collections: String,
    val settings: String,
    val resource: String,
    val clearSearch: String,
    val noResultsFound: String,
    val noResultsFoundSearch: String,
    val recentSearches: String,
    val clearSearchHistory: String,
    val deleteSearchHistoryConfirmation: String,
    val yes: String,
    val no: String,
    val recentHistory: String,
    val clearHistory: String,
    val deleteLookupHistoryConfirmation: String,
    val nowPlayingHistory: String,
    val nowPlayingHistorySubtitle: String,
    val enableNotificationListener: String,
    val enableNotificationListenerSubtitle: String,
    val labels: String,
    val details: String,
    val areas: String,
    val artists: String,
    val events: String,
    val genres: String,
    val instruments: String,
    val places: String,
    val releaseGroups: String,
    val releases: String,
    val recordings: String,
    val relationships: String,
    val relationshipsReleases: String,
    val relationshipsRecordings: String,
    val tracks: String,
    val format: String,
    val stats: String,
    val barcode: String,
    val labelCode: String,
    val lc: (Int) -> String,
    val length: String,
    val type: String,
    val sortName: String,
    val gender: String,
    val opened: String,
    val closed: String,
    val created: String,
    val born: String,
    val died: String,
    val founded: String,
    val dissolved: String,
    val defunct: String,
    val date: String,
    val firstReleaseDate: String,
    val startDate: String,
    val endDate: String,
    val time: String,
    val address: String,
    val packaging: String,
    val status: String,
    val language: String,
    val script: String,
    val dataQuality: String,
    val asin: String,
    val iswc: String,
    val isrc: String,
    val ipi: String,
    val isni: String,
    val iso31661: String,
    val regionalIndicatorSymbol: String,
    val releaseEvents: String,
    val informationHeader: (String) -> String,
    val attributesHeader: (String) -> String,
    val additionalDetails: String,
    val multipleScripts: String,
    val coordinates: String,
    val cancelled: String,
    val description: String,
    val appVersion: String,
    val databaseVersion: String,
    val ok: String,
    val retry: String,
    val cached: String,
    val visited: String,
    val collected: String,
    val moreActions: String,
    val openGoogleMaps: String,
    val sort: String,
    val unsort: String,
    val showMoreInfo: String,
    val showLessInfo: String,
    val createCollection: String,
    val name: String,
    val collectionNamePlaceholder: String,
    val addToCollection: String,
    val about: String,
    val experimentalSearch: String,
    val openSourceLicenses: String,
    val spotify: String,
    val spotifySubtitle: String,
    val spotifyTutorial: String,
    val spotifyHistory: String,
    val searchX: (String) -> String,
    val searchXByX: (String, String) -> String,
    val none: String,
    val alphabetically: String,
    val alphabeticallyReverse: String,
    val recentlyVisited: String,
    val leastRecentlyVisited: String,
    val mostVisited: String,
    val leastVisited: String,
    val recentlyAdded: String,
    val leastRecentlyAdded: String,
    val earliestReleaseDate: String,
    val latestReleaseDate: String,
    val mostListened: String,
    val leastListened: String,
    val mostCompleteListened: String,
    val leastCompleteListened: String,
    val earliestCached: String,
    val latestCached: String,
    val typeAlphabetically: String,
    val typeReverseAlphabetically: String,
    val loginToMusicBrainz: String,
    val artificialLanguage: String,
    val mostEntities: String,
    val leastEntities: String,
    val seeCollaborators: String,
    val collaborationsWith: (String) -> String,
    val wikipedia: String,
    val readMore: String,
    val numberOfImages: String,
    val lastUpdatedFromMusicBrainz: (period: String, dateTime: String) -> String,
    val justNow: String,
    val secondsAgo: String,
    val minuteAgo: String,
    val minutesAgo: String,
    val hourAgo: String,
    val hoursAgo: String,
    val yesterday: String,
    val daysAgo: String,
    val weekAgo: String,
    val weeksAgo: String,
    val monthAgo: String,
    val monthsAgo: String,
    val yearAgo: String,
    val yearsAgo: String,
    val appearance: String,
    val areaName: String,
    val artistName: String,
    val eventName: String,
    val instrumentName: String,
    val labelName: String,
    val placeName: String,
    val recordingName: String,
    val releaseName: String,
    val releaseGroupName: String,
    val seriesName: String,
    val workName: String,
    val searchHint: String,
    val legalName: String,
    val formalName: String,
    val brandName: String,
    val primary: String,
    val listens: String,
    val xListens: (String) -> String,
    val username: String,
    val enterUsername: String,
    val changeUsername: String,
    val set: String,
    val youAreLoggedIn: String,
    val youAreLoggedOut: String,
    val invalidToken: String,
    val official: String,
    val bootleg: String,
    val promotion: String,
    val pseudoRelease: String,
    val withdrawn: String,
    val expunged: String,
    val video: String,
)

object Locales {
    const val EN = "en"
}

val Strings: Map<LanguageTag, AppStrings> = mapOf(
    Locales.EN to EnStrings,
)

expect fun String.fmt(vararg args: Any?): String
