import java.io.FileInputStream
import java.util.Properties

plugins {
    id("ly.david.android.application")
    id("ly.david.musicsearch.compose.multiplatform")
    alias(libs.plugins.baselineprofile)
    alias(libs.plugins.aboutlibraries)
}

// For F-Droid, remove google-services.json and we will not apply these plugins.
if (file("google-services.json").exists() ||
    file("src/debug/google-services.json").exists() ||
    file("src/release/google-services.json").exists()
) {
    apply(plugin = "com.google.gms.google-services")
    apply(plugin = "com.google.firebase.crashlytics")
}

android {
    namespace = "ly.david.musicsearch.android.app"

            // https://developer.android.com/studio/publish/app-signing#secure-shared-keystore

    defaultConfig {
        applicationId = "io.github.lydavid.musicsearch"
        versionCode = (project.properties["VERSION_CODE"] as String).toInt()
        versionName = project.properties["VERSION_NAME"] as String

        vectorDrawables {
            useSupportLibrary = true
        }
    }

    buildTypes {
        debug {
            applicationIdSuffix = ".debug"
        }
        release {
            isMinifyEnabled = true
            isShrinkResources = true
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
            vcsInfo.include = false
        }
    }

    flavorDimensions += "appStore"
    productFlavors {
        create("fDroid") {
            dimension = "appStore"
        }
        create("googlePlay") {
            dimension = "appStore"
        }
    }

    packaging {
        resources {
            excludes += setOf(
                "/META-INF/{AL2.0,LGPL2.1}",
                "META-INF/**/previous-compilation-data.bin",
            )
        }
    }

    dependenciesInfo {
        // Disables dependency metadata when building APKs.
        includeInApk = false
        // Disables dependency metadata when building Android App Bundles.
        includeInBundle = false
    }
}

dependencies {
    implementation(projects.shared.feature.nowplaying)
    implementation(projects.shared.feature.spotify)
    implementation(projects.core.logging.api)
    implementation(projects.shared.domain)
    implementation(projects.shared)
    implementation(projects.ui.common)
    implementation(libs.androidx.activity.compose)
    implementation(libs.appauth)
    implementation(libs.circuit.foundation)
    implementation(libs.koin.android)
    implementation(libs.koin.core)
    implementation(libs.kotlinx.collections.immutable)
    implementation(libs.timber)
    implementation(libs.androidx.profileinstaller)
    "baselineProfile"(projects.android.baselineprofile)

    googlePlayImplementation(platform(libs.firebase.bom))
    googlePlayImplementation(libs.firebase.analytics)
    googlePlayImplementation(libs.firebase.crashlytics)

    debugImplementation(libs.leakcanary.android)
}

fun DependencyHandler.googlePlayImplementation(dependencyNotation: Any) =
    add("googlePlayImplementation", dependencyNotation)

aboutLibraries {
    export {
        excludeFields.addAll("generated")
        outputFile = file("../../shared/feature/licenses/src/commonMain/composeResources/files/aboutlibraries.json")
        prettyPrint = true
    }
    library {
        duplicationMode = com.mikepenz.aboutlibraries.plugin.DuplicateMode.MERGE
        duplicationRule = com.mikepenz.aboutlibraries.plugin.DuplicateRule.GROUP
    }
}
