package ly.david.musicsearch.data.musicbrainz.models.relation

// TODO: Deal with attributes: if an attribute exists, then use appropriate {half:half-}{step} in label?
//  maybe something to consider down the road
//  For %, we needs to sub in its attribute-value
//  https://musicbrainz.org/relationship-attributes
/**
 * Generated by scrape_relationships.py Selenium script using data from https://musicbrainz.org/relationships.
 */
@Suppress("MaxLineLength")
internal val relationshipHeaders = hashMapOf(

    // https://musicbrainz.org/relationships/area-area
    "de7cc874-8b1b-3a05-8272-f3834c968fb7" to ("parts" to "part of"),

    // https://musicbrainz.org/relationships/area-artist
    // No relationships.

    // https://musicbrainz.org/relationships/artist-artist
    "92859e2a-f2e5-45fa-a680-3f62ba0beccc" to ("musical relationship" to "musical relationship"),
    // "5be4c609-9afa-4ea0-910b-12ffb71e3821" to ("{additional} {original} {eponymous} member of" to "{additional} {original} {eponymous} members"),
    "7802f96b-d995-4ce9-8f70-6366faad758e" to ("subgroup of" to "subgroups"),
    "9752bfdf-13ca-441a-a8bc-18928c600c73" to ("renamed into" to "renamed from"),
    "ab666dde-bd85-4ac2-a209-165eaf4146a0" to ("artistic director for" to "artistic director"),
    // "cac01ac7-4159-42fd-9f2b-c5a7a5624079" to ("{assistant} {principal} {guest} conductor {emeritus} for" to "{assistant} {principal} {guest} conductor {emeritus}"),
    "6ed4bfc4-0a0d-44c0-b025-b7fc4d900b67" to ("founded" to "founded by"),
    "88562a60-2550-48f0-8e8e-f54d95c7369a" to ("supporting artist for" to "supporting artists"),
    // "610d39a4-3fa0-4848-a8c9-f46d7b5cc02e" to ("{vocal:%|vocals} support for" to "{vocal:%|vocals} support by"),
    // "ed6a7891-ce70-4e08-9839-1f2f62270497" to ("supporting {instrument} for" to "supporting {instrument} by"),
    "a6f62641-2f58-470e-b02b-88d7b984dc9f" to ("tribute to" to "tribute artists"),
    "e259a3f5-ce8e-45c1-9ef7-90ff7d0c7589" to ("voice of" to "voiced by"),
    // "75c09861-6857-4ec0-9729-84eefde7fc86" to ("{additional} {minor} collaborator on" to "{additional} {minor} collaborators"),
    "dd9886f2-1dfe-4270-97db-283f6839a666" to ("performs as" to "legal name"),
    "249fc24f-d573-4290-9d74-0547712d1f1e" to ("students" to "teachers"),
    "094b1ddf-3df3-4fb9-8b01-cfd28e45da80" to ("composer-in-residence at" to "composers-in-residence"),
    "e794f8ff-b77b-4dfe-86ca-83197146ef10" to ("personal relationship" to "personal relationship"),
    // "9421ca84-934f-49fe-9e66-dea242430406" to ("{step}children" to "{step}parents"),
    // "b42b7966-b904-449e-b8f9-8c7297b863d0" to ("{half:half-}{step}siblings" to "{half:half-}{step}siblings"),
    "b2bf7a5d-2da6-4742-baf4-e38d8a7ad029" to ("married" to "married"),
    "fd3927ba-fd51-4fa9-bcc2-e83637896fe8" to ("romantically involved with" to "romantically involved with"),
    "1af24726-5b1f-4b07-826e-5351723f504b" to ("named after" to "inspired the name of"),

    // https://musicbrainz.org/relationships/area-event
    "542f8484-8bc7-3ce5-a022-747850b2b928" to ("held events" to "held in"),

    // https://musicbrainz.org/relationships/artist-event
    "936c7c95-3156-3889-a062-8a0cd57f8946" to ("main performer at" to "main performers"),
    "492a850e-97eb-306a-a85e-4b6d98527796" to ("support act at" to "support acts"),
    "292df906-98a6-307e-86e8-df01a579a321" to ("guest performer at" to "guest performers"),
    "76e8523e-567c-3e44-a302-3c75e601fcc2" to ("host at" to "hosts"),
    "9b2d5b96-b4d9-4bce-b056-c369ced25e81" to ("orchestra at" to "orchestras"),
    "92873f0d-12a7-4fb3-9eac-ff06c38c6a60" to ("conductor at" to "conductors"),
    "e5e6a204-8f81-4b17-9b54-a73a1a6db2bb" to ("taught at" to "teachers"),
    "2c5c92da-259c-42fc-ac1f-53d9dda2d6d0" to ("supporting DJ at" to "supporting DJ"),
    "9da4b1cc-cdfa-425d-b5bc-83222046c805" to ("non-performing relationships" to "non-performing relationships"),
    "19d9339e-04d7-4d59-8a16-9fea1263bbd7" to ("engineered" to "engineers"),
    "4ef86173-7f40-486d-bf8d-c38b1097e77f" to ("tribute events" to "tribute to"),

    // https://musicbrainz.org/relationships/event-event
    "65742183-b25c-469e-b094-ff6739e6699c" to ("parts" to "part of"),
    "eb39ba59-5c98-4af7-8475-02a28e235ba4" to ("rescheduled as" to "originally scheduled as"),

    // https://musicbrainz.org/relationships/area-genre
    "25ed73f8-a864-42cf-8b9c-68db198dbe0e" to ("genres" to "from"),

    // https://musicbrainz.org/relationships/artist-genre
    // No relationships.

    // https://musicbrainz.org/relationships/event-genre
    // No relationships.

    // https://musicbrainz.org/relationships/genre-genre
    // No relationships.

    // https://musicbrainz.org/relationships/area-instrument
    "0b67183b-9f36-4b09-b561-0fa531508f91" to ("instruments" to "from"),

    // https://musicbrainz.org/relationships/artist-instrument
    "87bfa63d-c91f-4bf2-9051-5103f7d181dd" to ("invented" to "invented by"),

    // https://musicbrainz.org/relationships/event-instrument
    // No relationships.

    // https://musicbrainz.org/relationships/genre-instrument
    "0b4d32c8-bdba-4842-a6b5-35b2ca2f4f11" to ("used instruments" to "used in"),

    // https://musicbrainz.org/relationships/instrument-instrument
    "12678b88-1adb-3536-890e-9b39b9a14b2d" to ("children" to "child of"),
    "deaf1d50-e624-3069-91bd-88e51cafd605" to ("derivations" to "derived from"),
    "5ee4568f-d8bd-321d-9426-0ff6819ae6b5" to ("consists of" to "part of"),
    "0fd327f5-8be4-3b9a-8852-2982c1a830ee" to ("related instruments" to "related instruments"),
    "2f522cbc-46f9-409b-9957-d0308d0899ef" to ("hybrid of" to "has hybrids"),
    "40b2bd3f-1457-3ceb-810d-57f87f0f74f0" to ("subtypes" to "type of"),

    // https://musicbrainz.org/relationships/area-label
    // No relationships.

    // https://musicbrainz.org/relationships/artist-label
    "e74a40e7-0f27-4e05-bdbd-eb10f5309472" to ("contract" to "contract"),
    "46981330-d73c-4ba5-845f-47f467072cf8" to ("producer position" to "producers"),
    "5f9374d2-a0fa-4958-8a6f-80ca67e4aaa5" to ("engineer position" to "engineers"),
    "85d1947c-1986-42f0-947c-80aab72a548f" to ("creative position" to "creative persons"),
    "8f60b62e-5755-4842-866a-269d1255a235" to ("artists and repertoire position" to "artists and repertoire persons"),
    "b336d682-592f-4486-9f45-3d5d59895bdc" to ("signed by" to "signed"),
    "c351514d-076b-45f9-9bc3-24200e5f90ba" to ("ownership" to "ownership"),
    "577996f3-7ff9-45cf-877e-740fb1267a63" to ("founded" to "founders"),
    "610fa594-eeaa-407b-a9f1-49f509ab5559" to ("owns" to "owner"),
    "fe16f2bd-d324-435a-8076-bcf43b805bd9" to ("has personal label" to "personal label for"),
    "8fecc8a7-0df7-4637-9152-f12a07f0e9cd" to ("has personal publisher" to "personal publisher for"),

    // https://musicbrainz.org/relationships/event-label
    // No relationships.

    // https://musicbrainz.org/relationships/genre-label
    // No relationships.

    // https://musicbrainz.org/relationships/instrument-label
    "9a1365db-5cce-4be6-9a6c-fbf566b26913" to ("invented by" to "invented"),

    // https://musicbrainz.org/relationships/label-label
    "0c1ff137-fca5-4148-82b7-8bce3c69165a" to ("business association" to "business association"),
    "ab7a9be0-c060-4852-8f2e-4faf5b33231e" to ("subsidiaries" to "parent label"),
    "A bootleg label reissues another label's catalog." to ("reissuing the catalog of" to "catalog reissued by"),
    "e6159066-6013-4d09-a2f8-bc473f21e89e" to ("renamed into" to "renamed from"),
    "e0636054-32b7-4dd5-97a9-6e5664d443bc" to ("distributor for" to "distributors"),
    "23f8c592-006d-4214-9080-c4e5000c05d7" to ("imprints" to "imprint of"),

    // https://musicbrainz.org/relationships/area-place
    // No relationships.

    // https://musicbrainz.org/relationships/artist-place
    "666c5ee3-b763-4b74-8f71-3456dfd3e755" to ("engineer position at" to "engineers"),
    "350f7ab7-c2d9-4f00-98e0-e1973bf4a2bf" to ("recording engineer position at" to "recording engineers"),
    "67ed1d31-8993-442c-aa59-afdb6a89d2c2" to ("mixing engineer position at" to "mixing engineers"),
    "98e2ad89-6641-4336-913d-db1515aaabcb" to ("mastering engineer position at" to "mastering engineers"),
    "fff4640a-0819-49e9-92c5-1e3b5134fd95" to ("primary concert venue" to "primary concert venue of"),
    "54fcf574-eb3a-40da-839f-986d46997b97" to ("founded" to "founders"),
    "6f238bfb-0108-45ad-a1da-960c919a7066" to ("owns" to "owner"),
    "7f7d829b-6ba8-4f86-be90-c9372ef9a679" to ("composer-in-residence at" to "composers-in-residence"),
    // "cad0dbab-c711-442a-a91c-05359f0228ce" to ("{assistant} organist at" to "{assistant} organists"),
    "72854c7e-ebf8-4b73-9b2c-ee08e83b9480" to ("educational institution connection" to "connected with"),
    "24fce292-8a25-4039-b313-611a3678a42a" to ("associated with" to "associated groups"),
    "58e18f90-fb7d-41d8-a70d-8d750fb73617" to ("studied at" to "students"),
    "3e23fc35-10c3-4dc9-a4f5-e3803643d5c1" to ("taught at" to "educators"),
    "8a3994fd-71ec-4443-9882-2192801241f2" to ("inspired the name of" to "named after"),

    // https://musicbrainz.org/relationships/event-place
    "e2c6f697-07dc-38b1-be0b-83d740165532" to ("held at" to "held events"),

    // https://musicbrainz.org/relationships/genre-place
    // No relationships.

    // https://musicbrainz.org/relationships/instrument-place
    // No relationships.

    // https://musicbrainz.org/relationships/label-place
    "06829429-0f20-4c00-aa3d-871fde07d8c4" to ("owns" to "owner"),

    // https://musicbrainz.org/relationships/place-place
    "ff683f48-eff1-40ab-a58f-b128098ffe92" to ("parts" to "part of"),
    "69c3ef7a-7fec-4e0a-ae6c-0b0535509528" to ("relocated to" to "relocated from"),

    // https://musicbrainz.org/relationships/area-recording
    "4f4aa317-c3c4-4001-ac23-fb8cf0bc543c" to ("arranging location for" to "arranged in"),
    // "aede7c5e-8bd3-4f07-bad2-c3d159e8c1c5" to ("{additional} engineering location for" to "{additional:additionally} engineered in"),
    // "37ef3a0c-cac3-4172-b09b-4ca98d2857fc" to ("{additional} recording location for" to "{additional:additionally} recorded in"),
    // "eef56d04-852a-4ce6-bfc9-678c19392a16" to ("{additional} mixing location for" to "{additional:additionally} mixed in"),
    // "e24482da-f568-46ba-a428-9fa56615c7b2" to ("{additional} editing location for" to "{additional:additionally} edited in"),
    // "582f6452-ff89-4f3b-9e78-eff5b842e208" to ("{additional} remixing location for" to "{additional:additionally} remixed in"),
    // "93078fc7-6585-40a7-ab7f-6acb9da65b84" to ("{additional} producing location for" to "{additional:additionally} produced in"),
    // "d92ee325-0d37-4d1c-aea1-436f36e13565" to ("{additional} shooting location for" to "{additional:additionally} shot in"),

    // https://musicbrainz.org/relationships/artist-recording
    "f8673e29-02a5-47b7-af61-dd4519328dd0" to ("performance" to "performance"),
    // "628a9658-f54c-4142-b0c0-95f031b544da" to ("{additional:additionally} {guest} {solo} performed" to "{additional} {guest} {solo} performer"),
    // "59054b12-01ac-43ee-a618-285fd397e461" to ("{additional} {guest} {solo} {instrument:%|instruments}" to "{additional} {guest} {solo} {instrument:%|instruments}"),
    // "0fdbe3c6-7700-4a31-ae54-b53f06ae1cfa" to ("{additional} {guest} {solo} {vocal:%|vocals}" to "{additional} {guest} {solo} {vocal:%|vocals}"),
    // "3b6616c5-88ba-4341-b4ee-81ce1e6d7ebb" to ("{additional} orchestra" to "{additional} orchestra"),
    // "234670ce-5f22-4fd0-921b-ef1662695c5d" to ("{additional:additionally} conducted" to "{additional} conductor"),
    // "45115945-597e-4cb9-852f-4e6ba583fcc8" to ("{additional} chorus master" to "{additional} chorus master"),
    // "ffeaa74f-8295-45ee-a2f2-7c0cc1f73b1e" to ("{guest} concertmaster for" to "{guest} concertmaster"),
    // "22661fb8-cdb7-4f67-8385-b2a8be6c9f0d" to ("{additional:additionally} {co:co-}arranged" to "{additional} {co:co-}arranger"),
    // "4820daa1-98d6-4f8b-aa4b-6895c5b79b27" to ("{additional:additionally} {instrument:%|instruments} {co:co-}arranged" to "{additional} {instrument:%|instruments} {co:co-}arranger"),
    // "38fa7405-f9a5-48cb-827a-8ac601933ba0" to ("{additional:additionally} orchestrated" to "{additional} orchestrator"),
    // "8a2799e8-a7e2-41ce-a7da-b5f520687216" to ("{additional:additionally} {vocal:%|vocals} {co:co-}arranged" to "{additional} {vocal:%|vocals} {co:co-}arranger"),
    "91109adb-a5a3-47b1-99bf-06f88130e875" to ("remixes and compilations" to "remixes and compilations"),
    "35ba2b3b-aaeb-4db1-bc5f-f42154e785d8" to ("compiled" to "compiler"),
    "28338ee6-d578-485a-bb53-61dbfd7c6545" to ("DJ-mixed" to "DJ-mixer"),
    // "7950be4d-13a3-48e7-906b-5af562e39544" to ("{additional:additionally} remixed" to "{additional} remixer"),
    // "83f72956-2007-4bca-8a97-0ae539cca99d" to ("produced material that was {additional:additionally} sampled in" to "contains {additional} samples by"),
    "1ef6f500-d098-4768-ad00-72cc2bc2912f" to ("video" to "video"),
    "601fc03e-1058-4ee6-a546-b914d55aa6ba" to ("appears on video" to "visual appearances"),
    "578ee04d-3227-4335-ba2c-11e8ba420e0b" to ("directed video" to "was directed by"),
    "b367fae0-c4b0-48b9-a40c-f3ae4c02cffc" to ("production" to "production"),
    // "5c0ceac3-feb4-41f0-868d-dc06f6e27fc0" to ("{additional:additionally} {assistant} {associate} {co:co-}{executive:executive }produced" to "{additional} {assistant} {associate} {co:co-}{executive:executive }producer"),
    // "5dcc52af-7064-4051-8d62-7d80f4c3c907" to ("{additional:additionally} {assistant} {associate} {co:co-}{executive:executive }engineered" to "{additional} {assistant} {associate} {co:co-}{executive:executive }engineer"),
    // "ca8d6d99-b847-439c-b0ec-33d8a1b942bc" to ("{additional:additionally} {assistant} {associate} {co:co-}audio engineered" to "{additional} {assistant} {associate} {co:co-}audio engineer"),
    // "30adb2d7-dbcc-4393-9230-2098510ce3c1" to ("{additional} {assistant} {associate} {co:co-}mastering" to "{additional} {assistant} {associate} {co:co-}mastering"),
    // "0cd6aa63-c297-42ed-8725-c16d31913a98" to ("{additional:additionally} {assistant} {associate} {co:co-}sound engineered" to "{additional} {assistant} {associate} {co:co-}sound engineer"),
    // "3e3102e1-1896-4f50-b5b2-dd9824e46efe" to ("{additional:additionally} {assistant} {associate} {co:co-}mixed" to "{additional} {assistant} {associate} {co:co-}mixer"),
    // "a01ee869-80a8-45ef-9447-c59e91aa7926" to ("{additional} {assistant} {associate} {co:co-}recording engineer for" to "{additional} {assistant} {associate} {co:co-}recording engineer"),
    "fc9b963a-29fa-4949-b22a-3bffd2440024" to ("field recordist for" to "field recordings"),
    // "36c50022-44e0-488d-994b-33f11d20301e" to ("{additional} {assistant} {associate} {instrument} programming" to "{additional} {assistant} {associate} {instrument} programming"),
    // "40dff87a-e475-4aa6-b615-9935b564d756" to ("{additional:additionally} {assistant} {associate} {co:co-}edited" to "{additional} {assistant} {associate} {co:co-}editor"),
    // "0748fa55-56b5-4ad5-8ce8-15b97f82a0c2" to ("{additional:additionally} {assistant} {associate} {co:co-}balance engineered" to "{additional} {assistant} {associate} {co:co-}balance engineer"),
    "68330a36-44cf-4fa2-84e8-533c6fe3fc23" to ("miscellaneous roles" to "miscellaneous support"),
    "75e37b65-7b50-4080-bf04-8c59c66b5f65" to ("legal representation" to "legal representation"),
    "7fd5fbc0-fbf4-4d04-be23-417d50a4dc30" to ("holds phonographic copyright (℗) for" to "phonographic copyright (℗) by"),
    "b1edc6f6-283d-4e32-b625-b96cfb192056" to ("booking" to "booking"),
    "8dc10cef-3116-4b3d-8e3e-33ffb84a97df" to ("artist & repertoire support" to "artist & repertoire support"),
    // "0eb67a3e-796b-4394-ab6e-1224f43236b6" to ("{additional} creative direction" to "{additional} creative direction"),
    // "9aae9a3d-7cc2-4eee-881d-b8b73d0ceef3" to ("{additional} art direction" to "{additional} art direction"),
    // "4af8e696-2690-486f-87db-bc8ec2bfe859" to ("{additional} design/illustration" to "{additional} design/illustration"),
    // "38751410-ee52-435b-af75-957cb4c34149" to ("{additional} graphic design" to "{additional} graphic design"),
    // "a7e408a1-8c64-4122-9ec2-906068955187" to ("{additional} photography" to "{additional} photography"),
    // "e88fefc3-042b-4f28-83af-6a79793b630b" to ("{instrument:%|instruments} technician for" to "{instrument:%|instruments} technician"),
    "9ef2ba0d-953c-43a9-b1b5-cf2ba5986406" to ("published" to "publisher"),

    // https://musicbrainz.org/relationships/event-recording
    "b06e6732-2603-47d3-8a49-9f589b430483" to ("recording location for" to "recorded at"),
    // "0c050cf9-885b-49fe-9a12-5ca04e2db8da" to ("{additional:additionally} shot for" to "{additional:additionally} shot at"),

    // https://musicbrainz.org/relationships/genre-recording
    // No relationships.

    // https://musicbrainz.org/relationships/instrument-recording
    // No relationships.

    // https://musicbrainz.org/relationships/label-recording
    "fd841726-ba3c-47f7-af8e-6734ab6243ff" to ("holds phonographic copyright (℗) for" to "phonographic copyright (℗) by"),
    "51e4a303-8215-4db6-9a9f-ebe95442dbef" to ("published" to "publisher"),
    "4f331532-eb4b-4057-a19d-e789d1b15a32" to ("contracted tasks" to "contracted tasks"),
    "1a26bf37-1f34-4c9a-97d5-b96bc49e9153" to ("contracted arrangement for" to "arranged for"),
    "e43d91b4-23d8-4a20-848f-1e1a392e23f0" to ("contracted mixing for" to "mixed for"),
    // "ce1529b0-2fd9-4dcc-82d2-4036a044b5b9" to ("contracted {co:co-}{executive:executive }production for" to "{co:co-}{executive:executive }produced for"),
    "57935ae5-9f21-47bc-9854-0fa5d1a56696" to ("miscellaneous roles" to "miscellaneous support"),

    // https://musicbrainz.org/relationships/place-recording
    "ce8dbff2-0f07-45f3-8b7c-2ea40d82cbfe" to ("arranging location for" to "arranged at"),
    // "f845a95e-b2b5-4a94-9645-fc8b031ab0bd" to ("{additional} engineering location for" to "{additional:additionally} engineered at"),
    // "ad462279-14b0-4180-9b58-571d0eef7c51" to ("{additional} recording location for" to "{additional:additionally} recorded at"),
    // "11d74801-1493-4a5d-bc0f-4ddc537acddb" to ("{additional} mixing location for" to "{additional:additionally} mixed at"),
    // "069c1cf0-a9b2-448e-8486-1eced48b48f9" to ("{additional} editing location for" to "{additional:additionally} edited at"),
    // "88183045-b769-48ba-a55c-c58450903241" to ("{additional} remixing location for" to "{additional:additionally} remixed at"),
    // "6bc3827d-bc20-4621-ae14-9c3707ad140a" to ("{additional} producing location for" to "{additional:additionally} produced at"),
    // "07e6b4eb-5891-4646-b167-f96c5a4ccc77" to ("{additional} shooting location for" to "{additional:additionally} shot at"),

    // https://musicbrainz.org/relationships/recording-recording
    "6a76ad99-cc5d-4ebc-a6e4-b2eb2eb3ad98" to ("other versions" to "other versions"),
//    "Few relationships (0)" to ("karaoke versions" to "karaoke version of"),
    "ce01b3ac-dd47-4702-9302-085344f96e84" to ("edit of" to "edits"),
    "ce3de655-7451-44d1-9224-87eb948c205d" to ("music videos" to "music video for"),
    "f5f41b82-ecc7-488e-adf3-12356885d724" to ("later releases" to "earliest release"),
    "b984b8d1-76f9-43d7-aa3e-0b3a46999dea" to ("remaster of" to "remasters"),
    "1baddd63-4539-4d49-ae43-600df9ef4647" to ("remixes and compilations" to "remixes and compilations"),
    "1b6311e8-5f81-43b7-8c55-4bbae71ec00c" to ("compilation of" to "compiled in"),
    "451076df-61cf-46ab-9921-555cab2f050d" to ("DJ-mix of" to "DJ-mixes"),
    "bfbdb55a-b857-473a-8f2e-a9c09e45c3f5" to ("remix of" to "has remixes"),
    // "9efd9ce9-e702-448b-8e76-641515e8fe62" to ("{additional} samples" to "{additional:additionally} sampled by"),
    "579d0b4c-bf77-479d-aa59-a8af1f518958" to ("mash-up of" to "mash-ups"),

    // https://musicbrainz.org/relationships/area-release
    "d59c5121-7d6c-4965-9fa8-ab47b7d59012" to ("arranging location for" to "arranged in"),
    // "3a24272b-3273-456a-9be8-421580513d4b" to ("{additional} engineering location for" to "{additional:additionally} engineered in"),
    // "354043e1-bdc2-4c7f-b338-2bf9c1d56e88" to ("{additional} recording location for" to "{additional:additionally} recorded in"),
    // "653b7420-c418-4bdc-83a5-6b2f44a65915" to ("{additional} mixing location for" to "{additional:additionally} mixed in"),
    // "ee380877-3636-462b-b407-ab39370a787e" to ("{additional} {re}mastering location for" to "{additional:additionally} {re}mastered in"),
    "2d9a192c-cd30-4110-a99e-481c56a0ce70" to ("lacquer cut location for" to "lacquer cut in"),
    // "e42af9dd-4203-480c-9178-ee4f67ba2609" to ("{additional} editing location for" to "{additional:additionally} edited in"),
    // "5147db55-6240-4479-bfa9-0589455f1c50" to ("{additional} remixing location for" to "{additional:additionally} remixed in"),
    // "8d60be20-959c-4f5b-85f6-2b1f44321d11" to ("{additional} producing location for" to "{additional:additionally} produced in"),
    "c0998b44-aa21-4d27-be79-2ff64205cecd" to ("manufacturing location for" to "manufactured in"),
    "0123b87a-5b31-4cd7-9df7-03f885bfd90c" to ("printing location for" to "printed in"),

    // https://musicbrainz.org/relationships/artist-release
    "8db9d0b7-ca39-43a6-8c72-9a47f811229e" to ("performance" to "performance"),
    // "888a2320-52e4-4fe8-a8a0-7a4c8dfde167" to ("{additional:additionally} {guest} {solo} performed" to "{additional} {guest} {solo} performer"),
    // "67555849-61e5-455b-96e3-29733f0115f5" to ("{additional} {guest} {solo} {instrument:%|instruments}" to "{additional} {guest} {solo} {instrument:%|instruments}"),
    // "eb10f8a0-0f4c-4dce-aa47-87bcb2bc42f3" to ("{additional} {guest} {solo} {vocal:%|vocals}" to "{additional} {guest} {solo} {vocal:%|vocals}"),
    // "23a2e2e7-81ca-4865-8d05-2243848a77bf" to ("{additional} orchestra" to "{additional} orchestra"),
    // "9ae9e4d0-f26b-42fb-ab5c-1149a47cf83b" to ("{additional:additionally} conducted" to "{additional} conductor"),
    // "b9129850-73ec-4af5-803c-1c12b97e25d2" to ("{additional} chorus master" to "{additional} chorus master"),
    // "8a2b1c46-0fe5-42f7-9d72-f68604244c1d" to ("{guest} concertmaster for" to "{guest} concertmaster"),
    "d6b8f1d2-5431-4c97-9688-44f73213ee5b" to ("remixes and compilations" to "remixes and compilations"),
    "2f81887a-8674-4d8b-bd48-8bfd4c6fa332" to ("compiled" to "compiler"),
    // "9162dedd-790c-446c-838e-240f877dbfe2" to ("DJ-mixed {medium}" to "DJ-mixer {medium}"),
    // "ac6a86db-f757-4815-a07e-744428d2382b" to ("{additional:additionally} remixed" to "{additional} remixer"),
    // "7ddb04ae-6c8a-41bd-95c2-392994d663db" to ("produced material that was {additional:additionally} sampled in" to "contains {additional} samples by"),
    "800a8a16-5426-4f4e-8dd6-9371d8bc8398" to ("composition" to "composition"),
    // "ca7a474a-a1cd-4431-9230-56a17f553090" to ("{additional:additionally} wrote" to "{additional} writer"),
    // "01ce32b0-d873-4baa-8025-714b45c0c754" to ("{additional:additionally} composed" to "{additional} composer"),
    // "a2af367a-b040-46f8-af21-310f92dfe97b" to ("{additional} lyrics" to "{additional} lyricist"),
    // "dd182715-ca2b-4e4b-80b1-d21742fda0dc" to ("{additional} librettist" to "{additional} librettist"),
    // "4db37fec-eb67-45d3-b4fa-148a68135fbb" to ("translated" to "{additional} translator"),
    // "34d5334e-a4c8-4b65-a5f8-bbcc9c81d13d" to ("{additional:additionally} {co:co-}arranged" to "{additional} {co:co-}arranger"),
    // "18f159bb-44f0-4aef-b198-a4736ad9b659" to ("{additional:additionally} {instrument:%|instruments} {co:co-}arranged" to "{additional} {instrument:%|instruments} {co:co-}arranger"),
    // "04e1f0b6-ef40-4168-ba25-42a87729fe09" to ("{additional:additionally} orchestrated" to "{additional:additionally} orchestrator"),
    // "d7d9128d-e676-4d8f-a353-f48a55a98501" to ("{additional:additionally} {vocal:%|vocals} {co:co-}arranged" to "{additional} {vocal:%|vocals} {co:co-}arranger"),
    "3172a175-7c9d-44ce-a8b7-9a9187b33762" to ("production" to "production"),
    // "8bf377ba-8d71-4ecc-97f2-7bb2d8a2a75f" to ("{additional:additionally} {assistant} {associate} {co:co-}{executive:executive }produced" to "{additional} {assistant} {associate} {co:co-}{executive:executive }producer"),
    // "87e922ba-872e-418a-9f41-0a63aa3c30cc" to ("{additional:additionally} {assistant} {associate} {co:co-}{executive:executive }engineered" to "{additional} {assistant} {associate} {co:co-}{executive:executive }engineer"),
    // "b04848d7-dbd9-4be0-9d8c-13df6d6e40db" to ("{additional:additionally} {assistant} {associate} {co:co-}audio engineered" to "{additional} {assistant} {associate} {co:co-}audio engineer"),
    // "84453d28-c3e8-4864-9aae-25aa968bcf9e" to ("{additional} {assistant} {associate} {co:co-}{re}mastering" to "{additional} {assistant} {associate} {co:co-}{re}mastering"),
    "904e57f3-cbbc-43ab-8798-13e710e400d3" to ("lacquer cut" to "lacquer cut"),
    // "271306ca-c77f-4fe0-94bc-dd4b87ae0205" to ("{additional:additionally} {assistant} {associate} {co:co-}sound engineered" to "{additional} {assistant} {associate} {co:co-}sound engineer"),
    // "6cc958c0-533b-4540-a281-058fbb941890" to ("{additional:additionally} {assistant} {associate} {co:co-}mixed" to "{additional} {assistant} {associate} {co:co-}mixer"),
    // "023a6c6d-80af-4f88-ae69-f5f6213f9bf4" to ("{additional} {assistant} {associate} {co:co-}recording engineer for" to "{additional} {assistant} {associate} {co:co-}recording engineer"),
    "d92d4280-e288-4268-81ca-4c7252dfe7c3" to ("field recordist for" to "field recordings"),
    // "617063ad-dbb5-4877-9ba0-ba2b9198d5a7" to ("{additional} {assistant} {associate} {instrument} programming" to "{additional} {assistant} {associate} {instrument} programming"),
    // "f30c29d3-a3f1-420d-9b6c-a750fd6bc2aa" to ("{additional:additionally} {assistant} {associate} {co:co-}edited" to "{additional} {assistant} {associate} {co:co-}editor"),
    // "97169e5e-c978-486e-a5ea-da353ca9ea42" to ("{additional:additionally} {assistant} {associate} {co:co-}balance engineered" to "{additional} {assistant} {associate} {co:co-}balance engineer"),
    "0b63af5e-85b2-4891-8234-bddab251399d" to ("miscellaneous roles" to "miscellaneous support"),
    "730b5251-7432-4896-8fc6-e1cba943bfe1" to ("holds copyright (©) for" to "copyrighted (©) by"),
    "01d3488d-8d2a-4cff-9226-5250404db4dc" to ("holds phonographic copyright (℗) for" to "phonographic copyright (℗) by"),
    "b0f98226-7121-4db5-a69c-552e6d061da2" to ("booking" to "booking"),
    // "1a900189-53ba-442a-9406-49c43ddecb3f" to ("{additional} legal representation" to "{additional} legal representation"),
    "eaaf08cf-a698-4e3b-a871-f9570f8fdab1" to ("licensed" to "licensed from"),
    // "f3b80a09-5ebf-4ad2-9c46-3e6bce971d1b" to ("{additional} art direction" to "{additional} art direction"),
    // "5acef56d-e676-4b4d-a581-db5d36afd213" to ("{additional} artwork" to "{additional} artwork"),
    // "9c02ea37-7680-4fb5-8555-e330c7aa885b" to ("{additional} design" to "{additional} design"),
    // "cf43b79e-3299-4b0c-9244-59ea06337107" to ("{additional} graphic design" to "{additional} graphic design"),
    // "a6029157-d96b-4dc3-9f73-f99f76423d11" to ("{additional} illustration" to "{additional} illustration"),
    // "307e95dd-88b5-419b-8223-b146d4a0d439" to ("{additional} design/illustration" to "{additional} design/illustration"),
    "74518a6b-589d-460e-8dd7-a8383851040a" to ("booklet editor for" to "booklet editor"),
    // "0b58dc9b-9c49-4b19-bb58-9c06d41c8fbf" to ("{additional} photography" to "{additional} photography"),
    // "bd780597-0b67-4b97-a4a0-671a70e1182d" to ("{instrument:%|instruments} technician for" to "{instrument:%|instruments} technician"),
    "7a573a01-8815-44db-8e30-693faa83fbfa" to ("published" to "publisher"),
    // "01323b4f-7aba-410c-8c91-cb224b963a40" to ("{additional} liner notes {translator}" to "{additional} liner notes {translator}"),

    // https://musicbrainz.org/relationships/event-release
    "de1f976a-d6af-342d-9220-d2485284e502" to ("available releases" to "available at"),
    "83205d04-c74d-3165-a956-567c27869cdc" to ("launch event for" to "launch events"),
    "4dda6e40-14af-46bb-bb78-ea22f4a99dfa" to ("recording location for" to "recorded at"),

    // https://musicbrainz.org/relationships/genre-release
    // No relationships.

    // https://musicbrainz.org/relationships/instrument-release
    // No relationships.

    // https://musicbrainz.org/relationships/label-release
    "cee6eeeb-14f5-4079-9789-632b46acfd33" to ("business association" to "business association with"),
    "2ed5a497-4f85-4b3f-831e-d341ad28c544" to ("holds copyright (©) for" to "copyrighted (©) by"),
    "287361d2-1dce-4d39-9f82-222b786e2b30" to ("holds phonographic copyright (℗) for" to "phonographic copyright (℗) by"),
    "e77cb4ab-a438-43ad-9200-0d9bbf68b378" to ("licensee for" to "licensed to"),
    "45a18e5d-b610-412f-acfc-c43ca835c24f" to ("licensed" to "licensed from"),
    "25858332-bf31-4ad6-85b6-6a3bccebf02e" to ("published" to "publisher"),
    "4f89b0a1-e135-41e4-94a7-e3d2a95f31a1" to ("distributed" to "distributed by"),
    "835e514a-c5bc-44f7-be7b-92452a3f5d60" to ("manufactured" to "manufactured by"),
    "3106fe97-193d-4c9c-b93d-9861e03e9cc8" to ("glass mastered" to "glass mastered by"),
    "c55ab145-0618-4465-8034-b5c6742bbe9e" to ("pressed" to "pressed by"),
    "543a0464-52f0-4282-b8b0-080ca03395a0" to ("marketed" to "marketed by"),
    "f723f293-27b1-4c90-a623-6bacd0534465" to ("printed" to "printed by"),
    "b60d9455-aba8-4d81-b543-dbfa68044dcc" to ("promoted" to "promoted by"),
    "06fc3d02-ae89-4566-ad49-624500d6beb7" to ("rights society associated with" to "rights society"),
    "19585b83-6783-4dff-9e4a-0ca56fe0ee8a" to ("contracted tasks" to "contracted tasks"),
    "c395de60-b84b-4a09-99b2-30b222fda04e" to ("contracted arrangement for" to "arranged for"),
    "4d79a32f-7295-4b39-882f-cc6371e5493a" to ("contracted manufacturing for" to "manufactured for"),
    "17976e73-51a2-4174-9004-3baaba6b78c6" to ("contracted mixing for" to "mixed for"),
    // "a4c3fb3a-66f8-4362-9507-bb846fe86b64" to ("contracted {co:co-}{executive:executive }production for" to "{co:co-}{executive:executive }produced for"),
    "2266eb23-5fab-4aa3-8d2c-ad6d42df8568" to ("miscellaneous roles" to "miscellaneous support"),

    // https://musicbrainz.org/relationships/place-release
    "03a9e95d-986f-40e4-985d-7487bfccfbb2" to ("arranging location for" to "arranged at"),
    // "b35aae66-5578-41d1-b34b-1c9b1897ad49" to ("{additional} engineering location for" to "{additional:additionally} engineered at"),
    // "3b1fae9f-5b22-42c5-a40c-d1e5c9b90251" to ("{additional} recording location for" to "{additional:additionally} recorded at"),
    // "8ebfc2f6-0ac7-40f6-b03e-67fe3428f5d4" to ("{additional} mixing location for" to "{additional:additionally} mixed at"),
    // "5d075afa-6bb8-4327-9528-e3e4d3d68f49" to ("{additional} {re}mastering location for" to "{additional:additionally} {re}mastered at"),
    "e87ae6d1-4453-4e73-aa29-86a6badc1f1d" to ("lacquer cut location for" to "lacquer cut at"),
    // "9b678c30-453a-47c4-8f69-9ba96b2c5e9c" to ("{additional} editing location for" to "{additional:additionally} edited at"),
    // "32af03cf-8879-4d07-b7c2-68c6cbf060bd" to ("{additional} remixing location for" to "{additional:additionally} remixed at"),
    // "1c73465d-9bf7-41f4-bcb6-fb1852ffa64c" to ("{additional} producing location for" to "{additional:additionally} produced at"),
    "3de9787f-c148-4b4f-b4bf-cb9a2616a092" to ("manufacturing location for" to "manufactured at"),
    "d3709732-c488-45e9-9b46-ca15c50de552" to ("glass mastering location for" to "glass mastered at"),
    "eabf5903-8467-4329-b905-7504336e8241" to ("pressing location for" to "pressed at"),

    // https://musicbrainz.org/relationships/recording-release
    // "967746f9-9d79-456c-9d1e-50116f0b27fc" to ("{additional} samples from" to "{additional:additionally} sampled by"),

    // https://musicbrainz.org/relationships/release-release
    "3676d4aa-2fa7-435f-b83f-cdbbe4740938" to ("covers or other versions" to "covers or other versions"),
    "fc399d47-23a7-4c28-bfcf-0607a562b644" to ("transliterated/translated track listings" to "transliterated/translated track listing of"),
    "48e327b5-2d04-4518-93f1-fed5f0f0fa3c" to ("remaster of" to "remastered versions"),
    "7918eb7f-bfb0-4245-91fd-3a0e86e13841" to ("replaced by" to "replaced"),
    "7ad3c97e-e524-4d9a-a384-2b1407f4939b" to ("released in support of" to "supporting releases"),
    // "6d08ec1e-a292-4dac-90f3-c398a39defd5" to ("{bonus:bonus|next} disc" to "previous disc"),

    // https://musicbrainz.org/relationships/area-release_group
    // No relationships.

    // https://musicbrainz.org/relationships/artist-release_group
    "5e2907db-49ec-4a48-9f11-dfb99d2603ff" to ("tribute albums" to "tribute to"),
    "b41e7530-cde4-459c-b8c5-dfef08fc8295" to ("dedications" to "dedicated to"),
    "25dd0db4-189f-436c-a610-aacb979f13e2" to ("artist & repertoire support" to "artist & repertoire support"),
    // "e035ac25-a2ff-48a6-9fb6-077692c67241" to ("{additional} creative direction" to "{additional} creative direction"),
    "cee8e577-6fa6-4d77-abc0-35bce13c570e" to ("named after" to "inspired the name of"),

    // https://musicbrainz.org/relationships/event-release_group
    "5db276a9-15d2-3955-b5d9-c11f27fd8b44" to ("launch event for" to "launch events"),
    "a64a9085-505b-4588-bff9-214d7dda61c4" to ("performance of" to "performed at"),

    // https://musicbrainz.org/relationships/genre-release_group
    // No relationships.

    // https://musicbrainz.org/relationships/instrument-release_group
    // No relationships.

    // https://musicbrainz.org/relationships/label-release_group
    "a55095e6-5fd1-4a92-963e-75078a3c28b7" to ("tribute albums" to "tribute to"),

    // https://musicbrainz.org/relationships/place-release_group
    // No relationships.

    // https://musicbrainz.org/relationships/recording-release_group
    // No relationships.

    // https://musicbrainz.org/relationships/release-release_group
    // No relationships.

    // https://musicbrainz.org/relationships/release_group-release_group
    "38278b3b-30e6-304c-b0db-5ba701eb0268" to ("covers or other versions" to "covers or other versions"),
    "62beff0a-679c-43f3-8fe6-f6c8ed8581e4" to ("live performance of" to "live performances"),
    "7c303515-05a8-46fc-baae-d15d76cef286" to ("translated versions" to "translated version of"),
    // "Few relationships (0)" to ("{translated} {parody:parody|cover} of" to "{translated} {parody:parodies|covers}"),
    "3494ba38-4ac5-40b6-aa6f-4ac7546cd104" to ("remixes and compilations" to "remixes and compilations"),
    "d3286b50-a9d9-4cc3-94ad-cd7e2ffc787a" to ("DJ-mix of" to "DJ-mixed versions"),
    "04e0449b-6fb0-48f6-8b9d-0bd41d9b8d76" to ("remix of" to "remixes"),
    "03786c2a-cd9d-4148-b3ea-35ea61de1283" to ("mash-up of" to "mash-ups"),
    "fcf680a9-6871-4519-8c4b-8c6549575b35" to ("single/EP which was taken from" to "associated singles/EPs"),
    "589447ea-be2c-46cc-b9e9-469e1d06e18a" to ("included in" to "includes"),

    // https://musicbrainz.org/relationships/area-series
    "281bf307-f1e8-4a56-a7b8-fe8304bb2bf3" to ("location for" to "held in"),

    // https://musicbrainz.org/relationships/artist-series
    "d1a845d1-8c03-3191-9454-e4e8d37fa5e0" to ("part of" to "has parts"),
    "fc2d925d-eb65-4a08-a39c-26fb5cfbdf81" to ("event artists" to "event artists"),
    "bf846051-084c-4c49-b0af-17c61c428572" to ("founded" to "founded by"),
    "d5ea820c-4f2f-441a-878d-1715158ec111" to ("residencies" to "residency by"),
    "f03d59f3-97db-424b-885e-e8be69d65225" to ("tours" to "tour by"),
    "3673c88b-988b-47c3-a82c-4116fd2b2e1e" to ("inspired the name of" to "named after"),
    "d6cbe0fd-e457-4387-a7ec-450cd0a4e293" to ("work cataloguing" to "work cataloguing"),
    "2a1b5f1d-b712-4791-8079-57f95ce197d7" to ("catalogued" to "cataloguer"),
    "b792d0a6-a443-4e00-8882-c4f2bef56511" to ("has catalogue" to "catalogues work of"),

    // https://musicbrainz.org/relationships/event-series
    "707d947d-9563-328a-9a7d-0c5b9c3a9791" to ("part of" to "has parts"),

    // https://musicbrainz.org/relationships/genre-series
    // No relationships.

    // https://musicbrainz.org/relationships/instrument-series
    // No relationships.

    // https://musicbrainz.org/relationships/label-series
    "1cd0342c-69a1-4f97-8471-46748f8ecde1" to ("publishes series" to "publishing label"),

    // https://musicbrainz.org/relationships/place-series
    "0f5c1077-bea7-4a00-ad65-89dd1972fe76" to ("location for" to "held at"),

    // https://musicbrainz.org/relationships/recording-series
    "ea6f0698-6782-30d6-b16d-293081b66774" to ("part of" to "has parts"),
    "1640c657-d614-47cf-8161-b93809c9b88b" to ("recorded during" to "recorded recordings"),

    // https://musicbrainz.org/relationships/release-series
    "3fa29f01-8e13-3e49-9b0a-ad212aa2f81d" to ("part of" to "has parts"),

    // https://musicbrainz.org/relationships/release_group-series
    "01018437-91d8-36b9-bf89-3f885d53b5bd" to ("part of" to "has parts"),
    "c610b838-612f-4d9d-8527-0e59849b7d7e" to ("recorded during" to "recorded release groups"),
    // "72e1f4d8-011b-49ab-bba4-6990981c972e" to ("{anniversary:anniversary tours|supporting tours}" to "{anniversary:anniversary tour for|tour in support of}"),

    // https://musicbrainz.org/relationships/series-series
    "a3af4c16-de83-4d63-b9b8-77e074c9babe" to ("subseries" to "subseries of"),
    "b738cb29-0c23-4c1e-9bba-4934ea0d3f7f" to ("recorded during" to "recorded music series"),

    // https://musicbrainz.org/relationships/area-url
    "b879051b-10e6-43b4-a49a-efdecc695f02" to ("other databases" to "other databases"),
    "c52f14c0-e9ac-4a8a-8f7a-c47328de168f" to ("Geonames" to "Geonames page for"),
    "85c5256f-aef1-484f-979a-42007218a1c2" to ("Wikidata" to "Wikidata page for"),
    "9228621d-9720-35c3-ad3f-327d789464ec" to ("Wikipedia" to "Wikipedia page for"),

    // https://musicbrainz.org/relationships/artist-url
    "fe33d22f-c3b0-4d68-bd53-a856badf2b15" to ("official homepages" to "official homepage for"),
    "d0c5cf3a-8afb-4d24-ad47-00f43dc509fe" to ("discography" to "discography"),
    "f484f897-81cc-406e-96f9-cd799a04ee24" to ("fan pages" to "fan page for"),
    "78f75830-94e1-4138-8f8a-643e3bb21ce5" to ("biographies" to "biography of"),
    "4fb0eeec-a6eb-4ae3-ad52-b55765b94e8f" to ("discography pages" to "discography page for"),
    "d028a975-000c-4525-9333-d3c8425e4b54" to ("BBC Music" to "BBC Music page for"),
    "1f171391-1f98-4f45-b191-038ec3b12395" to ("interviews" to "interview with"),
    "221132e9-e30e-43f2-a741-15afc4c5fa7c" to ("picture" to "picture of"),
    "e4d73442-3762-45a8-905c-401da65544ed" to ("lyrics page" to "lyrics page for"),
    "07ae9b01-c09a-4460-8693-85479c1e96c3" to ("online data" to "online data"),
    "99429741-f3f6-484b-84f8-23af51991770" to ("social networking" to "social networking page for"),
    "bac47923-ecde-4b59-822e-d08f0cd10156" to ("Myspace" to "Myspace page for"),
    "b6f02157-a9d3-4f24-9057-0675b2dbc581" to ("PureVolume" to "PureVolume page for"),
    "89e4a949-0976-440d-bda1-5f772c1e5710" to ("SoundCloud" to "SoundCloud page for"),
    "d86c9450-b6d0-4760-a275-e7547495b48b" to ("video channel" to "video channel for"),
    "6a540e5b-58c6-4192-b6ba-dbc71ec8fcf0" to ("YouTube channels" to "YouTube channel for"),
    "35b3a50f-bf0e-4309-a3b4-58eeed8cee6a" to ("online communities" to "online community page for"),
    "eb535226-f8ca-499d-9b18-6a144df4ae6f" to ("blogs" to "blog of"),
    "93883cf6-e818-4938-990e-75863f8db2d3" to ("crowdfunding page" to "crowdfunding page for"),
    "6f77d54e-1d81-4e1a-9ea5-37947577151b" to ("patronage page" to "patronage page for"),
    "919db454-212f-495a-a9bb-f69631729953" to ("get the music" to "get the music"),
    "611b1862-67af-4253-a64f-34adba305d1d" to ("purchase music for mail-order" to "mail-order purchase page for"),
    "f8319a2f-f824-4617-81c8-be6560b3b203" to ("purchase music for download" to "download purchase page for"),
    "34ae77fe-defb-43ea-95d4-63c7540bac78" to ("download music for free" to "free download page for"),
    "769085a1-c2f7-4c24-a532-2375a77693bd" to ("stream for free" to "free music streaming page for"),
    "63cc5d1f-f096-4c94-a43f-ecb32ea94161" to ("streaming page" to "streaming page for"),
    "c550166e-0548-4a18-b1d4-e2ae423a3e88" to ("Bandcamp" to "Bandcamp page for"),
    "4c21e5f5-2960-4abc-88a1-62ce491bb96e" to ("CD Baby" to "CD Baby page for"),
    "631712a0-7525-42ba-b7a3-605aa7a238c4" to ("YouTube Music" to "YouTube Music channel for"),
    "d94fb61c-fa20-4e3c-a19a-71a949fb2c55" to ("other databases" to "other databases"),
    "6b3e3c85-0002-4f34-aca6-80ace0d7e846" to ("Allmusic" to "Allmusic page for"),
    "ea45ed3d-2d5e-456e-8c32-94b6f51426e2" to ("Bandsintown" to "Bandsintown page for"),
    "f82f9342-a08d-46b7-ab7a-d8b6330c805d" to ("BookBrainz" to "BookBrainz page for"),
    "991d7d60-01ee-41de-9b62-9ef3f86c2447" to ("CPDL" to "CPDL page for"),
    "04a5b104-a4c2-4bac-99a1-7b837c37d9e4" to ("Discogs" to "Discogs page for"),
    "94c8b0cc-4477-4106-932c-da60e63de61c" to ("IMDb" to "IMDb page for"),
    "8147b6a2-ad14-4ce7-8f0a-697f9a31f68f" to ("IMSLP" to "IMSLP page for"),
    "08db8098-c0df-4b78-82c3-c8697b4bba7f" to ("Last.fm" to "Last.fm page for"),
    "79c5b84d-a206-4f4c-9832-78c028c312c3" to ("SecondHandSongs" to "SecondHandSongs page for"),
    "bf5d0d5e-27a1-4e94-9df7-3cdc67b3b207" to ("setlist.fm" to "setlist.fm page for"),
    "aac9c4bc-a5b9-30b8-9839-e3ac314c6e58" to ("Songkick" to "Songkick page for"),
    "0af15ab3-c615-46d6-b95b-a5fcd2a92ed9" to ("VGMdb" to "VGMdb page for"),
    "e8571dcc-35d4-4e91-a577-a3382fd84460" to ("VIAF ID" to "VIAF ID for"),
    "689870a4-a1e4-4912-b17f-7b2664215698" to ("Wikidata" to "Wikidata page for"),
    "29651736-fa6d-48e4-aadc-a557c6add1cb" to ("Wikipedia" to "Wikipedia page for"),

    // https://musicbrainz.org/relationships/event-url
    "c26808b0-4e67-31a7-a587-913720dfb3f3" to ("official homepages" to "official homepage for"),
    "61187747-04d3-4d15-889a-0ceedaecf0aa" to ("crowdfunding page" to "crowdfunding page for"),
    "f0f05915-64ac-45fb-a9b3-1bf24cd191d9" to ("patronage page" to "patronage page for"),
    "ca7ada80-bf87-4422-9671-ec0a22733acc" to ("poster" to "poster for"),
    "30ee8e92-5722-4dd7-943c-a2fa82b9aff4" to ("reviews" to "review page for"),
    "68f5fcaa-b58c-3bfe-9b7c-75c2b56e839a" to ("social networking" to "social networking page for"),
    "1f3df2eb-3d0b-44f1-9599-1309c692bc7c" to ("video channel" to "video channel for"),
    "fea46163-dc45-3af9-917e-1798f325d21a" to ("YouTube channels" to "YouTube channel for"),
    "1e06fb0b-831d-49cf-abfd-52acb5b56e05" to ("other databases" to "other databases"),
    "81bc32b3-7039-486a-a92f-52486fb7e162" to ("Bandsintown" to "Bandsintown page for"),
    "fd86b01d-c8f7-4f0a-a077-81855a9cfeef" to ("Last.fm" to "Last.fm page for"),
    "027fce0c-c621-4fd1-b728-1678ae08f280" to ("setlist.fm" to "setlist.fm page for"),
    "125afc57-4d33-3b63-ab41-848a3a18d3a6" to ("Songkick" to "Songkick page for"),
    "5d3e0348-71a8-3dc1-b847-3a8f1d5de688" to ("VGMdb" to "VGMdb page for"),
    "b022d060-e6a8-340f-8c73-6b21b1d090b9" to ("Wikidata" to "Wikidata page for"),
    "08a982f7-d754-39b2-8315-d7cae474c641" to ("Wikipedia" to "Wikipedia page for"),

    // https://musicbrainz.org/relationships/genre-url
    "ec1bf02b-a941-4a5e-b0f1-ae97093061dd" to ("get the music" to "get the music"),
    "ad28869f-0f9e-4bd5-b786-70125cc69c3c" to ("Bandcamp" to "Bandcamp page for"),
    "1873eeea-f2e6-4e08-a754-cc92567983ea" to ("other databases" to "other databases"),
    "6da144de-911b-49c5-81eb-bd8303b3f6b4" to ("Allmusic" to "Allmusic page for"),
    "4c8510c9-1dc2-49b9-9693-27bdc5cc8311" to ("Discogs" to "Discogs page for"),
    "11a13c3b-15cb-4c1c-accc-0417f7f2019b" to ("Wikidata" to "Wikidata page for"),

    // https://musicbrainz.org/relationships/instrument-url
    "f64eacbd-1ea1-381e-9886-2cfb552b7d90" to ("picture" to "picture of"),
    "0e62afec-12f3-3d0f-b122-956207839854" to ("information page" to "information page"),
    "41930af2-cb94-488d-a4f0-d232f6ef391a" to ("other databases" to "other databases"),
    "1486fccd-cf59-35e4-9399-b50e2b255877" to ("Wikidata" to "Wikidata page for"),
    "b21fd997-c813-3bc6-99cc-c64323bd15d3" to ("Wikipedia" to "Wikipedia page for"),

    // https://musicbrainz.org/relationships/label-url
    "fe108f43-acb9-4ad1-8be3-57e6ec5b17b6" to ("official homepages" to "official homepage for"),
    "9eb3977f-2aa2-41dd-bbff-0cadda5ad484" to ("lyrics page" to "lyrics page for"),
    "5f82afae-0473-458d-9f17-8a2fa1ce7918" to ("online data" to "online data"),
    "1b431eba-0d25-4f27-9151-1bb607f5c8f8" to ("blogs" to "blog of"),
    "5261835c-0c23-4a63-94db-ad3a86bda846" to ("history page" to "history page for"),
    "5ac35a29-d29b-4390-b279-587bcd42fc73" to ("catalog of records" to "catalog of records"),
    "b35f7822-bf3c-4148-b306-fb723c63ee8b" to ("logos" to "logo of"),
    "6b91b233-a68c-4854-ba33-3b9ae27f86ae" to ("fan pages" to "fan page for"),
    "16f681e4-93c9-4888-ae5e-3163f01269ab" to ("crowdfunding page" to "crowdfunding page for"),
    "e3d9c283-0146-4d91-9471-1b491a9c17ef" to ("patronage page" to "patronage page for"),
    "5d217d99-bc05-4a76-836d-c91eec4ba818" to ("social networking" to "social networking page for"),
    "240ba9dc-9898-4505-9bf7-32a53a695612" to ("Myspace" to "Myspace page for"),
    "a31d05ba-3b82-47b2-ab8b-1fe73b5459e2" to ("SoundCloud" to "SoundCloud page for"),
    "20ad367c-cba0-4c02-bd61-2df3ae8cc799" to ("video channel" to "video channel for"),
    "d9c71059-ba9d-4135-b909-481d12cf84e3" to ("YouTube channels" to "YouTube channel for"),
    "a6874915-b6a3-42ef-82af-6ba800d1e940" to ("get the music" to "get the music"),
    "607deff9-31a8-4b8c-a971-d873cf59ef16" to ("purchase music for mail-order" to "mail-order purchase page for"),
    "dc1a65f4-6458-4f3d-bbb1-57e58668d6e7" to ("purchase music for download" to "download purchase page for"),
    "46505eea-05d6-48cc-ad78-1f79abc556e1" to ("download music for free" to "free download page for"),
    "5b3d2907-5cd0-459b-9a33-d4398a544388" to ("stream for free" to "free music streaming page for"),
    "cbe05bdd-a877-4cc6-8060-7ba43a2516ef" to ("streaming page" to "streaming page for"),
    "c535de4c-a112-4974-b138-5e0daa56eab5" to ("Bandcamp" to "Bandcamp page for"),
    "83eca2b3-5ae1-43f5-a732-56fa9a8591b1" to ("other databases" to "other databases"),
    "b7be2ca4-bdb7-4d87-9619-f2fa50120409" to ("BookBrainz" to "BookBrainz page for"),
    "5b987f87-25bc-4a2d-b3f1-3618795b8207" to ("Discogs" to "Discogs page for"),
    "dfd36bc7-0c06-49fa-8b79-96978778c716" to ("IMDb" to "IMDb page for"),
    "e3390a1d-3083-4bc9-9295-aff9da18612c" to ("Last.fm" to "Last.fm page for"),
    "e46c1166-2aae-4623-ade9-34bd067dfe02" to ("SecondHandSongs" to "SecondHandSongs page for"),
    "8a2d3e55-d291-4b99-87a0-c59c6b121762" to ("VGMdb" to "VGMdb page for"),
    "c4bee4f4-e622-4c74-b80b-585989de27f4" to ("VIAF ID" to "VIAF ID for"),
    "75d87e83-d927-4580-ba63-44dc76256f98" to ("Wikidata" to "Wikidata page for"),
    "51e9db21-8864-49b3-aa58-470d7b81fa50" to ("Wikipedia" to "Wikipedia page for"),

    // https://musicbrainz.org/relationships/place-url
    "696b79da-7e45-40e6-a9d4-b31438eb7e5d" to ("official homepages" to "official homepage for"),
    "e13a6749-086a-4c52-a03f-fce7532113ba" to ("online data" to "online data"),
    "e3051f32-527b-4c47-9993-71250a6cd99c" to ("blogs" to "blog of"),
    "68a4537c-f2a6-49b8-81c5-82a62b0976b7" to ("picture" to "picture of"),
    "040de4d5-ace5-4cfb-8a45-95c5c73bce01" to ("social networking" to "social networking page for"),
    "c809cb4a-2835-44fb-bc64-fd4882bd389c" to ("Myspace" to "Myspace page for"),
    "1cd2eb89-2997-4901-87e9-838ac9a68da9" to ("SoundCloud" to "SoundCloud page for"),
    "e5c5a0f6-9581-44d8-a5fb-d3688254dc9f" to ("video channel" to "video channel for"),
    "22ec436d-bb65-4c83-a268-0fdb0dbd8834" to ("YouTube channels" to "YouTube channel for"),
    "09328447-f070-463e-a760-a419ffc115bf" to ("crowdfunding page" to "crowdfunding page for"),
    "271e2959-8dbd-45e2-933c-55cab4227b51" to ("history page" to "history page for"),
    "f14b4e5f-0884-4bb0-b3fa-134cc2734f0e" to ("patronage page" to "patronage page for"),
    "87a0a644-0a69-46c0-9e48-0656b8240d89" to ("other databases" to "other databases"),
    "0e41b9de-20d8-4d1a-869d-7018e1045439" to ("Bandsintown" to "Bandsintown page for"),
    "1c140ac8-8dc2-449e-92cb-52c90d525640" to ("Discogs" to "Discogs page for"),
    "c4c6356f-9cbc-4e26-ae76-63eef96d059d" to ("Geonames" to "Geonames page for"),
    "815bc5ca-c2fb-4dc6-a89b-9150888b0d4d" to ("IMDb" to "IMDb page for"),
    "c3ddb53d-a7df-4486-8cc7-c1b7baec994e" to ("Last.fm" to "Last.fm page for"),
    "751e8fb1-ed8d-4a94-b71b-a38065054f5d" to ("setlist.fm" to "setlist.fm page for"),
    "3eb58d3e-6f00-36a8-a115-3dad616b7391" to ("Songkick" to "Songkick page for"),
    "f11ffda6-d59a-45bf-9b07-74b08335b5fa" to ("VGMdb" to "VGMdb page for"),
    "49a08641-0aed-4e10-8311-ec220b8c50ad" to ("VIAF ID" to "VIAF ID for"),
    "e6826618-b410-4b8d-b3b5-52e29eac5e1f" to ("Wikidata" to "Wikidata page for"),
    "82680bbb-0391-4344-9687-4f419df4b97a" to ("Wikipedia" to "Wikipedia page for"),

    // https://musicbrainz.org/relationships/recording-url
    "f25e301d-b87b-4561-86a0-5d2df6d26c0a" to ("license" to "license for"),
    "c0b9cc44-ea3b-4312-94f9-577c2605d305" to ("production" to "production"),
//    "Few relationships (0)" to ("samples IMDb entry" to "IMDb entry sampled in"),
    "44598c7e-01f9-438b-950a-183720a2cbbe" to ("get the music" to "get the music"),
    "92777657-504c-4acb-bd33-51a201bd57e1" to ("purchase for download" to "download purchase page for"),
    "45d0cbc5-d65b-4e77-bdfd-8a75207cb5c5" to ("download for free" to "free download page for"),
    // "7e41ef12-a124-4324-afdb-fdbae687a89c" to ("stream {video} for free" to "free music {video} streaming page for"),
    "b5f3058a-666c-406f-aafb-f9249fc7b122" to ("streaming page" to "streaming page for"),
    "f9d9946e-0cea-4e47-9d3b-be4be55397a8" to ("crowdfunding page" to "crowdfunding page for"),
    "bc21877b-e993-42ed-a7ce-9187ec9b638f" to ("other databases" to "other databases"),
    "54482490-5ff1-4b1c-9382-b4d0ef8e0eac" to ("Allmusic" to "Allmusic page for"),
    "a98fb02f-f289-4778-b34e-2625d922e28f" to ("SecondHandSongs" to "SecondHandSongs page for"),

    // https://musicbrainz.org/relationships/release-url
    "4f2e710d-166c-480c-a293-2e2c8d658d87" to ("ASIN" to "ASIN"),
    "823656dd-0309-4247-b282-b92d287d59c5" to ("discography entry" to "discography entry for"),
    "004bd0c3-8a45-4309-ba52-fa99f3aa3d50" to ("license" to "license for"),
    "ee1c7888-99c7-4c22-aaee-6a34a907fa24" to ("production" to "production"),
//    "Few relationships (0)" to ("samples IMDb entry" to "IMDb entry sampled in"),
    "759935d6-c9c6-4362-8978-2f0d46d67deb" to ("get the music" to "get the music"),
    "3ee51e05-a06a-415e-b40c-b3f740dedfd7" to ("purchase for mail-order" to "mail-order purchase page for"),
    "98e08c20-8402-4163-8970-53504bb6a1e4" to ("purchase for download" to "download purchase page for"),
    "9896ecd0-6d29-482d-a21e-bd5d1b5e3425" to ("download for free" to "free download page for"),
    // "08445ccf-7b99-4438-9f9a-fb9ac18099ee" to ("stream {video} for free" to "free music {video} streaming page for"),
    "320adf26-96fa-4183-9045-1f5f32f833cb" to ("streaming page" to "streaming page for"),
    "e1434bc9-5e54-4b10-b3f6-db09e6f0cb44" to ("crowdfunding page" to "crowdfunding page for"),
    "2d24d075-9943-4c4d-a659-8ce52e6e6b57" to ("show notes" to "show notes for"),
    "2476be45-3090-43b3-a948-a8f972b4065c" to ("cover art" to "cover art for"),
    "c74dee45-3c85-41e9-a804-92ab1c654446" to ("other databases" to "other databases"),
    "90ff18ad-3e9d-4472-a3d1-71d4df7e8484" to ("Allmusic" to "Allmusic page for"),
    "63b84620-ba52-4630-9bfe-8ad3b5504dff" to ("BookBrainz" to "BookBrainz page for"),
    "4a78823c-1c53-4176-a5f3-58026c76f2bc" to ("Discogs" to "Discogs page for"),
    "0e555925-1b7d-475c-9b25-b9c349dcc3f3" to ("SecondHandSongs" to "SecondHandSongs page for"),
    "6af0134a-df6a-425a-96e2-895f9cd342ba" to ("VGMdb" to "VGMdb page for"),

    // https://musicbrainz.org/relationships/release_group-url
    "156344d3-da8b-40c6-8b10-7b1c22727124" to ("lyrics page" to "lyrics page for"),
    "89fe4da2-ced3-4fd0-8739-fd22d823acdb" to ("discography" to "discography"),
    "87d97dfc-3206-42fd-89d5-99593d5f1297" to ("standalone website" to "standalone website for"),
    "c3ac9c3b-f546-4d15-873f-b294d2c1b708" to ("reviews" to "review page for"),
    "6aec99c1-8817-4d91-8fd0-1028cb467b62" to ("crowdfunding page" to "crowdfunding page for"),
    "38320e40-9f4a-3ae7-8cb2-3f3c9c5d856d" to ("other databases" to "other databases"),
    "a50a1d20-2b20-4d2c-9a29-eb771dd78386" to ("Allmusic" to "Allmusic page for"),
    "27cfc95c-d368-45a9-ae0d-308c274c2017" to ("BookBrainz" to "BookBrainz page for"),
    "99e550f3-5ab4-3110-b5b9-fe01d970b126" to ("Discogs" to "Discogs page for"),
    "85b0a010-3237-47c7-8476-6fcefd4761af" to ("IMDb" to "IMDb page for"),
    "b988d08c-5d86-4a57-9557-c83b399e3580" to ("Wikidata" to "Wikidata page for"),
    "6578f0e9-1ace-4095-9de8-6e517ddb1ceb" to ("Wikipedia" to "Wikipedia page for"),

    // https://musicbrainz.org/relationships/series-url
    "b79eb9a5-46df-492d-b107-1f1fea71b0eb" to ("official homepages" to "official homepage for"),
    "ac9d08ef-c794-48b9-aadb-4d2944a0b6ed" to ("schedule" to "schedule for"),
    "80d5e037-9aa7-3d80-80da-fb01d6dbc25b" to ("social networking" to "social networking page for"),
    "4789521b-57b9-4689-9644-46de63190f66" to ("SoundCloud" to "SoundCloud page for"),
    "5ce55509-47a5-4374-a1c6-a68fd377bddf" to ("podcast feed" to "podcast feed for"),
    "71774032-781b-468c-9cbf-8a9a2f8eda13" to ("video channel" to "video channel for"),
    "f23802a4-36be-3751-8e4d-93422e08b3e8" to ("YouTube channels" to "YouTube channel for"),
    "b4894e57-5e32-479f-b1e7-bc561048ce48" to ("crowdfunding page" to "crowdfunding page for"),
    "492a4e07-0ea9-4e82-870b-cab942b0576f" to ("patronage page" to "patronage page for"),
    "8a08d0f5-c7c4-4572-9d22-cee92693d820" to ("other databases" to "other databases"),
    "338811ef-b1a9-449d-954e-115846f33a44" to ("Discogs" to "Discogs page for"),
    "de143a8b-ea80-4b26-9246-f1ce498d4b01" to ("setlist.fm" to "setlist.fm page for"),
    "67764397-d154-4f9a-8aa8-cbc4de4df5b8" to ("VIAF ID" to "VIAF ID for"),
    "a1eecd98-f2f2-420b-ba8e-e5bc61697869" to ("Wikidata" to "Wikidata page for"),
    "b2b9407a-dd32-30f4-aa48-b2fd2077d1d2" to ("Wikipedia" to "Wikipedia page for"),

    // https://musicbrainz.org/relationships/url-url
    // No relationships.

    // https://musicbrainz.org/relationships/area-work
    "536b4ee4-bb2d-3b6f-a3f1-082f22e5b17d" to ("anthem" to "anthem of"),
    "c6bd908f-41f1-4ff3-83f3-df514278d994" to ("premieres hosted" to "premiered in"),
    // "e02f372b-33c3-41fc-88ba-6b3e95f50d77" to ("{additional} writing location for" to "{additional:additionally} written in"),
    // "5293c7f7-7950-4fef-b367-b0062b99c4e7" to ("{additional} composing location for" to "{additional:additionally} composed in"),
    // "43ba113b-968f-4fa9-93b2-73e60f954c90" to ("{additional} lyrics writing location for" to "{additional} lyrics written in"),
    // "69230b8a-aa15-46e5-b540-b6302d60eb22" to ("{additional} libretto writing location for" to "libretto {additional:additionally} written in"),
    "4dd0d181-8df0-47d4-9f5f-0b63d05b64cb" to ("revising location for" to "revised in"),
    // "79a01829-749c-44c3-8b9e-65243b302f81" to ("{additional} translating location for" to "{additional:additionally} translated in"),
    // "468ec917-4be7-4a9a-8dbd-e740d049c5a2" to ("{additional} arranging location for" to "{additional:additionally} arranged in"),
    "04307051-fe20-4357-89e6-ee7a6470c229" to ("dedicated works" to "dedicated to"),

    // https://musicbrainz.org/relationships/artist-work
    "cc9fcb45-7ab5-4629-bc5f-277f2592fa5a" to ("composition" to "composition"),
    // "a255bca1-b157-4518-9108-7b147dc3fc68" to ("{additional:additionally} wrote" to "{additional} writer"),
    // "d59d99ea-23d4-4a80-b066-edca32ee158f" to ("{additional:additionally} composed" to "{additional} composer"),
    // "3e48faba-ec01-47fd-8e89-30e81161661c" to ("{additional} lyrics" to "{additional} lyricist"),
    // "7474ab81-486f-40b5-8685-3a4f8ea624cb" to ("{additional} libretto" to "{additional} librettist"),
    "eeb9c319-9fde-4313-b76d-29db1576aad8" to ("revised" to "revised by"),
    // "da6c5d8a-ce13-474d-9375-61feb29039a5" to ("{additional:additionally} translated" to "{additional} translator"),
    "cb887d1b-5267-4f3d-badb-5b3fba7349f6" to ("reconstructed" to "reconstructed by"),
    // "d3fd781c-5894-47e2-8c12-86cc0e2c8d08" to ("{additional:additionally} {co:co-}arranged" to "{additional} {co:co-}arranger"),
    // "0084e70a-873e-4f7f-b3ff-635b9e863dae" to ("{additional:additionally} {instrument:%|instruments} {co:co-}arranged" to "{additional} {instrument:%|instruments} {co:co-}arranger"),
    // "0a1771e1-8639-4740-8a43-bdafc050c3da" to ("{additional:additionally} orchestrated" to "{additional} orchestrator"),
    // "6a88b92b-8fb5-41b3-aa1f-169ee7e05ed6" to ("{additional:additionally} {vocal:%|vocals} {co:co-}arranged" to "{additional} {vocal:%|vocals} {co:co-}arranger"),
    "7231dcac-d2dc-4b4a-b218-ecea4123a4cd" to ("previous attribution" to "previously attributed to"),
    "7d166271-99c7-3a13-ae96-d2aab758029d" to ("miscellaneous roles" to "miscellaneous support"),
    "95f0213a-dbe0-4d36-8036-9782e425e98a" to ("commissioned" to "was commissioned by"),
    "26131498-00e8-4136-b937-22a4be01a63d" to ("dedicated works" to "dedicated to"),
    "5cc8cfb5-cca0-4395-a44b-b7d3c1777608" to ("works premiered" to "premiered by"),
    "a442b140-830b-30b0-a4aa-2e36f098b6aa" to ("published" to "publisher"),
    "535fdfed-3bca-40ad-966b-e67be7882d09" to ("named after" to "inspired the name of"),

    // https://musicbrainz.org/relationships/event-work
    "8cfc7355-186b-477b-b55d-4c20f63d0927" to ("premieres" to "premiered at"),

    // https://musicbrainz.org/relationships/genre-work
    // No relationships.

    // https://musicbrainz.org/relationships/instrument-work
    // No relationships.

    // https://musicbrainz.org/relationships/label-work
    "05ee6f18-4517-342d-afdf-5897f64276e3" to ("published" to "publisher"),
    "74f8e1b8-b91f-425d-bc36-f8cc09d4f456" to ("commissioned" to "was commissioned by"),
    "762b17eb-e511-4cc0-836e-a081831c1754" to ("dedicated works" to "dedicated to"),

    // https://musicbrainz.org/relationships/place-work
    "a4d2a7cb-365b-4b90-b52f-29469edf8ac0" to ("premieres hosted" to "premiered at"),
    // "e7f4918a-48e9-49ca-8e3d-ee5eb0dc0ff4" to ("{additional} writing location for" to "{additional:additionally} written at"),
    // "beaff7ea-771d-4f0d-aeb7-633bdddfa196" to ("{additional} composing location for" to "{additional:additionally} composed at"),
    // "dfd87666-da9b-43ac-b45e-7ad01b355746" to ("{additional} lyrics writing location for" to "{additional} lyrics written at"),
    // "f2144669-1eff-46e9-a8aa-2717c0b619f6" to ("{additional} libretto writing location for" to "libretto {additional:additionally} written at"),
    "31fb8bbc-5458-4b5a-8747-2b8f373fe0c1" to ("revising location for" to "revised at"),
    // "1ff44f30-3e21-493a-b97e-dab30a9b295f" to ("{additional} translating location for" to "translated at"),
    // "fc206200-021c-4b28-97ea-36e4c1391068" to ("{additional} arranging location for" to "{additional:additionally} arranged at"),
    "77edb403-8628-4f00-9fa4-b1f69bea6dc2" to ("commissioned" to "was commissioned by"),
    "4121e462-a6bd-4e33-8fe7-0f9aee69f5e9" to ("dedicated works" to "dedicated to"),

    // https://musicbrainz.org/relationships/recording-work
    // "a3005666-a872-32c3-ad06-98af558e99b0" to ("{live} {medley:medley including a} {partial} {instrumental} {cover} {karaoke} recording of" to "{live} {medley:medleys including} {partial} {instrumental} {cover} {karaoke} recordings"),

    // https://musicbrainz.org/relationships/release-work
    // No relationships.

    // https://musicbrainz.org/relationships/release_group-work
    // No relationships.

    // https://musicbrainz.org/relationships/series-work
    "b0d44366-cdf0-3acb-bee6-0f65a77a6ef0" to ("has parts" to "part of"),
    "3c181de6-9784-43de-99f6-aaed16ee85f4" to ("commissioned" to "was commissioned by"),

    // https://musicbrainz.org/relationships/url-work
    "770ea9f4-cba0-4194-b77f-fe2740055e34" to ("license for" to "license"),
    "e38e65aa-75e0-42ba-ace0-072aeb91a538" to ("lyrics page for" to "lyrics page"),
    "d23c710f-7657-41fe-a328-c588bcb52483" to ("get the score" to "get the score"),
    "26b5d3aa-7d05-4121-a9eb-bf8a9aeb6e28" to ("mail-order purchase page for the score of" to "purchase score for mail-order"),
    "68ac61a1-6151-48bf-8596-ac3bcc3a41a2" to ("download purchase page for the score of" to "purchase score for download"),
    "0cc8527e-ea40-40dd-b144-3b7588e759bf" to ("free download page for the score of" to "download score for free"),
    "9900c8c5-9844-4f10-8403-23aabafd913c" to ("work list entry for" to "work list entry"),
    "c0ba3feb-289c-4701-8d0c-24d51f7fcf2b" to ("crowdfunding page for" to "crowdfunding page"),
    "190ea031-4355-405d-a43e-53eb4c5c4ada" to ("other databases" to "other databases"),
    "ca9c9f46-11bd-423a-b134-9109cbebe9d7" to ("Allmusic page for" to "Allmusic"),
    "0ea7cf4e-93dd-4bc4-b748-0f1073cf951c" to ("BookBrainz page for" to "BookBrainz"),
    "d78b7280-eb9e-4a57-86c3-cedaa1aa2175" to ("Discogs page for" to "Discogs"),
    "e5c75559-4dda-452e-a900-ae375935164c" to ("IMDb page for" to "IMDb"),
    "b80dff64-9560-445a-b824-c8b432d77a52" to ("SecondHandSongs page for" to "SecondHandSongs"),
    "80402bbc-1aec-41d1-a5be-b599b89bc3c3" to ("Songfacts page for" to "Songfacts"),
    "bb250727-5090-4568-af7b-be8545c034bc" to ("VGMdb page for" to "VGMdb"),
//    "Few relationships (0)" to ("VIAF ID for" to "VIAF ID"),
    "587fdd8f-080e-46a9-97af-6425ebbcb3a2" to ("Wikidata page for" to "Wikidata"),
    "b45a88d6-851e-4a6e-9ec8-9a5f4ebe76ab" to ("Wikipedia page for" to "Wikipedia"),

    // https://musicbrainz.org/relationships/work-work
    "c1dca2cd-194c-36dd-93f8-6a359167e992" to ("medley of" to "referred to in medleys"),
    // "7440b539-19ab-4243-8c03-4f5942ca2218" to ("later {translated} {parody} versions" to "{translated} {parody} version of"),
    "51975ed8-bbfa-486b-9f28-5947f4370299" to ("arrangements" to "arrangement of"),
    "dd372cb2-5f4d-4dcd-868e-7564782f460b" to ("orchestrations" to "orchestration of"),
    "6bb1df6b-57f3-434d-8a39-5dc363d2eb78" to ("is the basis for" to "is based on"),
    "4d0d6491-3c41-42c6-883f-d6c7e825b052" to ("has revision" to "revision of"),
    "c5decae0-535c-4730-aa5f-ab78eadd98ba" to ("quotes music from" to "music quoted on"),
    "c8283596-6f1f-42db-be9c-def66d387e78" to ("quotes lyrics from" to "lyrics quoted on"),
    "ca8d3642-ce5f-49f8-91f2-125d72524e6a" to ("parts" to "part of"),

)
