package ly.david.musicsearch.data.database.dao

import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.TransactionWithoutReturn

interface EntityDao {
    val transacter: TransacterImpl

    fun withTransaction(block: TransactionWithoutReturn.() -> Unit) {
        transacter.transaction { block() }
    }

    fun <R>withTransactionWithResult(block: () -> R): R {
        return transacter.transactionWithResult { block() }
    }
}
