package io.github.kitswas.VGP_Data_Exchange;


// Code generated by colf(1); DO NOT EDIT.
// The compiler used schema file demo.colf and GamePadReading.colf.


import static java.lang.String.format;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.InputMismatchException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;


/**
 * Data bean with built-in serialization support.
 * Inspired by the GamepadReading struct in the Windows API.
 * https://learn.microsoft.com/en-us/uwp/api/windows.gaming.input.gamepadreading
 * The Thumbstick values are actual circular positions in the range -1.0 to 1.0
 * It means 0.7, 0.7 is a corner, while 1.0, 1.0 is invalid.
 * @author generated by colf(1)
 * @see <a href="https://github.com/pascaldekloe/colfer">Colfer's home</a>
 */
public class GamepadReading implements Serializable {

	/** The upper limit for serial byte sizes. */
	public static int colferSizeMax = 16 * 1024 * 1024;


	public int ButtonsUp;

	public int ButtonsDown;

	public float LeftTrigger;

	public float RightTrigger;

	public float LeftThumbstickX;

	public float LeftThumbstickY;

	public float RightThumbstickX;

	public float RightThumbstickY;

	/** Default constructor */
	public GamepadReading() {
		init();
	}


	/** Colfer zero values. */
	private void init() {
	}

	/**
	 * {@link #reset(InputStream) Reusable} deserialization of Colfer streams.
	 */
	public static class Unmarshaller {

		/** The data source. */
		protected InputStream in;

		/** The read buffer. */
		public byte[] buf;

		/** The {@link #buf buffer}'s data start index, inclusive. */
		protected int offset;

		/** The {@link #buf buffer}'s data end index, exclusive. */
		protected int i;


		/**
		 * @param in the data source or {@code null}.
		 * @param buf the initial buffer or {@code null}.
		 */
		public Unmarshaller(InputStream in, byte[] buf) {
			if (buf == null || buf.length == 0)
				buf = new byte[Math.min(GamepadReading.colferSizeMax, 2048)];
			this.buf = buf;
			reset(in);
		}

		/**
		 * Reuses the marshaller.
		 * @param in the data source or {@code null}.
		 * @throws IllegalStateException on pending data.
		 */
		public void reset(InputStream in) {
			if (this.i != this.offset) throw new IllegalStateException("colfer: pending data");
			this.in = in;
			this.offset = 0;
			this.i = 0;
		}

		/**
		 * Deserializes the following object.
		 * @return the result or {@code null} when EOF.
		 * @throws IOException from the input stream.
		 * @throws SecurityException on an upper limit breach defined by {@link #colferSizeMax}.
		 * @throws InputMismatchException when the data does not match this object's schema.
		 */
		public GamepadReading next() throws IOException {
			if (in == null) return null;

			while (true) {
				if (this.i > this.offset) {
					try {
						GamepadReading o = new GamepadReading();
						this.offset = o.unmarshal(this.buf, this.offset, this.i);
						return o;
					} catch (BufferUnderflowException e) {
					}
				}
				// not enough data

				if (this.i <= this.offset) {
					this.offset = 0;
					this.i = 0;
				} else if (i == buf.length) {
					byte[] src = this.buf;
					if (offset == 0) this.buf = new byte[Math.min(GamepadReading.colferSizeMax, this.buf.length * 4)];
					System.arraycopy(src, this.offset, this.buf, 0, this.i - this.offset);
					this.i -= this.offset;
					this.offset = 0;
				}
				assert this.i < this.buf.length;

				int n = in.read(buf, i, buf.length - i);
				if (n < 0) {
					if (this.i > this.offset)
						throw new InputMismatchException("colfer: pending data with EOF");
					return null;
				}
				assert n > 0;
				i += n;
			}
		}

	}

	/**
	 * Gets the serial size estimate as an upper boundary, whereby
	 * {@link #marshal(byte[],int)} ≤ {@link #marshalFit()} ≤ {@link #colferSizeMax}.
	 * @return the number of bytes.
	 */
	public int marshalFit() {
		long n = 1L + 5 + 5 + 5 + 5 + 5 + 5 + 5 + 5;
		if (n < 0 || n > (long)GamepadReading.colferSizeMax) return GamepadReading.colferSizeMax;
		return (int) n;
	}

	/**
	 * Serializes the object.
	 * @param out the data destination.
	 * @param buf the initial buffer or {@code null}.
	 * @return the final buffer. When the serial fits into {@code buf} then the return is {@code buf}.
	 *  Otherwise the return is a new buffer, large enough to hold the whole serial.
	 * @throws IOException from {@code out}.
	 * @throws IllegalStateException on an upper limit breach defined by {@link #colferSizeMax}.
	 */
	public byte[] marshal(OutputStream out, byte[] buf) throws IOException {
		int n = 0;
		if (buf != null && buf.length != 0) try {
			n = marshal(buf, 0);
		} catch (BufferOverflowException e) {}
		if (n == 0) {
			buf = new byte[marshalFit()];
			n = marshal(buf, 0);
		}
		out.write(buf, 0, n);
		return buf;
	}

	/**
	 * Serializes the object.
	 * @param buf the data destination.
	 * @param offset the initial index for {@code buf}, inclusive.
	 * @return the final index for {@code buf}, exclusive.
	 * @throws BufferOverflowException when {@code buf} is too small.
	 * @throws IllegalStateException on an upper limit breach defined by {@link #colferSizeMax}.
	 */
	public int marshal(byte[] buf, int offset) {
		int i = offset;

		try {
			if (this.ButtonsUp != 0) {
				int x = this.ButtonsUp;
				if ((x & ~((1 << 21) - 1)) != 0) {
					buf[i++] = (byte) (0 | 0x80);
					buf[i++] = (byte) (x >>> 24);
					buf[i++] = (byte) (x >>> 16);
					buf[i++] = (byte) (x >>> 8);
				} else {
					buf[i++] = (byte) 0;
					while (x > 0x7f) {
						buf[i++] = (byte) (x | 0x80);
						x >>>= 7;
					}
				}
				buf[i++] = (byte) x;
			}

			if (this.ButtonsDown != 0) {
				int x = this.ButtonsDown;
				if ((x & ~((1 << 21) - 1)) != 0) {
					buf[i++] = (byte) (1 | 0x80);
					buf[i++] = (byte) (x >>> 24);
					buf[i++] = (byte) (x >>> 16);
					buf[i++] = (byte) (x >>> 8);
				} else {
					buf[i++] = (byte) 1;
					while (x > 0x7f) {
						buf[i++] = (byte) (x | 0x80);
						x >>>= 7;
					}
				}
				buf[i++] = (byte) x;
			}

			if (this.LeftTrigger != 0.0f) {
				buf[i++] = (byte) 2;
				int x = Float.floatToRawIntBits(this.LeftTrigger);
				buf[i++] = (byte) (x >>> 24);
				buf[i++] = (byte) (x >>> 16);
				buf[i++] = (byte) (x >>> 8);
				buf[i++] = (byte) (x);
			}

			if (this.RightTrigger != 0.0f) {
				buf[i++] = (byte) 3;
				int x = Float.floatToRawIntBits(this.RightTrigger);
				buf[i++] = (byte) (x >>> 24);
				buf[i++] = (byte) (x >>> 16);
				buf[i++] = (byte) (x >>> 8);
				buf[i++] = (byte) (x);
			}

			if (this.LeftThumbstickX != 0.0f) {
				buf[i++] = (byte) 4;
				int x = Float.floatToRawIntBits(this.LeftThumbstickX);
				buf[i++] = (byte) (x >>> 24);
				buf[i++] = (byte) (x >>> 16);
				buf[i++] = (byte) (x >>> 8);
				buf[i++] = (byte) (x);
			}

			if (this.LeftThumbstickY != 0.0f) {
				buf[i++] = (byte) 5;
				int x = Float.floatToRawIntBits(this.LeftThumbstickY);
				buf[i++] = (byte) (x >>> 24);
				buf[i++] = (byte) (x >>> 16);
				buf[i++] = (byte) (x >>> 8);
				buf[i++] = (byte) (x);
			}

			if (this.RightThumbstickX != 0.0f) {
				buf[i++] = (byte) 6;
				int x = Float.floatToRawIntBits(this.RightThumbstickX);
				buf[i++] = (byte) (x >>> 24);
				buf[i++] = (byte) (x >>> 16);
				buf[i++] = (byte) (x >>> 8);
				buf[i++] = (byte) (x);
			}

			if (this.RightThumbstickY != 0.0f) {
				buf[i++] = (byte) 7;
				int x = Float.floatToRawIntBits(this.RightThumbstickY);
				buf[i++] = (byte) (x >>> 24);
				buf[i++] = (byte) (x >>> 16);
				buf[i++] = (byte) (x >>> 8);
				buf[i++] = (byte) (x);
			}

			buf[i++] = (byte) 0x7f;
			return i;
		} catch (ArrayIndexOutOfBoundsException e) {
			if (i - offset > GamepadReading.colferSizeMax)
				throw new IllegalStateException(format("colfer: io.github.kitswas/VGP_Data_Exchange.GamepadReading exceeds %d bytes", GamepadReading.colferSizeMax));
			if (i > buf.length) throw new BufferOverflowException();
			throw e;
		}
	}

	/**
	 * Deserializes the object.
	 * @param buf the data source.
	 * @param offset the initial index for {@code buf}, inclusive.
	 * @return the final index for {@code buf}, exclusive.
	 * @throws BufferUnderflowException when {@code buf} is incomplete. (EOF)
	 * @throws SecurityException on an upper limit breach defined by {@link #colferSizeMax}.
	 * @throws InputMismatchException when the data does not match this object's schema.
	 */
	public int unmarshal(byte[] buf, int offset) {
		return unmarshal(buf, offset, buf.length);
	}

	/**
	 * Deserializes the object.
	 * @param buf the data source.
	 * @param offset the initial index for {@code buf}, inclusive.
	 * @param end the index limit for {@code buf}, exclusive.
	 * @return the final index for {@code buf}, exclusive.
	 * @throws BufferUnderflowException when {@code buf} is incomplete. (EOF)
	 * @throws SecurityException on an upper limit breach defined by {@link #colferSizeMax}.
	 * @throws InputMismatchException when the data does not match this object's schema.
	 */
	public int unmarshal(byte[] buf, int offset, int end) {
		if (end > buf.length) end = buf.length;
		int i = offset;

		try {
			byte header = buf[i++];

			if (header == (byte) 0) {
				int x = 0;
				for (int shift = 0; true; shift += 7) {
					byte b = buf[i++];
					x |= (b & 0x7f) << shift;
					if (shift == 28 || b >= 0) break;
				}
				this.ButtonsUp = x;
				header = buf[i++];
			} else if (header == (byte) (0 | 0x80)) {
				this.ButtonsUp = (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
				header = buf[i++];
			}

			if (header == (byte) 1) {
				int x = 0;
				for (int shift = 0; true; shift += 7) {
					byte b = buf[i++];
					x |= (b & 0x7f) << shift;
					if (shift == 28 || b >= 0) break;
				}
				this.ButtonsDown = x;
				header = buf[i++];
			} else if (header == (byte) (1 | 0x80)) {
				this.ButtonsDown = (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
				header = buf[i++];
			}

			if (header == (byte) 2) {
				int x = (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
				this.LeftTrigger = Float.intBitsToFloat(x);
				header = buf[i++];
			}

			if (header == (byte) 3) {
				int x = (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
				this.RightTrigger = Float.intBitsToFloat(x);
				header = buf[i++];
			}

			if (header == (byte) 4) {
				int x = (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
				this.LeftThumbstickX = Float.intBitsToFloat(x);
				header = buf[i++];
			}

			if (header == (byte) 5) {
				int x = (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
				this.LeftThumbstickY = Float.intBitsToFloat(x);
				header = buf[i++];
			}

			if (header == (byte) 6) {
				int x = (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
				this.RightThumbstickX = Float.intBitsToFloat(x);
				header = buf[i++];
			}

			if (header == (byte) 7) {
				int x = (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
				this.RightThumbstickY = Float.intBitsToFloat(x);
				header = buf[i++];
			}

			if (header != (byte) 0x7f)
				throw new InputMismatchException(format("colfer: unknown header at byte %d", i - 1));
		} finally {
			if (i > end && end - offset < GamepadReading.colferSizeMax) throw new BufferUnderflowException();
			if (i < 0 || i - offset > GamepadReading.colferSizeMax)
				throw new SecurityException(format("colfer: io.github.kitswas/VGP_Data_Exchange.GamepadReading exceeds %d bytes", GamepadReading.colferSizeMax));
			if (i > end) throw new BufferUnderflowException();
		}

		return i;
	}

	// {@link Serializable} version number.
	private static final long serialVersionUID = 8L;

	// {@link Serializable} Colfer extension.
	private void writeObject(ObjectOutputStream out) throws IOException {
		byte[] buf = new byte[marshalFit()];
		int n = marshal(buf, 0);
		out.writeInt(n);
		out.write(buf, 0, n);
	}

	// {@link Serializable} Colfer extension.
	private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
		init();

		int n = in.readInt();
		byte[] buf = new byte[n];
		in.readFully(buf);
		unmarshal(buf, 0);
	}

	// {@link Serializable} Colfer extension.
	private void readObjectNoData() throws ObjectStreamException {
		init();
	}

	/**
	 * Gets io.github.kitswas/VGP_Data_Exchange.GamepadReading.ButtonsUp.
	 * @return the value.
	 */
	public int getButtonsUp() {
		return this.ButtonsUp;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.ButtonsUp.
	 * @param value the replacement.
	 */
	public void setButtonsUp(int value) {
		this.ButtonsUp = value;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.ButtonsUp.
	 * @param value the replacement.
	 * @return {@code this}.
	 */
	public GamepadReading withButtonsUp(int value) {
		this.ButtonsUp = value;
		return this;
	}

	/**
	 * Gets io.github.kitswas/VGP_Data_Exchange.GamepadReading.ButtonsDown.
	 * @return the value.
	 */
	public int getButtonsDown() {
		return this.ButtonsDown;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.ButtonsDown.
	 * @param value the replacement.
	 */
	public void setButtonsDown(int value) {
		this.ButtonsDown = value;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.ButtonsDown.
	 * @param value the replacement.
	 * @return {@code this}.
	 */
	public GamepadReading withButtonsDown(int value) {
		this.ButtonsDown = value;
		return this;
	}

	/**
	 * Gets io.github.kitswas/VGP_Data_Exchange.GamepadReading.LeftTrigger.
	 * @return the value.
	 */
	public float getLeftTrigger() {
		return this.LeftTrigger;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.LeftTrigger.
	 * @param value the replacement.
	 */
	public void setLeftTrigger(float value) {
		this.LeftTrigger = value;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.LeftTrigger.
	 * @param value the replacement.
	 * @return {@code this}.
	 */
	public GamepadReading withLeftTrigger(float value) {
		this.LeftTrigger = value;
		return this;
	}

	/**
	 * Gets io.github.kitswas/VGP_Data_Exchange.GamepadReading.RightTrigger.
	 * @return the value.
	 */
	public float getRightTrigger() {
		return this.RightTrigger;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.RightTrigger.
	 * @param value the replacement.
	 */
	public void setRightTrigger(float value) {
		this.RightTrigger = value;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.RightTrigger.
	 * @param value the replacement.
	 * @return {@code this}.
	 */
	public GamepadReading withRightTrigger(float value) {
		this.RightTrigger = value;
		return this;
	}

	/**
	 * Gets io.github.kitswas/VGP_Data_Exchange.GamepadReading.LeftThumbstickX.
	 * @return the value.
	 */
	public float getLeftThumbstickX() {
		return this.LeftThumbstickX;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.LeftThumbstickX.
	 * @param value the replacement.
	 */
	public void setLeftThumbstickX(float value) {
		this.LeftThumbstickX = value;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.LeftThumbstickX.
	 * @param value the replacement.
	 * @return {@code this}.
	 */
	public GamepadReading withLeftThumbstickX(float value) {
		this.LeftThumbstickX = value;
		return this;
	}

	/**
	 * Gets io.github.kitswas/VGP_Data_Exchange.GamepadReading.LeftThumbstickY.
	 * @return the value.
	 */
	public float getLeftThumbstickY() {
		return this.LeftThumbstickY;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.LeftThumbstickY.
	 * @param value the replacement.
	 */
	public void setLeftThumbstickY(float value) {
		this.LeftThumbstickY = value;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.LeftThumbstickY.
	 * @param value the replacement.
	 * @return {@code this}.
	 */
	public GamepadReading withLeftThumbstickY(float value) {
		this.LeftThumbstickY = value;
		return this;
	}

	/**
	 * Gets io.github.kitswas/VGP_Data_Exchange.GamepadReading.RightThumbstickX.
	 * @return the value.
	 */
	public float getRightThumbstickX() {
		return this.RightThumbstickX;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.RightThumbstickX.
	 * @param value the replacement.
	 */
	public void setRightThumbstickX(float value) {
		this.RightThumbstickX = value;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.RightThumbstickX.
	 * @param value the replacement.
	 * @return {@code this}.
	 */
	public GamepadReading withRightThumbstickX(float value) {
		this.RightThumbstickX = value;
		return this;
	}

	/**
	 * Gets io.github.kitswas/VGP_Data_Exchange.GamepadReading.RightThumbstickY.
	 * @return the value.
	 */
	public float getRightThumbstickY() {
		return this.RightThumbstickY;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.RightThumbstickY.
	 * @param value the replacement.
	 */
	public void setRightThumbstickY(float value) {
		this.RightThumbstickY = value;
	}

	/**
	 * Sets io.github.kitswas/VGP_Data_Exchange.GamepadReading.RightThumbstickY.
	 * @param value the replacement.
	 * @return {@code this}.
	 */
	public GamepadReading withRightThumbstickY(float value) {
		this.RightThumbstickY = value;
		return this;
	}

	@Override
	public final int hashCode() {
		int h = 1;
		h = 31 * h + this.ButtonsUp;
		h = 31 * h + this.ButtonsDown;
		h = 31 * h + Float.floatToIntBits(this.LeftTrigger);
		h = 31 * h + Float.floatToIntBits(this.RightTrigger);
		h = 31 * h + Float.floatToIntBits(this.LeftThumbstickX);
		h = 31 * h + Float.floatToIntBits(this.LeftThumbstickY);
		h = 31 * h + Float.floatToIntBits(this.RightThumbstickX);
		h = 31 * h + Float.floatToIntBits(this.RightThumbstickY);
		return h;
	}

	@Override
	public final boolean equals(Object o) {
		return o instanceof GamepadReading && equals((GamepadReading) o);
	}

	public final boolean equals(GamepadReading o) {
		if (o == null) return false;
		if (o == this) return true;

		return this.ButtonsUp == o.ButtonsUp
			&& this.ButtonsDown == o.ButtonsDown
			&& (this.LeftTrigger == o.LeftTrigger || (this.LeftTrigger != this.LeftTrigger && o.LeftTrigger != o.LeftTrigger))
			&& (this.RightTrigger == o.RightTrigger || (this.RightTrigger != this.RightTrigger && o.RightTrigger != o.RightTrigger))
			&& (this.LeftThumbstickX == o.LeftThumbstickX || (this.LeftThumbstickX != this.LeftThumbstickX && o.LeftThumbstickX != o.LeftThumbstickX))
			&& (this.LeftThumbstickY == o.LeftThumbstickY || (this.LeftThumbstickY != this.LeftThumbstickY && o.LeftThumbstickY != o.LeftThumbstickY))
			&& (this.RightThumbstickX == o.RightThumbstickX || (this.RightThumbstickX != this.RightThumbstickX && o.RightThumbstickX != o.RightThumbstickX))
			&& (this.RightThumbstickY == o.RightThumbstickY || (this.RightThumbstickY != this.RightThumbstickY && o.RightThumbstickY != o.RightThumbstickY));
	}

}
