# COPY SMS CODE | OTP Helper | کپی رمز پیامک

An open-source application that allows you to copy OTP and codes from SMS and notifications automatically by reading all of your notifications.

The application works completely offline and without internet permission. So you can be rest assured that your data does not leave your device.

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="80">](https://f-droid.org/packages/io.github.jd1378.otphelper/)
[<img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
     alt='Get it on Google Play'
     height="80">](https://play.google.com/store/apps/details?id=io.github.jd1378.otphelper)
[<img src="https://raw.githubusercontent.com/jd1378/otphelper/main/cafebazaar.png"
     alt='Get it on Bazaar'
     height="80">](https://cafebazaar.ir/app/io.github.jd1378.otphelper)

or get the APK from [Latest Release](https://github.com/jd1378/otphelper/releases/latest).

## How it works

The app works in 2 modes:

### 1. Notification

The app setups a [notification listener](https://github.com/jd1378/otphelper/blob/main/app/src/main/java/io/github/jd1378/otphelper/NotificationListener.kt) and reads all notifications that is sent by any apps. This allows the app to detect codes also from emails and possibly any other app that sends notification.
when a notification is sent, the app creates a single string from all text in the notification, then [checks if it should be ignored](https://github.com/jd1378/otphelper/blob/main/app/src/main/java/io/github/jd1378/otphelper/utils/CodeIgnore.kt). If It's not ignored, then It's matched against the [code detection regex](https://github.com/jd1378/otphelper/blob/main/app/src/main/java/io/github/jd1378/otphelper/utils/CodeExtractor.kt). The extracted code is then handled according to your settings.

### 2. SMS

The app listens to all incoming SMS messages and then processes them in the same way as the notification mode: checks if it should be ignored, and if not, matches it against the code detection regex. The extracted code is then handled according to your settings.

## How to build

Simply run:

```bash
./gradlew :app:assembleRelease
```

The apk should be available in `apps/build/outputs/apk/release/` directory.

## Credits

Feature graphic image generated by [hotpot.ai](https://hotpot.ai/templates/google-play-feature-graphic)

### Translated by these awesome people

German:

- [@Dacid99](https://github.com/Dacid99)

Spanish:

- [@nilp0inter](https://github.com/nilp0inter)

Turkish:

- [@SirCrownguard](https://github.com/SirCrownguard)

Bangla (Bangladesh):

- [@0xNaimulHasanTaky](https://github.com/0xNaimulHasanTaky)

Vietnamese:

- [@Sharethebest](https://github.com/Sharethebest)

Chinese (Hans):

- [@BackMountainDevil](https://github.com/BackMountainDevil)

Chinese (Hant):

- [@sntc06](https://github.com/sntc06)

Russian:

- [@darkspacer](https://github.com/darkspacer)

Italian:

- [@lollo03](https://github.com/lollo03)

French:

- [@trev0r-STA](https://github.com/trev0r-STA)

Arabic:

- [@Bunny-77X](https://github.com/Bunny-77X)

Hindi:

- [@chintanjoshi01](https://github.com/chintanjoshi01)

Ukrainian:

- [@balaraz](https://github.com/balaraz)

Portuguese:

- [@HackerSinhos](https://github.com/HackerSinhos)

Polish:

- [@pakin1](https://github.com/pakin1)

Japanese:

- [@KAWASAKICHIRO](https://github.com/KAWASAKICHIRO)

Korean:

- [@alexkoala](https://github.com/alexkoala)

You can help translate this app to your langauge on weblate:

<a href="https://hosted.weblate.org/engage/copy-sms-code-otp-helper/">
<img src="https://hosted.weblate.org/widget/copy-sms-code-otp-helper/287x66-grey.png" alt="Translation status" />
</a>

--------

### Donation

You can show your love and support for this project by donating to the following addresses:

BTC: bc1q8prgxcfcqpcq5ennyv08sxg6ymx2pm4azvcu0l

LTC: LVnTy14pHFRoSbqWbmhGBNjV4k2dBnY2Zn
