# Add project specific ProGuard rules here.
# You can control the set of applied configuration files using the
# proguardFiles setting in build.gradle.kts.
#
# For more details, see
#   http://developer.android.com/guide/developing/tools/proguard.html

# Keep SQLCipher classes
-keep class net.sqlcipher.** { *; }
-keep class net.sqlcipher.database.** { *; }

# Keep Room classes
-keep class * extends androidx.room.RoomDatabase
-keep @androidx.room.Entity class *
-dontwarn androidx.room.paging.**

# Keep Retrofit and OkHttp
-keepattributes Signature
-keepattributes *Annotation*
-keep class retrofit2.** { *; }
-keep class okhttp3.** { *; }

# Keep Kotlinx Serialization
-keepattributes *Annotation*, InnerClasses
-dontnote kotlinx.serialization.AnnotationsKt
-keepclassmembers class kotlinx.serialization.json.** {
    *** Companion;
}
-keepclasseswithmembers class kotlinx.serialization.json.** {
    kotlinx.serialization.KSerializer serializer(...);
}
-keep,includedescriptorclasses class io.github.dorumrr.happytaxes.**$$serializer { *; }
-keepclassmembers class io.github.dorumrr.happytaxes.** {
    *** Companion;
}
-keepclasseswithmembers class io.github.dorumrr.happytaxes.** {
    kotlinx.serialization.KSerializer serializer(...);
}

# Keep Hilt
-keep class dagger.hilt.** { *; }
-keep class javax.inject.** { *; }
-keep class * extends dagger.hilt.android.lifecycle.HiltViewModel



# Keep Tesseract4Android
-keep class com.googlecode.tesseract.android.** { *; }
-dontwarn com.googlecode.tesseract.android.**

# Reproducible builds for F-Droid
# Keep source file and line numbers for stack traces (via mapping file)
-keepattributes SourceFile,LineNumberTable
# Make source file attribute deterministic (removes non-deterministic r8-map-id hash)
-renamesourcefileattribute SourceFile
# Disable R8 optimizations for reproducible builds
# R8 optimizations are non-deterministic (especially Companion object handling)
# This keeps shrinking (unused code removal) but disables optimization passes
-dontoptimize
# Keep Kotlin Companion objects to prevent non-deterministic <clinit> generation
# This fixes R8 optimization non-determinism where Companion object static initializers
# may or may not be generated depending on optimization decisions
-keepclassmembers class ** {
    public static ** Companion;
}
-if class **$Companion
-keep class <1> {
    public static ** Companion;
}

