# Contributing to EnigmaDroid

We are thrilled that you're interested in contributing to EnigmaDroid! This document outlines our guidelines for contributing, so please take a moment to review them. Your contributions are what make this project better for everyone.

## Submitting a Bug Report

To help us address issues efficiently, please follow these steps when reporting a bug:

* **Search for existing issues:** Before creating a new issue, please check the [issue tracker](https://github.com/deprec8/EnigmaDroid/issues) to see if the bug has already been reported.

* **Provide a detailed report:** If the bug is new, open an issue with a clear and descriptive title. Include the steps to reproduce the bug, the expected behavior, the actual behavior, and details about your device's Android version and the EnigmaDroid app version. Screenshots or `Logcat` output are highly valuable.

## Proposing New Features

If you have a feature idea, please [open an issue](https://github.com/deprec8/EnigmaDroid/issues) to start a discussion. This allows us to align on the project's direction and helps you avoid spending time on a feature that may not fit the project's scope.

## Submitting a Pull Request

If you're ready to contribute code, please follow this workflow:

1. **Check for existing pull requests:** Before you begin, please check the [pull request list](https://github.com/deprec8/EnigmaDroid/pulls) to ensure a similar change isn't already in progress.

2. **Fork** the repository and clone your fork.

3. **Create a new branch** from `main` for your work.

4. **Implement your changes.** Ensure your code adheres to the existing coding style. EnigmaDroid is an Android app written in Kotlin using Jetpack Compose.

5. Before committing, please ensure your code is formatted correctly and passes the Android Studio lint checks.

6. **Commit your changes** with a clear and concise message.

7. **Open a Pull Request** to the `main` branch of the `deprec8/EnigmaDroid` repository. Please provide a clear description of your changes in the PR.

## Translation

You can help localize EnigmaDroid by contributing to translations. This project uses Crowdin for all its localization efforts. To contribute to an existing language or to add a new one, please visit the project's [Crowdin page](https://crowdin.com/project/enigmadroid).
