# EnigmaDroid

**EnigmaDroid** is a modern, user-friendly app that lets you control your Enigma2-based satellite or cable set-top box directly from your Android device.

Everywhere in your home, **EnigmaDroid** gives you full access to your receiver’s features and content.

## Installation

[<img src="https://f-droid.org/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/io.github.deprec8.enigmadroid)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" alt="Get it on IzzyOnDroid"  height="80">](https://apt.izzysoft.de/fdroid/index/apk/io.github.deprec8.enigmadroid)
[<img src="badge_github.png" alt="Get it on GitHub" height="80">](https://github.com/deprec8/EnigmaDroid/releases)

## Features

- **Live TV Streaming**: Watch live broadcasts from your Enigma2 box on your device using a compatible video player.
- **Playback Recordings**: Browse and play your saved shows and movies with a compatible video player.
- **Channel & Bouquet List**: Quickly navigate your full channel lineup and favorite bouquets.
- **Remote Control**: Full on-screen remote with keypad.
- **Timer Management**: Add, remove or edit timers and scheduled recordings.
- **EPG Support**: View Electronic Program Guide data with detailed show info.
- **Search & Filter**: Find channels or programs with built-in search on every page.
- **Multi-box Support**: Connect to multiple receivers and switch between them with ease.

## Streaming

EnigmaDroid currently only supports external media players for streaming live content and movies.

[**VLC**](https://www.videolan.org/vlc/download-android.html) is recommended, but other media players can also work.

## Translation

[![Crowdin](https://badges.crowdin.net/enigmadroid/localized.svg)](https://crowdin.com/project/enigmadroid) [![Crowdin Push](https://github.com/deprec8/EnigmaDroid/actions/workflows/crowdin-push.yml/badge.svg)](https://github.com/deprec8/EnigmaDroid/actions/workflows/crowdin-push.yml) [![Crowdin Pull](https://github.com/deprec8/EnigmaDroid/actions/workflows/crowdin-pull.yml/badge.svg)](https://github.com/deprec8/EnigmaDroid/actions/workflows/crowdin-pull.yml)

Translation is done on [**Crowdin**](https://crowdin.com/project/enigmadroid).

## Requirements

- A set-top box running **Enigma2**
- **OpenWebif** plugin enabled and configured

## Compatibility

Tested with popular Enigma2 images like **VTi**.

## Screenshots

| <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/1.jpg" alt="Navigation drawer" /> | <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/2.jpg" alt="Remote" />     | <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/3.jpg" alt="Add timer" /> |
|-------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------|
| <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/4.jpg" alt="Devices" />           | <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/5.jpg" alt="Edit device"/> |                                                                                               |
