// Copyright 2023-2025 BenderBlog Rodriguez and contributors
// Copyright 2025 Traintime PDA authors.
// SPDX-License-Identifier: MPL-2.0

import 'package:flutter_i18n/flutter_i18n.dart';
import 'package:watermeter/page/schoolnet/network_card_window.dart';
import 'package:get/get.dart';
import 'package:flutter/material.dart';
import 'package:watermeter/page/homepage/main_page_card.dart';
import 'package:watermeter/page/public_widget/context_extension.dart';
import 'package:watermeter/repository/network_session.dart';
import 'package:watermeter/repository/preference.dart' as preference;

import 'package:ming_cute_icons/ming_cute_icons.dart';
import 'package:watermeter/repository/schoolnet_session.dart';

class SchoolnetCard extends StatelessWidget {
  const SchoolnetCard({super.key});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () async {
        context.pushReplacement(const NetworkCardWindow());
      },
      child: Obx(
        () => MainPageCard(
          isLoad: schoolNetStatus.value == SessionState.fetching,
          icon: MingCuteIcons.mgc_wifi_fill,
          text:
              preference
                  .getString(preference.Preference.schoolNetQueryPassword)
                  .isEmpty
              ? FlutterI18n.translate(
                  context,
                  "homepage.school_card_info_card.bill",
                )
              : FlutterI18n.translate(
                  context,
                  "homepage.school_net.no_password",
                ),
          infoText: Text.rich(
            TextSpan(
              style: const TextStyle(fontSize: 20),
              children: [
                if (schoolNetStatus.value == SessionState.fetched) ...[
                  TextSpan(
                    text: FlutterI18n.translate(
                      context,
                      "homepage.school_net.title",
                      translationParams: {
                        "usage": networkInfo.value!.used.replaceAll("G", " GB"),
                      },
                    ),
                  ),
                ] else
                  TextSpan(
                    text: FlutterI18n.translate(
                      context,
                      schoolNetStatus.value == SessionState.error
                          ? "homepage.school_net.failed"
                          : "homepage.school_net.fetching",
                    ),
                  ),
              ],
            ),
          ),
          bottomText: Text(
            schoolNetStatus.value == SessionState.fetched
                ? FlutterI18n.translate(
                    context,
                    "homepage.school_net.remaining",
                    translationParams: {
                      "remaining": networkInfo.value!.charged,
                    },
                  )
                : schoolNetStatus.value == SessionState.error
                ? FlutterI18n.translate(context, isError.value)
                : FlutterI18n.translate(
                    context,
                    "homepage.school_net.fetching",
                  ),
            overflow: TextOverflow.ellipsis,
          ),
        ),
      ),
    );
  }
}
