// Copyright 2023-2025 BenderBlog Rodriguez and contributors
// Copyright 2025 Traintime PDA authors.
// SPDX-License-Identifier: MPL-2.0

import 'package:json_annotation/json_annotation.dart';

part 'message.g.dart';

@JsonSerializable(explicitToJson: true)
class UpdateMessage {
  final String code;
  final List<String> update;
  final String ioslink;
  final String github;
  final String fdroid;

  UpdateMessage({
    required this.code,
    required this.update,
    required this.ioslink,
    required this.github,
    required this.fdroid,
  });

  factory UpdateMessage.fromJson(Map<String, dynamic> json) =>
      _$UpdateMessageFromJson(json);

  Map<String, dynamic> toJson() => _$UpdateMessageToJson(this);
}
