// Copyright 2023-2025 BenderBlog Rodriguez and contributors
// Copyright 2025 Traintime PDA authors.
// SPDX-License-Identifier: MPL-2.0
//
// Autogenerated from Pigeon (v16.0.3), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers, constant_identifier_names

import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

class FileToGroupID {
  FileToGroupID({
    required this.appid,
    required this.fileName,
    required this.data,
  });

  String appid;

  String fileName;

  String data;

  Object encode() {
    return <Object?>[appid, fileName, data];
  }

  static FileToGroupID decode(Object result) {
    result as List<Object?>;
    return FileToGroupID(
      appid: result[0]! as String,
      fileName: result[1]! as String,
      data: result[2]! as String,
    );
  }
}

class _SaveToGroupIdSwiftApiCodec extends StandardMessageCodec {
  const _SaveToGroupIdSwiftApiCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is FileToGroupID) {
      buffer.putUint8(128);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 128:
        return FileToGroupID.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class SaveToGroupIdSwiftApi {
  /// Constructor for [SaveToGroupIdSwiftApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  SaveToGroupIdSwiftApi({BinaryMessenger? binaryMessenger})
    : __pigeon_binaryMessenger = binaryMessenger;
  final BinaryMessenger? __pigeon_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec =
      _SaveToGroupIdSwiftApiCodec();

  Future<String> getHostLanguage() async {
    const String __pigeon_channelName =
        'dev.flutter.pigeon.watermeter.SaveToGroupIdSwiftApi.getHostLanguage';
    final BasicMessageChannel<Object?> __pigeon_channel =
        BasicMessageChannel<Object?>(
          __pigeon_channelName,
          pigeonChannelCodec,
          binaryMessenger: __pigeon_binaryMessenger,
        );
    final List<Object?>? __pigeon_replyList =
        await __pigeon_channel.send(null) as List<Object?>?;
    if (__pigeon_replyList == null) {
      throw _createConnectionError(__pigeon_channelName);
    } else if (__pigeon_replyList.length > 1) {
      throw PlatformException(
        code: __pigeon_replyList[0]! as String,
        message: __pigeon_replyList[1] as String?,
        details: __pigeon_replyList[2],
      );
    } else if (__pigeon_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (__pigeon_replyList[0] as String?)!;
    }
  }

  Future<bool> saveToGroupId(FileToGroupID data) async {
    const String __pigeon_channelName =
        'dev.flutter.pigeon.watermeter.SaveToGroupIdSwiftApi.saveToGroupId';
    final BasicMessageChannel<Object?> __pigeon_channel =
        BasicMessageChannel<Object?>(
          __pigeon_channelName,
          pigeonChannelCodec,
          binaryMessenger: __pigeon_binaryMessenger,
        );
    final List<Object?>? __pigeon_replyList =
        await __pigeon_channel.send(<Object?>[data]) as List<Object?>?;
    if (__pigeon_replyList == null) {
      throw _createConnectionError(__pigeon_channelName);
    } else if (__pigeon_replyList.length > 1) {
      throw PlatformException(
        code: __pigeon_replyList[0]! as String,
        message: __pigeon_replyList[1] as String?,
        details: __pigeon_replyList[2],
      );
    } else if (__pigeon_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (__pigeon_replyList[0] as bool?)!;
    }
  }
}
