<!--
 Copyright 2024 BenderBlog Rodriguez and contributors.
 SPDX-License-Identifier: MPL-2.0
-->
# PDA 设计文档草案：数据结构

本草案面向服务端开发商，用于实际编程、估算服务端开发商需要的成本、向相关部门申请。

本文档是对 PDA 代码的分析，大多数是根据一站式API侦测所作出的。由于该数据结构没有过多深度设计，建议服务端开发者作出变通。

## 课程表信息

课程表信息包含三大类：主要课程信息，调课信息，未安排课程信息。

### 主要课程信息

课程信息由课程索引信息和课程安排信息构成。具体如下：

课程索引信息

| 名称     | 功能                   | 格式   | 是否可空 |
| -------- | ---------------------- | ------ | -------- |
| 名称     | 显示课程名称           | 字符串 | 否       |
| 课程序号 | 该课程在教务处里的序号 | 字符串 | 是       |
| 班级序号 | 开课班级的序号         | 字符串 | 是       |

课程安排信息

| 名称         | 功能                            | 格式           | 是否可空 |
| ------------ | ------------------------------- | -------------- | -------- |
| 课程索引信息 | 指示课程索引信息的变量          | 外键到课程索引 | 否       |
| 上课周次     | 在开课周次里面标志该周是否有课  | 布尔类型的数组 | 否       |
| 上课教师     | 该次安排中上课教师              | 字符串         | 是       |
| 上课教室     | 上课的地点                      | 字符串         | 是       |
| 上课星期     | 该周星期几上课，建议从1开始计数 | 整型数         | 否       |
| 上课开始时间 | 第几节课开始，建议从1开始计数   | 整型数         | 否       |
| 上课结束时间 | 第几节课结束，建议从1开始计数   | 整型数         | 否       |

### 调课信息

调课信息针对课程安排信息进行处理，具体如下：

| 名称           | 功能                                             | 格式           | 是否可空       |
| -------------- | ------------------------------------------------ | -------------- | -------------- |
| 调课类型       | 本次课程调整类型，分为三种情况：调课、停课、补课 | 枚举           | 否             |
| 课程序号       | 调课课程在教务处里的序号                         | 字符串         | 否             |
| 班级序号       | 调课课程开课班级的序号                           | 字符串         | 否             |
| 课程名称       | 调课课程名称                                     | 字符串         | 否             |
| 原上课周次     | 调课课程原先上课周次                             | 布尔类型的数组 | 否             |
| 新上课周次     | 调课课程新的上课周次                             | 布尔类型的数组 | 是，如果无更改 |
| 原上课教师     | 该次安排中原先的上课教师                         | 字符串         | 否             |
| 新上课教师     | 该次安排中新的上课教师                           | 字符串         | 是，如果无更改 |
| 原上课教室     | 原先上课的地点                                   | 字符串         | 否             |
| 新上课教室     | 新上课的地点                                     | 字符串         | 是，如果无更改 |
| 原上课星期     | 原先该周星期几上课，建议从1开始计数              | 整型数         | 否             |
| 新上课星期     | 新该周星期几上课，建议从1开始计数                | 整型数         | 是，如果无更改 |
| 原上课开始时间 | 原先第几节课开始，建议从1开始计数                | 整型数         | 否             |
| 新上课开始时间 | 新第几节课开始，建议从1开始计数                  | 整型数         | 是，如果无更改 |
| 原上课结束时间 | 原先第几节课结束，建议从1开始计数                | 整型数         | 否             |
| 新上课结束时间 | 新第几节课结束，建议从1开始计数                  | 整型数         | 是，如果无更改 |

### 未安排课程信息

未安排课程信息具体如下：

| 名称     | 功能                   | 格式   | 是否可空     |
| -------- | ---------------------- | ------ | ------------ |
| 名称     | 显示课程名称           | 字符串 | 否           |
| 课程序号 | 该课程在教务处里的序号 | 字符串 | 是，但最好否 |
| 班级序号 | 开课班级的序号         | 字符串 | 是，但最好否 |
| 负责老师 | 由谁负责这门课         | 字符串 | 是，但最好否 |

## 成绩信息

成绩信息如下表所示

| 名称         | 功能                                         | 格式   | 是否可空             |
| ------------ | -------------------------------------------- | ------ | -------------------- |
| 名称         | 学科名称                                     | 字符串 | 否                   |
| 分数         | 数值分数                                     | 浮点数 | 是，如果尚未登记成绩 |
| 学年         | 学年学期信息，按照开学年-结束年-第几学期计算 | 字符串 | 否                   |
| 学分         | 该课程获得的学分                             | 浮点数 | 否                   |
| 课程性质     | 必修/选修                                    | 字符串 | 否                   |
| 课程类别     | 该课程类别                                   | 字符串 | 否                   |
| 计分方式     | 三级成绩/五级成绩/两级成绩                   | 枚举   | 否                   |
| 等级         | 仅适用于三级成绩/五级成绩/两级成绩           | 字符串 | 是                   |
| 是否通过     | 是否及格                                     | 布尔   | 是，如果尚未登记成绩 |
| 教学班序列号 | 用于可能的查排名                             | 字符串 | 是                   |

如果查排名能做，需要传递教学班序列号**和一个当前用户认证机制**来获得！

## 校园卡流水

需要通过开始日期和结束日期信息查询由消费地点、消费时间、消费金钱的数组。

## 图书馆借书信息

暂时不考虑查询书库信息，这个估计用API侦测那坨学校也不知道……

| 名称               | 功能                       | 格式   | 是否可空           |
| ------------------ | -------------------------- | ------ | ------------------ |
| 借书名称           | 借书的名称                 | 字符串 | 否                 |
| 借书作者           | 该书籍的作者               | 字符串 | 否                 |
| 借书发行商         | 该书籍的发行商             | 字符串 | 否                 |
| 借书 ISBN          | 该书籍的isbn，用于获取封面 | 字符串 | 否                 |
| 借书记录 ID        | recordId                   | 整型数 | 否                 |
| 借书 ID            | loanId                     | 整型数 | 否                 |
| 书籍本身的 ID      | itemId                     | 整型数 | 否                 |
| 借书日期           | 开始借书的日期             | 日期   | 否                 |
| 续借日期           | 如有续借，续借日期         | 日期   | 是，如果从未续借过 |
| 理论还书日期       | 借书期限到期日期           | 日期   | 否                 |
| 借书类型           | loanType                   | 字符串 | 否                 |
| 书本身的一维码信息 | barCode                    | 字符串 | 否                 |

这里有很多的 Id 只是为了搞续借功能。

## 考试安排

考试安排包括有时间的考试安排和暂无考试安排的科目。

| 名称     | 功能                   | 格式        | 是否可空                     |
| -------- | ---------------------- | ----------- | ---------------------------- |
| 考试科目 | 考试科目名称           | 字符串      | 否                           |
| 考试类型 | 开学考试/期中期末/补考 | 枚举/字符串 | 否                           |
| 开始时间 | 考试开始时间           | 日期        | 否                           |
| 结束时间 | 考试结束时间           | 日期        | 否                           |
| 考试地点 | 考试                   | 整型数      | 是，万一是计算机导论考试之类 |
| 座位号   | 考试座位号             | 字符串      | 是，万一是计算机导论考试之类 |

暂无考试科目仅需考虑科目名称和科目的教务处编号。

## 空闲教室

需要发送这些信息：

| 名称       | 功能                                      | 格式        | 是否可空                 |
| ---------- | ----------------------------------------- | ----------- | ------------------------ |
| 教室地点   | 广研/杭研/北校区/南校区，同时只能满足一个 | 字符串      | 否                       |
| 查询日期   | 四位数年份-两位数月份-两位数日期字符串    | 枚举/字符串 | 否                       |
| 搜索关键词 | 搜索建筑物的关键词                        | 字符串      | 否，就算没有也发空字符串 |

获得以下信息的数组：

| 名称     | 功能                                      | 格式   | 是否可空 |
| -------- | ----------------------------------------- | ------ | -------- |
| 教室名称 | 广研/杭研/北校区/南校区，同时只能满足一个 | 字符串 | 否       |
| 1-2有课  | 第一节课到第二节课是否有课                | 布尔   | 否       |
| 3-4有课  | 第三节课到第四节课是否有课                | 布尔   | 否       |
| 5-6有课  | 第五节课到第六节课是否有课                | 布尔   | 否       |
| 7-8有课  | 第七节课到第八节课是否有课                | 布尔   | 否       |
| 9-10有课 | 第九节课到第十节课是否有课                | 布尔   | 否       |

## 电费和能源欠费

仅查询，就俩数的事情。

## 体育信息

体育课程信息分为上课教师记录和体测记录，乐跑计数不做。

体育课程信息是每学期选课的结果，暂时不融入日程表。

| 名称         | 功能                                     | 格式   | 是否可空 |
| ------------ | ---------------------------------------- | ------ | -------- |
| 学期名称     | 学期开始年份-学期结束年份-第几学期字符串 | 字符串 | 否       |
| 课程名称     | 上课课程名称                             | 字符串 | 否       |
| 老师姓名     | 上课教师姓名                             | 字符串 | 否       |
| 上课星期     | 星期几上课，建议从1开始计数              | 整型   | 否       |
| 开始上课时间 | 第几节课开始，建议从1开始计数            | 整型   | 否       |
| 结束上课时间 | 第几节课结束，建议从1开始计数            | 整型   | 否       |
| 课程成绩     | 如果结课，成绩多少                       | 整型   | 是       |

体测成绩比较复杂，分为总信息，分项信息，最后加上所有体测的总成绩和等级，以及计算规则。

分项信息

| 名称     | 功能                       | 格式        | 是否可空 |
| -------- | -------------------------- | ----------- | -------- |
| 项目名称 | 测试项目名称               | 字符串      | 否       |
| 单位     | 该项目单位                 | 字符串      | 否       |
| 实际成绩 | 测试数值                   | 字符串      | 否       |
| 数值成绩 | 转换后的成绩               | 整型数      | 否       |
| 等级     | 优秀/良好/中等/合格/不合格 | 枚举/字符串 | 否       |

总信息

| 名称         | 功能                                     | 格式         | 是否可空 |
| ------------ | ---------------------------------------- | ------------ | -------- |
| 测试年份     | 学期开始年份-学期结束年份-第几学期字符串 | 字符串       | 否       |
| 总成绩       | 该年体测总成绩                           | 字符串       | 否       |
| 等级         | 体测等级                                 | 字符串       | 否       |
| 分项信息数组 | 具体成绩信息                             | 分项信息数组 | 否       |

## 物理实验信息

这玩意能搞就要搞

| 名称     | 功能                     | 格式   | 是否可空         |
| -------- | ------------------------ | ------ | ---------------- |
| 名称     | 实验名称                 | 字符串 | 否               |
| 开始时间 | 实验开始时间             | 日期   | 否               |
| 结束时间 | 实验结束时间             | 日期   | 否               |
| 负责老师 | 该次实验负责老师         | 字符串 | 否               |
| 地点     | 实验地点                 | 字符串 | 否               |
| 座位号   | 实验要填的座位号         | 字符串 | 否               |
| 成绩     | 如果老师想起来记成绩的话 | 字符串 | 是，就怕老师忘了 |
