/*
 * This file is part of Satunes.
 *
 * Satunes is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * Satunes is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with Satunes.
 * If not, see <https://www.gnu.org/licenses/>.
 *
 * *** INFORMATION ABOUT THE AUTHOR *****
 * The author of this file is Antoine Pirlot, the owner of this project.
 * You find this original project on Codeberg.
 *
 * My Codeberg link is: https://codeberg.org/antoinepirlot
 * This current project's link is: https://codeberg.org/antoinepirlot/Satunes
 */

package io.github.antoinepirlot.satunes.database.models

import androidx.compose.runtime.MutableState
import androidx.compose.runtime.mutableStateOf
import io.github.antoinepirlot.satunes.database.R

/**
 * @author Antoine Pirlot on 03/02/24
 */

enum class NavBarSection(
    internal val id: Int,
    open val stringId: Int,
    var isEnabled: MutableState<Boolean> = mutableStateOf(true),
) {
    FOLDERS(id = 0, stringId = R.string.folders),
    ARTISTS(id = 1, stringId = R.string.artists),
    MUSICS(id = 2, stringId = R.string.musics),
    ALBUMS(id = 3, stringId = R.string.albums),
    GENRES(id = 4, stringId = R.string.genres),
    PLAYLISTS(id = 5, stringId = R.string.playlists);

    companion object {
        fun enableAll() {
            FOLDERS.isEnabled.value = true
            ARTISTS.isEnabled.value = true
            MUSICS.isEnabled.value = true
            ALBUMS.isEnabled.value = true
            GENRES.isEnabled.value = true
            PLAYLISTS.isEnabled.value = true
        }
    }
}