/*
 * This file is part of Satunes.
 *
 * Satunes is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * Satunes is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with Satunes.
 * If not, see <https://www.gnu.org/licenses/>.
 *
 * *** INFORMATION ABOUT THE AUTHOR *****
 * The author of this file is Antoine Pirlot, the owner of this project.
 * You find this original project on Codeberg.
 *
 * My Codeberg link is: https://codeberg.org/antoinepirlot
 * This current project's link is: https://codeberg.org/antoinepirlot/Satunes
 */

package io.github.antoinepirlot.satunes.ui.views.media.folder

import androidx.compose.foundation.layout.Column
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.lifecycle.viewmodel.compose.viewModel
import io.github.antoinepirlot.satunes.R
import io.github.antoinepirlot.satunes.data.viewmodels.DataViewModel
import io.github.antoinepirlot.satunes.data.viewmodels.SatunesViewModel
import io.github.antoinepirlot.satunes.database.models.media.Folder
import io.github.antoinepirlot.satunes.database.models.media.MediaImpl
import io.github.antoinepirlot.satunes.database.models.media.RootFolder
import io.github.antoinepirlot.satunes.ui.components.bars.media.FoldersPathRow
import io.github.antoinepirlot.satunes.ui.components.buttons.fab.ExtraButtonList
import io.github.antoinepirlot.satunes.ui.views.media.MediaListView

/**
 * @author Antoine Pirlot on 01/04/2024
 */


@Composable
internal fun FolderView(
    modifier: Modifier = Modifier,
    satunesViewModel: SatunesViewModel = viewModel(),
    dataViewModel: DataViewModel = viewModel(),
    folder: Folder,
) {
    val subFolders: MutableList<MediaImpl> = mutableListOf()
    if (folder !is RootFolder) subFolders.add(dataViewModel.getBackFolder())
    subFolders.addAll(elements = folder.getSubFolderListWithMusics())

    LaunchedEffect(key1 = dataViewModel.isLoaded) {
        if (folder.isNotEmpty())
            satunesViewModel.replaceExtraButtons(extraButtons = { ExtraButtonList() })
        else
            satunesViewModel.clearExtraButtons()
    }

    Column(modifier = modifier) {
        if (folder !== dataViewModel.getRootFolder())
            FoldersPathRow(endFolder = folder)
        MediaListView(
            mediaImplCollection = subFolders,
            emptyViewText = stringResource(id = R.string.no_music)
        )
    }
}

@Preview
@Composable
private fun FolderViewPreview() {
    FolderView(folder = Folder(title = "Folder title"))
}