/*
 * This file is part of Satunes.
 * Satunes is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 *  Satunes is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License along with Satunes.
 *  If not, see <https://www.gnu.org/licenses/>.
 *
 * ** INFORMATION ABOUT THE AUTHOR *****
 * The author of this file is Antoine Pirlot, the owner of this project.
 * You find this original project on Codeberg.
 *
 * My Codeberg link is: https://codeberg.org/antoinepirlot
 * This current project's link is: https://codeberg.org/antoinepirlot/Satunes
 */

package io.github.antoinepirlot.satunes.ui.components.settings.library.folders

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.lifecycle.viewmodel.compose.viewModel
import io.github.antoinepirlot.jetpack_libs.components.texts.NormalText
import io.github.antoinepirlot.satunes.R
import io.github.antoinepirlot.satunes.data.states.FolderSelectionUiState
import io.github.antoinepirlot.satunes.data.viewmodels.FolderSelectionViewModel
import io.github.antoinepirlot.satunes.database.models.FoldersSelection
import io.github.antoinepirlot.satunes.ui.components.buttons.settings.library.folders.FolderPathRow
import io.github.antoinepirlot.satunes.ui.components.buttons.settings.library.folders.FoldersPathButtons

/**
 * @author Antoine Pirlot on 09/08/2024
 */

@Composable
internal fun FoldersPathsSelection(
    modifier: Modifier = Modifier,
    folderSelectionViewModel: FolderSelectionViewModel = viewModel()
) {
    val folderSelectionUiState: FolderSelectionUiState by folderSelectionViewModel.uiState.collectAsState()
    val isIncludeSelected: Boolean =
        folderSelectionUiState.folderSelectionSelected == FoldersSelection.INCLUDE
    Column(
        modifier = modifier.fillMaxWidth(),
        horizontalAlignment = Alignment.CenterHorizontally,
    ) {
        if (isIncludeSelected) {
            val folders: Collection<String> =
                folderSelectionViewModel.foldersPathsIncludingCollection
            if (folders.isNotEmpty())
                for (path: String in folders)
                    FolderPathRow(path = path)
            else
                NormalText(text = stringResource(id = R.string.path_set_empty))
        } else {
            val folders: Collection<String> =
                folderSelectionViewModel.foldersPathsExcludingCollection
            if (folders.isNotEmpty())
                for (path: String in folders)
                    FolderPathRow(path = path)
            else
                NormalText(text = stringResource(id = R.string.path_set_empty))

        }
        FoldersPathButtons()
    }
}

@Preview
@Composable
private fun FoldersPathsSelectionPreview() {
    FoldersPathsSelection()
}