/*
 * This file is part of Satunes.
 *
 * Satunes is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * Satunes is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with Satunes.
 * If not, see <https://www.gnu.org/licenses/>.
 *
 * *** INFORMATION ABOUT THE AUTHOR *****
 * The author of this file is Antoine Pirlot, the owner of this project.
 * You find this original project on Codeberg.
 *
 * My Codeberg link is: https://codeberg.org/antoinepirlot
 * This current project's link is: https://codeberg.org/antoinepirlot/Satunes
 */

package io.github.antoinepirlot.satunes.ui.components.buttons.updates

import android.content.Context
import android.os.Build
import androidx.annotation.RequiresApi
import androidx.compose.material3.Button
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import io.github.antoinepirlot.jetpack_libs.components.texts.NormalText
import io.github.antoinepirlot.satunes.internet.R
import io.github.antoinepirlot.satunes.internet.updates.UpdateAvailableStatus
import io.github.antoinepirlot.satunes.ui.utils.openUrl

/**
 * @author Antoine Pirlot on 14/04/2024
 */

private const val FDROID_SATUNES_URL: String =
    "https://f-droid.org/fr/packages/io.github.antoinepirlot.satunes/"

@Composable
@RequiresApi(Build.VERSION_CODES.M)
internal fun SeeDetailsButton(
    modifier: Modifier = Modifier,
    text: String = stringResource(id = R.string.see_on_codeberg),
    onFdroid: Boolean = false
) {
    val context: Context = LocalContext.current
    Button(
        modifier = modifier,
        onClick = {
            val url: String =
                if (onFdroid) FDROID_SATUNES_URL else UpdateAvailableStatus.AVAILABLE.updateLink!!
            openUrl(
                context = context,
                url = url
            )
        }
    ) {
        NormalText(text = text)
    }
}

@Preview
@Composable
@RequiresApi(Build.VERSION_CODES.M)
private fun SeeDetailsButtonPreview() {
    SeeDetailsButton()
}