## Introduction

[dart_pubspec_licenses](https://pub.dev/packages/dart_pubspec_licenses) is a package that helps gather and assemble OSS license info using `pubspec.lock`.

## Installing

Adding the package name to `dev_dependencies`; not to `dependencies` because the package does nothing on runtime.

Of course, if you just want to create some program that handles Dart/Flutter dependency information, you can use the package in your `dependencies`.

```yaml
dev_dependencies:
  dart_pubspec_licenses: ^3.0.7
```

## Generate oss_licenses.dart

Before executing the command, you must update your `pubspec.lock` using `pub get` (or `pub upgrade` if you want).

```shell
dart pub get
```

And then, the following command generates `oss_licenses.dart` on the project's `lib/` directory:

```shell
dart run dart_pubspec_licenses:generate
```

The following fragment is just a part of generated `lib/oss_licenses.dart`:

```dart
const thisPackage = _example;

const allDependencies = <Package>[
  __fe_analyzer_shared,
  _analyzer,
  _args,
  _async,
  _boolean_selector,
  _build,
  _build_config,
  _build_daemon,
  _build_runner,
  ...
];

/// Direct `dependencies`.
const dependencies = <Package>[
  _flutter,
  _cupertino_icons,
  _url_launcher
];

/// Direct `dev_dependencies`.
const devDependencies = <Package>[
  _flutter_lints,
  _flutter_oss_licenses
];

/// Package license definition.
class Package {
  /// Package name
  final String name;
  /// Description
  final String description;
  /// Authors
  final List<String> authors;
  /// Whether the license is in markdown format or not (plain text).
  final bool isMarkdown;
  /// Whether the package is included in the SDK or not.
  final bool isSdk;
  /// Direct dependencies
  final List<PackageRef> dependencies;
  /// Website URL
  final String? homepage;
  /// Repository URL
  final String? repository;
  /// Version
  final String? version;
  /// License
  final String? license;

  const Package({
    required this.name,
    required this.description,
    required this.authors,
    required this.isMarkdown,
    required this.isSdk,
    required this.dependencies,
    this.homepage,
    this.repository,
    this.version,
    this.license,
  });
}

class PackageRef {
  final String name;

  const PackageRef(this.name);

  Package resolve() => allDependencies.firstWhere((d) => d.name == name);
}

/// args 2.6.0
const _args = Package(
    name: 'args',
    description: 'Library for defining parsers for parsing raw command-line arguments into a set of options and values using GNU and POSIX style options.',
    repository: 'https://github.com/dart-lang/core/main/pkgs/args',
    authors: [],
    version: '2.6.0',
    license: '''Copyright 2013, the Dart project authors. 

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of Google LLC nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.''',
    isMarkdown: false,
    isSdk: false,
    dependencies: []
  );

...

```

The `Package` class here is defined inside the same file but it's almost identical to [dart_pubspec_licenses](https://pub.dev/packages/dart_pubspec_licenses)'s [Package](https://pub.dev/documentation/dart_pubspec_licenses/latest/dart_pubspec_licenses/Package-class.html) class except it does not have `directory` and `packageYaml` fields.

For a full generated sample, see example code's [oss_licenses.dart](https://github.com/espresso3389/flutter_oss_licenses/blob/master/packages/flutter_oss_licenses/example/lib/oss_licenses.dart).

## Command line options

The following command line generates JSON file instead of dart file:

```shell
dart run dart_pubspec_licenses:generate -o licenses.json --json
```

The following table lists the acceptable options:

| Option                        | Abbr. | Description                                                                                                                                                                                                                                                               |
| ----------------------------- | ----- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `--output OUTPUT_FILE_PATH`   | `-o`  | Specify output file path. If the file extension is .json, --json option is implied anyway. The default output file path depends on the `--json` flag:<br>with `--json`: `PROJECT_ROOT/assets/oss_licenses.json`<br>without `--json`: `PROJECT_ROOT/lib/oss_licenses.dart` |
| `--ignore PACKAGE[,...]` | `-i` | Ignore packages by names.<br>This option can be specified multiple times, or as a comma-separated list.
| `--project-root PROJECT_ROOT` | `-p`  | Explicitly specify project root directory that contains `pubspec.lock`.                                                                                                                                                                                                   |
| `--json`                      | `-j`  | Generate JSON file rather than dart file.                                                                                                                                                                                                                                 |
| `--help`                      | `-h`  | Show the help.                                                                                                                                                                                                                                                            |

### Environment variables

The `bin/generate.dart` uses one or two environment variable(s) depending on your use case:

- `PUB_CACHE` is used to determine package directory.
- `FLUTTER_ROOT` is for Flutter projects only. If not set, Flutter SDK dependencies are simply ignored and not listed.

They are normally set by `dart run`.

## Reporting issues

Report any bugs on the project's [issues](https://github.com/espresso3389/flutter_oss_licenses/issues).

## URLs

- [Project page on GitHub](https://github.com/espresso3389/flutter_oss_licenses)
