![Audio Waveforms - Simform LLC.](https://raw.githubusercontent.com/SimformSolutionsPvtLtd/audio_waveforms/main/preview/banner.png)

# Audio Waveforms

[![pub package](https://img.shields.io/pub/v/audio_waveforms.svg)](https://pub.dev/packages/audio_waveforms)
[![license](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/SimformSolutionsPvtLtd/audio_waveforms/blob/main/LICENSE)

A Flutter package to generate waveforms while recording audio or from audio files. Features gesture controls to scroll through waveforms or seek positions, with extensive customization options.

_Check out other amazing open-source [Flutter libraries](https://simform-flutter-packages.web.app) and [Mobile libraries](https://github.com/SimformSolutionsPvtLtd/Awesome-Mobile-Libraries) developed by Simform Solutions!_

## Preview

![Audio Waveforms Demo](https://raw.githubusercontent.com/SimformSolutionsPvtLtd/audio_waveforms/main/preview/demo_v2_0_0.gif)

## Features

- **Recording**: Record audio with customizable encoder settings
- **Waveform Display**: Visualize audio in real-time during recording
- **Playback**: Play audio files with waveform visualization
- **Gesture Controls**: Scroll through waveforms and seek to specific positions
- **Customization**: Style waveforms with colors, gradients, and various appearance options
- **Waveform Extraction**: Extract and save waveform data for better performance

## Documentation

Visit our [documentation](https://simform-flutter-packages.web.app/audioWaveForm) site for all implementation details, usage instructions, code examples, and advanced features.

## Installation

```yaml
dependencies:
  audio_waveforms: <latest-version>
```

## Support

For questions, issues, or feature requests, [create an issue](https://github.com/SimformSolutionsPvtLtd/audio_waveforms/issues) on GitHub or reach out via the GitHub Discussions tab. We're happy to help and encourage community contributions.
To contribute documentation updates specifically, please make changes to the doc/documentation.md file and submit a pull request.

## License

This project is licensed under the MIT License - see the [LICENSE](https://simform-flutter-packages.web.app/audioWaveForm/license) file for details.