# How to Install Repertoire on Your Android Phone

There are two ways to install Repertoire on your Android device. The recommended method is through F-Droid, which provides automatic updates.

---

## Option 1: Install from F-Droid (Recommended)

F-Droid is a trusted, community-maintained software repository for Android. Installing from F-Droid is the easiest way to get the app and keep it updated.

1.  **Get the F-Droid Client:** If you don't already have it, install the F-Droid client from the [official F-Droid website](https://f-droid.org/). You'll need to follow their instructions to allow installation of apps from your browser.
2.  **Open the App Page:** Once F-Droid is installed, you can open the Repertoire app page by clicking the logo below, or by searching for "Repertoire" in the F-Droid app.

    <a href="https://f-droid.org/en/packages/io.github.adithya_jayan.myrepertoirapp.fdroid/">
      <img src="https://gitlab.com/fdroid/fdroidclient/-/raw/master/logo-icon.svg" alt="Get it on F-Droid" height="80">
    </a>

3.  **Install:** Tap the "Install" button on the app page in F-Droid. The app will be downloaded, installed, and automatically updated in the future.

---

## Option 2: Manual Installation (Advanced)

If you prefer not to use F-Droid, you can download and install the app manually from our GitHub releases.

### Step 1: Download the App Installer

The installer file for an Android app is called an "APK" file.

1.  **[Click here to go to the latest release page.](https://github.com/Adithya-Jayan/MyRepertoirApp/releases/latest)**
2.  On the release page, scroll down until you see a section labeled **Assets**. You may need to tap on it to see the list of files.
3.  Look for the file that ends with `.apk`. It will typically be named `app-arm64-v8a-fdroid-release.apk` (for newer phones) or `app-armeabi-v7a-fdroid-release.apk` (for older phones).
4.  Tap on that file to download it to your phone.

Here is what the "Assets" section looks like. You want to download one of the highlighted files:
```
▼ Assets
  app-arm64-v8a-fdroid-release.apk      <-- TAP THIS ONE (Most common)
  app-armeabi-v7a-fdroid-release.apk    <-- OR THIS ONE (Older phones)
  app-x86_64-fdroid-release.apk
  app-fdroid-release.aab
  Source code (zip)
  Source code (tar.gz)
  web_build.zip
```
*(Note: The other files like `.aab` and `.sha256` are for developers or for verifying the download. You can safely ignore them.)*

### Step 2: Allow Installation from Your Browser

Android has a security feature that may block installations from outside the Google Play Store. You'll need to give your browser permission to install the app.

1.  Once the download is complete, tap the notification to open the downloaded `.apk` file. (If you can't find it, open your phone's "Files" or "Downloads" app).
2.  Your phone will likely show a security pop-up message saying you are not allowed to install unknown apps from this source (e.g., from your web browser).
3.  This pop-up should have a **"Settings"** button. Tap it.
4.  You will be taken to a screen with an option like **"Allow from this source"**. Toggle the switch to enable it.
5.  Press the back button. You will now be able to proceed with the installation.

### Step 3: Install the App

After allowing the installation, you should see a screen asking for confirmation to install Repertoire.

1.  Tap the **"Install"** button.
2.  Wait for the installation to complete.
3.  Once it's done, you can tap **"Open"** to start using the app right away, or **"Done"** to open it later from your phone's home screen or app drawer.

That's it! The Repertoire app is now installed and ready to use on your phone.
