// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get enterYourEmailAddress => '请输入您的电子邮件地址';

  @override
  String get enterYourNewEmailAddress => '输入您的新电子邮件地址';

  @override
  String get accountWelcomeBack => '欢迎回来！';

  @override
  String get emailAlreadyRegistered => '此电子邮件地址已被注册。';

  @override
  String get emailNotRegistered => '此电子邮件地址未被注册。';

  @override
  String get email => '电子邮件地址';

  @override
  String get cancel => '取消';

  @override
  String get verify => '验证';

  @override
  String get invalidEmailAddress => '无效的电子邮件地址';

  @override
  String get enterValidEmail => '请输入一个有效的电子邮件地址。';

  @override
  String get deleteAccount => '删除账户';

  @override
  String get deleteAccountWarning => '这将删除您的Ente 验证器、Ente 照片和 Ente 文件柜账户。';

  @override
  String get askDeleteReason => '您删除账户的主要原因是什么？';

  @override
  String get deleteAccountFeedbackPrompt => '我们很抱歉看到您离开。请分享您的反馈以帮助我们改进。';

  @override
  String get feedback => '反馈';

  @override
  String get kindlyHelpUsWithThisInformation => '请帮助我们了解这个信息';

  @override
  String get confirmDeletePrompt => '是的，我想永久删除此账户及其所有关联的应用程序的数据。';

  @override
  String get confirmAccountDeletion => '确认删除账户';

  @override
  String get deleteAccountPermanentlyButton => '永久删除账户';

  @override
  String get yourAccountHasBeenDeleted => '您的账户已删除';

  @override
  String get selectReason => '选择原因';

  @override
  String get deleteReason1 => '缺少我所需的关键功能';

  @override
  String get deleteReason2 => '应用或某项功能未按预期运行';

  @override
  String get deleteReason3 => '我发现另一个产品更好用';

  @override
  String get deleteReason4 => '其他原因';

  @override
  String get sendEmail => '发送电子邮件';

  @override
  String get deleteRequestSLAText => '您的请求将在 72 小时内处理。';

  @override
  String get deleteEmailRequest =>
      '请从您注册的电子邮件地址发送电子邮件到 <warning>account-delettion@ente.io</warning>。';

  @override
  String get entePhotosPerm => 'Ente <i>需要许可</i>才能保存您的照片';

  @override
  String get ok => 'OK';

  @override
  String get createAccount => '创建账户';

  @override
  String get createNewAccount => '创建新账号';

  @override
  String get password => '密码';

  @override
  String get confirmPassword => '请确认密码';

  @override
  String get activeSessions => '已登录的设备';

  @override
  String get ocrProcessingOverlayMessage => '正在检测文本……';

  @override
  String get ocrLoadingIndicatorLabel => '正在检测文本';

  @override
  String get ocrSelectionHint => '滑动或双击即可选择所需内容';

  @override
  String get ocrNoTextDetected => '未检测到文本';

  @override
  String get ocrRetryButtonLabel => '重试';

  @override
  String get ocrModelsNetworkRequiredError => '首次使用时需要连接网络才能下载 OCR 模型';

  @override
  String get ocrModelsPrepareFailed => '无法准备 OCR 模型';

  @override
  String get ocrImageNotFoundError => '未找到图像文件';

  @override
  String get ocrImageDecodeFailedError => '无法读取图像文件';

  @override
  String get ocrGenericDetectError => '无法检测到图像中的文本';

  @override
  String get oops => '哎呀';

  @override
  String get somethingWentWrongPleaseTryAgain => '出了点问题，请重试';

  @override
  String get thisWillLogYouOutOfThisDevice => '这将使您在此设备上退出登录！';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice => '这将使您在以下设备中退出登录：';

  @override
  String get terminateSession => '是否终止会话？';

  @override
  String get terminate => '终止';

  @override
  String get thisDevice => '此设备';

  @override
  String get recoverButton => '恢复';

  @override
  String get recoverySuccessful => '恢复成功!';

  @override
  String get decrypting => '解密中...';

  @override
  String get incorrectRecoveryKeyTitle => '恢复密钥不正确';

  @override
  String get incorrectRecoveryKeyBody => '您输入的恢复密钥不正确';

  @override
  String get forgotPassword => '忘记密码';

  @override
  String get enterYourRecoveryKey => '输入您的恢复密钥';

  @override
  String get noRecoveryKey => '没有恢复密钥吗？';

  @override
  String get sorry => '抱歉';

  @override
  String get noRecoveryKeyNoDecryption =>
      '由于我们端到端加密协议的性质，如果没有您的密码或恢复密钥，您的数据将无法解密';

  @override
  String get verifyEmail => '验证电子邮件';

  @override
  String get toResetVerifyEmail => '要重置您的密码，请先验证您的电子邮件。';

  @override
  String get checkInboxAndSpamFolder => '请检查您的收件箱 (或者是在您的“垃圾邮件”列表内) 以完成验证';

  @override
  String get tapToEnterCode => '点击以输入代码';

  @override
  String get resendEmail => '重新发送电子邮件';

  @override
  String weHaveSendEmailTo({required String email}) {
    return '我们已经发送邮件到 <green>$email</green>';
  }

  @override
  String get setPasswordTitle => '设置密码';

  @override
  String get changePasswordTitle => '修改密码';

  @override
  String get resetPasswordTitle => '重置密码';

  @override
  String get encryptionKeys => '加密密钥';

  @override
  String get passwordWarning =>
      '我们不储存这个密码，所以如果忘记， <underline>我们将无法解密您的数据</underline>';

  @override
  String get enterPasswordToEncrypt => '输入我们可以用来加密您的数据的密码';

  @override
  String get enterNewPasswordToEncrypt => '输入我们可以用来加密您的数据的新密码';

  @override
  String get weakStrength => '弱';

  @override
  String get strongStrength => '强';

  @override
  String get moderateStrength => '中等';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return '密码强度： $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => '密码修改成功';

  @override
  String get generatingEncryptionKeys => '正在生成加密密钥...';

  @override
  String get pleaseWait => '请稍候...';

  @override
  String get continueLabel => '继续';

  @override
  String get insecureDevice => '设备不安全';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      '抱歉，我们无法在此设备上生成安全密钥。\n\n请使用其他设备注册。';

  @override
  String get howItWorks => '工作原理';

  @override
  String get encryption => '加密';

  @override
  String get ackPasswordLostWarning =>
      '我明白，如果我丢失密码，我可能会丢失我的数据，因为我的数据是 <underline>端到端加密的</underline>。';

  @override
  String get privacyPolicyTitle => '隐私政策';

  @override
  String get termsOfServicesTitle => '使用条款';

  @override
  String get signUpTerms =>
      '我同意 <u-terms>服务条款</u-terms> 和 <u-policy>隐私政策</u-policy>';

  @override
  String get logInLabel => '登录';

  @override
  String get loginTerms =>
      '点击登录时，默认我同意 <u-terms>服务条款</u-terms> 和 <u-policy>隐私政策</u-policy>';

  @override
  String get changeEmail => '修改邮箱';

  @override
  String get enterYourPassword => '输入您的密码';

  @override
  String get welcomeBack => '欢迎回来！';

  @override
  String get contactSupport => '联系支持';

  @override
  String get locationPickerTip => '您也可以在照片的详情界面上添加以照片为中心的定位';

  @override
  String get incorrectPasswordTitle => '密码错误';

  @override
  String get pleaseTryAgain => '请重试';

  @override
  String get recreatePasswordTitle => '重新创建密码';

  @override
  String get useRecoveryKey => '使用恢复密钥';

  @override
  String get recreatePasswordBody =>
      '当前设备的功能不足以验证您的密码，但我们可以以适用于所有设备的方式重新生成。\n\n请使用您的恢复密钥登录并重新生成您的密码（如果您希望，可以再次使用相同的密码）。';

  @override
  String get verifyPassword => '验证密码';

  @override
  String get recoveryKey => '恢复密钥';

  @override
  String get recoveryKeyOnForgotPassword => '如果您忘记了密码，恢复数据的唯一方法就是使用此密钥。';

  @override
  String get recoveryKeySaveDescription => '我们不会存储此密钥，请将此24个单词密钥保存在一个安全的地方。';

  @override
  String get doThisLater => '稍后再说';

  @override
  String get saveKey => '保存密钥';

  @override
  String get recoveryKeyCopiedToClipboard => '恢复密钥已复制到剪贴板';

  @override
  String get recoverAccount => '恢复账户';

  @override
  String get recover => '恢复';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return '请从您注册的邮箱发送一封邮件到 $supportEmail';
  }

  @override
  String get twofactorSetup => '双重认证设置';

  @override
  String get enterCode => '输入代码';

  @override
  String get scanCode => '扫描二维码/条码';

  @override
  String get codeCopiedToClipboard => '代码已复制到剪贴板';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      '请复制粘贴此代码\n到您的身份验证器应用程序上';

  @override
  String get tapToCopy => '点击以复制';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp => '用您的身份验证器应用\n扫描此条码';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      '从你的身份验证器应用中\n输入6位数字代码';

  @override
  String get confirm => '确认';

  @override
  String get setupComplete => '设置完成';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready => '若您尚未保存，请妥善保存此恢复密钥';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      '如果您丢失了双重认证方式，这可以用来恢复您的账户';

  @override
  String get twofactorAuthenticationPageTitle => '双重认证';

  @override
  String get lostDevice => '设备丢失？';

  @override
  String get verifyingRecoveryKey => '正在验证恢复密钥...';

  @override
  String get recoveryKeyVerified => '恢复密钥已验证';

  @override
  String get recoveryKeySuccessBody =>
      '太棒了！ 您的恢复密钥是有效的。 感谢您的验证。\n\n请记住要安全备份您的恢复密钥。';

  @override
  String get invalidRecoveryKey =>
      '您输入的恢复密钥无效。请确保它包含24个单词，并检查每个单词的拼写。\n\n如果您输入了旧的恢复码，请确保它长度为64个字符，并检查其中每个字符。';

  @override
  String get invalidKey => '无效的密钥';

  @override
  String get tryAgain => '请再试一次';

  @override
  String get viewRecoveryKey => '查看恢复密钥';

  @override
  String get confirmRecoveryKey => '确认恢复密钥';

  @override
  String get recoveryKeyVerifyReason =>
      '如果您忘记了密码，恢复密钥是恢复照片的唯一方法。您可以在“设置”>“账户”中找到恢复密钥。\n\n请在此处输入恢复密钥，以验证您是否已正确保存。';

  @override
  String get confirmYourRecoveryKey => '确认您的恢复密钥';

  @override
  String get addViewer => '添加查看者';

  @override
  String get addCollaborator => '添加协作者';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => '添加新的电子邮件';

  @override
  String get orPickAnExistingOne => '或者选择一个现有的';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      '协作者可以将照片和视频添加到共享相册中。';

  @override
  String get enterEmail => '输入电子邮件';

  @override
  String get albumOwner => '所有者';

  @override
  String get you => '您';

  @override
  String get collaborator => '协作者';

  @override
  String get addMore => '添加更多';

  @override
  String get viewer => '查看者';

  @override
  String get remove => '移除';

  @override
  String get removeParticipant => '移除参与者';

  @override
  String get manage => '管理';

  @override
  String get addedAs => '已添加为';

  @override
  String get changePermissions => '要修改权限吗？';

  @override
  String get yesConvertToViewer => '是的，转换为查看者';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user 将无法添加更多照片到此相册\n\n他们仍然能够删除他们添加的现有照片';
  }

  @override
  String get allowAddingPhotos => '允许添加照片';

  @override
  String get allowJoiningAlbum => '允许加入相册';

  @override
  String get allowAddPhotosDescription => '允许具有链接的人也将照片添加到共享相册。';

  @override
  String get passwordLock => '密码锁';

  @override
  String get canNotOpenTitle => '无法打开此相册';

  @override
  String get canNotOpenBody => '抱歉，该相册无法在应用中打开。';

  @override
  String get disableDownloadWarningTitle => '请注意';

  @override
  String get disableDownloadWarningBody => '查看者仍然可以使用外部工具截图或保存您的照片副本';

  @override
  String get allowDownloads => '允许下载';

  @override
  String get linkDeviceLimit => '设备限制';

  @override
  String get noDeviceLimit => '无';

  @override
  String get albumLayout => '相册布局';

  @override
  String get layoutGrouped => '已分组';

  @override
  String get layoutContinuous => '连续';

  @override
  String get layoutTrip => '旅游';

  @override
  String get preview => '预览';

  @override
  String get linkExpiry => '链接过期';

  @override
  String get linkExpired => '已过期';

  @override
  String get linkEnabled => '已启用';

  @override
  String get linkNeverExpires => '永不';

  @override
  String get expiredLinkInfo => '此链接已过期。请选择新的过期时间或禁用链接有效期。';

  @override
  String get setAPassword => '设置密码';

  @override
  String get lockButtonLabel => '锁定';

  @override
  String get enterPassword => '输入密码';

  @override
  String get removeLink => '移除链接';

  @override
  String get manageLink => '管理链接';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return '链接将在 $expiryTime 过期';
  }

  @override
  String get albumUpdated => '相册已更新';

  @override
  String get never => '永不';

  @override
  String get custom => '自定义';

  @override
  String get after1Hour => '1小时后';

  @override
  String get after1Day => '1天后';

  @override
  String get after1Week => '1 周后';

  @override
  String get after1Month => '1个月后';

  @override
  String get after1Year => '1 年后';

  @override
  String get manageParticipants => '管理';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 个参与者',
      one: '1个参与者',
      zero: '无参与者',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      '创建一个链接来让他人无需 Ente 应用程序或账户即可在您的共享相册中添加和查看照片。非常适合收集活动照片。';

  @override
  String get collectPhotos => '收集照片';

  @override
  String get collaborativeLink => '协作链接';

  @override
  String get shareWithNonenteUsers => '与非 Ente 用户共享';

  @override
  String get createPublicLink => '创建公开链接';

  @override
  String get sendLink => '发送链接';

  @override
  String get qrCode => '二维码';

  @override
  String get sendQrCode => '发送二维码';

  @override
  String get copyLink => '复制链接';

  @override
  String get copyEmbedHtml => '复制嵌入 HTML';

  @override
  String get linkHasExpired => '链接已过期';

  @override
  String get publicLinkEnabled => '公开链接已启用';

  @override
  String get shareALink => '分享链接';

  @override
  String get sharedAlbumSectionDescription => '与其他 Ente 用户（包括免费计划用户）创建共享和协作相册。';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: '与 $numberOfPeople 人共享',
      one: '与 1 人共享',
      zero: '与特定人员共享',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => '这是您的验证 ID';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      '与您共享相册的人应该会在他们的设备上看到相同的 ID。';

  @override
  String get howToViewShareeVerificationID =>
      '请让他们在设置屏幕上长按他们的电子邮件地址，并验证两台设备上的 ID 是否匹配。';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return '这是 $email 的验证ID';
  }

  @override
  String get verificationId => '验证 ID';

  @override
  String verifyEmailID({required Object email}) {
    return '验证 $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email 没有 Ente 帐户。\n\n向他们发出共享照片的邀请。';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return '这是我的ente.io 的验证 ID： $verificationID。';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return '嘿，你能确认这是你的 ente.io 验证 ID吗：$verificationID';
  }

  @override
  String get somethingWentWrong => '出了些问题';

  @override
  String get sendInvite => '发送邀请';

  @override
  String get shareTextRecommendUsingEnte => '下载 Ente，让我们轻松共享高质量的原始照片和视频';

  @override
  String get done => '已完成';

  @override
  String get applyCodeTitle => '应用代码';

  @override
  String get enterCodeDescription => '输入您的朋友提供的代码来为您申请免费存储';

  @override
  String get apply => '应用';

  @override
  String get failedToApplyCode => '无法使用此代码';

  @override
  String get enterReferralCode => '输入推荐代码';

  @override
  String get codeAppliedPageTitle => '代码已应用';

  @override
  String get changeYourReferralCode => '更改您的推荐代码';

  @override
  String get change => '更改';

  @override
  String get unavailableReferralCode => '抱歉，此代码不可用。';

  @override
  String get codeChangeLimitReached => '抱歉，您已达到代码更改的限制。';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return '请联系$familyAdminEmail 以更改您的代码。';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => '已领取';

  @override
  String get details => '详情';

  @override
  String get claimMore => '领取更多！';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return '他们也会获得 $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '每当有人使用您的代码注册付费计划时您将获得$storageAmountInGB GB';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Ente 推荐代码：$referralCode\n\n在 \"设置\"→\"通用\"→\"推荐 \"中应用它，即可在注册付费计划后免费获得 $referralStorageInGB GB 存储空间\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => '领取免费存储';

  @override
  String get inviteYourFriends => '邀请您的朋友';

  @override
  String get failedToFetchReferralDetails => '无法获取引荐详细信息。 请稍后再试。';

  @override
  String get referralStep1 => '1. 将此代码提供给您的朋友';

  @override
  String get referralStep2 => '2. 他们注册一个付费计划';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. 你和朋友都将免费获得 $storageInGB GB*';
  }

  @override
  String get referralsAreCurrentlyPaused => '推荐已暂停';

  @override
  String get youCanAtMaxDoubleYourStorage => '* 您最多可以将您的存储空间增加一倍';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': '到目前为止，您的家庭已经领取了 $storageAmountInGb GB',
      'false': '到目前为止，您已经领取了 $storageAmountInGb GB',
      'other': '到目前为止，您已经领取了$storageAmountInGb GB',
    });
    return '$_temp0';
  }

  @override
  String get faq => '常见问题';

  @override
  String get help => '帮助';

  @override
  String get oopsSomethingWentWrong => '哎呀，似乎出了点问题';

  @override
  String get peopleUsingYourCode => '使用您的代码的人';

  @override
  String get eligible => '符合资格';

  @override
  String get total => '总计';

  @override
  String get codeUsedByYou => '您所使用的代码';

  @override
  String get freeStorageClaimed => '已领取的免费存储';

  @override
  String get freeStorageUsable => '可用的免费存储';

  @override
  String get usableReferralStorageInfo =>
      '可用存储空间受您当前计划的限制。 当您升级您的计划时，超出要求的存储空间将自动变为可用。';

  @override
  String get removeFromAlbumTitle => '要从相册中移除吗？';

  @override
  String get removeFromAlbum => '从相册中移除';

  @override
  String get itemsWillBeRemovedFromAlbum => '所选项目将从此相册中移除';

  @override
  String get removeShareItemsWarning => '除了照片所有者之外，本相册中的部分照片将不对任何其他浏览者开放。';

  @override
  String get addingToFavorites => '正在添加到收藏...';

  @override
  String get removingFromFavorites => '正在从收藏中删除...';

  @override
  String get sorryCouldNotAddToFavorites => '抱歉，无法添加到收藏！';

  @override
  String get sorryCouldNotRemoveFromFavorites => '抱歉，无法从收藏中移除！';

  @override
  String get subscribeToEnableSharing => '您需要有效的付费订阅才能启用共享。';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => '订阅';

  @override
  String get canOnlyRemoveFilesOwnedByYou => '只能删除您拥有的文件';

  @override
  String get deleteSharedAlbum => '要删除共享相册吗？';

  @override
  String get deleteAlbum => '删除相册';

  @override
  String get deleteAlbumDialog =>
      '也删除此相册中存在的照片(和视频)，从 <bold>他们所加入的所有</bold> 其他相册？';

  @override
  String get deleteSharedAlbumDialogBody => '将为所有人删除相册\n\n您将无法访问此相册中他人拥有的共享照片';

  @override
  String get yesRemove => '是，移除';

  @override
  String get creatingLink => '正在创建链接...';

  @override
  String get removeWithQuestionMark => '要移除吗?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail 将从这个共享相册中删除\n\nTA们添加的任何照片也将从相册中删除';
  }

  @override
  String get keepPhotos => '保留照片';

  @override
  String get deletePhotos => '删除照片';

  @override
  String get inviteToEnte => '邀请到 Ente';

  @override
  String get removePublicLink => '删除公开链接';

  @override
  String disableLinkMessage({required Object albumName}) {
    return '这将删除用于访问\"$albumName\"的公开链接。';
  }

  @override
  String get sharing => '正在分享...';

  @override
  String get youCannotShareWithYourself => '莫开玩笑，您不能与自己分享';

  @override
  String get archive => '存档';

  @override
  String get createAlbumActionHint => '长按选择照片，然后点击 + 创建相册';

  @override
  String get importing => '正在导入...';

  @override
  String get failedToLoadAlbums => '加载相册失败';

  @override
  String get hidden => '已隐藏';

  @override
  String get authToViewYourHiddenFiles => '请验证以查看您的隐藏文件';

  @override
  String get authToViewTrashedFiles => '请验证身份以查看您已删除的文件';

  @override
  String get trash => '回收站';

  @override
  String get uncategorized => '未分类的';

  @override
  String get videoSmallCase => '视频';

  @override
  String get photoSmallCase => '照片';

  @override
  String get singleFileDeleteHighlight => '它将从所有相册中删除。';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return '$fileType 已同时存在于 Ente 和您的设备中。';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return '$fileType 将从 Ente 中删除。';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return '此 $fileType 将从您的设备中删除。';
  }

  @override
  String get deleteFromEnte => '从 Ente 中删除';

  @override
  String get yesDelete => '是的, 删除';

  @override
  String get movedToTrash => '已移至回收站';

  @override
  String get deleteFromDevice => '从设备中删除';

  @override
  String get deleteFromBoth => '同时从两者中删除';

  @override
  String get newAlbum => '新建相册';

  @override
  String get albums => '相册';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount 个回忆',
      zero: '暂无回忆',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '已选择 $count 个';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '选择了 $count 个 (您的 $yourCount 个)';
  }

  @override
  String get advancedSettings => '高级设置';

  @override
  String get photoGridSize => '照片网格大小';

  @override
  String get manageDeviceStorage => '管理设备缓存';

  @override
  String get manageDeviceStorageDesc => '检查并清除本地缓存存储。';

  @override
  String get machineLearning => '机器学习';

  @override
  String get mlConsent => '启用机器学习';

  @override
  String get mlConsentTitle => '要启用机器学习吗？';

  @override
  String get mlConsentDescription =>
      '如果您启用机器学习，Ente 将从文件（包括与您共享的文件）中提取面部几何形状等信息。\n\n这将在您的设备上进行，并且任何生成的生物特征信息都将被端到端加密。';

  @override
  String get mlConsentPrivacy => '请点击此处查看我们隐私政策中有关此功能的更多详细信息';

  @override
  String get mlConsentConfirmation => '我了解了，并希望启用机器学习';

  @override
  String get magicSearch => '魔法搜索';

  @override
  String get discover => '发现';

  @override
  String get discover_identity => '身份';

  @override
  String get discover_screenshots => '屏幕截图';

  @override
  String get discover_receipts => '收据';

  @override
  String get discover_notes => '备注';

  @override
  String get discover_memes => '表情包';

  @override
  String get discover_visiting_cards => '访问卡';

  @override
  String get discover_babies => '婴儿';

  @override
  String get discover_pets => '宠物';

  @override
  String get discover_selfies => '自拍';

  @override
  String get discover_wallpapers => '壁纸';

  @override
  String get discover_food => '食物';

  @override
  String get discover_celebrations => '节日';

  @override
  String get discover_sunset => '日落';

  @override
  String get discover_hills => '山';

  @override
  String get discover_greenery => '绿植';

  @override
  String get mlIndexingDescription =>
      '请注意，机器学习会导致带宽和电池使用量增加，直到所有项目都被索引。请考虑使用桌面应用程序来加快索引速度，所有结果都将自动同步。';

  @override
  String get loadingModel => '正在下载模型...';

  @override
  String get waitingForWifi => '正在等待 WiFi...';

  @override
  String get status => '状态';

  @override
  String get indexedItems => '已索引项目';

  @override
  String get pendingItems => '待处理项目';

  @override
  String get clearIndexes => '清空索引';

  @override
  String get selectFoldersForBackup => '选择要备份的文件夹';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp => '所选文件夹将被加密并备份';

  @override
  String get unselectAll => '取消全部选择';

  @override
  String get selectAll => '全选';

  @override
  String get skip => '跳过';

  @override
  String get updatingFolderSelection => '正在更新文件夹选择...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 个项目',
      one: '$count 个项目',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '删除 $count 个项目',
      one: '删除 $count 个项目',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count 个文件，每个文件 $formattedSize';
  }

  @override
  String get showMemories => '显示回忆';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 年前',
      one: '$count 年前',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => '备份设置';

  @override
  String get backupStatus => '备份状态';

  @override
  String get backupStatusDescription => '已备份的项目将显示在此处';

  @override
  String get backupOverMobileData => '通过移动数据备份';

  @override
  String get backupVideos => '备份视频';

  @override
  String get disableAutoLock => '禁用自动锁定';

  @override
  String get deviceLockExplanation =>
      '当 Ente 置于前台且正在进行备份时将禁用设备屏幕锁定。这通常是不需要的，但可能有助于更快地完成大型上传和大型库的初始导入。';

  @override
  String get about => '关于';

  @override
  String get weAreOpenSource => '我们是开源的 ！';

  @override
  String get privacy => '隐私';

  @override
  String get terms => '使用条款';

  @override
  String get checkForUpdates => '检查更新';

  @override
  String get checkStatus => '检查状态';

  @override
  String get checking => '正在检查...';

  @override
  String get youAreOnTheLatestVersion => '当前为最新版本';

  @override
  String get account => '账户';

  @override
  String get manageSubscription => '管理订阅';

  @override
  String get authToChangeYourEmail => '请验证以更改您的电子邮件';

  @override
  String get changePassword => '修改密码';

  @override
  String get authToChangeYourPassword => '请验证以更改密码';

  @override
  String get emailVerificationToggle => '电子邮件验证';

  @override
  String get authToChangeEmailVerificationSetting => '请进行身份验证以更改电子邮件验证';

  @override
  String get exportYourData => '导出您的数据';

  @override
  String get logout => '退出登录';

  @override
  String get authToInitiateAccountDeletion => '请进行身份验证以启动账户删除';

  @override
  String get areYouSureYouWantToLogout => '您确定要退出登录吗？';

  @override
  String get yesLogout => '是的，退出登陆';

  @override
  String get aNewVersionOfEnteIsAvailable => '有新版本的 Ente 可供使用。';

  @override
  String get update => '更新';

  @override
  String get installManually => '手动安装';

  @override
  String get criticalUpdateAvailable => '可用的关键更新';

  @override
  String get updateAvailable => '有可用的更新';

  @override
  String get ignoreUpdate => '忽略';

  @override
  String get downloading => '正在下载...';

  @override
  String get cannotDeleteSharedFiles => '无法删除共享文件';

  @override
  String get theDownloadCouldNotBeCompleted => '未能完成下载';

  @override
  String get retry => '重试';

  @override
  String get backedUpFolders => '已备份的文件夹';

  @override
  String get backup => '备份';

  @override
  String get freeUpDeviceSpace => '释放设备空间';

  @override
  String get freeUpDeviceSpaceDesc => '通过清除已备份的文件来节省设备空间。';

  @override
  String get allClear => '✨ 全部清除';

  @override
  String get noDeviceThatCanBeDeleted => '您在此设备上没有可被删除的文件';

  @override
  String get removeDuplicates => '移除重复内容';

  @override
  String get removeDuplicatesDesc => '检查并删除完全重复的文件。';

  @override
  String get viewLargeFiles => '大文件';

  @override
  String get viewLargeFilesDesc => '查看占用存储空间最多的文件。';

  @override
  String get noDuplicates => '✨ 没有重复内容';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared => '您没有任何可以清除的重复文件';

  @override
  String get success => '成功';

  @override
  String get rateUs => '给我们评分';

  @override
  String get remindToEmptyDeviceTrash => '同时从“设置”->“存储”中清空“最近删除”以领取释放的空间';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return '您已成功释放了 $storageSaved！';
  }

  @override
  String get remindToEmptyEnteTrash => '同时清空您的“回收站”以领取释放的空间';

  @override
  String get sparkleSuccess => '✨ 成功';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 个重复文件',
    );
    return '您已经清理了 $_temp0, 释放了 ($storageSaved!)';
  }

  @override
  String get familyPlans => '家庭计划';

  @override
  String get referrals => '推荐';

  @override
  String get notifications => '通知';

  @override
  String get sharedPhotoNotifications => '新共享的照片';

  @override
  String get sharedPhotoNotificationsExplanation => '当有人将照片添加到您所属的共享相册时收到通知';

  @override
  String get advanced => '高级设置';

  @override
  String get general => '通用';

  @override
  String get security => '安全';

  @override
  String get authToViewYourRecoveryKey => '请验证以查看您的恢复密钥';

  @override
  String get twofactor => '双重认证';

  @override
  String get authToConfigureTwofactorAuthentication => '请进行身份验证以配置双重身份认证';

  @override
  String get lockscreen => '锁屏';

  @override
  String get authToChangeLockscreenSetting => '请验证以更改锁屏设置';

  @override
  String get viewActiveSessions => '查看活动会话';

  @override
  String get authToViewYourActiveSessions => '请验证以查看您的活动会话';

  @override
  String get disableTwofactor => '禁用双重认证';

  @override
  String get confirm2FADisable => '您确定要禁用双重认证吗？';

  @override
  String get no => '否';

  @override
  String get yes => '是';

  @override
  String get social => '社交';

  @override
  String rateUsOnStore({required Object storeName}) {
    return '在 $storeName 上给我们评分';
  }

  @override
  String get blog => '博客';

  @override
  String get merchandise => '商品';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched => '无法获取您的存储详情';

  @override
  String get reportABug => '报告错误';

  @override
  String get reportBug => '报告错误';

  @override
  String get suggestFeatures => '建议新功能';

  @override
  String get support => '支持';

  @override
  String get theme => '主题';

  @override
  String get lightTheme => '浅色';

  @override
  String get darkTheme => '深色';

  @override
  String get systemTheme => '适应系统';

  @override
  String get freeTrial => '免费试用';

  @override
  String get selectYourPlan => '选择您的计划';

  @override
  String get enteSubscriptionPitch => 'Ente 会保留您的回忆，因此即使您丢失了设备，也能随时找到它们。';

  @override
  String get enteSubscriptionShareWithFamily => '您的家人也可以添加到您的计划中。';

  @override
  String get currentUsageIs => '当前用量 ';

  @override
  String get faqs => '常见问题';

  @override
  String renewsOn({required Object endDate}) {
    return '在 $endDate 前续费';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return '免费试用有效期至 $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return '有效期至 $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return '您的 $storageAmount 插件有效期至 $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return '免费试用有效期至 $endDate。\n在此之后您可以选择付费计划。';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return '您的订阅将于 $endDate 取消';
  }

  @override
  String get subscription => '订阅';

  @override
  String get paymentDetails => '付款明细';

  @override
  String get manageFamily => '管理家庭计划';

  @override
  String contactToManageSubscription({required Object provider}) {
    return '请通过support@ente.io 用英语联系我们来管理您的 $provider 订阅。';
  }

  @override
  String get renewSubscription => '续费订阅';

  @override
  String get cancelSubscription => '取消订阅';

  @override
  String get areYouSureYouWantToRenew => '您确定要续费吗？';

  @override
  String get yesRenew => '是的，续费';

  @override
  String get areYouSureYouWantToCancel => '您确定要取消吗？';

  @override
  String get yesCancel => '是的，取消';

  @override
  String get failedToRenew => '续费失败';

  @override
  String get failedToCancel => '取消失败';

  @override
  String get twoMonthsFreeOnYearlyPlans => '在年度计划上免费获得 2 个月';

  @override
  String get monthly => '每月';

  @override
  String get yearly => '每年';

  @override
  String get confirmPlanChange => '确认更改计划';

  @override
  String get areYouSureYouWantToChangeYourPlan => '您确定要更改您的计划吗？';

  @override
  String get youCannotDowngradeToThisPlan => '您不能降级到此计划';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return '请先取消您现有的订阅 $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => '可选的，按您喜欢的短语...';

  @override
  String get send => '发送';

  @override
  String get askCancelReason => '您的订阅已取消。您想分享原因吗？';

  @override
  String get thankYouForSubscribing => '感谢您的订阅！';

  @override
  String get yourPurchaseWasSuccessful => '您购买成功！';

  @override
  String get yourPlanWasSuccessfullyUpgraded => '您的计划已成功升级';

  @override
  String get yourPlanWasSuccessfullyDowngraded => '您的计划已成功降级';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully => '您的订阅已成功更新';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStore 订阅';

  @override
  String get appstoreSubscription => 'AppStore 订阅';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return '您的 $id 已链接到另一个 Ente 账户。\n如果您想在此账户中使用您的 $id ，请联系我们的支持人员';
  }

  @override
  String get visitWebToManage => '请访问 web.ente.io 来管理您的订阅';

  @override
  String get couldNotUpdateSubscription => '无法升级订阅';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      '请用英语联系 support@ente.io ，我们将乐意提供帮助！';

  @override
  String get paymentFailed => '支付失败';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return '如果您被收取费用，请用英语与 $providerName 的客服聊天';
  }

  @override
  String get continueOnFreeTrial => '继续免费试用';

  @override
  String get areYouSureYouWantToExit => '您确定要退出吗？';

  @override
  String get thankYou => '非常感谢您';

  @override
  String get failedToVerifyPaymentStatus => '验证支付状态失败';

  @override
  String get pleaseWaitForSometimeBeforeRetrying => '请稍等片刻后再重试';

  @override
  String get paymentFailedMessage => '不幸的是，您的付款失败。请联系支持人员，我们将为您提供帮助！';

  @override
  String get youAreOnAFamilyPlan => '你在一个家庭计划中！';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return '请联系 <green>$familyAdminEmail</green> 来管理您的订阅';
  }

  @override
  String get leaveFamily => '离开家庭计划';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily => '您确定要离开家庭计划吗？';

  @override
  String get leave => '离开';

  @override
  String get rateTheApp => '为此应用评分';

  @override
  String get startBackup => '开始备份';

  @override
  String get noPhotosAreBeingBackedUpRightNow => '目前没有照片正在备份';

  @override
  String get preserveMore => '保留更多';

  @override
  String get grantFullAccessPrompt => '请在手机“设置”中授权软件访问所有照片';

  @override
  String get allowPermTitle => '允许访问照片';

  @override
  String get allowPermBody => '请从“设置”中选择允许访问您的照片，以便 Ente 可以显示和备份您的图库。';

  @override
  String get openSettings => '打开“设置”';

  @override
  String get selectMorePhotos => '选择更多照片';

  @override
  String get existingUser => '现有用户';

  @override
  String get privateBackups => '私人备份';

  @override
  String get forYourMemories => '为您的回忆';

  @override
  String get endtoendEncryptedByDefault => '默认端到端加密';

  @override
  String get safelyStored => '安全存储';

  @override
  String get atAFalloutShelter => '在一个庇护所中';

  @override
  String get designedToOutlive => '经久耐用';

  @override
  String get available => '可用';

  @override
  String get everywhere => '随时随地';

  @override
  String get androidIosWebDesktop => '安卓, iOS, 网页端, 桌面端';

  @override
  String get mobileWebDesktop => '移动端, 网页端, 桌面端';

  @override
  String get newToEnte => '初来 Ente';

  @override
  String get pleaseLoginAgain => '请重新登录';

  @override
  String get autoLogoutMessage => '由于技术故障，您已退出登录。对于由此造成的不便，我们深表歉意。';

  @override
  String get yourSubscriptionHasExpired => '您的订阅已过期';

  @override
  String get storageLimitExceeded => '已超出存储限制';

  @override
  String get upgrade => '升级';

  @override
  String get raiseTicket => '提升工单';

  @override
  String get backupFailed => '备份失败';

  @override
  String get sorryBackupFailedDesc => '抱歉，我们目前无法备份此文件，我们将稍后重试。';

  @override
  String get couldNotBackUpTryLater => '我们无法备份您的数据。\n我们将稍后再试。';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      '仅当您授予文件访问权限时，Ente 才能加密和保存文件';

  @override
  String get pleaseGrantPermissions => '请授予权限';

  @override
  String get grantPermission => '授予权限';

  @override
  String get privateSharing => '私人分享';

  @override
  String get shareOnlyWithThePeopleYouWant => '仅与您想要的人分享';

  @override
  String get usePublicLinksForPeopleNotOnEnte => '对不在 Ente 上的人使用公开链接';

  @override
  String get allowPeopleToAddPhotos => '允许人们添加照片';

  @override
  String get shareAnAlbumNow => '立即分享相册';

  @override
  String get collectEventPhotos => '收集活动照片';

  @override
  String get sessionExpired => '会话已过期';

  @override
  String get loggingOut => '正在退出登录...';

  @override
  String get onDevice => '在设备上';

  @override
  String get onEnte => '在 <branding>ente</branding> 上';

  @override
  String get name => '名称';

  @override
  String get newest => '最新';

  @override
  String get lastUpdated => '最后更新';

  @override
  String get deleteEmptyAlbums => '删除空相册';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => '要删除空相册吗？';

  @override
  String get deleteAlbumsDialogBody => '这将删除所有空相册。 当您想减少相册列表的混乱时，这很有用。';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return '正在删除 $currentlyDeleting /共 $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return '正在处理 $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => '永久删除';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou => '只能为您拥有的文件创建链接';

  @override
  String get publicLinkCreated => '公共链接已创建';

  @override
  String get youCanManageYourLinksInTheShareTab => '您可以在分享选项卡中管理您的链接。';

  @override
  String get linkCopiedToClipboard => '链接已复制到剪贴板';

  @override
  String get restore => '恢复';

  @override
  String get moveToAlbum => '移动到相册';

  @override
  String get unhide => '取消隐藏';

  @override
  String get unarchive => '取消存档';

  @override
  String get favorite => '收藏';

  @override
  String get removeFromFavorite => '从收藏中移除';

  @override
  String get shareLink => '分享链接';

  @override
  String get createCollage => '创建拼贴';

  @override
  String get saveCollage => '保存拼贴';

  @override
  String get collageSaved => '拼贴已保存到相册';

  @override
  String get collageLayout => '布局';

  @override
  String get addToEnte => '添加到 Ente';

  @override
  String get addToAlbum => '添加到相册';

  @override
  String get delete => '删除';

  @override
  String get hide => '隐藏';

  @override
  String get share => '分享';

  @override
  String get unhideToAlbum => '取消隐藏到相册';

  @override
  String get restoreToAlbum => '恢复到相册';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '移动数个项目',
      one: '移动项目',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '添加数个项目',
      one: '添加项目',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => '创建或选择相册';

  @override
  String get selectAlbum => '选择相册';

  @override
  String get searchByAlbumNameHint => '相册名称';

  @override
  String get albumTitle => '相册标题';

  @override
  String get enterAlbumName => '输入相册名称';

  @override
  String get restoringFiles => '正在恢复文件...';

  @override
  String get movingFilesToAlbum => '正在将文件移动到相册...';

  @override
  String get unhidingFilesToAlbum => '正在取消隐藏文件到相册';

  @override
  String get canNotUploadToAlbumsOwnedByOthers => '无法上传到他人拥有的相册中';

  @override
  String get uploadingFilesToAlbum => '正在将文件上传到相册...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return '成功添加到  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return '成功移动到 $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink => '此相册已经有一个协作链接';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return '为 $albumName 创建了协作链接';
  }

  @override
  String get askYourLovedOnesToShare => '请您的亲人分享';

  @override
  String get invite => '邀请';

  @override
  String get shareYourFirstAlbum => '分享您的第一个相册';

  @override
  String sharedWith({required Object emailIDs}) {
    return '与 $emailIDs 共享';
  }

  @override
  String get sharedWithMe => '与我共享';

  @override
  String get sharedByMe => '由我共享的';

  @override
  String get doubleYourStorage => '将您的存储空间增加一倍';

  @override
  String get referFriendsAnd2xYourPlan => '把我们推荐给你的朋友然后获得延长一倍的订阅计划';

  @override
  String get shareAlbumHint => '打开相册并点击右上角的分享按钮进行分享';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      '项目显示永久删除前剩余的天数';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 天',
      one: '1 天',
      zero: '马上',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => '全部删除';

  @override
  String get renameAlbum => '重命名相册';

  @override
  String get convertToAlbum => '转换为相册';

  @override
  String get setCover => '设置封面';

  @override
  String get sortAlbumsBy => '排序方式';

  @override
  String get sortNewestFirst => '最新在前';

  @override
  String get sortOldestFirst => '最旧在前';

  @override
  String get rename => '重命名';

  @override
  String get leaveSharedAlbum => '要离开共享相册吗？';

  @override
  String get leaveAlbum => '离开相册';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum => '您添加的照片将从相册中移除';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted => '您在此相册中没有可以删除的文件';

  @override
  String get youDontHaveAnyArchivedItems => '您没有任何存档的项目。';

  @override
  String get ignoredFolderUploadReason =>
      '此相册中的某些文件在上传时会被忽略，因为它们之前已从 Ente 中删除。';

  @override
  String get resetIgnoredFiles => '重置忽略的文件';

  @override
  String get deviceFilesAutoUploading => '添加到此设备相册的文件将自动上传到 Ente。';

  @override
  String get turnOnBackupForAutoUpload => '打开备份可自动上传添加到此设备文件夹的文件至 Ente。';

  @override
  String get noHiddenPhotosOrVideos => '没有隐藏的照片或视频';

  @override
  String get toHideAPhotoOrVideo => '隐藏照片或视频';

  @override
  String get openTheItem => '• 打开该项目';

  @override
  String get clickOnTheOverflowMenu => '• 点击溢出菜单';

  @override
  String get click => '• 点击';

  @override
  String get nothingToSeeHere => '这里空空如也! 👀';

  @override
  String get unarchiveAlbum => '取消存档相册';

  @override
  String get archiveAlbum => '存档相册';

  @override
  String get calculating => '正在计算...';

  @override
  String get pleaseWaitDeletingAlbum => '请稍候，正在删除相册';

  @override
  String get searchByExamples =>
      '• 相册名称（例如“相机”）\n• 文件类型（例如“视频”、“.gif”）\n• 年份和月份（例如“2022”、“一月”）\n• 假期（例如“圣诞节”）\n• 照片说明（例如“#和女儿独居，好开心啊”）';

  @override
  String get youCanTrySearchingForADifferentQuery => '您可以尝试搜索不同的查询。';

  @override
  String get noResultsFound => '未找到任何结果';

  @override
  String addedBy({required Object emailOrName}) {
    return '由 $emailOrName 添加';
  }

  @override
  String get loadingExifData => '正在加载 EXIF 数据...';

  @override
  String get viewAllExifData => '查看所有 EXIF 数据';

  @override
  String get noExifData => '无 EXIF 数据';

  @override
  String get thisImageHasNoExifData => '此图像没有Exif 数据';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => '无结果';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      '我们不支持编辑您尚未拥有的照片和相册';

  @override
  String get failedToFetchOriginalForEdit => '无法获取原始编辑';

  @override
  String get close => '关闭';

  @override
  String get setAs => '设置为';

  @override
  String get fileSavedToGallery => '文件已保存到相册';

  @override
  String get filesSavedToGallery => '多个文件已保存到相册';

  @override
  String get fileFailedToSaveToGallery => '无法将文件保存到相册';

  @override
  String get download => '下载';

  @override
  String get pressAndHoldToPlayVideo => '按住以播放视频';

  @override
  String get pressAndHoldToPlayVideoDetailed => '长按图像以播放视频';

  @override
  String get downloadFailed => '下載失敗';

  @override
  String get deduplicateFiles => '文件去重';

  @override
  String get deselectAll => '取消全选';

  @override
  String get reviewDeduplicateItems => '请检查并删除您认为重复的项目。';

  @override
  String get clubByCaptureTime => '按拍摄时间分组';

  @override
  String get clubByFileName => '按文件名排序';

  @override
  String get count => '计数';

  @override
  String get totalSize => '总大小';

  @override
  String get longpressOnAnItemToViewInFullscreen => '长按一个项目来全屏查看';

  @override
  String get decryptingVideo => '正在解密视频...';

  @override
  String get authToViewYourMemories => '请验证以查看您的回忆';

  @override
  String get unlock => '解锁';

  @override
  String get freeUpSpace => '释放空间';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '它们可以从设备中删除以释放 $formattedSize',
      one: '它可以从设备中删除以释放 $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber 个文件',
      one: '1 个文件',
    );
    return '此相册中的 $_temp0 已安全备份';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber 个文件',
      one: '1 个文件',
    );
    return '此设备上的 $_temp0 已安全备份';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '它们',
      one: '它',
    );
    return '只要您拥有有效订阅，您仍然可以在 Ente 上访问 $_temp0';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return '释放 $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => '这个邮箱地址已经被使用';

  @override
  String get incorrectCode => '代码错误';

  @override
  String get authenticationFailedPleaseTryAgain => '身份验证失败，请重试';

  @override
  String get verificationFailedPleaseTryAgain => '验证失败，请重试';

  @override
  String get authenticating => '正在验证...';

  @override
  String get authenticationSuccessful => '验证成功';

  @override
  String get incorrectRecoveryKey => '不正确的恢复密钥';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect => '您输入的恢复密钥不正确';

  @override
  String get twofactorAuthenticationSuccessfullyReset => '成功重置双重认证';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered => '请验证您输入的代码';

  @override
  String get pleaseContactSupportIfTheProblemPersists => '如果问题仍然存在，请联系支持';

  @override
  String get twofactorAuthenticationHasBeenDisabled => '双重认证已被禁用';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect => '抱歉，您输入的代码不正确';

  @override
  String get yourVerificationCodeHasExpired => '您的验证码已过期';

  @override
  String emailChangedTo({required Object newEmail}) {
    return '电子邮件已更改为 $newEmail';
  }

  @override
  String get verifying => '正在验证...';

  @override
  String get disablingTwofactorAuthentication => '正在禁用双重认证...';

  @override
  String get allMemoriesPreserved => '所有回忆都已保存';

  @override
  String get loadingGallery => '正在加载图库...';

  @override
  String get syncing => '正在同步···';

  @override
  String get encryptingBackup => '正在加密备份...';

  @override
  String get syncStopped => '同步已停止';

  @override
  String syncProgress({required String completed, required String total}) {
    return '已保存的回忆 $completed/共 $total';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return '正在保存 $count 个回忆...';
  }

  @override
  String get uploadingSingleMemory => '正在保存 1 个回忆...';

  @override
  String get archiving => '正在存档...';

  @override
  String get unarchiving => '正在取消存档...';

  @override
  String get successfullyArchived => '存档成功';

  @override
  String get successfullyUnarchived => '取消存档成功';

  @override
  String get renameFile => '重命名文件';

  @override
  String get enterFileName => '请输入文件名';

  @override
  String get filesDeleted => '文件已删除';

  @override
  String get selectedFilesAreNotOnEnte => '所选文件不在 Ente 上';

  @override
  String get thisActionCannotBeUndone => '此操作无法撤销';

  @override
  String get emptyTrash => '要清空回收站吗？';

  @override
  String get permDeleteWarning => '回收站中的所有项目将被永久删除\n\n此操作无法撤消';

  @override
  String get empty => '清空';

  @override
  String get couldNotFreeUpSpace => '无法释放空间';

  @override
  String get permanentlyDeleteFromDevice => '要从设备中永久删除吗？';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      '您要删除的部分文件仅在您的设备上可用，且删除后无法恢复';

  @override
  String get theyWillBeDeletedFromAllAlbums => '他们将从所有相册中删除。';

  @override
  String get someItemsAreInBothEnteAndYourDevice => '有些项目同时存在于 Ente 和您的设备中。';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      '所选项目将从所有相册中删除并移动到回收站。';

  @override
  String get theseItemsWillBeDeletedFromYourDevice => '这些项目将从您的设备中删除。';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      '看起来出了点问题。 请稍后重试。 如果错误仍然存在，请联系我们的支持团队。';

  @override
  String get error => '错误';

  @override
  String get tempErrorContactSupportIfPersists =>
      '看起来出了点问题。 请稍后重试。 如果错误仍然存在，请联系我们的支持团队。';

  @override
  String get networkHostLookUpErr => '无法连接到 Ente，请检查您的网络设置，如果错误仍然存在，请联系支持人员。';

  @override
  String get networkConnectionRefusedErr =>
      '无法连接到 Ente，请稍后重试。如果错误仍然存在，请联系支持人员。';

  @override
  String get cachedData => '缓存数据';

  @override
  String get clearCaches => '清除缓存';

  @override
  String get remoteImages => '云端图像';

  @override
  String get remoteVideos => '云端视频';

  @override
  String get remoteThumbnails => '云端缩略图';

  @override
  String get pendingSync => '正在等待同步';

  @override
  String get localGallery => '本地相册';

  @override
  String get todaysLogs => '当天日志';

  @override
  String get viewLogs => '查看日志';

  @override
  String get logsDialogBody => '这将跨日志发送以帮助我们调试您的问题。 请注意，将包含文件名以帮助跟踪特定文件的问题。';

  @override
  String get preparingLogs => '正在准备日志...';

  @override
  String get emailYourLogs => '通过电子邮件发送您的日志';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return '请将日志发送至 \n$toEmail';
  }

  @override
  String get copyEmailAddress => '复制电子邮件地址';

  @override
  String get exportLogs => '导出日志';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return '请给我们发送电子邮件至 $toEmail';
  }

  @override
  String get dismiss => '忽略';

  @override
  String get didYouKnow => '您知道吗？';

  @override
  String get loadingMessage => '正在加载您的照片...';

  @override
  String get loadMessage1 => '您可以与家庭分享您的订阅';

  @override
  String get loadMessage2 => '我们至今已保存超过2亿个回忆';

  @override
  String get loadMessage3 => '我们保存你的3个数据副本，其中一个在地下安全屋中';

  @override
  String get loadMessage4 => '我们所有的应用程序都是开源的';

  @override
  String get loadMessage5 => '我们的源代码和加密技术已经由外部审计';

  @override
  String get loadMessage6 => '您可以与您所爱的人分享您相册的链接';

  @override
  String get loadMessage7 => '我们的移动应用程序在后台运行以加密和备份您点击的任何新照片';

  @override
  String get loadMessage8 => 'web.ente.io 有一个巧妙的上传器';

  @override
  String get loadMessage9 => '我们使用 Xchacha20Poly1305 加密技术来安全地加密您的数据';

  @override
  String get photoDescriptions => '照片说明';

  @override
  String get fileTypesAndNames => '文件类型和名称';

  @override
  String get location => '地理位置';

  @override
  String get moments => '瞬间';

  @override
  String get searchFaceEmptySection => '待索引完成后，人物将显示在此处';

  @override
  String get searchDatesEmptySection => '按日期搜索，月份或年份';

  @override
  String get searchLocationEmptySection => '在照片的一定半径内拍摄的几组照片';

  @override
  String get searchPeopleEmptySection => '邀请他人，您将在此看到他们分享的所有照片';

  @override
  String get searchAlbumsEmptySection => '相册';

  @override
  String get searchFileTypesAndNamesEmptySection => '文件类型和名称';

  @override
  String get searchCaptionEmptySection => '在照片信息中添加“#旅游”等描述，以便在此处快速找到它们';

  @override
  String get language => '语言';

  @override
  String get selectLanguage => '选择语言';

  @override
  String get locationName => '地点名称';

  @override
  String get addLocation => '添加地点';

  @override
  String get groupNearbyPhotos => '将附近的照片分组';

  @override
  String get kiloMeterUnit => '公里';

  @override
  String get addLocationButton => '添加';

  @override
  String get radius => '半径';

  @override
  String get locationTagFeatureDescription => '位置标签将在照片的某个半径范围内拍摄的所有照片进行分组';

  @override
  String get galleryMemoryLimitInfo => '在图库中显示最多1000个回忆';

  @override
  String get save => '保存';

  @override
  String get centerPoint => '中心点';

  @override
  String get pickCenterPoint => '选择中心点';

  @override
  String get useSelectedPhoto => '使用所选照片';

  @override
  String get resetToDefault => '重置为默认设置';

  @override
  String get edit => '编辑';

  @override
  String get deleteLocation => '删除位置';

  @override
  String get rotateLeft => '向左旋转';

  @override
  String get flip => '上下翻转';

  @override
  String get rotateRight => '向右旋转';

  @override
  String get saveCopy => '保存副本';

  @override
  String get light => '亮度';

  @override
  String get color => '颜色';

  @override
  String get yesDiscardChanges => '是的，放弃更改';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade => '您想要放弃您所做的编辑吗？';

  @override
  String get saving => '正在保存...';

  @override
  String get editsSaved => '已保存编辑';

  @override
  String get oopsCouldNotSaveEdits => '糟糕，无法保存编辑';

  @override
  String get distanceInKMUnit => '公里';

  @override
  String get dayToday => '今天';

  @override
  String get dayYesterday => '昨天';

  @override
  String get storage => '存储空间';

  @override
  String get usedSpace => '已用空间';

  @override
  String get storageBreakupFamily => '家庭';

  @override
  String get storageBreakupYou => '您';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '已使用 $usedAmount $usedStorageUnit / $totalAmount $totalStorageUnit';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit 空闲';
  }

  @override
  String appVersion({required Object versionValue}) {
    return '版本: $versionValue';
  }

  @override
  String get verifyIDLabel => '验证';

  @override
  String get fileInfoAddDescHint => '添加说明...';

  @override
  String get editLocationTagTitle => '编辑位置';

  @override
  String get setLabel => '设置';

  @override
  String get setRadius => '设定半径';

  @override
  String get familyPlanPortalTitle => '家庭';

  @override
  String get familyPlanOverview =>
      '将 5 名家庭成员添加到您现有的计划中，无需支付额外费用。\n\n每个成员都有自己的私人空间，除非共享，否则无法看到彼此的文件。\n\n家庭计划适用于已付费 Ente 订阅的客户。\n\n立即订阅，开始体验！';

  @override
  String get androidBiometricHint => '验证身份';

  @override
  String get androidBiometricNotRecognized => '无法识别。请重试。';

  @override
  String get androidBiometricSuccess => '成功';

  @override
  String get androidCancelButton => '取消';

  @override
  String get androidSignInTitle => '需要身份验证';

  @override
  String get androidBiometricRequiredTitle => '需要生物识别认证';

  @override
  String get androidDeviceCredentialsRequiredTitle => '需要设备凭据';

  @override
  String get androidDeviceCredentialsSetupDescription => '需要设备凭据';

  @override
  String get goToSettings => '前往设置';

  @override
  String get androidGoToSettingsDescription =>
      '您未在该设备上设置生物识别身份验证。前往“设置>安全”添加生物识别身份验证。';

  @override
  String get iOSLockOut => '生物识别认证已禁用。请锁定并解锁您的屏幕以启用它。';

  @override
  String get iOSGoToSettingsDescription =>
      '您未在该设备上设置生物识别身份验证。请在您的手机上启用 Touch ID或Face ID。';

  @override
  String get iOSOkButton => '好的';

  @override
  String get openstreetmapContributors => 'OpenStreetMap 贡献者';

  @override
  String get hostedAtOsmFrance => '法国 OSM 主办';

  @override
  String get map => '地图';

  @override
  String get maps => '地图';

  @override
  String get mapsPrivacyNotice =>
      '我们会将大致坐标发送给注重隐私的第三方（例如 OpenStreetMap），以便显示地图和位置。';

  @override
  String get enableMaps => '启用地图';

  @override
  String get quickLinks => '快速链接';

  @override
  String get selectItemsToAdd => '选择要添加的项目';

  @override
  String get addSelected => '添加所选项';

  @override
  String get addFromDevice => '从设备添加';

  @override
  String get addPhotos => '添加照片';

  @override
  String get noPhotosFoundHere => '这里没有找到照片';

  @override
  String get zoomOutToSeePhotos => '缩小以查看照片';

  @override
  String get noImagesWithLocation => '没有带有位置的图像';

  @override
  String get unpinAlbum => '取消置顶相册';

  @override
  String get pinAlbum => '置顶相册';

  @override
  String get pin => '置顶';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => '置顶到最上';

  @override
  String get unpin => '取消置顶';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => '可见范围';

  @override
  String get hideFromMemories => '从回忆中隐藏';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => '创建';

  @override
  String get viewAll => '查看全部';

  @override
  String get nothingSharedWithYouYet => '尚未与您共享任何内容';

  @override
  String get noAlbumsSharedByYouYet => '您尚未共享任何相册';

  @override
  String get sharedWithYou => '已与您共享';

  @override
  String get sharedByYou => '您共享的';

  @override
  String get inviteYourFriendsToEnte => '邀请您的朋友加入 Ente';

  @override
  String get failedToDownloadVideo => '视频下载失败';

  @override
  String get hiding => '正在隐藏...';

  @override
  String get unhiding => '正在取消隐藏...';

  @override
  String get successfullyHid => '已成功隐藏';

  @override
  String get successfullyUnhid => '已成功取消隐藏';

  @override
  String get crashReporting => '上报崩溃';

  @override
  String get resumableUploads => '可续传上传';

  @override
  String get addToHiddenAlbum => '添加到隐藏相册';

  @override
  String get moveToHiddenAlbum => '移至隐藏相册';

  @override
  String get fileTypes => '文件类型';

  @override
  String get deleteConfirmDialogBody =>
      '此账户已链接到其他 Ente 应用程序（如果您使用任何应用程序）。您在所有 Ente 应用程序中上传的数据将被安排删除，并且您的账户将被永久删除。';

  @override
  String get hearUsWhereTitle => '您是如何知道Ente的？ （可选的）';

  @override
  String get hearUsExplanation => '我们不跟踪应用程序安装情况。如果您告诉我们您是在哪里找到我们的，将会有所帮助！';

  @override
  String get viewAddOnButton => '查看附加组件';

  @override
  String get addOns => '附加组件';

  @override
  String get addOnPageSubtitle => '附加组件详情';

  @override
  String get yourMap => '您的地图';

  @override
  String get modifyYourQueryOrTrySearchingFor => '修改您的查询，或尝试搜索';

  @override
  String get blackFridaySale => '黑色星期五特惠';

  @override
  String get upto50OffUntil4thDec => '最高五折优惠，直至12月4日。';

  @override
  String get photos => '照片';

  @override
  String get videos => '视频';

  @override
  String get livePhotos => '实况照片';

  @override
  String get searchHint1 => '在设备上快速搜索';

  @override
  String get searchHint2 => '照片日期、描述';

  @override
  String get searchHint3 => '相册、文件名和类型';

  @override
  String get searchHint4 => '位置';

  @override
  String get searchHint5 => '即将到来：面部和魔法搜索✨';

  @override
  String get addYourPhotosNow => '立即添加您的照片';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '已找到 $count 个结果',
    );
    return '$_temp0';
  }

  @override
  String get faces => '人脸';

  @override
  String get people => '人物';

  @override
  String get contents => '内容';

  @override
  String get addNew => '新建';

  @override
  String get contacts => '联系人';

  @override
  String get noInternetConnection => '无互联网连接';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain => '请检查您的互联网连接，然后重试。';

  @override
  String get signOutFromOtherDevices => '从其他设备退出登录';

  @override
  String get signOutOtherBody => '如果你认为有人可能知道你的密码，你可以强制所有使用你账户的其他设备退出登录。';

  @override
  String get signOutOtherDevices => '登出其他设备';

  @override
  String get doNotSignOut => '不要登出';

  @override
  String get editLocation => '编辑位置';

  @override
  String get selectALocation => '选择一个位置';

  @override
  String get selectALocationFirst => '首先选择一个位置';

  @override
  String get changeLocationOfSelectedItems => '确定要更改所选项目的位置吗？';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte => '对位置的编辑只能在 Ente 内看到';

  @override
  String get cleanUncategorized => '清除未分类的';

  @override
  String get cleanUncategorizedDescription => '从“未分类”中删除其他相册中存在的所有文件';

  @override
  String get waitingForVerification => '等待验证...';

  @override
  String get passkey => '通行密钥';

  @override
  String get passkeyAuthTitle => '通行密钥认证';

  @override
  String get loginWithTOTP => '使用 TOTP 登录';

  @override
  String get passKeyPendingVerification => '仍需进行验证';

  @override
  String get loginSessionExpired => '会话已过期';

  @override
  String get loginSessionExpiredDetails => '您的会话已过期。请重新登录。';

  @override
  String get verifyPasskey => '验证通行密钥';

  @override
  String get playOnTv => '在电视上播放相册';

  @override
  String get pair => '配对';

  @override
  String get deviceNotFound => '未发现设备';

  @override
  String get castInstruction =>
      '在您要配对的设备上访问 cast.ente.io。\n在下框中输入代码即可在电视上播放相册。';

  @override
  String get deviceCodeHint => '输入代码';

  @override
  String get joinDiscord => '加入 Discord';

  @override
  String get locations => '位置';

  @override
  String get addAName => '添加一个名称';

  @override
  String get findThemQuickly => '快速找到它们';

  @override
  String get findPeopleByName => '按名称快速查找人物';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '添加数个查看者',
      one: '添加查看者r',
      zero: '添加查看者',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '添加数个协作者',
      one: '添加协作者',
      zero: '添加协作者',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption => '长按电子邮件以验证端到端加密。';

  @override
  String get developerSettingsWarning => '您确定要修改开发者设置吗？';

  @override
  String get developerSettings => '开发者设置';

  @override
  String get serverEndpoint => '服务器端点';

  @override
  String get invalidEndpoint => '端点无效';

  @override
  String get invalidEndpointMessage => '抱歉，您输入的端点无效。请输入有效的端点，然后重试。';

  @override
  String get endpointUpdatedMessage => '端点更新成功';

  @override
  String customEndpoint({required Object endpoint}) {
    return '已连接至 $endpoint';
  }

  @override
  String get createCollaborativeLink => '创建协作链接';

  @override
  String get search => '搜索';

  @override
  String get enterPersonName => '输入人物名称';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return '此电子邮件已与$name关联。';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return '查看$name以解除关联';
  }

  @override
  String get enterName => '输入名称';

  @override
  String get savePerson => '保存人物';

  @override
  String get editPerson => '编辑人物';

  @override
  String get mergedPhotos => '已合并照片';

  @override
  String get orMergeWithExistingPerson => '或与现有的合并';

  @override
  String get enterDateOfBirth => '生日(可选)';

  @override
  String get birthday => '生日';

  @override
  String get removePersonLabel => '移除人物标签';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc => '自动配对仅适用于支持 Chromecast 的设备。';

  @override
  String get manualPairDesc => '用 PIN 码配对适用于您希望在其上查看相册的任何屏幕。';

  @override
  String get connectToDevice => '连接到设备';

  @override
  String get autoCastDialogBody => '您将在此处看到可用的 Cast 设备。';

  @override
  String get autoCastiOSPermission => '请确保已在“设置”中为 Ente Photos 应用打开本地网络权限。';

  @override
  String get noDeviceFound => '未发现设备';

  @override
  String get stopCastingTitle => '停止投放';

  @override
  String get stopCastingBody => '您想停止投放吗？';

  @override
  String get castIPMismatchTitle => '投放相册失败';

  @override
  String get castIPMismatchBody => '请确保您的设备与电视处于同一网络。';

  @override
  String get pairingComplete => '配对完成';

  @override
  String get savingEdits => '正在保存编辑内容...';

  @override
  String get autoPair => '自动配对';

  @override
  String get pairWithPin => '用 PIN 配对';

  @override
  String get faceRecognition => '人脸识别';

  @override
  String get foundFaces => '已找到的人脸';

  @override
  String get clusteringProgress => '聚类进展';

  @override
  String get trim => '修剪';

  @override
  String get crop => '裁剪';

  @override
  String get rotate => '旋转';

  @override
  String get left => '向左';

  @override
  String get right => '向右';

  @override
  String get whatsNew => '更新日志';

  @override
  String get reviewSuggestions => '查看建议';

  @override
  String get review => '查看';

  @override
  String get useAsCover => '用作封面';

  @override
  String notPersonLabel({required String name}) {
    return '不是 $name？';
  }

  @override
  String get enable => '启用';

  @override
  String get enabled => '已启用';

  @override
  String get moreDetails => '更多详情';

  @override
  String get enableMLIndexingDesc => 'Ente 支持设备上的机器学习，实现人脸识别、魔法搜索和其他高级搜索功能';

  @override
  String get magicSearchHint =>
      '魔法搜索允许按内容搜索照片，例如“lower\'”、“red car”、“identity documents”';

  @override
  String get panorama => '全景';

  @override
  String get reenterPassword => '再次输入密码';

  @override
  String get reenterPin => '再次输入 PIN 码';

  @override
  String get deviceLock => '设备锁';

  @override
  String get pinLock => 'PIN 锁定';

  @override
  String get next => '下一步';

  @override
  String get setNewPassword => '设置新密码';

  @override
  String get enterPin => '输入 PIN 码';

  @override
  String get setNewPin => '设置新 PIN 码';

  @override
  String get appLock => '应用锁';

  @override
  String get noSystemLockFound => '未找到系统锁';

  @override
  String get tapToUnlock => '点击解锁';

  @override
  String get tooManyIncorrectAttempts => '错误尝试次数过多';

  @override
  String get videoInfo => '视频详情';

  @override
  String get autoLock => '自动锁定';

  @override
  String get immediately => '立即';

  @override
  String get autoLockFeatureDescription => '应用程序进入后台后锁定的时间';

  @override
  String get hideContent => '隐藏内容';

  @override
  String get hideContentDescriptionAndroid => '在应用切换器中隐藏应用内容并禁用屏幕截图';

  @override
  String get hideContentDescriptionIos => '在应用切换器中隐藏应用内容';

  @override
  String get passwordStrengthInfo =>
      '密码强度的计算考虑了密码的长度、使用的字符以及密码是否出现在最常用的 10,000 个密码中';

  @override
  String get noQuickLinksSelected => '未选择快速链接';

  @override
  String get pleaseSelectQuickLinksToRemove => '请选择要删除的快速链接';

  @override
  String get removePublicLinks => '删除公开链接';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      '这将删除所有选定的快速链接的公共链接。';

  @override
  String get guestView => '访客视图';

  @override
  String get guestViewEnablePreSteps => '要启用访客视图，请在系统设置中设置设备密码或屏幕锁。';

  @override
  String get nameTheAlbum => '命名相册';

  @override
  String get collectPhotosDescription => '创建一个您的朋友可以上传原图的链接。';

  @override
  String get collect => '收集';

  @override
  String get appLockDescriptions => '在设备的默认锁定屏幕和带有 PIN 或密码的自定义锁定屏幕之间进行选择。';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      '要启用应用锁，请在系统设置中设置设备密码或屏幕锁。';

  @override
  String get authToViewPasskey => '请验证身份以查看您的通行密钥';

  @override
  String get loopVideoOn => '关闭循环';

  @override
  String get loopVideoOff => '开启循环';

  @override
  String get localSyncErrorMessage => '似乎出了点问题，因为本地照片同步耗时比预期的要长。请联系我们的支持团队';

  @override
  String get showPerson => '显示人员';

  @override
  String get sort => '排序';

  @override
  String get mostRecent => '最近';

  @override
  String get mostRelevant => '最相关';

  @override
  String get loadingYourPhotos => '正在加载您的照片...';

  @override
  String processingImport({required Object folderName}) {
    return '正在处理 $folderName...';
  }

  @override
  String get personName => '人物名称';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => '添加新人物';

  @override
  String get addNameOrMerge => '添加名称或合并';

  @override
  String get mergeWithExisting => '与现有的合并';

  @override
  String get newPerson => '新人物';

  @override
  String get addName => '添加名称';

  @override
  String get add => '添加';

  @override
  String extraPhotosFoundFor({required String text}) {
    return '为 $text 找到额外照片';
  }

  @override
  String get extraPhotosFound => '发现额外照片';

  @override
  String get configuration => '配置';

  @override
  String get localIndexing => '本地索引';

  @override
  String get processed => '已处理';

  @override
  String get resetPerson => '移除';

  @override
  String get areYouSureYouWantToResetThisPerson => '您确定要重设此人吗？';

  @override
  String get allPersonGroupingWillReset => '此人的所有分组都将被重设，并且您将丢失针对此人的所有建议';

  @override
  String get yesResetPerson => '是，重设人物';

  @override
  String get onlyThem => '仅限他们';

  @override
  String get checkingModels => '正在检查模型...';

  @override
  String get enableMachineLearningBanner => '启用机器学习进行魔法搜索和面部识别';

  @override
  String get searchDiscoverEmptySection => '处理和同步完成后，图像将显示在此处';

  @override
  String get searchPersonsEmptySection => '处理和同步完成后，人物将显示在此处';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '已添加 $count 个查看者',
      one: '已添加1个查看者',
      zero: '已添加0个查看者',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '已添加 $count 位协作者',
      one: '已添加 1 位协作者',
      zero: '已添加 0 位协作者',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => '账户已配置。';

  @override
  String get sessionIdMismatch => '会话 ID 不匹配';

  @override
  String get failedToFetchActiveSessions => '无法获取活动会话';

  @override
  String get failedToRefreshStripeSubscription => '刷新订阅失败';

  @override
  String get failedToPlayVideo => '播放视频失败';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return '由于 $ignoreReason，上传被忽略';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return '相册类型 $galleryType 不支持重命名';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return '点按上传，由于$ignoreReason，目前上传已被忽略';
  }

  @override
  String get tapToUpload => '点按上传';

  @override
  String get info => '详情';

  @override
  String get addFiles => '添加文件';

  @override
  String get castAlbum => '投放相册';

  @override
  String get imageNotAnalyzed => '图像未分析';

  @override
  String get noFacesFound => '未找到任何面部';

  @override
  String get fileNotUploadedYet => '文件尚未上传';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return '没有针对 $personName 的建议';
  }

  @override
  String get month => '月';

  @override
  String get yearShort => '年';

  @override
  String get currentlyRunning => '目前正在运行';

  @override
  String get ignored => '已忽略';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 张照片',
      one: '1张照片',
      zero: '0张照片',
    );
    return '$_temp0';
  }

  @override
  String get file => '文件';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return '部分长度不匹配：$snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => '选择邮件应用';

  @override
  String get selectAllShort => '全部';

  @override
  String get selectCoverPhoto => '选择封面照片';

  @override
  String get newLocation => '新位置';

  @override
  String get faceNotClusteredYet => '人脸尚未聚类，请稍后再来';

  @override
  String get theLinkYouAreTryingToAccessHasExpired => '您尝试访问的链接已过期。';

  @override
  String get openFile => '打开文件';

  @override
  String get backupFile => '备份文件';

  @override
  String get openAlbumInBrowser => '在浏览器中打开相册';

  @override
  String get openAlbumInBrowserTitle => '请使用网络应用将照片添加到此相册';

  @override
  String get allow => '允许';

  @override
  String get allowAppToOpenSharedAlbumLinks => '允许应用打开共享相册链接';

  @override
  String get seePublicAlbumLinksInApp => '在应用程序中查看公开相册链接';

  @override
  String get emergencyContacts => '紧急联系人';

  @override
  String get acceptTrustInvite => '接受邀请';

  @override
  String get declineTrustInvite => '拒绝邀请';

  @override
  String get removeYourselfAsTrustedContact => '删除自己作为可信联系人';

  @override
  String get legacy => '遗产';

  @override
  String get legacyPageDesc => '遗产允许信任的联系人在您不在时访问您的账户。';

  @override
  String get legacyPageDesc2 => '可信联系人可以启动账户恢复，如果 30 天内没有被阻止，则可以重置密码并访问您的账户。';

  @override
  String get legacyAccounts => '遗产账户';

  @override
  String get trustedContacts => '可信联系人';

  @override
  String get addTrustedContact => '添加可信联系人';

  @override
  String get removeInvite => '移除邀请';

  @override
  String get recoveryWarning => '一位可信联系人正在尝试访问您的账户';

  @override
  String get rejectRecovery => '拒绝恢复';

  @override
  String get recoveryInitiated => '已启动恢复';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return '您可以在 $days 天后访问该账户。通知将发送至 $email。';
  }

  @override
  String get cancelAccountRecovery => '取消恢复';

  @override
  String get recoveryAccount => '恢复账户';

  @override
  String get cancelAccountRecoveryBody => '您真的要取消恢复吗？';

  @override
  String get startAccountRecoveryTitle => '开始恢复';

  @override
  String get whyAddTrustContact => '可信联系人可以帮助恢复您的数据。';

  @override
  String recoveryReady({required String email}) {
    return '您现在可以通过设置新密码来恢复 $email 的账户。';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email 正在尝试恢复您的账户。';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return '您已受邀通过 $email 成为遗产联系人。';
  }

  @override
  String get warning => '警告';

  @override
  String get proceed => '继续';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return '您即将添加 $email 作为可信联系人。如果您离开了 $numOfDays 天，他们将能够恢复您的帐户。';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email 已邀请您成为可信联系人';
  }

  @override
  String get authToManageLegacy => '请验证身份以管理您的可信联系人';

  @override
  String get hideSharedItemsFromHomeGallery => '隐藏主页图库中的共享项目';

  @override
  String get swipeToSelect => '滑动以选择';

  @override
  String get gallery => '图库';

  @override
  String get joinAlbum => '加入相册';

  @override
  String get joinAlbumSubtext => '来查看和添加您的照片';

  @override
  String get joinAlbumSubtextViewer => '来将其添加到共享相册';

  @override
  String get join => '加入';

  @override
  String get linkEmail => '链接邮箱';

  @override
  String get link => '链接';

  @override
  String get noEnteAccountExclamation => '没有 Ente 账户！';

  @override
  String get orPickFromYourContacts => '或从您的联系人中选择';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email 没有 Ente 账户。';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (我)';
  }

  @override
  String get reassignMe => '重新分配“我”';

  @override
  String get me => '我';

  @override
  String get linkEmailToContactBannerCaption => '来实现更快的共享';

  @override
  String get selectPersonToLink => '选择要链接的人';

  @override
  String linkPersonToEmail({required String email}) {
    return '将人员链接到 $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return '这将会将 $personName 链接到 $email';
  }

  @override
  String get selectYourFace => '选择你的脸';

  @override
  String get reassigningLoading => '正在重新分配...';

  @override
  String reassignedToName({required String name}) {
    return '已将您重新分配给 $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => '离开之前要保存更改吗？';

  @override
  String get dontSave => '不保存';

  @override
  String get thisIsMeExclamation => '这就是我！';

  @override
  String get linkPerson => '链接人员';

  @override
  String get linkPersonCaption => '来感受更好的共享体验';

  @override
  String get videoStreaming => '可流媒体播放的视频';

  @override
  String get processingVideos => '正在处理视频';

  @override
  String get streamDetails => '流详情';

  @override
  String get processing => '正在处理';

  @override
  String get queued => '已入列';

  @override
  String get ineligible => '不合格';

  @override
  String get failed => '失败';

  @override
  String get playStream => '播放流';

  @override
  String get playOriginal => '播放原内容';

  @override
  String get joinAlbumConfirmationDialogBody => '加入相册将使相册的参与者可以看到您的电子邮件地址。';

  @override
  String get pleaseWaitThisWillTakeAWhile => '请稍候，这将需要一段时间。';

  @override
  String get editTime => '修改时间';

  @override
  String get selectTime => '选择时间';

  @override
  String get selectDate => '选择日期';

  @override
  String get previous => '以前的';

  @override
  String get selectOneDateAndTimeForAll => '为所有项选择一个日期和时间';

  @override
  String get selectStartOfRange => '选择起始图片';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected => '这将使所有选定的照片的日期和时间相同。';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      '这张照片是该组中的第一张。其他已选择的照片将根据此新日期自动调整。';

  @override
  String get newRange => '新起始图片';

  @override
  String get selectOneDateAndTime => '选择一个日期和时间';

  @override
  String get moveSelectedPhotosToOneDate => '将选定的照片调整到某一日期';

  @override
  String get shiftDatesAndTime => '调整日期和时间';

  @override
  String get photosKeepRelativeTimeDifference => '照片保持相对时间差';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 张照片',
      one: '1 张照片',
      zero: '没有照片',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => '应用图标';

  @override
  String get notThisPerson => '不是此人？';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      '选定的项目将从此人身上移除，但不会从您的库中删除。';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat 年间';
  }

  @override
  String get thisWeekThroughTheYears => '历年本周';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 年前的本周',
      one: '$count 年前的本周',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return '您和 $name';
  }

  @override
  String admiringThem({required Object name}) {
    return '欣赏 $name';
  }

  @override
  String embracingThem({required Object name}) {
    return '拥抱 $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return '与 $name 开派对';
  }

  @override
  String hikingWithThem({required Object name}) {
    return '与 $name 徒步';
  }

  @override
  String feastingWithThem({required Object name}) {
    return '与 $name 的盛宴';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return '与 $name 的自拍';
  }

  @override
  String posingWithThem({required Object name}) {
    return '与 $name 的合影';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return '与 $name 一起欣赏美景';
  }

  @override
  String sportsWithThem({required Object name}) {
    return '与 $name 一起运动';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return '与 $name 一起的自驾游';
  }

  @override
  String get spotlightOnYourself => '聚光灯下的自己';

  @override
  String spotlightOnThem({required Object name}) {
    return '聚光灯下的 $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name  $age 岁啦！';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name 快满 $age 岁啦';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return '最后一次与 $name 相聚';
  }

  @override
  String tripToLocation({required Object location}) {
    return '前往 $location 的旅行';
  }

  @override
  String tripInYear({required Object year}) {
    return '$year 年的旅行';
  }

  @override
  String get lastYearsTrip => '去年的旅行';

  @override
  String get sunrise => '在地平线上';

  @override
  String get mountains => '翻过山丘';

  @override
  String get greenery => '绿色生活';

  @override
  String get beach => '沙滩与大海';

  @override
  String get city => '城市之中';

  @override
  String get moon => '月光之下';

  @override
  String get onTheRoad => '再次踏上旅途';

  @override
  String get food => '美食盛宴';

  @override
  String get pets => '毛茸茸的伙伴';

  @override
  String get curatedMemories => '精选回忆';

  @override
  String get widgets => '小组件';

  @override
  String get memories => '回忆';

  @override
  String get peopleWidgetDesc => '选择您希望在主屏幕上看到的人。';

  @override
  String get albumsWidgetDesc => '选择您希望在主屏幕上看到的相册。';

  @override
  String get memoriesWidgetDesc => '选择您希望在主屏幕上看到的回忆类型。';

  @override
  String get smartMemories => '智能回忆';

  @override
  String get pastYearsMemories => '往年回忆';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return '也删除这$count个相册中的照片（和视频）从它们所在的<bold>所有</bold>其他相册中？';
  }

  @override
  String get addParticipants => '添加参与者';

  @override
  String selectedAlbums({required Object count}) {
    return '已选择 $count 个';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum => '收藏相册不支持此操作';

  @override
  String get onThisDayMemories => '这天的回忆';

  @override
  String get onThisDay => '这天';

  @override
  String get lookBackOnYourMemories => '回顾你的回忆🌄';

  @override
  String get newPhotosEmoji => ' 新 📸';

  @override
  String get sorryWeHadToPauseYourBackups => '抱歉，我们不得不暂停您的备份';

  @override
  String get clickToInstallOurBestVersionYet => '点击安装我们迄今最好的版本';

  @override
  String get onThisDayNotificationExplanation => '接收关于往年这一天回忆的提醒。';

  @override
  String get addMemoriesWidgetPrompt => '将回忆小组件添加到您的主屏幕，然后返回此处进行自定义。';

  @override
  String get addAlbumWidgetPrompt => '将相册小组件添加到您的主屏幕，然后返回此处进行自定义。';

  @override
  String get addPeopleWidgetPrompt => '将人物小组件添加到您的主屏幕，然后返回此处进行自定义。';

  @override
  String get birthdayNotifications => '生日通知';

  @override
  String get receiveRemindersOnBirthdays => '接收某人生日时的提醒。点击通知将带您查看生日人物的照片。';

  @override
  String get happyBirthday => '生日快乐！ 🥳';

  @override
  String get birthdays => '生日';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return '祝 $name 生日快乐！ 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson => '您确定要从此人中移除这个人脸吗？';

  @override
  String get otherDetectedFaces => '其他检测到的人脸';

  @override
  String get areThey => '他们是 ';

  @override
  String get questionmark => '？';

  @override
  String get saveAsAnotherPerson => '另存为其他人物';

  @override
  String get showLessFaces => '显示较少人脸';

  @override
  String get showMoreFaces => '显示更多人脸';

  @override
  String get ignore => '忽略';

  @override
  String get merge => '合并';

  @override
  String get reset => '重设';

  @override
  String get areYouSureYouWantToIgnoreThisPerson => '您确定要忽略此人吗？';

  @override
  String get areYouSureYouWantToIgnoreThesePersons => '您确定要忽略这些人吗？';

  @override
  String get thePersonGroupsWillNotBeDisplayed => '人物组将不再显示在人物部分。照片将保持不变。';

  @override
  String get thePersonWillNotBeDisplayed => '该人将不再显示在人物部分。照片将保持不变。';

  @override
  String get areYouSureYouWantToMergeThem => '您确定要合并他们吗？';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      '所有未命名组将合并到所选人物中。此操作仍可从该人物的建议历史概览中撤销。';

  @override
  String get yesIgnore => '是的，忽略';

  @override
  String get same => '相同';

  @override
  String get different => '不同';

  @override
  String get sameperson => '是同一个人？';

  @override
  String get indexingPausedStatusDescription =>
      '索引已暂停。待设备准备就绪后，索引将自动恢复。当设备的电池电量、电池健康度和温度状态处于健康范围内时，设备即被视为准备就绪。';

  @override
  String get thisWeek => '本周';

  @override
  String get lastWeek => '上周';

  @override
  String get thisMonth => '本月';

  @override
  String get thisYear => '今年';

  @override
  String get groupBy => '分组依据';

  @override
  String get faceThumbnailGenerationFailed => '无法生成人脸缩略图';

  @override
  String get fileAnalysisFailed => '无法分析文件';

  @override
  String get editAutoAddPeople => '编辑自动添加人物';

  @override
  String get autoAddPeople => '自动添加人物';

  @override
  String get autoAddToAlbum => '自动添加到相册';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc => '应该移除之前在智能相册中选择的与该人相关的文件吗？';

  @override
  String get addingPhotos => '正在添加照片';

  @override
  String get gettingReady => '准备就绪';

  @override
  String get addSomePhotosDesc1 => '添加一些照片或者选择 ';

  @override
  String get addSomePhotosDesc2 => '熟悉的面孔';

  @override
  String get addSomePhotosDesc3 => '首先';

  @override
  String get ignorePerson => '忽略此人';

  @override
  String get mixedGrouping => '混合分组？';

  @override
  String get analysis => '分析';

  @override
  String get doesGroupContainMultiplePeople => '这个分组包含多个人吗？';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      '我们将自动分析分组以确定是否有多人在场，并再次将他们分开。这可能需要几秒钟。';

  @override
  String get layout => '布局';

  @override
  String get day => '日';

  @override
  String get undo => '撤销';

  @override
  String get redo => '重做';

  @override
  String get filter => '筛选';

  @override
  String get adjust => '调整';

  @override
  String get draw => '绘制';

  @override
  String get sticker => '贴纸';

  @override
  String get brushColor => '笔刷颜色';

  @override
  String get font => '字体';

  @override
  String get background => '背景';

  @override
  String get align => '对齐';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '已成功添加到 $count 个相册',
      one: '已成功添加到 1 个相册',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => '视频已处理';

  @override
  String get totalVideos => '视频总数';

  @override
  String get skippedVideos => '已跳过的视频';

  @override
  String get videoStreamingDescriptionLine1 => '在任何设备上立即播放视频。';

  @override
  String get videoStreamingDescriptionLine2 => '启用以处理此设备上的视频流。';

  @override
  String get videoStreamingNote =>
      '此设备仅处理过去 60 天内时长不超过 1 分钟的视频。对于更早/更长的视频，请在桌面应用中启用流式传输。';

  @override
  String get createStream => '创建流';

  @override
  String get recreateStream => '重建流';

  @override
  String get addedToStreamCreationQueue => '已添加到流创建队列';

  @override
  String get addedToStreamRecreationQueue => '已添加到流重建队列';

  @override
  String get videoPreviewAlreadyExists => '视频预览已存在';

  @override
  String get videoAlreadyInQueue => '视频文件已存在于队列中';

  @override
  String get videoExportFailed => '视频创建失败，请重试。';

  @override
  String videoExportSuccess({required String path}) {
    return '视频已成功创建于 $path';
  }

  @override
  String get addedToQueue => '已添加至队列';

  @override
  String get creatingStream => '正在创建流';

  @override
  String get similarImages => '相似图片';

  @override
  String get findSimilarImages => '查找相似图片';

  @override
  String get noSimilarImagesFound => '未找到相似图片';

  @override
  String get yourPhotosLookUnique => '您的照片看起来很独特';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 组已找到',
      one: '$count 组已找到',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => '查看并删除相似图片';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return '删除 $count 张照片 ($size)';
  }

  @override
  String get selectionOptions => '选择选项';

  @override
  String selectExactWithCount({required int count}) {
    return '完全相似 ($count)';
  }

  @override
  String get selectExact => '精确选择';

  @override
  String selectSimilarWithCount({required int count}) {
    return '部分相似 ($count)';
  }

  @override
  String get selectSimilar => '选择相似项';

  @override
  String selectAllWithCount({required int count}) {
    return '所有相似项 ($count)';
  }

  @override
  String get selectSimilarImagesTitle => '选择所有相似图片';

  @override
  String get chooseSimilarImagesToSelect => '根据视觉相似性选择图像';

  @override
  String get clearSelection => '清除选择';

  @override
  String similarImagesCount({required int count}) {
    return '$count 张相似图片';
  }

  @override
  String deleteWithCount({required int count}) {
    return '删除 ($count) 项';
  }

  @override
  String get deleteFiles => '删除文件';

  @override
  String get areYouSureDeleteFiles => '您确定要删除这些文件吗？';

  @override
  String get greatJob => '做得好！';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return '您已释放了 $size 的空间';
  }

  @override
  String get size => '大小';

  @override
  String get similarity => '相似度';

  @override
  String get analyzingPhotosLocally => '正在本地分析您的照片...';

  @override
  String get lookingForVisualSimilarities => '正在寻找视觉相似点……';

  @override
  String get comparingImageDetails => '正在比较图像细节...';

  @override
  String get findingSimilarImages => '正在寻找相似图片...';

  @override
  String get almostDone => '即将完成...';

  @override
  String get processingLocally => '正在本地处理';

  @override
  String get useMLToFindSimilarImages => '审查并删除看起来彼此相似的图像。';

  @override
  String get all => '全部';

  @override
  String get similar => '相似的';

  @override
  String get identical => '完全相同';

  @override
  String get nothingHereTryAnotherFilter => '此处无内容，请尝试其他过滤器！👀';

  @override
  String get related => '相关';

  @override
  String get hoorayyyy => '耶～～！';

  @override
  String get nothingToTidyUpHere => '这里没什么可清理的';

  @override
  String get deletingDash => '正在删除 - ';

  @override
  String get cLTitle1 => '介绍仪式';

  @override
  String get cLDesc1 =>
      '计划2026年的目标？通过仪式功能，您可以在Ente Photos中设置提醒并通过拍照追踪进度。用于健身、饮食习惯、与亲人的日常时刻——任何您想养成习惯的事情。';

  @override
  String get cLTitle2 => '公开链接，现在人人可用';

  @override
  String get cLDesc2 => '所有免费计划的Ente用户现在都可以创建和分享照片和相册的公开链接。为防止滥用，链接将限制可查看人数。';

  @override
  String get cLTitle3 => '手动标记人物';

  @override
  String get cLDesc3 =>
      '即使设备端AI未检测到人脸，您现在也可以标记人物。适用于宠物、部分可见的面孔，或者某人实际上不在照片中但仍应被包含的时刻。';

  @override
  String get cLTitle4 => '更多更新';

  @override
  String get cLDesc4 =>
      '您现在可以置顶共享相册。相册链接对协作者和查看者可见，使分享更加便捷。我们修复了一些iOS滑动问题并更新了照片视图，包括新的收藏图标（为即将推出的功能腾出空间）。';

  @override
  String get closeBy => '关闭';

  @override
  String get peopleAutoAddDesc => '自动将选定人物的照片添加到此相册';

  @override
  String get festivities => '节日欢庆';

  @override
  String get snowAdventures => '冬日探险';

  @override
  String get waterfalls => '追逐瀑布';

  @override
  String get wildlife => '走进荒野';

  @override
  String get flowers => '绽放之美';

  @override
  String get nightLights => '霓虹之夜';

  @override
  String get architecture => '设计典藏';

  @override
  String get autumnColors => '秋日华彩';

  @override
  String get desertDreams => '沙漠之梦';

  @override
  String get stargazing => '星空之下';

  @override
  String get lakeside => '湖畔宁静';

  @override
  String get rainyDays => '雨天心情';

  @override
  String get sportsAction => '开赛时刻';

  @override
  String get streetArt => '街头艺术故事';

  @override
  String get familyMoments => '家庭时光';

  @override
  String get fireworks => '烟火终章';

  @override
  String get historicSites => '历史回响';

  @override
  String get tropicalParadise => '热带之旅';

  @override
  String get forestTrails => '森林漫步';

  @override
  String get citySunsets => '城市落日余晖';

  @override
  String get colorfulMarkets => '活力市集';

  @override
  String get cozyCafes => '惬意咖啡角落';

  @override
  String get vintageVibes => '复古氛围';

  @override
  String get aerialViews => '空中视角';

  @override
  String get artisticPortraits => '艺术人像';

  @override
  String get streetFood => '街头美食一口咬';

  @override
  String get riverCruises => '河上游览美景';

  @override
  String get facesTimelineBannerTitle => '和 TA 的回忆';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return '一起看看 $name 这些年的样子';
  }

  @override
  String get facesTimelineAppBarTitle => '和 TA 的回忆';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 岁啦',
    );
    return '$name 已经 $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# 年前',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => '视频共享即将到来';

  @override
  String get facesTimelinePlaybackPrevious => '上一张';

  @override
  String get facesTimelinePlaybackNext => '下一张';

  @override
  String get facesTimelinePlaybackPlay => '播放';

  @override
  String get facesTimelinePlaybackPause => '暂停';

  @override
  String get facesTimelineUnavailable => '和 TA 们的回忆正在准备中……';

  @override
  String get playfulKids => '童趣时光';

  @override
  String get coastalCliffs => '海边峭壁';

  @override
  String get ritualsTitle => '仪式';

  @override
  String get ritualAddTooltip => '添加仪式';

  @override
  String get ritualActivityHeading => '活动';

  @override
  String get ritualDefaultHeatmapTitle => '每日一拍';

  @override
  String get ritualUntitled => '未命名仪式';

  @override
  String get ritualShareUnavailable => '暂时无法分享，请稍后重试。';

  @override
  String get ritualNotificationMessage => '立即拍照';

  @override
  String get ritualCameraNotFound => '在此设备上未找到相机。';

  @override
  String get ritualCameraStartError => '无法启动相机，请检查权限';

  @override
  String get ritualCaptureError => '无法拍摄照片。请重试。';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# 张照片。',
    );
    return '您最多可以添加 $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => '先至少拍一张照片。';

  @override
  String get ritualAlbumMissing => '仪式相册缺失。请编辑仪式以设置相册。';

  @override
  String get ritualAddedToAlbum => '已添加到相册';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return '已添加到 $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return '无法向此相册添加照片： $error';
  }

  @override
  String get ritualBackToList => '回到仪式';

  @override
  String get ritualNoPhotosYet => '暂无照片';

  @override
  String get ritualSetAlbumToLaunchCamera => '设置一个相册，记录下这个启动相机的仪式。';

  @override
  String get ritualDefaultCameraTitle => '拍照';

  @override
  String get ritualBadgeMessage7 => '7天过去了！坚持不懈让你看起来状态很好。继续加油！';

  @override
  String get ritualBadgeMessage14 => '已经坚持了14天！你的仪式正在变成一种习惯。太棒了！';

  @override
  String get ritualBadgeMessage30 => '连续30天！真是传奇般的稳定性。太棒了！';

  @override
  String get ritualBadgeMessageDefault => '你最近状态超好！';

  @override
  String get ritualBadgeNewTitle => '新成就';

  @override
  String get ritualBadgePreparing => '准备中...';

  @override
  String get ritualStreaksLabel => '连胜';

  @override
  String get ritualCreateYourOwn => '创建你自己的仪式';

  @override
  String get ritualGetDailyReminders => '每日提醒';

  @override
  String get ritualAlbumNotSet => '相册未设置';

  @override
  String get ritualOpenCameraTooltip => '打开仪式相机';

  @override
  String get ritualEditorLabel => '仪式编辑器';

  @override
  String get ritualNew => '新仪式';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => '编辑仪式';

  @override
  String get ritualEnterPrompt => '输入您的仪式';

  @override
  String get ritualEnterDescription => '请输入描述';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => '天';

  @override
  String get ritualNotificationsOffHint => '通知已关闭。点击日期即可开启通知。';

  @override
  String get ritualTimeLabel => '时间';

  @override
  String get ritualAlbumLabel => '相册';

  @override
  String get ritualSave => '保存仪式';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => '更新仪式';

  @override
  String get ritualSelectAlbumTitle => '选择相册';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => '搜索或新建';

  @override
  String get ritualNoAlbumsYet => '暂无相册';

  @override
  String get ritualNoMatchingAlbums => '没有匹配的相册';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return '创建“$albumName“';
  }

  @override
  String get ritualCreateNew => '新建';

  @override
  String get ritualAlbumSelectionPlaceholder => '选择相册';

  @override
  String get ritualPickEmojiTitle => '选择一个表情';

  @override
  String get ritualCustomKeyboardLabel => '自定义（键盘）';

  @override
  String get ritualEmojiKeyboardHint => '按下即可打开表情符号键盘';

  @override
  String get ritualEmojiUseAction => '使用';

  @override
  String get ritualSearchEmpty => '养成拍照的习惯，并为此建立一套仪式。';
}
