// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class AppLocalizationsUk extends AppLocalizations {
  AppLocalizationsUk([String locale = 'uk']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Введіть вашу адресу електронної пошти';

  @override
  String get enterYourNewEmailAddress =>
      'Введіть вашу нову адресу електронної пошти';

  @override
  String get accountWelcomeBack => 'З поверненням!';

  @override
  String get emailAlreadyRegistered => 'Пошту вже зареєстровано.';

  @override
  String get emailNotRegistered => 'Пошту не зареєстровано.';

  @override
  String get email => 'Адреса електронної пошти';

  @override
  String get cancel => 'Скасувати';

  @override
  String get verify => 'Підтвердити';

  @override
  String get invalidEmailAddress => 'Хибна адреса електронної пошти';

  @override
  String get enterValidEmail =>
      'Будь ласка, введіть дійсну адресу електронної пошти.';

  @override
  String get deleteAccount => 'Видалити обліковий запис';

  @override
  String get deleteAccountWarning =>
      'Це видалить ваші облікові записи Ente Auth, Ente Photos та Ente Locker.';

  @override
  String get askDeleteReason =>
      'Яка основна причина видалення вашого облікового запису?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Нам шкода, що ви йдете. Будь ласка, поділіться своїм відгуком, щоб допомогти нам покращитися.';

  @override
  String get feedback => 'Зворотній зв’язок';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Будь ласка, допоможіть нам із цією інформацією';

  @override
  String get confirmDeletePrompt =>
      'Так, я хочу безповоротно видалити цей обліковий запис та його дані з усіх застосунків.';

  @override
  String get confirmAccountDeletion =>
      'Підтвердьте видалення облікового запису';

  @override
  String get deleteAccountPermanentlyButton =>
      'Остаточно видалити обліковий запис';

  @override
  String get yourAccountHasBeenDeleted => 'Ваш обліковий запис видалено';

  @override
  String get selectReason => 'Оберіть причину';

  @override
  String get deleteReason1 => 'Мені бракує ключової функції';

  @override
  String get deleteReason2 =>
      'Застосунок або певна функція не поводяться так, як я думаю, вони повинні';

  @override
  String get deleteReason3 =>
      'Я знайшов інший сервіс, який подобається мені більше';

  @override
  String get deleteReason4 => 'Причина не перерахована';

  @override
  String get sendEmail => 'Надіслати електронного листа';

  @override
  String get deleteRequestSLAText =>
      'Ваш запит буде оброблений протягом 72 годин.';

  @override
  String get deleteEmailRequest =>
      'Будь ласка, надішліть електронного листа на <warning>account-deletion@ente.io</warning> зі скриньки, зазначеної при реєстрації.';

  @override
  String get entePhotosPerm => 'Ente <i>потребує дозволу</i> до ваших світлин';

  @override
  String get ok => 'Добре';

  @override
  String get createAccount => 'Створити обліковий запис';

  @override
  String get createNewAccount => 'Створити новий обліковий запис';

  @override
  String get password => 'Пароль';

  @override
  String get confirmPassword => 'Підтвердити пароль';

  @override
  String get activeSessions => 'Активні сеанси';

  @override
  String get ocrProcessingOverlayMessage => 'Виявлення тексту...';

  @override
  String get ocrLoadingIndicatorLabel => 'Виявлення тексту';

  @override
  String get ocrSelectionHint =>
      'Проведіть або двічі торкніться, щоб обрати те, що вам потрібно';

  @override
  String get ocrNoTextDetected => 'Текст не виявлено';

  @override
  String get ocrRetryButtonLabel => 'Повторити';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Файл зображення не знайдено';

  @override
  String get ocrImageDecodeFailedError =>
      'Не вдалося прочитати файл зображення';

  @override
  String get ocrGenericDetectError => 'Не вдалося виявити текст на зображенні';

  @override
  String get oops => 'От халепа';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Щось пішло не так, будь ласка, спробуйте знову';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Це призведе до виходу на цьому пристрої!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Це призведе до виходу на наступному пристрої:';

  @override
  String get terminateSession => 'Припинити сеанс?';

  @override
  String get terminate => 'Припинити';

  @override
  String get thisDevice => 'Цей пристрій';

  @override
  String get recoverButton => 'Відновлення';

  @override
  String get recoverySuccessful => 'Відновлення успішне!';

  @override
  String get decrypting => 'Дешифрування...';

  @override
  String get incorrectRecoveryKeyTitle => 'Невірний ключ відновлення';

  @override
  String get incorrectRecoveryKeyBody => 'Ви ввели невірний ключ відновлення';

  @override
  String get forgotPassword => 'Нагадати пароль';

  @override
  String get enterYourRecoveryKey => 'Введіть ваш ключ відновлення';

  @override
  String get noRecoveryKey => 'Немає ключа відновлення?';

  @override
  String get sorry => 'Пробачте';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Через природу нашого кінцевого протоколу шифрування, ваші дані не можуть бути розшифровані без вашого пароля або ключа відновлення';

  @override
  String get verifyEmail => 'Підтвердити пошту';

  @override
  String get toResetVerifyEmail =>
      'Щоб скинути пароль, спочатку підтвердьте адресу своєї пошти.';

  @override
  String get checkInboxAndSpamFolder =>
      'Перевірте вашу поштову скриньку (та спам), щоб завершити перевірку';

  @override
  String get tapToEnterCode => 'Натисніть, щоб ввести код';

  @override
  String get resendEmail => 'Повторно надіслати лист';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Ми надіслали листа на <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Встановити пароль';

  @override
  String get changePasswordTitle => 'Змінити пароль';

  @override
  String get resetPasswordTitle => 'Скинути пароль';

  @override
  String get encryptionKeys => 'Ключі шифрування';

  @override
  String get passwordWarning =>
      'Ми не зберігаємо цей пароль, тому, якщо ви його забудете, <underline>ми не зможемо розшифрувати ваші дані</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Введіть пароль, який ми зможемо використати для шифрування ваших даних';

  @override
  String get enterNewPasswordToEncrypt =>
      'Введіть новий пароль, який ми зможемо використати для шифрування ваших даних';

  @override
  String get weakStrength => 'Слабкий';

  @override
  String get strongStrength => 'Надійний';

  @override
  String get moderateStrength => 'Середній';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Надійність пароля: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Пароль успішно змінено';

  @override
  String get generatingEncryptionKeys => 'Створення ключів шифрування...';

  @override
  String get pleaseWait => 'Будь ласка, зачекайте...';

  @override
  String get continueLabel => 'Продовжити';

  @override
  String get insecureDevice => 'Незахищений пристрій';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'На жаль, на цьому пристрої не вдалося створити безпечні ключі.\n\nЗареєструйтесь з іншого пристрою.';

  @override
  String get howItWorks => 'Як це працює';

  @override
  String get encryption => 'Шифрування';

  @override
  String get ackPasswordLostWarning =>
      'Я розумію, що якщо я втрачу свій пароль, я можу втратити свої дані, тому що вони є захищені <underline>наскрізним шифруванням</underline>.';

  @override
  String get privacyPolicyTitle => 'Політика приватності';

  @override
  String get termsOfServicesTitle => 'Умови';

  @override
  String get signUpTerms =>
      'Я приймаю <u-terms>умови використання</u-terms> і <u-policy>політику приватності</u-policy>';

  @override
  String get logInLabel => 'Увійти';

  @override
  String get loginTerms =>
      'Натискаючи «Увійти», я приймаю <u-terms>умови використання</u-terms> і <u-policy>політику приватності</u-policy>';

  @override
  String get changeEmail => 'Змінити адресу пошти';

  @override
  String get enterYourPassword => 'Введіть пароль';

  @override
  String get welcomeBack => 'З поверненням!';

  @override
  String get contactSupport => 'Звернутися до служби підтримки';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Невірний пароль';

  @override
  String get pleaseTryAgain => 'Спробуйте ще раз';

  @override
  String get recreatePasswordTitle => 'Повторно створити пароль';

  @override
  String get useRecoveryKey => 'Застосувати ключ відновлення';

  @override
  String get recreatePasswordBody =>
      'Ваш пристрій недостатньо потужний для перевірки пароля, але ми можемо відновити його таким чином, щоб він працював на всіх пристроях.\n\nУвійдіть за допомогою ключа відновлення та відновіть свій пароль (за бажанням ви можете використати той самий ключ знову).';

  @override
  String get verifyPassword => 'Підтвердження пароля';

  @override
  String get recoveryKey => 'Ключ відновлення';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Якщо ви забудете свій пароль, то єдиний спосіб відновити ваші дані – за допомогою цього ключа.';

  @override
  String get recoveryKeySaveDescription =>
      'Ми не зберігаємо цей ключ, збережіть цей ключ із 24 слів в надійному місці.';

  @override
  String get doThisLater => 'Зробити це пізніше';

  @override
  String get saveKey => 'Зберегти ключ';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Ключ відновлення скопійовано в буфер обміну';

  @override
  String get recoverAccount => 'Відновити обліковий запис';

  @override
  String get recover => 'Відновити';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Надішліть листа на $supportEmail з вашої зареєстрованої поштової адреси';
  }

  @override
  String get twofactorSetup => 'Налаштування двоетапної перевірки';

  @override
  String get enterCode => 'Введіть код';

  @override
  String get scanCode => 'Сканувати код';

  @override
  String get codeCopiedToClipboard => 'Код скопійовано до буфера обміну';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Скопіюйте цей код\nу ваш застосунок для автентифікації';

  @override
  String get tapToCopy => 'натисніть, щоб скопіювати';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Зіскануйте цей штрихкод за допомогою\nвашого застосунку для автентифікації';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Введіть 6-значний код з\nвашого застосунку для автентифікації';

  @override
  String get confirm => 'Підтвердити';

  @override
  String get setupComplete => 'Налаштування завершено';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Збережіть ваш ключ відновлення, якщо ви ще цього не зробили';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Це може бути використано для відновлення вашого облікового запису, якщо ви втратите свій автентифікатор';

  @override
  String get twofactorAuthenticationPageTitle => 'Двоетапна перевірка';

  @override
  String get lostDevice => 'Загубили пристрій?';

  @override
  String get verifyingRecoveryKey => 'Перевірка ключа відновлення...';

  @override
  String get recoveryKeyVerified => 'Ключ відновлення перевірено';

  @override
  String get recoveryKeySuccessBody =>
      'Чудово! Ваш ключ відновлення дійсний. Дякуємо за перевірку.\n\nНе забувайте надійно зберігати ключ відновлення.';

  @override
  String get invalidRecoveryKey =>
      'Уведений вами ключ відновлення недійсний. Переконайтеся, що він містить 24 слова, і перевірте правильність написання кожного з них.\n\nЯкщо ви ввели старіший код відновлення, переконайтеся, що він складається з 64 символів, і перевірте кожен з них.';

  @override
  String get invalidKey => 'Невірний ключ';

  @override
  String get tryAgain => 'Спробувати знову';

  @override
  String get viewRecoveryKey => 'Переглянути ключ відновлення';

  @override
  String get confirmRecoveryKey => 'Підтвердити ключ відновлення';

  @override
  String get recoveryKeyVerifyReason =>
      'Ключ відновлення — це єдиний спосіб відновити фотографії, якщо ви забули пароль. Ви можете знайти свій ключ в розділі «Налаштування» > «Обліковий запис».\n\nВведіть ключ відновлення тут, щоб перевірити, чи правильно ви його зберегли.';

  @override
  String get confirmYourRecoveryKey => 'Підтвердіть ваш ключ відновлення';

  @override
  String get addViewer => 'Додати глядача';

  @override
  String get addCollaborator => 'Додати співавтора';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Додати нову пошту';

  @override
  String get orPickAnExistingOne => 'Або виберіть наявну';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Співавтори можуть додавати фотографії та відео до спільного альбому.';

  @override
  String get enterEmail => 'Введіть поштову адресу';

  @override
  String get albumOwner => 'Власник';

  @override
  String get you => 'Ви';

  @override
  String get collaborator => 'Співавтор';

  @override
  String get addMore => 'Додати більше';

  @override
  String get viewer => 'Глядач';

  @override
  String get remove => 'Вилучити';

  @override
  String get removeParticipant => 'Видалити учасника';

  @override
  String get manage => 'Керування';

  @override
  String get addedAs => 'Додано як';

  @override
  String get changePermissions => 'Змінити дозволи?';

  @override
  String get yesConvertToViewer => 'Так, перетворити в глядача';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user не зможе додавати більше фотографій до цього альбому\n\nВони все ще зможуть видаляти додані ними фотографії';
  }

  @override
  String get allowAddingPhotos => 'Дозволити додавати фотографії';

  @override
  String get allowJoiningAlbum => 'Дозволити приєднання до альбому';

  @override
  String get allowAddPhotosDescription =>
      'Дозволити людям з посиланням також додавати фотографії до спільного альбому.';

  @override
  String get passwordLock => 'Блокування паролем';

  @override
  String get canNotOpenTitle => 'Неможливо відкрити цей альбом';

  @override
  String get canNotOpenBody => 'Sorry, this album cannot be opened in the app.';

  @override
  String get disableDownloadWarningTitle => 'Зверніть увагу';

  @override
  String get disableDownloadWarningBody =>
      'Переглядачі все ще можуть робити знімки екрана або зберігати копію ваших фотографій за допомогою зовнішніх інструментів';

  @override
  String get allowDownloads => 'Дозволити завантаження';

  @override
  String get linkDeviceLimit => 'Досягнуто ліміту пристроїв';

  @override
  String get noDeviceLimit => 'Немає';

  @override
  String get albumLayout => 'Макет альбому';

  @override
  String get layoutGrouped => 'Згрупований';

  @override
  String get layoutContinuous => 'Безперервний';

  @override
  String get layoutTrip => 'Подорож';

  @override
  String get preview => 'Попередній перегляд';

  @override
  String get linkExpiry => 'Термін дії посилання закінчився';

  @override
  String get linkExpired => 'Закінчився';

  @override
  String get linkEnabled => 'Увімкнено';

  @override
  String get linkNeverExpires => 'Ніколи';

  @override
  String get expiredLinkInfo =>
      'Термін дії цього посилання минув. Будь ласка, виберіть новий час терміну дії або вимкніть це посилання.';

  @override
  String get setAPassword => 'Встановити пароль';

  @override
  String get lockButtonLabel => 'Заблокувати';

  @override
  String get enterPassword => 'Введіть пароль';

  @override
  String get removeLink => 'Вилучити посилання';

  @override
  String get manageLink => 'Керувати посиланням';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Посилання закінчується через $expiryTime';
  }

  @override
  String get albumUpdated => 'Альбом оновлено';

  @override
  String get never => 'Ніколи';

  @override
  String get custom => 'Власне';

  @override
  String get after1Hour => 'Через 1 годину';

  @override
  String get after1Day => 'Через 1 день';

  @override
  String get after1Week => 'Через 1 тиждень';

  @override
  String get after1Month => 'Через 1 місяць';

  @override
  String get after1Year => 'Через 1 рік';

  @override
  String get manageParticipants => 'Керування';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count учасників',
      one: '1 учасник',
      zero: 'Немає учасників',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Створіть посилання, щоб дозволити людям додавати й переглядати фотографії у вашому спільному альбомі без використання застосунку Ente або облікового запису. Чудово підходить для збору фотографій з подій.';

  @override
  String get collectPhotos => 'Зібрати фотографії';

  @override
  String get collaborativeLink => 'Спільне посилання';

  @override
  String get shareWithNonenteUsers => 'Поділитися з користувачами без Ente';

  @override
  String get createPublicLink => 'Створити публічне посилання';

  @override
  String get sendLink => 'Надіслати посилання';

  @override
  String get qrCode => 'QR-код';

  @override
  String get sendQrCode => 'Надіслати QR-код';

  @override
  String get copyLink => 'Копіювати посилання';

  @override
  String get copyEmbedHtml => 'Скопіювати вбудований HTML';

  @override
  String get linkHasExpired => 'Посилання прострочено';

  @override
  String get publicLinkEnabled => 'Публічне посилання увімкнено';

  @override
  String get shareALink => 'Поділитися посиланням';

  @override
  String get sharedAlbumSectionDescription =>
      'Створюйте спільні альбоми з іншими користувачами Ente, включно з користувачами безплатних тарифів.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Поділитися з $numberOfPeople людьми',
      one: 'Поділитися з 1 особою',
      zero: 'Поділитися з конкретними людьми',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Це ваш Ідентифікатор підтвердження';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Той, хто ділиться з вами альбомами, повинен бачити той самий ідентифікатор на своєму пристрої.';

  @override
  String get howToViewShareeVerificationID =>
      'Попросіть їх довго утримувати палець на свій поштовій адресі на екрані налаштувань і переконайтеся, що ідентифікатори на обох пристроях збігаються.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Це ідентифікатор підтвердження пошти $email';
  }

  @override
  String get verificationId => 'Ідентифікатор підтвердження';

  @override
  String verifyEmailID({required Object email}) {
    return 'Підтвердити $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return 'У $email немає облікового запису Ente.\n\nНадішліть їм запрошення для обміну фотографіями.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Ось мій ідентифікатор підтвердження: $verificationID для ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Гей, ви можете підтвердити, що це ваш ідентифікатор підтвердження: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Щось пішло не так';

  @override
  String get sendInvite => 'Надіслати запрошення';

  @override
  String get shareTextRecommendUsingEnte =>
      'Завантажте Ente для того, щоб легко поділитися фотографіями оригінальної якості та відео\n\nhttps://ente.io';

  @override
  String get done => 'Готово';

  @override
  String get applyCodeTitle => 'Застосувати код';

  @override
  String get enterCodeDescription =>
      'Введіть код, наданий вашим другом, щоби отримати безплатне сховище для вас обох';

  @override
  String get apply => 'Застосувати';

  @override
  String get failedToApplyCode => 'Не вдалося застосувати код';

  @override
  String get enterReferralCode => 'Введіть реферальний код';

  @override
  String get codeAppliedPageTitle => 'Код застосовано';

  @override
  String get changeYourReferralCode => 'Змінити ваш реферальний код';

  @override
  String get change => 'Змінити';

  @override
  String get unavailableReferralCode => 'На жаль, цей код недоступний.';

  @override
  String get codeChangeLimitReached => 'На жаль, ви досягли ліміту змін коду.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Зв\'яжіться з $familyAdminEmail, щоб змінити код.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB ГБ';
  }

  @override
  String get claimed => 'Отримано';

  @override
  String get details => 'Подробиці';

  @override
  String get claimMore => 'Отримайте більше!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Вони також отримують $storageAmountInGB ГБ';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB ГБ щоразу, коли хтось оформлює передплату і застосовує ваш код';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Реферальний код Ente: $referralCode \n\nЗастосуйте його в «Налаштування» → «Загальні» → «Реферали», щоб отримати $referralStorageInGB ГБ безплатно після переходу на платний тариф\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Отримайте безплатне сховище';

  @override
  String get inviteYourFriends => 'Запросити своїх друзів';

  @override
  String get failedToFetchReferralDetails =>
      'Не вдається отримати відомості про реферала. Спробуйте ще раз пізніше.';

  @override
  String get referralStep1 => '1. Дайте цей код друзям';

  @override
  String get referralStep2 => '2. Вони оформлюють передплату';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Ви обоє отримуєте $storageInGB ГБ* безплатно';
  }

  @override
  String get referralsAreCurrentlyPaused => 'Реферали зараз призупинені';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Ви можете максимально подвоїти своє сховище';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Ваша сім\'я отримала $storageAmountInGb ГБ',
      'false': 'Ви отримали $storageAmountInGb ГБ',
      'other': 'Ви отримали $storageAmountInGb ГБ!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'ЧаПи';

  @override
  String get help => 'Допомога';

  @override
  String get oopsSomethingWentWrong => 'Йой, щось пішло не так';

  @override
  String get peopleUsingYourCode => 'Люди, які використовують ваш код';

  @override
  String get eligible => 'придатний';

  @override
  String get total => 'всього';

  @override
  String get codeUsedByYou => 'Код використано вами';

  @override
  String get freeStorageClaimed => 'Безплатне сховище отримано';

  @override
  String get freeStorageUsable => 'Безплатне сховище можна використовувати';

  @override
  String get usableReferralStorageInfo =>
      'Доступний обсяг пам\'яті обмежений вашим поточним тарифом. Надлишок заявленого обсягу автоматично стане доступним, коли ви покращите тариф.';

  @override
  String get removeFromAlbumTitle => 'Видалити з альбому?';

  @override
  String get removeFromAlbum => 'Видалити з альбому';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Обрані елементи будуть видалені з цього альбому';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Додавання до обраного...';

  @override
  String get removingFromFavorites => 'Видалення з обраного...';

  @override
  String get sorryCouldNotAddToFavorites => 'Неможливо додати до обраного!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Не вдалося видалити з обраного!';

  @override
  String get subscribeToEnableSharing =>
      'Вам потрібна активна передплата, щоб увімкнути спільне поширення.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'Передплачувати';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Ви можете видалити лише файли, що належать вам';

  @override
  String get deleteSharedAlbum => 'Видалити спільний альбом?';

  @override
  String get deleteAlbum => 'Видалити альбом';

  @override
  String get deleteAlbumDialog =>
      'Також видалити фотографії (і відео), які є в цьому альбомі, зі <bold>всіх</bold> інших альбомів, з яких вони складаються?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Альбом буде видалено для всіх\n\nВи втратите доступ до спільних фотографій у цьому альбомі, які належать іншим';

  @override
  String get yesRemove => 'Так, видалити';

  @override
  String get creatingLink => 'Створення посилання...';

  @override
  String get removeWithQuestionMark => 'Видалити?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail буде видалено з цього спільного альбому\n\nБудь-які додані вами фото, будуть також видалені з альбому';
  }

  @override
  String get keepPhotos => 'Залишити фото';

  @override
  String get deletePhotos => 'Видалити фото';

  @override
  String get inviteToEnte => 'Запросити до Ente';

  @override
  String get removePublicLink => 'Видалити публічне посилання';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Це видалить публічне посилання для доступу до «$albumName».';
  }

  @override
  String get sharing => 'Відправлення...';

  @override
  String get youCannotShareWithYourself => 'Ви не можете поділитися із собою';

  @override
  String get archive => 'Архів';

  @override
  String get createAlbumActionHint =>
      'Утримуйте, щоби вибрати фотографії, та натисніть «+», щоб створити альбом';

  @override
  String get importing => 'Імпортування...';

  @override
  String get failedToLoadAlbums => 'Не вдалося завантажити альбоми';

  @override
  String get hidden => 'Приховано';

  @override
  String get authToViewYourHiddenFiles =>
      'Авторизуйтеся, щоб переглянути приховані файли';

  @override
  String get authToViewTrashedFiles =>
      'Please authenticate to view your trashed files';

  @override
  String get trash => 'Смітник';

  @override
  String get uncategorized => 'Без категорії';

  @override
  String get videoSmallCase => 'відео';

  @override
  String get photoSmallCase => 'фото';

  @override
  String get singleFileDeleteHighlight => 'Воно буде видалено з усіх альбомів.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Цей $fileType знаходиться і в Ente, і на вашому пристрої.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Цей $fileType буде видалено з Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Цей $fileType буде видалено з пристрою.';
  }

  @override
  String get deleteFromEnte => 'Видалити з Ente';

  @override
  String get yesDelete => 'Так, видалити';

  @override
  String get movedToTrash => 'Переміщено у смітник';

  @override
  String get deleteFromDevice => 'Видалити з пристрою';

  @override
  String get deleteFromBoth => 'Видалити з обох';

  @override
  String get newAlbum => 'Новий альбом';

  @override
  String get albums => 'Альбоми';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount memories',
      one: '$formattedCount memory',
      zero: 'no memories',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count вибрано';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count вибрано ($yourCount ваші)';
  }

  @override
  String get advancedSettings => 'Додатково';

  @override
  String get photoGridSize => 'Розмір сітки фотографій';

  @override
  String get manageDeviceStorage => 'Керування кешем пристрою';

  @override
  String get manageDeviceStorageDesc =>
      'Переглянути та очистити локальне сховище кешу.';

  @override
  String get machineLearning => 'Машинне навчання';

  @override
  String get mlConsent => 'Увімкнути машинне навчання';

  @override
  String get mlConsentTitle => 'Увімкнути машинне навчання?';

  @override
  String get mlConsentDescription =>
      'Якщо увімкнути машинне навчання, Ente вилучатиме інформацію, наприклад геометрію обличчя з файлів, включно з тими, хто поділився з вами.\n\nЦе відбуватиметься на вашому пристрої, і будь-яка згенерована біометрична інформація буде наскрізно зашифрована.';

  @override
  String get mlConsentPrivacy =>
      'Натисніть тут для більш детальної інформації про цю функцію в нашій політиці приватності';

  @override
  String get mlConsentConfirmation =>
      'Я розумію, та бажаю увімкнути машинне навчання';

  @override
  String get magicSearch => 'Магічний пошук';

  @override
  String get discover => 'Відкрийте для себе';

  @override
  String get discover_identity => 'Особистість';

  @override
  String get discover_screenshots => 'Знімки екрана';

  @override
  String get discover_receipts => 'Квитанції';

  @override
  String get discover_notes => 'Нотатки';

  @override
  String get discover_memes => 'Меми';

  @override
  String get discover_visiting_cards => 'Візитівки';

  @override
  String get discover_babies => 'Немовлята';

  @override
  String get discover_pets => 'Домашні тварини';

  @override
  String get discover_selfies => 'Селфі';

  @override
  String get discover_wallpapers => 'Шпалери';

  @override
  String get discover_food => 'Їжа';

  @override
  String get discover_celebrations => 'Святкування';

  @override
  String get discover_sunset => 'Захід сонця';

  @override
  String get discover_hills => 'Пагорби';

  @override
  String get discover_greenery => 'Зелень';

  @override
  String get mlIndexingDescription =>
      'Зверніть увагу, що машинне навчання призведе до збільшення пропускної здатності та споживання заряду батареї, поки не будуть проіндексовані всі елементи. Для прискорення індексації скористайтеся настільним застосунком, всі результати будуть синхронізовані автоматично.';

  @override
  String get loadingModel => 'Завантаження моделей...';

  @override
  String get waitingForWifi => 'Очікування на Wi-Fi...';

  @override
  String get status => 'Стан';

  @override
  String get indexedItems => 'Індексовані елементи';

  @override
  String get pendingItems => 'Елементи на розгляді';

  @override
  String get clearIndexes => 'Очистити індекси';

  @override
  String get selectFoldersForBackup => 'Оберіть теки для резервного копіювання';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Обрані теки будуть зашифровані й створені резервні копії';

  @override
  String get unselectAll => 'Зняти виділення';

  @override
  String get selectAll => 'Обрати все';

  @override
  String get skip => 'Пропустити';

  @override
  String get updatingFolderSelection => 'Оновлення вибору теки...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count елементів',
      many: '$count елементів',
      few: '$count елементи',
      one: '$count елемент',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Видалено $count елементів',
      one: 'Видалено $count елемент',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count файлів, кожен по $formattedSize';
  }

  @override
  String get showMemories => 'Показати спогади';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count років тому',
      one: '$count рік тому',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Налаштування резервного копіювання';

  @override
  String get backupStatus => 'Стан резервного копіювання';

  @override
  String get backupStatusDescription =>
      'Елементи, для яких було створено резервну копію, показуватимуться тут';

  @override
  String get backupOverMobileData => 'Резервне копіювання через мобільні дані';

  @override
  String get backupVideos => 'Резервне копіювання відео';

  @override
  String get disableAutoLock => 'Вимкнути автоблокування';

  @override
  String get deviceLockExplanation =>
      'Вимкніть блокування екрана пристрою, коли на передньому плані знаходиться Ente і виконується резервне копіювання. Зазвичай це не потрібно, але може допомогти швидше завершити великі вивантаження і початковий імпорт великих бібліотек.';

  @override
  String get about => 'Про застосунок';

  @override
  String get weAreOpenSource => 'У нас відкритий вихідний код!';

  @override
  String get privacy => 'Приватність';

  @override
  String get terms => 'Умови';

  @override
  String get checkForUpdates => 'Перевiрити наявнiсть оновлень';

  @override
  String get checkStatus => 'Перевірити стан';

  @override
  String get checking => 'Перевірка...';

  @override
  String get youAreOnTheLatestVersion => 'Ви використовуєте останню версію';

  @override
  String get account => 'Обліковий запис';

  @override
  String get manageSubscription => 'Керування передплатою';

  @override
  String get authToChangeYourEmail =>
      'Авторизуйтесь, щоб змінити поштову адресу';

  @override
  String get changePassword => 'Змінити пароль';

  @override
  String get authToChangeYourPassword => 'Авторизуйтесь, щоб змінити пароль';

  @override
  String get emailVerificationToggle => 'Підтвердження через пошту';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Авторизуйтесь, щоб змінити перевірку через пошту';

  @override
  String get exportYourData => 'Експортувати дані';

  @override
  String get logout => 'Вийти';

  @override
  String get authToInitiateAccountDeletion =>
      'Авторизуйтесь, щоби розпочати видалення облікового запису';

  @override
  String get areYouSureYouWantToLogout =>
      'Ви впевнені, що хочете вийти з облікового запису?';

  @override
  String get yesLogout => 'Так, вийти з облікового запису';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Доступна нова версія Ente.';

  @override
  String get update => 'Оновити';

  @override
  String get installManually => 'Встановити вручну';

  @override
  String get criticalUpdateAvailable => 'Доступне важливе оновлення';

  @override
  String get updateAvailable => 'Доступне оновлення';

  @override
  String get ignoreUpdate => 'Ігнорувати';

  @override
  String get downloading => 'Завантаження...';

  @override
  String get cannotDeleteSharedFiles => 'Не можна видалити спільні файли';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Завантаження не може бути завершено';

  @override
  String get retry => 'Повторити';

  @override
  String get backedUpFolders => 'Резервне копіювання тек';

  @override
  String get backup => 'Резервне копіювання';

  @override
  String get freeUpDeviceSpace => 'Звільніть місце на пристрої';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Збережіть місце на вашому пристрої, очистивши файли, які вже збережено.';

  @override
  String get allClear => '✨ Все чисто';

  @override
  String get noDeviceThatCanBeDeleted =>
      'У вас не маєте файлів на цьому пристрої, які можна видалити';

  @override
  String get removeDuplicates => 'Вилучити дублікати';

  @override
  String get removeDuplicatesDesc =>
      'Перегляньте та видаліть файли, які є точними дублікатами.';

  @override
  String get viewLargeFiles => 'Великі файли';

  @override
  String get viewLargeFilesDesc =>
      'Перегляньте файли, які займають найбільше місця у сховищі.';

  @override
  String get noDuplicates => '✨ Немає дублікатів';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'You don\'t have any duplicate files that can be cleared';

  @override
  String get success => 'Успішно';

  @override
  String get rateUs => 'Оцініть нас';

  @override
  String get remindToEmptyDeviceTrash =>
      'Також очистьте «Нещодавно видалено» в «Налаштування» -> «Сховище», щоб отримати вільне місце';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Ви успішно звільнили $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Також очистьте «Смітник», щоб звільнити місце';

  @override
  String get sparkleSuccess => '✨ Успішно';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count дублікатів файлів',
      one: '$count дублікат файлу',
    );
    return 'Ви очистили $_temp0, збережено ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Сімейні тарифи';

  @override
  String get referrals => 'Реферали';

  @override
  String get notifications => 'Сповіщення';

  @override
  String get sharedPhotoNotifications => 'Нові спільні фотографії';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Отримувати сповіщення, коли хтось додасть фото до спільного альбому, в якому ви перебуваєте';

  @override
  String get advanced => 'Додатково';

  @override
  String get general => 'Загальні';

  @override
  String get security => 'Безпека';

  @override
  String get authToViewYourRecoveryKey =>
      'Авторизуйтесь для перегляду вашого ключа відновлення';

  @override
  String get twofactor => 'Двоетапна';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Авторизуйтесь, щоб налаштувати двоетапну перевірку';

  @override
  String get lockscreen => 'Екран блокування';

  @override
  String get authToChangeLockscreenSetting =>
      'Авторизуйтесь для зміни налаштувань екрана блокування';

  @override
  String get viewActiveSessions => 'Показати активні сеанси';

  @override
  String get authToViewYourActiveSessions =>
      'Авторизуйтесь, щоб переглянути активні сеанси';

  @override
  String get disableTwofactor => 'Вимкнути двоетапну перевірку';

  @override
  String get confirm2FADisable =>
      'Ви впевнені, що хочете вимкнути двоетапну перевірку?';

  @override
  String get no => 'Ні';

  @override
  String get yes => 'Так';

  @override
  String get social => 'Соцмережі';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Оцініть нас в $storeName';
  }

  @override
  String get blog => 'Блог';

  @override
  String get merchandise => 'Товари';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Не вдалося отримати деталі про ваше сховище';

  @override
  String get reportABug => 'Повідомити про помилку';

  @override
  String get reportBug => 'Повідомити про помилку';

  @override
  String get suggestFeatures => 'Запропонувати нові функції';

  @override
  String get support => 'Підтримка';

  @override
  String get theme => 'Тема';

  @override
  String get lightTheme => 'Світла';

  @override
  String get darkTheme => 'Темна';

  @override
  String get systemTheme => 'Як у системі';

  @override
  String get freeTrial => 'Безплатний пробний період';

  @override
  String get selectYourPlan => 'Оберіть тариф';

  @override
  String get enteSubscriptionPitch =>
      'Ente зберігає ваші спогади, тому вони завжди доступні для вас, навіть якщо ви втратите пристрій.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Вашу сім\'ю також можна додати до вашого тарифу.';

  @override
  String get currentUsageIs => 'Поточне використання ';

  @override
  String get faqs => 'ЧаПи';

  @override
  String renewsOn({required Object endDate}) {
    return 'Передплата поновиться $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Безплатна пробна версія діє до $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Діє до $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Ваше доповнення $storageAmount діє до $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Безплатна пробна версія діє до $endDate.\nПісля цього ви можете обрати платний план.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Вашу передплату буде скасовано $endDate';
  }

  @override
  String get subscription => 'Передплата';

  @override
  String get paymentDetails => 'Деталі платежу';

  @override
  String get manageFamily => 'Керування сім\'єю';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Зв\'яжіться з нами за адресою support@ente.io для управління вашою передплатою $provider.';
  }

  @override
  String get renewSubscription => 'Поновити передплату';

  @override
  String get cancelSubscription => 'Скасувати передплату';

  @override
  String get areYouSureYouWantToRenew => 'Ви впевнені, що хочете поновити?';

  @override
  String get yesRenew => 'Так, поновити';

  @override
  String get areYouSureYouWantToCancel => 'Ви дійсно хочете скасувати?';

  @override
  String get yesCancel => 'Так, скасувати';

  @override
  String get failedToRenew => 'Не вдалося поновити';

  @override
  String get failedToCancel => 'Не вдалося скасувати';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 місяці безплатно на щорічних планах';

  @override
  String get monthly => 'Щомісяця';

  @override
  String get yearly => 'Щороку';

  @override
  String get confirmPlanChange => 'Підтвердити зміну плану';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Ви впевнені, що хочете змінити свій план?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Ви не можете перейти до цього плану';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Спочатку скасуйте вашу передплату від $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike =>
      'Необов\'язково, так коротко, як ви хочете...';

  @override
  String get send => 'Надіслати';

  @override
  String get askCancelReason =>
      'Передплату було скасовано. Ви хотіли б поділитися причиною?';

  @override
  String get thankYouForSubscribing => 'Спасибі за передплату!';

  @override
  String get yourPurchaseWasSuccessful => 'Ваша покупка пройшла успішно';

  @override
  String get yourPlanWasSuccessfullyUpgraded => 'Ваш план успішно покращено';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Ваш план був успішно знижено';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Вашу передплату успішно оновлено';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'Передплата Play Store';

  @override
  String get appstoreSubscription => 'Передплата App Store';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Ваш $id вже пов\'язаний з іншим обліковим записом Ente.\nЯкщо ви хочете використовувати свій $id з цим обліковим записом, зверніться до нашої служби підтримки';
  }

  @override
  String get visitWebToManage =>
      'Відвідайте web.ente.io, щоб керувати передплатою';

  @override
  String get couldNotUpdateSubscription => 'Не вдалося оновити передплату';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Зв\'яжіться з support@ente.io і ми будемо раді допомогти!';

  @override
  String get paymentFailed => 'Не вдалося оплатити';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Зверніться до $providerName, якщо було знято платіж';
  }

  @override
  String get continueOnFreeTrial => 'Продовжити безплатний пробний період';

  @override
  String get areYouSureYouWantToExit => 'Ви впевнені, що хочете вийти?';

  @override
  String get thankYou => 'Дякуємо';

  @override
  String get failedToVerifyPaymentStatus =>
      'Не вдалося перевірити стан платежу';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Зачекайте деякий час перед повторною спробою';

  @override
  String get paymentFailedMessage =>
      'На жаль, ваш платіж не вдався. Зв\'яжіться зі службою підтримки і ми вам допоможемо!';

  @override
  String get youAreOnAFamilyPlan => 'Ви на сімейному плані!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Зв\'яжіться з <green>$familyAdminEmail</green> для керування вашою передплатою';
  }

  @override
  String get leaveFamily => 'Покинути сім\'ю';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Ви впевнені, що хочете залишити сімейний план?';

  @override
  String get leave => 'Покинути';

  @override
  String get rateTheApp => 'Оцініть застосунок';

  @override
  String get startBackup => 'Почати резервне копіювання';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Наразі немає резервних копій фотографій';

  @override
  String get preserveMore => 'Зберегти більше';

  @override
  String get grantFullAccessPrompt =>
      'Надайте доступ до всіх фотографій в налаштуваннях застосунку';

  @override
  String get allowPermTitle => 'Дозволити доступ до фотографій';

  @override
  String get allowPermBody =>
      'Надайте доступ до ваших фотографій з налаштувань, щоб Ente міг показувати та створювати резервну копію вашої бібліотеки.';

  @override
  String get openSettings => 'Відкрити налаштування';

  @override
  String get selectMorePhotos => 'Обрати більше фотографій';

  @override
  String get existingUser => 'Наявний користувач';

  @override
  String get privateBackups => 'Приватні резервні копії';

  @override
  String get forYourMemories => 'для ваших спогадів';

  @override
  String get endtoendEncryptedByDefault => 'Наскрізне шифрування по стандарту';

  @override
  String get safelyStored => 'Безпечне збереження';

  @override
  String get atAFalloutShelter => 'в бомбосховищі';

  @override
  String get designedToOutlive => 'Створено, щоб пережити вас';

  @override
  String get available => 'Доступно';

  @override
  String get everywhere => 'всюди';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Вебсайт, ПК';

  @override
  String get mobileWebDesktop => 'Смартфон, Вебсайт, ПК';

  @override
  String get newToEnte => 'Уперше на Ente';

  @override
  String get pleaseLoginAgain => 'Увійдіть знову';

  @override
  String get autoLogoutMessage =>
      'Через технічні збої ви вийшли з системи. Перепрошуємо за незручності.';

  @override
  String get yourSubscriptionHasExpired =>
      'Термін дії вашої передплати скінчився';

  @override
  String get storageLimitExceeded => 'Перевищено ліміт сховища';

  @override
  String get upgrade => 'Покращити';

  @override
  String get raiseTicket => 'Подати заявку';

  @override
  String get backupFailed => 'Помилка резервного копіювання';

  @override
  String get sorryBackupFailedDesc =>
      'Sorry, we could not backup this file right now, we will retry later.';

  @override
  String get couldNotBackUpTryLater =>
      'Не вдалося створити резервну копію даних.\nМи спробуємо пізніше.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente може зашифрувати та зберігати файли тільки в тому випадку, якщо ви надасте до них доступ';

  @override
  String get pleaseGrantPermissions => 'Надайте дозволи';

  @override
  String get grantPermission => 'Надати дозвіл';

  @override
  String get privateSharing => 'Приватне поширення';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Поділіться тільки з тими людьми, якими ви хочете';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Використовувати публічні посилання для людей не з Ente';

  @override
  String get allowPeopleToAddPhotos => 'Дозволити людям додавати фотографії';

  @override
  String get shareAnAlbumNow => 'Поділитися альбомом зараз';

  @override
  String get collectEventPhotos => 'Зібрати фотографії події';

  @override
  String get sessionExpired => 'Час сеансу минув';

  @override
  String get loggingOut => 'Вихід із системи...';

  @override
  String get onDevice => 'На пристрої';

  @override
  String get onEnte => 'В <branding>Ente</branding>';

  @override
  String get name => 'Назва';

  @override
  String get newest => 'Найновіші';

  @override
  String get lastUpdated => 'Востаннє оновлено';

  @override
  String get deleteEmptyAlbums => 'Видалити пусті альбоми';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Видалити пусті альбоми?';

  @override
  String get deleteAlbumsDialogBody =>
      'Це призведе до видалення всіх пустих альбомів. Це зручно, коли ви бажаєте зменшити засмічення в списку альбомів.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Видалення $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Обробка $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Остаточно видалити';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Можна створити лише посилання для файлів, що належать вам';

  @override
  String get publicLinkCreated => 'Публічне посилання створено';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Ви можете керувати посиланнями на вкладці «Поділитися».';

  @override
  String get linkCopiedToClipboard => 'Посилання скопійовано в буфер обміну';

  @override
  String get restore => 'Відновити';

  @override
  String get moveToAlbum => 'Перемістити до альбому';

  @override
  String get unhide => 'Показати';

  @override
  String get unarchive => 'Розархівувати';

  @override
  String get favorite => 'Додати до улюбленого';

  @override
  String get removeFromFavorite => 'Вилучити з улюбленого';

  @override
  String get shareLink => 'Поділитися посиланням';

  @override
  String get createCollage => 'Створити колаж';

  @override
  String get saveCollage => 'Зберегти колаж';

  @override
  String get collageSaved => 'Колаж збережено до галереї';

  @override
  String get collageLayout => 'Макет';

  @override
  String get addToEnte => 'Додати до Ente';

  @override
  String get addToAlbum => 'Додати до альбому';

  @override
  String get delete => 'Видалити';

  @override
  String get hide => 'Приховати';

  @override
  String get share => 'Поділитися';

  @override
  String get unhideToAlbum => 'Показати в альбомі';

  @override
  String get restoreToAlbum => 'Відновити в альбомі';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Move items',
      one: 'Move item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add items',
      one: 'Add item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Створити або вибрати альбом';

  @override
  String get selectAlbum => 'Обрати альбом';

  @override
  String get searchByAlbumNameHint => 'Назва альбому';

  @override
  String get albumTitle => 'Назва альбому';

  @override
  String get enterAlbumName => 'Введіть назву альбому';

  @override
  String get restoringFiles => 'Відновлюємо файли...';

  @override
  String get movingFilesToAlbum => 'Переміщуємо файли до альбому...';

  @override
  String get unhidingFilesToAlbum => 'Розкриваємо файли в альбомі';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Не можна завантажувати в альбоми, які належать іншим';

  @override
  String get uploadingFilesToAlbum => 'Завантажуємо файли до альбому...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Успішно додано до «$albumName»';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Успішно перенесено до «$albumName»';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Цей альбом вже має спільне посилання';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Створено спільне посилання для «$albumName»';
  }

  @override
  String get askYourLovedOnesToShare => 'Попросіть своїх близьких поділитися';

  @override
  String get invite => 'Запросити';

  @override
  String get shareYourFirstAlbum => 'Поділитися вашим першим альбомом';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Поділилися з $emailIDs';
  }

  @override
  String get sharedWithMe => 'Поділитися зі мною';

  @override
  String get sharedByMe => 'Поділився мною';

  @override
  String get doubleYourStorage => 'Подвоїти своє сховище';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Запросіть друзів та подвойте свій план';

  @override
  String get shareAlbumHint =>
      'Відкрийте альбом та натисніть кнопку «Поділитися» у верхньому правому куті.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Елементи показують кількість днів, що залишилися до остаточного видалення';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count днів',
      one: '1 день',
      zero: 'Незабаром',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Видалити все';

  @override
  String get renameAlbum => 'Перейменувати альбом';

  @override
  String get convertToAlbum => 'Перетворити в альбом';

  @override
  String get setCover => 'Встановити обкладинку';

  @override
  String get sortAlbumsBy => 'Сортувати за';

  @override
  String get sortNewestFirst => 'Спочатку найновіші';

  @override
  String get sortOldestFirst => 'Спочатку найстаріші';

  @override
  String get rename => 'Перейменувати';

  @override
  String get leaveSharedAlbum => 'Покинути спільний альбом?';

  @override
  String get leaveAlbum => 'Покинути альбом';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Додані вами фотографії будуть видалені з альбому';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'У цьому альбомі немає файлів, які можуть бути видалені';

  @override
  String get youDontHaveAnyArchivedItems =>
      'У вас немає жодних архівних елементів.';

  @override
  String get ignoredFolderUploadReason =>
      'Деякі файли в цьому альбомі ігноруються після вивантаження, тому що вони раніше були видалені з Ente.';

  @override
  String get resetIgnoredFiles => 'Скинути ігноровані файли';

  @override
  String get deviceFilesAutoUploading =>
      'Файли, додані до цього альбому на пристрої, автоматично завантажаться до Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Увімкніть резервну копію для автоматичного завантаження файлів, доданих до теки пристрою в Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Немає прихованих фотографій чи відео';

  @override
  String get toHideAPhotoOrVideo => 'Щоб приховати фото або відео';

  @override
  String get openTheItem => '• Відкрити елемент';

  @override
  String get clickOnTheOverflowMenu => '• Натисніть на меню переповнення';

  @override
  String get click => '• Натисніть';

  @override
  String get nothingToSeeHere => 'Тут немає на що дивитися! 👀';

  @override
  String get unarchiveAlbum => 'Розархівувати альбом';

  @override
  String get archiveAlbum => 'Архівувати альбом';

  @override
  String get calculating => 'Обчислення...';

  @override
  String get pleaseWaitDeletingAlbum => 'Зачекайте на видалення альбому';

  @override
  String get searchByExamples =>
      '• Назви альбомів (наприклад, «Камера»)\n• Типи файлів (наприклад, «Відео», «.gif»)\n• Роки та місяці (наприклад, «2022», «січень»)\n• Свята (наприклад, «Різдво»)\n• Описи фотографій (наприклад, «#fun»)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Ви можете спробувати пошукати за іншим запитом.';

  @override
  String get noResultsFound => 'Нічого не знайдено';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Додано $emailOrName';
  }

  @override
  String get loadingExifData => 'Завантаження даних EXIF...';

  @override
  String get viewAllExifData => 'Переглянути всі дані EXIF';

  @override
  String get noExifData => 'Немає даних EXIF';

  @override
  String get thisImageHasNoExifData => 'Це зображення не має даних exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Немає результатів';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Ми не підтримуємо редагування фотографій та альбомів, якими ви ще не володієте';

  @override
  String get failedToFetchOriginalForEdit =>
      'Не вдалося отримати оригінал для редагування';

  @override
  String get close => 'Закрити';

  @override
  String get setAs => 'Встановити як';

  @override
  String get fileSavedToGallery => 'Файл збережено до галереї';

  @override
  String get filesSavedToGallery => 'Файли збережено до галереї';

  @override
  String get fileFailedToSaveToGallery => 'Не вдалося зберегти файл до галереї';

  @override
  String get download => 'Завантажити';

  @override
  String get pressAndHoldToPlayVideo =>
      'Натисніть та утримуйте, щоб відтворити відео';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Натисніть та утримуйте на зображення, щоби відтворити відео';

  @override
  String get downloadFailed => 'Не вдалося завантажити';

  @override
  String get deduplicateFiles => 'Усунути дублікати файлів';

  @override
  String get deselectAll => 'Зняти виділення';

  @override
  String get reviewDeduplicateItems =>
      'Перегляньте та видаліть елементи, які, на вашу думку, є дублікатами.';

  @override
  String get clubByCaptureTime => 'Клуб за часом захоплення';

  @override
  String get clubByFileName => 'Клуб за назвою файлу';

  @override
  String get count => 'Кількість';

  @override
  String get totalSize => 'Загальний розмір';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Натисніть і утримуйте елемент для перегляду в повноекранному режимі';

  @override
  String get decryptingVideo => 'Розшифрування відео...';

  @override
  String get authToViewYourMemories =>
      'Авторизуйтеся, щоб переглянути ваші спогади';

  @override
  String get unlock => 'Розблокувати';

  @override
  String get freeUpSpace => 'Звільнити місце';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They can be deleted from the device to free up $formattedSize',
      one: 'It can be deleted from the device to free up $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Для $formattedNumber файлів',
      one: 'Для 1 файлу',
    );
    return '$_temp0 у цьому альбомі було створено резервну копію';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Для $formattedNumber файлів',
      one: 'Для 1 файлу',
    );
    return '$_temp0 на цьому пристрої було створено резервну копію';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Звільніть $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Ця поштова адреса вже використовується';

  @override
  String get incorrectCode => 'Невірний код';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Автентифікація не пройдена. Спробуйте ще раз';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Перевірка не вдалася, спробуйте ще раз';

  @override
  String get authenticating => 'Автентифікація...';

  @override
  String get authenticationSuccessful => 'Автентифікація пройшла успішно!';

  @override
  String get incorrectRecoveryKey => 'Невірний ключ відновлення';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Ви ввели невірний ключ відновлення';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Двоетапну перевірку успішно скинуто';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered => 'Підтвердьте введений код';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Зверніться до служби підтримки, якщо проблема не зникне';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Двоетапну перевірку вимкнено';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Вибачте, але введений вами код є невірним';

  @override
  String get yourVerificationCodeHasExpired =>
      'Термін дії коду підтвердження минув';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Поштову адресу змінено на $newEmail';
  }

  @override
  String get verifying => 'Перевіряємо...';

  @override
  String get disablingTwofactorAuthentication =>
      'Вимкнення двоетапної перевірки...';

  @override
  String get allMemoriesPreserved => 'Всі спогади збережені';

  @override
  String get loadingGallery => 'Завантаження галереї...';

  @override
  String get syncing => 'Синхронізуємо...';

  @override
  String get encryptingBackup => 'Шифруємо резервну копію...';

  @override
  String get syncStopped => 'Синхронізацію зупинено';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed / $total спогадів збережено';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Збереження $count спогадів...';
  }

  @override
  String get uploadingSingleMemory => 'Зберігаємо 1 спогад...';

  @override
  String get archiving => 'Архівуємо...';

  @override
  String get unarchiving => 'Розархівуємо...';

  @override
  String get successfullyArchived => 'Успішно архівовано';

  @override
  String get successfullyUnarchived => 'Успішно розархівовано';

  @override
  String get renameFile => 'Перейменувати файл';

  @override
  String get enterFileName => 'Введіть назву файлу';

  @override
  String get filesDeleted => 'Файли видалено';

  @override
  String get selectedFilesAreNotOnEnte => 'Обрані файли не на Ente';

  @override
  String get thisActionCannotBeUndone => 'Цю дію не можна буде скасувати';

  @override
  String get emptyTrash => 'Очистити смітник?';

  @override
  String get permDeleteWarning =>
      'Усі елементи смітника будуть остаточно видалені\n\nЦю дію не можна скасувати';

  @override
  String get empty => 'Спорожнити';

  @override
  String get couldNotFreeUpSpace => 'Не вдалося звільнити місце';

  @override
  String get permanentlyDeleteFromDevice => 'Остаточно видалити з пристрою?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Деякі файли, які ви намагаєтеся видалити, доступні лише на вашому пристрої, і їх неможливо відновити';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Вони будуть видалені з усіх альбомів.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Деякі елементи знаходяться на Ente та вашому пристрої.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Обрані елементи будуть видалені з усіх альбомів і переміщені в смітник.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Ці елементи будуть видалені з пристрою.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Схоже, що щось пішло не так. Спробуйте ще раз через деякий час. Якщо помилка не зникне, зв\'яжіться з нашою командою підтримки.';

  @override
  String get error => 'Помилка';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Схоже, що щось пішло не так. Спробуйте ще раз через деякий час. Якщо помилка не зникне, зв\'яжіться з нашою командою підтримки.';

  @override
  String get networkHostLookUpErr =>
      'Не вдалося під\'єднатися до Ente. Перевірте налаштування мережі. Зверніться до нашої команди підтримки, якщо помилка залишиться.';

  @override
  String get networkConnectionRefusedErr =>
      'Не вдалося під\'єднатися до Ente. Спробуйте ще раз через деякий час. Якщо помилка не зникне, зв\'яжіться з нашою командою підтримки.';

  @override
  String get cachedData => 'Кешовані дані';

  @override
  String get clearCaches => 'Очистити кеш';

  @override
  String get remoteImages => 'Віддалені зображення';

  @override
  String get remoteVideos => 'Віддалені відео';

  @override
  String get remoteThumbnails => 'Віддалені мініатюри';

  @override
  String get pendingSync => 'Очікування синхронізації';

  @override
  String get localGallery => 'Локальна галерея';

  @override
  String get todaysLogs => 'Сьогоднішні журнали';

  @override
  String get viewLogs => 'Переглянути журнали';

  @override
  String get logsDialogBody =>
      'Це призведе до надсилання журналів, які допоможуть нам усунути вашу проблему. Зверніть увагу, що назви файлів будуть включені, щоби допомогти відстежувати проблеми з конкретними файлами.';

  @override
  String get preparingLogs => 'Підготовка журналів...';

  @override
  String get emailYourLogs => 'Відправте ваші журнали поштою';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Надішліть журнали на \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Копіювати поштову адресу';

  @override
  String get exportLogs => 'Експортування журналів';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Напишіть нам на $toEmail';
  }

  @override
  String get dismiss => 'Відхилити';

  @override
  String get didYouKnow => 'Чи знали ви?';

  @override
  String get loadingMessage => 'Завантажуємо ваші фотографії...';

  @override
  String get loadMessage1 => 'Ви можете поділитися своєю передплатою з родиною';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'Ми зберігаємо 3 копії ваших даних, одну в підземному бункері';

  @override
  String get loadMessage4 => 'Всі наші застосунки мають відкритий код';

  @override
  String get loadMessage5 =>
      'Наш вихідний код та шифрування пройшли перевірку спільнотою';

  @override
  String get loadMessage6 =>
      'Ви можете поділитися посиланнями на свої альбоми з близькими';

  @override
  String get loadMessage7 =>
      'Наші мобільні застосунки працюють у фоновому режимі для шифрування і створення резервних копій будь-яких нових фотографій, які ви виберете';

  @override
  String get loadMessage8 => 'web.ente.io має зручний завантажувач';

  @override
  String get loadMessage9 =>
      'Ми використовуємо Xchacha20Poly1305 для безпечного шифрування ваших даних';

  @override
  String get photoDescriptions => 'Опис фотографії';

  @override
  String get fileTypesAndNames => 'Типи та назви файлів';

  @override
  String get location => 'Розташування';

  @override
  String get moments => 'Моменти';

  @override
  String get searchFaceEmptySection =>
      'Люди будуть показані тут після завершення індексації';

  @override
  String get searchDatesEmptySection => 'Шукати за датою, місяцем або роком';

  @override
  String get searchLocationEmptySection =>
      'Групові фотографії, які зроблені в певному радіусі від фотографії';

  @override
  String get searchPeopleEmptySection =>
      'Запросіть людей, і ви побачите всі фотографії, якими вони поділилися, тут';

  @override
  String get searchAlbumsEmptySection => 'Альбоми';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Типи та назви файлів';

  @override
  String get searchCaptionEmptySection =>
      'Додавайте такі описи як «#подорож» в інформацію про фотографію, щоб швидко знайти їх тут';

  @override
  String get language => 'Мова';

  @override
  String get selectLanguage => 'Оберіть мову';

  @override
  String get locationName => 'Назва місце розташування';

  @override
  String get addLocation => 'Додати розташування';

  @override
  String get groupNearbyPhotos => 'Групувати фотографії поблизу';

  @override
  String get kiloMeterUnit => 'км';

  @override
  String get addLocationButton => 'Додати';

  @override
  String get radius => 'Радіус';

  @override
  String get locationTagFeatureDescription =>
      'Тег розташування групує всі фотографії, які були зроблені в певному радіусі від фотографії';

  @override
  String get galleryMemoryLimitInfo => 'До 1000 спогадів, показаних у галереї';

  @override
  String get save => 'Зберегти';

  @override
  String get centerPoint => 'Центральна точка';

  @override
  String get pickCenterPoint => 'Вкажіть центральну точку';

  @override
  String get useSelectedPhoto => 'Використати обране фото';

  @override
  String get resetToDefault => 'Скинути до типових';

  @override
  String get edit => 'Редагувати';

  @override
  String get deleteLocation => 'Видалити розташування';

  @override
  String get rotateLeft => 'Повернути ліворуч';

  @override
  String get flip => 'Відзеркалити';

  @override
  String get rotateRight => 'Повернути праворуч';

  @override
  String get saveCopy => 'Зберегти копію';

  @override
  String get light => 'Яскравість';

  @override
  String get color => 'Колір';

  @override
  String get yesDiscardChanges => 'Так, відхилити зміни';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Ви хочете відхилити внесені зміни?';

  @override
  String get saving => 'Зберігаємо...';

  @override
  String get editsSaved => 'Зміни збережено';

  @override
  String get oopsCouldNotSaveEdits => 'Ой, не вдалося зберегти зміни';

  @override
  String get distanceInKMUnit => 'км';

  @override
  String get dayToday => 'Сьогодні';

  @override
  String get dayYesterday => 'Вчора';

  @override
  String get storage => 'Сховище';

  @override
  String get usedSpace => 'Використано місця';

  @override
  String get storageBreakupFamily => 'Сім\'я';

  @override
  String get storageBreakupYou => 'Ви';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit з $totalAmount $totalStorageUnit використано';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit вільно';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Версія: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Підтвердження';

  @override
  String get fileInfoAddDescHint => 'Додати опис...';

  @override
  String get editLocationTagTitle => 'Змінити розташування';

  @override
  String get setLabel => 'Установити';

  @override
  String get setRadius => 'Встановити радіус';

  @override
  String get familyPlanPortalTitle => 'Сім\'я';

  @override
  String get familyPlanOverview =>
      'Додайте 5 членів сім\'ї до чинного тарифу без додаткової плати.\n\nКожен член сім\'ї отримає власний приватний простір і не зможе бачити файли інших, доки обидва не нададуть до них спільний доступ.\n\nСімейні плани доступні клієнтам, які мають платну підписку на Ente.\n\nПідпишіться зараз, щоби розпочати!';

  @override
  String get androidBiometricHint => 'Підтвердження особистості';

  @override
  String get androidBiometricNotRecognized =>
      'Не розпізнано. Спробуйте ще раз.';

  @override
  String get androidBiometricSuccess => 'Успішно';

  @override
  String get androidCancelButton => 'Скасувати';

  @override
  String get androidSignInTitle => 'Необхідна перевірка';

  @override
  String get androidBiometricRequiredTitle => 'Потрібна біометрія';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Необхідні облікові дані пристрою';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Необхідні облікові дані пристрою';

  @override
  String get goToSettings => 'Перейти до налаштувань';

  @override
  String get androidGoToSettingsDescription =>
      'Біометрична перевірка не встановлена на вашому пристрої. Перейдіть в «Налаштування > Безпека», щоб додати біометричну перевірку.';

  @override
  String get iOSLockOut =>
      'Біометрична перевірка вимкнена. Заблокуйте і розблокуйте свій екран, щоб увімкнути її.';

  @override
  String get iOSGoToSettingsDescription =>
      'Біометрична перевірка не встановлена на вашому пристрої. Увімкніть TouchID або FaceID на вашому телефоні.';

  @override
  String get iOSOkButton => 'Гаразд';

  @override
  String get openstreetmapContributors => 'Учасники OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Розміщення на OSM Франція';

  @override
  String get map => 'Мапа';

  @override
  String get maps => 'Мапи';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Увімкнути мапи';

  @override
  String get quickLinks => 'Швидкі посилання';

  @override
  String get selectItemsToAdd => 'Виберіть елементи для додавання';

  @override
  String get addSelected => 'Додати вибране';

  @override
  String get addFromDevice => 'Додати з пристрою';

  @override
  String get addPhotos => 'Додати фотографії';

  @override
  String get noPhotosFoundHere => 'Тут немає фотографій';

  @override
  String get zoomOutToSeePhotos => 'Збільште, щоб побачити фотографії';

  @override
  String get noImagesWithLocation => 'Немає зображень з розташуванням';

  @override
  String get unpinAlbum => 'Відкріпити альбом';

  @override
  String get pinAlbum => 'Закріпити альбом';

  @override
  String get pin => 'Закріпити';

  @override
  String get pinPerson => 'Закріпити особу';

  @override
  String get pinToTop => 'Закріпити вгорі';

  @override
  String get unpin => 'Відкріпити';

  @override
  String get unpinPerson => 'Відкріпити особу';

  @override
  String get visibility => 'Видимість';

  @override
  String get hideFromMemories => 'Приховати у спогадах';

  @override
  String get showInMemories => 'Показати у спогадах';

  @override
  String get create => 'Створити';

  @override
  String get viewAll => 'Переглянути все';

  @override
  String get nothingSharedWithYouYet => 'Поки що з вами ніхто не поділився';

  @override
  String get noAlbumsSharedByYouYet => 'Ви ще не поділилися жодним альбомом';

  @override
  String get sharedWithYou => 'Поділилися з вами';

  @override
  String get sharedByYou => 'Поділилися вами';

  @override
  String get inviteYourFriendsToEnte => 'Запросіть своїх друзів до Ente';

  @override
  String get failedToDownloadVideo => 'Не вдалося завантажити відео';

  @override
  String get hiding => 'Приховуємо...';

  @override
  String get unhiding => 'Показуємо...';

  @override
  String get successfullyHid => 'Успішно приховано';

  @override
  String get successfullyUnhid => 'Успішно показано';

  @override
  String get crashReporting => 'Звіти про помилки';

  @override
  String get resumableUploads => 'Завантаження з можливістю відновлення';

  @override
  String get addToHiddenAlbum => 'Додати до прихованого альбому';

  @override
  String get moveToHiddenAlbum => 'Перемістити до прихованого альбому';

  @override
  String get fileTypes => 'Типи файлів';

  @override
  String get deleteConfirmDialogBody =>
      'Цей обліковий запис пов\'язаний з іншими застосунками Ente, якщо ви ними користуєтесь. Завантажені вами дані з усіх застосунків Ente будуть заплановані до видалення, а ваш обліковий запис буде видалено назавжди.';

  @override
  String get hearUsWhereTitle => 'Як ви дізналися про Ente? (необов\'язково)';

  @override
  String get hearUsExplanation =>
      'Ми не відстежуємо встановлення застосунку. Але, якщо ви скажете нам, де ви нас знайшли, це допоможе!';

  @override
  String get viewAddOnButton => 'Переглянути доповнення';

  @override
  String get addOns => 'Доповнення';

  @override
  String get addOnPageSubtitle => 'Подробиці доповнень';

  @override
  String get yourMap => 'Ваша мапа';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Змініть ваш запит або спробуйте знайти';

  @override
  String get blackFridaySale => 'Розпродаж у «Чорну п\'ятницю»';

  @override
  String get upto50OffUntil4thDec => 'Знижки до 50%, до 4 грудня.';

  @override
  String get photos => 'Фото';

  @override
  String get videos => 'Відео';

  @override
  String get livePhotos => 'Живі фото';

  @override
  String get searchHint1 => 'Швидкий пошук на пристрої';

  @override
  String get searchHint2 => 'Дати, описи фото';

  @override
  String get searchHint3 => 'Альбоми, назви та типи файлів';

  @override
  String get searchHint4 => 'Розташування';

  @override
  String get searchHint5 => 'Незабаром: Обличчя і магічний пошук ✨';

  @override
  String get addYourPhotosNow => 'Додайте свої фотографії';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Знайдено $count результати',
      many: 'Знайдено $count результатів',
      few: 'Знайдено $count результати',
      one: 'Знайдено $count результат',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Обличчя';

  @override
  String get people => 'Люди';

  @override
  String get contents => 'Вміст';

  @override
  String get addNew => 'Додати нове';

  @override
  String get contacts => 'Контакти';

  @override
  String get noInternetConnection => 'Немає з’єднання з мережею';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Перевірте з\'єднання з мережею та спробуйте ще раз.';

  @override
  String get signOutFromOtherDevices => 'Вийти на інших пристроях';

  @override
  String get signOutOtherBody =>
      'Якщо ви думаєте, що хтось може знати ваш пароль, ви можете примусити всі інші пристрої, які використовують ваш обліковий запис, вийти із системи.';

  @override
  String get signOutOtherDevices => 'Вийти на інших пристроях';

  @override
  String get doNotSignOut => 'Не виходити';

  @override
  String get editLocation => 'Змінити розташування';

  @override
  String get selectALocation => 'Оберіть розташування';

  @override
  String get selectALocationFirst => 'Спочатку оберіть розташування';

  @override
  String get changeLocationOfSelectedItems =>
      'Змінити розташування вибраних елементів?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Зміна розташування буде видима лише в Ente';

  @override
  String get cleanUncategorized => 'Очистити «Без категорії»';

  @override
  String get cleanUncategorizedDescription =>
      'Видалити всі файли з «Без категорії», що є в інших альбомах';

  @override
  String get waitingForVerification => 'Очікується підтвердження...';

  @override
  String get passkey => 'Ключ доступу';

  @override
  String get passkeyAuthTitle => 'Перевірка через ключ доступу';

  @override
  String get loginWithTOTP => 'Увійти за допомогою TOTP';

  @override
  String get passKeyPendingVerification => 'Перевірка все ще триває';

  @override
  String get loginSessionExpired => 'Час сеансу минув';

  @override
  String get loginSessionExpiredDetails =>
      'Термін дії вашого сеансу завершився. Увійдіть знову.';

  @override
  String get verifyPasskey => 'Підтвердити ключ доступу';

  @override
  String get playOnTv => 'Відтворити альбом на ТБ';

  @override
  String get pair => 'Створити пару';

  @override
  String get deviceNotFound => 'Пристрій не знайдено';

  @override
  String get castInstruction =>
      'Відвідайте cast.ente.io на пристрої, з яким ви хочете створити пару.\n\nВведіть код нижче, щоб відтворити альбом на телевізорі.';

  @override
  String get deviceCodeHint => 'Введіть код';

  @override
  String get joinDiscord => 'Приєднатися до Discord';

  @override
  String get locations => 'Розташування';

  @override
  String get addAName => 'Додати ім\'я';

  @override
  String get findThemQuickly => 'Знайдіть їх швидко';

  @override
  String get findPeopleByName => 'Швидко знаходьте людей за іменами';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Довго утримуйте поштову адресу, щоб перевірити наскрізне шифрування.';

  @override
  String get developerSettingsWarning =>
      'Ви впевнені, що хочете змінити налаштування для розробників?';

  @override
  String get developerSettings => 'Налаштування для розробників';

  @override
  String get serverEndpoint => 'Кінцева точка сервера';

  @override
  String get invalidEndpoint => 'Недійсна кінцева точка';

  @override
  String get invalidEndpointMessage =>
      'Введена вами кінцева точка є недійсною. Введіть дійсну кінцеву точку та спробуйте ще раз.';

  @override
  String get endpointUpdatedMessage => 'Кінцева точка успішно оновлена';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Під\'єднано до $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Створити спільне посилання';

  @override
  String get search => 'Пошук';

  @override
  String get enterPersonName => 'Введіть ім\'я особи';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Введіть ім\'я';

  @override
  String get savePerson => 'Зберегти особу';

  @override
  String get editPerson => 'Редагувати особу';

  @override
  String get mergedPhotos => 'Об\'єднані фотографії';

  @override
  String get orMergeWithExistingPerson => 'Або об\'єднати з наявними';

  @override
  String get enterDateOfBirth => 'День народження (необов\'язково)';

  @override
  String get birthday => 'День народження';

  @override
  String get removePersonLabel => 'Видалити мітку особи';

  @override
  String get removePersonTag => 'Видалити мітку особи';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'Автоматичне створення пари працює лише з пристроями, що підтримують Chromecast.';

  @override
  String get manualPairDesc =>
      'Створення пари з PIN-кодом працює з будь-яким екраном, на яку ви хочете переглянути альбом.';

  @override
  String get connectToDevice => 'Під\'єднатися до пристрою';

  @override
  String get autoCastDialogBody =>
      'Тут ви побачите доступні пристрої для трансляції.';

  @override
  String get autoCastiOSPermission =>
      'Переконайтеся, що дозволи локальної мережі увімкнені для застосунку «Ente Photos» у налаштуваннях.';

  @override
  String get noDeviceFound => 'Не знайдено жодного пристрою';

  @override
  String get stopCastingTitle => 'Припинити трансляцію';

  @override
  String get stopCastingBody => 'Ви хочете припинити трансляцію?';

  @override
  String get castIPMismatchTitle => 'Не вдалося транслювати альбом';

  @override
  String get castIPMismatchBody =>
      'Переконайтеся, що ви перебуваєте в тій же мережі, що і телевізор.';

  @override
  String get pairingComplete => 'Створення пари завершено';

  @override
  String get savingEdits => 'Зберігаємо зміни...';

  @override
  String get autoPair => 'Автоматичне створення пари';

  @override
  String get pairWithPin => 'Під’єднатися через PIN-код';

  @override
  String get faceRecognition => 'Розпізнавання обличчя';

  @override
  String get foundFaces => 'Знайдені обличчя';

  @override
  String get clusteringProgress => 'Прогрес кластеризації';

  @override
  String get trim => 'Вирізати';

  @override
  String get crop => 'Обрізати';

  @override
  String get rotate => 'Обернути';

  @override
  String get left => 'Ліворуч';

  @override
  String get right => 'Праворуч';

  @override
  String get whatsNew => 'Що нового';

  @override
  String get reviewSuggestions => 'Переглянути пропозиції';

  @override
  String get review => 'Оцінити';

  @override
  String get useAsCover => 'Використати як обкладинку';

  @override
  String notPersonLabel({required String name}) {
    return 'Не $name?';
  }

  @override
  String get enable => 'Увімкнути';

  @override
  String get enabled => 'Увімкнено';

  @override
  String get moreDetails => 'Детальніше';

  @override
  String get enableMLIndexingDesc =>
      'Ente підтримує машинне навчання для розпізнавання обличчя, магічний пошук та інші розширені функції пошуку';

  @override
  String get magicSearchHint =>
      'Магічний пошук дозволяє шукати фотографії за їхнім вмістом, наприклад «квітка», «червоне авто» «паспорт»';

  @override
  String get panorama => 'Панорама';

  @override
  String get reenterPassword => 'Введіть пароль ще раз';

  @override
  String get reenterPin => 'Введіть PIN-код ще раз';

  @override
  String get deviceLock => 'Блокування пристрою';

  @override
  String get pinLock => 'Блокування PIN-кодом';

  @override
  String get next => 'Далі';

  @override
  String get setNewPassword => 'Встановити новий пароль';

  @override
  String get enterPin => 'Введіть PIN-код';

  @override
  String get setNewPin => 'Встановити новий PIN-код';

  @override
  String get appLock => 'Блокування застосунку';

  @override
  String get noSystemLockFound => 'Не знайдено системного блокування';

  @override
  String get tapToUnlock => 'Торкніться, щоби розблокувати';

  @override
  String get tooManyIncorrectAttempts => 'Завелика кількість невірних спроб';

  @override
  String get videoInfo => 'Інформація про відео';

  @override
  String get autoLock => 'Автоблокування';

  @override
  String get immediately => 'Негайно';

  @override
  String get autoLockFeatureDescription =>
      'Час, через який застосунок буде заблоковано у фоновому режимі';

  @override
  String get hideContent => 'Приховати вміст';

  @override
  String get hideContentDescriptionAndroid =>
      'Приховує вміст застосунку у перемикачі застосунків і вимикає знімки екрана';

  @override
  String get hideContentDescriptionIos =>
      'Приховує вміст застосунку у перемикачі застосунків';

  @override
  String get passwordStrengthInfo =>
      'Надійність пароля розраховується з урахуванням довжини пароля, використаних символів, а також того, чи входить пароль у топ 10 000 найбільш використовуваних паролів';

  @override
  String get noQuickLinksSelected => 'Не вибрано швидких посилань';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Оберіть посилання для видалення';

  @override
  String get removePublicLinks => 'Видалити публічні посилання';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Це видалить публічні посилання з усіх вибраних швидких посилань.';

  @override
  String get guestView => 'Гостьовий перегляд';

  @override
  String get guestViewEnablePreSteps =>
      'Щоб увімкнути гостьовий перегляд, встановіть пароль або блокування екрана в налаштуваннях системи.';

  @override
  String get nameTheAlbum => 'Назвіть альбом';

  @override
  String get collectPhotosDescription =>
      'Створіть посилання, за яким ваші друзі зможуть завантажувати фотографії в оригінальній якості.';

  @override
  String get collect => 'Зібрати';

  @override
  String get appLockDescriptions =>
      'Виберіть між типовим екраном блокування вашого пристрою та власним екраном блокування з PIN-кодом або паролем.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Для увімкнення блокування застосунку, налаштуйте пароль пристрою або блокування екрана в системних налаштуваннях.';

  @override
  String get authToViewPasskey =>
      'Авторизуйтесь, щоб переглянути свій ключ доступу';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Схоже, щось пішло не так, оскільки локальна синхронізація фотографій займає більше часу, ніж очікувалося. Зверніться до нашої служби підтримки';

  @override
  String get showPerson => 'Показати особу';

  @override
  String get sort => 'Сортувати';

  @override
  String get mostRecent => 'Останні';

  @override
  String get mostRelevant => 'Найактуальніші';

  @override
  String get loadingYourPhotos => 'Завантажуємо фотографії...';

  @override
  String processingImport({required Object folderName}) {
    return 'Оброблюємо «$folderName»...';
  }

  @override
  String get personName => 'Ім\'я особи';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Додати нову особу';

  @override
  String get addNameOrMerge => 'Додати назву або об\'єднати';

  @override
  String get mergeWithExisting => 'Об\'єднати з наявним';

  @override
  String get newPerson => 'Нова особа';

  @override
  String get addName => 'Додати ім\'я';

  @override
  String get add => 'Додати';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Знайдено додаткові фотографії для $text';
  }

  @override
  String get extraPhotosFound => 'Знайдено додаткові фотографії';

  @override
  String get configuration => 'Налаштування';

  @override
  String get localIndexing => 'Локальне індексування';

  @override
  String get processed => 'Оброблено';

  @override
  String get resetPerson => 'Вилучити';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Ви впевнені, що хочете скинути цю особу?';

  @override
  String get allPersonGroupingWillReset =>
      'Усі групи для цієї особи будуть скинуті, і ви втратите всі пропозиції, зроблені для неї';

  @override
  String get yesResetPerson => 'Так, скинути особу';

  @override
  String get onlyThem => 'Тільки вони';

  @override
  String get checkingModels => 'Перевірка моделей...';

  @override
  String get enableMachineLearningBanner =>
      'Увімкніть машинне навчання для магічного пошуку та розпізнавання облич';

  @override
  String get searchDiscoverEmptySection =>
      'Зображення будуть показані тут після завершення оброблення та синхронізації';

  @override
  String get searchPersonsEmptySection =>
      'Люди будуть показані тут після завершення оброблення та синхронізації';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count collaborators',
      one: 'Added 1 collaborator',
      zero: 'Added 0 collaborator',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Обліковий запис уже налаштовано.';

  @override
  String get sessionIdMismatch => 'Невідповідність ідентифікатора сеансу';

  @override
  String get failedToFetchActiveSessions =>
      'Не вдалося отримати активні сеанси';

  @override
  String get failedToRefreshStripeSubscription =>
      'Не вдалося поновити підписку';

  @override
  String get failedToPlayVideo => 'Не вдалося відтворити відео';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Завантаження проігноровано через: $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Тип галереї «$galleryType» не підтримується для перейменування';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Натисніть, щоб завантажити; завантаження наразі ігнорується через: $ignoreReason';
  }

  @override
  String get tapToUpload => 'Натисніть, щоб завантажити';

  @override
  String get info => 'Інформація';

  @override
  String get addFiles => 'Додати файли';

  @override
  String get castAlbum => 'Транслювати альбом';

  @override
  String get imageNotAnalyzed => 'Зображення не проаналізовано';

  @override
  String get noFacesFound => 'Обличчя не знайдено';

  @override
  String get fileNotUploadedYet => 'Файл ще не завантажено';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Немає пропозицій для $personName';
  }

  @override
  String get month => 'місяць';

  @override
  String get yearShort => 'рік';

  @override
  String get currentlyRunning => 'зараз працює';

  @override
  String get ignored => 'ігнорується';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Файл';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Невідповідність довжини розділів: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Вибрати застосунок пошти';

  @override
  String get selectAllShort => 'Усі';

  @override
  String get selectCoverPhoto => 'Обрати обкладинку';

  @override
  String get newLocation => 'Нове розташування';

  @override
  String get faceNotClusteredYet =>
      'Обличчя ще не згруповані, поверніться пізніше';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Термін дії посилання, за яким ви намагаєтеся отримати доступ, закінчився.';

  @override
  String get openFile => 'Відкрити файл';

  @override
  String get backupFile => 'Файл резервної копії';

  @override
  String get openAlbumInBrowser => 'Відкрити альбом у браузері';

  @override
  String get openAlbumInBrowserTitle =>
      'Використовуйте вебзастосунок, щоби додавати фотографії до цього альбому';

  @override
  String get allow => 'Дозволити';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Дозволити застосунку відкривати спільні альбоми';

  @override
  String get seePublicAlbumLinksInApp =>
      'Посилання на публічні альбоми в застосунку';

  @override
  String get emergencyContacts => 'Екстрені контакти';

  @override
  String get acceptTrustInvite => 'Прийняти запрошення';

  @override
  String get declineTrustInvite => 'Відхилити запрошення';

  @override
  String get removeYourselfAsTrustedContact =>
      'Видалити себе як довірений контакт';

  @override
  String get legacy => 'Спадок';

  @override
  String get legacyPageDesc =>
      '«Спадок» дозволяє довіреним контактам отримати доступ до вашого облікового запису під час вашої відсутності.';

  @override
  String get legacyPageDesc2 =>
      'Довірені контакти можуть ініціювати відновлення облікового запису, і якщо його не буде заблоковано протягом 30 днів, скинути пароль і отримати доступ до нього.';

  @override
  String get legacyAccounts => 'Облікові записи «Спадку»';

  @override
  String get trustedContacts => 'Довірені контакти';

  @override
  String get addTrustedContact => 'Додати довірений контакт';

  @override
  String get removeInvite => 'Видалити запрошення';

  @override
  String get recoveryWarning =>
      'Довірений контакт намагається отримати доступ до вашого облікового запису';

  @override
  String get rejectRecovery => 'Відхилити відновлення';

  @override
  String get recoveryInitiated => 'Почато відновлення';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Ви зможете отримати доступ до облікового запису через $days днів. Повідомлення буде надіслано на $email.';
  }

  @override
  String get cancelAccountRecovery => 'Скасувати відновлення';

  @override
  String get recoveryAccount => 'Відновити обліковий запис';

  @override
  String get cancelAccountRecoveryBody =>
      'Ви впевнені, що хочете скасувати відновлення?';

  @override
  String get startAccountRecoveryTitle => 'Почати відновлення';

  @override
  String get whyAddTrustContact =>
      'Довірений контакт може допомогти у відновленні ваших даних.';

  @override
  String recoveryReady({required String email}) {
    return 'Тепер ви можете відновити обліковий запис $email, встановивши новий пароль.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email намагається відновити ваш обліковий запис.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Ви отримали запрошення стати спадковим контактом від $email.';
  }

  @override
  String get warning => 'Увага';

  @override
  String get proceed => 'Продовжити';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Ви збираєтеся додати $email як довірений контакт. Вони зможуть відновити ваш обліковий запис, якщо ви будете відсутні протягом $numOfDays днів.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email запросив вас стати довіреною особою';
  }

  @override
  String get authToManageLegacy =>
      'Авторизуйтесь, щоби керувати довіреними контактами';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Hide shared items from home gallery';

  @override
  String get swipeToSelect => 'Проведіть пальцем, щоб обрати';

  @override
  String get gallery => 'Галерея';

  @override
  String get joinAlbum => 'Приєднатися до альбому';

  @override
  String get joinAlbumSubtext => 'to view and add your photos';

  @override
  String get joinAlbumSubtextViewer => 'to add this to shared albums';

  @override
  String get join => 'Приєднатися';

  @override
  String get linkEmail => 'Прив\'язати електронну пошту';

  @override
  String get link => 'Прив\'язати';

  @override
  String get noEnteAccountExclamation => 'Відсутній обліковий запис Ente!';

  @override
  String get orPickFromYourContacts => 'або виберіть зі своїх контактів';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email does not have an Ente account.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Я)';
  }

  @override
  String get reassignMe => 'Перепризначити «Мене»';

  @override
  String get me => 'Я';

  @override
  String get linkEmailToContactBannerCaption => 'for faster sharing';

  @override
  String get selectPersonToLink => 'Select person to link';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Link person to $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'This will link $personName to $email';
  }

  @override
  String get selectYourFace => 'Оберіть своє обличчя';

  @override
  String get reassigningLoading => 'Перепризначення...';

  @override
  String reassignedToName({required String name}) {
    return 'Вас перепризначено на $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Зберегти зміни перед виходом?';

  @override
  String get dontSave => 'Не зберігати';

  @override
  String get thisIsMeExclamation => 'Це я!';

  @override
  String get linkPerson => 'Прив\'язати особу';

  @override
  String get linkPersonCaption => 'for better sharing experience';

  @override
  String get videoStreaming => 'Streamable videos';

  @override
  String get processingVideos => 'Processing videos';

  @override
  String get streamDetails => 'Деталі потоку';

  @override
  String get processing => 'Обробка';

  @override
  String get queued => 'У черзі';

  @override
  String get ineligible => 'Ineligible';

  @override
  String get failed => 'Збій';

  @override
  String get playStream => 'Відтворити потік';

  @override
  String get playOriginal => 'Відтворити оригінал';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Joining an album will make your email visible to its participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Please wait, this will take a while.';

  @override
  String get editTime => 'Редагувати час';

  @override
  String get selectTime => 'Обрати час';

  @override
  String get selectDate => 'Обрати дату';

  @override
  String get previous => 'Попередній';

  @override
  String get selectOneDateAndTimeForAll => 'Оберіть одну дату і час для всіх';

  @override
  String get selectStartOfRange => 'Оберіть початок діапазону';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'This will make the date and time of all selected photos the same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'This is the first in the group. Other selected photos will automatically shift based on this new date';

  @override
  String get newRange => 'Новий діапазон';

  @override
  String get selectOneDateAndTime => 'Оберіть одну дату і час';

  @override
  String get moveSelectedPhotosToOneDate => 'Move selected photos to one date';

  @override
  String get shiftDatesAndTime => 'Shift dates and time';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Photos keep relative time difference';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Іконка застосунку';

  @override
  String get notThisPerson => 'Не ця особа?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Selected items will be removed from this person, but not deleted from your library.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat through the years';
  }

  @override
  String get thisWeekThroughTheYears => 'This week through the years';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'This week, $count years ago',
      one: 'This week, $count year ago',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Ви та $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admiring $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embracing $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Вечірка з $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Похід з $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feasting with $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Селфі з $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Позуючи з $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Чудові краєвиди з $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Спорт з $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Road trip with $name';
  }

  @override
  String get spotlightOnYourself => 'Spotlight on yourself';

  @override
  String spotlightOnThem({required Object name}) {
    return 'У центрі уваги $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name виповнилося $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name невдовзі виповниться $age';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Last time with $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Подорож у $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Подорож у $year';
  }

  @override
  String get lastYearsTrip => 'Тогорічна подорож';

  @override
  String get sunrise => 'На горизонті';

  @override
  String get mountains => 'Over the hills';

  @override
  String get greenery => 'Зелене життя';

  @override
  String get beach => 'Пісок і море';

  @override
  String get city => 'У місті';

  @override
  String get moon => 'У місячному сяйві';

  @override
  String get onTheRoad => 'Знов у дорозі';

  @override
  String get food => 'Кулінарне задоволення';

  @override
  String get pets => 'Furry companions';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Віджети';

  @override
  String get memories => 'Спогади';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Past years\' memories';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'З днем народження! 🥳';

  @override
  String get birthdays => 'Дні народження';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Інші виявлені обличчя';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Зберегти як іншу особу';

  @override
  String get showLessFaces => 'Показати менше облич';

  @override
  String get showMoreFaces => 'Показати більше облич';

  @override
  String get ignore => 'Ігнорувати';

  @override
  String get merge => 'Об\'єднати';

  @override
  String get reset => 'Скинути';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Так, ігнорувати';

  @override
  String get same => 'Однакові';

  @override
  String get different => 'Різні';

  @override
  String get sameperson => 'Та сама особа?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Групувати за';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Додано до черги';

  @override
  String get creatingStream => 'Створення потоку';

  @override
  String get similarImages => 'Схожі зображення';

  @override
  String get findSimilarImages => 'Знайти схожі зображення';

  @override
  String get noSimilarImagesFound => 'Схожі зображення не знайдені';

  @override
  String get yourPhotosLookUnique => 'Ваші фотографії виглядають унікально';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Представляємо Ритуали';

  @override
  String get cLDesc1 =>
      'Плануєте цілі на 2026 рік? З Ритуалами ви можете встановити нагадування в Ente Photos і відстежувати свій прогрес, роблячи фотографії. Використовуйте для тренувань, харчових звичок, щоденних моментів з близькими – всього, що ви хочете перетворити на звичку.';

  @override
  String get cLTitle2 => 'Публічні посилання тепер для всіх';

  @override
  String get cLDesc2 =>
      'Усі користувачі Ente на безкоштовному плані тепер можуть створювати та ділитися публічними посиланнями на фотографії та альбоми. Для запобігання зловживанням посилання матимуть обмеження щодо кількості переглядів.';

  @override
  String get cLTitle3 => 'Ручне позначення людей';

  @override
  String get cLDesc3 =>
      'Тепер ви можете позначати людей, навіть коли наш ШІ на пристрої не розпізнає обличчя. Зручно для домашніх тварин, частково видимих облич або моментів, коли когось немає на фото, але його слід включити.';

  @override
  String get cLTitle4 => 'І ще';

  @override
  String get cLDesc4 =>
      'Тепер можна закріплювати спільні альбоми. Посилання на альбоми видимі співавторам і глядачам для ще зручнішого обміну. Ми виправили деякі помилки свайпу на iOS і оновили перегляд фотографій, включаючи нову іконку обраного (готуємось до нових функцій).';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Створити новий';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Вибрати альбом';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Використати';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
