// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class AppLocalizationsTr extends AppLocalizations {
  AppLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get enterYourEmailAddress => 'E-posta adresinizi girin';

  @override
  String get enterYourNewEmailAddress => 'Yeni e-posta adresinizi girin';

  @override
  String get accountWelcomeBack => 'Tekrar hoş geldiniz!';

  @override
  String get emailAlreadyRegistered => 'E-posta zaten kayıtlı.';

  @override
  String get emailNotRegistered => 'E-posta kayıtlı değil.';

  @override
  String get email => 'E-Posta';

  @override
  String get cancel => 'İptal et';

  @override
  String get verify => 'Doğrula';

  @override
  String get invalidEmailAddress => 'Geçersiz e-posta adresi';

  @override
  String get enterValidEmail => 'Lütfen geçerli bir e-posta adresi girin.';

  @override
  String get deleteAccount => 'Hesabı sil';

  @override
  String get deleteAccountWarning =>
      'Bu, Ente Auth, Ente Photos ve Ente Locker hesabınızı silecektir.';

  @override
  String get askDeleteReason => 'Hesabınızı silme sebebiniz nedir?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Gittiğini gördüğümüze üzüldük. Lütfen gelişmemize yardımcı olmak için neden ayrıldığınızı açıklayın.';

  @override
  String get feedback => 'Geri Bildirim';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Lütfen bu bilgilerle bize yardımcı olun';

  @override
  String get confirmDeletePrompt =>
      'Evet, bu hesabı ve verilerini tüm uygulamalardan kalıcı olarak silmek istiyorum.';

  @override
  String get confirmAccountDeletion => 'Hesap silme işlemini onayla';

  @override
  String get deleteAccountPermanentlyButton => 'Hesabımı kalıcı olarak sil';

  @override
  String get yourAccountHasBeenDeleted => 'Hesabınız silindi';

  @override
  String get selectReason => 'Ayrılma nedeninizi seçin';

  @override
  String get deleteReason1 => 'İhtiyacım olan önemli bir özellik eksik';

  @override
  String get deleteReason2 =>
      'Uygulama veya bir özellik olması gerektiğini düşündüğüm gibi çalışmıyor';

  @override
  String get deleteReason3 => 'Daha çok sevdiğim başka bir hizmet buldum';

  @override
  String get deleteReason4 => 'Nedenim listede yok';

  @override
  String get sendEmail => 'E-posta gönder';

  @override
  String get deleteRequestSLAText =>
      'İsteğiniz 72 saat içinde gerçekleştirilecek.';

  @override
  String get deleteEmailRequest =>
      'Lütfen kayıtlı e-posta adresinizden <warning> account-deletion@ente.io</warning>\'ya e-posta gönderiniz.';

  @override
  String get entePhotosPerm =>
      'Ente fotoğrafları saklamak için <i>iznine ihtiyaç duyuyor</i>';

  @override
  String get ok => 'Tamam';

  @override
  String get createAccount => 'Hesap oluşturun';

  @override
  String get createNewAccount => 'Yeni bir hesap oluşturun';

  @override
  String get password => 'Şifre';

  @override
  String get confirmPassword => 'Şifrenizi onaylayın';

  @override
  String get activeSessions => 'Aktif oturumlar';

  @override
  String get ocrProcessingOverlayMessage => 'Metin algılanıyor...';

  @override
  String get ocrLoadingIndicatorLabel => 'Metin Algılanıyor';

  @override
  String get ocrSelectionHint =>
      'İhtiyacınız olanı seçmek için kaydırın veya iki kez dokunun';

  @override
  String get ocrNoTextDetected => 'Yazı algılanmadı';

  @override
  String get ocrRetryButtonLabel => 'Tekrar dene';

  @override
  String get ocrModelsNetworkRequiredError =>
      'OCR modellerini ilk kez kullanmak için ağ bağlantısı gereklidir';

  @override
  String get ocrModelsPrepareFailed => 'OCR modelleri hazırlanamadı';

  @override
  String get ocrImageNotFoundError => 'Görsel dosyası bulunamadı';

  @override
  String get ocrImageDecodeFailedError => 'Görsel okunamadı';

  @override
  String get ocrGenericDetectError => 'Görselde yazı algılanmadı';

  @override
  String get oops => 'Hay aksi';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Bir şeyler ters gitti, lütfen tekrar deneyin';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Bu cihazdaki oturumunuz kapatılacak!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Bu, sizi aşağıdaki cihazdan çıkış yapacak:';

  @override
  String get terminateSession => 'Oturum sonlandırılsın mı?';

  @override
  String get terminate => 'Sonlandır';

  @override
  String get thisDevice => 'Bu cihaz';

  @override
  String get recoverButton => 'Kurtar';

  @override
  String get recoverySuccessful => 'Kurtarma başarılı!';

  @override
  String get decrypting => 'Şifre çözülüyor...';

  @override
  String get incorrectRecoveryKeyTitle => 'Yanlış kurtarma kodu';

  @override
  String get incorrectRecoveryKeyBody => 'Girdiğiniz kurtarma kod yanlış';

  @override
  String get forgotPassword => 'Şifremi unuttum';

  @override
  String get enterYourRecoveryKey => 'Kurtarma kodunuzu girin';

  @override
  String get noRecoveryKey => 'Kurtarma anahtarınız yok mu?';

  @override
  String get sorry => 'Üzgünüz';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Uçtan uca şifreleme protokolümüzün doğası gereği, verileriniz şifreniz veya kurtarma anahtarınız olmadan çözülemez';

  @override
  String get verifyEmail => 'E-posta adresini doğrulayın';

  @override
  String get toResetVerifyEmail =>
      'Şifrenizi sıfılamak için lütfen e-postanızı girin.';

  @override
  String get checkInboxAndSpamFolder =>
      'Lütfen doğrulama işlemini tamamlamak için gelen kutunuzu (ve spam klasörünüzü) kontrol edin';

  @override
  String get tapToEnterCode => 'Kodu girmek icin tıklayın';

  @override
  String get resendEmail => 'E-postayı yeniden gönder';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'E-postayı <green>$email</green> adresine gönderdik';
  }

  @override
  String get setPasswordTitle => 'Parola ayarlayın';

  @override
  String get changePasswordTitle => 'Parolanızı değiştirin';

  @override
  String get resetPasswordTitle => 'Parolanızı sıfırlayın';

  @override
  String get encryptionKeys => 'Şifreleme anahtarı';

  @override
  String get passwordWarning =>
      'Şifrelerinizi saklamıyoruz, bu yüzden unutursanız, <underline>verilerinizi deşifre edemeyiz</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Verilerinizi şifrelemek için kullanabileceğimiz bir şifre girin';

  @override
  String get enterNewPasswordToEncrypt =>
      'Verilerinizi şifrelemek için kullanabileceğimiz yeni bir şifre girin';

  @override
  String get weakStrength => 'Zayıf';

  @override
  String get strongStrength => 'Güçlü';

  @override
  String get moderateStrength => 'Ilımlı';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Şifrenin güçlülük seviyesi: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully =>
      'Şifreniz başarılı bir şekilde değiştirildi';

  @override
  String get generatingEncryptionKeys => 'Şifreleme anahtarı oluşturuluyor...';

  @override
  String get pleaseWait => 'Lütfen bekleyiniz...';

  @override
  String get continueLabel => 'Devam edin';

  @override
  String get insecureDevice => 'Güvenilir olmayan cihaz';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Üzgünüm, bu cihazda güvenli anahtarlarını oluşturamadık.\n\nLütfen başka bir cihazdan giriş yapmayı deneyiniz.';

  @override
  String get howItWorks => 'Nasıl çalışır';

  @override
  String get encryption => 'Şifreleme';

  @override
  String get ackPasswordLostWarning =>
      'Şifremi kaybedersem, verilerim <underline>uçtan uca şifrelendiği</underline> için verilerimi kaybedebileceğimi farkındayım.';

  @override
  String get privacyPolicyTitle => 'Mahremiyet Politikası';

  @override
  String get termsOfServicesTitle => 'Şartlar';

  @override
  String get signUpTerms =>
      '<u-terms>Hizmet Şartları</u-terms>\'nı ve <u-policy>Gizlilik Politikası</u-policy>\'nı kabul ediyorum';

  @override
  String get logInLabel => 'Giriş yap';

  @override
  String get loginTerms =>
      '\"Giriş yap\" düğmesine tıklayarak, <u-terms>Hizmet Şartları</u-terms>\'nı ve <u-policy>Gizlilik Politikası</u-policy>\'nı kabul ediyorum';

  @override
  String get changeEmail => 'E-posta adresini değiştir';

  @override
  String get enterYourPassword => 'Lütfen şifrenizi giriniz';

  @override
  String get welcomeBack => 'Tekrardan hoşgeldin!';

  @override
  String get contactSupport => 'Destek ile iletişim';

  @override
  String get locationPickerTip =>
      'Fotoğrafın bilgi ekranından fotoğrafın ana yerine konum ekleyebilirsiniz';

  @override
  String get incorrectPasswordTitle => 'Yanlış şifre';

  @override
  String get pleaseTryAgain => 'Lütfen tekrar deneyiniz';

  @override
  String get recreatePasswordTitle => 'Şifrenizi tekrardan oluşturun';

  @override
  String get useRecoveryKey => 'Kurtarma anahtarını kullan';

  @override
  String get recreatePasswordBody =>
      'Cihazınız, şifrenizi doğrulamak için yeterli güce sahip değil, ancak tüm cihazlarda çalışacak şekilde yeniden oluşturabiliriz.\n\nLütfen kurtarma anahtarınızı kullanarak giriş yapın ve şifrenizi yeniden oluşturun (istediğiniz takdirde aynı şifreyi tekrar kullanabilirsiniz).';

  @override
  String get verifyPassword => 'Şifrenizi doğrulayın';

  @override
  String get recoveryKey => 'Kurtarma anahtarı';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Şifrenizi unutursanız, verilerinizi kurtarmanın tek yolu bu anahtar olacaktır.';

  @override
  String get recoveryKeySaveDescription =>
      'Bu anahtarı saklamıyoruz, lütfen bu 24 kelime anahtarı güvenli bir yerde saklayın.';

  @override
  String get doThisLater => 'Sonra yap';

  @override
  String get saveKey => 'Anahtarı kaydet';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Kurtarma anahtarınız panoya kopyalandı';

  @override
  String get recoverAccount => 'Hesabı kurtar';

  @override
  String get recover => 'Kurtarma';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Lütfen kayıtlı e-posta adresinizden $supportEmail adresine bir e-posta gönderin';
  }

  @override
  String get twofactorSetup => 'İki faktörlü kurulum';

  @override
  String get enterCode => 'Kodu giriniz';

  @override
  String get scanCode => 'Kodu tarayın';

  @override
  String get codeCopiedToClipboard => 'Kodunuz panoya kopyalandı';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Bu kodu kopyalayın ve kimlik doğrulama uygulamanıza yapıştırın';

  @override
  String get tapToCopy => 'kopyalamak için dokunun';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Kimlik doğrulama uygulamanız ile kodu tarayın';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Doğrulama uygulamasındaki 6 basamaklı kodu giriniz';

  @override
  String get confirm => 'Onayla';

  @override
  String get setupComplete => 'Ayarlama işlemi başarılı';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Henüz yapmadıysanız kurtarma anahtarınızı kaydetmeyi unutmayın';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Bu, iki faktörünüzü kaybederseniz hesabınızı kurtarmak için kullanılabilir';

  @override
  String get twofactorAuthenticationPageTitle => 'İki faktörlü doğrulama';

  @override
  String get lostDevice => 'Cihazınızı mı kaybettiniz?';

  @override
  String get verifyingRecoveryKey => 'Kurtarma kodu doğrulanıyor...';

  @override
  String get recoveryKeyVerified => 'Kurtarma kodu doğrulandı';

  @override
  String get recoveryKeySuccessBody =>
      'Harika! Kurtarma anahtarınız geçerlidir. Doğrulama için teşekkür ederim.\n\nLütfen kurtarma anahtarınızı güvenli bir şekilde yedeklediğinizden emin olun.';

  @override
  String get invalidRecoveryKey =>
      'Girdiğiniz kurtarma anahtarı geçerli değil. Lütfen anahtarın 24 kelime içerdiğinden ve her bir kelimenin doğru şekilde yazıldığından emin olun.\n\nEğer eski bir kurtarma kodu girdiyseniz, o zaman kodun 64 karakter uzunluğunda olduğunu kontrol edin.';

  @override
  String get invalidKey => 'Gecersiz anahtar';

  @override
  String get tryAgain => 'Tekrar deneyiniz';

  @override
  String get viewRecoveryKey => 'Kurtarma anahtarını görüntüle';

  @override
  String get confirmRecoveryKey => 'Kurtarma anahtarını doğrula';

  @override
  String get recoveryKeyVerifyReason =>
      'Kurtarma anahtarınız, şifrenizi unutmanız durumunda fotoğraflarınızı kurtarmanın tek yoludur. Kurtarma anahtarınızı Ayarlar > Hesap bölümünde bulabilirsiniz.\n\nDoğru kaydettiğinizi doğrulamak için lütfen kurtarma anahtarınızı buraya girin.';

  @override
  String get confirmYourRecoveryKey => 'Kurtarma anahtarını doğrulayın';

  @override
  String get addViewer => 'Görüntüleyici ekle';

  @override
  String get addCollaborator => 'Düzenleyici ekle';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Yeni e-posta ekle';

  @override
  String get orPickAnExistingOne => 'Veya mevcut birini seçiniz';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Düzenleyiciler, paylaşılan albüme fotoğraf ve videolar ekleyebilir.';

  @override
  String get enterEmail => 'E-postanızı giriniz';

  @override
  String get albumOwner => 'Sahip';

  @override
  String get you => 'Sen';

  @override
  String get collaborator => 'Düzenleyici';

  @override
  String get addMore => 'Daha fazla ekle';

  @override
  String get viewer => 'Görüntüleyici';

  @override
  String get remove => 'Kaldır';

  @override
  String get removeParticipant => 'Katılımcıyı kaldır';

  @override
  String get manage => 'Yönet';

  @override
  String get addedAs => 'Eklendi';

  @override
  String get changePermissions => 'İzinleri değiştir?';

  @override
  String get yesConvertToViewer => 'Evet, görüntüleyici olarak dönüştür';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user, bu albüme daha fazla fotoğraf ekleyemeyecek.\n\nAncak, kendi eklediği mevcut fotoğrafları kaldırmaya devam edebilecektir';
  }

  @override
  String get allowAddingPhotos => 'Fotoğraf eklemeye izin ver';

  @override
  String get allowJoiningAlbum => 'Albüme katılmaya izin ver';

  @override
  String get allowAddPhotosDescription =>
      'Bağlantıya sahip olan kişilerin paylaşılan albüme fotoğraf eklemelerine izin ver.';

  @override
  String get passwordLock => 'Şifre kilidi';

  @override
  String get canNotOpenTitle => 'Albüm açılamadı';

  @override
  String get canNotOpenBody => 'Üzgünüz, Bu albüm uygulama içinde açılamadı.';

  @override
  String get disableDownloadWarningTitle => 'Lütfen dikkate alın';

  @override
  String get disableDownloadWarningBody =>
      'Görüntüleyiciler, hala harici araçlar kullanarak ekran görüntüsü alabilir veya fotoğraflarınızın bir kopyasını kaydedebilir. Lütfen bunu göz önünde bulundurunuz';

  @override
  String get allowDownloads => 'İndirmeye izin ver';

  @override
  String get linkDeviceLimit => 'Cihaz sınırı';

  @override
  String get noDeviceLimit => 'Yok';

  @override
  String get albumLayout => 'Albüm düzeni';

  @override
  String get layoutGrouped => 'Gruplandırıldı';

  @override
  String get layoutContinuous => 'Sürekli';

  @override
  String get layoutTrip => 'Seyahat';

  @override
  String get preview => 'Önceki';

  @override
  String get linkExpiry => 'Bağlantı geçerliliği';

  @override
  String get linkExpired => 'Süresi dolmuş';

  @override
  String get linkEnabled => 'Geçerli';

  @override
  String get linkNeverExpires => 'Asla';

  @override
  String get expiredLinkInfo =>
      'Bu bağlantının süresi dolmuştur. Lütfen yeni bir süre belirleyin veya bağlantı süresini devre dışı bırakın.';

  @override
  String get setAPassword => 'Şifre ayarla';

  @override
  String get lockButtonLabel => 'Kilit';

  @override
  String get enterPassword => 'Şifrenizi girin';

  @override
  String get removeLink => 'Bağlantıyı kaldır';

  @override
  String get manageLink => 'Bağlantıyı yönet';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Bu bağlantı $expiryTime tarihinden itibaren geçersiz olacaktır';
  }

  @override
  String get albumUpdated => 'Albüm güncellendi';

  @override
  String get never => 'Asla';

  @override
  String get custom => 'Özel';

  @override
  String get after1Hour => '1 saat sonra';

  @override
  String get after1Day => '1 gün sonra';

  @override
  String get after1Week => '1 hafta sonra';

  @override
  String get after1Month => '1 ay sonra';

  @override
  String get after1Year => '1 yıl sonra';

  @override
  String get manageParticipants => 'Yönet';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Katılımcı',
      one: '1 Katılımcı',
      zero: 'Katılımcı Yok',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Ente aplikasyonu veya hesabı olmadan insanların paylaşılan albümde fotoğraf ekleyip görüntülemelerine izin vermek için bir bağlantı oluşturun. Grup veya etkinlik fotoğraflarını toplamak için harika bir seçenek.';

  @override
  String get collectPhotos => 'Fotoğrafları topla';

  @override
  String get collaborativeLink => 'Ortak bağlantı';

  @override
  String get shareWithNonenteUsers => 'Ente kullanıcısı olmayanlar için paylaş';

  @override
  String get createPublicLink => 'Herkese açık bir bağlantı oluştur';

  @override
  String get sendLink => 'Bağlantıyı gönder';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'QR kod gönder';

  @override
  String get copyLink => 'Bağlantıyı kopyala';

  @override
  String get copyEmbedHtml => 'Kopyalanmış Html ekle';

  @override
  String get linkHasExpired => 'Bağlantının süresi dolmuş';

  @override
  String get publicLinkEnabled => 'Herkese açık bağlantı aktive edildi';

  @override
  String get shareALink => 'Bir bağlantı paylaş';

  @override
  String get sharedAlbumSectionDescription =>
      'Diğer Ente kullanıcılarıyla paylaşılan ve topluluk albümleri oluşturun, bu arada ücretsiz planlara sahip kullanıcıları da içerir.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: '$numberOfPeople kişiyle paylaşıldı',
      one: '1 kişiyle paylaşıldı',
      zero: 'Belirli kişilerle paylaş',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Doğrulama kimliğiniz';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Size albümleri paylaşan biri, kendi cihazında aynı kimliği görmelidir.';

  @override
  String get howToViewShareeVerificationID =>
      'Lütfen onlardan ayarlar ekranında e-posta adresine uzun süre basmalarını ve her iki cihazdaki kimliklerin eşleştiğini doğrulamalarını isteyin.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Bu, $email\'in Doğrulama Kimliği';
  }

  @override
  String get verificationId => 'Doğrulama kimliği';

  @override
  String verifyEmailID({required Object email}) {
    return '$email doğrula';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email, Ente hesabı bulunmamaktadır.\n\nOnlarla fotoğraf paylaşımı için bir davet gönder.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'İşte ente.io için doğrulama kimliğim: $verificationID.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Merhaba, bu ente.io doğrulama kimliğinizin doğruluğunu onaylayabilir misiniz: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Bazı şeyler yanlış gitti';

  @override
  String get sendInvite => 'Davet kodu gönder';

  @override
  String get shareTextRecommendUsingEnte =>
      'Orijinal kalitede fotoğraf ve videoları kolayca paylaşabilmemiz için Ente\'yi indirin\n\nhttps://ente.io';

  @override
  String get done => 'Bitti';

  @override
  String get applyCodeTitle => 'Kodu girin';

  @override
  String get enterCodeDescription =>
      'İkiniz için de ücretsiz depolama alanı talep etmek için arkadaşınız tarafından sağlanan kodu girin';

  @override
  String get apply => 'Uygula';

  @override
  String get failedToApplyCode => 'Uygulanırken hata oluştu';

  @override
  String get enterReferralCode => 'Davet kodunuzu girin';

  @override
  String get codeAppliedPageTitle => 'Kod kabul edildi';

  @override
  String get changeYourReferralCode => 'Referans kodunuzu değiştirin';

  @override
  String get change => 'Değiştir';

  @override
  String get unavailableReferralCode => 'Üzgünüz, bu kod mevcut değil.';

  @override
  String get codeChangeLimitReached =>
      'Üzgünüz, kod değişikliklerinin sınırına ulaştınız.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Kodunuzu değiştirmek için lütfen $familyAdminEmail ile iletişime geçin.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Alındı';

  @override
  String get details => 'Ayrıntılar';

  @override
  String get claimMore => 'Arttır!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Aynı zamanda $storageAmountInGB GB alıyorlar';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return 'Birisinin davet kodunuzu uygulayıp ücretli hesap açtığı her seferede $storageAmountInGB GB';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Ente davet kodu: $referralCode \n\nÜcretli hesaba başvurduktan sonra $referralStorageInGB GB bedava almak için \nAyarlar → Genel → Davetlerde bu kodu girin\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Bedava alan kazanın';

  @override
  String get inviteYourFriends => 'Arkadaşlarını davet et';

  @override
  String get failedToFetchReferralDetails =>
      'Davet ayrıntıları çekilemedi. Iütfen daha sonra deneyin.';

  @override
  String get referralStep1 => '1. Bu kodu arkadaşlarınıza verin';

  @override
  String get referralStep2 => '2. Ücretli bir plan için kaydolsunlar';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. İkinizde bedava $storageInGB GB alın';
  }

  @override
  String get referralsAreCurrentlyPaused => 'Davetler şu anda durmuş durumda';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Alanınızı en fazla ikiye katlayabilirsiniz';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Şu ana kadar aileniz $storageAmountInGb GB aldı',
      'false': 'Şu ana kadar $storageAmountInGb GB aldınız',
      'other': 'Şu ana kadar $storageAmountInGb GB aldınız!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Sık sorulan sorular';

  @override
  String get help => 'Yardım';

  @override
  String get oopsSomethingWentWrong => 'Hoop, Birşeyler yanlış gitti';

  @override
  String get peopleUsingYourCode => 'Kodunuzu kullananlar';

  @override
  String get eligible => 'uygun';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Sizin kullandığınız kod';

  @override
  String get freeStorageClaimed => 'Alınan bedava alan';

  @override
  String get freeStorageUsable => 'Kullanılabilir bedava alan';

  @override
  String get usableReferralStorageInfo =>
      'Kullanılabilir depolama alanı mevcut planınızla sınırlıdır. Talep edilen fazla depolama alanı, planınızı yükselttiğinizde otomatik olarak kullanılabilir hale gelecektir.';

  @override
  String get removeFromAlbumTitle => 'Albümden çıkarılsın mı?';

  @override
  String get removeFromAlbum => 'Albümden çıkar';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Seçilen öğeler bu albümden kaldırılacak';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Favorilere ekleniyor...';

  @override
  String get removingFromFavorites => 'Favorilerimden kaldır...';

  @override
  String get sorryCouldNotAddToFavorites => 'Üzgünüm, favorilere ekleyemedim!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Üzgünüm, favorilere ekleyemedim!';

  @override
  String get subscribeToEnableSharing =>
      'Paylaşımı etkinleştirmek için aktif bir ücretli aboneliğe ihtiyacınız var.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'Abone ol';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Yalnızca size ait dosyaları kaldırabilir';

  @override
  String get deleteSharedAlbum => 'Paylaşılan albüm silinsin mi?';

  @override
  String get deleteAlbum => 'Albümü sil';

  @override
  String get deleteAlbumDialog =>
      'Ayrıca bu albümde bulunan fotoğrafları (ve videoları) parçası oldukları <bold>tüm</bold> diğer albümlerden silebilir miyim?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Albüm herkes için silinecek\n\nBu albümdeki başkalarına ait paylaşılan fotoğraflara erişiminizi kaybedeceksiniz';

  @override
  String get yesRemove => 'Evet, sil';

  @override
  String get creatingLink => 'Bağlantı oluşturuluyor...';

  @override
  String get removeWithQuestionMark => 'Kaldırılsın mı?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail bu paylaşılan albümden kaldırılacaktır\n\nOnlar tarafından eklenen tüm fotoğraflar da albümden kaldırılacaktır';
  }

  @override
  String get keepPhotos => 'Fotoğrafları sakla';

  @override
  String get deletePhotos => 'Fotoğrafları sil';

  @override
  String get inviteToEnte => 'Ente\'ye davet edin';

  @override
  String get removePublicLink => 'Herkese açık bağlantıyı kaldır';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Bu, \"$albumName\"e erişim için olan genel bağlantıyı kaldıracaktır.';
  }

  @override
  String get sharing => 'Paylaşılıyor...';

  @override
  String get youCannotShareWithYourself => 'Kendinizle paylaşamazsınız';

  @override
  String get archive => 'Arşiv';

  @override
  String get createAlbumActionHint =>
      'Fotoğrafları seçmek için uzun basın ve + düğmesine tıklayarak bir albüm oluşturun';

  @override
  String get importing => 'İçeri aktarılıyor....';

  @override
  String get failedToLoadAlbums => 'Albüm yüklenirken hata oluştu';

  @override
  String get hidden => 'Gizle';

  @override
  String get authToViewYourHiddenFiles =>
      'Gizli dosyalarınızı görüntülemek için kimlik doğrulama yapınız';

  @override
  String get authToViewTrashedFiles =>
      'Çöp dosyalarınızı görüntülemek için lütfen kimlik doğrulaması yapın';

  @override
  String get trash => 'Cöp kutusu';

  @override
  String get uncategorized => 'Kategorisiz';

  @override
  String get videoSmallCase => 'video';

  @override
  String get photoSmallCase => 'fotoğraf';

  @override
  String get singleFileDeleteHighlight => 'Tüm albümlerden silinecek.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return '$fileType Ente ve cihazınızdan silinecektir.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return '$fileType Ente\'den silinecektir.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Bu $fileType, cihazınızdan silinecek.';
  }

  @override
  String get deleteFromEnte => 'Ente\'den Sil';

  @override
  String get yesDelete => 'Evet, sil';

  @override
  String get movedToTrash => 'Cöp kutusuna taşı';

  @override
  String get deleteFromDevice => 'Cihazınızdan silin';

  @override
  String get deleteFromBoth => 'Her ikisinden de sil';

  @override
  String get newAlbum => 'Yeni albüm';

  @override
  String get albums => 'Albümler';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount anı',
      one: '$formattedCount anı',
      zero: 'hiç anı yok',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count seçildi';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return 'Seçilenler: $count ($yourCount sizin seçiminiz)';
  }

  @override
  String get advancedSettings => 'Gelişmiş';

  @override
  String get photoGridSize => 'Izgara boyutu';

  @override
  String get manageDeviceStorage => 'Cihaz Önbelliğini Yönet';

  @override
  String get manageDeviceStorageDesc =>
      'Yerel önbellek depolama alanını gözden geçirin ve temizleyin.';

  @override
  String get machineLearning => 'Makine öğrenimi';

  @override
  String get mlConsent => 'Makine öğrenimini etkinleştir';

  @override
  String get mlConsentTitle => 'Makine öğrenimi etkinleştirilsin mi?';

  @override
  String get mlConsentDescription =>
      'Makine öğrenimini etkinleştirirseniz, Ente sizinle paylaşılanlar da dahil olmak üzere dosyalardan yüz geometrisi gibi bilgileri çıkarır.\n\nBu, cihazınızda gerçekleşecek ve oluşturulan tüm biyometrik bilgiler uçtan uca şifrelenecektir.';

  @override
  String get mlConsentPrivacy =>
      'Gizlilik politikamızdaki bu özellik hakkında daha fazla ayrıntı için lütfen buraya tıklayın';

  @override
  String get mlConsentConfirmation =>
      'Anladım, ve makine öğrenimini etkinleştirmek istiyorum';

  @override
  String get magicSearch => 'Sihirli arama';

  @override
  String get discover => 'Keşfet';

  @override
  String get discover_identity => 'Kimlik';

  @override
  String get discover_screenshots => 'Ekran Görüntüleri';

  @override
  String get discover_receipts => 'Makbuzlar';

  @override
  String get discover_notes => 'Notlar';

  @override
  String get discover_memes => 'Mimler';

  @override
  String get discover_visiting_cards => 'Ziyaret Kartları';

  @override
  String get discover_babies => 'Bebek';

  @override
  String get discover_pets => 'Evcil Hayvanlar';

  @override
  String get discover_selfies => 'Özçekimler';

  @override
  String get discover_wallpapers => 'Duvar Kağıtları';

  @override
  String get discover_food => 'Yiyecek';

  @override
  String get discover_celebrations => 'Kutlamalar ';

  @override
  String get discover_sunset => 'Gün batımı';

  @override
  String get discover_hills => 'Tepeler';

  @override
  String get discover_greenery => 'Yeşillik';

  @override
  String get mlIndexingDescription =>
      'Makine öğreniminin, tüm öğeler dizine eklenene kadar daha yüksek bant genişliği ve pil kullanımıyla sonuçlanacağını lütfen unutmayın. Daha hızlı dizinleme için masaüstü uygulamasını kullanmayı deneyin, tüm sonuçlar otomatik olarak senkronize edilir.';

  @override
  String get loadingModel => 'Modeller indiriliyor...';

  @override
  String get waitingForWifi => 'WiFi bekleniyor...';

  @override
  String get status => 'Durum';

  @override
  String get indexedItems => 'Dizinlenmiş öğeler';

  @override
  String get pendingItems => 'Bekleyen Öğeler';

  @override
  String get clearIndexes => 'Dizinleri temizle';

  @override
  String get selectFoldersForBackup => 'Yedekleme için klasörleri seçin';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Seçilen klasörler şifrelenecek ve yedeklenecektir';

  @override
  String get unselectAll => 'Tümünün seçimini kaldır';

  @override
  String get selectAll => 'Hepsini seç';

  @override
  String get skip => 'Geç';

  @override
  String get updatingFolderSelection => 'Klasör seçimi güncelleniyor...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count öğeler',
      one: '$count öğe',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Delete $count items',
      one: 'Delete $count item',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count dosyalar, $formattedSize her biri';
  }

  @override
  String get showMemories => 'Anıları göster';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count yıl önce',
      one: '$count yıl önce',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Yedekleme seçenekleri';

  @override
  String get backupStatus => 'Yedekleme durumu';

  @override
  String get backupStatusDescription => 'Eklenen öğeler burada görünecek';

  @override
  String get backupOverMobileData => 'Mobil veri ile yedekle';

  @override
  String get backupVideos => 'Videoları yedekle';

  @override
  String get disableAutoLock => 'Otomatik kilidi devre dışı bırak';

  @override
  String get deviceLockExplanation =>
      'Ente uygulaması önplanda calıştığında ve bir yedekleme işlemi devam ettiğinde, cihaz ekran kilidini devre dışı bırakın. Bu genellikle gerekli olmasa da, büyük dosyaların yüklenmesi ve büyük kütüphanelerin başlangıçta içe aktarılması sürecini hızlandırabilir.';

  @override
  String get about => 'Hakkında';

  @override
  String get weAreOpenSource => 'Biz açık kaynağız!';

  @override
  String get privacy => 'Gizlilik';

  @override
  String get terms => 'Şartlar';

  @override
  String get checkForUpdates => 'Güncellemeleri kontol et';

  @override
  String get checkStatus => 'Durumu kontrol edin';

  @override
  String get checking => 'Kontrol ediliyor...';

  @override
  String get youAreOnTheLatestVersion => 'En son sürüme sahipsiniz';

  @override
  String get account => 'Hesap';

  @override
  String get manageSubscription => 'Abonelikleri yönet';

  @override
  String get authToChangeYourEmail =>
      'E-postanızı değiştirmek için lütfen kimlik doğrulaması yapın';

  @override
  String get changePassword => 'Şifrenizi değiştirin';

  @override
  String get authToChangeYourPassword =>
      'Şifrenizi değiştirmek için lütfen kimlik doğrulaması yapın';

  @override
  String get emailVerificationToggle => 'E-posta doğrulama';

  @override
  String get authToChangeEmailVerificationSetting =>
      'E-posta doğrulamasını değiştirmek için lütfen kimlik doğrulaması yapın';

  @override
  String get exportYourData => 'Veriyi dışarı aktar';

  @override
  String get logout => 'Çıkış yap';

  @override
  String get authToInitiateAccountDeletion =>
      'Hesap silme işlemini başlatmak için lütfen kimlik doğrulaması yapın';

  @override
  String get areYouSureYouWantToLogout =>
      'Çıkış yapmak istediğinize emin misiniz?';

  @override
  String get yesLogout => 'Evet, oturumu kapat';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Ente için yeni bir sürüm mevcut.';

  @override
  String get update => 'Güncelle';

  @override
  String get installManually => 'Manuel kurulum';

  @override
  String get criticalUpdateAvailable => 'Kritik güncelleme mevcut';

  @override
  String get updateAvailable => 'Güncelleme mevcut';

  @override
  String get ignoreUpdate => 'Yoksay';

  @override
  String get downloading => 'İndiriliyor...';

  @override
  String get cannotDeleteSharedFiles => 'Dosyalar silinemiyor';

  @override
  String get theDownloadCouldNotBeCompleted => 'İndirme işlemi tamamlanamadı';

  @override
  String get retry => 'Tekrar dene';

  @override
  String get backedUpFolders => 'Yedeklenmiş klasörler';

  @override
  String get backup => 'Yedekle';

  @override
  String get freeUpDeviceSpace => 'Cihaz alanını boşaltın';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Zaten yedeklenmiş dosyaları temizleyerek cihazınızda yer kazanın.';

  @override
  String get allClear => '✨ Tümü temizlendi';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Her şey zaten temiz, silinecek dosya kalmadı';

  @override
  String get removeDuplicates => 'Yinelenenleri kaldır';

  @override
  String get removeDuplicatesDesc =>
      'Aynı olan dosyaları gözden geçirin ve kaldırın.';

  @override
  String get viewLargeFiles => 'Büyük dosyalar';

  @override
  String get viewLargeFilesDesc =>
      'En fazla depolama alanı kullanan dosyaları görüntüleyin.';

  @override
  String get noDuplicates => 'Yinelenenleri kaldır';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Temizlenebilecek yinelenen dosyalarınız yok';

  @override
  String get success => 'Başarılı';

  @override
  String get rateUs => 'Bizi değerlendirin';

  @override
  String get remindToEmptyDeviceTrash =>
      'Ayrıca boş alanı kazanmak için \"Ayarlar\" > \"Depolama\" bölümünden \"Son Silinenler\" klasörünü de boşaltın';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Başarılı bir şekilde $storageSaved alanını boşalttınız!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Ayrıca boşalan alana sahip olmak için \"Çöp Kutunuzu\" boşaltın';

  @override
  String get sparkleSuccess => '✨ Başarılı';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count duplicate files',
      one: '$count duplicate file',
    );
    return 'You have cleaned up $_temp0, saving ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Aile Planı';

  @override
  String get referrals => 'Arkadaşını davet et';

  @override
  String get notifications => 'Bildirimler';

  @override
  String get sharedPhotoNotifications => 'Paylaşılan fotoğrafları ekle';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Birisi parçası olduğunuz paylaşılan bir albüme fotoğraf eklediğinde bildirim alın';

  @override
  String get advanced => 'Gelişmiş';

  @override
  String get general => 'Genel';

  @override
  String get security => 'Güvenlik';

  @override
  String get authToViewYourRecoveryKey =>
      'Kurtarma anahtarınızı görmek için lütfen kimliğinizi doğrulayın';

  @override
  String get twofactor => 'İki faktörlü doğrulama';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'İki faktörlü kimlik doğrulamayı yapılandırmak için lütfen kimlik doğrulaması yapın';

  @override
  String get lockscreen => 'Kilit ekranı';

  @override
  String get authToChangeLockscreenSetting =>
      'Kilit ekranı ayarını değiştirmek için lütfen kimliğinizi doğrulayın';

  @override
  String get viewActiveSessions => 'Aktif oturumları görüntüle';

  @override
  String get authToViewYourActiveSessions =>
      'Aktif oturumlarınızı görüntülemek için lütfen kimliğinizi doğrulayın';

  @override
  String get disableTwofactor => 'İki Aşamalı Doğrulamayı Devre Dışı Bırak';

  @override
  String get confirm2FADisable =>
      'İki adımlı kimlik doğrulamasını devre dışı bırakmak istediğinize emin misiniz?';

  @override
  String get no => 'Hayır';

  @override
  String get yes => 'Evet';

  @override
  String get social => 'Sosyal Medya';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Bizi $storeName üzerinden değerlendirin';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Ürünler';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Depolama bilgisi alınamadı';

  @override
  String get reportABug => 'Hata bildir';

  @override
  String get reportBug => 'Hata bildir';

  @override
  String get suggestFeatures => 'Özellik önerin';

  @override
  String get support => 'Destek';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Aydınlık';

  @override
  String get darkTheme => 'Karanlık';

  @override
  String get systemTheme => 'Sistem';

  @override
  String get freeTrial => 'Ücretsiz deneme';

  @override
  String get selectYourPlan => 'Planınızı seçin';

  @override
  String get enteSubscriptionPitch =>
      'Ente anılarınızı korur, böylece cihazınızı kaybetseniz bile anılarınıza her zaman ulaşabilirsiniz.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Aileniz de planınıza eklenebilir.';

  @override
  String get currentUsageIs => 'Güncel kullanımınız ';

  @override
  String get faqs => 'Sık Sorulan Sorular';

  @override
  String renewsOn({required Object endDate}) {
    return 'Abonelik $endDate tarihinde yenilenir';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Ücretsiz deneme $endDate sona erir';
  }

  @override
  String validTill({required Object endDate}) {
    return '$endDate tarihine kadar geçerli';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return '$storageAmount eklentiniz $endDate tarihine kadar geçerlidir';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Ücretsiz deneme süresi $endDate tarihine kadar geçerlidir.\nDaha sonra ücretli bir plan seçebilirsiniz.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Aboneliğiniz $endDate tarihinde iptal edilecektir';
  }

  @override
  String get subscription => 'Abonelik';

  @override
  String get paymentDetails => 'Ödeme detayları';

  @override
  String get manageFamily => 'Aileyi yönet';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Lütfen $provider aboneliğinizi yönetmek için support@ente.io adresinden bizimle iletişime geçin.';
  }

  @override
  String get renewSubscription => 'Abonelik yenileme';

  @override
  String get cancelSubscription => 'Abonelik iptali';

  @override
  String get areYouSureYouWantToRenew => 'Yenilemek istediğinize emin misiniz?';

  @override
  String get yesRenew => 'Evet, yenile';

  @override
  String get areYouSureYouWantToCancel =>
      'İptal etmek istediğinize emin misiniz?';

  @override
  String get yesCancel => 'Evet, iptal et';

  @override
  String get failedToRenew => 'Abonelik yenilenirken hata oluştu';

  @override
  String get failedToCancel => 'İptal edilirken sorun oluştu';

  @override
  String get twoMonthsFreeOnYearlyPlans => 'Yıllık planlarda 2 ay ücretsiz';

  @override
  String get monthly => 'Aylık';

  @override
  String get yearly => 'Yıllık';

  @override
  String get confirmPlanChange => 'Plan değişikliğini onaylayın';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Planı değistirmek istediğinize emin misiniz?';

  @override
  String get youCannotDowngradeToThisPlan => 'Bu plana geçemezsiniz';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Lütfen önce mevcut aboneliğinizi $paymentProvider adresinden iptal edin';
  }

  @override
  String get optionalAsShortAsYouLike =>
      'İsteğe bağlı, istediğiniz kadar kısa...';

  @override
  String get send => 'Gönder';

  @override
  String get askCancelReason =>
      'Aboneliğiniz iptal edilmiştir. Bunun sebebini paylaşmak ister misiniz?';

  @override
  String get thankYouForSubscribing => 'Abone olduğunuz için teşekkürler!';

  @override
  String get yourPurchaseWasSuccessful => 'Satın alım başarılı';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Planınız başarıyla yükseltildi';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Planınız başarıyla düşürüldü';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Aboneliğiniz başarıyla güncellendi';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStore aboneliği';

  @override
  String get appstoreSubscription => 'AppStore aboneliği';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return '$id\'niz zaten başka bir ente hesabına bağlı.\n$id numaranızı bu hesapla kullanmak istiyorsanız lütfen desteğimizle iletişime geçin\'\'';
  }

  @override
  String get visitWebToManage =>
      'Aboneliğinizi yönetmek için lütfen web.ente.io adresini ziyaret edin';

  @override
  String get couldNotUpdateSubscription => 'Abonelikler kaydedilemedi';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Lütfen support@ente.io ile iletişime geçin; size yardımcı olmaktan memnuniyet duyarız!';

  @override
  String get paymentFailed => 'Ödeme başarısız oldu';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Sizden ücret alındıysa lütfen $providerName destek ekibiyle görüşün';
  }

  @override
  String get continueOnFreeTrial => 'Ücretsiz denemeye devam et';

  @override
  String get areYouSureYouWantToExit => 'Çıkmak istediğinden emin misiniz?';

  @override
  String get thankYou => 'Teşekkürler';

  @override
  String get failedToVerifyPaymentStatus => 'Ödeme durumu doğrulanamadı';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Tekrar denemeden önce lütfen bir süre bekleyin';

  @override
  String get paymentFailedMessage =>
      'Maalesef ödemeniz başarısız oldu. Lütfen destekle iletişime geçin, size yardımcı olacağız!';

  @override
  String get youAreOnAFamilyPlan => 'Aile planı kullanıyorsunuz!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Aboneliğinizi yönetmek için lütfen <green>$familyAdminEmail</green> ile iletişime geçin';
  }

  @override
  String get leaveFamily => 'Aile planından ayrıl';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Aile planından ayrılmak istediğinize emin misiniz?';

  @override
  String get leave => 'Ayrıl';

  @override
  String get rateTheApp => 'Uygulamayı puanlayın';

  @override
  String get startBackup => 'Yedeklemeyi başlat';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Şu anda hiçbir fotoğraf yedeklenmiyor';

  @override
  String get preserveMore => 'Daha fazlasını koruyun';

  @override
  String get grantFullAccessPrompt =>
      'Lütfen Ayarlar uygulamasında tüm fotoğraflara erişime izin verin';

  @override
  String get allowPermTitle => 'Fotoğraflara erişime izin verin';

  @override
  String get allowPermBody =>
      'Ente\'nin kitaplığınızı görüntüleyebilmesi ve yedekleyebilmesi için lütfen Ayarlar\'dan fotoğraflarınıza erişime izin verin.';

  @override
  String get openSettings => 'Ayarları Açın';

  @override
  String get selectMorePhotos => 'Daha Fazla Fotoğraf Seç';

  @override
  String get existingUser => 'Mevcut kullanıcı';

  @override
  String get privateBackups => 'Özel yedeklemeler';

  @override
  String get forYourMemories => 'anılarınız için';

  @override
  String get endtoendEncryptedByDefault =>
      'Varsayılan olarak uçtan uca şifrelenmiş';

  @override
  String get safelyStored => 'Güvenle saklanır';

  @override
  String get atAFalloutShelter => 'serpinti sığınağında';

  @override
  String get designedToOutlive => 'Hayatta kalmak için tasarlandı';

  @override
  String get available => 'Mevcut';

  @override
  String get everywhere => 'her yerde';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Masaüstü';

  @override
  String get mobileWebDesktop => 'Mobil, Web, Masaüstü';

  @override
  String get newToEnte => 'Ente\'de yeniyim';

  @override
  String get pleaseLoginAgain => 'Lütfen tekrar giriş yapın';

  @override
  String get autoLogoutMessage =>
      'Teknik aksaklık nedeniyle oturumunuz kapatıldı. Verdiğimiz rahatsızlıktan dolayı özür dileriz.';

  @override
  String get yourSubscriptionHasExpired => 'Aboneliğinizin süresi doldu';

  @override
  String get storageLimitExceeded => 'Depolama sınırı aşıldı';

  @override
  String get upgrade => 'Yükselt';

  @override
  String get raiseTicket => 'Bileti artır';

  @override
  String get backupFailed => 'Yedekleme başarısız oldu';

  @override
  String get sorryBackupFailedDesc =>
      'Üzgünüz, bu dosya şu anda yedeklenemedi. Daha sonra tekrar deneyeceğiz.';

  @override
  String get couldNotBackUpTryLater =>
      'Verilerinizi yedekleyemedik.\nDaha sonra tekrar deneyeceğiz.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente dosyaları yalnızca erişim izni verdiğiniz takdirde şifreleyebilir ve koruyabilir';

  @override
  String get pleaseGrantPermissions => 'Lütfen izin ver';

  @override
  String get grantPermission => 'İzinleri değiştir';

  @override
  String get privateSharing => 'Özel paylaşım';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Yalnızca istediğiniz kişilerle paylaşın';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Ente\'de olmayan kişiler için genel bağlantıları kullanın';

  @override
  String get allowPeopleToAddPhotos =>
      'Kullanıcıların fotoğraf eklemesine izin ver';

  @override
  String get shareAnAlbumNow => 'Şimdi bir albüm paylaşın';

  @override
  String get collectEventPhotos => 'Etkinlik fotoğraflarını topla';

  @override
  String get sessionExpired => 'Oturum süresi doldu';

  @override
  String get loggingOut => 'Çıkış yapılıyor...';

  @override
  String get onDevice => 'Cihazda';

  @override
  String get onEnte => '<branding>ente</branding> üzerinde';

  @override
  String get name => 'İsim';

  @override
  String get newest => 'En yeni';

  @override
  String get lastUpdated => 'En son güncellenen';

  @override
  String get deleteEmptyAlbums => 'Boş albümleri sil';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Boş albümler silinsin mi?';

  @override
  String get deleteAlbumsDialogBody =>
      'Bu, tüm boş albümleri silecektir. Bu, albüm listenizdeki dağınıklığı azaltmak istediğinizde kullanışlıdır.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Siliniyor $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Siliniyor $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Kalıcı olarak sil';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Yalnızca size ait dosyalar için bağlantı oluşturabilir';

  @override
  String get publicLinkCreated => 'Herkese açık bağlantı oluşturuldu';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Bağlantılarınızı paylaşım sekmesinden yönetebilirsiniz.';

  @override
  String get linkCopiedToClipboard => 'Link panoya kopyalandı';

  @override
  String get restore => 'Geri yükle';

  @override
  String get moveToAlbum => 'Albüme taşı';

  @override
  String get unhide => 'Gizleme';

  @override
  String get unarchive => 'Arşivden cıkar';

  @override
  String get favorite => 'Favori';

  @override
  String get removeFromFavorite => 'Favorilerden Kaldır';

  @override
  String get shareLink => 'Bağlantıyı paylaş';

  @override
  String get createCollage => 'Kolaj oluştur';

  @override
  String get saveCollage => 'Kolajı kaydet';

  @override
  String get collageSaved => 'Kolajınız galeriye kaydedildi';

  @override
  String get collageLayout => 'Düzen';

  @override
  String get addToEnte => 'Ente\'ye ekle';

  @override
  String get addToAlbum => 'Albüme ekle';

  @override
  String get delete => 'Sil';

  @override
  String get hide => 'Gizle';

  @override
  String get share => 'Paylaş';

  @override
  String get unhideToAlbum => 'Albümü gizleme';

  @override
  String get restoreToAlbum => 'Albümü yenile';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Öğeleri taşı',
      one: 'Öğeyi taşı',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Öğeler ekle',
      one: 'Öğe ekle',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Albüm oluştur veya seç';

  @override
  String get selectAlbum => 'Albüm seçin';

  @override
  String get searchByAlbumNameHint => 'Albüm adı';

  @override
  String get albumTitle => 'Albüm Başlığı';

  @override
  String get enterAlbumName => 'Bir albüm adı girin';

  @override
  String get restoringFiles => 'Dosyalar geri yükleniyor...';

  @override
  String get movingFilesToAlbum => 'Dosyalar albüme taşınıyor...';

  @override
  String get unhidingFilesToAlbum => 'Albümdeki dosyalar gösteriliyor';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Başkalarına ait albümlere yüklenemez';

  @override
  String get uploadingFilesToAlbum => 'Dosyalar albüme taşınıyor...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return '$albumName albümüne başarıyla eklendi';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return '$albumName adlı albüme başarıyla taşındı';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Bu albümde zaten bir ortak çalışma bağlantısı var';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return '$albumName için ortak çalışma bağlantısı oluşturuldu';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Sevdiklerinizden paylaşmalarını isteyin';

  @override
  String get invite => 'Davet et';

  @override
  String get shareYourFirstAlbum => 'İlk albümünüzü paylaşın';

  @override
  String sharedWith({required Object emailIDs}) {
    return '$emailIDs ile paylaşıldı';
  }

  @override
  String get sharedWithMe => 'Benimle paylaşılan';

  @override
  String get sharedByMe => 'Benim paylaştıklarım';

  @override
  String get doubleYourStorage => 'Depolama alanınızı ikiye katlayın';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Arkadaşlarınıza önerin ve planınızı 2 katına çıkarın';

  @override
  String get shareAlbumHint =>
      'Bir albüm açın ve paylaşmak için sağ üstteki paylaş düğmesine dokunun.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Öğeler kalıcı olarak silinmeden önce kalan gün sayısını gösterir';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count gün',
      one: '1 gün',
      zero: 'Yakında',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Hepsini Sil';

  @override
  String get renameAlbum => 'Albümü yeniden adlandır';

  @override
  String get convertToAlbum => 'Albüme taşı';

  @override
  String get setCover => 'Kapak Belirle';

  @override
  String get sortAlbumsBy => 'Sırala';

  @override
  String get sortNewestFirst => 'Yeniden eskiye';

  @override
  String get sortOldestFirst => 'Önce en eski';

  @override
  String get rename => 'Yeniden adlandır';

  @override
  String get leaveSharedAlbum => 'Paylaşılan albüm silinsin mi?';

  @override
  String get leaveAlbum => 'Albümü yeniden adlandır';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Eklediğiniz fotoğraflar albümden kaldırılacak';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Her şey zaten temiz, silinecek dosya kalmadı';

  @override
  String get youDontHaveAnyArchivedItems => 'Arşivlenmiş öğeniz yok.';

  @override
  String get ignoredFolderUploadReason =>
      'Bu albümdeki bazı dosyalar daha önce ente\'den silindiğinden yükleme işleminde göz ardı edildi.';

  @override
  String get resetIgnoredFiles => 'Yok sayılan dosyaları sıfırla';

  @override
  String get deviceFilesAutoUploading =>
      'Bu cihazın albümüne eklenen dosyalar otomatik olarak ente\'ye yüklenecektir.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Bu cihaz klasörüne eklenen dosyaları otomatik olarak ente\'ye yüklemek için yedeklemeyi açın.';

  @override
  String get noHiddenPhotosOrVideos => 'Gizli fotoğraf veya video yok';

  @override
  String get toHideAPhotoOrVideo => 'Bir fotoğrafı veya videoyu gizlemek için';

  @override
  String get openTheItem => '• Öğeyi açın';

  @override
  String get clickOnTheOverflowMenu => '• Taşma menüsüne tıklayın';

  @override
  String get click => '• Tıklamak';

  @override
  String get nothingToSeeHere => 'Burada görülecek bir şey yok! 👀';

  @override
  String get unarchiveAlbum => 'Arşivden Çıkar';

  @override
  String get archiveAlbum => 'Albümü arşivle';

  @override
  String get calculating => 'Hesaplanıyor...';

  @override
  String get pleaseWaitDeletingAlbum => 'Lütfen bekleyin, albüm siliniyor';

  @override
  String get searchByExamples =>
      '• Albüm adları (ör. \"Kamera\")\n• Dosya türleri (ör. \"Videolar\", \".gif\")\n• Yıllar ve aylar (ör. \"2022\", \"Ocak\")\n• Tatiller (ör. \"Noel\")\n• Fotoğraf açıklamaları (ör. \"#eğlence\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Farklı bir sorgu aramayı deneyebilirsiniz.';

  @override
  String get noResultsFound => 'Hiçbir sonuç bulunamadı';

  @override
  String addedBy({required Object emailOrName}) {
    return '$emailOrName tarafından eklendi';
  }

  @override
  String get loadingExifData => 'EXIF verileri yükleniyor...';

  @override
  String get viewAllExifData => 'Tüm EXIF verilerini görüntüle';

  @override
  String get noExifData => 'EXIF verisi yok';

  @override
  String get thisImageHasNoExifData => 'Bu görselde exif verisi yok';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Sonuç bulunamadı';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Henüz sahibi olmadığınız fotoğraf ve albümlerin düzenlenmesini desteklemiyoruz';

  @override
  String get failedToFetchOriginalForEdit =>
      'Düzenleme için orijinal getirilemedi';

  @override
  String get close => 'Kapat';

  @override
  String get setAs => 'Şu şekilde ayarla';

  @override
  String get fileSavedToGallery => 'Video galeriye kaydedildi';

  @override
  String get filesSavedToGallery => 'Dosyalar galeriye kaydedildi';

  @override
  String get fileFailedToSaveToGallery => 'Dosya galeriye kaydedilemedi';

  @override
  String get download => 'İndir';

  @override
  String get pressAndHoldToPlayVideo => 'Videoları yönetmek için basılı tutun';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Videoyu oynatmak için resmi basılı tutun';

  @override
  String get downloadFailed => 'İndirme başarısız';

  @override
  String get deduplicateFiles => 'Dosyaları Tekilleştirme';

  @override
  String get deselectAll => 'Tüm seçimi kaldır';

  @override
  String get reviewDeduplicateItems =>
      'Lütfen kopya olduğunu düşündüğünüz öğeleri inceleyin ve silin.';

  @override
  String get clubByCaptureTime => 'Yakalama zamanına göre kulüp';

  @override
  String get clubByFileName => 'Dosya adına göre kulüp';

  @override
  String get count => 'Miktar';

  @override
  String get totalSize => 'Toplam boyut';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Tam ekranda görüntülemek için bir öğeye uzun basın';

  @override
  String get decryptingVideo => 'Videonun şifresi çözülüyor...';

  @override
  String get authToViewYourMemories =>
      'Kodlarınızı görmek için lütfen kimlik doğrulaması yapın';

  @override
  String get unlock => 'Kilidi aç';

  @override
  String get freeUpSpace => 'Boş alan';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Cihazdan silinerek $formattedSize boşaltılabilirler',
      one: 'Cihazdan silinerek $formattedSize boşaltılabilir',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber dosya',
      one: '1 file',
    );
    return 'Bu albümdeki $_temp0 güvenli bir şekilde yedeklendi';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber dosya',
      one: '1 file',
    );
    return 'Bu cihazdaki $_temp0 güvenli bir şekilde yedeklendi';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'onlara',
      one: 'ona',
    );
    return 'Aktif bir aboneliğiniz olduğu sürece Ente üzerinden $_temp0 hâlâ erişebilirsiniz';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return '$sizeInMBorGB yer açın';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Bu e-posta zaten kullanılıyor';

  @override
  String get incorrectCode => 'Yanlış kod';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Kimlik doğrulama başarısız oldu, lütfen tekrar deneyin';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Doğrulama başarısız oldu, lütfen tekrar deneyin';

  @override
  String get authenticating => 'Kimlik doğrulanıyor...';

  @override
  String get authenticationSuccessful => 'Kimlik doğrulama başarılı!';

  @override
  String get incorrectRecoveryKey => 'Yanlış kurtarma kodu';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Girdiğiniz kurtarma kodu yanlış';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'İki faktörlü kimlik doğrulama başarıyla sıfırlandı';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Lütfen girdiğiniz kodu doğrulayın';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Bu hata devam ederse lütfen desteğe başvurun';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'İki faktörlü kimlik doğrulama devre dışı';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Üzgünüz, girdiğiniz kod yanlış';

  @override
  String get yourVerificationCodeHasExpired =>
      'Doğrulama kodunuzun süresi doldu';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'E-posta $newEmail olarak değiştirildi';
  }

  @override
  String get verifying => 'Doğrulanıyor...';

  @override
  String get disablingTwofactorAuthentication =>
      'İki aşamalı doğrulamayı devre dışı bırak...';

  @override
  String get allMemoriesPreserved => 'Tüm anılar saklandı';

  @override
  String get loadingGallery => 'Galeri yükleniyor...';

  @override
  String get syncing => 'Eşitleniyor...';

  @override
  String get encryptingBackup => 'Yedekleme şifreleniyor...';

  @override
  String get syncStopped => 'Senkronizasyon durduruldu';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total anı korundu';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return '$count anı korunuyor...';
  }

  @override
  String get uploadingSingleMemory => '1 anı korunuyor...';

  @override
  String get archiving => 'Arşivleniyor...';

  @override
  String get unarchiving => 'Arşivden çıkarılıyor...';

  @override
  String get successfullyArchived => 'Başarıyla arşivlendi';

  @override
  String get successfullyUnarchived => 'Başarıyla arşivden çıkarıldı';

  @override
  String get renameFile => 'Dosyayı yeniden adlandır';

  @override
  String get enterFileName => 'Dosya adını girin';

  @override
  String get filesDeleted => 'Dosyalar silinmiş';

  @override
  String get selectedFilesAreNotOnEnte => 'Seçilen dosyalar Ente\'de değil';

  @override
  String get thisActionCannotBeUndone => 'Bu eylem geri alınamaz';

  @override
  String get emptyTrash => 'Çöp kutusu boşaltılsın mı?';

  @override
  String get permDeleteWarning =>
      'Çöp kutusundaki tüm öğeler kalıcı olarak silinecek\n\nBu işlem geri alınamaz';

  @override
  String get empty => 'Boşalt';

  @override
  String get couldNotFreeUpSpace => 'Yer boşaltılamadı';

  @override
  String get permanentlyDeleteFromDevice =>
      'Cihazdan kalıcı olarak silinsin mi?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Silmeye çalıştığınız dosyalardan bazıları yalnızca cihazınızda mevcuttur ve silindiği takdirde kurtarılamaz';

  @override
  String get theyWillBeDeletedFromAllAlbums => 'Tüm albümlerden silinecek.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Bazı öğeler hem Ente\'de hem de cihazınızda bulunur.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Seçilen öğeler tüm albümlerden silinecek ve çöp kutusuna taşınacak.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Bu öğeler cihazınızdan silinecektir.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Bir şeyler ters gitmiş gibi görünüyor. Lütfen bir süre sonra tekrar deneyin. Hata devam ederse, lütfen destek ekibimizle iletişime geçin.';

  @override
  String get error => 'Hata';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Bir şeyler ters gitmiş gibi görünüyor. Lütfen bir süre sonra tekrar deneyin. Hata devam ederse, lütfen destek ekibimizle iletişime geçin.';

  @override
  String get networkHostLookUpErr =>
      'Ente\'ye bağlanılamıyor. Lütfen ağ ayarlarınızı kontrol edin ve hata devam ederse destek ekibiyle iletişime geçin.';

  @override
  String get networkConnectionRefusedErr =>
      'Ente\'ye bağlanılamıyor. Lütfen bir süre sonra tekrar deneyin. Hata devam ederse lütfen desteğe başvurun.';

  @override
  String get cachedData => 'Önbelleğe alınmış veriler';

  @override
  String get clearCaches => 'Önbelleği temizle';

  @override
  String get remoteImages => 'Uzak Görseller';

  @override
  String get remoteVideos => 'Uzak Videolar';

  @override
  String get remoteThumbnails => 'Uzak Küçük Resimler';

  @override
  String get pendingSync => 'Bekleyen Senkronizasyonlar';

  @override
  String get localGallery => 'Yerel galeri';

  @override
  String get todaysLogs => 'Bugünün kayıtları';

  @override
  String get viewLogs => 'Kayıtları görüntüle';

  @override
  String get logsDialogBody =>
      'Bu, sorununuzu gidermemize yardımcı olmak için kayıtları gönderecektir. Belirli dosyalarla ilgili sorunların izlenmesine yardımcı olmak için dosya adlarının ekleneceğini lütfen unutmayın.';

  @override
  String get preparingLogs => 'Kayıtlar hazırlanıyor...';

  @override
  String get emailYourLogs => 'Kayıtlarınızı e-postayla gönderin';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Lütfen kayıtları şu adrese gönderin\n$toEmail';
  }

  @override
  String get copyEmailAddress => 'E-posta adresini kopyala';

  @override
  String get exportLogs => 'Günlüğü dışa aktar';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Lütfen bize $toEmail adresinden ulaşın';
  }

  @override
  String get dismiss => 'Reddet';

  @override
  String get didYouKnow => 'Biliyor musun?';

  @override
  String get loadingMessage => 'Fotoğraflarınız yükleniyor...';

  @override
  String get loadMessage1 => 'Aboneliğinizi ailenizle paylaşabilirsiniz';

  @override
  String get loadMessage2 => 'Şimdiye kadar 200 milyondan fazla anıyı koruduk';

  @override
  String get loadMessage3 =>
      'Verilerinizin 3 kopyasını saklıyoruz, biri yer altı serpinti sığınağında';

  @override
  String get loadMessage4 => 'Tüm uygulamalarımız açık kaynaktır';

  @override
  String get loadMessage5 =>
      'Kaynak kodumuz ve şifrelememiz harici olarak denetlenmiştir';

  @override
  String get loadMessage6 =>
      'Albümlerinizin bağlantılarını sevdiklerinizle paylaşabilirsiniz';

  @override
  String get loadMessage7 =>
      'Mobil uygulamalarımız, tıkladığınız yeni fotoğrafları şifrelemek ve yedeklemek için arka planda çalışır';

  @override
  String get loadMessage8 => 'web.ente.io\'nun mükemmel bir yükleyicisi var';

  @override
  String get loadMessage9 =>
      'Verilerinizi güvenli bir şekilde şifrelemek için Xchacha20Poly1305 kullanıyoruz';

  @override
  String get photoDescriptions => 'Fotoğraf Açıklaması';

  @override
  String get fileTypesAndNames => 'Dosya türleri ve adları';

  @override
  String get location => 'Konum';

  @override
  String get moments => 'Anlar';

  @override
  String get searchFaceEmptySection =>
      'Dizinleme yapıldıktan sonra insanlar burada gösterilecek';

  @override
  String get searchDatesEmptySection =>
      'Tarihe, aya veya yıla göre arama yapın';

  @override
  String get searchLocationEmptySection =>
      'Bir fotoğrafın belli bir yarıçapında çekilen fotoğrafları gruplandırın';

  @override
  String get searchPeopleEmptySection =>
      'İnsanları davet ettiğinizde onların paylaştığı tüm fotoğrafları burada göreceksiniz';

  @override
  String get searchAlbumsEmptySection => 'Albümler';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Dosya türleri ve adları';

  @override
  String get searchCaptionEmptySection =>
      'Fotoğraf bilgilerini burada hızlı bir şekilde bulmak için \"#trip\" gibi açıklamalar ekleyin';

  @override
  String get language => 'Dil';

  @override
  String get selectLanguage => 'Dil Seçin';

  @override
  String get locationName => 'Konum Adı';

  @override
  String get addLocation => 'Konum Ekle';

  @override
  String get groupNearbyPhotos => 'Yakındaki fotoğrafları gruplandır';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Ekle';

  @override
  String get radius => 'Yarıçap';

  @override
  String get locationTagFeatureDescription =>
      'Bir fotoğrafın belli bir yarıçapında çekilen fotoğrafları gruplandırın';

  @override
  String get galleryMemoryLimitInfo => 'Galeride 1000\'e kadar anı gösterilir';

  @override
  String get save => 'Kaydet';

  @override
  String get centerPoint => 'Merkez noktası';

  @override
  String get pickCenterPoint => 'Merkez noktasını seçin';

  @override
  String get useSelectedPhoto => 'Seçilen fotoğrafı kullan';

  @override
  String get resetToDefault => 'Varsayılana sıfırla';

  @override
  String get edit => 'Düzenle';

  @override
  String get deleteLocation => 'Konumu sil';

  @override
  String get rotateLeft => 'Sola döndür';

  @override
  String get flip => 'Çevir';

  @override
  String get rotateRight => 'Sağa döndür';

  @override
  String get saveCopy => 'Kopyasını kaydet';

  @override
  String get light => 'Aydınlık';

  @override
  String get color => 'Renk';

  @override
  String get yesDiscardChanges => 'Evet, değişiklikleri sil';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Yaptığınız düzenlemeleri silmek istiyor musunuz?';

  @override
  String get saving => 'Kaydediliyor...';

  @override
  String get editsSaved => 'Düzenleme kaydedildi';

  @override
  String get oopsCouldNotSaveEdits => 'Hata! Düzenlemeler kaydedilemedi';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Bugün';

  @override
  String get dayYesterday => 'Dün';

  @override
  String get storage => 'Depolama';

  @override
  String get usedSpace => 'Kullanılan alan';

  @override
  String get storageBreakupFamily => 'Aile';

  @override
  String get storageBreakupYou => 'Sen';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit / $totalAmount $totalStorageUnit kullanıldı';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit ücretsiz';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Sürüm: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Doğrula';

  @override
  String get fileInfoAddDescHint => 'Bir açıklama ekle...';

  @override
  String get editLocationTagTitle => 'Konumu düzenle';

  @override
  String get setLabel => 'Ayarla';

  @override
  String get setRadius => 'Yarıçapı ayarla';

  @override
  String get familyPlanPortalTitle => 'Aile';

  @override
  String get familyPlanOverview =>
      'Ekstra ödeme yapmadan mevcut planınıza 5 aile üyesi ekleyin.\n\nHer üyenin kendine ait özel alanı vardır ve paylaşılmadıkça birbirlerinin dosyalarını göremezler.\n\nAile planları ücretli ente aboneliğine sahip müşteriler tarafından kullanılabilir.\n\nBaşlamak için şimdi abone olun!';

  @override
  String get androidBiometricHint => 'Kimliği doğrula';

  @override
  String get androidBiometricNotRecognized => 'Tanınmadı. Tekrar deneyin.';

  @override
  String get androidBiometricSuccess => 'Başarılı';

  @override
  String get androidCancelButton => 'İptal et';

  @override
  String get androidSignInTitle => 'Kimlik doğrulaması gerekli';

  @override
  String get androidBiometricRequiredTitle => 'Biyometrik gerekli';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Cihaz kimlik bilgileri gerekli';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Cihaz kimlik bilgileri gerekmekte';

  @override
  String get goToSettings => 'Ayarlara git';

  @override
  String get androidGoToSettingsDescription =>
      'Biyometrik kimlik doğrulama cihazınızda ayarlanmamış. Biyometrik kimlik doğrulama eklemek için \'Ayarlar > Güvenlik\' bölümüne gidin.';

  @override
  String get iOSLockOut =>
      'Biyometrik kimlik doğrulama devre dışı. Etkinleştirmek için lütfen ekranınızı kilitleyin ve kilidini açın.';

  @override
  String get iOSGoToSettingsDescription =>
      'Cihazınızda biyometrik kimlik doğrulama ayarlanmamış. Lütfen telefonunuzda Touch ID veya Face ID\'yi etkinleştirin.';

  @override
  String get iOSOkButton => 'Tamam';

  @override
  String get openstreetmapContributors => 'OpenStreetMap katkıda bululanlar';

  @override
  String get hostedAtOsmFrance => 'OSM Fransa\'da ağırlandı';

  @override
  String get map => 'Harita';

  @override
  String get maps => 'Haritalar';

  @override
  String get mapsPrivacyNotice =>
      'Yaklaşık yer blgileri haritayı ve konumu göstermek için OpenStreetMap gibi gizlilik bilincine sahip üçüncü taraflara gönderilecektir.';

  @override
  String get enableMaps => 'Haritaları Etkinleştir';

  @override
  String get quickLinks => 'Hızlı Erişim';

  @override
  String get selectItemsToAdd => 'Eklenecek eşyaları seçin';

  @override
  String get addSelected => 'Seçileni ekle';

  @override
  String get addFromDevice => 'Cihazdan ekle';

  @override
  String get addPhotos => 'Fotoğraf ekle';

  @override
  String get noPhotosFoundHere => 'Burada fotoğraf bulunamadı';

  @override
  String get zoomOutToSeePhotos => 'Fotoğrafları görmek için uzaklaştırın';

  @override
  String get noImagesWithLocation => 'Konum içeren resim yok';

  @override
  String get unpinAlbum => 'Albümün sabitlemesini kaldır';

  @override
  String get pinAlbum => 'Albümü sabitle';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Oluştur';

  @override
  String get viewAll => 'Tümünü görüntüle';

  @override
  String get nothingSharedWithYouYet => 'Henüz sizinle paylaşılan bir şey yok';

  @override
  String get noAlbumsSharedByYouYet => 'Henüz paylaştığınız albüm yok';

  @override
  String get sharedWithYou => 'Sizinle paylaşıldı';

  @override
  String get sharedByYou => 'Paylaştıklarınız';

  @override
  String get inviteYourFriendsToEnte =>
      'Katılmaları için arkadaşlarınızı davet edin';

  @override
  String get failedToDownloadVideo => 'Video indirilemedi';

  @override
  String get hiding => 'Gizleniyor...';

  @override
  String get unhiding => 'Gösteriliyor...';

  @override
  String get successfullyHid => 'Başarıyla saklandı';

  @override
  String get successfullyUnhid => 'Başarıyla arşivden çıkarıldı';

  @override
  String get crashReporting => 'Çökme raporlaması';

  @override
  String get resumableUploads => 'Devam edilebilir yüklemeler';

  @override
  String get addToHiddenAlbum => 'Gizli albüme ekle';

  @override
  String get moveToHiddenAlbum => 'Gizli albüme ekle';

  @override
  String get fileTypes => 'Dosya türü';

  @override
  String get deleteConfirmDialogBody =>
      'Kullandığınız Ente uygulamaları varsa bu hesap diğer Ente uygulamalarıyla bağlantılıdır. Tüm Ente uygulamalarına yüklediğiniz veriler ve hesabınız kalıcı olarak silinecektir.';

  @override
  String get hearUsWhereTitle => 'Ente\'yi nereden duydunuz? (isteğe bağlı)';

  @override
  String get hearUsExplanation =>
      'Biz uygulama kurulumlarını takip etmiyoruz. Bizi nereden duyduğunuzdan bahsetmeniz bize çok yardımcı olacak!';

  @override
  String get viewAddOnButton => 'Eklentileri görüntüle';

  @override
  String get addOns => 'Eklentiler';

  @override
  String get addOnPageSubtitle => 'Eklentilerin ayrıntıları';

  @override
  String get yourMap => 'Haritalarınız';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Sorgunuzu değiştirin veya aramayı deneyin';

  @override
  String get blackFridaySale => 'Muhteşem Cuma kampanyası';

  @override
  String get upto50OffUntil4thDec => '4 Aralık\'a kadar %50\'ye varan indirim.';

  @override
  String get photos => 'Fotoğraflar';

  @override
  String get videos => 'Videolar';

  @override
  String get livePhotos => 'Canlı Fotoğraf';

  @override
  String get searchHint1 => 'Hızlı, cihaz üzerinde arama';

  @override
  String get searchHint2 => 'Fotoğraf tarihleri, açıklamalar';

  @override
  String get searchHint3 => 'Albümler, dosya adları ve türleri';

  @override
  String get searchHint4 => 'Konum';

  @override
  String get searchHint5 => 'Çok yakında: Yüzler ve sihirli arama ✨';

  @override
  String get addYourPhotosNow => 'Fotoğraflarınızı şimdi ekleyin';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count yıl önce',
      one: '$count yıl önce',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Yüzler';

  @override
  String get people => 'Kişiler';

  @override
  String get contents => 'İçerikler';

  @override
  String get addNew => 'Yeni ekle';

  @override
  String get contacts => 'Kişiler';

  @override
  String get noInternetConnection => 'İnternet bağlantısı yok';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Lütfen internet bağlantınızı kontrol edin ve yeniden deneyin.';

  @override
  String get signOutFromOtherDevices => 'Diğer cihazlardan çıkış yap';

  @override
  String get signOutOtherBody =>
      'Eğer başka birisinin parolanızı bildiğini düşünüyorsanız, diğer tüm cihazları hesabınızdan çıkışa zorlayabilirsiniz.';

  @override
  String get signOutOtherDevices => 'Diğer cihazlardan çıkış yap';

  @override
  String get doNotSignOut => 'Çıkış yapma';

  @override
  String get editLocation => 'Konumu düzenle';

  @override
  String get selectALocation => 'Bir konum seçin';

  @override
  String get selectALocationFirst => 'Önce yeni yer seçin';

  @override
  String get changeLocationOfSelectedItems =>
      'Seçilen öğelerin konumu değiştirilsin mi?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Konumda yapılan düzenlemeler yalnızca Ente\'de görülecektir';

  @override
  String get cleanUncategorized => 'Temiz Genel';

  @override
  String get cleanUncategorizedDescription =>
      'Diğer albümlerde bulunan Kategorilenmemiş tüm dosyaları kaldırın';

  @override
  String get waitingForVerification => 'Doğrulama bekleniyor...';

  @override
  String get passkey => 'Geçiş anahtarı';

  @override
  String get passkeyAuthTitle => 'Geçiş anahtarı doğrulaması';

  @override
  String get loginWithTOTP => 'TOTP ile giriş yap';

  @override
  String get passKeyPendingVerification => 'Doğrulama hala bekliyor';

  @override
  String get loginSessionExpired => 'Oturum süresi doldu';

  @override
  String get loginSessionExpiredDetails =>
      'Oturum süreniz doldu. Tekrar giriş yapın.';

  @override
  String get verifyPasskey => 'Şifrenizi doğrulayın';

  @override
  String get playOnTv => 'Albümü TV\'de oynat';

  @override
  String get pair => 'Eşleştir';

  @override
  String get deviceNotFound => 'Cihaz bulunamadı';

  @override
  String get castInstruction =>
      'Eşleştirmek istediğiniz cihazda cast.ente.io adresini ziyaret edin.\n\nAlbümü TV\'nizde oynatmak için aşağıdaki kodu girin.';

  @override
  String get deviceCodeHint => 'Kodu girin';

  @override
  String get joinDiscord => 'Discord\'a Katıl';

  @override
  String get locations => 'Konum';

  @override
  String get addAName => 'Bir Ad Ekle';

  @override
  String get findThemQuickly => 'Çabucak bulun';

  @override
  String get findPeopleByName => 'Kişileri isimlerine göre bulun';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Görüntüleyen ekle',
      one: 'Görüntüleyen ekle',
      zero: 'Görüntüleyen ekle',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ortak çalışan ekle',
      one: 'Ortak çalışan ekle',
      zero: 'Ortak çalışan ekle',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Uçtan uca şifrelemeyi doğrulamak için bir e-postaya uzun basın.';

  @override
  String get developerSettingsWarning =>
      'Geliştirici ayarlarını değiştirmek istediğinizden emin misiniz?';

  @override
  String get developerSettings => 'Geliştirici ayarları';

  @override
  String get serverEndpoint => 'Sunucu uç noktası';

  @override
  String get invalidEndpoint => 'Geçersiz uç nokta';

  @override
  String get invalidEndpointMessage =>
      'Üzgünüz, girdiğiniz uç nokta geçersiz. Lütfen geçerli bir uç nokta girin ve tekrar deneyin.';

  @override
  String get endpointUpdatedMessage => 'Fatura başarıyla güncellendi';

  @override
  String customEndpoint({required Object endpoint}) {
    return '$endpoint\'e bağlanıldı';
  }

  @override
  String get createCollaborativeLink => 'Ortak bağlantı oluşturun';

  @override
  String get search => 'Ara';

  @override
  String get enterPersonName => 'Kişi ismini giriniz';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Bu e-posta zaten $name kişisine bağlı.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Bağlantıyı kaldırmak için $name kişisini görüntüle';
  }

  @override
  String get enterName => 'İsim girin';

  @override
  String get savePerson => 'Kişiyi kaydet';

  @override
  String get editPerson => 'Kişiyi düzenle';

  @override
  String get mergedPhotos => 'Birleştirilmiş fotoğraflar';

  @override
  String get orMergeWithExistingPerson => 'Ya da mevcut olan ile birleştirin';

  @override
  String get enterDateOfBirth => 'Doğum Günü (isteğe bağlı)';

  @override
  String get birthday => 'Doğum Günü';

  @override
  String get removePersonLabel => 'Kişi etiketini kaldırın';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'Otomatik eşleştirme yalnızca Chromecast destekleyen cihazlarla çalışır.';

  @override
  String get manualPairDesc =>
      'PIN ile eşleştirme, albümünüzü görüntülemek istediğiniz herhangi bir ekranla çalışır.';

  @override
  String get connectToDevice => 'Cihaza bağlanın';

  @override
  String get autoCastDialogBody =>
      'Mevcut Cast cihazlarını burada görebilirsiniz.';

  @override
  String get autoCastiOSPermission =>
      'Ayarlar\'da Ente Photos uygulaması için Yerel Ağ izinlerinin açık olduğundan emin olun.';

  @override
  String get noDeviceFound => 'Aygıt bulunamadı';

  @override
  String get stopCastingTitle => 'Yayını durdur';

  @override
  String get stopCastingBody => 'Yansıtmayı durdurmak istiyor musunuz?';

  @override
  String get castIPMismatchTitle => 'Albüm yüklenirken hata oluştu';

  @override
  String get castIPMismatchBody =>
      'Lütfen TV ile aynı ağda olduğunuzdan emin olun.';

  @override
  String get pairingComplete => 'Eşleştirme tamamlandı';

  @override
  String get savingEdits => 'Düzenlemeler kaydediliyor...';

  @override
  String get autoPair => 'Otomatik eşle';

  @override
  String get pairWithPin => 'PIN ile eşleştirin';

  @override
  String get faceRecognition => 'Yüz Tanıma';

  @override
  String get foundFaces => 'Yüzler bulundu';

  @override
  String get clusteringProgress => 'Kümeleme ilerlemesi';

  @override
  String get trim => 'Kes';

  @override
  String get crop => 'Kırp';

  @override
  String get rotate => 'Döndür';

  @override
  String get left => 'Sol';

  @override
  String get right => 'Sağ';

  @override
  String get whatsNew => 'Yenilikler';

  @override
  String get reviewSuggestions => 'Önerileri inceleyin';

  @override
  String get review => 'Gözden Geçir';

  @override
  String get useAsCover => 'Kapak olarak kullanın';

  @override
  String notPersonLabel({required String name}) {
    return '$name değil mi?';
  }

  @override
  String get enable => 'Etkinleştir';

  @override
  String get enabled => 'Etkin';

  @override
  String get moreDetails => 'Daha fazla detay';

  @override
  String get enableMLIndexingDesc =>
      'Ente, yüz tanıma, sihirli arama ve diğer gelişmiş arama özellikleri için cihaz üzerinde çalışan makine öğrenimini kullanır';

  @override
  String get magicSearchHint =>
      'Sihirli arama, fotoğrafları içeriklerine göre aramanıza olanak tanır, örneğin \'çiçek\', \'kırmızı araba\', \'kimlik belgeleri\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Şifrenizi tekrar girin';

  @override
  String get reenterPin => 'PIN\'inizi tekrar girin';

  @override
  String get deviceLock => 'Cihaz kilidi';

  @override
  String get pinLock => 'Pin kilidi';

  @override
  String get next => 'Sonraki';

  @override
  String get setNewPassword => 'Yeni şifre belirle';

  @override
  String get enterPin => 'PIN Girin';

  @override
  String get setNewPin => 'Yeni PIN belirleyin';

  @override
  String get appLock => 'Uygulama kilidi';

  @override
  String get noSystemLockFound => 'Sistem kilidi bulunamadı';

  @override
  String get tapToUnlock => 'Açmak için dokun';

  @override
  String get tooManyIncorrectAttempts => 'Çok fazla hatalı deneme';

  @override
  String get videoInfo => 'Video Bilgileri';

  @override
  String get autoLock => 'Otomatik Kilit';

  @override
  String get immediately => 'Hemen';

  @override
  String get autoLockFeatureDescription =>
      'Uygulama arka plana geçtikten sonra kilitleneceği süre';

  @override
  String get hideContent => 'İçeriği gizle';

  @override
  String get hideContentDescriptionAndroid =>
      'Uygulama değiştiricide bulunan uygulama içeriğini gizler ve ekran görüntülerini devre dışı bırakır';

  @override
  String get hideContentDescriptionIos =>
      'Uygulama değiştiricideki uygulama içeriğini gizler';

  @override
  String get passwordStrengthInfo =>
      'Parola gücü, parolanın uzunluğu, kullanılan karakterler ve parolanın en çok kullanılan ilk 10.000 parola arasında yer alıp almadığı dikkate alınarak hesaplanır';

  @override
  String get noQuickLinksSelected => 'Hızlı bağlantılar seçilmedi';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Lütfen kaldırmak için hızlı bağlantıları seçin';

  @override
  String get removePublicLinks => 'Herkese açık bağlantıları kaldır';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Bu, seçilen tüm hızlı bağlantıların genel bağlantılarını kaldıracaktır.';

  @override
  String get guestView => 'Misafir Görünümü';

  @override
  String get guestViewEnablePreSteps =>
      'Misafir görünümünü etkinleştirmek için lütfen sistem ayarlarınızda cihaz şifresi veya ekran kilidi ayarlayın.';

  @override
  String get nameTheAlbum => 'Albüm İsmi';

  @override
  String get collectPhotosDescription =>
      'Arkadaşlarınızın orijinal kalitede fotoğraf yükleyebileceği bir bağlantı oluşturun.';

  @override
  String get collect => 'Topla';

  @override
  String get appLockDescriptions =>
      'Cihazınızın varsayılan kilit ekranı ile PIN veya parola içeren özel bir kilit ekranı arasında seçim yapın.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Uygulama kilidini etkinleştirmek için lütfen sistem ayarlarınızda cihaz şifresi veya ekran kilidi ayarlayın.';

  @override
  String get authToViewPasskey =>
      'Geçiş anahtarınızı görüntülemek için lütfen kimlik doğrulaması yapın';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Yerel fotoğraf senkronizasyonu beklenenden daha uzun sürdüğü için bir şeyler ters gitmiş gibi görünüyor. Lütfen destek ekibimize ulaşın';

  @override
  String get showPerson => 'Kişiyi Göster';

  @override
  String get sort => 'Sırala';

  @override
  String get mostRecent => 'En son';

  @override
  String get mostRelevant => 'En alakalı';

  @override
  String get loadingYourPhotos => 'Fotoğraflarınız yükleniyor...';

  @override
  String processingImport({required Object folderName}) {
    return 'İşleniyor $folderName...';
  }

  @override
  String get personName => 'Kişi Adı';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Yeni kişi ekle';

  @override
  String get addNameOrMerge => 'İsim ekleyin veya birleştirin';

  @override
  String get mergeWithExisting => 'Var olan ile birleştir.';

  @override
  String get newPerson => 'Yeni Kişi';

  @override
  String get addName => 'İsim Ekle';

  @override
  String get add => 'Ekle';

  @override
  String extraPhotosFoundFor({required String text}) {
    return '$text için ekstra fotoğraflar bulundu';
  }

  @override
  String get extraPhotosFound => 'Ekstra fotoğraflar bulundu';

  @override
  String get configuration => 'Yapılandırma';

  @override
  String get localIndexing => 'Yerel dizinleme';

  @override
  String get processed => 'İşlenen';

  @override
  String get resetPerson => 'Kaldır';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Bu kişiyi sıfırlamak istediğinden emin misiniz?';

  @override
  String get allPersonGroupingWillReset =>
      'Bu kişi için tüm gruplamalar sıfırlanacak ve bu kişi için yaptığınız tüm önerileri kaybedeceksiniz';

  @override
  String get yesResetPerson => 'Evet, kişiyi sıfırla';

  @override
  String get onlyThem => 'Sadece onlar';

  @override
  String get checkingModels => 'Modeller kontrol ediliyor...';

  @override
  String get enableMachineLearningBanner =>
      'Sihirli arama ve yüz tanıma için makine öğrenimini etkinleştirin';

  @override
  String get searchDiscoverEmptySection =>
      'İşleme ve senkronizasyon tamamlandığında görüntüler burada gösterilecektir';

  @override
  String get searchPersonsEmptySection =>
      'İşleme ve senkronizasyon tamamlandığında kişiler burada gösterilecektir';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count izleyici eklendi',
      one: '1 izleyici eklendi',
      zero: '0 izleyici eklendi',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count işbirlikçi eklendi',
      one: '1 işbirlikçi eklendi',
      zero: '0 işbirlikçi eklendi',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Hesap zaten yapılandırılmıştır.';

  @override
  String get sessionIdMismatch => 'Oturum kimliği uyuşmazlığı';

  @override
  String get failedToFetchActiveSessions => 'Etkin oturumlar getirilemedi';

  @override
  String get failedToRefreshStripeSubscription => 'Abonelik yenilenemedi';

  @override
  String get failedToPlayVideo => 'Video oynatılamadı';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Yükleme $ignoreReason nedeniyle yok sayıldı';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Galeri türü $galleryType yeniden adlandırma için desteklenmiyor';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Yüklemek için dokunun, yükleme şu anda $ignoreReason nedeniyle yok sayılıyor';
  }

  @override
  String get tapToUpload => 'Yüklemek için tıklayın';

  @override
  String get info => 'Bilgi';

  @override
  String get addFiles => 'Dosyaları Ekle';

  @override
  String get castAlbum => 'Yayın albümü';

  @override
  String get imageNotAnalyzed => 'Görüntü analiz edilmedi';

  @override
  String get noFacesFound => 'Yüz bulunamadı';

  @override
  String get fileNotUploadedYet => 'Dosya henüz yüklenmedi';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return '$personName için öneri yok';
  }

  @override
  String get month => 'ay';

  @override
  String get yearShort => 'yıl';

  @override
  String get currentlyRunning => 'şu anda çalışıyor';

  @override
  String get ignored => 'yoksayıldı';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotoğraf',
      one: '1 fotoğraf',
      zero: '0 fotoğraf',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Dosya';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Bölüm uzunluğu uyuşmazlığı: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Mail Uygulamasını Seç';

  @override
  String get selectAllShort => 'Tümü';

  @override
  String get selectCoverPhoto => 'Kapak fotoğrafı seçin';

  @override
  String get newLocation => 'Yeni konum';

  @override
  String get faceNotClusteredYet =>
      'Yüz henüz kümelenmedi, lütfen daha sonra tekrar gelin';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Erişmeye çalıştığınız bağlantının süresi dolmuştur.';

  @override
  String get openFile => 'Dosyayı aç';

  @override
  String get backupFile => 'Yedek Dosyası';

  @override
  String get openAlbumInBrowser => 'Albümü tarayıcıda aç';

  @override
  String get openAlbumInBrowserTitle =>
      'Bu albüme fotoğraf eklemek için lütfen web uygulamasını kullanın';

  @override
  String get allow => 'İzin ver';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Uygulamanın paylaşılan albüm bağlantılarını açmasına izin ver';

  @override
  String get seePublicAlbumLinksInApp =>
      'Uygulamadaki herkese açık albüm bağlantılarını görün';

  @override
  String get emergencyContacts => 'Acil Durum İletişim Bilgileri';

  @override
  String get acceptTrustInvite => 'Daveti Kabul Et';

  @override
  String get declineTrustInvite => 'Daveti Reddet';

  @override
  String get removeYourselfAsTrustedContact =>
      'Kendinizi güvenilir kişi olarak kaldırın';

  @override
  String get legacy => 'Geleneksel';

  @override
  String get legacyPageDesc =>
      'Geleneksel yol, güvendiğiniz kişilerin yokluğunuzda hesabınıza erişmesine olanak tanır.';

  @override
  String get legacyPageDesc2 =>
      'Güvenilir kişiler hesap kurtarma işlemini başlatabilir ve 30 gün içinde engellenmezse şifrenizi sıfırlayabilir ve hesabınıza erişebilir.';

  @override
  String get legacyAccounts => 'Geleneksel hesaplar';

  @override
  String get trustedContacts => 'Güvenilir kişiler';

  @override
  String get addTrustedContact => 'Güvenilir kişi ekle';

  @override
  String get removeInvite => 'Davetiyeyi kaldır';

  @override
  String get recoveryWarning =>
      'Güvenilir bir kişi hesabınıza erişmeye çalışıyor';

  @override
  String get rejectRecovery => 'Kurtarmayı reddet';

  @override
  String get recoveryInitiated => 'Kurtarma başlatıldı';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Hesabınıza $days gün sonra erişebilirsiniz. $email adresine bir bildirim gönderilecektir.';
  }

  @override
  String get cancelAccountRecovery => 'Kurtarma işlemini iptal et';

  @override
  String get recoveryAccount => 'Hesabı kurtar';

  @override
  String get cancelAccountRecoveryBody =>
      'Kurtarmayı iptal etmek istediğinize emin misiniz?';

  @override
  String get startAccountRecoveryTitle => 'Kurtarmayı başlat';

  @override
  String get whyAddTrustContact => '.';

  @override
  String recoveryReady({required String email}) {
    return 'Artık yeni bir parola belirleyerek $email hesabını kurtarabilirsiniz.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email hesabınızı kurtarmaya çalışıyor.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return '$email ile eski bir irtibat kişisi olmaya davet edildiniz.';
  }

  @override
  String get warning => 'Uyarı';

  @override
  String get proceed => 'Devam edin';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Güvenilir bir kişi olarak $email eklemek üzeresiniz. Eğer $numOfDays gün boyunca yoksanız hesabınızı kurtarabilecekler.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email sizi güvenilir bir kişi olmaya davet etti';
  }

  @override
  String get authToManageLegacy =>
      'Güvenilir kişilerinizi yönetmek için lütfen kimlik doğrulaması yapın';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Paylaşılan öğeleri ana galeriden gizle';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galeri';

  @override
  String get joinAlbum => 'Albüme Katılın';

  @override
  String get joinAlbumSubtext =>
      'fotoğraflarınızı görüntülemek ve eklemek için';

  @override
  String get joinAlbumSubtextViewer => 'bunu paylaşılan albümlere eklemek için';

  @override
  String get join => 'Katıl';

  @override
  String get linkEmail => 'E-posta bağlantısı';

  @override
  String get link => 'Bağlantı';

  @override
  String get noEnteAccountExclamation => 'Ente hesabı yok!';

  @override
  String get orPickFromYourContacts => 'veya kişilerinizden birini seçin';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email bir Ente hesabına sahip değil';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Ben)';
  }

  @override
  String get reassignMe => '\"Ben\"i yeniden atayın';

  @override
  String get me => 'Ben';

  @override
  String get linkEmailToContactBannerCaption => 'daha hızlı paylaşım için';

  @override
  String get selectPersonToLink => 'Bağlantı kurulacak kişiyi seçin';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Kişiyi $email adresine bağlayın';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Bu, $personName ile $email arasında bağlantı kuracaktır.';
  }

  @override
  String get selectYourFace => 'Yüzünüzü seçin';

  @override
  String get reassigningLoading => 'Yeniden atanıyor...';

  @override
  String reassignedToName({required String name}) {
    return 'Sizi $name\'e yeniden atadı';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Çıkmadan önce değişiklikler kaydedilsin mi?';

  @override
  String get dontSave => 'Kaydetme';

  @override
  String get thisIsMeExclamation => 'Bu benim!';

  @override
  String get linkPerson => 'Kişiyi bağla';

  @override
  String get linkPersonCaption => 'daha iyi paylaşım deneyimi için';

  @override
  String get videoStreaming => 'Akışlandırılabilir videolar';

  @override
  String get processingVideos => 'Videolar işleniyor';

  @override
  String get streamDetails => 'Akış detayları';

  @override
  String get processing => 'İşleniyor';

  @override
  String get queued => 'Kuyrukta';

  @override
  String get ineligible => 'Uygun Değil';

  @override
  String get failed => 'Başarısız oldu';

  @override
  String get playStream => 'Akışı oynat';

  @override
  String get playOriginal => 'Orijinali oynat';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Bir albüme katılmak, e-postanızın katılımcılar tarafından görülebilmesini sağlayacaktır.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Lütfen bekleyin, bu biraz zaman alabilir.';

  @override
  String get editTime => 'Zamanı düzenle';

  @override
  String get selectTime => 'Zaman Seç';

  @override
  String get selectDate => 'Tarih seç';

  @override
  String get previous => 'Önceki';

  @override
  String get selectOneDateAndTimeForAll =>
      'Tümü için tek bir tarih ve saat seçin';

  @override
  String get selectStartOfRange => 'Aralık başlangıcını seçin';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Bu, seçilen tüm fotoğrafların tarih ve saatini aynı yapacaktır.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Bu, gruptaki ilk fotoğraftır. Seçilen diğer fotoğraflar otomatik olarak bu yeni tarihe göre kaydırılacaktır';

  @override
  String get newRange => 'Yeni aralık';

  @override
  String get selectOneDateAndTime => 'Bir tarih ve saat seçin';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Seçilen fotoğrafları bir tarihe taşıma';

  @override
  String get shiftDatesAndTime => 'Vardiya tarihleri ve saati';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Fotoğraflar göreli zaman farkını korur';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotoğraf',
      one: '1 fotoğraf',
      zero: 'Fotoğraf yok',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Uygulama simgesi';

  @override
  String get notThisPerson => 'Bu kişi değil mi?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Seçili öğeler bu kişiden silinir, ancak kitaplığınızdan silinmez.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat yıllar boyunca';
  }

  @override
  String get thisWeekThroughTheYears => 'Yıllar boyunca bu hafta';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Bu hafta, $count yıl önce',
      one: 'Bu hafta, $count yıl önce',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Sen ve $name';
  }

  @override
  String admiringThem({required Object name}) {
    return '$name\'e hayran kalmak';
  }

  @override
  String embracingThem({required Object name}) {
    return '$name\'e sarılmak';
  }

  @override
  String partyWithThem({required Object name}) {
    return '$name ile parti';
  }

  @override
  String hikingWithThem({required Object name}) {
    return '$name ile doğa yürüyüşü';
  }

  @override
  String feastingWithThem({required Object name}) {
    return '$name ile ziyafet';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return '$name ile selfieler';
  }

  @override
  String posingWithThem({required Object name}) {
    return '$name ile poz verme';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return '$name ile güzel manzaralar';
  }

  @override
  String sportsWithThem({required Object name}) {
    return '$name ile spor';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return '$name ile yolculuk';
  }

  @override
  String get spotlightOnYourself => 'Sahne senin';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Sahne $name\'in';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name $age yaşında!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name yakında $age yaşına giriyor';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return '$name ile son an';
  }

  @override
  String tripToLocation({required Object location}) {
    return '$location\'a gezi';
  }

  @override
  String tripInYear({required Object year}) {
    return '$year yılındaki gezi';
  }

  @override
  String get lastYearsTrip => 'Geçen yılki gezi';

  @override
  String get sunrise => 'Ufukta';

  @override
  String get mountains => 'Tepelerin ötesinde';

  @override
  String get greenery => 'Yeşil yaşam';

  @override
  String get beach => 'Kum ve deniz';

  @override
  String get city => 'Şehirde';

  @override
  String get moon => 'Ay ışığında';

  @override
  String get onTheRoad => 'Yeniden yollarda';

  @override
  String get food => 'Yemek keyfi';

  @override
  String get pets => 'Tüylü dostlar';

  @override
  String get curatedMemories => 'Seçilmiş anılar';

  @override
  String get widgets => 'Widget\'lar';

  @override
  String get memories => 'Anılar';

  @override
  String get peopleWidgetDesc =>
      'Ana ekranınızda görmek istediğiniz kişileri seçin.';

  @override
  String get albumsWidgetDesc =>
      'Ana ekranınızda görmek istediğiniz albümleri seçin.';

  @override
  String get memoriesWidgetDesc =>
      'Ana ekranınızda görmek istediğiniz anı türünü seçin.';

  @override
  String get smartMemories => 'Akıllı anılar';

  @override
  String get pastYearsMemories => 'Geçmiş yılların anıları';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Ayrıca bu $count albümde bulunan fotoğrafları (ve videoları) parçası oldukları <bold>tüm</bold> diğer albümlerden silmek istiyor musunuz?';
  }

  @override
  String get addParticipants => 'Katılımcı ekle';

  @override
  String selectedAlbums({required Object count}) {
    return '$count seçildi';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Favoriler albümünde eylem desteklenmiyor';

  @override
  String get onThisDayMemories => 'Bugün anılar';

  @override
  String get onThisDay => 'Bu günde';

  @override
  String get lookBackOnYourMemories => 'Anılarına bir bak 🌄';

  @override
  String get newPhotosEmoji => ' yeni 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Üzgünüm, yedeklemenizi duraklatmak zorunda kaldık';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Bugüne kadarki en iyi sürümümüzü yüklemek için tıklayın';

  @override
  String get onThisDayNotificationExplanation =>
      'Önceki yıllarda bu günden anılar hakkında hatırlatıcılar alın.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Ana ekranınıza bir anılar widget\'ı ekleyin ve özelleştirmek için buraya geri dönün.';

  @override
  String get addAlbumWidgetPrompt =>
      'Ana ekranınıza bir albüm widget\'ı ekleyin ve özelleştirmek için buraya geri dönün.';

  @override
  String get addPeopleWidgetPrompt =>
      'Ana ekranınıza bir kişiler widget\'ı ekleyin ve özelleştirmek için buraya geri dönün.';

  @override
  String get birthdayNotifications => 'Doğum günü bildirimleri';

  @override
  String get receiveRemindersOnBirthdays =>
      'Birinin doğum günü olduğunda hatırlatıcılar alın. Bildirime dokunmak sizi doğum günü kişisinin fotoğraflarına götürecektir.';

  @override
  String get happyBirthday => 'Doğum günün kutlu olsun! 🥳';

  @override
  String get birthdays => 'Doğum Günleri';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return '$name doğum günü kutlu olsun! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Bu yüzü bu kişiden çıkarmak istediğine emin misin?';

  @override
  String get otherDetectedFaces => 'Tespit edilen diğer yüzler';

  @override
  String get areThey => 'Onlar mı ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Başka bir kişi olarak kaydet';

  @override
  String get showLessFaces => 'Daha az yüz göster';

  @override
  String get showMoreFaces => 'Daha fazla yüz göster';

  @override
  String get ignore => 'Yoksay';

  @override
  String get merge => 'Birleştir';

  @override
  String get reset => 'Sıfırla';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Bu kişiyi görmezden gelmek istediğine emin misin?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Bu insanları görmezden gelmek istediğine emin misiniz?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Kişi grupları artık kişiler bölümünde görüntülenmeyecek. Fotoğraflar dokunulmadan kalacaktır.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'Kişi artık kişiler bölümünde görüntülenmeyecek. Fotoğraflar dokunulmadan kalacaktır.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Onları birleştirmek istediğine emin misiniz?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Tüm isimsiz gruplar seçilen kişiyle birleştirilecektir. Bu, kişinin öneri geçmişine genel bakışından hala geri alınabilir.';

  @override
  String get yesIgnore => 'Evet, görmezden gel';

  @override
  String get same => 'Aynı';

  @override
  String get different => 'Farklı';

  @override
  String get sameperson => 'Aynı kişi mi?';

  @override
  String get indexingPausedStatusDescription =>
      'Dizin oluşturma duraklatıldı. Cihaz hazır olduğunda otomatik olarak devam edecektir. Cihaz, pil seviyesi, pil sağlığı ve termal durumu sağlıklı bir aralıkta olduğunda hazır kabul edilir.';

  @override
  String get thisWeek => 'Bu hafta';

  @override
  String get lastWeek => 'Geçen hafta';

  @override
  String get thisMonth => 'Bu ay';

  @override
  String get thisYear => 'Bu yıl';

  @override
  String get groupBy => 'Gruplama';

  @override
  String get faceThumbnailGenerationFailed =>
      'Küçük yüz resimleri oluşturulamıyor';

  @override
  String get fileAnalysisFailed => 'Dosya gözlemlenemiyor';

  @override
  String get editAutoAddPeople => 'Otomatik olarak kişi eklemeyi düzenle';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analiz';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Görünüm';

  @override
  String get day => 'Gün';

  @override
  String get undo => 'Geri al';

  @override
  String get redo => 'İleri al';

  @override
  String get filter => 'Filtre';

  @override
  String get adjust => 'Ayarla';

  @override
  String get draw => 'Çiz';

  @override
  String get sticker => 'Çıkartma';

  @override
  String get brushColor => 'Fırça rengi';

  @override
  String get font => 'Yazı tipi';

  @override
  String get background => 'Arka plan';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Başarıyla $count tane şey albümlere eklendi ',
      one: 'Başarıyla albüm 1\'e eklendi',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => '';

  @override
  String get totalVideos => 'Toplam videolar';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Sıraya ekle';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Seçimi temizle';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Harika iş!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Boyut';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Neredeyse tamam...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'Hepsi';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Ritüeller Tanıtılıyor';

  @override
  String get cLDesc1 =>
      '2026 için kararlar mı planlıyorsunuz? Ritüeller ile Ente Photos\'ta hatırlatıcı ayarlayabilir ve fotoğraf çekerek ilerlemenizi takip edebilirsiniz. Egzersizler, beslenme alışkanlıkları, sevdiklerinizle günlük anlar için kullanın – alışkanlık haline getirmek istediğiniz her şey için.';

  @override
  String get cLTitle2 => 'Herkese açık bağlantılar, artık herkes için';

  @override
  String get cLDesc2 =>
      'Ücretsiz plandaki tüm Ente kullanıcıları artık fotoğraflara ve albümlere herkese açık bağlantılar oluşturabilir ve paylaşabilir. Kötüye kullanımı önlemek için bağlantıların kaç kişinin görüntüleyebileceğine dair sınırları olacak.';

  @override
  String get cLTitle3 => 'Kişileri manuel olarak etiketle';

  @override
  String get cLDesc3 =>
      'Artık cihaz üzerindeki yapay zekamız yüz algılamasa bile kişileri etiketleyebilirsiniz. Evcil hayvanlar, kısmen görünen yüzler veya birinin aslında fotoğrafta olmadığı ama yine de dahil edilmesi gereken anlar için kullanışlı.';

  @override
  String get cLTitle4 => 'Ve daha fazlası';

  @override
  String get cLDesc4 =>
      'Artık paylaşılan albümleri sabitleyebilirsiniz. Albüm bağlantıları, paylaşımı daha da kolaylaştırmak için ortak çalışanlar ve izleyiciler tarafından görülebilir. Bazı iOS kaydırma hatalarını düzelttik ve yeni bir favori simgesi dahil fotoğraf görünümünü güncelledik (gelecek özellikler için yer açıyoruz).';

  @override
  String get closeBy => 'Kapat';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
