// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Romanian Moldavian Moldovan (`ro`).
class AppLocalizationsRo extends AppLocalizations {
  AppLocalizationsRo([String locale = 'ro']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Introduceți adresa de e-mail';

  @override
  String get enterYourNewEmailAddress => 'Enter your new email address';

  @override
  String get accountWelcomeBack => 'Bine ați revenit!';

  @override
  String get emailAlreadyRegistered => 'E-mail deja înregistrat.';

  @override
  String get emailNotRegistered => 'E-mailul nu este înregistrat.';

  @override
  String get email => 'E-mail';

  @override
  String get cancel => 'Anulare';

  @override
  String get verify => 'Verificare';

  @override
  String get invalidEmailAddress => 'Adresa e-mail nu este validă';

  @override
  String get enterValidEmail =>
      'Vă rugăm să introduceți o adresă de e-mail validă.';

  @override
  String get deleteAccount => 'Ștergere cont';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Care este principalul motiv pentru care vă ștergeți contul?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Ne pare rău că plecați. Vă rugăm să împărtășiți feedback-ul dvs. pentru a ne ajuta să ne îmbunătățim.';

  @override
  String get feedback => 'Feedback';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Vă rugăm să ne ajutați cu aceste informații';

  @override
  String get confirmDeletePrompt =>
      'Da, doresc să șterg definitiv acest cont și toate datele sale din toate aplicațiile.';

  @override
  String get confirmAccountDeletion => 'Confirmați ștergerea contului';

  @override
  String get deleteAccountPermanentlyButton => 'Ștergeți contul definitiv';

  @override
  String get yourAccountHasBeenDeleted => 'Contul dvs. a fost șters';

  @override
  String get selectReason => 'Selectați motivul';

  @override
  String get deleteReason1 => 'Lipsește o funcție cheie de care am nevoie';

  @override
  String get deleteReason2 =>
      'Aplicația sau o anumită funcție nu se comportă așa cum cred eu că ar trebui';

  @override
  String get deleteReason3 =>
      'Am găsit un alt serviciu care îmi place mai mult';

  @override
  String get deleteReason4 => 'Motivul meu nu apare';

  @override
  String get sendEmail => 'Trimiteți e-mail';

  @override
  String get deleteRequestSLAText =>
      'Solicitarea dvs. va fi procesată în 72 de ore.';

  @override
  String get deleteEmailRequest =>
      'Vă rugăm să trimiteți un e-mail la <warning>account-deletion@ente.io</warning> de pe adresa dvs. de e-mail înregistrată.';

  @override
  String get entePhotosPerm =>
      'Ente <i>are nevoie de permisiune</i> pentru a vă păstra fotografiile';

  @override
  String get ok => 'Ok';

  @override
  String get createAccount => 'Creare cont';

  @override
  String get createNewAccount => 'Creare cont nou';

  @override
  String get password => 'Parolă';

  @override
  String get confirmPassword => 'Confirmare parolă';

  @override
  String get activeSessions => 'Sesiuni active';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Ups';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Ceva nu a mers bine, vă rugăm să încercați din nou';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Urmează să vă deconectați de pe acest dispozitiv!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Urmează să vă deconectați de pe următorul dispozitiv:';

  @override
  String get terminateSession => 'Terminați sesiunea?';

  @override
  String get terminate => 'Terminare';

  @override
  String get thisDevice => 'Acest dispozitiv';

  @override
  String get recoverButton => 'Recuperare';

  @override
  String get recoverySuccessful => 'Recuperare reușită!';

  @override
  String get decrypting => 'Se decriptează...';

  @override
  String get incorrectRecoveryKeyTitle => 'Cheie de recuperare incorectă';

  @override
  String get incorrectRecoveryKeyBody =>
      'Cheia de recuperare introdusă este incorectă';

  @override
  String get forgotPassword => 'Am uitat parola';

  @override
  String get enterYourRecoveryKey => 'Introduceți cheia de recuperare';

  @override
  String get noRecoveryKey => 'Nu aveți cheia de recuperare?';

  @override
  String get sorry => 'Ne pare rău';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Datorită naturii protocolului nostru de criptare integrală, datele dvs. nu pot fi decriptate fără parola sau cheia dvs. de recuperare';

  @override
  String get verifyEmail => 'Verificare e-mail';

  @override
  String get toResetVerifyEmail =>
      'Pentru a reseta parola, vă rugăm să verificați mai întâi e-mailul.';

  @override
  String get checkInboxAndSpamFolder =>
      'Vă rugăm să verificaţi inbox-ul (şi spam) pentru a finaliza verificarea';

  @override
  String get tapToEnterCode => 'Atingeți pentru a introduce codul';

  @override
  String get resendEmail => 'Retrimitere e-mail';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Am trimis un e-mail la <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Setați parola';

  @override
  String get changePasswordTitle => 'Schimbați parola';

  @override
  String get resetPasswordTitle => 'Resetați parola';

  @override
  String get encryptionKeys => 'Chei de criptare';

  @override
  String get passwordWarning =>
      'Nu reținem această parolă, deci dacă o uitați <underline>nu vă putem decripta datele</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Introduceți o parolă pe care o putem folosi pentru a decripta datele';

  @override
  String get enterNewPasswordToEncrypt =>
      'Introduceți o parolă nouă pe care o putem folosi pentru a cripta datele';

  @override
  String get weakStrength => 'Slabă';

  @override
  String get strongStrength => 'Puternică';

  @override
  String get moderateStrength => 'Moderată';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Complexitatea parolei: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Parola a fost schimbată cu succes';

  @override
  String get generatingEncryptionKeys => 'Se generează cheile de criptare...';

  @override
  String get pleaseWait => 'Vă rugăm așteptați...';

  @override
  String get continueLabel => 'Continuare';

  @override
  String get insecureDevice => 'Dispozitiv nesigur';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Ne pare rău, nu am putut genera chei securizate pe acest dispozitiv.\n\nvă rugăm să vă înregistrați de pe un alt dispozitiv.';

  @override
  String get howItWorks => 'Cum funcţionează';

  @override
  String get encryption => 'Criptarea';

  @override
  String get ackPasswordLostWarning =>
      'Înțeleg că dacă îmi pierd parola, îmi pot pierde datele, deoarece datele mele sunt <underline>criptate integral</underline>.';

  @override
  String get privacyPolicyTitle => 'Politică de confidențialitate';

  @override
  String get termsOfServicesTitle => 'Termeni';

  @override
  String get signUpTerms =>
      'Sunt de acord cu <u-terms>termenii de prestare ai serviciului</u-terms> și <u-policy>politica de confidențialitate</u-policy>';

  @override
  String get logInLabel => 'Conectare';

  @override
  String get loginTerms =>
      'Apăsând pe „Conectare”, sunteți de acord cu <u-terms>termenii de prestare ai serviciului</u-terms> și <u-policy>politica de confidenţialitate</u-policy>';

  @override
  String get changeEmail => 'Schimbați e-mailul';

  @override
  String get enterYourPassword => 'Introduceţi parola';

  @override
  String get welcomeBack => 'Bine ați revenit!';

  @override
  String get contactSupport => 'Contactați serviciul de asistență';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Parolă incorectă';

  @override
  String get pleaseTryAgain => 'Vă rugăm să încercați din nou';

  @override
  String get recreatePasswordTitle => 'Refaceți parola';

  @override
  String get useRecoveryKey => 'Folosiți cheia de recuperare';

  @override
  String get recreatePasswordBody =>
      'Dispozitivul actual nu este suficient de puternic pentru a vă verifica parola, dar o putem regenera într-un mod care să funcționeze cu toate dispozitivele.\n\nVă rugăm să vă conectați utilizând cheia de recuperare și să vă regenerați parola (dacă doriți, o puteți utiliza din nou pe aceeași).';

  @override
  String get verifyPassword => 'Verificați parola';

  @override
  String get recoveryKey => 'Cheie de recuperare';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Dacă vă uitați parola, singura cale de a vă recupera datele este folosind această cheie.';

  @override
  String get recoveryKeySaveDescription =>
      'Nu reținem această cheie, vă rugăm să păstrați această cheie de 24 de cuvinte într-un loc sigur.';

  @override
  String get doThisLater => 'Mai târziu';

  @override
  String get saveKey => 'Salvați cheia';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Cheie de recuperare copiată în clipboard';

  @override
  String get recoverAccount => 'Recuperare cont';

  @override
  String get recover => 'Recuperare';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Vă rugăm să trimiteți un e-mail la $supportEmail de pe adresa de e-mail înregistrată';
  }

  @override
  String get twofactorSetup => 'Configurare doi factori';

  @override
  String get enterCode => 'Introduceți codul';

  @override
  String get scanCode => 'Scanare cod';

  @override
  String get codeCopiedToClipboard => 'Cod copiat în clipboard';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Copiați acest cod\nîn aplicația de autentificare';

  @override
  String get tapToCopy => 'atingeți pentru a copia';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Scanați acest cod de bare\ncu aplicația de autentificare';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Introduceți codul de 6 cifre\ndin aplicația de autentificare';

  @override
  String get confirm => 'Confirmare';

  @override
  String get setupComplete => 'Configurare finalizată';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Salvați cheia de recuperare, dacă nu ați făcut-o deja';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Aceasta poate fi utilizată pentru a vă recupera contul în cazul în care pierdeți al doilea factor';

  @override
  String get twofactorAuthenticationPageTitle => 'Autentificare cu doi factori';

  @override
  String get lostDevice => 'Dispozitiv pierdut?';

  @override
  String get verifyingRecoveryKey => 'Se verifică cheia de recuperare...';

  @override
  String get recoveryKeyVerified => 'Cheie de recuperare verificată';

  @override
  String get recoveryKeySuccessBody =>
      'Super! Cheia dvs. de recuperare este validă. Vă mulțumim pentru verificare.\n\nVă rugăm să nu uitați să păstrați cheia de recuperare în siguranță.';

  @override
  String get invalidRecoveryKey =>
      'Cheia de recuperare pe care ați introdus-o nu este validă. Vă rugăm să vă asigurați că aceasta conține 24 de cuvinte și să verificați ortografia fiecăruia.\n\nDacă ați introdus un cod de recuperare mai vechi, asigurați-vă că acesta conține 64 de caractere și verificați fiecare dintre ele.';

  @override
  String get invalidKey => 'Cheie invalidă';

  @override
  String get tryAgain => 'Încercați din nou';

  @override
  String get viewRecoveryKey => 'Vizualizați cheia de recuperare';

  @override
  String get confirmRecoveryKey => 'Confirmați cheia de recuperare';

  @override
  String get recoveryKeyVerifyReason =>
      'Cheia dvs. de recuperare este singura modalitate de a vă recupera fotografiile dacă uitați parola. Puteți găsi cheia dvs. de recuperare în Setări > Cont.\n\nVă rugăm să introduceți aici cheia de recuperare pentru a verifica dacă ați salvat-o corect.';

  @override
  String get confirmYourRecoveryKey => 'Confirmați cheia de recuperare';

  @override
  String get addViewer => 'Adăugare observator';

  @override
  String get addCollaborator => 'Adăugare colaborator';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Adăugați un e-mail nou';

  @override
  String get orPickAnExistingOne => 'Sau alegeți unul existent';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Colaboratorii pot adăuga fotografii și videoclipuri la albumul distribuit.';

  @override
  String get enterEmail => 'Introduceți e-mailul';

  @override
  String get albumOwner => 'Proprietar';

  @override
  String get you => 'Dvs.';

  @override
  String get collaborator => 'Colaborator';

  @override
  String get addMore => 'Adăugați mai mulți';

  @override
  String get viewer => 'Observator';

  @override
  String get remove => 'Eliminare';

  @override
  String get removeParticipant => 'Eliminați participantul';

  @override
  String get manage => 'Gestionare';

  @override
  String get addedAs => 'Adăugat ca';

  @override
  String get changePermissions => 'Schimbați permisiunile?';

  @override
  String get yesConvertToViewer => 'Da, covertiți la observator';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user nu va putea să mai adauge fotografii la acest album\n\nVa putea să elimine fotografii existente adăugate de el/ea';
  }

  @override
  String get allowAddingPhotos => 'Permiteți adăugarea fotografiilor';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Permiteți persoanelor care au linkul să adauge și fotografii la albumul distribuit.';

  @override
  String get passwordLock => 'Blocare cu parolă';

  @override
  String get canNotOpenTitle => 'Nu se poate deschide acest album';

  @override
  String get canNotOpenBody =>
      'Ne pare rău, acest album nu poate fi deschis în aplicație.';

  @override
  String get disableDownloadWarningTitle => 'Rețineți';

  @override
  String get disableDownloadWarningBody =>
      'Observatorii pot să facă capturi de ecran sau să salveze o copie a fotografiilor dvs. folosind instrumente externe';

  @override
  String get allowDownloads => 'Permiteți descărcările';

  @override
  String get linkDeviceLimit => 'Limită de dispozitive';

  @override
  String get noDeviceLimit => 'Niciuna';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Expirarea linkului';

  @override
  String get linkExpired => 'Expirat';

  @override
  String get linkEnabled => 'Activat';

  @override
  String get linkNeverExpires => 'Niciodată';

  @override
  String get expiredLinkInfo =>
      'Acest link a expirat. Vă rugăm să selectați un nou termen de expirare sau să dezactivați expirarea linkului.';

  @override
  String get setAPassword => 'Setați o parolă';

  @override
  String get lockButtonLabel => 'Blocat';

  @override
  String get enterPassword => 'Introduceți parola';

  @override
  String get removeLink => 'Eliminați linkul';

  @override
  String get manageLink => 'Gestionați linkul';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Linkul va expira pe $expiryTime';
  }

  @override
  String get albumUpdated => 'Album actualizat';

  @override
  String get never => 'Niciodată';

  @override
  String get custom => 'Particularizat';

  @override
  String get after1Hour => 'După o oră';

  @override
  String get after1Day => 'După o zi';

  @override
  String get after1Week => 'După o săptămâna';

  @override
  String get after1Month => 'După o lună';

  @override
  String get after1Year => 'După un an';

  @override
  String get manageParticipants => 'Gestionare';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count de participanți',
      one: '1 participant',
      zero: 'Fără participanți',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Creați un link pentru a permite oamenilor să adauge și să vizualizeze fotografii în albumul dvs. distribuit, fără a avea nevoie de o aplicație sau un cont Ente. Excelent pentru colectarea fotografiilor de la evenimente.';

  @override
  String get collectPhotos => 'Colectare fotografii';

  @override
  String get collaborativeLink => 'Link colaborativ';

  @override
  String get shareWithNonenteUsers =>
      'Distribuiți cu utilizatori din afara Ente';

  @override
  String get createPublicLink => 'Creare link public';

  @override
  String get sendLink => 'Trimitere link';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Copere link';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Linkul a expirat';

  @override
  String get publicLinkEnabled => 'Link public activat';

  @override
  String get shareALink => 'Distribuiți un link';

  @override
  String get sharedAlbumSectionDescription =>
      'Creați albume distribuite și colaborative cu alți utilizatori Ente, inclusiv cu utilizatorii planurilor gratuite.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Distribuit cu $numberOfPeople de persoane',
      one: 'Distribuit cu o persoană',
      zero: 'Distribuiți cu anumite persoane',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Acesta este ID-ul dvs. de verificare';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Cineva care distribuie albume cu dvs. ar trebui să vadă același ID pe dispozitivul său.';

  @override
  String get howToViewShareeVerificationID =>
      'Rugați-i să țină apăsat pe adresa de e-mail din ecranul de setări și să verifice dacă ID-urile de pe ambele dispozitive se potrivesc.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Acesta este ID-ul de verificare al $email';
  }

  @override
  String get verificationId => 'ID de verificare';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verificare $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email nu are un cont Ente.\n\nTrimiteți-le o invitație pentru a distribui fotografii.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Acesta este ID-ul meu de verificare: $verificationID pentru ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Poți confirma că acesta este ID-ul tău de verificare ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Ceva nu a funcţionat corect';

  @override
  String get sendInvite => 'Trimiteți invitația';

  @override
  String get shareTextRecommendUsingEnte =>
      'Descarcă Ente pentru a putea distribui cu ușurință fotografii și videoclipuri în calitate originală\n\nhttps://ente.io';

  @override
  String get done => 'Finalizat';

  @override
  String get applyCodeTitle => 'Aplicați codul';

  @override
  String get enterCodeDescription =>
      'Introduceți codul oferit de prietenul dvs. pentru a beneficia de spațiu gratuit pentru amândoi';

  @override
  String get apply => 'Aplicare';

  @override
  String get failedToApplyCode => 'Codul nu a putut fi aplicat';

  @override
  String get enterReferralCode => 'Introduceţi codul de recomandare';

  @override
  String get codeAppliedPageTitle => 'Cod aplicat';

  @override
  String get changeYourReferralCode => 'Schimbați codul dvs. de recomandare';

  @override
  String get change => 'Schimbați';

  @override
  String get unavailableReferralCode =>
      'Ne pare rău, acest cod nu este disponibil.';

  @override
  String get codeChangeLimitReached =>
      'Ne pare rău, ați atins limita de modificări ale codului.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Vă rugăm să contactați $familyAdminEmail pentru a vă schimba codul.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Revendicat';

  @override
  String get details => 'Detalii';

  @override
  String get claimMore => 'Revendicați mai multe!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'De asemenea, va primii $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB de fiecare dată când cineva se înscrie pentru un plan plătit și aplică codul dvs.';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Codul de recomandare Ente: $referralCode\n\nAplică-l în Setări → General → Recomandări pentru a obține $referralStorageInGB GB gratuit după ce te înscrii pentru un plan plătit\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Revendică spațiul gratuit';

  @override
  String get inviteYourFriends => 'Invitați-vă prietenii';

  @override
  String get failedToFetchReferralDetails =>
      'Nu se pot obține detaliile recomandării. Vă rugăm să încercați din nou mai târziu.';

  @override
  String get referralStep1 => '1. Dați acest cod prietenilor';

  @override
  String get referralStep2 => '2. Aceștia se înscriu la un plan cu plată';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Amândoi primiți $storageInGB GB* gratuit';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Recomandările sunt momentan întrerupte';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Cel mult vă puteți dubla spațiul';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Familia dvs. a revendicat $storageAmountInGb GB până acum',
      'false': 'Ați revendicat $storageAmountInGb GB până acum',
      'other': 'Ați revendicat $storageAmountInGb de GB până acum!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Întrebări frecvente';

  @override
  String get help => 'Asistență';

  @override
  String get oopsSomethingWentWrong => 'Hopa, ceva nu a mers bine';

  @override
  String get peopleUsingYourCode => 'Persoane care folosesc codul dvs.';

  @override
  String get eligible => 'eligibil';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Cod folosit de dvs.';

  @override
  String get freeStorageClaimed => 'Spațiu gratuit revendicat';

  @override
  String get freeStorageUsable => 'Spațiu gratuit utilizabil';

  @override
  String get usableReferralStorageInfo =>
      'Spațiul utilizabil este limitat de planul dvs. actual. Spațiul suplimentar revendicat va deveni automat utilizabil atunci când vă îmbunătățiți planul.';

  @override
  String get removeFromAlbumTitle => 'Eliminați din album?';

  @override
  String get removeFromAlbum => 'Eliminați din album';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Articolele selectate vor fi eliminate din acest album';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Se adaugă la favorite...';

  @override
  String get removingFromFavorites => 'Se elimină din favorite...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Ne pare rău, nu s-a putut adăuga la favorite!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Ne pare rău, nu s-a putut elimina din favorite!';

  @override
  String get subscribeToEnableSharing =>
      'Aveți nevoie de un abonament plătit activ pentru a activa distribuirea.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'Abonare';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Puteți elimina numai fișierele deținute de dvs.';

  @override
  String get deleteSharedAlbum => 'Ștergeți albumul distribuit?';

  @override
  String get deleteAlbum => 'Ştergeţi albumul';

  @override
  String get deleteAlbumDialog =>
      'De asemenea, ștergeți fotografiile (și videoclipurile) prezente în acest album din <bold>toate</bold> celelalte albume din care fac parte?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Albumul va fi șters pentru toată lumea\n\nVeți pierde accesul la fotografiile distribuite din acest album care sunt deținute de alții';

  @override
  String get yesRemove => 'Da, elimină';

  @override
  String get creatingLink => 'Se crează linkul...';

  @override
  String get removeWithQuestionMark => 'Eliminați?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail va fi eliminat din acest album distribuit\n\nOrice fotografii adăugate de acesta vor fi, de asemenea, eliminate din album';
  }

  @override
  String get keepPhotos => 'Păstrați fotografiile';

  @override
  String get deletePhotos => 'Ștergeți fotografiile';

  @override
  String get inviteToEnte => 'Invitați la Ente';

  @override
  String get removePublicLink => 'Eliminați linkul public';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Urmează să eliminați linkul public pentru accesarea „$albumName”.';
  }

  @override
  String get sharing => 'Se distribuie...';

  @override
  String get youCannotShareWithYourself => 'Nu poți distribui cu tine însuți';

  @override
  String get archive => 'Arhivă';

  @override
  String get createAlbumActionHint =>
      'Apăsați lung pentru a selecta fotografii și apăsați pe + pentru a crea un album';

  @override
  String get importing => 'Se importă....';

  @override
  String get failedToLoadAlbums => 'Încărcarea albumelor nu a reușit';

  @override
  String get hidden => 'Ascunse';

  @override
  String get authToViewYourHiddenFiles =>
      'Vă rugăm să vă autentificați pentru a vedea fișierele ascunse';

  @override
  String get authToViewTrashedFiles =>
      'Vă rugăm să vă autentificați pentru a vedea fișierele din coșul de gunoi';

  @override
  String get trash => 'Coș de gunoi';

  @override
  String get uncategorized => 'Necategorisite';

  @override
  String get videoSmallCase => 'videoclip';

  @override
  String get photoSmallCase => 'fotografie';

  @override
  String get singleFileDeleteHighlight =>
      'Acesta va fi șters din toate albumele.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Fișierul de tip $fileType este atât în Ente, cât și în dispozitivul dvs.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Fișierul de tip $fileType va fi șters din Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Fișierul de tip $fileType va fi șters din dispozitivul dvs.';
  }

  @override
  String get deleteFromEnte => 'Ștergeți din Ente';

  @override
  String get yesDelete => 'Da, șterge';

  @override
  String get movedToTrash => 'S-a mutat în coșul de gunoi';

  @override
  String get deleteFromDevice => 'Ștergeți de pe dispozitiv';

  @override
  String get deleteFromBoth => 'Ștergeți din ambele';

  @override
  String get newAlbum => 'Album nou';

  @override
  String get albums => 'Albume';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount memories',
      one: '$formattedCount memory',
      zero: 'no memories',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count selectate';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count selectate ($yourCount ale dvs.)';
  }

  @override
  String get advancedSettings => 'Avansat';

  @override
  String get photoGridSize => 'Dimensiunea grilei foto';

  @override
  String get manageDeviceStorage => 'Gestionați memoria cache a dispozitivului';

  @override
  String get manageDeviceStorageDesc =>
      'Revizuiți și ștergeți spațiul din memoria cache locală.';

  @override
  String get machineLearning => 'Învățare automată';

  @override
  String get mlConsent => 'Activați învățarea automată';

  @override
  String get mlConsentTitle => 'Activați învățarea automată?';

  @override
  String get mlConsentDescription =>
      'Dacă activați învățarea automată, Ente va extrage informații precum geometria fețelor din fișiere, inclusiv din cele distribuite cu dvs.\n\nAcest lucru se va întâmpla pe dispozitivul dvs., iar orice informații biometrice generate vor fi criptate integral.';

  @override
  String get mlConsentPrivacy =>
      'Vă rugăm să faceți clic aici pentru mai multe detalii despre această funcție în politica de confidențialitate';

  @override
  String get mlConsentConfirmation =>
      'Înțeleg și doresc să activez învățarea automată';

  @override
  String get magicSearch => 'Căutare magică';

  @override
  String get discover => 'Descoperire';

  @override
  String get discover_identity => 'Identitate';

  @override
  String get discover_screenshots => 'Capturi de ecran';

  @override
  String get discover_receipts => 'Bonuri';

  @override
  String get discover_notes => 'Notițe';

  @override
  String get discover_memes => 'Meme-uri';

  @override
  String get discover_visiting_cards => 'Carte de vizită';

  @override
  String get discover_babies => 'Bebeluși';

  @override
  String get discover_pets => 'Animale';

  @override
  String get discover_selfies => 'Selfie-uri';

  @override
  String get discover_wallpapers => 'Imagini de fundal';

  @override
  String get discover_food => 'Mâncare';

  @override
  String get discover_celebrations => 'Celebrări';

  @override
  String get discover_sunset => 'Apusuri';

  @override
  String get discover_hills => 'Dealuri';

  @override
  String get discover_greenery => 'Verdeață';

  @override
  String get mlIndexingDescription =>
      'Vă rugăm să rețineți că învățarea automată va duce la o utilizare mai mare a lățimii de bandă și a bateriei până când toate elementele sunt indexate. Luați în considerare utilizarea aplicației desktop pentru o indexare mai rapidă, toate rezultatele vor fi sincronizate automat.';

  @override
  String get loadingModel => 'Se descarcă modelele...';

  @override
  String get waitingForWifi => 'Se așteaptă WiFi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Elemente indexate';

  @override
  String get pendingItems => 'Elemente în așteptare';

  @override
  String get clearIndexes => 'Ștergeți indexul';

  @override
  String get selectFoldersForBackup =>
      'Selectați folderele pentru copie de rezervă';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Dosarele selectate vor fi criptate și salvate';

  @override
  String get unselectAll => 'Deselectare totală';

  @override
  String get selectAll => 'Selectare totală';

  @override
  String get skip => 'Omiteți';

  @override
  String get updatingFolderSelection => 'Se actualizează selecția dosarelor...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count de articole',
      few: '$count articole',
      one: '$count articol',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ștergeți $count de articole',
      one: 'Ștergeți $count articol',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count fișiere, $formattedSize fiecare';
  }

  @override
  String get showMemories => 'Afișare amintiri';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'acum $count de ani',
      few: 'acum $count ani',
      one: 'acum $count an',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Setări copie de rezervă';

  @override
  String get backupStatus => 'Stare copie de rezervă';

  @override
  String get backupStatusDescription =>
      'Articolele care au fost salvate vor apărea aici';

  @override
  String get backupOverMobileData =>
      'Efectuare copie de rezervă prin date mobile';

  @override
  String get backupVideos => 'Copie de rezervă videoclipuri';

  @override
  String get disableAutoLock => 'Dezactivare blocare automată';

  @override
  String get deviceLockExplanation =>
      'Dezactivați blocarea ecranului dispozitivului atunci când Ente este în prim-plan și există o copie de rezervă în curs de desfășurare. În mod normal, acest lucru nu este necesar, dar poate ajuta la finalizarea mai rapidă a încărcărilor mari și a importurilor inițiale de biblioteci mari.';

  @override
  String get about => 'Despre';

  @override
  String get weAreOpenSource => 'Suntem open source!';

  @override
  String get privacy => 'Confidențialitate';

  @override
  String get terms => 'Termeni';

  @override
  String get checkForUpdates => 'Căutați actualizări';

  @override
  String get checkStatus => 'Verificați starea';

  @override
  String get checking => 'Se verifică...';

  @override
  String get youAreOnTheLatestVersion => 'Sunteți pe cea mai recentă versiune';

  @override
  String get account => 'Cont';

  @override
  String get manageSubscription => 'Gestionare abonament';

  @override
  String get authToChangeYourEmail =>
      'Vă rugăm să vă autentificați pentru a vă schimba adresa de e-mail';

  @override
  String get changePassword => 'Schimbare parolă';

  @override
  String get authToChangeYourPassword =>
      'Vă rugăm să vă autentificați pentru a vă schimba parola';

  @override
  String get emailVerificationToggle => 'Verificarea adresei de e-mail';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Vă rugăm să vă autentificați pentru a schimba verificarea prin e-mail';

  @override
  String get exportYourData => 'Export de date';

  @override
  String get logout => 'Deconectare';

  @override
  String get authToInitiateAccountDeletion =>
      'Vă rugăm să vă autentificați pentru a iniția ștergerea contului';

  @override
  String get areYouSureYouWantToLogout =>
      'Sunteți sigur că doriți să vă deconectați?';

  @override
  String get yesLogout => 'Da, mă deconectez';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Este disponibilă o nouă versiune de Ente.';

  @override
  String get update => 'Actualizare';

  @override
  String get installManually => 'Instalare manuală';

  @override
  String get criticalUpdateAvailable => 'Actualizare critică disponibilă';

  @override
  String get updateAvailable => 'Actualizare disponibilă';

  @override
  String get ignoreUpdate => 'Ignorare';

  @override
  String get downloading => 'Se descarcă...';

  @override
  String get cannotDeleteSharedFiles =>
      'Nu se pot șterge fișierele distribuite';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Descărcarea nu a putut fi finalizată';

  @override
  String get retry => 'Încercați din nou';

  @override
  String get backedUpFolders => 'Foldere salvate';

  @override
  String get backup => 'Copie de rezervă';

  @override
  String get freeUpDeviceSpace => 'Eliberați spațiu pe dispozitiv';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Economisiți spațiu pe dispozitivul dvs. prin ștergerea fișierelor cărora li s-a făcut copie de rezervă.';

  @override
  String get allClear => '✨ Totul e curat';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Nu aveți fișiere pe acest dispozitiv care pot fi șterse';

  @override
  String get removeDuplicates => 'Eliminați dublurile';

  @override
  String get removeDuplicatesDesc =>
      'Revizuiți și eliminați fișierele care sunt dubluri exacte.';

  @override
  String get viewLargeFiles => 'Fișiere mari';

  @override
  String get viewLargeFilesDesc =>
      'Vizualizați fișierele care consumă cel mai mult spațiu.';

  @override
  String get noDuplicates => '✨ Fără dubluri';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'You don\'t have any duplicate files that can be cleared';

  @override
  String get success => 'Succes';

  @override
  String get rateUs => 'Evaluați-ne';

  @override
  String get remindToEmptyDeviceTrash =>
      'De asemenea, goliți dosarul „Șterse recent” din „Setări” -> „Spațiu” pentru a recupera spațiul eliberat';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Ați eliberat cu succes $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'De asemenea, goliți „Coșul de gunoi” pentru a revendica spațiul eliberat';

  @override
  String get sparkleSuccess => '✨ Succes';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count de dubluri',
      few: '$count dubluri',
      one: '$count dublură',
    );
    return 'Ați curățat $_temp0, economisind ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Planuri de familie';

  @override
  String get referrals => 'Recomandări';

  @override
  String get notifications => 'Notificări';

  @override
  String get sharedPhotoNotifications => 'Fotografii partajate noi';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Primiți notificări atunci când cineva adaugă o fotografie la un album distribuit din care faceți parte';

  @override
  String get advanced => 'Avansat';

  @override
  String get general => 'General';

  @override
  String get security => 'Securitate';

  @override
  String get authToViewYourRecoveryKey =>
      'Vă rugăm să vă autentificați pentru a vedea cheia de recuperare';

  @override
  String get twofactor => 'Doi factori';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Vă rugăm să vă autentificați pentru a configura autentificarea cu doi factori';

  @override
  String get lockscreen => 'Ecran de blocare';

  @override
  String get authToChangeLockscreenSetting =>
      'Vă rugăm să vă autentificați pentru a schimba setarea ecranului de blocare';

  @override
  String get viewActiveSessions => 'Vedeți sesiunile active';

  @override
  String get authToViewYourActiveSessions =>
      'Vă rugăm să vă autentificați pentru a vedea sesiunile active';

  @override
  String get disableTwofactor => 'Dezactivați al doilea factor';

  @override
  String get confirm2FADisable =>
      'Sigur doriți dezactivarea autentificării cu doi factori?';

  @override
  String get no => 'Nu';

  @override
  String get yes => 'Da';

  @override
  String get social => 'Rețele socializare';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Evaluați-ne pe $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Produse';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Detaliile privind spațiul de stocare nu au putut fi preluate';

  @override
  String get reportABug => 'Raportați o eroare';

  @override
  String get reportBug => 'Raportare eroare';

  @override
  String get suggestFeatures => 'Sugerați funcționalități';

  @override
  String get support => 'Asistență';

  @override
  String get theme => 'Temă';

  @override
  String get lightTheme => 'Luminoasă';

  @override
  String get darkTheme => 'Întunecată';

  @override
  String get systemTheme => 'Sistem';

  @override
  String get freeTrial => 'Perioadă de încercare gratuită';

  @override
  String get selectYourPlan => 'Selectați planul';

  @override
  String get enteSubscriptionPitch =>
      'Ente vă păstrează amintirile, astfel încât acestea să vă fie întotdeauna disponibile, chiar dacă vă pierdeți dispozitivul.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'La planul dvs. vi se poate alătura și familia.';

  @override
  String get currentUsageIs => 'Utilizarea actuală este ';

  @override
  String get faqs => 'Întrebări frecvente';

  @override
  String renewsOn({required Object endDate}) {
    return 'Abonamentul se reînnoiește pe $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Perioadă de încercare valabilă până pe $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Valabil până pe $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Suplimentul de $storageAmount este valabil până pe $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Perioada de încercare gratuită valabilă până pe $endDate.\nUlterior, puteți opta pentru un plan plătit.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Abonamentul dvs. va fi anulat pe $endDate';
  }

  @override
  String get subscription => 'Abonament';

  @override
  String get paymentDetails => 'Detalii de plată';

  @override
  String get manageFamily => 'Administrați familia';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Vă rugăm să ne contactați la support@ente.io pentru a vă gestiona abonamentul $provider.';
  }

  @override
  String get renewSubscription => 'Reînnoire abonament';

  @override
  String get cancelSubscription => 'Anulare abonament';

  @override
  String get areYouSureYouWantToRenew =>
      'Sunteți sigur că doriți să reînnoiți?';

  @override
  String get yesRenew => 'Da, reînnoiește';

  @override
  String get areYouSureYouWantToCancel => 'Sunteți sigur că doriți să anulați?';

  @override
  String get yesCancel => 'Da, anulează';

  @override
  String get failedToRenew => 'Nu s-a reușit reînnoirea';

  @override
  String get failedToCancel => 'Nu s-a reușit anularea';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 luni gratuite la planurile anuale';

  @override
  String get monthly => 'Lunar';

  @override
  String get yearly => 'Anual';

  @override
  String get confirmPlanChange => 'Confirmați schimbarea planului';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Sunteți sigur că doriți să vă schimbați planul?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Nu puteți retrograda la acest plan';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Vă rugăm să vă anulați mai întâi abonamentul existent de la $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Opțional, cât de scurt doriți...';

  @override
  String get send => 'Trimitere';

  @override
  String get askCancelReason =>
      'Abonamentul dvs. a fost anulat. Doriți să ne comunicați motivul?';

  @override
  String get thankYouForSubscribing => 'Mulțumim pentru abonare!';

  @override
  String get yourPurchaseWasSuccessful =>
      'Achiziția dvs. a fost efectuată cu succes';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Planul dvs. a fost îmbunătățit cu succes';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Planul dvs. a fost retrogradat cu succes';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Abonamentul dvs. a fost actualizat cu succes';

  @override
  String get googlePlayId => 'ID Google Play';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'Abonament PlayStore';

  @override
  String get appstoreSubscription => 'Abonament AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return '$id este deja legat la un alt cont Ente.\nDacă doriți să folosiți $id cu acest cont, vă rugăm să contactați asistența noastră';
  }

  @override
  String get visitWebToManage =>
      'Vă rugăm să vizitați web.ente.io pentru a vă gestiona abonamentul';

  @override
  String get couldNotUpdateSubscription => 'Nu s-a putut actualiza abonamentul';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Vă rugăm să contactați support@ente.io și vom fi bucuroși să vă ajutăm!';

  @override
  String get paymentFailed => 'Plata nu a reușit';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Vă rugăm să vorbiți cu asistența $providerName dacă ați fost taxat';
  }

  @override
  String get continueOnFreeTrial =>
      'Continuați în perioada de încercare gratuită';

  @override
  String get areYouSureYouWantToExit => 'Sigur doriți să ieșiți?';

  @override
  String get thankYou => 'Vă mulțumim';

  @override
  String get failedToVerifyPaymentStatus =>
      'Verificarea stării plății nu a reușit';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Vă rugăm să așteptați un moment înainte să reîncercați';

  @override
  String get paymentFailedMessage =>
      'Din păcate, plata dvs. nu a reușit. Vă rugăm să contactați asistență și vom fi bucuroși să vă ajutăm!';

  @override
  String get youAreOnAFamilyPlan => 'Sunteți pe un plan de familie!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Vă rugăm să contactați <green>$familyAdminEmail</green> pentru a gestiona abonamentul';
  }

  @override
  String get leaveFamily => 'Părăsiți familia';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Sunteți sigur că doriți să părăsiți planul de familie?';

  @override
  String get leave => 'Părăsiți';

  @override
  String get rateTheApp => 'Evaluați aplicația';

  @override
  String get startBackup => 'Începeți copia de rezervă';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Nicio fotografie nu este salvată în acest moment';

  @override
  String get preserveMore => 'Păstrați mai multe';

  @override
  String get grantFullAccessPrompt =>
      'Vă rugăm să permiteți accesul la toate fotografiile în aplicația Setări';

  @override
  String get allowPermTitle => 'Permiteți accesul la fotografii';

  @override
  String get allowPermBody =>
      'Vă rugăm să permiteți accesul la fotografiile dvs. din Setări, astfel încât Ente să vă poată afișa și salva biblioteca.';

  @override
  String get openSettings => 'Deschideți Setări';

  @override
  String get selectMorePhotos => 'Selectați mai multe fotografii';

  @override
  String get existingUser => 'Utilizator existent';

  @override
  String get privateBackups => 'Copii de rezervă private';

  @override
  String get forYourMemories => 'pentru amintirile dvs.';

  @override
  String get endtoendEncryptedByDefault => 'Criptare integrală implicită';

  @override
  String get safelyStored => 'Stocare în siguranță';

  @override
  String get atAFalloutShelter => 'la un adăpost antiatomic';

  @override
  String get designedToOutlive => 'Conceput pentru a supraviețui';

  @override
  String get available => 'Disponibil';

  @override
  String get everywhere => 'pretutindeni';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobil, Web, Desktop';

  @override
  String get newToEnte => 'Nou la Ente';

  @override
  String get pleaseLoginAgain => 'Vă rugăm, autentificați-vă din nou';

  @override
  String get autoLogoutMessage =>
      'Din cauza unei probleme tehnice, ați fost deconectat. Ne cerem scuze pentru neplăcerile create.';

  @override
  String get yourSubscriptionHasExpired => 'Abonamentul dvs. a expirat';

  @override
  String get storageLimitExceeded => 'Limita de spațiu depășită';

  @override
  String get upgrade => 'Îmbunătățire';

  @override
  String get raiseTicket => 'Solicitați asistență';

  @override
  String get backupFailed => 'Copie de rezervă eșuată';

  @override
  String get sorryBackupFailedDesc =>
      'Sorry, we could not backup this file right now, we will retry later.';

  @override
  String get couldNotBackUpTryLater =>
      'Nu s-a putut face copie de rezervă datelor.\nSe va reîncerca mai târziu.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente poate cripta și păstra fișiere numai dacă acordați accesul la acestea';

  @override
  String get pleaseGrantPermissions => 'Vă rugăm să acordați permisiuni';

  @override
  String get grantPermission => 'Acordați permisiunea';

  @override
  String get privateSharing => 'Distribuire privată';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Distribuiți numai cu persoanele pe care le doriți';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Folosiți linkuri publice pentru persoanele care nu sunt pe Ente';

  @override
  String get allowPeopleToAddPhotos =>
      'Permiteți persoanelor să adauge fotografii';

  @override
  String get shareAnAlbumNow => 'Distribuiți un album acum';

  @override
  String get collectEventPhotos => 'Strângeți imagini de la evenimente';

  @override
  String get sessionExpired => 'Sesiune expirată';

  @override
  String get loggingOut => 'Se deconectează...';

  @override
  String get onDevice => 'Pe dispozitiv';

  @override
  String get onEnte => 'Pe <branding>ente</branding>';

  @override
  String get name => 'Nume';

  @override
  String get newest => 'Cele mai noi';

  @override
  String get lastUpdated => 'Ultima actualizare';

  @override
  String get deleteEmptyAlbums => 'Ștergeți albumele goale';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Ștergeți albumele goale?';

  @override
  String get deleteAlbumsDialogBody =>
      'Urmează să ștergeți toate albumele goale. Este util atunci când doriți să reduceți dezordinea din lista de albume.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Se șterg $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Se procesează $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Ștergere definitivă';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Se pot crea linkuri doar pentru fișiere deținute de dvs.';

  @override
  String get publicLinkCreated => 'Link public creat';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Puteți gestiona link-urile în fila de distribuire.';

  @override
  String get linkCopiedToClipboard => 'Linkul a fost copiat în clipboard';

  @override
  String get restore => 'Restaurare';

  @override
  String get moveToAlbum => 'Mutare în album';

  @override
  String get unhide => 'Reafişare';

  @override
  String get unarchive => 'Dezarhivare';

  @override
  String get favorite => 'Favorit';

  @override
  String get removeFromFavorite => 'Eliminați din favorite';

  @override
  String get shareLink => 'Distribuiți linkul';

  @override
  String get createCollage => 'Creați colaj';

  @override
  String get saveCollage => 'Salvați colajul';

  @override
  String get collageSaved => 'Colaj salvat în galerie';

  @override
  String get collageLayout => 'Aspect';

  @override
  String get addToEnte => 'Adăugare la Ente';

  @override
  String get addToAlbum => 'Adăugare la album';

  @override
  String get delete => 'Ștergere';

  @override
  String get hide => 'Ascundere';

  @override
  String get share => 'Distribuire';

  @override
  String get unhideToAlbum => 'Reafișare în album';

  @override
  String get restoreToAlbum => 'Restaurare în album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Move items',
      one: 'Move item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add items',
      one: 'Add item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Creați sau selectați un album';

  @override
  String get selectAlbum => 'Selectare album';

  @override
  String get searchByAlbumNameHint => 'Nume album';

  @override
  String get albumTitle => 'Titlu album';

  @override
  String get enterAlbumName => 'Introduceți numele albumului';

  @override
  String get restoringFiles => 'Se restaurează fișierele...';

  @override
  String get movingFilesToAlbum => 'Se mută fișierele în album...';

  @override
  String get unhidingFilesToAlbum => 'Se reafișează fișierele în album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Nu se poate încărca în albumele deținute de alții';

  @override
  String get uploadingFilesToAlbum => 'Se încarcă fișiere în album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'S-au adăugat cu succes la $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'S-au mutat cu succes în $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Acest album are deja un link colaborativ';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Link colaborativ creat pentru $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Cereți-le celor dragi să distribuie';

  @override
  String get invite => 'Invitați';

  @override
  String get shareYourFirstAlbum => 'Distribuiți primul album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Distribuit cu $emailIDs';
  }

  @override
  String get sharedWithMe => 'Distribuit mie';

  @override
  String get sharedByMe => 'Distribuit de către mine';

  @override
  String get doubleYourStorage => 'Dublați-vă spațiul';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Recomandați un prieten și dublați-vă planul';

  @override
  String get shareAlbumHint =>
      'Deschideți un album și atingeți butonul de distribuire din dreapta sus pentru a distribui.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Articolele afișează numărul de zile rămase până la ștergerea definitivă';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count de zile',
      one: 'O zi',
      zero: 'Curând',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Ștergeți tot';

  @override
  String get renameAlbum => 'Redenumire album';

  @override
  String get convertToAlbum => 'Convertire în album';

  @override
  String get setCover => 'Setare copertă';

  @override
  String get sortAlbumsBy => 'Sortare după';

  @override
  String get sortNewestFirst => 'Cele mai noi primele';

  @override
  String get sortOldestFirst => 'Cele mai vechi primele';

  @override
  String get rename => 'Redenumire';

  @override
  String get leaveSharedAlbum => 'Părăsiți albumul distribuit?';

  @override
  String get leaveAlbum => 'Părăsiți albumul';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Fotografiile adăugate de dvs. vor fi eliminate din album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Nu aveți fișiere în acest album care pot fi șterse';

  @override
  String get youDontHaveAnyArchivedItems => 'Nu aveți articole arhivate.';

  @override
  String get ignoredFolderUploadReason =>
      'Unele fișiere din acest album sunt excluse de la încărcare deoarece au fost șterse anterior din Ente.';

  @override
  String get resetIgnoredFiles => 'Resetare fișiere ignorate';

  @override
  String get deviceFilesAutoUploading =>
      'Fișierele adăugate la acest album de pe dispozitiv vor fi încărcate automat pe Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Activați copia de rezervă pentru a încărca automat fișierele adăugate la acest dosar de pe dispozitiv în Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Fără poze sau videoclipuri ascunse';

  @override
  String get toHideAPhotoOrVideo =>
      'Pentru a ascunde o fotografie sau un videoclip';

  @override
  String get openTheItem => '• Deschideți articolul';

  @override
  String get clickOnTheOverflowMenu => '• Apăsați pe meniul suplimentar';

  @override
  String get click => '• Apăsați';

  @override
  String get nothingToSeeHere => 'Nimic de văzut aici! 👀';

  @override
  String get unarchiveAlbum => 'Dezarhivare album';

  @override
  String get archiveAlbum => 'Arhivare album';

  @override
  String get calculating => 'Se calculează...';

  @override
  String get pleaseWaitDeletingAlbum => 'Vă rugăm așteptați, se șterge albumul';

  @override
  String get searchByExamples =>
      '• Nume de album (ex. „Cameră”)\n• Tipuri de fișiere (ex. „Videoclipuri”, „.gif”)\n• Ani și luni (ex. „2022”, „Ianuarie”)\n• Sărbători (ex. „Crăciun”)\n• Descrieri ale fotografiilor (ex. „#distracție”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Puteți încerca să căutați altceva.';

  @override
  String get noResultsFound => 'Nu s-au găsit rezultate';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Adăugat de $emailOrName';
  }

  @override
  String get loadingExifData => 'Se încarcă date EXIF...';

  @override
  String get viewAllExifData => 'Vizualizați toate datele EXIF';

  @override
  String get noExifData => 'Nu există date EXIF';

  @override
  String get thisImageHasNoExifData => 'Această imagine nu are date exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Niciun rezultat';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Nu se acceptă editarea fotografiilor sau albumelor pe care nu le dețineți încă';

  @override
  String get failedToFetchOriginalForEdit =>
      'Nu s-a reușit preluarea originalului pentru editare';

  @override
  String get close => 'Închidere';

  @override
  String get setAs => 'Setare ca';

  @override
  String get fileSavedToGallery => 'Fișier salvat în galerie';

  @override
  String get filesSavedToGallery => 'Fișiere salvate în galerie';

  @override
  String get fileFailedToSaveToGallery =>
      'Salvarea fișierului în galerie nu a reușit';

  @override
  String get download => 'Descărcare';

  @override
  String get pressAndHoldToPlayVideo =>
      'Apăsați lung pentru a reda videoclipul';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Apăsați lung pe imagine pentru a reda videoclipul';

  @override
  String get downloadFailed => 'Descărcarea nu a reușit';

  @override
  String get deduplicateFiles => 'Elim. dubluri fișiere';

  @override
  String get deselectAll => 'Deselectare totală';

  @override
  String get reviewDeduplicateItems =>
      'Vă rugăm să revizuiți și să ștergeți articolele pe care le considerați a fi dubluri.';

  @override
  String get clubByCaptureTime => 'Grupare după timpul capturării';

  @override
  String get clubByFileName => 'Grupare după numele fișierului';

  @override
  String get count => 'Total';

  @override
  String get totalSize => 'Dimensiune totală';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Apăsați lung pe un articol pentru a-l vizualiza pe tot ecranul';

  @override
  String get decryptingVideo => 'Se decriptează videoclipul...';

  @override
  String get authToViewYourMemories =>
      'Vă rugăm să vă autentificați pentru a vă vizualiza amintirile';

  @override
  String get unlock => 'Deblocare';

  @override
  String get freeUpSpace => 'Eliberați spațiu';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They can be deleted from the device to free up $formattedSize',
      one: 'It can be deleted from the device to free up $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          '$formattedNumber de fișiere din acest album au fost deja salvate în siguranță',
      few:
          '$formattedNumber fișiere din acest album au fost deja salvate în siguranță',
      one: 'Un fișier din acest album a fost deja salvat în siguranță',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          '$formattedNumber de fișiere de pe acest dispozitiv fost deja salvate în siguranță',
      few:
          '$formattedNumber fișiere de pe acest dispozitiv au fost deja salvate în siguranță',
      one: 'Un fișier de pe acest dispozitiv a fost deja salvat în siguranță',
    );
    return '$_temp0';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Eliberați $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Această adresă de e-mail este deja folosită';

  @override
  String get incorrectCode => 'Cod incorect';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Autentificare eșuată, încercați din nou';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verificare eșuată, încercați din nou';

  @override
  String get authenticating => 'Autentificare...';

  @override
  String get authenticationSuccessful => 'Autentificare cu succes!';

  @override
  String get incorrectRecoveryKey => 'Cheie de recuperare incorectă';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Cheia de recuperare introdusă este incorectă';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Autentificarea cu doi factori a fost resetată cu succes';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Vă rugăm să verificați codul introdus';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Vă rugăm să contactați asistența dacă problema persistă';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Autentificarea cu doi factori a fost dezactivată';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Ne pare rău, codul introdus este incorect';

  @override
  String get yourVerificationCodeHasExpired =>
      'Codul dvs. de verificare a expirat';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'E-mail modificat în $newEmail';
  }

  @override
  String get verifying => 'Se verifică...';

  @override
  String get disablingTwofactorAuthentication =>
      'Se dezactivează autentificarea cu doi factori...';

  @override
  String get allMemoriesPreserved => 'S-au salvat toate amintirile';

  @override
  String get loadingGallery => 'Se încarcă galeria...';

  @override
  String get syncing => 'Sincronizare...';

  @override
  String get encryptingBackup => 'Criptare copie de rezervă...';

  @override
  String get syncStopped => 'Sincronizare oprită';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total amintiri salvate';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Se salvează $count amintiri...';
  }

  @override
  String get uploadingSingleMemory => 'Se salvează o amintire...';

  @override
  String get archiving => 'Se arhivează...';

  @override
  String get unarchiving => 'Se dezarhivează...';

  @override
  String get successfullyArchived => 'Arhivat cu succes';

  @override
  String get successfullyUnarchived => 'Dezarhivat cu succes';

  @override
  String get renameFile => 'Redenumiți fișierul';

  @override
  String get enterFileName => 'Introduceți numele fișierului';

  @override
  String get filesDeleted => 'Fișiere șterse';

  @override
  String get selectedFilesAreNotOnEnte => 'Fișierele selectate nu sunt pe Ente';

  @override
  String get thisActionCannotBeUndone => 'Această acțiune nu poate fi anulată';

  @override
  String get emptyTrash => 'Goliți coșul de gunoi?';

  @override
  String get permDeleteWarning =>
      'Toate articolele din coșul de gunoi vor fi șterse definitiv\n\nAceastă acțiune nu poate fi anulată';

  @override
  String get empty => 'Gol';

  @override
  String get couldNotFreeUpSpace => 'Nu s-a putut elibera spațiu';

  @override
  String get permanentlyDeleteFromDevice =>
      'Ștergeți permanent de pe dispozitiv?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Unele dintre fișierele pe care încercați să le ștergeți sunt disponibile numai pe dispozitivul dvs. și nu pot fi recuperate dacă sunt șterse';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Acestea vor fi șterse din toate albumele.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Anumite articole se află atât în Ente, cât și în dispozitiv.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Articolele selectate vor fi șterse din toate albumele și mutate în coșul de gunoi.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Aceste articole vor fi șterse din dispozitivul dvs.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Se pare că ceva nu a mers bine. Vă rugăm să încercați din nou după ceva timp. Dacă eroarea persistă, vă rugăm să contactați echipa noastră de asistență.';

  @override
  String get error => 'Eroare';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Se pare că ceva nu a mers bine. Vă rugăm să încercați din nou după ceva timp. Dacă eroarea persistă, vă rugăm să contactați echipa noastră de asistență.';

  @override
  String get networkHostLookUpErr =>
      'Nu se poate conecta la Ente, vă rugăm să verificați setările de rețea și să contactați asistenta dacă eroarea persistă.';

  @override
  String get networkConnectionRefusedErr =>
      'Nu se poate conecta la Ente, vă rugăm să reîncercați după un timp. Dacă eroarea persistă, contactați asistența.';

  @override
  String get cachedData => 'Date salvate în memoria cache';

  @override
  String get clearCaches => 'Ștergeți memoria cache';

  @override
  String get remoteImages => 'Imagini la distanță';

  @override
  String get remoteVideos => 'Videoclipuri la distanță';

  @override
  String get remoteThumbnails => 'Miniaturi la distanță';

  @override
  String get pendingSync => 'Sincronizare în așteptare';

  @override
  String get localGallery => 'Galerie locală';

  @override
  String get todaysLogs => 'Jurnalele de astăzi';

  @override
  String get viewLogs => 'Afișare jurnale';

  @override
  String get logsDialogBody =>
      'Aceasta va trimite jurnalele pentru a ne ajuta să depistăm problema. Vă rugăm să rețineți că numele fișierelor vor fi incluse pentru a ne ajuta să urmărim problemele cu anumite fișiere.';

  @override
  String get preparingLogs => 'Se pregătesc jurnalele...';

  @override
  String get emailYourLogs => 'Trimiteți jurnalele prin e-mail';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Vă rugăm să trimiteți jurnalele la \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copiați adresa de e-mail';

  @override
  String get exportLogs => 'Exportați jurnalele';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Vă rugăm să ne trimiteți un e-mail la $toEmail';
  }

  @override
  String get dismiss => 'Renunțați';

  @override
  String get didYouKnow => 'Știați că?';

  @override
  String get loadingMessage => 'Se încarcă fotografiile...';

  @override
  String get loadMessage1 => 'Puteți împărți abonamentul cu familia dvs.';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'Păstrăm 3 copii ale datelor dvs., dintre care una într-un adăpost antiatomic subteran';

  @override
  String get loadMessage4 => 'Toate aplicațiile noastre sunt open source';

  @override
  String get loadMessage5 =>
      'Codul nostru sursă și criptografia au fost evaluate extern';

  @override
  String get loadMessage6 =>
      'Puteți distribui linkuri către albumele dvs. celor dragi';

  @override
  String get loadMessage7 =>
      'Aplicațiile noastre mobile rulează în fundal pentru a cripta și salva orice fotografie nouă pe care o realizați';

  @override
  String get loadMessage8 =>
      'web.ente.io are un instrument de încărcare sofisticat';

  @override
  String get loadMessage9 =>
      'Folosim Xchacha20Poly1305 pentru a vă cripta datele în siguranță';

  @override
  String get photoDescriptions => 'Descrieri fotografie';

  @override
  String get fileTypesAndNames => 'Tipuri de fișiere și denumiri';

  @override
  String get location => 'Locație';

  @override
  String get moments => 'Momente';

  @override
  String get searchFaceEmptySection =>
      'Persoanele vor fi afișate aici odată ce indexarea este finalizată';

  @override
  String get searchDatesEmptySection => 'Căutare după o dată, o lună sau un an';

  @override
  String get searchLocationEmptySection =>
      'Grupare fotografii realizate în raza unei fotografii';

  @override
  String get searchPeopleEmptySection =>
      'Invitați persoane și veți vedea aici toate fotografiile distribuite de acestea';

  @override
  String get searchAlbumsEmptySection => 'Albume';

  @override
  String get searchFileTypesAndNamesEmptySection =>
      'Tipuri de fișiere și denumiri';

  @override
  String get searchCaptionEmptySection =>
      'Adăugați descrieri precum „#excursie” în informațiile fotografiilor pentru a le găsi ușor aici';

  @override
  String get language => 'Limbă';

  @override
  String get selectLanguage => 'Selectaţi limba';

  @override
  String get locationName => 'Numele locației';

  @override
  String get addLocation => 'Adăugare locație';

  @override
  String get groupNearbyPhotos => 'Grupare fotografii apropiate';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Adăugare';

  @override
  String get radius => 'Rază';

  @override
  String get locationTagFeatureDescription =>
      'O etichetă de locație grupează toate fotografiile care au fost făcute pe o anumită rază a unei fotografii';

  @override
  String get galleryMemoryLimitInfo =>
      'Până la 1000 de amintiri afișate în galerie';

  @override
  String get save => 'Salvare';

  @override
  String get centerPoint => 'Punctul central';

  @override
  String get pickCenterPoint => 'Alegeți punctul central';

  @override
  String get useSelectedPhoto => 'Folosiți fotografia selectată';

  @override
  String get resetToDefault => 'Resetare la valori implicite';

  @override
  String get edit => 'Editare';

  @override
  String get deleteLocation => 'Ștergeți locația';

  @override
  String get rotateLeft => 'Rotire la stânga';

  @override
  String get flip => 'Răsturnare';

  @override
  String get rotateRight => 'Rotire la dreapta';

  @override
  String get saveCopy => 'Salvare copie';

  @override
  String get light => 'Lumină';

  @override
  String get color => 'Culoare';

  @override
  String get yesDiscardChanges => 'Da, renunțați la modificări';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Doriți să renunțați la editările efectuate?';

  @override
  String get saving => 'Se salvează...';

  @override
  String get editsSaved => 'Editări salvate';

  @override
  String get oopsCouldNotSaveEdits => 'Hopa, nu s-au putut salva editările';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Astăzi';

  @override
  String get dayYesterday => 'Ieri';

  @override
  String get storage => 'Spațiu';

  @override
  String get usedSpace => 'Spațiu utilizat';

  @override
  String get storageBreakupFamily => 'Familie';

  @override
  String get storageBreakupYou => 'Dvs.';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit din $totalAmount $totalStorageUnit utilizat';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit liber';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versiune: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verificare';

  @override
  String get fileInfoAddDescHint => 'Adăugați o descriere...';

  @override
  String get editLocationTagTitle => 'Editare locaţie';

  @override
  String get setLabel => 'Setare';

  @override
  String get setRadius => 'Setare rază';

  @override
  String get familyPlanPortalTitle => 'Familie';

  @override
  String get familyPlanOverview =>
      'Adăugați 5 membri ai familiei la planul dvs. existent fără a plăti suplimentar.\n\nFiecare membru primește propriul spațiu privat și nu poate vedea fișierele celuilalt decât dacă acestea sunt partajate.\n\nPlanurile de familie sunt disponibile pentru clienții care au un abonament Ente plătit.\n\nAbonați-vă acum pentru a începe!';

  @override
  String get androidBiometricHint => 'Verificați-vă identitatea';

  @override
  String get androidBiometricNotRecognized =>
      'Neidentificat. Încercați din nou.';

  @override
  String get androidBiometricSuccess => 'Succes';

  @override
  String get androidCancelButton => 'Anulare';

  @override
  String get androidSignInTitle => 'Autentificare necesară';

  @override
  String get androidBiometricRequiredTitle => 'Biometrice necesare';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Sunt necesare acreditările dispozitivului';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Sunt necesare acreditările dispozitivului';

  @override
  String get goToSettings => 'Mergeți la setări';

  @override
  String get androidGoToSettingsDescription =>
      'Autentificarea biometrică nu este configurată pe dispozitivul dvs. Mergeți la „Setări > Securitate” pentru a adăuga autentificarea biometrică.';

  @override
  String get iOSLockOut =>
      'Autentificarea biometrică este dezactivată. Vă rugăm să blocați și să deblocați ecranul pentru a o activa.';

  @override
  String get iOSGoToSettingsDescription =>
      'Autentificarea biometrică nu este configurată pe dispozitivul dvs. Vă rugăm să activați Touch ID sau Face ID pe telefonul dvs.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Contribuitori OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Găzduit la OSM Franţa';

  @override
  String get map => 'Hartă';

  @override
  String get maps => 'Hărţi';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Activare hărți';

  @override
  String get quickLinks => 'Link-uri rapide';

  @override
  String get selectItemsToAdd => 'Selectați elementele de adăugat';

  @override
  String get addSelected => 'Adăugați selectate';

  @override
  String get addFromDevice => 'Adăugați de pe dispozitiv';

  @override
  String get addPhotos => 'Adăugați fotografii';

  @override
  String get noPhotosFoundHere => 'Nu s-au găsit fotografii aici';

  @override
  String get zoomOutToSeePhotos => 'Micșorați pentru a vedea fotografiile';

  @override
  String get noImagesWithLocation => 'Nicio imagine cu locație';

  @override
  String get unpinAlbum => 'Anulați fixarea albumului';

  @override
  String get pinAlbum => 'Fixați albumul';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Creare';

  @override
  String get viewAll => 'Vizualizați tot';

  @override
  String get nothingSharedWithYouYet => 'Nimic distribuit cu dvs. încă';

  @override
  String get noAlbumsSharedByYouYet =>
      'Niciun album nu a fost distribuit de dvs. încă';

  @override
  String get sharedWithYou => 'Distribuite cu dvs.';

  @override
  String get sharedByYou => 'Distribuite de dvs.';

  @override
  String get inviteYourFriendsToEnte => 'Invitați-vă prietenii la Ente';

  @override
  String get failedToDownloadVideo => 'Descărcarea videoclipului nu a reușit';

  @override
  String get hiding => 'Se ascunde...';

  @override
  String get unhiding => 'Se reafișează...';

  @override
  String get successfullyHid => 'S-a ascuns cu succes';

  @override
  String get successfullyUnhid => 'S-a reafișat cu succes';

  @override
  String get crashReporting => 'Raportarea problemelor';

  @override
  String get resumableUploads => 'Reluare încărcări';

  @override
  String get addToHiddenAlbum => 'Adăugați la album ascuns';

  @override
  String get moveToHiddenAlbum => 'Mutați în albumul ascuns';

  @override
  String get fileTypes => 'Tipuri de fișiere';

  @override
  String get deleteConfirmDialogBody =>
      'Acest cont este legat de alte aplicații Ente, dacă utilizați vreuna. Datele dvs. încărcate în toate aplicațiile Ente vor fi programate pentru ștergere, iar contul dvs. va fi șters definitiv.';

  @override
  String get hearUsWhereTitle => 'Cum ați auzit de Ente? (opțional)';

  @override
  String get hearUsExplanation =>
      'Nu urmărim instalările aplicației. Ne-ar ajuta dacă ne-ați spune unde ne-ați găsit!';

  @override
  String get viewAddOnButton => 'Vizualizare suplimente';

  @override
  String get addOns => 'Suplimente';

  @override
  String get addOnPageSubtitle => 'Detaliile suplimentelor';

  @override
  String get yourMap => 'Harta dvs.';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modificați interogarea sau încercați să căutați';

  @override
  String get blackFridaySale => 'Ofertă Black Friday';

  @override
  String get upto50OffUntil4thDec =>
      'Reducere de până la 50%, până pe 4 decembrie';

  @override
  String get photos => 'Fotografii';

  @override
  String get videos => 'Videoclipuri';

  @override
  String get livePhotos => 'Fotografii live';

  @override
  String get searchHint1 => 'Căutare rapidă, pe dispozitiv';

  @override
  String get searchHint2 => 'Date, descrieri ale fotografiilor';

  @override
  String get searchHint3 => 'Albume, numele fișierelor și tipuri';

  @override
  String get searchHint4 => 'Locație';

  @override
  String get searchHint5 => 'În curând: chipuri și căutare magică ✨';

  @override
  String get addYourPhotosNow => 'Adăugați-vă fotografiile acum';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count de rezultate găsite',
      few: '$count rezultate găsite',
      one: '$count rezultat găsit',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Fețe';

  @override
  String get people => 'Persoane';

  @override
  String get contents => 'Conținuturi';

  @override
  String get addNew => 'Adăugare nou';

  @override
  String get contacts => 'Contacte';

  @override
  String get noInternetConnection => 'Nu există conexiune la internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Vă rugăm să verificați conexiunea la internet și să încercați din nou.';

  @override
  String get signOutFromOtherDevices => 'Deconectare de pe alte dispozitive';

  @override
  String get signOutOtherBody =>
      'Dacă credeți că cineva ar putea să vă cunoască parola, puteți forța toate celelalte dispozitive care utilizează contul dvs. să se deconecteze.';

  @override
  String get signOutOtherDevices => 'Deconectați alte dispozitive';

  @override
  String get doNotSignOut => 'Nu deconectați';

  @override
  String get editLocation => 'Editare locaţie';

  @override
  String get selectALocation => 'Selectați o locație';

  @override
  String get selectALocationFirst => 'Selectați mai întâi o locație';

  @override
  String get changeLocationOfSelectedItems =>
      'Schimbați locația articolelor selectate?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Editările locației vor fi vizibile doar pe Ente';

  @override
  String get cleanUncategorized => 'Curățare Necategorisite';

  @override
  String get cleanUncategorizedDescription =>
      'Eliminați toate fișierele din „Fără categorie” care sunt prezente în alte albume';

  @override
  String get waitingForVerification => 'Se așteaptă verificarea...';

  @override
  String get passkey => 'Cheie de acces';

  @override
  String get passkeyAuthTitle => 'Verificare cheie de acces';

  @override
  String get loginWithTOTP => 'Autentificare cu parolă unică (TOTP)';

  @override
  String get passKeyPendingVerification => 'Verificarea este încă în așteptare';

  @override
  String get loginSessionExpired => 'Sesiune expirată';

  @override
  String get loginSessionExpiredDetails =>
      'Sesiunea a expirat. Vă rugăm să vă autentificați din nou.';

  @override
  String get verifyPasskey => 'Verificați cheia de acces';

  @override
  String get playOnTv => 'Redare album pe TV';

  @override
  String get pair => 'Asociere';

  @override
  String get deviceNotFound => 'Dispozitivul nu a fost găsit';

  @override
  String get castInstruction =>
      'Accesați cast.ente.io de pe dispozitivul pe care doriți să îl asociați.\n\nIntroduceți codul de mai jos pentru a reda albumul pe TV.';

  @override
  String get deviceCodeHint => 'Introduceți codul';

  @override
  String get joinDiscord => 'Alăturați-vă pe Discord';

  @override
  String get locations => 'Locații';

  @override
  String get addAName => 'Adăugați un nume';

  @override
  String get findThemQuickly => 'Găsiți rapid';

  @override
  String get findPeopleByName => 'Găsiți rapid persoane după nume';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Apăsați lung un e-mail pentru a verifica criptarea integrală.';

  @override
  String get developerSettingsWarning =>
      'Sunteți sigur că doriți să modificați setările pentru dezvoltatori?';

  @override
  String get developerSettings => 'Setări dezvoltator';

  @override
  String get serverEndpoint => 'Adresa (endpoint) server-ului';

  @override
  String get invalidEndpoint => 'Endpoint invalid';

  @override
  String get invalidEndpointMessage =>
      'Ne pare rău, endpoint-ul introdus nu este valabil. Vă rugăm să introduceți un endpoint valid și să încercați din nou.';

  @override
  String get endpointUpdatedMessage => 'Endpoint actualizat cu succes';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Conectat la $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Creați un link colaborativ';

  @override
  String get search => 'Căutare';

  @override
  String get enterPersonName => 'Introduceți numele persoanei';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Introduceți numele';

  @override
  String get savePerson => 'Salvați persoana';

  @override
  String get editPerson => 'Editați persoana';

  @override
  String get mergedPhotos => 'Fotografii combinate';

  @override
  String get orMergeWithExistingPerson => 'Sau îmbinați cu cele existente';

  @override
  String get enterDateOfBirth => 'Ziua de naștere (opțional)';

  @override
  String get birthday => 'Ziua de naștere';

  @override
  String get removePersonLabel => 'Eliminați eticheta persoanei';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'Asocierea automată funcționează numai cu dispozitive care acceptă Chromecast.';

  @override
  String get manualPairDesc =>
      'Asocierea cu PIN funcționează cu orice ecran pe care doriți să vizualizați albumul.';

  @override
  String get connectToDevice => 'Conectați-vă la dispozitiv';

  @override
  String get autoCastDialogBody =>
      'Veți vedea dispozitivele disponibile pentru Cast aici.';

  @override
  String get autoCastiOSPermission =>
      'Asigurați-vă că permisiunile de rețea locală sunt activate pentru aplicația Ente Foto, în Setări.';

  @override
  String get noDeviceFound => 'Niciun dispozitiv găsit';

  @override
  String get stopCastingTitle => 'Opriți proiectarea';

  @override
  String get stopCastingBody => 'Doriți să opriți proiectarea?';

  @override
  String get castIPMismatchTitle => 'Nu s-a reușit proiectarea albumului';

  @override
  String get castIPMismatchBody =>
      'Vă rugăm să vă asigurați că sunteți în aceeași rețea cu televizorul.';

  @override
  String get pairingComplete => 'Asociere reușită';

  @override
  String get savingEdits => 'Se salvează editările...';

  @override
  String get autoPair => 'Asociere automată';

  @override
  String get pairWithPin => 'Asociere cu PIN';

  @override
  String get faceRecognition => 'Recunoaștere facială';

  @override
  String get foundFaces => 'S-au găsit fețe';

  @override
  String get clusteringProgress => 'Progres grupare';

  @override
  String get trim => 'Decupare';

  @override
  String get crop => 'Decupare';

  @override
  String get rotate => 'Rotire';

  @override
  String get left => 'Stânga';

  @override
  String get right => 'Dreapta';

  @override
  String get whatsNew => 'Noutăți';

  @override
  String get reviewSuggestions => 'Revizuire sugestii';

  @override
  String get review => 'Examinați';

  @override
  String get useAsCover => 'Utilizați ca și copertă';

  @override
  String notPersonLabel({required String name}) {
    return 'Nu este $name?';
  }

  @override
  String get enable => 'Activare';

  @override
  String get enabled => 'Activat';

  @override
  String get moreDetails => 'Mai multe detalii';

  @override
  String get enableMLIndexingDesc =>
      'Ente acceptă învățarea automată pe dispozitiv pentru recunoaștere facială, căutarea magică și alte funcții avansate de căutare';

  @override
  String get magicSearchHint =>
      'Căutarea magică permite căutarea fotografiilor după conținutul lor, de exemplu, „floare”, „mașină roșie”, „documente de identitate”';

  @override
  String get panorama => 'Panoramă';

  @override
  String get reenterPassword => 'Reintroduceți parola';

  @override
  String get reenterPin => 'Reintroduceți codul PIN';

  @override
  String get deviceLock => 'Blocare dispozitiv';

  @override
  String get pinLock => 'Blocare PIN';

  @override
  String get next => 'Înainte';

  @override
  String get setNewPassword => 'Setați parola noua';

  @override
  String get enterPin => 'Introduceţi codul PIN';

  @override
  String get setNewPin => 'Setați un cod nou PIN';

  @override
  String get appLock => 'Blocare aplicație';

  @override
  String get noSystemLockFound => 'Nu s-a găsit nicio blocare de sistem';

  @override
  String get tapToUnlock => 'Atingeți pentru a debloca';

  @override
  String get tooManyIncorrectAttempts => 'Prea multe încercări incorecte';

  @override
  String get videoInfo => 'Informaţii video';

  @override
  String get autoLock => 'Blocare automată';

  @override
  String get immediately => 'Imediat';

  @override
  String get autoLockFeatureDescription =>
      'Timpul după care aplicația se blochează după ce a fost pusă în fundal';

  @override
  String get hideContent => 'Ascundeți conținutul';

  @override
  String get hideContentDescriptionAndroid =>
      'Ascunde conținutul aplicației în comutatorul de aplicații și dezactivează capturile de ecran';

  @override
  String get hideContentDescriptionIos =>
      'Ascunde conținutul aplicației în comutatorul de aplicații';

  @override
  String get passwordStrengthInfo =>
      'Puterea parolei este calculată luând în considerare lungimea parolei, caracterele utilizate și dacă parola apare sau nu în top 10.000 cele mai utilizate parole';

  @override
  String get noQuickLinksSelected => 'Nu au fost găsite linkuri rapide';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Vă rugăm să selectați linkurile rapide de eliminat';

  @override
  String get removePublicLinks => 'Eliminați linkurile publice';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Se vor elimina linkurile publice ale linkurilor rapide selectate.';

  @override
  String get guestView => 'Mod oaspete';

  @override
  String get guestViewEnablePreSteps =>
      'Pentru a activa modul oaspete, vă rugăm să configurați codul de acces al dispozitivului sau blocarea ecranului în setările sistemului.';

  @override
  String get nameTheAlbum => 'Denumiți albumul';

  @override
  String get collectPhotosDescription =>
      'Creați un link unde prietenii dvs. pot încărca fotografii la calitatea originală.';

  @override
  String get collect => 'Colectare';

  @override
  String get appLockDescriptions =>
      'Alegeți între ecranul de blocare implicit al dispozitivului dvs. și un ecran de blocare personalizat cu PIN sau parolă.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Pentru a activa blocarea aplicației, vă rugăm să configurați codul de acces al dispozitivului sau blocarea ecranului în setările sistemului.';

  @override
  String get authToViewPasskey =>
      'Vă rugăm să vă autentificați pentru a vizualiza cheia de acces';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Se pare că ceva nu a mers bine, deoarece sincronizarea fotografiilor locale durează mai mult decât ne așteptam. Vă rugăm să contactați echipa noastră de asistență';

  @override
  String get showPerson => 'Afișare persoană';

  @override
  String get sort => 'Sortare';

  @override
  String get mostRecent => 'Cele mai recente';

  @override
  String get mostRelevant => 'Cele mai relevante';

  @override
  String get loadingYourPhotos => 'Se încarcă fotografiile dvs...';

  @override
  String processingImport({required Object folderName}) {
    return 'Se procesează $folderName...';
  }

  @override
  String get personName => 'Numele persoanei';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Adăugare persoană nouă';

  @override
  String get addNameOrMerge => 'Adăugare nume sau îmbinare';

  @override
  String get mergeWithExisting => 'Îmbinare cu unul existent';

  @override
  String get newPerson => 'Persoană nouă';

  @override
  String get addName => 'Adăugare nume';

  @override
  String get add => 'Adăugare';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'S-au găsit fotografii extra pentru $text';
  }

  @override
  String get extraPhotosFound => 'S-au găsit fotografii extra';

  @override
  String get configuration => 'Configurare';

  @override
  String get localIndexing => 'Indexare locală';

  @override
  String get processed => 'Procesate';

  @override
  String get resetPerson => 'Eliminare';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Sunteți sigur că doriți să resetaţi această persoană?';

  @override
  String get allPersonGroupingWillReset =>
      'Toate grupările pentru această persoană vor fi resetate și veți pierde toate sugestiile făcute pentru această persoană';

  @override
  String get yesResetPerson => 'Da, resetează persoana';

  @override
  String get onlyThem => 'Numai el/ea';

  @override
  String get checkingModels => 'Se verifică modelele...';

  @override
  String get enableMachineLearningBanner =>
      'Activați învățarea automată pentru a folosi căutarea magică și recunoașterea facială';

  @override
  String get searchDiscoverEmptySection =>
      'Imaginile vor fi afișate aici odată ce procesarea și sincronizarea este completă';

  @override
  String get searchPersonsEmptySection =>
      'Persoanele vor fi afișate aici odată ce procesarea și sincronizarea este completă';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count collaborators',
      one: 'Added 1 collaborator',
      zero: 'Added 0 collaborator',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Contul este deja configurat.';

  @override
  String get sessionIdMismatch => 'Nepotrivire ID sesiune';

  @override
  String get failedToFetchActiveSessions =>
      'Nu s-a reușit preluarea sesiunilor active';

  @override
  String get failedToRefreshStripeSubscription =>
      'Nu s-a reușit reîmprospătarea abonamentului';

  @override
  String get failedToPlayVideo => 'Eroare la redarea videoclipului';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Încărcare ignorată din motivul $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Tipul de galerie $galleryType nu este acceptat pentru redenumire';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Atingeți pentru a încărca, încărcarea este ignorată în prezent datorită $ignoreReason';
  }

  @override
  String get tapToUpload => 'Atingeți pentru a încărca';

  @override
  String get info => 'Informații';

  @override
  String get addFiles => 'Adăugați fișiere';

  @override
  String get castAlbum => 'Difuzați albumul';

  @override
  String get imageNotAnalyzed => 'Imaginea nu a fost analizată';

  @override
  String get noFacesFound => 'Nu au fost găsite fețe';

  @override
  String get fileNotUploadedYet => 'Fișierul nu a fost încărcat încă';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Nicio sugestie pentru $personName';
  }

  @override
  String get month => 'lună';

  @override
  String get yearShort => 'an';

  @override
  String get currentlyRunning => 'rulează în prezent';

  @override
  String get ignored => 'ignorat';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Fișier';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Lungimea secțiunilor nu se potrivesc: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Selectați aplicația de e-mail';

  @override
  String get selectAllShort => 'Toate';

  @override
  String get selectCoverPhoto => 'Selectați fotografia de copertă';

  @override
  String get newLocation => 'Locație nouă';

  @override
  String get faceNotClusteredYet =>
      'Fața nu este încă grupată, vă rugăm să reveniți mai târziu';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Linkul pe care încercați să îl accesați a expirat.';

  @override
  String get openFile => 'Deschidere fișier';

  @override
  String get backupFile => 'Salvare fișier';

  @override
  String get openAlbumInBrowser => 'Deschideți albumul în browser';

  @override
  String get openAlbumInBrowserTitle =>
      'Vă rugăm să utilizați aplicația web pentru a adăuga fotografii la acest album';

  @override
  String get allow => 'Permiteți';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Permiteți aplicației să deschidă link-uri de album partajate';

  @override
  String get seePublicAlbumLinksInApp =>
      'Vedeți linkurile albumelor publice în aplicație';

  @override
  String get emergencyContacts => 'Contacte de urgență';

  @override
  String get acceptTrustInvite => 'Acceptați invitația';

  @override
  String get declineTrustInvite => 'Refuzați invitația';

  @override
  String get removeYourselfAsTrustedContact =>
      'Eliminați-vă ca persoană de contact de încredere';

  @override
  String get legacy => 'Moștenire';

  @override
  String get legacyPageDesc =>
      'Moștenirea permite contactelor de încredere să vă acceseze contul în absența dvs.';

  @override
  String get legacyPageDesc2 =>
      'Persoanele de contact de încredere pot iniția recuperarea contului și, dacă nu este blocată în termen de 30 de zile, vă pot reseta parola și accesa contul.';

  @override
  String get legacyAccounts => 'Conturi de moștenire';

  @override
  String get trustedContacts => 'Contacte de încredere';

  @override
  String get addTrustedContact => 'Adăugare contact de încredere';

  @override
  String get removeInvite => 'Eliminare invitație';

  @override
  String get recoveryWarning =>
      'Un contact de încredere încearcă să vă acceseze contul';

  @override
  String get rejectRecovery => 'Respingeți recuperarea';

  @override
  String get recoveryInitiated => 'Recuperare inițiată';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Puteți accesa contul după $days zile. O notificare va fi trimisă la $email.';
  }

  @override
  String get cancelAccountRecovery => 'Anulare recuperare';

  @override
  String get recoveryAccount => 'Recuperare cont';

  @override
  String get cancelAccountRecoveryBody =>
      'Sunteți sigur că doriți să anulați recuperarea?';

  @override
  String get startAccountRecoveryTitle => 'Începeți recuperarea';

  @override
  String get whyAddTrustContact =>
      'Contactul de încredere vă poate ajuta la recuperarea datelor.';

  @override
  String recoveryReady({required String email}) {
    return 'Acum puteți recupera contul $email setând o nouă parolă.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email încearcă să vă recupereze contul.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Ați fost învitat să fiți un contact de moștenire de către $email.';
  }

  @override
  String get warning => 'Atenție';

  @override
  String get proceed => 'Continuați';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Sunteți pe cale să adăugați $email ca persoană de contact de încredere. Acesta va putea să vă recupereze contul dacă lipsiți timp de $numOfDays de zile.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email v-a invitat să fiți un contact de încredere';
  }

  @override
  String get authToManageLegacy =>
      'Vă rugăm să vă autentificați pentru a gestiona contactele de încredere';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Ascundeți elementele distribuite din galeria principală';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galerie';

  @override
  String get joinAlbum => 'Alăturați-vă albumului';

  @override
  String get joinAlbumSubtext => 'pentru a vedea și a adăuga fotografii';

  @override
  String get joinAlbumSubtextViewer =>
      'pentru a adăuga la albumele distribuite';

  @override
  String get join => 'Alăturare';

  @override
  String get linkEmail => 'Link email';

  @override
  String get link => 'Link';

  @override
  String get noEnteAccountExclamation => 'No Ente account!';

  @override
  String get orPickFromYourContacts => 'or pick from your contacts';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email does not have an Ente account.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Me)';
  }

  @override
  String get reassignMe => 'Reassign \"Me\"';

  @override
  String get me => 'Me';

  @override
  String get linkEmailToContactBannerCaption => 'for faster sharing';

  @override
  String get selectPersonToLink => 'Select person to link';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Link person to $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'This will link $personName to $email';
  }

  @override
  String get selectYourFace => 'Select your face';

  @override
  String get reassigningLoading => 'Reassigning...';

  @override
  String reassignedToName({required String name}) {
    return 'Reassigned you to $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'Save changes before leaving?';

  @override
  String get dontSave => 'Don\'t save';

  @override
  String get thisIsMeExclamation => 'This is me!';

  @override
  String get linkPerson => 'Link person';

  @override
  String get linkPersonCaption => 'for better sharing experience';

  @override
  String get videoStreaming => 'Streamable videos';

  @override
  String get processingVideos => 'Processing videos';

  @override
  String get streamDetails => 'Stream details';

  @override
  String get processing => 'Processing';

  @override
  String get queued => 'Queued';

  @override
  String get ineligible => 'Ineligible';

  @override
  String get failed => 'Failed';

  @override
  String get playStream => 'Play stream';

  @override
  String get playOriginal => 'Play original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Joining an album will make your email visible to its participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Please wait, this will take a while.';

  @override
  String get editTime => 'Edit time';

  @override
  String get selectTime => 'Select time';

  @override
  String get selectDate => 'Select date';

  @override
  String get previous => 'Previous';

  @override
  String get selectOneDateAndTimeForAll => 'Select one date and time for all';

  @override
  String get selectStartOfRange => 'Select start of range';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'This will make the date and time of all selected photos the same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'This is the first in the group. Other selected photos will automatically shift based on this new date';

  @override
  String get newRange => 'New range';

  @override
  String get selectOneDateAndTime => 'Select one date and time';

  @override
  String get moveSelectedPhotosToOneDate => 'Move selected photos to one date';

  @override
  String get shiftDatesAndTime => 'Shift dates and time';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Photos keep relative time difference';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'App icon';

  @override
  String get notThisPerson => 'Not this person?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Selected items will be removed from this person, but not deleted from your library.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat through the years';
  }

  @override
  String get thisWeekThroughTheYears => 'This week through the years';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'This week, $count years ago',
      one: 'This week, $count year ago',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'You and $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admiring $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embracing $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Party with $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Hiking with $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feasting with $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies with $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posing with $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Beautiful views with $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sports with $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Road trip with $name';
  }

  @override
  String get spotlightOnYourself => 'Spotlight on yourself';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spotlight on $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name is $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name turning $age soon';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Last time with $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Trip to $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Trip in $year';
  }

  @override
  String get lastYearsTrip => 'Last year\'s trip';

  @override
  String get sunrise => 'On the horizon';

  @override
  String get mountains => 'Over the hills';

  @override
  String get greenery => 'The green life';

  @override
  String get beach => 'Sand and sea';

  @override
  String get city => 'In the city';

  @override
  String get moon => 'In the moonlight';

  @override
  String get onTheRoad => 'On the road again';

  @override
  String get food => 'Culinary delight';

  @override
  String get pets => 'Furry companions';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memories';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Past years\' memories';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Happy birthday! 🥳';

  @override
  String get birthdays => 'Birthdays';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Other detected faces';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Save as another person';

  @override
  String get showLessFaces => 'Show less faces';

  @override
  String get showMoreFaces => 'Show more faces';

  @override
  String get ignore => 'Ignore';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Prezentăm Ritualuri';

  @override
  String get cLDesc1 =>
      'Planificați rezoluții pentru 2026? Cu Ritualuri, puteți seta un memento în Ente Photos și vă urmăriți progresul făcând fotografii. Folosiți-l pentru antrenamente, obiceiuri alimentare, momente zilnice cu cei dragi – orice doriți să transformați într-un obicei.';

  @override
  String get cLTitle2 => 'Linkuri publice, acum pentru toată lumea';

  @override
  String get cLDesc2 =>
      'Toți utilizatorii Ente pe planul gratuit pot crea și partaja linkuri publice către fotografii și albume. Pentru a preveni abuzurile, linkurile vor avea limite privind câte persoane le pot vizualiza.';

  @override
  String get cLTitle3 => 'Etichetați manual persoane';

  @override
  String get cLDesc3 =>
      'Acum puteți eticheta persoane chiar și când AI-ul nostru pe dispozitiv nu detectează o față. Util pentru animale de companie, fețe parțial vizibile sau momente în care cineva nu este de fapt în fotografie, dar ar trebui să fie inclus.';

  @override
  String get cLTitle4 => 'Și mai multe';

  @override
  String get cLDesc4 =>
      'Acum puteți fixa albumele partajate. Linkurile albumelor sunt vizibile pentru colaboratori și vizualizatori pentru a face partajarea și mai ușoară. Am reparat câteva bug-uri de glisare pe iOS și am actualizat vizualizarea fotografiilor, inclusiv o nouă pictogramă de favorite (făcând loc pentru funcțiile viitoare).';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
