// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Lithuanian (`lt`).
class AppLocalizationsLt extends AppLocalizations {
  AppLocalizationsLt([String locale = 'lt']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Įveskite savo el. pašto adresą';

  @override
  String get enterYourNewEmailAddress => 'Įveskite savo naują el. pašto adresą';

  @override
  String get accountWelcomeBack => 'Sveiki sugrįžę!';

  @override
  String get emailAlreadyRegistered => 'El. paštas jau užregistruotas.';

  @override
  String get emailNotRegistered => 'El. paštas neregistruotas.';

  @override
  String get email => 'El. paštas';

  @override
  String get cancel => 'Atšaukti';

  @override
  String get verify => 'Patvirtinti';

  @override
  String get invalidEmailAddress => 'Netinkamas el. pašto adresas';

  @override
  String get enterValidEmail => 'Įveskite tinkamą el. pašto adresą.';

  @override
  String get deleteAccount => 'Ištrinti paskyrą';

  @override
  String get deleteAccountWarning =>
      'Tai ištrins jūsų „Ente Auth“, „Ente“ nuotraukos ir „Ente“ sandėlio paskyras.';

  @override
  String get askDeleteReason =>
      'Kokia yra pagrindinė priežastis, dėl kurios ištrinate savo paskyrą?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Apgailestaujame, kad išeinate. Pasidalykite savo atsiliepimais, kad padėtumėte mums tobulėti.';

  @override
  String get feedback => 'Atsiliepimai';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Maloniai padėkite mums su šia informacija.';

  @override
  String get confirmDeletePrompt =>
      'Taip, noriu negrįžtamai ištrinti šią paskyrą ir jos duomenis per visas programas';

  @override
  String get confirmAccountDeletion => 'Patvirtinti paskyros ištrynimą';

  @override
  String get deleteAccountPermanentlyButton => 'Ištrinti paskyrą negrįžtamai';

  @override
  String get yourAccountHasBeenDeleted => 'Jūsų paskyra ištrinta';

  @override
  String get selectReason => 'Pasirinkite priežastį';

  @override
  String get deleteReason1 =>
      'Trūksta pagrindinės funkcijos, kurios man reikia';

  @override
  String get deleteReason2 =>
      'Programa arba tam tikra funkcija nesielgia taip, kaip, mano manymu, turėtų elgtis';

  @override
  String get deleteReason3 => 'Radau kitą paslaugą, kuri man patinka labiau';

  @override
  String get deleteReason4 => 'Mano priežastis nenurodyta';

  @override
  String get sendEmail => 'Siųsti el. laišką';

  @override
  String get deleteRequestSLAText =>
      'Jūsų prašymas bus apdorotas per 72 valandas.';

  @override
  String get deleteEmailRequest =>
      'Iš savo registruoto el. pašto adreso siųskite el. laišką adresu <warning>account-deletion@ente.io</warning>.';

  @override
  String get entePhotosPerm =>
      '„Ente“ <i>reikia leidimo</i> išsaugoti jūsų nuotraukas';

  @override
  String get ok => 'Gerai';

  @override
  String get createAccount => 'Kurti paskyrą';

  @override
  String get createNewAccount => 'Kurti naują paskyrą';

  @override
  String get password => 'Slaptažodis';

  @override
  String get confirmPassword => 'Patvirtinkite slaptažodį';

  @override
  String get activeSessions => 'Aktyvūs seansai';

  @override
  String get ocrProcessingOverlayMessage => 'Aptikiamas tekstas...';

  @override
  String get ocrLoadingIndicatorLabel => 'Aptikiamas tekstas';

  @override
  String get ocrSelectionHint =>
      'Perbraukite arba dukart palieskite, kad pasirinktumėte, ko jums reikia.';

  @override
  String get ocrNoTextDetected => 'Tekstas neaptiktas';

  @override
  String get ocrRetryButtonLabel => 'Kartoti';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Tinklo ryšys privalomas norint atsisiųsti OCR modelius pirmojo naudojimo metu.';

  @override
  String get ocrModelsPrepareFailed => 'Nepavyko parengti OCR modelių.';

  @override
  String get ocrImageNotFoundError => 'Vaizdo failas nerastas.';

  @override
  String get ocrImageDecodeFailedError => 'Nepavyko perskaityti vaizdo failo.';

  @override
  String get ocrGenericDetectError => 'Nepavyko aptikti teksto vaizde.';

  @override
  String get oops => 'Ups';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Kažkas nutiko ne taip. Bandykite dar kartą.';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Tai jus atjungs nuo šio įrenginio.';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Tai jus atjungs nuo toliau nurodyto įrenginio:';

  @override
  String get terminateSession => 'Baigti seansą?';

  @override
  String get terminate => 'Baigti';

  @override
  String get thisDevice => 'Šis įrenginys';

  @override
  String get recoverButton => 'Atkurti';

  @override
  String get recoverySuccessful => 'Atkūrimas sėkmingas.';

  @override
  String get decrypting => 'Iššifruojama...';

  @override
  String get incorrectRecoveryKeyTitle => 'Neteisingas atkūrimo raktas';

  @override
  String get incorrectRecoveryKeyBody =>
      'Įvestas atkūrimo raktas yra neteisingas.';

  @override
  String get forgotPassword => 'Pamiršau slaptažodį';

  @override
  String get enterYourRecoveryKey => 'Įveskite atkūrimo raktą';

  @override
  String get noRecoveryKey => 'Neturite atkūrimo rakto?';

  @override
  String get sorry => 'Atsiprašome';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Dėl mūsų visapusio šifravimo protokolo pobūdžio jūsų duomenų negalima iššifruoti be slaptažodžio arba atkūrimo rakto';

  @override
  String get verifyEmail => 'Patvirtinti el. paštą';

  @override
  String get toResetVerifyEmail =>
      'Kad iš naujo nustatytumėte slaptažodį, pirmiausia patvirtinkite savo el. paštą.';

  @override
  String get checkInboxAndSpamFolder =>
      'Patikrinkite savo gautieją (ir šlamštą), kad užbaigtumėte patvirtinimą';

  @override
  String get tapToEnterCode => 'Palieskite, kad įvestumėte kodą';

  @override
  String get resendEmail => 'Iš naujo siųsti el. laišką';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Išsiuntėme laišką adresu <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Nustatyti slaptažodį';

  @override
  String get changePasswordTitle => 'Keisti slaptažodį';

  @override
  String get resetPasswordTitle => 'Nustatyti slaptažodį iš naujo';

  @override
  String get encryptionKeys => 'Šifravimo raktai';

  @override
  String get passwordWarning =>
      'Šio slaptažodžio nesaugome, todėl jei jį pamiršite, <underline>negalėsime iššifruoti jūsų duomenų</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Įveskite slaptažodį, kurį galime naudoti jūsų duomenims šifruoti';

  @override
  String get enterNewPasswordToEncrypt =>
      'Įveskite naują slaptažodį, kurį galime naudoti jūsų duomenims šifruoti';

  @override
  String get weakStrength => 'Silpna';

  @override
  String get strongStrength => 'Stipri';

  @override
  String get moderateStrength => 'Vidutinė';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Slaptažodžio stiprumas: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Slaptažodis sėkmingai pakeistas';

  @override
  String get generatingEncryptionKeys => 'Generuojami šifravimo raktai...';

  @override
  String get pleaseWait => 'Palaukite...';

  @override
  String get continueLabel => 'Tęsti';

  @override
  String get insecureDevice => 'Nesaugus įrenginys';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Atsiprašome, šiame įrenginyje nepavyko sugeneruoti saugių raktų.\n\nRegistruokitės iš kito įrenginio.';

  @override
  String get howItWorks => 'Kaip tai veikia';

  @override
  String get encryption => 'Šifravimas';

  @override
  String get ackPasswordLostWarning =>
      'Suprantu, kad jei prarasiu slaptažodį, galiu prarasti savo duomenis, kadangi mano duomenys yra <underline>visapusiškai užšifruoti</underline>';

  @override
  String get privacyPolicyTitle => 'Privatumo politika';

  @override
  String get termsOfServicesTitle => 'Sąlygos';

  @override
  String get signUpTerms =>
      'Sutinku su <u-terms>paslaugų sąlygomis</u-terms> ir <u-policy> privatumo politika</u-policy>';

  @override
  String get logInLabel => 'Prisijungti';

  @override
  String get loginTerms =>
      'Spustelėjus Prisijungti sutinku su <u-terms>paslaugų sąlygomis</u-terms> ir <u-policy> privatumo politika</u-policy>';

  @override
  String get changeEmail => 'Keisti el. paštą';

  @override
  String get enterYourPassword => 'Įveskite savo slaptažodį';

  @override
  String get welcomeBack => 'Sveiki sugrįžę!';

  @override
  String get contactSupport => 'Susisiekti su palaikymo komanda';

  @override
  String get locationPickerTip =>
      'Taip pat galite pridėti vietą, centruotą ant nuotraukos, iš nuotraukos informacijos ekrano.';

  @override
  String get incorrectPasswordTitle => 'Neteisingas slaptažodis';

  @override
  String get pleaseTryAgain => 'Bandykite dar kartą.';

  @override
  String get recreatePasswordTitle => 'Iš naujo sukurti slaptažodį';

  @override
  String get useRecoveryKey => 'Naudoti atkūrimo raktą';

  @override
  String get recreatePasswordBody =>
      'Dabartinis įrenginys nėra pakankamai galingas, kad patvirtintų jūsų slaptažodį, bet mes galime iš naujo sugeneruoti taip, kad jis veiktų su visais įrenginiais.\n\nPrisijunkite naudojant atkūrimo raktą ir sugeneruokite iš naujo slaptažodį (jei norite, galite vėl naudoti tą patį).';

  @override
  String get verifyPassword => 'Patvirtinkite slaptažodį';

  @override
  String get recoveryKey => 'Atkūrimo raktas';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Jei pamiršote slaptažodį, vienintelis būdas atkurti duomenis – naudoti šį raktą.';

  @override
  String get recoveryKeySaveDescription =>
      'Šio rakto nesaugome, todėl išsaugokite šį 24 žodžių raktą saugioje vietoje.';

  @override
  String get doThisLater => 'Daryti tai vėliau';

  @override
  String get saveKey => 'Išsaugoti raktą';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Nukopijuotas atkūrimo raktas į iškarpinę';

  @override
  String get recoverAccount => 'Atkurti paskyrą';

  @override
  String get recover => 'Atkurti';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Iš savo registruoto el. pašto adreso atsiųskite el. laišką adresu $supportEmail';
  }

  @override
  String get twofactorSetup => 'Dvigubo tapatybės nustatymo sąranka';

  @override
  String get enterCode => 'Įvesti kodą';

  @override
  String get scanCode => 'Skenuoti kodą';

  @override
  String get codeCopiedToClipboard => 'Nukopijuotas kodas į iškarpinę';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Nukopijuokite ir įklijuokite šį kodą\nį autentifikatoriaus programą';

  @override
  String get tapToCopy => 'palieskite, kad nukopijuotumėte';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Skenuokite šį QR kodą\nsu autentifikatoriaus programa';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Įveskite 6 skaitmenų kodą\niš autentifikatoriaus programos';

  @override
  String get confirm => 'Patvirtinti';

  @override
  String get setupComplete => 'Sąranka baigta';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Išsaugokite atkūrimo raktą, jei dar to nepadarėte';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Tai gali būti naudojama paskyrai atkurti, jei prarandate dvigubo tapatybės nustatymą';

  @override
  String get twofactorAuthenticationPageTitle =>
      'Dvigubas tapatybės nustatymas';

  @override
  String get lostDevice => 'Prarastas įrenginys?';

  @override
  String get verifyingRecoveryKey => 'Patvirtinima atkūrimo raktą...';

  @override
  String get recoveryKeyVerified => 'Patvirtintas atkūrimo raktas';

  @override
  String get recoveryKeySuccessBody =>
      'Puiku! Jūsų atkūrimo raktas tinkamas. Dėkojame už patvirtinimą.\n\nNepamirškite sukurti saugią atkūrimo rakto atsarginę kopiją.';

  @override
  String get invalidRecoveryKey =>
      'Įvestas atkūrimo raktas yra netinkamas. Įsitikinkite, kad jame yra 24 žodžiai, ir patikrinkite kiekvieno iš jų rašybą.\n\nJei įvedėte senesnį atkūrimo kodą, įsitikinkite, kad jis yra 64 simbolių ilgio, ir patikrinkite kiekvieną iš jų.';

  @override
  String get invalidKey => 'Netinkamas raktas.';

  @override
  String get tryAgain => 'Bandyti dar kartą';

  @override
  String get viewRecoveryKey => 'Peržiūrėti atkūrimo raktą';

  @override
  String get confirmRecoveryKey => 'Patvirtinkite atkūrimo raktą';

  @override
  String get recoveryKeyVerifyReason =>
      'Atkūrimo raktas – vienintelis būdas atkurti nuotraukas, jei pamiršote slaptažodį. Atkūrimo raktą galite rasti Nustatymose > Paskyra.\n\nĮveskite savo atkūrimo raktą čia, kad patvirtintumėte, ar teisingai jį išsaugojote.';

  @override
  String get confirmYourRecoveryKey => 'Patvirtinkite savo atkūrimo raktą';

  @override
  String get addViewer => 'Pridėti žiūrėtoją';

  @override
  String get addCollaborator => 'Pridėti bendradarbį';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Įtraukite naują el. paštą';

  @override
  String get orPickAnExistingOne => 'Arba pasirinkite esamą';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Bendradarbiai gali pridėti nuotraukų ir vaizdo įrašų į bendrintą albumą.';

  @override
  String get enterEmail => 'Įveskite el. paštą';

  @override
  String get albumOwner => 'Savininkas';

  @override
  String get you => 'Jūs';

  @override
  String get collaborator => 'Bendradarbis';

  @override
  String get addMore => 'Pridėti daugiau';

  @override
  String get viewer => 'Žiūrėtojas';

  @override
  String get remove => 'Šalinti';

  @override
  String get removeParticipant => 'Šalinti dalyvį';

  @override
  String get manage => 'Tvarkyti';

  @override
  String get addedAs => 'Pridėta kaip';

  @override
  String get changePermissions => 'Keisti leidimus?';

  @override
  String get yesConvertToViewer => 'Taip, keisti į žiūrėtoją';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user negalės pridėti daugiau nuotraukų į šį albumą\n\nJie vis tiek galės pašalinti esamas pridėtas nuotraukas';
  }

  @override
  String get allowAddingPhotos => 'Leisti pridėti nuotraukų';

  @override
  String get allowJoiningAlbum => 'Leisti jungtis prie albumo';

  @override
  String get allowAddPhotosDescription =>
      'Leiskite nuorodą turintiems asmenims taip pat pridėti nuotraukų į bendrinamą albumą.';

  @override
  String get passwordLock => 'Slaptažodžio užraktas';

  @override
  String get canNotOpenTitle => 'Negalima atverti šio albumo';

  @override
  String get canNotOpenBody =>
      'Atsiprašome, šio albumo negalima atverti programoje.';

  @override
  String get disableDownloadWarningTitle => 'Atkreipkite dėmesį';

  @override
  String get disableDownloadWarningBody =>
      'Žiūrėtojai vis tiek gali daryti ekrano kopijas arba išsaugoti nuotraukų kopijas naudojant išorinius įrankius';

  @override
  String get allowDownloads => 'Leisti atsisiuntimus';

  @override
  String get linkDeviceLimit => 'Įrenginių riba';

  @override
  String get noDeviceLimit => 'Jokio';

  @override
  String get albumLayout => 'Albumo išdėstymas';

  @override
  String get layoutGrouped => 'Sugrupuoti';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Nuorodos galiojimo laikas';

  @override
  String get linkExpired => 'Nebegalioja';

  @override
  String get linkEnabled => 'Įjungta';

  @override
  String get linkNeverExpires => 'Niekada';

  @override
  String get expiredLinkInfo =>
      'Ši nuoroda nebegalioja. Pasirinkite naują galiojimo laiką arba išjunkite nuorodos galiojimo laiką.';

  @override
  String get setAPassword => 'Nustatyti slaptažodį';

  @override
  String get lockButtonLabel => 'Užrakinti';

  @override
  String get enterPassword => 'Įveskite slaptažodį';

  @override
  String get removeLink => 'Šalinti nuorodą';

  @override
  String get manageLink => 'Tvarkyti nuorodą';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Nuoroda nebegalios $expiryTime';
  }

  @override
  String get albumUpdated => 'Atnaujintas albumas';

  @override
  String get never => 'Niekada';

  @override
  String get custom => 'Pasirinktinis';

  @override
  String get after1Hour => 'Po 1 valandos';

  @override
  String get after1Day => 'Po 1 dienos';

  @override
  String get after1Week => 'Po 1 savaitės';

  @override
  String get after1Month => 'Po 1 mėnesio';

  @override
  String get after1Year => 'Po 1 metų';

  @override
  String get manageParticipants => 'Tvarkyti';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dalyviai',
      one: '1 dalyvis',
      zero: 'Nėra dalyvių',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Sukurkite nuorodą, kad asmenys galėtų pridėti ir peržiūrėti nuotraukas bendrinamame albume, nereikalaujant „Ente“ programos ar paskyros. Puikiai tinka įvykių nuotraukoms rinkti.';

  @override
  String get collectPhotos => 'Rinkti nuotraukas';

  @override
  String get collaborativeLink => 'Bendradarbiavimo nuoroda';

  @override
  String get shareWithNonenteUsers => 'Bendrinkite su ne „Ente“ naudotojais.';

  @override
  String get createPublicLink => 'Kurti viešą nuorodą';

  @override
  String get sendLink => 'Siųsti nuorodą';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Kopijuoti nuorodą';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Nuoroda nebegalioja';

  @override
  String get publicLinkEnabled => 'Įjungta viešoji nuoroda';

  @override
  String get shareALink => 'Bendrinkite nuorodą';

  @override
  String get sharedAlbumSectionDescription =>
      'Sukurkite bendrinamus ir bendradarbiaujamus albumus su kitais „Ente“ naudotojais, įskaitant naudotojus nemokamuose planuose.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Bendrinta su $numberOfPeople asmenimis',
      one: 'Bendrinta su 1 asmeniu',
      zero: 'Bendrinti su konkrečiais asmenimis',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Tai – jūsų patvirtinimo ID';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Asmuo, kuris bendrina albumus su jumis, savo įrenginyje turėtų matyti tą patį ID.';

  @override
  String get howToViewShareeVerificationID =>
      'Paprašykite jų ilgai paspausti savo el. pašto adresą nustatymų ekrane ir patvirtinti, kad abiejų įrenginių ID sutampa.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Tai – $email patvirtinimo ID';
  }

  @override
  String get verificationId => 'Patvirtinimo ID';

  @override
  String verifyEmailID({required Object email}) {
    return 'Patvirtinti $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email neturi „Ente“ paskyros.\n\nSiųskite jiems kvietimą bendrinti nuotraukas.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Štai mano patvirtinimo ID: $verificationID, skirta ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Ei, ar galite patvirtinti, kad tai yra jūsų ente.io patvirtinimo ID: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Kažkas nutiko ne taip';

  @override
  String get sendInvite => 'Siųsti kvietimą';

  @override
  String get shareTextRecommendUsingEnte =>
      'Atsisiųskite „Ente“, kad galėtume lengvai bendrinti originalios kokybės nuotraukas ir vaizdo įrašus.\n\nhttps://ente.io';

  @override
  String get done => 'Atlikta';

  @override
  String get applyCodeTitle => 'Taikyti kodą';

  @override
  String get enterCodeDescription =>
      'Įveskite draugo pateiktą kodą, kad gautumėte nemokamą saugyklą abiem.';

  @override
  String get apply => 'Taikyti';

  @override
  String get failedToApplyCode => 'Nepavyko pritaikyti kodo.';

  @override
  String get enterReferralCode => 'Įveskite rekomendacijos kodą';

  @override
  String get codeAppliedPageTitle => 'Pritaikytas kodas';

  @override
  String get changeYourReferralCode => 'Keisti savo rekomendacijos kodą';

  @override
  String get change => 'Keisti';

  @override
  String get unavailableReferralCode => 'Atsiprašome, šis kodas nepasiekiamas.';

  @override
  String get codeChangeLimitReached =>
      'Atsiprašome, pasiekėte kodo pakeitimų ribą.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Susisiekite su $familyAdminEmail, kad pakeistumėte savo kodą.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Gauta';

  @override
  String get details => 'Išsami informacija';

  @override
  String get claimMore => 'Gaukite daugiau!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Jie taip pat gauna $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB kiekvieną kartą, kai kas nors užsiregistruoja mokamam planui ir pritaiko jūsų kodą.';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return '„Ente“ rekomendacijos kodas: $referralCode \n\nTaikykite jį per Nustatymai → Bendrieji → Rekomendacijos, kad gautumėte $referralStorageInGB GB nemokamai po to, kai užsiregistruosite mokamam planui.\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Gaukite nemokamos saugyklos';

  @override
  String get inviteYourFriends => 'Kviesti savo draugus';

  @override
  String get failedToFetchReferralDetails =>
      'Nepavyksta gauti rekomendacijos išsamios informacijos. Bandykite dar kartą vėliau.';

  @override
  String get referralStep1 => '1. Duokite šį kodą savo draugams';

  @override
  String get referralStep2 => '2. Jie užsiregistruoja mokamą planą';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Abu gaunate $storageInGB GB* nemokamai';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Šiuo metu rekomendacijos yra pristabdytos';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Galite daugiausiai padvigubinti savo saugyklą.';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Jūsų šeima gavo $storageAmountInGb GB iki šiol',
      'false': 'Jūs gavote $storageAmountInGb GB iki šiol',
      'other': 'Jūs gavote $storageAmountInGb GB iki šiol.',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'DUK';

  @override
  String get help => 'Pagalba';

  @override
  String get oopsSomethingWentWrong => 'Ups, kažkas nutiko ne taip';

  @override
  String get peopleUsingYourCode => 'Asmenys, naudojantys jūsų kodą';

  @override
  String get eligible => 'tinkamas';

  @override
  String get total => 'iš viso';

  @override
  String get codeUsedByYou => 'Jūsų naudojamas kodas';

  @override
  String get freeStorageClaimed => 'Gauta nemokama saugykla';

  @override
  String get freeStorageUsable => 'Naudojama nemokama saugykla';

  @override
  String get usableReferralStorageInfo =>
      'Naudojama saugykla ribojama pagal jūsų dabartinį planą. Perteklinė gauta saugykla automatiškai taps tinkama naudoti, kai pakeisite planą.';

  @override
  String get removeFromAlbumTitle => 'Pašalinti iš albumo?';

  @override
  String get removeFromAlbum => 'Šalinti iš albumo';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Pasirinkti elementai bus pašalinti iš šio albumo';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Pridedama prie mėgstamų...';

  @override
  String get removingFromFavorites => 'Pašalinama iš mėgstamų...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Atsiprašome, nepavyko pridėti prie mėgstamų.';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Atsiprašome, nepavyko pašalinti iš mėgstamų.';

  @override
  String get subscribeToEnableSharing =>
      'Kad įjungtumėte bendrinimą, reikia aktyvios mokamos prenumeratos.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'Prenumeruoti';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Galima pašalinti tik jums priklausančius failus';

  @override
  String get deleteSharedAlbum => 'Ištrinti bendrinamą albumą?';

  @override
  String get deleteAlbum => 'Ištrinti albumą';

  @override
  String get deleteAlbumDialog =>
      'Taip pat ištrinti šiame albume esančias nuotraukas (ir vaizdo įrašus) iš <bold>visų</bold> kitų albumų, kuriuose jos yra dalis?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Albumas bus ištrintas visiems.\n\nPrarasite prieigą prie bendrinamų nuotraukų, esančių šiame albume ir priklausančių kitiems.';

  @override
  String get yesRemove => 'Taip, šalinti';

  @override
  String get creatingLink => 'Kuriama nuoroda...';

  @override
  String get removeWithQuestionMark => 'Šalinti?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail bus pašalintas iš šio bendrinamo albumo.\n\nVisos jų pridėtos nuotraukos taip pat bus pašalintos iš albumo.';
  }

  @override
  String get keepPhotos => 'Palikti nuotraukas';

  @override
  String get deletePhotos => 'Ištrinti nuotraukas';

  @override
  String get inviteToEnte => 'Kviesti į „Ente“';

  @override
  String get removePublicLink => 'Šalinti viešą nuorodą';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Tai pašalins viešą nuorodą, skirtą pasiekti „$albumName“.';
  }

  @override
  String get sharing => 'Bendrinima...';

  @override
  String get youCannotShareWithYourself => 'Negalite bendrinti su savimi.';

  @override
  String get archive => 'Archyvas';

  @override
  String get createAlbumActionHint =>
      'Ilgai paspauskite, kad pasirinktumėte nuotraukas, ir spustelėkite +, kad sukurtumėte albumą';

  @override
  String get importing => 'Importuojama....';

  @override
  String get failedToLoadAlbums => 'Nepavyko įkelti albumų.';

  @override
  String get hidden => 'Paslėpti';

  @override
  String get authToViewYourHiddenFiles =>
      'Nustatykite tapatybę, kad peržiūrėtumėte paslėptus failus';

  @override
  String get authToViewTrashedFiles =>
      'Nustatykite tapatybę, kad peržiūrėtumėte išmestus failus';

  @override
  String get trash => 'Šiukšlinė';

  @override
  String get uncategorized => 'Nekategorizuoti';

  @override
  String get videoSmallCase => 'vaizdo įrašas';

  @override
  String get photoSmallCase => 'nuotrauka';

  @override
  String get singleFileDeleteHighlight => 'Jis bus ištrintas iš visų albumų.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Šis $fileType yra ir saugykloje „Ente“ bei įrenginyje.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Šis $fileType bus ištrintas iš „Ente“.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Šis $fileType bus ištrintas iš jūsų įrenginio.';
  }

  @override
  String get deleteFromEnte => 'Ištrinti iš „Ente“';

  @override
  String get yesDelete => 'Taip, ištrinti';

  @override
  String get movedToTrash => 'Perkelta į šiukšlinę';

  @override
  String get deleteFromDevice => 'Ištrinti iš įrenginio';

  @override
  String get deleteFromBoth => 'Ištrinti iš abiejų';

  @override
  String get newAlbum => 'Naujas albumas';

  @override
  String get albums => 'Albumai';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount prisiminimų',
      one: '$formattedCount prisiminimas',
      zero: 'nėra prisiminimų',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count pasirinkta';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count pasirinkta ($yourCount jūsų)';
  }

  @override
  String get advancedSettings => 'Išplėstiniai';

  @override
  String get photoGridSize => 'Nuotraukų tinklelio dydis';

  @override
  String get manageDeviceStorage => 'Tvarkyti įrenginio podėlį';

  @override
  String get manageDeviceStorageDesc =>
      'Peržiūrėkite ir išvalykite vietinę podėlį.';

  @override
  String get machineLearning => 'Mašininis mokymasis';

  @override
  String get mlConsent => 'Įjungti mašininį mokymąsi';

  @override
  String get mlConsentTitle => 'Įjungti mašininį mokymąsi?';

  @override
  String get mlConsentDescription =>
      'Jei įjungsite mašininį mokymąsi, „Ente“ išsitrauks tokią informaciją kaip veido geometrija iš failų, įskaitant tuos, kuriais su jumis bendrinama.\n\nTai bus daroma jūsų įrenginyje, o visa sugeneruota biometrinė informacija bus visapusiškai užšifruota.';

  @override
  String get mlConsentPrivacy =>
      'Spustelėkite čia dėl išsamesnės informacijos apie šią funkciją mūsų privatumo politikoje';

  @override
  String get mlConsentConfirmation =>
      'Suprantu ir noriu įjungti mašininį mokymąsi';

  @override
  String get magicSearch => 'Magiška paieška';

  @override
  String get discover => 'Atraskite';

  @override
  String get discover_identity => 'Tapatybė';

  @override
  String get discover_screenshots => 'Ekrano kopijos';

  @override
  String get discover_receipts => 'Kvitai';

  @override
  String get discover_notes => 'Užrašai';

  @override
  String get discover_memes => 'Mėmai';

  @override
  String get discover_visiting_cards => 'Lankymo kortelės';

  @override
  String get discover_babies => 'Kūdikiai';

  @override
  String get discover_pets => 'Gyvūnai';

  @override
  String get discover_selfies => 'Asmenukės';

  @override
  String get discover_wallpapers => 'Ekrano fonai';

  @override
  String get discover_food => 'Maistas';

  @override
  String get discover_celebrations => 'Šventės';

  @override
  String get discover_sunset => 'Saulėlydis';

  @override
  String get discover_hills => 'Kalvos';

  @override
  String get discover_greenery => 'Žaluma';

  @override
  String get mlIndexingDescription =>
      'Atkreipkite dėmesį, kad mašininis mokymasis padidins pralaidumą ir akumuliatoriaus naudojimą, kol bus indeksuoti visi elementai. Apsvarstykite galimybę naudoti darbalaukio programą, kad indeksavimas būtų spartesnis – visi rezultatai bus sinchronizuojami automatiškai.';

  @override
  String get loadingModel => 'Atsisiunčiami modeliai...';

  @override
  String get waitingForWifi => 'Laukiama „WiFi“...';

  @override
  String get status => 'Būsena';

  @override
  String get indexedItems => 'Indeksuoti elementai';

  @override
  String get pendingItems => 'Laukiami elementai';

  @override
  String get clearIndexes => 'Valyti indeksavimus';

  @override
  String get selectFoldersForBackup =>
      'Pasirinkite aplankus atsarginėms kopijoms kurti';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Pasirinkti aplankai bus užšifruoti ir sukurtos atsarginės kopijos.';

  @override
  String get unselectAll => 'Nesirinkti visų';

  @override
  String get selectAll => 'Pasirinkti viską';

  @override
  String get skip => 'Praleisti';

  @override
  String get updatingFolderSelection => 'Atnaujinamas aplankų pasirinkimas...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementų',
      one: '$count elementas',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ištrinti $count elementų',
      one: 'Ištrinti $count elementą',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count failai (-ų), kiekvienas $formattedSize';
  }

  @override
  String get showMemories => 'Rodyti prisiminimus';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'prieš $count metų',
      one: 'prieš $count metus',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Atsarginės kopijos nustatymai';

  @override
  String get backupStatus => 'Atsarginės kopijos būsena';

  @override
  String get backupStatusDescription =>
      'Čia bus rodomi elementai, kurių atsarginės kopijos buvo sukurtos.';

  @override
  String get backupOverMobileData =>
      'Kurti atsargines kopijas per mobiliuosius duomenis';

  @override
  String get backupVideos => 'Kurti atsargines vaizdo įrašų kopijas';

  @override
  String get disableAutoLock => 'Išjungti automatinį užraktą';

  @override
  String get deviceLockExplanation =>
      'Išjunkite įrenginio ekrano užraktą, kai „Ente“ yra priekiniame fone ir kuriama atsarginės kopijos. Paprastai to nereikia, bet tai gali padėti sparčiau užbaigti didelius įkėlimus ir pradinį didelių bibliotekų importą.';

  @override
  String get about => 'Apie';

  @override
  String get weAreOpenSource => 'Esame atviro kodo!';

  @override
  String get privacy => 'Privatumas';

  @override
  String get terms => 'Sąlygos';

  @override
  String get checkForUpdates => 'Tikrinti, ar yra atnaujinimų';

  @override
  String get checkStatus => 'Tikrinti būseną';

  @override
  String get checking => 'Tikrinama...';

  @override
  String get youAreOnTheLatestVersion => 'Esate naujausioje versijoje';

  @override
  String get account => 'Paskyra';

  @override
  String get manageSubscription => 'Tvarkyti prenumeratą';

  @override
  String get authToChangeYourEmail =>
      'Nustatykite tapatybę, kad pakeistumėte savo el. paštą';

  @override
  String get changePassword => 'Keisti slaptažodį';

  @override
  String get authToChangeYourPassword =>
      'Nustatykite tapatybę, kad pakeistumėte slaptažodį';

  @override
  String get emailVerificationToggle => 'El. pašto patvirtinimas';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Nustatykite tapatybę, kad pakeistumėte el. pašto patvirtinimą';

  @override
  String get exportYourData => 'Eksportuoti duomenis';

  @override
  String get logout => 'Atsijungti';

  @override
  String get authToInitiateAccountDeletion =>
      'Nustatykite tapatybę, kad pradėtumėte paskyros ištrynimą';

  @override
  String get areYouSureYouWantToLogout => 'Ar tikrai norite atsijungti?';

  @override
  String get yesLogout => 'Taip, atsijungti';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Yra nauja „Ente“ versija.';

  @override
  String get update => 'Atnaujinti';

  @override
  String get installManually => 'Diegti rankiniu būdu';

  @override
  String get criticalUpdateAvailable => 'Yra kritinis naujinimas';

  @override
  String get updateAvailable => 'Yra naujinimas';

  @override
  String get ignoreUpdate => 'Ignoruoti';

  @override
  String get downloading => 'Atsisiunčiama...';

  @override
  String get cannotDeleteSharedFiles => 'Negalima ištrinti bendrinamų failų.';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Atsisiuntimas negalėjo būti baigtas.';

  @override
  String get retry => 'Kartoti';

  @override
  String get backedUpFolders => 'Sukurtos atsarginės aplankų kopijos';

  @override
  String get backup => 'Kurti atsarginę kopiją';

  @override
  String get freeUpDeviceSpace => 'Atlaisvinti įrenginio vietą';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Sutaupykite vietos savo įrenginyje išvalydami failus, kurių atsarginės kopijos jau buvo sukurtos.';

  @override
  String get allClear => '✨ Viskas išvalyta';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Neturite šiame įrenginyje failų, kuriuos galima ištrinti.';

  @override
  String get removeDuplicates => 'Šalinti dublikatus';

  @override
  String get removeDuplicatesDesc =>
      'Peržiūrėkite ir pašalinkite failus, kurie yra tiksliai dublikatai.';

  @override
  String get viewLargeFiles => 'Dideli failai';

  @override
  String get viewLargeFilesDesc =>
      'Peržiūrėkite failus, kurie užima daugiausiai saugyklos vietos.';

  @override
  String get noDuplicates => '✨ Dublikatų nėra';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Neturite dubliuotų failų, kuriuos būtų galima išvalyti.';

  @override
  String get success => 'Sėkmė';

  @override
  String get rateUs => 'Vertinti mus';

  @override
  String get remindToEmptyDeviceTrash =>
      'Taip pat ištuštinkite Neseniai ištrinti iš Nustatymai -> Saugykla, kad atlaisvintumėte vietos.';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Sėkmingai atlaisvinote $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Taip pat ištuštinkite šiukšlinę, kad gautumėte laisvos vietos.';

  @override
  String get sparkleSuccess => '✨ Sėkmė';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dubliuojančių failų',
      one: '$count dubliuojantį failą',
    );
    return 'Išvalėte $_temp0, išsaugodami ($storageSaved)';
  }

  @override
  String get familyPlans => 'Šeimos planai';

  @override
  String get referrals => 'Rekomendacijos';

  @override
  String get notifications => 'Pranešimai';

  @override
  String get sharedPhotoNotifications => 'Naujos bendrintos nuotraukos';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Gaukite pranešimus, kai kas nors įtraukia nuotrauką į bendrinamą albumą, kuriame dalyvaujate.';

  @override
  String get advanced => 'Išplėstiniai';

  @override
  String get general => 'Bendrieji';

  @override
  String get security => 'Saugumas';

  @override
  String get authToViewYourRecoveryKey =>
      'Nustatykite tapatybę, kad peržiūrėtumėte savo atkūrimo raktą';

  @override
  String get twofactor => 'Dvigubas tapatybės nustatymas';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Nustatykite tapatybę, kad sukonfigūruotumėte dvigubą tapatybės nustatymą';

  @override
  String get lockscreen => 'Ekrano užraktas';

  @override
  String get authToChangeLockscreenSetting =>
      'Nustatykite tapatybę, kad pakeistumėte užrakinto ekrano nustatymą';

  @override
  String get viewActiveSessions => 'Peržiūrėti aktyvius seansus';

  @override
  String get authToViewYourActiveSessions =>
      'Nustatykite tapatybę, kad peržiūrėtumėte savo aktyvius seansus';

  @override
  String get disableTwofactor => 'Išjungti dvigubą tapatybės nustatymą';

  @override
  String get confirm2FADisable =>
      'Ar tikrai norite išjungti dvigubą tapatybės nustatymą?';

  @override
  String get no => 'Ne';

  @override
  String get yes => 'Taip';

  @override
  String get social => 'Socialinės';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Vertinti mus parduotuvėje „$storeName“';
  }

  @override
  String get blog => 'Tinklaraštis';

  @override
  String get merchandise => 'Atributika';

  @override
  String get twitter => '„Twitter“';

  @override
  String get mastodon => '„Mastodon“';

  @override
  String get matrix => '„Matrix“';

  @override
  String get discord => '„Discord“';

  @override
  String get reddit => '„Reddit“';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Nepavyko gauti jūsų saugyklos duomenų.';

  @override
  String get reportABug => 'Pranešti apie riktą';

  @override
  String get reportBug => 'Pranešti apie riktą';

  @override
  String get suggestFeatures => 'Siūlyti funkcijas';

  @override
  String get support => 'Pagalba';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Šviesi';

  @override
  String get darkTheme => 'Tamsi';

  @override
  String get systemTheme => 'Sistemos';

  @override
  String get freeTrial => 'Nemokamas bandomasis laikotarpis';

  @override
  String get selectYourPlan => 'Pasirinkite planą';

  @override
  String get enteSubscriptionPitch =>
      '„Ente“ išsaugo jūsų prisiminimus, todėl jie visada bus pasiekiami, net jei prarasite įrenginį.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Į planą galima pridėti ir savo šeimą.';

  @override
  String get currentUsageIs => 'Dabartinis naudojimas – ';

  @override
  String get faqs => 'DUK';

  @override
  String renewsOn({required Object endDate}) {
    return 'Prenumerata pratęsiama $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Nemokamas bandomasis laikotarpis galioja iki $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Galioja iki $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Jūsų $storageAmount priedas galioja iki $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Nemokama bandomoji versija galioja iki $endDate.\nVėliau galėsite pasirinkti mokamą planą.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Jūsų prenumerata bus atsisakyta $endDate';
  }

  @override
  String get subscription => 'Prenumerata';

  @override
  String get paymentDetails => 'Mokėjimo duomenys';

  @override
  String get manageFamily => 'Tvarkyti šeimą';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Susisiekite su mumis adresu support@ente.io, kad sutvarkytumėte savo $provider prenumeratą.';
  }

  @override
  String get renewSubscription => 'Pratęsti prenumeratą';

  @override
  String get cancelSubscription => 'Atsisakyti prenumeratos';

  @override
  String get areYouSureYouWantToRenew => 'Ar tikrai norite pratęsti?';

  @override
  String get yesRenew => 'Taip, pratęsti';

  @override
  String get areYouSureYouWantToCancel => 'Ar tikrai norite atšaukti?';

  @override
  String get yesCancel => 'Taip, atsisakyti';

  @override
  String get failedToRenew => 'Nepavyko pratęsti.';

  @override
  String get failedToCancel => 'Nepavyko atsisakyti';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 mėnesiai nemokamai metiniuose planuose';

  @override
  String get monthly => 'Mėnesinis';

  @override
  String get yearly => 'Metinis';

  @override
  String get confirmPlanChange => 'Patvirtinkite plano pakeitimą';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Ar tikrai norite keisti planą?';

  @override
  String get youCannotDowngradeToThisPlan => 'Negalite pakeisti į šį planą';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Pirmiausia atsisakykite esamos prenumeratos iš $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike =>
      'Nebūtina, trumpai, kaip jums patinka...';

  @override
  String get send => 'Siųsti';

  @override
  String get askCancelReason =>
      'Jūsų prenumerata buvo atšaukta. Ar norėtumėte pasidalyti priežastimi?';

  @override
  String get thankYouForSubscribing => 'Dėkojame, kad užsiprenumeravote!';

  @override
  String get yourPurchaseWasSuccessful => 'Jūsų pirkimas buvo sėkmingas';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Jūsų planas sėkmingai pakeistas';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Jūsų planas sėkmingai pakeistas į žemesnį';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Jūsų prenumerata buvo sėkmingai atnaujinta';

  @override
  String get googlePlayId => '„Google Play“ ID';

  @override
  String get appleId => '„Apple ID“';

  @override
  String get playstoreSubscription => '„PlayStore“ prenumerata';

  @override
  String get appstoreSubscription => '„App Store“ prenumerata';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Jūsų $id jau susietas su kita „Ente“ paskyra.\nJei norite naudoti savo $id su šia paskyra, susisiekite su mūsų palaikymo komanda.';
  }

  @override
  String get visitWebToManage =>
      'Aplankykite web.ente.io, kad tvarkytumėte savo prenumeratą';

  @override
  String get couldNotUpdateSubscription => 'Nepavyko atnaujinti prenumeratos';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Susisiekite adresu support@ente.io ir mes mielai padėsime!';

  @override
  String get paymentFailed => 'Mokėjimas nepavyko';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Kreipkitės į $providerName palaikymo komandą, jei jums buvo nuskaičiuota.';
  }

  @override
  String get continueOnFreeTrial => 'Tęsti nemokame bandomajame laikotarpyje';

  @override
  String get areYouSureYouWantToExit => 'Ar tikrai norite išeiti?';

  @override
  String get thankYou => 'Dėkojame';

  @override
  String get failedToVerifyPaymentStatus =>
      'Nepavyko patvirtinti mokėjimo būsenos';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Palaukite kurį laiką prieš bandydami pakartotinai';

  @override
  String get paymentFailedMessage =>
      'Deja, jūsų mokėjimas nepavyko. Susisiekite su palaikymo komanda ir mes jums padėsime!';

  @override
  String get youAreOnAFamilyPlan => 'Esate šeimos plane!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Susisiekite su <green>$familyAdminEmail</green>, kad sutvarkytumėte savo prenumeratą.';
  }

  @override
  String get leaveFamily => 'Palikti šeimą';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Ar tikrai norite palikti šeimos planą?';

  @override
  String get leave => 'Palikti';

  @override
  String get rateTheApp => 'Vertinti programą';

  @override
  String get startBackup => 'Pradėti kurti atsarginę kopiją';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Šiuo metu nekuriamos atsarginės nuotraukų kopijos';

  @override
  String get preserveMore => 'Išsaugoti daugiau';

  @override
  String get grantFullAccessPrompt =>
      'Leiskite prieigą prie visų nuotraukų nustatymų programoje.';

  @override
  String get allowPermTitle => 'Leisti prieigą prie nuotraukų';

  @override
  String get allowPermBody =>
      'Iš nustatymų leiskite prieigą prie nuotraukų, kad „Ente“ galėtų rodyti ir kurti atsargines bibliotekos kopijas.';

  @override
  String get openSettings => 'Atverti nustatymus';

  @override
  String get selectMorePhotos => 'Pasirinkti daugiau nuotraukų';

  @override
  String get existingUser => 'Esamas naudotojas';

  @override
  String get privateBackups => 'Privačios atsarginės kopijos';

  @override
  String get forYourMemories => 'jūsų prisiminimams';

  @override
  String get endtoendEncryptedByDefault =>
      'Pagal numatytąjį užšifruota visapusiškai';

  @override
  String get safelyStored => 'Saugiai saugoma';

  @override
  String get atAFalloutShelter => 'priešgaisrinėje slėptuvėje';

  @override
  String get designedToOutlive => 'Sukurta išgyventi';

  @override
  String get available => 'Prieinama';

  @override
  String get everywhere => 'visur';

  @override
  String get androidIosWebDesktop =>
      '„Android“, „iOS“, internete ir darbalaukyje';

  @override
  String get mobileWebDesktop => 'Mobiliuosiuose, internete ir darbalaukyje';

  @override
  String get newToEnte => 'Naujas platformoje „Ente“';

  @override
  String get pleaseLoginAgain => 'Prisijunkite iš naujo.';

  @override
  String get autoLogoutMessage =>
      'Dėl techninio trikdžio buvote atjungti. Atsiprašome už nepatogumus.';

  @override
  String get yourSubscriptionHasExpired => 'Jūsų prenumerata baigėsi.';

  @override
  String get storageLimitExceeded => 'Viršyta saugyklos riba.';

  @override
  String get upgrade => 'Keisti planą';

  @override
  String get raiseTicket => 'Sukurti paraišką';

  @override
  String get backupFailed => 'Atsarginė kopija nepavyko';

  @override
  String get sorryBackupFailedDesc =>
      'Atsiprašome, šiuo metu negalėjome sukurti atsarginės šio failo kopijos. Bandysime pakartoti vėliau.';

  @override
  String get couldNotBackUpTryLater =>
      'Nepavyko sukurti atsarginės duomenų kopijos.\nBandysime pakartotinai vėliau.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      '„Ente“ gali užšifruoti ir išsaugoti failus tik tada, jei suteikiate prieigą prie jų.';

  @override
  String get pleaseGrantPermissions => 'Suteikite leidimus.';

  @override
  String get grantPermission => 'Suteikti leidimą';

  @override
  String get privateSharing => 'Privatus bendrinimas';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Bendrinkite tik su tais asmenimis, su kuriais norite';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Naudokite viešas nuorodas asmenimis, kurie nėra sistemoje „Ente“';

  @override
  String get allowPeopleToAddPhotos => 'Leiskite asmenims pridėti nuotraukų';

  @override
  String get shareAnAlbumNow => 'Bendrinti albumą dabar';

  @override
  String get collectEventPhotos => 'Rinkti įvykių nuotraukas';

  @override
  String get sessionExpired => 'Seansas baigėsi';

  @override
  String get loggingOut => 'Atsijungiama...';

  @override
  String get onDevice => 'Įrenginyje';

  @override
  String get onEnte => 'Saugykloje <branding>ente</branding>';

  @override
  String get name => 'Pavadinimą';

  @override
  String get newest => 'Naujausią';

  @override
  String get lastUpdated => 'Paskutinį kartą atnaujintą';

  @override
  String get deleteEmptyAlbums => 'Ištrinti tuščius albumus';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Ištrinti tuščius albumus?';

  @override
  String get deleteAlbumsDialogBody =>
      'Tai ištrins visus tuščius albumus. Tai naudinga, kai norite sumažinti netvarką savo albumų sąraše.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Ištrinama $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Apdorojama $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Ištrinti negrįžtamai';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Galima sukurti nuorodą tik jums priklausantiems failams';

  @override
  String get publicLinkCreated => 'Vieša nuoroda sukurta';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Nuorodas galite valdyti bendrinimo kortelėje.';

  @override
  String get linkCopiedToClipboard => 'Nuoroda nukopijuota į iškarpinę';

  @override
  String get restore => 'Atkurti';

  @override
  String get moveToAlbum => 'Perkelti į albumą';

  @override
  String get unhide => 'Rodyti';

  @override
  String get unarchive => 'Išarchyvuoti';

  @override
  String get favorite => 'Pamėgti';

  @override
  String get removeFromFavorite => 'Šalinti iš mėgstamų';

  @override
  String get shareLink => 'Bendrinti nuorodą';

  @override
  String get createCollage => 'Kurti koliažą';

  @override
  String get saveCollage => 'Išsaugoti koliažą';

  @override
  String get collageSaved => 'Koliažas išsaugotas į galeriją';

  @override
  String get collageLayout => 'Išdėstymas';

  @override
  String get addToEnte => 'Pridėti į „Ente“';

  @override
  String get addToAlbum => 'Pridėti į albumą';

  @override
  String get delete => 'Ištrinti';

  @override
  String get hide => 'Slėpti';

  @override
  String get share => 'Bendrinti';

  @override
  String get unhideToAlbum => 'Rodyti į albumą';

  @override
  String get restoreToAlbum => 'Atkurti į albumą';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Perkelti elementų',
      one: 'Perkelti elementą',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pridėti elementų',
      one: 'Pridėti elementą',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Kurkite arba pasirinkite albumą';

  @override
  String get selectAlbum => 'Pasirinkti albumą';

  @override
  String get searchByAlbumNameHint => 'Albumo pavadinimas';

  @override
  String get albumTitle => 'Albumo pavadinimas';

  @override
  String get enterAlbumName => 'Įveskite albumo pavadinimą';

  @override
  String get restoringFiles => 'Atkuriami failai...';

  @override
  String get movingFilesToAlbum => 'Perkeliami failai į albumą...';

  @override
  String get unhidingFilesToAlbum => 'Rodomi failai į albumą';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Negalima įkelti į kitiems priklausančius albumus';

  @override
  String get uploadingFilesToAlbum => 'Įkeliami failai į albumą...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Sėkmingai įtraukta į „$albumName“';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Sėkmingai perkelta į „$albumName“';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Šis albumas jau turi bendradarbiavimo nuorodą.';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Bendradarbiavimo nuoroda sukurta albumui „$albumName“';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Paprašykite savo artimuosius bendrinti';

  @override
  String get invite => 'Kviesti';

  @override
  String get shareYourFirstAlbum => 'Bendrinkite savo pirmąjį albumą';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Bendrinta su $emailIDs';
  }

  @override
  String get sharedWithMe => 'Bendrinta su manimi';

  @override
  String get sharedByMe => 'Bendrinta manimi';

  @override
  String get doubleYourStorage => 'Padvigubinkite saugyklą';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Rekomenduokite draugams ir 2 kartus padidinkite savo planą';

  @override
  String get shareAlbumHint =>
      'Atidarykite albumą ir palieskite bendrinimo mygtuką viršuje dešinėje, kad bendrintumėte.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Elementai rodo likusių dienų skaičių iki visiško ištrynimo.';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dienų',
      one: '1 diena',
      zero: 'Netrukus',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Ištrinti viską';

  @override
  String get renameAlbum => 'Pervadinti albumą';

  @override
  String get convertToAlbum => 'Konvertuoti į albumą';

  @override
  String get setCover => 'Nustatyti viršelį';

  @override
  String get sortAlbumsBy => 'Rikiuoti pagal';

  @override
  String get sortNewestFirst => 'Naujausią pirmiausiai';

  @override
  String get sortOldestFirst => 'Seniausią pirmiausiai';

  @override
  String get rename => 'Pervadinti';

  @override
  String get leaveSharedAlbum => 'Palikti bendrinamą albumą?';

  @override
  String get leaveAlbum => 'Palikti albumą';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Jūsų pridėtos nuotraukos bus pašalintos iš albumo';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Neturite šiame albume failų, kuriuos būtų galima ištrinti.';

  @override
  String get youDontHaveAnyArchivedItems =>
      'Neturite jokių archyvuotų elementų.';

  @override
  String get ignoredFolderUploadReason =>
      'Kai kurie šio albumo failai ignoruojami, nes anksčiau buvo ištrinti iš „Ente“.';

  @override
  String get resetIgnoredFiles => 'Atkurti ignoruojamus failus';

  @override
  String get deviceFilesAutoUploading =>
      'Į šį įrenginio albumą įtraukti failai bus automatiškai įkelti į „Ente“.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Įjunkite atsarginės kopijos kūrimą, kad automatiškai įkeltumėte į šį įrenginio aplanką įtrauktus failus į „Ente“.';

  @override
  String get noHiddenPhotosOrVideos =>
      'Nėra paslėptų nuotraukų arba vaizdo įrašų';

  @override
  String get toHideAPhotoOrVideo =>
      'Kad paslėptumėte nuotrauką ar vaizdo įrašą';

  @override
  String get openTheItem => '• Atverkite elementą.';

  @override
  String get clickOnTheOverflowMenu => '• Spustelėkite ant perpildymo meniu';

  @override
  String get click => '• Spauskite';

  @override
  String get nothingToSeeHere => 'Čia nėra nieko, ką pamatyti. 👀';

  @override
  String get unarchiveAlbum => 'Išarchyvuoti albumą';

  @override
  String get archiveAlbum => 'Archyvuoti albumą';

  @override
  String get calculating => 'Skaičiuojama...';

  @override
  String get pleaseWaitDeletingAlbum => 'Palaukite. Ištrinamas albumas';

  @override
  String get searchByExamples =>
      '• Albumų pavadinimai (pvz., „Fotoaparatas“)\n• Failų tipai (pvz., „Vaizdo įrašai“, „.gif“)\n• Metai ir mėnesiai (pvz., „2022“, „sausis“)\n• Šventės (pvz., „Kalėdos“)\n• Nuotraukų aprašymai (pvz., „#džiaugsmas“)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Galite pabandyti ieškoti pagal kitą užklausą.';

  @override
  String get noResultsFound => 'Rezultatų nerasta.';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Įtraukė $emailOrName';
  }

  @override
  String get loadingExifData => 'Įkeliami EXIF duomenys...';

  @override
  String get viewAllExifData => 'Peržiūrėti visus EXIF duomenis';

  @override
  String get noExifData => 'Nėra EXIF duomenų';

  @override
  String get thisImageHasNoExifData => 'Šis vaizdas neturi Exif duomenų';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Rezultatų nėra.';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Nepalaikome nuotraukų ir albumų redagavimo, kurių dar neturite.';

  @override
  String get failedToFetchOriginalForEdit =>
      'Nepavyko gauti originalo redagavimui.';

  @override
  String get close => 'Uždaryti';

  @override
  String get setAs => 'Nustatyti kaip';

  @override
  String get fileSavedToGallery => 'Failas išsaugotas į galeriją';

  @override
  String get filesSavedToGallery => 'Failai išsaugoti į galeriją';

  @override
  String get fileFailedToSaveToGallery => 'Nepavyko išsaugoti failo į galeriją';

  @override
  String get download => 'Atsisiųsti';

  @override
  String get pressAndHoldToPlayVideo =>
      'Paspauskite ir palaikykite, kad paleistumėte vaizdo įrašą';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Paspauskite ir palaikykite vaizdą, kad paleistumėte vaizdo įrašą';

  @override
  String get downloadFailed => 'Atsisiuntimas nepavyko.';

  @override
  String get deduplicateFiles => 'Atdubliuoti failus';

  @override
  String get deselectAll => 'Naikinti visų pasirinkimą';

  @override
  String get reviewDeduplicateItems =>
      'Peržiūrėkite ir ištrinkite elementus, kurie, jūsų manymu, yra dublikatai.';

  @override
  String get clubByCaptureTime => 'Grupuoti pagal užfiksavimo laiką';

  @override
  String get clubByFileName => 'Grupuoti pagal failo pavadinimą';

  @override
  String get count => 'Skaičių';

  @override
  String get totalSize => 'Bendrą dydį';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Ilgai paspauskite elementą, kad peržiūrėtumėte per visą ekraną';

  @override
  String get decryptingVideo => 'Iššifruojamas vaizdo įrašas...';

  @override
  String get authToViewYourMemories =>
      'Nustatykite tapatybę, kad peržiūrėtumėte savo prisiminimus';

  @override
  String get unlock => 'Atrakinti';

  @override
  String get freeUpSpace => 'Atlaisvinti vietos';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Jų galima ištrinti iš įrenginio, kad atlaisvintų $formattedSize',
      one: 'Jį galima ištrinti iš įrenginio, kad atlaisvintų $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          '$formattedNumber failų šiame albume saugiai sukurta atsarginė kopija',
      many:
          '$formattedNumber failo šiame albume saugiai sukurtos atsargines kopijos',
      few:
          '$formattedNumber failai šiame albume saugiai sukurtos atsarginės kopijos',
      one:
          '$formattedNumber failas šiame albume saugiai sukurta atsarginė kopija',
    );
    return '$_temp0.';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          '$formattedNumber failų šiame įrenginyje saugiai sukurta atsarginių kopijų',
      many:
          '$formattedNumber failo šiame įrenginyje saugiai sukurtos atsargines kopijos',
      few:
          '$formattedNumber failai šiame įrenginyje saugiai sukurtos atsarginės kopijos',
      one:
          '$formattedNumber failas šiame įrenginyje saugiai sukurta atsarginė kopija',
    );
    return '$_temp0.';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'jų',
      one: 'jį',
    );
    return 'Vis dar galite pasiekti $_temp0 platformoje „Ente“, kol turite aktyvų prenumeratą.';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Atlaisvinti $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Šis el. paštas jau naudojamas.';

  @override
  String get incorrectCode => 'Neteisingas kodas.';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Tapatybės nustatymas nepavyko. Bandykite dar kartą.';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Patvirtinimas nepavyko. Bandykite dar kartą.';

  @override
  String get authenticating => 'Nustatoma tapatybė...';

  @override
  String get authenticationSuccessful => 'Tapatybės nustatymas sėkmingas.';

  @override
  String get incorrectRecoveryKey => 'Neteisingas atkūrimo raktas';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Įvestas atkūrimo raktas yra neteisingas.';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Dvigubas tapatybės nustatymas sėkmingai iš naujo nustatytas.';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered => 'Patvirtinkite įvestą kodą.';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Jei problema išlieka, susisiekite su pagalbos komanda.';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Dvigubas tapatybės nustatymas išjungtas.';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Atsiprašome, įvestas kodas yra neteisingas.';

  @override
  String get yourVerificationCodeHasExpired =>
      'Jūsų patvirtinimo kodas nebegaliojantis.';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'El. paštas pakeistas į $newEmail';
  }

  @override
  String get verifying => 'Patvirtinama...';

  @override
  String get disablingTwofactorAuthentication =>
      'Išjungiamas dvigubas tapatybės nustatymas...';

  @override
  String get allMemoriesPreserved => 'Išsaugoti visi prisiminimai';

  @override
  String get loadingGallery => 'Įkeliama galerija...';

  @override
  String get syncing => 'Sinchronizuojama...';

  @override
  String get encryptingBackup => 'Šifruojama atsarginė kopija...';

  @override
  String get syncStopped => 'Sinchronizavimas sustabdytas';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed / $total išsaugomi prisiminimai';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Išsaugomi $count prisiminimai...';
  }

  @override
  String get uploadingSingleMemory => 'Išsaugomas prisiminimas...';

  @override
  String get archiving => 'Archyvuojama...';

  @override
  String get unarchiving => 'Išarchyvuojama...';

  @override
  String get successfullyArchived => 'Sėkmingai suarchyvuota';

  @override
  String get successfullyUnarchived => 'Sėkmingai išarchyvuota';

  @override
  String get renameFile => 'Pervadinti failą';

  @override
  String get enterFileName => 'Įveskite failo pavadinimą';

  @override
  String get filesDeleted => 'Failai ištrinti';

  @override
  String get selectedFilesAreNotOnEnte =>
      'Pasirinkti failai nėra platformoje „Ente“';

  @override
  String get thisActionCannotBeUndone => 'Šio veiksmo negalima anuliuoti.';

  @override
  String get emptyTrash => 'Ištuštinti šiukšlinę?';

  @override
  String get permDeleteWarning =>
      'Visi elementai šiukšlinėje bus negrįžtamai ištrinti.\n\nŠio veiksmo negalima anuliuoti.';

  @override
  String get empty => 'Ištuštinti';

  @override
  String get couldNotFreeUpSpace => 'Nepavyko atlaisvinti vietos.';

  @override
  String get permanentlyDeleteFromDevice =>
      'Ištrinti negrįžtamai iš įrenginio?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Kai kurie failai, kuriuos bandote ištrinti, yra pasiekiami tik jūsų įrenginyje ir jų negalima atkurti, jei jie buvo ištrinti.';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Jie bus ištrinti iš visų albumų.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Kai kurie elementai yra ir platformoje „Ente“ bei jūsų įrenginyje.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Pasirinkti elementai bus ištrinti iš visų albumų ir perkelti į šiukšlinę.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Šie elementai bus ištrinti iš jūsų įrenginio.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Atrodo, kad kažkas nutiko ne taip. Bandykite pakartotinai po kurio laiko. Jei klaida tęsiasi, susisiekite su mūsų palaikymo komanda.';

  @override
  String get error => 'Klaida';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Atrodo, kad kažkas nutiko ne taip. Bandykite dar kartą po kurio laiko. Jei klaida tęsiasi, susisiekite su mūsų palaikymo komanda.';

  @override
  String get networkHostLookUpErr =>
      'Nepavyksta prisijungti prie „Ente“. Patikrinkite tinklo nustatymus ir susisiekite su palaikymo komanda, jei klaida tęsiasi.';

  @override
  String get networkConnectionRefusedErr =>
      'Nepavyksta prisijungti prie „Ente“. Bandykite dar kartą po kurio laiko. Jei klaida tęsiasi, susisiekite su palaikymo komanda.';

  @override
  String get cachedData => 'Podėliuoti duomenis';

  @override
  String get clearCaches => 'Valyti podėlius';

  @override
  String get remoteImages => 'Nuotoliniai vaizdai';

  @override
  String get remoteVideos => 'Nuotoliniai vaizdo įrašai';

  @override
  String get remoteThumbnails => 'Nuotolinės miniatiūros';

  @override
  String get pendingSync => 'Laukiama sinchronizacija';

  @override
  String get localGallery => 'Vietinė galerija';

  @override
  String get todaysLogs => 'Šiandienos žurnalai';

  @override
  String get viewLogs => 'Peržiūrėti žurnalus';

  @override
  String get logsDialogBody =>
      'Tai nusiųs žurnalus, kurie padės mums išspręsti jūsų problemą. Atkreipkite dėmesį, kad failų pavadinimai bus įtraukti, kad būtų lengviau atsekti problemas su konkrečiais failais.';

  @override
  String get preparingLogs => 'Ruošiami žurnalai...';

  @override
  String get emailYourLogs => 'Atsiųskite žurnalus el. laišku';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Siųskite žurnalus adresu\n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Kopijuoti el. pašto adresą';

  @override
  String get exportLogs => 'Eksportuoti žurnalus';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Siųskite el. laišką mums adresu $toEmail.';
  }

  @override
  String get dismiss => 'Atmesti';

  @override
  String get didYouKnow => 'Ar žinojote?';

  @override
  String get loadingMessage => 'Įkeliamos jūsų nuotraukos...';

  @override
  String get loadMessage1 => 'Galite bendrinti savo prenumeratą su šeima.';

  @override
  String get loadMessage2 =>
      'Iki šiol išsaugojome daugiau nei 200 milijonų prisiminimų.';

  @override
  String get loadMessage3 =>
      'Laikome 3 jūsų duomenų kopijas, vieną iš jų – požeminėje priešgaisrinėje slėptuvėje.';

  @override
  String get loadMessage4 => 'Visos mūsų programos yra atvirojo kodo.';

  @override
  String get loadMessage5 =>
      'Mūsų šaltinio kodas ir kriptografija buvo išoriškai audituoti.';

  @override
  String get loadMessage6 =>
      'Galite bendrinti savo albumų nuorodas su artimaisiais.';

  @override
  String get loadMessage7 =>
      'Mūsų mobiliosios programos veikia fone, kad užšifruotų ir sukurtų atsarginę kopiją visų naujų nuotraukų, kurias spustelėjate.';

  @override
  String get loadMessage8 => 'web.ente.io turi sklandų įkėlėją';

  @override
  String get loadMessage9 =>
      'Naudojame „Xchacha20Poly1305“, kad saugiai užšifruotume jūsų duomenis.';

  @override
  String get photoDescriptions => 'Nuotraukų aprašai';

  @override
  String get fileTypesAndNames => 'Failų tipai ir pavadinimai';

  @override
  String get location => 'Vietovė';

  @override
  String get moments => 'Akimirkos';

  @override
  String get searchFaceEmptySection =>
      'Asmenys bus rodomi čia, kai bus užbaigtas indeksavimas.';

  @override
  String get searchDatesEmptySection =>
      'Ieškokite pagal datą, mėnesį arba metus';

  @override
  String get searchLocationEmptySection =>
      'Grupės nuotraukos, kurios padarytos tam tikru spinduliu nuo nuotraukos';

  @override
  String get searchPeopleEmptySection =>
      'Pakvieskite asmenis ir čia matysite visas jų bendrinamas nuotraukas.';

  @override
  String get searchAlbumsEmptySection => 'Albumai';

  @override
  String get searchFileTypesAndNamesEmptySection =>
      'Failų tipai ir pavadinimai';

  @override
  String get searchCaptionEmptySection =>
      'Pridėkite aprašus, pavyzdžiui, „#kelionė“, į nuotraukos informaciją, kad sparčiau jas čia rastumėte.';

  @override
  String get language => 'Kalba';

  @override
  String get selectLanguage => 'Pasirinkite kalbą';

  @override
  String get locationName => 'Vietovės pavadinimas';

  @override
  String get addLocation => 'Pridėti vietovę';

  @override
  String get groupNearbyPhotos => 'Grupuoti netoliese nuotraukas';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Pridėti';

  @override
  String get radius => 'Spindulys';

  @override
  String get locationTagFeatureDescription =>
      'Vietos žymė grupuoja visas nuotraukas, kurios buvo padarytos tam tikru spinduliu nuo nuotraukos';

  @override
  String get galleryMemoryLimitInfo => 'Galerijoje rodoma iki 1000 prisiminimų';

  @override
  String get save => 'Išsaugoti';

  @override
  String get centerPoint => 'Centro taškas';

  @override
  String get pickCenterPoint => 'Pasirinkite centro tašką';

  @override
  String get useSelectedPhoto => 'Naudoti pasirinktą nuotrauką';

  @override
  String get resetToDefault => 'Atkurti numatytąsias reikšmes';

  @override
  String get edit => 'Redaguoti';

  @override
  String get deleteLocation => 'Ištrinti vietovę';

  @override
  String get rotateLeft => 'Sukti į kairę';

  @override
  String get flip => 'Apversti';

  @override
  String get rotateRight => 'Sukti į dešinę';

  @override
  String get saveCopy => 'Išsaugoti kopiją';

  @override
  String get light => 'Šviesi';

  @override
  String get color => 'Spalva';

  @override
  String get yesDiscardChanges => 'Taip, atmesti pakeitimus';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Ar norite atmesti atliktus pakeitimus?';

  @override
  String get saving => 'Išsaugoma...';

  @override
  String get editsSaved => 'Redagavimai išsaugoti';

  @override
  String get oopsCouldNotSaveEdits => 'Ups, nepavyko išsaugoti redagavimų.';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Šiandien';

  @override
  String get dayYesterday => 'Vakar';

  @override
  String get storage => 'Saugykla';

  @override
  String get usedSpace => 'Naudojama vieta';

  @override
  String get storageBreakupFamily => 'Šeima';

  @override
  String get storageBreakupYou => 'Jūs';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit iš $totalAmount $totalStorageUnit naudojama';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit laisva';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versija: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Patvirtinti';

  @override
  String get fileInfoAddDescHint => 'Pridėti aprašymą...';

  @override
  String get editLocationTagTitle => 'Redaguoti vietovę';

  @override
  String get setLabel => 'Nustatyti';

  @override
  String get setRadius => 'Nustatyti spindulį';

  @override
  String get familyPlanPortalTitle => 'Šeima';

  @override
  String get familyPlanOverview =>
      'Įtraukite 5 šeimos narius į jūsų esamą planą nemokėdami papildomai.\n\nKiekvienas narys gauna savo asmeninę vietą ir negali matyti vienas kito failų, nebent jie bendrinami.\n\nŠeimos planai pasiekiami klientams, kurie turi mokamą „Ente“ prenumeratą.\n\nPrenumeruokite dabar, kad pradėtumėte!';

  @override
  String get androidBiometricHint => 'Patvirtinkite tapatybę';

  @override
  String get androidBiometricNotRecognized =>
      'Neatpažinta. Bandykite dar kartą.';

  @override
  String get androidBiometricSuccess => 'Sėkmė';

  @override
  String get androidCancelButton => 'Atšaukti';

  @override
  String get androidSignInTitle => 'Privalomas tapatybės nustatymas';

  @override
  String get androidBiometricRequiredTitle => 'Privaloma biometrija';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Privalomi įrenginio kredencialai';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Privalomi įrenginio kredencialai';

  @override
  String get goToSettings => 'Eiti į nustatymus';

  @override
  String get androidGoToSettingsDescription =>
      'Biometrinis tapatybės nustatymas jūsų įrenginyje nenustatytas. Eikite į Nustatymai > Saugumas ir pridėkite biometrinį tapatybės nustatymą.';

  @override
  String get iOSLockOut =>
      'Biometrinis tapatybės nustatymas išjungtas. Kad jį įjungtumėte, užrakinkite ir atrakinkite ekraną.';

  @override
  String get iOSGoToSettingsDescription =>
      'Biometrinis tapatybės nustatymas jūsų įrenginyje nenustatytas. Telefone įjunkite „Touch ID“ arba „Face ID“.';

  @override
  String get iOSOkButton => 'Gerai';

  @override
  String get openstreetmapContributors => '„OpenStreetMap“ bendradarbiai';

  @override
  String get hostedAtOsmFrance => 'Talpinama OSM Prancūzijoje';

  @override
  String get map => 'Žemėlapis';

  @override
  String get maps => 'Žemėlapiai';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Įjungti žemėlapius';

  @override
  String get quickLinks => 'Sparčios nuorodos';

  @override
  String get selectItemsToAdd => 'Pasirinkite elementus įtraukti';

  @override
  String get addSelected => 'Pridėti pasirinktus';

  @override
  String get addFromDevice => 'Pridėti iš įrenginio';

  @override
  String get addPhotos => 'Įtraukti nuotraukų';

  @override
  String get noPhotosFoundHere => 'Nuotraukų čia nerasta';

  @override
  String get zoomOutToSeePhotos =>
      'Padidinkite mastelį, kad matytumėte nuotraukas';

  @override
  String get noImagesWithLocation => 'Nėra vaizdų su vietove';

  @override
  String get unpinAlbum => 'Atsegti albumą';

  @override
  String get pinAlbum => 'Prisegti albumą';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Kurti';

  @override
  String get viewAll => 'Peržiūrėti viską';

  @override
  String get nothingSharedWithYouYet =>
      'Kol kas su jumis niekuo nesibendrinama.';

  @override
  String get noAlbumsSharedByYouYet => 'Dar nėra albumų, kuriais bendrinotės.';

  @override
  String get sharedWithYou => 'Bendrinta su jumis';

  @override
  String get sharedByYou => 'Bendrinta iš jūsų';

  @override
  String get inviteYourFriendsToEnte => 'Pakvieskite savo draugus į „Ente“';

  @override
  String get failedToDownloadVideo => 'Nepavyko atsisiųsti vaizdo įrašo.';

  @override
  String get hiding => 'Slepiama...';

  @override
  String get unhiding => 'Rodoma...';

  @override
  String get successfullyHid => 'Sėkmingai paslėptas';

  @override
  String get successfullyUnhid => 'Sėkmingai atslėptas';

  @override
  String get crashReporting => 'Pranešti apie strigčius';

  @override
  String get resumableUploads => 'Tęstiniai įkėlimai';

  @override
  String get addToHiddenAlbum => 'Įtraukti į paslėptą albumą';

  @override
  String get moveToHiddenAlbum => 'Perkelti į paslėptą albumą';

  @override
  String get fileTypes => 'Failų tipai';

  @override
  String get deleteConfirmDialogBody =>
      'Ši paskyra susieta su kitomis „Ente“ programomis, jei jas naudojate. Jūsų įkelti duomenys per visas „Ente“ programas bus planuojama ištrinti, o jūsų paskyra bus ištrinta negrįžtamai.';

  @override
  String get hearUsWhereTitle => 'Kaip išgirdote apie „Ente“? (nebūtina)';

  @override
  String get hearUsExplanation =>
      'Mes nesekame programų diegimų. Mums padėtų, jei pasakytumėte, kur mus radote.';

  @override
  String get viewAddOnButton => 'Peržiūrėti priedus';

  @override
  String get addOns => 'Priedai';

  @override
  String get addOnPageSubtitle => 'Išsami informacija apie priedus';

  @override
  String get yourMap => 'Jūsų žemėlapis';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modifikuokite užklausą arba bandykite ieškoti';

  @override
  String get blackFridaySale => 'Juodojo penktadienio išpardavimas';

  @override
  String get upto50OffUntil4thDec => 'Iki 50% nuolaida, gruodžio 4 d.';

  @override
  String get photos => 'Nuotraukos';

  @override
  String get videos => 'Vaizdo įrašai';

  @override
  String get livePhotos => 'Gyvos nuotraukos';

  @override
  String get searchHint1 => 'Sparti paieška įrenginyje';

  @override
  String get searchHint2 => 'Nuotraukų datos ir aprašai';

  @override
  String get searchHint3 => 'Albumai, failų pavadinimai ir tipai';

  @override
  String get searchHint4 => 'Vietovė';

  @override
  String get searchHint5 => 'Jau netrukus: veidų ir magiškos paieškos ✨';

  @override
  String get addYourPhotosNow => 'Įtraukite savo nuotraukas dabar';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Rasta $count rezultatų',
      one: 'Rastas $count rezultatas',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Veidai';

  @override
  String get people => 'Asmenys';

  @override
  String get contents => 'Turinys';

  @override
  String get addNew => 'Pridėti naują';

  @override
  String get contacts => 'Kontaktai';

  @override
  String get noInternetConnection => 'Nėra interneto ryšio';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Patikrinkite savo interneto ryšį ir bandykite dar kartą.';

  @override
  String get signOutFromOtherDevices => 'Atsijungti iš kitų įrenginių';

  @override
  String get signOutOtherBody =>
      'Jei manote, kad kas nors gali žinoti jūsų slaptažodį, galite priverstinai atsijungti iš visų kitų įrenginių, naudojančių jūsų paskyrą.';

  @override
  String get signOutOtherDevices => 'Atsijungti kitus įrenginius';

  @override
  String get doNotSignOut => 'Neatsijungti';

  @override
  String get editLocation => 'Redaguoti vietovę';

  @override
  String get selectALocation => 'Pasirinkite vietovę';

  @override
  String get selectALocationFirst => 'Pirmiausia pasirinkite vietovę';

  @override
  String get changeLocationOfSelectedItems =>
      'Keisti pasirinktų elementų vietovę?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Vietovės pakeitimai bus matomi tik per „Ente“';

  @override
  String get cleanUncategorized => 'Valyti nekategorizuotus';

  @override
  String get cleanUncategorizedDescription =>
      'Pašalinkite iš nekategorizuotus visus failus, esančius kituose albumuose';

  @override
  String get waitingForVerification => 'Laukiama patvirtinimo...';

  @override
  String get passkey => 'Slaptaraktis';

  @override
  String get passkeyAuthTitle => 'Slaptarakčio patvirtinimas';

  @override
  String get loginWithTOTP => 'Prisijungti su TOTP';

  @override
  String get passKeyPendingVerification => 'Vis dar laukiama patvirtinimo';

  @override
  String get loginSessionExpired => 'Seansas baigėsi';

  @override
  String get loginSessionExpiredDetails =>
      'Jūsų seansas baigėsi. Prisijunkite iš naujo.';

  @override
  String get verifyPasskey => 'Patvirtinti slaptaraktį';

  @override
  String get playOnTv => 'Paleisti albumą televizoriuje';

  @override
  String get pair => 'Susieti';

  @override
  String get deviceNotFound => 'Įrenginys nerastas';

  @override
  String get castInstruction =>
      'Aplankykite cast.ente.io įrenginyje, kurį norite susieti.\n\nĮveskite toliau esantį kodą, kad paleistumėte albumą televizoriuje.';

  @override
  String get deviceCodeHint => 'Įveskite kodą';

  @override
  String get joinDiscord => 'Jungtis prie „Discord“';

  @override
  String get locations => 'Vietovės';

  @override
  String get addAName => 'Pridėti vardą';

  @override
  String get findThemQuickly => 'Raskite juos sparčiai';

  @override
  String get findPeopleByName => 'Sparčiai suraskite asmenis pagal vardą';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pridėti žiūrėtojų',
      one: 'Pridėti žiūrėtoją',
      zero: 'Pridėti žiūrėtojų',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pridėti bendradarbių',
      one: 'Pridėti bendradarbį',
      zero: 'Pridėti bendradarbių',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Ilgai paspauskite el. paštą, kad patvirtintumėte visapusį šifravimą.';

  @override
  String get developerSettingsWarning =>
      'Ar tikrai norite modifikuoti kūrėjo nustatymus?';

  @override
  String get developerSettings => 'Kūrėjo nustatymai';

  @override
  String get serverEndpoint => 'Serverio galutinis taškas';

  @override
  String get invalidEndpoint => 'Netinkamas galutinis taškas';

  @override
  String get invalidEndpointMessage =>
      'Atsiprašome, įvestas galutinis taškas netinkamas. Įveskite tinkamą galutinį tašką ir bandykite dar kartą.';

  @override
  String get endpointUpdatedMessage => 'Galutinis taškas sėkmingai atnaujintas';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Prijungta prie $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Kurti bendradarbiavimo nuorodą';

  @override
  String get search => 'Ieškokite';

  @override
  String get enterPersonName => 'Įveskite asmens vardą';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Šis el. paštas jau susietas su $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Peržiūrėkite $name, kad atsietumėte';
  }

  @override
  String get enterName => 'Įveskite vardą';

  @override
  String get savePerson => 'Išsaugoti asmenį';

  @override
  String get editPerson => 'Redaguoti asmenį';

  @override
  String get mergedPhotos => 'Sujungtos nuotraukos';

  @override
  String get orMergeWithExistingPerson => 'Arba sujunkite su esamais';

  @override
  String get enterDateOfBirth => 'Gimtadienis (neprivaloma)';

  @override
  String get birthday => 'Gimtadienis';

  @override
  String get removePersonLabel => 'Šalinti asmens žymą';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'Automatinis susiejimas veikia tik su įrenginiais, kurie palaiko „Chromecast“.';

  @override
  String get manualPairDesc =>
      'Susieti su PIN kodu veikia bet kuriame ekrane, kuriame norite peržiūrėti albumą.';

  @override
  String get connectToDevice => 'Prijungti prie įrenginio';

  @override
  String get autoCastDialogBody =>
      'Čia matysite pasiekiamus perdavimo įrenginius.';

  @override
  String get autoCastiOSPermission =>
      'Įsitikinkite, kad programai „Ente“ nuotraukos yra įjungti vietinio tinklo leidimai, nustatymuose.';

  @override
  String get noDeviceFound => 'Įrenginys nerastas';

  @override
  String get stopCastingTitle => 'Stabdyti perdavimą';

  @override
  String get stopCastingBody => 'Ar norite sustabdyti perdavimą?';

  @override
  String get castIPMismatchTitle => 'Nepavyko perduoti albumo';

  @override
  String get castIPMismatchBody =>
      'Įsitikinkite, kad esate tame pačiame tinkle kaip ir televizorius.';

  @override
  String get pairingComplete => 'Susiejimas baigtas';

  @override
  String get savingEdits => 'Išsaugomi redagavimai...';

  @override
  String get autoPair => 'Automatiškai susieti';

  @override
  String get pairWithPin => 'Susieti su PIN';

  @override
  String get faceRecognition => 'Veido atpažinimas';

  @override
  String get foundFaces => 'Rasti veidai';

  @override
  String get clusteringProgress => 'Sankaupos vykdymas';

  @override
  String get trim => 'Trumpinti';

  @override
  String get crop => 'Apkirpti';

  @override
  String get rotate => 'Sukti';

  @override
  String get left => 'Kairė';

  @override
  String get right => 'Dešinė';

  @override
  String get whatsNew => 'Kas naujo';

  @override
  String get reviewSuggestions => 'Peržiūrėti pasiūlymus';

  @override
  String get review => 'Peržiūrėti';

  @override
  String get useAsCover => 'Naudoti kaip viršelį';

  @override
  String notPersonLabel({required String name}) {
    return 'Ne $name?';
  }

  @override
  String get enable => 'Įjungti';

  @override
  String get enabled => 'Įjungta';

  @override
  String get moreDetails => 'Daugiau išsamios informacijos';

  @override
  String get enableMLIndexingDesc =>
      '„Ente“ palaiko įrenginyje mašininį mokymąsi, skirtą veidų atpažinimui, magiškai paieškai ir kitoms išplėstinėms paieškos funkcijoms';

  @override
  String get magicSearchHint =>
      'Magiška paieška leidžia ieškoti nuotraukų pagal jų turinį, pvz., „gėlė“, „raudonas automobilis“, „tapatybės dokumentai“';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Įveskite slaptažodį iš naujo';

  @override
  String get reenterPin => 'Įveskite PIN iš naujo';

  @override
  String get deviceLock => 'Įrenginio užraktas';

  @override
  String get pinLock => 'PIN užrakinimas';

  @override
  String get next => 'Toliau';

  @override
  String get setNewPassword => 'Nustatykite naują slaptažodį';

  @override
  String get enterPin => 'Įveskite PIN';

  @override
  String get setNewPin => 'Nustatykite naują PIN';

  @override
  String get appLock => 'Programos užraktas';

  @override
  String get noSystemLockFound => 'Nerastas sistemos užraktas';

  @override
  String get tapToUnlock => 'Palieskite, kad atrakintumėte';

  @override
  String get tooManyIncorrectAttempts => 'Per daug neteisingų bandymų.';

  @override
  String get videoInfo => 'Vaizdo įrašo informacija';

  @override
  String get autoLock => 'Automatinis užraktas';

  @override
  String get immediately => 'Iš karto';

  @override
  String get autoLockFeatureDescription =>
      'Laikas, po kurio programa užrakinama perkėlus ją į foną';

  @override
  String get hideContent => 'Slėpti turinį';

  @override
  String get hideContentDescriptionAndroid =>
      'Paslepia programų turinį programų perjungiklyje ir išjungia ekrano kopijas';

  @override
  String get hideContentDescriptionIos =>
      'Paslepia programos turinį programos perjungiklyje';

  @override
  String get passwordStrengthInfo =>
      'Slaptažodžio stiprumas apskaičiuojamas atsižvelgiant į slaptažodžio ilgį, naudotus simbolius ir į tai, ar slaptažodis patenka į 10 000 dažniausiai naudojamų slaptažodžių.';

  @override
  String get noQuickLinksSelected => 'Nėra pasirinktų sparčiųjų nuorodų';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Pasirinkite sparčiąsias nuorodas, kad pašalintumėte';

  @override
  String get removePublicLinks => 'Šalinti viešąsias nuorodas';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Tai pašalins visų pasirinktų sparčiųjų nuorodų viešąsias nuorodas.';

  @override
  String get guestView => 'Svečio peržiūra';

  @override
  String get guestViewEnablePreSteps =>
      'Kad įjungtumėte svečio peržiūrą, sistemos nustatymuose nustatykite įrenginio prieigos kodą arba ekrano užraktą.';

  @override
  String get nameTheAlbum => 'Pavadinkite albumą';

  @override
  String get collectPhotosDescription =>
      'Sukurkite nuorodą, į kurią draugai gali įkelti originalios kokybės nuotraukas.';

  @override
  String get collect => 'Rinkti';

  @override
  String get appLockDescriptions =>
      'Pasirinkite tarp numatytojo įrenginio užrakinimo ekrano ir pasirinktinio užrakinimo ekrano su PIN kodu arba slaptažodžiu.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Kad įjungtumėte programos užraktą, sistemos nustatymuose nustatykite įrenginio prieigos kodą arba ekrano užraktą.';

  @override
  String get authToViewPasskey =>
      'Nustatykite tapatybę, kad peržiūrėtumėte savo slaptaraktį';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Atrodo, kad kažkas nutiko ne taip, nes vietinių nuotraukų sinchronizavimas trunka ilgiau nei tikėtasi. Susisiekite su mūsų palaikymo komanda.';

  @override
  String get showPerson => 'Rodyti asmenį';

  @override
  String get sort => 'Rikiuoti';

  @override
  String get mostRecent => 'Naujausią';

  @override
  String get mostRelevant => 'Aktualiausią';

  @override
  String get loadingYourPhotos => 'Įkeliamos nuotraukos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Apdorojama $folderName...';
  }

  @override
  String get personName => 'Asmens vardas';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Pridėti naują asmenį';

  @override
  String get addNameOrMerge => 'Pridėti vardą arba sujungti';

  @override
  String get mergeWithExisting => 'Sujungti su esamais';

  @override
  String get newPerson => 'Naujas asmuo';

  @override
  String get addName => 'Pridėti vardą';

  @override
  String get add => 'Pridėti';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Rastos papildomos nuotraukos, skirtos $text';
  }

  @override
  String get extraPhotosFound => 'Rastos papildomos nuotraukos';

  @override
  String get configuration => 'Konfiguracija';

  @override
  String get localIndexing => 'Vietinis indeksavimas';

  @override
  String get processed => 'Apdorota';

  @override
  String get resetPerson => 'Šalinti';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Ar tikrai norite iš naujo nustatyti šį asmenį?';

  @override
  String get allPersonGroupingWillReset =>
      'Visi šio asmens grupavimai bus iš naujo nustatyti, o jūs neteksite visų šiam asmeniui pateiktų pasiūlymų';

  @override
  String get yesResetPerson => 'Taip, nustatyti asmenį iš naujo';

  @override
  String get onlyThem => 'Tik jiems';

  @override
  String get checkingModels => 'Tikrinami modeliai...';

  @override
  String get enableMachineLearningBanner =>
      'Įjunkite mašininį mokymąsi magiškai paieškai ir veidų atpažinimui';

  @override
  String get searchDiscoverEmptySection =>
      'Vaizdai bus rodomi čia, kai bus užbaigtas apdorojimas ir sinchronizavimas.';

  @override
  String get searchPersonsEmptySection =>
      'Asmenys bus rodomi čia, kai bus užbaigtas apdorojimas ir sinchronizavimas.';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Įtraukta $count žiūrėtojų',
      one: 'Įtrauktas 1 žiūrėtojas',
      zero: 'Įtraukta 0 žiūrėtojų',
      many: 'Įtraukta $count žiūrėtojo',
      few: 'Įtraukti $count žiūrėtojai',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pridėta $count bendradarbių',
      one: 'Pridėtas 1 bendradarbis',
      zero: 'Pridėta 0 bendradarbių',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Paskyra jau sukonfigūruota.';

  @override
  String get sessionIdMismatch => 'Seanso ID nesutampa.';

  @override
  String get failedToFetchActiveSessions => 'Nepavyko gauti aktyvių seansų.';

  @override
  String get failedToRefreshStripeSubscription =>
      'Nepavyko atnaujinti prenumeratos.';

  @override
  String get failedToPlayVideo => 'Nepavyko paleisti vaizdo įrašą. ';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Įkėlimas ignoruojamas dėl $ignoreReason.';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Galerijos tipas $galleryType nepalaikomas pervadinimui.';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Palieskite, kad įkeltumėte. Įkėlimas šiuo metu ignoruojamas dėl $ignoreReason.';
  }

  @override
  String get tapToUpload => 'Palieskite, kad įkeltumėte';

  @override
  String get info => 'Informacija';

  @override
  String get addFiles => 'Pridėti failus';

  @override
  String get castAlbum => 'Perduoti albumą';

  @override
  String get imageNotAnalyzed => 'Vaizdas neanalizuotas.';

  @override
  String get noFacesFound => 'Nerasta veidų.';

  @override
  String get fileNotUploadedYet => 'Failas dar neįkeltas.';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Nėra pasiūlymų asmeniui $personName.';
  }

  @override
  String get month => 'mėnesis';

  @override
  String get yearShort => 'm.';

  @override
  String get currentlyRunning => 'šiuo metu vykdoma';

  @override
  String get ignored => 'ignoruota';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count nuotraukų',
      one: '1 nuotrauka',
      zero: '0 nuotraukų',
      many: '$count nuotraukos',
      few: '$count nuotraukos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Failas';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Sekcijų ilgio neatitikimas: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Pasirinkti pašto programą';

  @override
  String get selectAllShort => 'Viskas';

  @override
  String get selectCoverPhoto => 'Pasirinkite viršelio nuotrauką';

  @override
  String get newLocation => 'Nauja vietovė';

  @override
  String get faceNotClusteredYet =>
      'Veidas dar nesugrupuotas. Grįžkite vėliau.';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Nuoroda, kurią bandote pasiekti, nebegalioja.';

  @override
  String get openFile => 'Atverti failą';

  @override
  String get backupFile => 'Kurti atsarginę failo kopiją';

  @override
  String get openAlbumInBrowser => 'Atverti albumą naršyklėje';

  @override
  String get openAlbumInBrowserTitle =>
      'Naudokite interneto programą, kad pridėtumėte nuotraukų į šį albumą.';

  @override
  String get allow => 'Leisti';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Leisti programai atverti bendrinamų albumų nuorodas';

  @override
  String get seePublicAlbumLinksInApp =>
      'Žiūrėti viešų albumų nuorodas programoje';

  @override
  String get emergencyContacts => 'Skubios pagalbos kontaktai';

  @override
  String get acceptTrustInvite => 'Priimti kvietimą';

  @override
  String get declineTrustInvite => 'Atmesti kvietimą';

  @override
  String get removeYourselfAsTrustedContact =>
      'Šalinti save kaip patikimą kontaktą';

  @override
  String get legacy => 'Palikimas';

  @override
  String get legacyPageDesc =>
      'Palikimas leidžia patikimiems kontaktams pasiekti jūsų paskyrą jums nesant.';

  @override
  String get legacyPageDesc2 =>
      'Patikimi kontaktai gali pradėti paskyros atkūrimą, o jei per 30 dienų paskyra neužblokuojama, iš naujo nustatyti slaptažodį ir pasiekti paskyrą.';

  @override
  String get legacyAccounts => 'Palikimo paskyros';

  @override
  String get trustedContacts => 'Patikimi kontaktai';

  @override
  String get addTrustedContact => 'Pridėti patikimą kontaktą';

  @override
  String get removeInvite => 'Šalinti kvietimą';

  @override
  String get recoveryWarning =>
      'Patikimas kontaktas bando pasiekti jūsų paskyrą.';

  @override
  String get rejectRecovery => 'Atmesti atkūrimą';

  @override
  String get recoveryInitiated => 'Pradėtas atkūrimas';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Paskyrą galėsite pasiekti po $days dienų. Pranešimas bus išsiųstas į $email.';
  }

  @override
  String get cancelAccountRecovery => 'Atšaukti atkūrimą';

  @override
  String get recoveryAccount => 'Atkurti paskyrą';

  @override
  String get cancelAccountRecoveryBody => 'Ar tikrai norite atšaukti atkūrimą?';

  @override
  String get startAccountRecoveryTitle => 'Pradėti atkūrimą';

  @override
  String get whyAddTrustContact =>
      'Patikimas kontaktas gali padėti atkurti jūsų duomenis.';

  @override
  String recoveryReady({required String email}) {
    return 'Dabar galite atkurti $email paskyrą nustatydami naują slaptažodį.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email bando atkurti jūsų paskyrą.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Buvote pakviesti tapti $email palikimo kontaktu.';
  }

  @override
  String get warning => 'Įspėjimas';

  @override
  String get proceed => 'Tęsti';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Ketinate įtraukti $email kaip patikimą kontaktą. Jie galės atkurti jūsų paskyrą, jei jūsų nebus $numOfDays dienų.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email pakvietė jus būti patikimu kontaktu';
  }

  @override
  String get authToManageLegacy =>
      'Nustatykite tapatybę, kad tvarkytumėte patikimus kontaktus';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Slėpti bendrinamus elementus iš pagrindinės galerijos';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galerija';

  @override
  String get joinAlbum => 'Junkitės prie albumo';

  @override
  String get joinAlbumSubtext =>
      'kad peržiūrėtumėte ir pridėtumėte savo nuotraukas';

  @override
  String get joinAlbumSubtextViewer =>
      'kad pridėtumėte tai prie bendrinamų albumų';

  @override
  String get join => 'Jungtis';

  @override
  String get linkEmail => 'Susieti el. paštą';

  @override
  String get link => 'Susieti';

  @override
  String get noEnteAccountExclamation => 'Nėra „Ente“ paskyros!';

  @override
  String get orPickFromYourContacts => 'arba pasirinkite iš savo kontaktų';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email neturi „Ente“ paskyros.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Aš)';
  }

  @override
  String get reassignMe => 'Perskirstyti „Aš“';

  @override
  String get me => 'Aš';

  @override
  String get linkEmailToContactBannerCaption => 'spartesniam bendrinimui';

  @override
  String get selectPersonToLink => 'Pasirinkite asmenį, kurį susieti.';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Susieti asmenį su $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Tai susies $personName su $email.';
  }

  @override
  String get selectYourFace => 'Pasirinkite savo veidą';

  @override
  String get reassigningLoading => 'Perskirstoma...';

  @override
  String reassignedToName({required String name}) {
    return 'Perskirstė jus į $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Išsaugoti pakeitimus prieš išeinant?';

  @override
  String get dontSave => 'Neišsaugoti';

  @override
  String get thisIsMeExclamation => 'Tai aš!';

  @override
  String get linkPerson => 'Susiekite asmenį,';

  @override
  String get linkPersonCaption => 'geresniam bendrinimo patirčiai';

  @override
  String get videoStreaming => 'Srautiniai vaizdo įrašai';

  @override
  String get processingVideos => 'Apdorojami vaizdo įrašai';

  @override
  String get streamDetails => 'Srautinio perdavimo išsami informacija';

  @override
  String get processing => 'Apdorojama';

  @override
  String get queued => 'Įtraukta eilėje';

  @override
  String get ineligible => 'Netinkami';

  @override
  String get failed => 'Nepavyko';

  @override
  String get playStream => 'Leisti srautinį perdavimą';

  @override
  String get playOriginal => 'Leisti originalą';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Prisijungus prie albumo, jūsų el. paštas bus matomas jo dalyviams.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Palaukite, tai šiek tiek užtruks.';

  @override
  String get editTime => 'Redaguoti laiką';

  @override
  String get selectTime => 'Pasirinkti laiką';

  @override
  String get selectDate => 'Pasirinkti datą';

  @override
  String get previous => 'Ankstesnis';

  @override
  String get selectOneDateAndTimeForAll =>
      'Pasirinkti vieną datą ir laiką viskam';

  @override
  String get selectStartOfRange => 'Pasirinkti intervalo pradžią';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Tai padarys visų pasirinktų nuotraukų datą ir laiką vienodus.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Tai – pirmoji šioje grupėje. Kitos pasirinktos nuotraukos bus automatiškai perkeltos pagal šią naują datą.';

  @override
  String get newRange => 'Naujas intervalas';

  @override
  String get selectOneDateAndTime => 'Pasirinkti vieną datą ir laiką';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Perkelti pasirinktas nuotraukas į vieną datą';

  @override
  String get shiftDatesAndTime => 'Pastumti datas ir laiką';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Nuotraukos išlaiko santykinį laiko skirtumą';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count nuotraukų',
      one: '1 nuotrauka',
      zero: 'Nėra nuotraukų',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Programos piktograma';

  @override
  String get notThisPerson => 'Ne šis asmuo?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Pasirinkti elementai bus pašalinti iš šio asmens, bet nebus ištrinti iš jūsų bibliotekos.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat per metus';
  }

  @override
  String get thisWeekThroughTheYears => 'Ši savaitė per metus';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Šią savaitę, prieš $count metų',
      one: 'Šią savaitę, prieš $count metus',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Jūs ir $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Žavisi $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Apkabinat $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Vakarėlis su $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Žygiavimas su $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Vaišiavimas su $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Asmenukės su $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Pozavimas su $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Gražūs vaizdai su $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sportai su $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Kelionė su $name';
  }

  @override
  String get spotlightOnYourself => 'Dėmesys į save';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Dėmesys $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name yra $age m.!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name netrukus sulauks $age m.';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Paskutinį kartą su $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Kelionė į $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Kelionė per $year';
  }

  @override
  String get lastYearsTrip => 'Pastarųjų metų kelionė';

  @override
  String get sunrise => 'Akiratyje';

  @override
  String get mountains => 'Per kalvas';

  @override
  String get greenery => 'Žaliasis gyvenimas';

  @override
  String get beach => 'Smėlis ir jūra';

  @override
  String get city => 'Mieste';

  @override
  String get moon => 'Mėnulio šviesoje';

  @override
  String get onTheRoad => 'Vėl kelyje';

  @override
  String get food => 'Kulinarinis malonumas';

  @override
  String get pets => 'Furio draugai';

  @override
  String get curatedMemories => 'Kuruoti prisiminimai';

  @override
  String get widgets => 'Valdikliai';

  @override
  String get memories => 'Prisiminimai';

  @override
  String get peopleWidgetDesc =>
      'Pasirinkite asmenis, kuriuos norite matyti savo pradžios ekrane.';

  @override
  String get albumsWidgetDesc =>
      'Pasirinkite albumus, kuriuos norite matyti savo pradžios ekrane.';

  @override
  String get memoriesWidgetDesc =>
      'Pasirinkite, kokius prisiminimus norite matyti savo pradžios ekrane.';

  @override
  String get smartMemories => 'Išmanieji prisiminimai';

  @override
  String get pastYearsMemories => 'Praėjusių metų prisiminimai';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Taip pat ištrinti nuotraukas (ir vaizdo įrašus), esančias šiuose $count albumuose, iš <bold>visų</bold> kitų albumų, kuriuose jos yra dalis?';
  }

  @override
  String get addParticipants => 'Įtraukti dalyvių';

  @override
  String selectedAlbums({required Object count}) {
    return '$count pasirinkta';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Veiksmas nepalaikomas Mėgstamų albume.';

  @override
  String get onThisDayMemories => 'Šios dienos prisiminimai';

  @override
  String get onThisDay => 'Šią dieną';

  @override
  String get lookBackOnYourMemories =>
      'Pažvelkite atgal į savo prisiminimus 🌄';

  @override
  String get newPhotosEmoji => ' naujas 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Atsiprašome, turėjome pristabdyti jūsų atsarginių kopijų kūrimą.';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Spustelėkite, kad įdiegtumėte geriausią mūsų versiją iki šiol';

  @override
  String get onThisDayNotificationExplanation =>
      'Gaukite priminimus apie praėjusių metų šios dienos prisiminimus.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Pridėkite prisiminimų valdiklį prie savo pradžios ekrano ir grįžkite čia, kad tinkintumėte.';

  @override
  String get addAlbumWidgetPrompt =>
      'Pridėkite albumo valdiklį prie savo pradžios ekrano ir grįžkite čia, kad tinkintumėte.';

  @override
  String get addPeopleWidgetPrompt =>
      'Pridėkite asmenų valdiklį prie savo pradžios ekrano ir grįžkite čia, kad tinkintumėte.';

  @override
  String get birthdayNotifications => 'Gimtadienio pranešimai';

  @override
  String get receiveRemindersOnBirthdays =>
      'Gaukite priminimus, kai yra kažkieno gimtadienis. Paliesdami pranešimą, pateksite į gimtadienio šventės asmens nuotraukas.';

  @override
  String get happyBirthday => 'Su gimtadieniu! 🥳';

  @override
  String get birthdays => 'Gimtadieniai';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Palinkėkite $name su gimtadieniu! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Ar tikrai norite pašalinti šį veidą iš šio asmens?';

  @override
  String get otherDetectedFaces => 'Kiti aptikti veidai';

  @override
  String get areThey => 'Ar jie ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Išsaugoti kaip kitą asmenį';

  @override
  String get showLessFaces => 'Rodyti mažiau veidų';

  @override
  String get showMoreFaces => 'Rodyti daugiau veidų';

  @override
  String get ignore => 'Ignoruoti';

  @override
  String get merge => 'Sujungti';

  @override
  String get reset => 'Atkurti';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Ar tikrai norite ignoruoti šį asmenį?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Ar tikrai norite ignoruoti šiuos asmenis?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Asmenų grupės nebebus rodomos asmenų sekcijoje. Nuotraukos liks nepakitusios.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'Asmuo nebebus rodomas asmenų sekcijoje. Nuotraukos liks nepakitusios.';

  @override
  String get areYouSureYouWantToMergeThem => 'Ar tikrai norite juos sujungti?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Visos nepavadintos grupės bus sujungtos su pasirinktu asmeniu. Tai vis dar galima atšaukti iš asmens pasiūlymų istorijos apžvalgos.';

  @override
  String get yesIgnore => 'Taip, ignoruoti';

  @override
  String get same => 'Tas pats';

  @override
  String get different => 'Skirtingas';

  @override
  String get sameperson => 'Tas pats asmuo?';

  @override
  String get indexingPausedStatusDescription =>
      'Indeksavimas pristabdytas. Jis bus automatiškai tęsiamas, kai įrenginys bus parengtas. Įrenginys laikomas parengtu, kai jo akumuliatoriaus įkrovos lygis, akumuliatoriaus būklė ir terminė būklė yra normos ribose.';

  @override
  String get thisWeek => 'Šią savaitę';

  @override
  String get lastWeek => 'Praėjusią savaitę';

  @override
  String get thisMonth => 'Šį mėnesį';

  @override
  String get thisYear => 'Šiais metais';

  @override
  String get groupBy => 'Grupuoti pagal';

  @override
  String get faceThumbnailGenerationFailed =>
      'Nepavyksta sugeneruoti veido miniatiūrų.';

  @override
  String get fileAnalysisFailed => 'Nepavyksta išanalizuoti failo.';

  @override
  String get editAutoAddPeople => 'Redaguoti automatiškai įtrauktus asmenis';

  @override
  String get autoAddPeople => 'Automatiškai įtraukti asmenis';

  @override
  String get autoAddToAlbum => 'Automatiškai įtraukti į albumą';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Ar reikia pašalinti failus, susijusius su asmeniu, kuris anksčiau buvo atrinktas išmaniuosiuose albumuose?';

  @override
  String get addingPhotos => 'Įtraukiamos nuotraukos';

  @override
  String get gettingReady => 'Pasirengiama';

  @override
  String get addSomePhotosDesc1 =>
      'Įtraukite šiek tiek nuotraukų arba pasirinkite ';

  @override
  String get addSomePhotosDesc2 => 'pažįstamus veidus';

  @override
  String get addSomePhotosDesc3 => '\niš pradžių.';

  @override
  String get ignorePerson => 'Ignoruoti asmenį';

  @override
  String get mixedGrouping => 'Sumaišytas grupavimas?';

  @override
  String get analysis => 'Analizė';

  @override
  String get doesGroupContainMultiplePeople =>
      'Ar šiame grupavime yra keli asmenys?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Mes automatiškai išanalizuosime grupavimą, kad nustatytume, ar yra keli asmenys, ir vėl juos atskirsime. Tai gali užtrukti keletą sekundžių.';

  @override
  String get layout => 'Išdėstymas';

  @override
  String get day => 'Diena';

  @override
  String get undo => 'Anuliuoti';

  @override
  String get redo => 'Grąžinti';

  @override
  String get filter => 'Filtruoti';

  @override
  String get adjust => 'Priderinti';

  @override
  String get draw => 'Piešti';

  @override
  String get sticker => 'Lipdukas';

  @override
  String get brushColor => 'Teptuko spalva';

  @override
  String get font => 'Šriftas';

  @override
  String get background => 'Fonas';

  @override
  String get align => 'Lygiuoti';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Vaizdo įrašai apdoroti';

  @override
  String get totalVideos => 'Iš viso vaizdo įrašų';

  @override
  String get skippedVideos => 'Praleisti vaizdo įrašai';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Panašūs vaizdai';

  @override
  String get findSimilarImages => 'Rasti panašų vaizdų';

  @override
  String get noSimilarImagesFound => 'Panašių vaizdų nerasta';

  @override
  String get yourPhotosLookUnique => 'Jūsų nuotraukos atrodo ypatingos';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Pasirinkimo parinktys';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'Visi panašumai ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Pasirinkite vaizdus pagal jų vizualinį panašumą.';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Ištrinti failus';

  @override
  String get areYouSureDeleteFiles => 'Ar tikrai norite ištrinti šiuos failus?';

  @override
  String get greatJob => 'Puiku!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Atlaisvinote $size vietos.';
  }

  @override
  String get size => 'Dydis';

  @override
  String get similarity => 'Panašumas';

  @override
  String get analyzingPhotosLocally =>
      'Analizuojamos jūsų nuotraukos vietoje...';

  @override
  String get lookingForVisualSimilarities => 'Ieškoma vizualių panašumų...';

  @override
  String get comparingImageDetails => 'Lyginama vaizdo išsami informacija...';

  @override
  String get findingSimilarImages => 'Randama panašių vaizdų...';

  @override
  String get almostDone => 'Beveik baigta...';

  @override
  String get processingLocally => 'Apdorojama vietoje';

  @override
  String get useMLToFindSimilarImages =>
      'Peržiūrėkite ir pašalinkite vaizdus, kurie atrodo panašūs vienas į kitą.';

  @override
  String get all => 'Visi';

  @override
  String get similar => 'Panašūs';

  @override
  String get identical => 'Vienodi';

  @override
  String get nothingHereTryAnotherFilter =>
      'Čia nieko nėra. Bandykite kitą filtrą. 👀';

  @override
  String get related => 'Susiję';

  @override
  String get hoorayyyy => 'Puiiiiku!';

  @override
  String get nothingToTidyUpHere => 'Čia nėra ko tvarkyti.';

  @override
  String get deletingDash => 'Ištrinama - ';

  @override
  String get cLTitle1 => 'Introducing Rituals';

  @override
  String get cLDesc1 =>
      'Planning resolutions for 2026? With Rituals, you can set a reminder on Ente Photos and track your progress by taking photos. Use it for workouts, eating habits, daily moments with loved ones—anything you want to make a habit.';

  @override
  String get cLTitle2 => 'Public links, now for everyone';

  @override
  String get cLDesc2 =>
      'All Ente users on the free plan can now create and share public links to photos and albums. To prevent abuse, links will have limits on how many people can view them.';

  @override
  String get cLTitle3 => 'Manually tag people';

  @override
  String get cLDesc3 =>
      'You can now tag people even when our on-device AI doesn\'t detect a face. Handy for pets, partially visible faces, or moments where someone isn\'t actually in the photo but should still be included.';

  @override
  String get cLTitle4 => 'And more';

  @override
  String get cLDesc4 =>
      'You can now pin shared albums. Album links are visible to collaborators and viewers to make sharing even easier. We\'ve fixed some iOS swiping bugs and updated the photo view, including a new favorite icon (making room for upcoming features).';

  @override
  String get closeBy => 'Arti';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
