// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Japanese (`ja`).
class AppLocalizationsJa extends AppLocalizations {
  AppLocalizationsJa([String locale = 'ja']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Eメールアドレスを入力';

  @override
  String get enterYourNewEmailAddress => 'Enter your new email address';

  @override
  String get accountWelcomeBack => 'おかえりなさい！';

  @override
  String get emailAlreadyRegistered => 'このメールアドレスはすでに登録されています。';

  @override
  String get emailNotRegistered => 'このメールアドレスはまだ登録されていません。';

  @override
  String get email => 'Eメール';

  @override
  String get cancel => 'キャンセル';

  @override
  String get verify => '確認';

  @override
  String get invalidEmailAddress => '無効なEメールアドレス';

  @override
  String get enterValidEmail => '有効なEメールアドレスを入力してください';

  @override
  String get deleteAccount => 'アカウントを削除';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason => 'アカウントを削除する理由を教えて下さい';

  @override
  String get deleteAccountFeedbackPrompt =>
      '今までご利用ありがとうございました。改善点があれば、フィードバックをお寄せください';

  @override
  String get feedback => 'フィードバック';

  @override
  String get kindlyHelpUsWithThisInformation => 'よければ、情報をお寄せください';

  @override
  String get confirmDeletePrompt => 'はい、アカウントとすべてのアプリのデータを削除します';

  @override
  String get confirmAccountDeletion => 'アカウント削除の確認';

  @override
  String get deleteAccountPermanentlyButton => 'アカウントの削除';

  @override
  String get yourAccountHasBeenDeleted => 'アカウントは削除されました';

  @override
  String get selectReason => '';

  @override
  String get deleteReason1 => 'いちばん必要な機能がない';

  @override
  String get deleteReason2 => 'アプリや特定の機能が想定通りに動かない';

  @override
  String get deleteReason3 => 'より良いサービスを見つけた';

  @override
  String get deleteReason4 => '該当する理由がない';

  @override
  String get sendEmail => 'メールを送信する';

  @override
  String get deleteRequestSLAText => 'リクエストは72時間以内に処理されます';

  @override
  String get deleteEmailRequest =>
      '<warning>account-deletion@ente.io</warning>にあなたの登録したメールアドレスからメールを送信してください';

  @override
  String get entePhotosPerm => '写真を大切にバックアップするために<i>許可が必要</i>です';

  @override
  String get ok => 'OK';

  @override
  String get createAccount => 'アカウント作成';

  @override
  String get createNewAccount => '新規アカウントを作成';

  @override
  String get password => 'パスワード';

  @override
  String get confirmPassword => 'パスワードを確認';

  @override
  String get activeSessions => 'アクティブなセッション';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Oops';

  @override
  String get somethingWentWrongPleaseTryAgain => '問題が起きてしまいました、もう一度試してください';

  @override
  String get thisWillLogYouOutOfThisDevice => 'ログアウトします';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice => '以下のデバイスからログアウトします:';

  @override
  String get terminateSession => 'セッションを終了';

  @override
  String get terminate => '終了させる';

  @override
  String get thisDevice => 'このデバイス';

  @override
  String get recoverButton => '復元';

  @override
  String get recoverySuccessful => '復元に成功しました！';

  @override
  String get decrypting => '復号しています';

  @override
  String get incorrectRecoveryKeyTitle => 'リカバリーキーの誤り';

  @override
  String get incorrectRecoveryKeyBody => 'リカバリーキーが間違っています';

  @override
  String get forgotPassword => 'パスワードを忘れた';

  @override
  String get enterYourRecoveryKey => 'リカバリーキーを入力してください';

  @override
  String get noRecoveryKey => 'リカバリーキーがないですか？';

  @override
  String get sorry => 'すみません';

  @override
  String get noRecoveryKeyNoDecryption =>
      'あなたのデータはエンドツーエンド暗号化されており、パスワードかリカバリーキーがない場合、データを復号することはできません';

  @override
  String get verifyEmail => 'Eメールの確認';

  @override
  String get toResetVerifyEmail => 'パスワードのリセットをするには、まずEメールを確認してください';

  @override
  String get checkInboxAndSpamFolder =>
      'メールボックスを確認してEメールの所有を証明してください(見つからない場合は、スパムの中も確認してください)';

  @override
  String get tapToEnterCode => 'タップしてコードを入力';

  @override
  String get resendEmail => 'メールを再送信';

  @override
  String weHaveSendEmailTo({required String email}) {
    return '<green>$email</green>にメールを送りました';
  }

  @override
  String get setPasswordTitle => 'パスワードを決定';

  @override
  String get changePasswordTitle => 'パスワードを変更';

  @override
  String get resetPasswordTitle => 'パスワードをリセット';

  @override
  String get encryptionKeys => '暗号化の鍵';

  @override
  String get passwordWarning =>
      'このパスワードを忘れると、<underline>あなたのデータを復号することは私達にもできません</underline>';

  @override
  String get enterPasswordToEncrypt => 'あなたのデータを暗号化するためのパスワードを入力してください';

  @override
  String get enterNewPasswordToEncrypt => 'あなたのデータを暗号化するための新しいパスワードを入力してください';

  @override
  String get weakStrength => '弱いパスワード';

  @override
  String get strongStrength => '強いパスワード';

  @override
  String get moderateStrength => '普通のパスワード';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'パスワードの長さ: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'パスワードの変更に成功しました';

  @override
  String get generatingEncryptionKeys => '暗号化鍵を生成しています';

  @override
  String get pleaseWait => 'お待ち下さい';

  @override
  String get continueLabel => 'つづける';

  @override
  String get insecureDevice => '安全でないデバイス';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'このデバイスでは安全な鍵を生成することができませんでした。\n\n他のデバイスからサインアップを試みてください。';

  @override
  String get howItWorks => '仕組みを知る';

  @override
  String get encryption => '暗号化';

  @override
  String get ackPasswordLostWarning => 'もしパスワードを忘れたら、自身のデータを失うことを理解しました';

  @override
  String get privacyPolicyTitle => 'プライバシーポリシー';

  @override
  String get termsOfServicesTitle => '規約';

  @override
  String get signUpTerms =>
      '<u-terms>利用規約</u-terms>と<u-policy>プライバシーポリシー</u-policy>に同意します';

  @override
  String get logInLabel => 'ログイン';

  @override
  String get loginTerms =>
      '「ログイン」をクリックすることで、<u-terms>利用規約</u-terms>と<u-policy>プライバシーポリシー</u-policy>に同意します';

  @override
  String get changeEmail => 'Eメールを変更';

  @override
  String get enterYourPassword => 'パスワードを入力';

  @override
  String get welcomeBack => 'おかえりなさい！';

  @override
  String get contactSupport => 'お問い合わせ';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'パスワードが間違っています';

  @override
  String get pleaseTryAgain => 'もう一度試してください';

  @override
  String get recreatePasswordTitle => 'パスワードを再生成';

  @override
  String get useRecoveryKey => 'リカバリーキーを使用';

  @override
  String get recreatePasswordBody =>
      'このデバイスではパスワードを確認する能力が足りません。\n\n恐れ入りますが、リカバリーキーを入力してパスワードを再生成する必要があります。';

  @override
  String get verifyPassword => 'パスワードの確認';

  @override
  String get recoveryKey => 'リカバリーキー';

  @override
  String get recoveryKeyOnForgotPassword =>
      'パスワードを忘れてしまったら、このリカバリーキーがあなたのデータを復元する唯一の方法です。';

  @override
  String get recoveryKeySaveDescription =>
      'リカバリーキーは私達も保管しません。この24個の単語を安全な場所に保管してください。';

  @override
  String get doThisLater => 'あとで行う';

  @override
  String get saveKey => 'キーを保存';

  @override
  String get recoveryKeyCopiedToClipboard => 'リカバリーキーはクリップボードにコピーされました';

  @override
  String get recoverAccount => 'アカウントを復元';

  @override
  String get recover => '復元';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'あなたの登録したメールアドレスから$supportEmail にメールを送ってください';
  }

  @override
  String get twofactorSetup => '2段階認証のセットアップ';

  @override
  String get enterCode => 'コードを入力';

  @override
  String get scanCode => 'コードをスキャン';

  @override
  String get codeCopiedToClipboard => 'コードがクリップボードにコピーされました';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      '認証アプリにこのコードをコピペしてください';

  @override
  String get tapToCopy => 'タップしてコピー';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      '認証アプリでQRコードをスキャンして下さい。';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      '認証アプリに表示された 6 桁のコードを入力してください';

  @override
  String get confirm => '確認';

  @override
  String get setupComplete => 'セットアップ完了';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready => 'リカバリーキーを保存してください';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      '2段階認証を失った場合、アカウントを回復するために使用できます。';

  @override
  String get twofactorAuthenticationPageTitle => '2段階認証';

  @override
  String get lostDevice => 'デバイスを紛失しましたか？';

  @override
  String get verifyingRecoveryKey => 'リカバリキーを確認中...';

  @override
  String get recoveryKeyVerified => 'リカバリキーが確認されました';

  @override
  String get recoveryKeySuccessBody =>
      'リカバリーキーは有効です。ご確認いただきありがとうございます。\n\nリカバリーキーは今後も安全にバックアップしておいてください。';

  @override
  String get invalidRecoveryKey =>
      '入力されたリカバリーキーが無効です。24 単語が含まれていることを確認し、それぞれのスペルを確認してください。\n\n古い形式のリカバリーコードを入力した場合は、64 文字であることを確認して、それぞれを確認してください。';

  @override
  String get invalidKey => '無効なキー';

  @override
  String get tryAgain => 'もう一度試してください';

  @override
  String get viewRecoveryKey => 'リカバリキーを表示';

  @override
  String get confirmRecoveryKey => 'リカバリーキーを確認';

  @override
  String get recoveryKeyVerifyReason =>
      'パスワードを忘れた場合、リカバリーキーは写真を復元するための唯一の方法になります。なお、設定 > アカウント でリカバリーキーを確認することができます。\n \n\nここにリカバリーキーを入力して、正しく保存できていることを確認してください。';

  @override
  String get confirmYourRecoveryKey => 'リカバリーキーを確認';

  @override
  String get addViewer => 'ビューアーを追加';

  @override
  String get addCollaborator => 'コラボレーターを追加';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => '新しいEメールアドレスを追加';

  @override
  String get orPickAnExistingOne => 'または既存のものを選択';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'コラボレーターは共有アルバムに写真やビデオを追加できます。';

  @override
  String get enterEmail => 'Eメールアドレスを入力してください';

  @override
  String get albumOwner => '所有者';

  @override
  String get you => 'あなた';

  @override
  String get collaborator => 'コラボレーター';

  @override
  String get addMore => 'さらに追加';

  @override
  String get viewer => 'ビューアー';

  @override
  String get remove => '削除';

  @override
  String get removeParticipant => '参加者を削除';

  @override
  String get manage => '管理';

  @override
  String get addedAs => '追加:';

  @override
  String get changePermissions => '権限を変更する';

  @override
  String get yesConvertToViewer => 'ビューアーに変換する';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user は写真をアルバムに追加できなくなります\n\n※$user が追加した写真は今後も$user が削除できます';
  }

  @override
  String get allowAddingPhotos => '写真の追加を許可';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription => 'リンクを持つ人が共有アルバムに写真を追加できるようにします。';

  @override
  String get passwordLock => 'パスワード保護';

  @override
  String get canNotOpenTitle => 'このアルバムは開けません';

  @override
  String get canNotOpenBody => '申し訳ありません。このアルバムをアプリで開くことができませんでした。';

  @override
  String get disableDownloadWarningTitle => 'ご注意ください';

  @override
  String get disableDownloadWarningBody =>
      'ビューアーはスクリーンショットを撮ったり、外部ツールを使用して写真のコピーを保存したりすることができます';

  @override
  String get allowDownloads => 'ダウンロードを許可';

  @override
  String get linkDeviceLimit => 'デバイスの制限';

  @override
  String get noDeviceLimit => 'なし';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'リンクの期限切れ';

  @override
  String get linkExpired => '期限切れ';

  @override
  String get linkEnabled => '有効';

  @override
  String get linkNeverExpires => 'なし';

  @override
  String get expiredLinkInfo =>
      'このリンクは期限切れです。新たな期限を設定するか、期限設定そのものを無くすか、選択してください';

  @override
  String get setAPassword => 'パスワードを設定';

  @override
  String get lockButtonLabel => 'ロック';

  @override
  String get enterPassword => 'パスワードを入力';

  @override
  String get removeLink => 'リンクを削除';

  @override
  String get manageLink => 'リンクを管理';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'リンクは $expiryTime に期限切れになります';
  }

  @override
  String get albumUpdated => 'アルバムが更新されました';

  @override
  String get never => 'なし';

  @override
  String get custom => 'カスタム';

  @override
  String get after1Hour => '1時間後';

  @override
  String get after1Day => '1日後';

  @override
  String get after1Week => '1週間後';

  @override
  String get after1Month => '1ヶ月後';

  @override
  String get after1Year => '1年後';

  @override
  String get manageParticipants => '管理';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 参加者',
      one: '1 参加者',
      zero: '参加者なし',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Enteアプリやアカウントを持っていない人にも、共有アルバムに写真を追加したり表示したりできるリンクを作成します。';

  @override
  String get collectPhotos => '写真を集めよう';

  @override
  String get collaborativeLink => '共同作業リンク';

  @override
  String get shareWithNonenteUsers => 'Enteを使っていない人に共有';

  @override
  String get createPublicLink => '公開リンクを作成';

  @override
  String get sendLink => 'リンクを送信';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'リンクをコピー';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'リンクは期限切れです';

  @override
  String get publicLinkEnabled => '公開リンクを有効にしました';

  @override
  String get shareALink => 'リンクをシェアする';

  @override
  String get sharedAlbumSectionDescription =>
      '無料プランのユーザーを含む、他のEnteユーザーと共有および共同アルバムを作成します。';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: '$numberOfPeople 人と共有されています',
      one: '1人と共有されています',
      zero: '誰かと共有しましょう',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'これはあなたの認証IDです';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'アルバムを共有している人はデバイス上で同じIDを見るはずです。';

  @override
  String get howToViewShareeVerificationID =>
      '設定画面でメールアドレスを長押しし、両デバイスのIDが一致していることを確認してください。';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'これは $email の確認用ID';
  }

  @override
  String get verificationId => '確認用ID';

  @override
  String verifyEmailID({required Object email}) {
    return '$email を確認';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email はEnteアカウントを持っていません。\n\n写真を共有するために「招待」を送信してください。';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return '私の確認ID: ente.ioの $verificationID';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'これがあなたのente.io確認用IDであることを確認できますか？ $verificationID';
  }

  @override
  String get somethingWentWrong => 'エラーが発生しました';

  @override
  String get sendInvite => '招待を送る';

  @override
  String get shareTextRecommendUsingEnte =>
      'Enteをダウンロードして、写真や動画の共有を簡単に！\n\nhttps://ente.io';

  @override
  String get done => '完了';

  @override
  String get applyCodeTitle => 'コードを適用';

  @override
  String get enterCodeDescription => 'もらったコードを入力して、無料のストレージを入手してください';

  @override
  String get apply => '適用';

  @override
  String get failedToApplyCode => 'コードを適用できませんでした';

  @override
  String get enterReferralCode => '紹介コードを入力してください';

  @override
  String get codeAppliedPageTitle => 'コードが適用されました。';

  @override
  String get changeYourReferralCode => '自分自身の紹介コードを変更する';

  @override
  String get change => '変更';

  @override
  String get unavailableReferralCode => 'このコードは利用できません';

  @override
  String get codeChangeLimitReached => 'コード変更の回数上限に達しました。';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'コードを変更するには、 $familyAdminEmail までご連絡ください。';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => '受け取り済';

  @override
  String get details => '詳細';

  @override
  String get claimMore => 'もっと！';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return '紹介者も $storageAmountInGB GB を得ます';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '誰かが有料プランにサインアップしてコードを適用する度に $storageAmountInGB GB';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'リフェラルコード: $referralCode\n\n設定→一般→リフェラルで使うことで$referralStorageInGBが無料になります(あなたが有料プランに加入したあと)。\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => '無料のストレージを受け取る';

  @override
  String get inviteYourFriends => '友達を招待';

  @override
  String get failedToFetchReferralDetails => '紹介の詳細を取得できません。後でもう一度お試しください。';

  @override
  String get referralStep1 => '1. このコードを友達に贈りましょう';

  @override
  String get referralStep2 => '2. 友達が有料プランに登録';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. お二人とも $storageInGB GB*を無料で手に入ります。';
  }

  @override
  String get referralsAreCurrentlyPaused => 'リフェラルは現在一時停止しています';

  @override
  String get youCanAtMaxDoubleYourStorage => '* 最大2倍のストレージまで';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': '家族は $storageAmountInGb GB 受け取っています',
      'false': 'あなたは $storageAmountInGb GB 受け取っています',
      'other': 'あなたは $storageAmountInGb GB受け取っています',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'よくある質問';

  @override
  String get help => 'ヘルプ';

  @override
  String get oopsSomethingWentWrong => '問題が発生しました';

  @override
  String get peopleUsingYourCode => 'あなたのコードを使っている人';

  @override
  String get eligible => '対象となる';

  @override
  String get total => '合計';

  @override
  String get codeUsedByYou => 'あなたが使用したコード';

  @override
  String get freeStorageClaimed => '空き容量を受け取る';

  @override
  String get freeStorageUsable => '無料のストレージが利用可能です';

  @override
  String get usableReferralStorageInfo =>
      '使用可能なストレージは現在のプランによって制限されています。プランをアップグレードすると、あなたが手に入れたストレージが自動的に使用可能になります。';

  @override
  String get removeFromAlbumTitle => 'アルバムから削除しますか？';

  @override
  String get removeFromAlbum => 'アルバムから削除';

  @override
  String get itemsWillBeRemovedFromAlbum => '選択したアイテムはこのアルバムから削除されます';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'お気に入りに追加しています...';

  @override
  String get removingFromFavorites => 'お気に入りから削除しています...';

  @override
  String get sorryCouldNotAddToFavorites => 'お気に入りに追加できませんでした。';

  @override
  String get sorryCouldNotRemoveFromFavorites => 'お気に入りから削除できませんでした';

  @override
  String get subscribeToEnableSharing => '共有を有効にするには、有料サブスクリプションが必要です。';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'サブスクライブ';

  @override
  String get canOnlyRemoveFilesOwnedByYou => 'あなたが所有しているファイルのみを削除できます';

  @override
  String get deleteSharedAlbum => '共有アルバムを削除しますか？';

  @override
  String get deleteAlbum => 'アルバムの削除';

  @override
  String get deleteAlbumDialog =>
      'このアルバムに含まれている写真 (およびビデオ) を <bold>すべて</bold> 他のアルバムからも削除しますか?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'このアルバムは他の人からも削除されます\n\n他の人が共有してくれた写真も、あなたからは見れなくなります';

  @override
  String get yesRemove => '削除';

  @override
  String get creatingLink => 'リンクを作成中...';

  @override
  String get removeWithQuestionMark => '削除しますか?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail はこの共有アルバムから退出します\n\n$userEmail が追加した写真もアルバムから削除されます';
  }

  @override
  String get keepPhotos => '写真を残す';

  @override
  String get deletePhotos => '写真を削除';

  @override
  String get inviteToEnte => 'Enteに招待する';

  @override
  String get removePublicLink => '公開リンクを削除';

  @override
  String disableLinkMessage({required Object albumName}) {
    return '\"$albumName\" にアクセスするための公開リンクが削除されます。';
  }

  @override
  String get sharing => '共有中...';

  @override
  String get youCannotShareWithYourself => '自分自身と共有することはできません';

  @override
  String get archive => 'アーカイブ';

  @override
  String get createAlbumActionHint => '長押しで写真を選択し、+をクリックしてアルバムを作成します';

  @override
  String get importing => 'インポート中...';

  @override
  String get failedToLoadAlbums => 'アルバムの読み込みに失敗しました';

  @override
  String get hidden => '非表示';

  @override
  String get authToViewYourHiddenFiles => '隠しファイルを表示するには認証してください';

  @override
  String get authToViewTrashedFiles => '削除したファイルを閲覧するには認証が必要です';

  @override
  String get trash => 'ゴミ箱';

  @override
  String get uncategorized => 'カテゴリなし';

  @override
  String get videoSmallCase => 'ビデオ';

  @override
  String get photoSmallCase => '写真';

  @override
  String get singleFileDeleteHighlight => '全てのアルバムから削除されます。';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'この $fileType はEnteとお使いのデバイスの両方にあります。';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return '$fileType はEnteから削除されます。';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return '$fileType はEnteから削除されます。';
  }

  @override
  String get deleteFromEnte => 'Enteから削除';

  @override
  String get yesDelete => 'はい、削除';

  @override
  String get movedToTrash => 'ごみ箱へ移動';

  @override
  String get deleteFromDevice => 'デバイスから削除';

  @override
  String get deleteFromBoth => '両方から削除';

  @override
  String get newAlbum => '新しいアルバム';

  @override
  String get albums => 'アルバム';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount memories',
      one: '$formattedCount memory',
      zero: 'no memories',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count 個を選択';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count 個選択中（$yourCount あなた）';
  }

  @override
  String get advancedSettings => '高度な設定';

  @override
  String get photoGridSize => '写真のグリッドサイズ';

  @override
  String get manageDeviceStorage => '端末のキャッシュを管理';

  @override
  String get manageDeviceStorageDesc => '端末上のキャッシュを確認・削除';

  @override
  String get machineLearning => '機械学習';

  @override
  String get mlConsent => '機械学習を有効にする';

  @override
  String get mlConsentTitle => '機械学習を有効にしますか？';

  @override
  String get mlConsentDescription =>
      '機械学習を有効にすると、Enteは顔などの情報をファイルから抽出します。\n\nこれはお使いのデバイスで行われ、生成された生体情報は暗号化されます。';

  @override
  String get mlConsentPrivacy => 'この機能の詳細については、こちらをクリックしてください。';

  @override
  String get mlConsentConfirmation => '機械学習を可能にしたい';

  @override
  String get magicSearch => 'マジックサーチ';

  @override
  String get discover => '新たな発見';

  @override
  String get discover_identity => '身分証';

  @override
  String get discover_screenshots => 'スクリーンショット';

  @override
  String get discover_receipts => 'レシート';

  @override
  String get discover_notes => 'メモ';

  @override
  String get discover_memes => 'ミーム';

  @override
  String get discover_visiting_cards => '訪問カード';

  @override
  String get discover_babies => '赤ちゃん';

  @override
  String get discover_pets => 'ペット';

  @override
  String get discover_selfies => 'セルフィー';

  @override
  String get discover_wallpapers => '壁紙';

  @override
  String get discover_food => '食べ物';

  @override
  String get discover_celebrations => 'お祝い';

  @override
  String get discover_sunset => '夕焼け';

  @override
  String get discover_hills => '丘';

  @override
  String get discover_greenery => '自然';

  @override
  String get mlIndexingDescription =>
      'すべての項目が処理されるまで、機械学習は帯域幅とバッテリー使用量が高くなりますのでご注意ください。 処理を高速で終わらせたい場合はデスクトップアプリを使用するのがおすすめです。結果は自動的に同期されます。';

  @override
  String get loadingModel => 'モデルをダウンロード中';

  @override
  String get waitingForWifi => 'WiFi を待っています';

  @override
  String get status => 'ステータス';

  @override
  String get indexedItems => '処理済みの項目';

  @override
  String get pendingItems => '処理待ちの項目';

  @override
  String get clearIndexes => '行った処理をクリアする';

  @override
  String get selectFoldersForBackup => 'バックアップするフォルダを選択';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      '選ばれたフォルダは暗号化されバックアップされます';

  @override
  String get unselectAll => 'すべての選択を解除';

  @override
  String get selectAll => '全て選択';

  @override
  String get skip => 'スキップ';

  @override
  String get updatingFolderSelection => 'フォルダの選択を更新しています...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count個のアイテム',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 個の項目を削除',
      one: '$count 個の項目を削除',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count 個のファイル、それぞれ$formattedSize';
  }

  @override
  String get showMemories => '思い出を表示';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 年前',
      one: '$count 年前',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'バックアップ設定';

  @override
  String get backupStatus => 'バックアップの状態';

  @override
  String get backupStatusDescription => 'バックアップされたアイテムがここに表示されます';

  @override
  String get backupOverMobileData => 'モバイルデータを使ってバックアップ';

  @override
  String get backupVideos => '動画をバックアップ';

  @override
  String get disableAutoLock => '自動ロックを無効にする';

  @override
  String get deviceLockExplanation =>
      '進行中のバックアップがある場合、デバイスがスリープしないようにします。\n\n※容量の大きいアップロードがある際にご活用ください。';

  @override
  String get about => 'このアプリについて';

  @override
  String get weAreOpenSource => '私たちはオープンソースです！';

  @override
  String get privacy => 'プライバシー';

  @override
  String get terms => '規約';

  @override
  String get checkForUpdates => 'アップデートを確認';

  @override
  String get checkStatus => 'ステータスの確認';

  @override
  String get checking => '確認中…';

  @override
  String get youAreOnTheLatestVersion => 'あなたは最新バージョンを使用しています';

  @override
  String get account => 'アカウント';

  @override
  String get manageSubscription => 'サブスクリプションの管理';

  @override
  String get authToChangeYourEmail => 'メールアドレスを変更するには認証してください';

  @override
  String get changePassword => 'パスワードを変更';

  @override
  String get authToChangeYourPassword => 'メールアドレスを変更するには認証してください';

  @override
  String get emailVerificationToggle => 'メール確認';

  @override
  String get authToChangeEmailVerificationSetting => 'メール確認を変更するには認証してください';

  @override
  String get exportYourData => 'データをエクスポート';

  @override
  String get logout => 'ログアウト';

  @override
  String get authToInitiateAccountDeletion => 'アカウントの削除をするためには認証が必要です';

  @override
  String get areYouSureYouWantToLogout => '本当にログアウトしてよろしいですか？';

  @override
  String get yesLogout => 'はい、ログアウトします';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Enteの新しいバージョンが利用可能です。';

  @override
  String get update => 'アップデート';

  @override
  String get installManually => '手動でインストール';

  @override
  String get criticalUpdateAvailable => '重要なアップデートがあります';

  @override
  String get updateAvailable => 'アップデートがあります';

  @override
  String get ignoreUpdate => '無視する';

  @override
  String get downloading => 'ダウンロード中…';

  @override
  String get cannotDeleteSharedFiles => '共有ファイルは削除できません';

  @override
  String get theDownloadCouldNotBeCompleted => 'ダウンロードを完了できませんでした';

  @override
  String get retry => 'リトライ';

  @override
  String get backedUpFolders => 'バックアップされたフォルダ';

  @override
  String get backup => 'バックアップ';

  @override
  String get freeUpDeviceSpace => 'デバイスの空き領域を解放する';

  @override
  String get freeUpDeviceSpaceDesc => 'すでにバックアップされているファイルを消去して、デバイスの容量を空けます。';

  @override
  String get allClear => '✨ オールクリア';

  @override
  String get noDeviceThatCanBeDeleted => '削除できるファイルがありません';

  @override
  String get removeDuplicates => '重複した項目を削除';

  @override
  String get removeDuplicatesDesc => '完全に重複しているファイルを確認し、削除します。';

  @override
  String get viewLargeFiles => '大きなファイル';

  @override
  String get viewLargeFilesDesc => '最も多くのストレージを消費しているファイルを表示します。';

  @override
  String get noDuplicates => '✨ 重複なし';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared => '削除できる同一ファイルはありません';

  @override
  String get success => '成功';

  @override
  String get rateUs => '評価して下さい';

  @override
  String get remindToEmptyDeviceTrash =>
      'また、空き領域を取得するには、「設定」→「ストレージ」から「最近削除した項目」を空にします';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return '$storageSaved を解放しました';
  }

  @override
  String get remindToEmptyEnteTrash => '「ゴミ箱」も空にするとアカウントのストレージが解放されます';

  @override
  String get sparkleSuccess => '成功✨';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 個の重複ファイル',
      one: '$count 個の重複ファイル',
    );
    return 'お掃除しました $_temp0, ($storageSavedが開放されます！)';
  }

  @override
  String get familyPlans => 'ファミリープラン';

  @override
  String get referrals => 'リフェラル';

  @override
  String get notifications => '通知';

  @override
  String get sharedPhotoNotifications => '新しい共有写真';

  @override
  String get sharedPhotoNotificationsExplanation =>
      '誰かが写真を共有アルバムに追加した時に通知を受け取る';

  @override
  String get advanced => '詳細';

  @override
  String get general => '設定';

  @override
  String get security => 'セキュリティ';

  @override
  String get authToViewYourRecoveryKey => 'リカバリーキーを表示するためには認証が必要です';

  @override
  String get twofactor => '二段階認証';

  @override
  String get authToConfigureTwofactorAuthentication => '2段階認証を設定するには認証してください';

  @override
  String get lockscreen => '画面のロック';

  @override
  String get authToChangeLockscreenSetting => '画面のロックの設定を変更するためには認証が必要です';

  @override
  String get viewActiveSessions => 'アクティブなセッションを表示';

  @override
  String get authToViewYourActiveSessions => 'アクティブなセッションを表示するためには認証が必要です';

  @override
  String get disableTwofactor => '2段階認証を無効にする';

  @override
  String get confirm2FADisable => '2 要素認証を無効にしてよろしいですか。';

  @override
  String get no => 'いいえ';

  @override
  String get yes => 'はい';

  @override
  String get social => 'SNS';

  @override
  String rateUsOnStore({required Object storeName}) {
    return '$storeName で評価';
  }

  @override
  String get blog => 'ブログ';

  @override
  String get merchandise => 'グッズ';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched => 'ストレージの詳細を取得できませんでした';

  @override
  String get reportABug => 'バグを報告';

  @override
  String get reportBug => 'バグを報告';

  @override
  String get suggestFeatures => '機能を提案';

  @override
  String get support => 'サポート';

  @override
  String get theme => 'テーマ';

  @override
  String get lightTheme => 'ライト';

  @override
  String get darkTheme => 'ダーク';

  @override
  String get systemTheme => 'システム';

  @override
  String get freeTrial => '無料トライアル';

  @override
  String get selectYourPlan => 'プランを選びましょう';

  @override
  String get enteSubscriptionPitch =>
      'Enteはあなたの思い出を保存します。デバイスを紛失しても、オンラインでアクセス可能です';

  @override
  String get enteSubscriptionShareWithFamily => 'あなたの家族もあなたの有料プランに参加することができます。';

  @override
  String get currentUsageIs => '現在の使用状況 ';

  @override
  String get faqs => 'よくある質問';

  @override
  String renewsOn({required Object endDate}) {
    return 'サブスクリプションは $endDate に更新します';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return '無料トライアルは$endDate までです';
  }

  @override
  String validTill({required Object endDate}) {
    return '$endDate まで';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'あなたの $storageAmount アドオンは $endDate まで有効です';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return '$endDate まで無料トライアルが有効です。\nその後、有料プランを選択することができます。';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'サブスクリプションは $endDate でキャンセルされます';
  }

  @override
  String get subscription => 'サブスクリプション';

  @override
  String get paymentDetails => 'お支払い情報';

  @override
  String get manageFamily => 'ファミリーの管理';

  @override
  String contactToManageSubscription({required Object provider}) {
    return '$provider サブスクリプションを管理するには、support@ente.io までご連絡ください。';
  }

  @override
  String get renewSubscription => 'サブスクリプションの更新';

  @override
  String get cancelSubscription => 'サブスクリプションをキャンセル';

  @override
  String get areYouSureYouWantToRenew => '更新してもよろしいですか？';

  @override
  String get yesRenew => 'はい、更新する';

  @override
  String get areYouSureYouWantToCancel => 'キャンセルしてもよろしいですか？';

  @override
  String get yesCancel => 'キャンセル';

  @override
  String get failedToRenew => '更新に失敗しました';

  @override
  String get failedToCancel => 'キャンセルに失敗しました';

  @override
  String get twoMonthsFreeOnYearlyPlans => '年次プランでは2ヶ月無料';

  @override
  String get monthly => '月額';

  @override
  String get yearly => '年額';

  @override
  String get confirmPlanChange => 'プランの変更を確認';

  @override
  String get areYouSureYouWantToChangeYourPlan => 'プランを変更して良いですか？';

  @override
  String get youCannotDowngradeToThisPlan => 'このプランにダウングレードはできません';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'まず$paymentProvider から既存のサブスクリプションをキャンセルしてください';
  }

  @override
  String get optionalAsShortAsYouLike => '省略可能、好きなだけお書きください...';

  @override
  String get send => '送信';

  @override
  String get askCancelReason => 'サブスクリプションはキャンセルされました。理由を教えていただけますか？';

  @override
  String get thankYouForSubscribing => 'ありがとうございます！';

  @override
  String get yourPurchaseWasSuccessful => '決済に成功しました';

  @override
  String get yourPlanWasSuccessfullyUpgraded => 'プランはアップグレードされました';

  @override
  String get yourPlanWasSuccessfullyDowngraded => 'プランはダウングレードされました';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully => 'サブスクリプションが更新されました';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStoreサブスクリプション';

  @override
  String get appstoreSubscription => 'AppStore サブスクリプション';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'あなたの $id はすでに別のEnteアカウントにリンクされています。\nこのアカウントであなたの $id を使用したい場合は、サポートにお問い合わせください。';
  }

  @override
  String get visitWebToManage => 'サブスクリプションを管理するにはweb.ente.ioをご覧ください';

  @override
  String get couldNotUpdateSubscription => 'サブスクリプションを更新できませんでした';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Support@ente.ioにお問い合わせください、お手伝いいたします。';

  @override
  String get paymentFailed => '支払いに失敗しました';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return '請求された場合は、 $providerName のサポートに連絡してください';
  }

  @override
  String get continueOnFreeTrial => '無料トライアルで続ける';

  @override
  String get areYouSureYouWantToExit => '本当に中止してよろしいですか？';

  @override
  String get thankYou => 'ありがとうございます';

  @override
  String get failedToVerifyPaymentStatus => '支払ステータスの確認に失敗しました';

  @override
  String get pleaseWaitForSometimeBeforeRetrying => '再試行する前にしばらくお待ちください';

  @override
  String get paymentFailedMessage =>
      '残念ながらお支払いに失敗しました。サポートにお問い合わせください。お手伝いします！';

  @override
  String get youAreOnAFamilyPlan => 'ファミリープランに入会しています！';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'サブスクリプションを管理するには、 <green>$familyAdminEmail</green> に連絡してください';
  }

  @override
  String get leaveFamily => 'ファミリープランから退会';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily => '本当にファミリープランを退会しますか？';

  @override
  String get leave => '離脱';

  @override
  String get rateTheApp => 'アプリを評価';

  @override
  String get startBackup => 'バックアップを開始';

  @override
  String get noPhotosAreBeingBackedUpRightNow => '現在バックアップされている写真はありません';

  @override
  String get preserveMore => 'もっと保存する';

  @override
  String get grantFullAccessPrompt => '設定アプリで、すべての写真へのアクセスを許可してください';

  @override
  String get allowPermTitle => '写真へのアクセスを許可';

  @override
  String get allowPermBody =>
      'Enteがライブラリを表示およびバックアップできるように、端末の設定から写真へのアクセスを許可してください。';

  @override
  String get openSettings => '設定を開く';

  @override
  String get selectMorePhotos => 'さらに写真を選択';

  @override
  String get existingUser => '既存のユーザー';

  @override
  String get privateBackups => 'プライベートバックアップ';

  @override
  String get forYourMemories => '思い出の為に';

  @override
  String get endtoendEncryptedByDefault => 'デフォルトで端末間で暗号化されています';

  @override
  String get safelyStored => '保管されています';

  @override
  String get atAFalloutShelter => '核シェルターで';

  @override
  String get designedToOutlive => '生き延びるためのデザイン';

  @override
  String get available => 'ご利用可能';

  @override
  String get everywhere => 'どこでも';

  @override
  String get androidIosWebDesktop => 'Android、iOS、Web、Desktop';

  @override
  String get mobileWebDesktop => 'モバイル、Web、デスクトップ';

  @override
  String get newToEnte => 'Enteを初めて使用する';

  @override
  String get pleaseLoginAgain => 'もう一度試してください';

  @override
  String get autoLogoutMessage => '技術的な不具合により、ログアウトしました。ご不便をおかけして申し訳ございません。';

  @override
  String get yourSubscriptionHasExpired => 'サブスクリプションの有効期限が終了しました';

  @override
  String get storageLimitExceeded => 'ストレージの上限を超えました';

  @override
  String get upgrade => 'アップグレード';

  @override
  String get raiseTicket => 'サポートを受ける';

  @override
  String get backupFailed => 'バックアップ失敗';

  @override
  String get sorryBackupFailedDesc =>
      'Sorry, we could not backup this file right now, we will retry later.';

  @override
  String get couldNotBackUpTryLater => 'データをバックアップできませんでした。\n後で再試行します。';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      '大切に保管します、Enteにファイルへのアクセスを許可してください';

  @override
  String get pleaseGrantPermissions => '権限を付与してください';

  @override
  String get grantPermission => '許可する';

  @override
  String get privateSharing => 'プライベート共有';

  @override
  String get shareOnlyWithThePeopleYouWant => '選んだ人と共有します';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      '公開リンクを使用する(Enteを利用しない人と共有できます)';

  @override
  String get allowPeopleToAddPhotos => '写真の追加をメンバーに許可する';

  @override
  String get shareAnAlbumNow => 'アルバムを共有';

  @override
  String get collectEventPhotos => 'イベントの写真を集めよう';

  @override
  String get sessionExpired => 'セッション切れ';

  @override
  String get loggingOut => 'ログアウト中...';

  @override
  String get onDevice => 'デバイス上';

  @override
  String get onEnte => '<branding>Ente</branding>が保管';

  @override
  String get name => '名前順';

  @override
  String get newest => '新しい順';

  @override
  String get lastUpdated => '更新された順';

  @override
  String get deleteEmptyAlbums => '空のアルバムを削除';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => '空のアルバムを削除しますか？';

  @override
  String get deleteAlbumsDialogBody => '空のアルバムはすべて削除されます。';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return '$currentlyDeleting / $totalCount を削除中';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return '$currentlyProcessing / $totalCount を処理中';
  }

  @override
  String get permanentlyDelete => '完全に削除';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou => 'あなたが所有するファイルのみリンクを作成できます';

  @override
  String get publicLinkCreated => '公開リンクが作成されました';

  @override
  String get youCanManageYourLinksInTheShareTab => '作ったリンクは共有タブで管理できます';

  @override
  String get linkCopiedToClipboard => 'リンクをクリップボードにコピーしました';

  @override
  String get restore => '復元';

  @override
  String get moveToAlbum => 'アルバムに移動';

  @override
  String get unhide => '再表示';

  @override
  String get unarchive => 'アーカイブ解除';

  @override
  String get favorite => 'お気に入り';

  @override
  String get removeFromFavorite => 'お気に入りリストから外す';

  @override
  String get shareLink => 'リンクの共有';

  @override
  String get createCollage => 'コラージュを作る';

  @override
  String get saveCollage => 'コラージュを保存';

  @override
  String get collageSaved => 'コラージュをギャラリーに保存しました';

  @override
  String get collageLayout => 'レイアウト';

  @override
  String get addToEnte => 'Enteに追加';

  @override
  String get addToAlbum => 'アルバムに追加';

  @override
  String get delete => '削除';

  @override
  String get hide => '非表示';

  @override
  String get share => '共有';

  @override
  String get unhideToAlbum => 'アルバムを再表示する';

  @override
  String get restoreToAlbum => 'アルバムに戻す';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Move items',
      one: 'Move item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add items',
      one: 'Add item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'アルバムを作成または選択';

  @override
  String get selectAlbum => 'アルバムを選択';

  @override
  String get searchByAlbumNameHint => 'アルバム名';

  @override
  String get albumTitle => 'アルバムタイトル';

  @override
  String get enterAlbumName => 'アルバム名を入力';

  @override
  String get restoringFiles => 'ファイルを復元中...';

  @override
  String get movingFilesToAlbum => 'アルバムにファイルを移動中';

  @override
  String get unhidingFilesToAlbum => 'アルバムにファイルを表示しない';

  @override
  String get canNotUploadToAlbumsOwnedByOthers => '他の人が作ったアルバムにはアップロードできません';

  @override
  String get uploadingFilesToAlbum => 'アルバムにファイルをアップロード中';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return '$albumName に追加しました';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return '$albumName に移動しました';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'このアルバムはすでにコラボレーションリンクが生成されています';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return '$albumName のコラボレーションリンクを生成しました';
  }

  @override
  String get askYourLovedOnesToShare => 'あなたの愛する人にシェアしてもらうように頼んでください';

  @override
  String get invite => '招待';

  @override
  String get shareYourFirstAlbum => 'アルバムの共有をしてみましょう';

  @override
  String sharedWith({required Object emailIDs}) {
    return '$emailIDs と共有中';
  }

  @override
  String get sharedWithMe => 'あなたと共有されたアルバム';

  @override
  String get sharedByMe => 'あなたが共有しました';

  @override
  String get doubleYourStorage => 'ストレージを倍にしよう';

  @override
  String get referFriendsAnd2xYourPlan => '友達に紹介して2倍';

  @override
  String get shareAlbumHint => 'アルバムを開いて右上のシェアボタンをタップ';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      '完全に削除されるまでの日数が項目に表示されます';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 日',
      one: '1日',
      zero: '',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => '全て削除';

  @override
  String get renameAlbum => 'アルバムの名前変更';

  @override
  String get convertToAlbum => 'アルバムに変換';

  @override
  String get setCover => 'カバー画像をセット';

  @override
  String get sortAlbumsBy => '並び替え';

  @override
  String get sortNewestFirst => '新しい順';

  @override
  String get sortOldestFirst => '古い順';

  @override
  String get rename => '名前変更';

  @override
  String get leaveSharedAlbum => '共有アルバムを抜けてよいですか？';

  @override
  String get leaveAlbum => 'アルバムを抜ける';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'あなたの追加した写真はこのアルバムから削除されます';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted => 'このアルバムには消すファイルがありません';

  @override
  String get youDontHaveAnyArchivedItems => 'アーカイブした項目はありません';

  @override
  String get ignoredFolderUploadReason =>
      'このアルバムの一部のファイルは、以前にEnteから削除されたため、あえてアップロード時に無視されます';

  @override
  String get resetIgnoredFiles => 'アップロード時に無視されるファイルをリセット';

  @override
  String get deviceFilesAutoUploading =>
      'このデバイス上アルバムに追加されたファイルは自動的にEnteにアップロードされます。';

  @override
  String get turnOnBackupForAutoUpload =>
      'バックアップをオンにすると、このデバイスフォルダに追加されたファイルは自動的にEnteにアップロードされます。';

  @override
  String get noHiddenPhotosOrVideos => '非表示の写真やビデオはありません';

  @override
  String get toHideAPhotoOrVideo => '写真や動画を非表示にする';

  @override
  String get openTheItem => '• アイテムを開く';

  @override
  String get clickOnTheOverflowMenu => '• 三点ドットをクリックしてください';

  @override
  String get click => '• クリック';

  @override
  String get nothingToSeeHere => 'ここに表示されるものはありません！ 👀';

  @override
  String get unarchiveAlbum => 'アルバムのアーカイブ解除';

  @override
  String get archiveAlbum => 'アルバムをアーカイブ';

  @override
  String get calculating => '計算中...';

  @override
  String get pleaseWaitDeletingAlbum => 'お待ちください、アルバムを削除しています';

  @override
  String get searchByExamples =>
      '• アルバム名 (e.g. \"Camera\")\n• ファイルの種類 (e.g. \"Videos\", \".gif\")\n• 年月日 (e.g. \"2022\", \"January\")\n• ホリデー (e.g. \"Christmas\")\n• 写真の説明文 (e.g. “#fun”)';

  @override
  String get youCanTrySearchingForADifferentQuery => '別の単語を検索してみてください。';

  @override
  String get noResultsFound => '一致する結果が見つかりませんでした';

  @override
  String addedBy({required Object emailOrName}) {
    return '$emailOrName が追加';
  }

  @override
  String get loadingExifData => 'EXIF データを読み込み中...';

  @override
  String get viewAllExifData => '全ての EXIF データを表示';

  @override
  String get noExifData => 'EXIFデータはありません';

  @override
  String get thisImageHasNoExifData => 'この画像にEXIFデータはありません';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => '該当なし';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'あなたが所有していない写真やアルバムの編集はサポートされていません';

  @override
  String get failedToFetchOriginalForEdit => '編集前の状態の取得に失敗しました';

  @override
  String get close => '閉じる';

  @override
  String get setAs => '設定：';

  @override
  String get fileSavedToGallery => 'ファイルをギャラリーに保存しました';

  @override
  String get filesSavedToGallery => '写真をダウンロードしました';

  @override
  String get fileFailedToSaveToGallery => 'ギャラリーへの保存に失敗しました';

  @override
  String get download => 'ダウンロード';

  @override
  String get pressAndHoldToPlayVideo => '長押しで動画を再生';

  @override
  String get pressAndHoldToPlayVideoDetailed => '画像の長押しで動画を再生';

  @override
  String get downloadFailed => 'ダウンロード失敗';

  @override
  String get deduplicateFiles => '重複ファイル';

  @override
  String get deselectAll => '選択解除';

  @override
  String get reviewDeduplicateItems => '重複だと思うファイルを確認して削除してください';

  @override
  String get clubByCaptureTime => '時間ごとにまとめる';

  @override
  String get clubByFileName => 'ファイル名ごとにまとめる';

  @override
  String get count => 'カウント';

  @override
  String get totalSize => '合計サイズ';

  @override
  String get longpressOnAnItemToViewInFullscreen => 'アイテムを長押しして全画面表示する';

  @override
  String get decryptingVideo => 'ビデオの復号化中...';

  @override
  String get authToViewYourMemories => '思い出を閲覧するためには認証が必要です';

  @override
  String get unlock => 'ロック解除';

  @override
  String get freeUpSpace => 'スペースを解放する';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They can be deleted from the device to free up $formattedSize',
      one: 'It can be deleted from the device to free up $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber ファイル',
    );
    return '$_temp0 が安全にバックアップされました';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber 個のファイル',
    );
    return '$_temp0 が安全にバックアップされました';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return '$sizeInMBorGB を解放する';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'このメールアドレスはすでに使用されています。';

  @override
  String get incorrectCode => '誤ったコード';

  @override
  String get authenticationFailedPleaseTryAgain => '認証が間違っています。もう一度お試しください';

  @override
  String get verificationFailedPleaseTryAgain => '確認に失敗しました、再試行してください';

  @override
  String get authenticating => '認証中...';

  @override
  String get authenticationSuccessful => '認証に成功しました！';

  @override
  String get incorrectRecoveryKey => 'リカバリーキーが正しくありません';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect => '入力したリカバリーキーが間違っています';

  @override
  String get twofactorAuthenticationSuccessfullyReset => '2段階認証をリセットしました';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered => '入力したコードを確認してください';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      '問題が解決しない場合はサポートにお問い合わせください';

  @override
  String get twofactorAuthenticationHasBeenDisabled => '二段階認証が無効になりました。';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect => '入力されたコードは正しくありません';

  @override
  String get yourVerificationCodeHasExpired => '確認用コードが失効しました';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'メールアドレスが $newEmail に変更されました';
  }

  @override
  String get verifying => '確認中...';

  @override
  String get disablingTwofactorAuthentication => '2要素認証を無効にしています...';

  @override
  String get allMemoriesPreserved => 'すべての思い出が保存されました';

  @override
  String get loadingGallery => 'ギャラリーを読み込み中...';

  @override
  String get syncing => '同期中...';

  @override
  String get encryptingBackup => 'バックアップを暗号化中...';

  @override
  String get syncStopped => '同期が停止しました';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total のメモリが保存されました';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return '$count メモリを保存しています...';
  }

  @override
  String get uploadingSingleMemory => '1メモリを保存しています...';

  @override
  String get archiving => 'アーカイブ中です';

  @override
  String get unarchiving => 'アーカイブを解除中...';

  @override
  String get successfullyArchived => 'アーカイブしました';

  @override
  String get successfullyUnarchived => 'アーカイブを解除しました';

  @override
  String get renameFile => 'ファイル名を変更';

  @override
  String get enterFileName => 'ファイル名を入力してください';

  @override
  String get filesDeleted => '削除されたファイル';

  @override
  String get selectedFilesAreNotOnEnte => '選択したファイルはEnte上にありません';

  @override
  String get thisActionCannotBeUndone => 'この操作は元に戻せません';

  @override
  String get emptyTrash => 'ゴミ箱を空にしますか？';

  @override
  String get permDeleteWarning => 'ゴミ箱を空にしました\n\nこの操作はもとに戻せません';

  @override
  String get empty => '空';

  @override
  String get couldNotFreeUpSpace => 'スペースを解放できませんでした';

  @override
  String get permanentlyDeleteFromDevice => 'デバイスから完全に削除しますか？';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      '削除しようとしているファイルのいくつかは、お使いのデバイス上にのみあり、削除した場合は復元できません';

  @override
  String get theyWillBeDeletedFromAllAlbums => '全てのアルバムから削除されます。';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'いくつかの項目は、Enteとお使いのデバイス上の両方にあります。';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      '選択したアイテムはすべてのアルバムから削除され、ゴミ箱に移動されます。';

  @override
  String get theseItemsWillBeDeletedFromYourDevice => 'これらの項目はデバイスから削除されます。';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      '問題が発生したようです。しばらくしてから再試行してください。エラーが解決しない場合は、サポートチームにお問い合わせください。';

  @override
  String get error => 'エラー';

  @override
  String get tempErrorContactSupportIfPersists =>
      '問題が発生したようです。しばらくしてから再試行してください。エラーが解決しない場合は、サポートチームにお問い合わせください。';

  @override
  String get networkHostLookUpErr =>
      'Enteに接続できませんでした。ネットワーク設定を確認し、エラーが解決しない場合はサポートにお問い合わせください。';

  @override
  String get networkConnectionRefusedErr =>
      'Enteに接続できませんでした。しばらくしてから再試行してください。エラーが解決しない場合は、サポートにお問い合わせください。';

  @override
  String get cachedData => 'キャッシュデータ';

  @override
  String get clearCaches => 'キャッシュをクリア';

  @override
  String get remoteImages => 'デバイス上にない画像';

  @override
  String get remoteVideos => 'デバイス上にない動画';

  @override
  String get remoteThumbnails => 'リモートのサムネイル画像';

  @override
  String get pendingSync => '同期を保留中';

  @override
  String get localGallery => 'デバイス上のギャラリー';

  @override
  String get todaysLogs => '今日のログ';

  @override
  String get viewLogs => 'ログを表示';

  @override
  String get logsDialogBody =>
      'これにより、問題のデバッグに役立つログが送信されます。 特定のファイルの問題を追跡するために、ファイル名が含まれることに注意してください。';

  @override
  String get preparingLogs => 'ログを準備中...';

  @override
  String get emailYourLogs => 'ログをメールで送信';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'ログを以下のアドレスに送信してください \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'メールアドレスをコピー';

  @override
  String get exportLogs => 'ログのエクスポート';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return '$toEmail にメールでご連絡ください';
  }

  @override
  String get dismiss => '閉じる';

  @override
  String get didYouKnow => 'ご存知ですか?';

  @override
  String get loadingMessage => 'あなたの写真を読み込み中...';

  @override
  String get loadMessage1 => 'サブスクリプションを家族と共有できます';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 => '私たちはあなたのデータのコピーを3つ保管しています。1つは地下のシェルターにあります。';

  @override
  String get loadMessage4 => 'すべてのアプリはオープンソースです';

  @override
  String get loadMessage5 => '当社のソースコードと暗号方式は外部から監査されています';

  @override
  String get loadMessage6 => 'アルバムへのリンクを共有できます';

  @override
  String get loadMessage7 => '当社のモバイルアプリはバックグラウンドで実行され、新しい写真を暗号化してバックアップします';

  @override
  String get loadMessage8 => 'web.ente.ioにはアップローダーがあります';

  @override
  String get loadMessage9 => 'Xchacha20Poly1305を使用してデータを安全に暗号化します。';

  @override
  String get photoDescriptions => '写真の説明';

  @override
  String get fileTypesAndNames => 'ファイルの種類と名前';

  @override
  String get location => '場所';

  @override
  String get moments => '日々の瞬間';

  @override
  String get searchFaceEmptySection => '学習が完了すると、ここに人が表示されます';

  @override
  String get searchDatesEmptySection => '日付、月または年で検索';

  @override
  String get searchLocationEmptySection => '当時の直近で撮影された写真をグループ化';

  @override
  String get searchPeopleEmptySection => '友達を招待すると、共有される写真はここから閲覧できます';

  @override
  String get searchAlbumsEmptySection => 'アルバム';

  @override
  String get searchFileTypesAndNamesEmptySection => 'ファイルの種類と名前';

  @override
  String get searchCaptionEmptySection =>
      '写真情報に \"#trip\" のように説明を追加すれば、ここで簡単に見つけることができます';

  @override
  String get language => '言語';

  @override
  String get selectLanguage => '言語を選ぶ';

  @override
  String get locationName => '場所名';

  @override
  String get addLocation => '位置情報を追加';

  @override
  String get groupNearbyPhotos => '近くの写真をグループ化';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => '追加';

  @override
  String get radius => '半径';

  @override
  String get locationTagFeatureDescription =>
      '位置タグは、写真の半径内で撮影されたすべての写真をグループ化します';

  @override
  String get galleryMemoryLimitInfo => 'ギャラリーに表示されるメモリは最大1000個までです';

  @override
  String get save => '保存';

  @override
  String get centerPoint => '中心点';

  @override
  String get pickCenterPoint => '中心点を選択';

  @override
  String get useSelectedPhoto => '選択した写真を使用';

  @override
  String get resetToDefault => '初期設定にリセット';

  @override
  String get edit => '編集';

  @override
  String get deleteLocation => '位置情報を削除';

  @override
  String get rotateLeft => '左に回転';

  @override
  String get flip => '反転';

  @override
  String get rotateRight => '右に回転';

  @override
  String get saveCopy => 'コピーを保存';

  @override
  String get light => 'ライト';

  @override
  String get color => '色';

  @override
  String get yesDiscardChanges => 'はい、変更を破棄します。';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade => '編集を破棄しますか？';

  @override
  String get saving => '保存中…';

  @override
  String get editsSaved => '編集が保存されました';

  @override
  String get oopsCouldNotSaveEdits => '編集を保存できませんでした';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => '今日';

  @override
  String get dayYesterday => '昨日';

  @override
  String get storage => 'ストレージ';

  @override
  String get usedSpace => '使用済み領域';

  @override
  String get storageBreakupFamily => 'ファミリー';

  @override
  String get storageBreakupYou => 'あなた';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit / $totalAmount $totalStorageUnit 使用';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit 無料';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'バージョン: $versionValue';
  }

  @override
  String get verifyIDLabel => '確認';

  @override
  String get fileInfoAddDescHint => '説明を追加...';

  @override
  String get editLocationTagTitle => '位置情報を編集';

  @override
  String get setLabel => 'セット';

  @override
  String get setRadius => '半径の設定';

  @override
  String get familyPlanPortalTitle => 'ファミリー';

  @override
  String get familyPlanOverview =>
      '5人までの家族をファミリープランに追加しましょう(追加料金無し)\n\n一人ひとりがプライベートなストレージを持ち、共有されない限りお互いに見ることはありません。\n\nファミリープランはEnteサブスクリプションに登録した人が利用できます。\n\nさっそく登録しましょう！';

  @override
  String get androidBiometricHint => '本人確認を行う';

  @override
  String get androidBiometricNotRecognized => '認識できません。再試行してください。';

  @override
  String get androidBiometricSuccess => '成功';

  @override
  String get androidCancelButton => 'キャンセル';

  @override
  String get androidSignInTitle => '認証が必要です';

  @override
  String get androidBiometricRequiredTitle => '生体認証が必要です';

  @override
  String get androidDeviceCredentialsRequiredTitle => 'デバイスの認証情報が必要です';

  @override
  String get androidDeviceCredentialsSetupDescription => 'デバイスの認証情報が必要です';

  @override
  String get goToSettings => '設定に移動';

  @override
  String get androidGoToSettingsDescription =>
      '生体認証がデバイスで設定されていません。生体認証を追加するには、\"設定 > セキュリティ\"を開いてください。';

  @override
  String get iOSLockOut => '生体認証が無効化されています。画面をロック・ロック解除して生体認証を有効化してください。';

  @override
  String get iOSGoToSettingsDescription =>
      '生体認証がデバイスで設定されていません。Touch ID もしくは Face ID を有効にしてください。';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'OpenStreetMap のコントリビューター';

  @override
  String get hostedAtOsmFrance => 'OSM Franceでホスト';

  @override
  String get map => '地図';

  @override
  String get maps => '地図';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'マップを有効にする';

  @override
  String get quickLinks => 'クイックリンク';

  @override
  String get selectItemsToAdd => '追加するアイテムを選んでください';

  @override
  String get addSelected => '選んだものをアルバムに追加';

  @override
  String get addFromDevice => 'デバイスから追加';

  @override
  String get addPhotos => '写真を追加';

  @override
  String get noPhotosFoundHere => '写真が見つかりません';

  @override
  String get zoomOutToSeePhotos => 'ズームアウトして写真を表示';

  @override
  String get noImagesWithLocation => '位置情報のある画像がありません';

  @override
  String get unpinAlbum => 'アルバムのピン留めを解除';

  @override
  String get pinAlbum => 'アルバムをピンする';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => '作成';

  @override
  String get viewAll => 'すべて表示';

  @override
  String get nothingSharedWithYouYet => 'あなたに共有されたものはありません';

  @override
  String get noAlbumsSharedByYouYet => 'あなたが共有したアルバムはまだありません';

  @override
  String get sharedWithYou => 'あなたと共有されています';

  @override
  String get sharedByYou => 'あなたが共有しました';

  @override
  String get inviteYourFriendsToEnte => '友達をEnteに招待する';

  @override
  String get failedToDownloadVideo => 'ビデオをダウンロードできませんでした';

  @override
  String get hiding => '非表示にしています';

  @override
  String get unhiding => '非表示を解除しています';

  @override
  String get successfullyHid => '非表示にしました';

  @override
  String get successfullyUnhid => '非表示を解除しました';

  @override
  String get crashReporting => 'クラッシュを報告';

  @override
  String get resumableUploads => '再開可能なアップロード';

  @override
  String get addToHiddenAlbum => '非表示アルバムに追加';

  @override
  String get moveToHiddenAlbum => '隠しアルバムに移動';

  @override
  String get fileTypes => 'ファイルの種類';

  @override
  String get deleteConfirmDialogBody =>
      'このアカウントは他のEnteアプリも使用している場合はそれらにも紐づけされています。\nすべてのEnteアプリでアップロードされたデータは削除され、アカウントは完全に削除されます。';

  @override
  String get hearUsWhereTitle => 'Ente についてどのようにお聞きになりましたか？（任意）';

  @override
  String get hearUsExplanation =>
      '私たちはアプリのインストールを追跡していませんが、もしよければ、Enteをお知りになった場所を教えてください！';

  @override
  String get viewAddOnButton => 'アドオンを表示';

  @override
  String get addOns => 'アドオン';

  @override
  String get addOnPageSubtitle => 'アドオンの詳細';

  @override
  String get yourMap => 'あなたの地図';

  @override
  String get modifyYourQueryOrTrySearchingFor => 'クエリを変更するか、以下のように検索してみてください';

  @override
  String get blackFridaySale => 'ブラックフライデーセール';

  @override
  String get upto50OffUntil4thDec => '12月4日まで、最大50%オフ。';

  @override
  String get photos => '写真';

  @override
  String get videos => 'ビデオ';

  @override
  String get livePhotos => 'ライブフォト';

  @override
  String get searchHint1 => 'デバイス上で高速検索';

  @override
  String get searchHint2 => '写真の日付、説明';

  @override
  String get searchHint3 => 'アルバム、ファイル名、種類';

  @override
  String get searchHint4 => '場所';

  @override
  String get searchHint5 => '近日公開: フェイスとマジック検索 ✨';

  @override
  String get addYourPhotosNow => '写真を今すぐ追加する';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 個の結果',
      one: '$count 個の結果',
    );
    return '$_temp0';
  }

  @override
  String get faces => '顔';

  @override
  String get people => '人物';

  @override
  String get contents => '内容';

  @override
  String get addNew => '新規追加';

  @override
  String get contacts => '連絡先';

  @override
  String get noInternetConnection => 'インターネット接続なし';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'インターネット接続を確認して、再試行してください。';

  @override
  String get signOutFromOtherDevices => '他のデバイスからサインアウトする';

  @override
  String get signOutOtherBody =>
      '他の誰かがあなたのパスワードを知っている可能性があると判断した場合は、あなたのアカウントを使用している他のすべてのデバイスから強制的にサインアウトできます。';

  @override
  String get signOutOtherDevices => '他のデバイスからサインアウトする';

  @override
  String get doNotSignOut => 'サインアウトしない';

  @override
  String get editLocation => '位置情報を編集';

  @override
  String get selectALocation => '場所を選択';

  @override
  String get selectALocationFirst => '先に場所を選択してください';

  @override
  String get changeLocationOfSelectedItems => '選択したアイテムの位置を変更しますか？';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte => '位置情報の編集はEnteでのみ表示されます';

  @override
  String get cleanUncategorized => '未分類のクリーンアップ';

  @override
  String get cleanUncategorizedDescription => '他のアルバムに存在する「未分類」からすべてのファイルを削除';

  @override
  String get waitingForVerification => '確認を待っています...';

  @override
  String get passkey => 'パスキー';

  @override
  String get passkeyAuthTitle => 'パスキーの検証';

  @override
  String get loginWithTOTP => 'TOTPでログイン';

  @override
  String get passKeyPendingVerification => '検証はまだ保留中です';

  @override
  String get loginSessionExpired => 'セッション切れ';

  @override
  String get loginSessionExpiredDetails => 'セッションの有効期限が切れました。再度ログインしてください。';

  @override
  String get verifyPasskey => 'パスキーを確認';

  @override
  String get playOnTv => 'TVでアルバムを再生';

  @override
  String get pair => 'ペアリング';

  @override
  String get deviceNotFound => 'デバイスが見つかりません';

  @override
  String get castInstruction =>
      'ペアリングしたいデバイスでcast.ente.ioにアクセスしてください。\n\nテレビでアルバムを再生するには以下のコードを入力してください。';

  @override
  String get deviceCodeHint => 'コードを入力する';

  @override
  String get joinDiscord => 'Discordに参加';

  @override
  String get locations => '場所';

  @override
  String get addAName => '名前を追加';

  @override
  String get findThemQuickly => 'すばやく見つける';

  @override
  String get findPeopleByName => '名前で人を探す';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      '表示されているEメールアドレスを長押しして、暗号化を確認します。';

  @override
  String get developerSettingsWarning => '開発者向け設定を変更してもよろしいですか？';

  @override
  String get developerSettings => '開発者向け設定';

  @override
  String get serverEndpoint => 'サーバーエンドポイント';

  @override
  String get invalidEndpoint => '無効なエンドポイントです';

  @override
  String get invalidEndpointMessage =>
      '入力されたエンドポイントは無効です。有効なエンドポイントを入力して再試行してください。';

  @override
  String get endpointUpdatedMessage => 'エンドポイントの更新に成功しました';

  @override
  String customEndpoint({required Object endpoint}) {
    return '$endpoint に接続しました';
  }

  @override
  String get createCollaborativeLink => '共同作業用リンクを作成';

  @override
  String get search => '検索';

  @override
  String get enterPersonName => '人名を入力してください';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => '名前を入力';

  @override
  String get savePerson => '人物を保存';

  @override
  String get editPerson => '人物を編集';

  @override
  String get mergedPhotos => '統合された写真';

  @override
  String get orMergeWithExistingPerson => '既存のものと統合する';

  @override
  String get enterDateOfBirth => '誕生日（任意）';

  @override
  String get birthday => '誕生日';

  @override
  String get removePersonLabel => '人名を削除';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc => '自動ペアリングは Chromecast に対応しているデバイスでのみ動作します。';

  @override
  String get manualPairDesc => 'PINを使ってペアリングすると、どんなスクリーンで動作します。';

  @override
  String get connectToDevice => 'デバイスに接続';

  @override
  String get autoCastDialogBody => '利用可能なキャストデバイスが表示されます。';

  @override
  String get autoCastiOSPermission =>
      'ローカルネットワークへのアクセス許可がEnte Photosアプリに与えられているか確認してください';

  @override
  String get noDeviceFound => 'デバイスが見つかりません';

  @override
  String get stopCastingTitle => 'キャストを停止';

  @override
  String get stopCastingBody => 'キャストを停止しますか？';

  @override
  String get castIPMismatchTitle => 'アルバムのキャストに失敗しました';

  @override
  String get castIPMismatchBody => 'TVと同じネットワーク上にいることを確認してください。';

  @override
  String get pairingComplete => 'ペアリング完了';

  @override
  String get savingEdits => '編集を保存中...';

  @override
  String get autoPair => 'オートペアリング';

  @override
  String get pairWithPin => 'PINを使ってペアリングする';

  @override
  String get faceRecognition => '顔認識';

  @override
  String get foundFaces => '見つかった顔';

  @override
  String get clusteringProgress => 'クラスタリングの進行状況';

  @override
  String get trim => 'トリミング';

  @override
  String get crop => 'クロップ';

  @override
  String get rotate => '回転';

  @override
  String get left => '左';

  @override
  String get right => '右';

  @override
  String get whatsNew => '最新情報';

  @override
  String get reviewSuggestions => '提案を確認';

  @override
  String get review => '確認';

  @override
  String get useAsCover => 'カバー写真として使用';

  @override
  String notPersonLabel({required String name}) {
    return '$name ではありませんか？';
  }

  @override
  String get enable => '有効化';

  @override
  String get enabled => '有効';

  @override
  String get moreDetails => 'さらに詳細を表示';

  @override
  String get enableMLIndexingDesc =>
      'Enteは顔認識、マジック検索、その他の高度な検索機能のため、あなたのデバイス上で機械学習をしています';

  @override
  String get magicSearchHint =>
      'マジック検索では、「花」、「赤い車」、「本人確認書類」などの写真に写っているもので検索できます。';

  @override
  String get panorama => 'パノラマ';

  @override
  String get reenterPassword => 'パスワードを再入力してください';

  @override
  String get reenterPin => 'PINを再入力してください';

  @override
  String get deviceLock => 'デバイスロック';

  @override
  String get pinLock => 'PINロック';

  @override
  String get next => '次へ';

  @override
  String get setNewPassword => '新しいパスワードを設定';

  @override
  String get enterPin => 'PINを入力してください';

  @override
  String get setNewPin => '新しいPINを設定';

  @override
  String get appLock => 'アプリのロック';

  @override
  String get noSystemLockFound => 'システムロックが見つかりませんでした';

  @override
  String get tapToUnlock => 'タップして解除';

  @override
  String get tooManyIncorrectAttempts => '間違った回数が多すぎます';

  @override
  String get videoInfo => 'ビデオ情報';

  @override
  String get autoLock => '自動ロック';

  @override
  String get immediately => 'すぐに';

  @override
  String get autoLockFeatureDescription => 'アプリがバックグラウンドでロックするまでの時間';

  @override
  String get hideContent => '内容を非表示';

  @override
  String get hideContentDescriptionAndroid => 'アプリ画面を非表示にし、スクリーンショットを無効にします';

  @override
  String get hideContentDescriptionIos => 'アプリ切り替え時に、アプリの画面を非表示にします';

  @override
  String get passwordStrengthInfo => 'パスワードの長さ、使用される文字の種類を考慮してパスワードの強度は計算されます。';

  @override
  String get noQuickLinksSelected => 'クイックリンクが選択されていません';

  @override
  String get pleaseSelectQuickLinksToRemove => '削除するクイックリンクを選択してください';

  @override
  String get removePublicLinks => '公開リンクを削除';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      '選択したすべてのクイックリンクの公開リンクを削除します。';

  @override
  String get guestView => 'ゲストビュー';

  @override
  String get guestViewEnablePreSteps =>
      'アプリのロックを有効にするには、システム設定でデバイスのパスコードまたは画面ロックを設定してください。';

  @override
  String get nameTheAlbum => 'アルバムに名前を付けよう';

  @override
  String get collectPhotosDescription => '友達が写真をアップロードできるリンクを作成できます';

  @override
  String get collect => '集める';

  @override
  String get appLockDescriptions => 'デバイスのデフォルトのロック画面と、カスタムロック画面のどちらを利用しますか？';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'アプリのロックを有効にするには、システム設定でデバイスのパスコードまたは画面ロックを設定してください。';

  @override
  String get authToViewPasskey => 'パスキーを表示するには認証してください';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'ローカルの写真の同期には予想以上の時間がかかっています。問題が発生したようです。サポートチームまでご連絡ください。';

  @override
  String get showPerson => '人物を表示';

  @override
  String get sort => '並び替え';

  @override
  String get mostRecent => '新しい順';

  @override
  String get mostRelevant => '関連度順';

  @override
  String get loadingYourPhotos => '写真を読み込んでいます...';

  @override
  String processingImport({required Object folderName}) {
    return '$folderName を処理中...';
  }

  @override
  String get personName => '人名名';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => '新しい人物を追加';

  @override
  String get addNameOrMerge => '名前をつける、あるいは既存の人物にまとめる';

  @override
  String get mergeWithExisting => '既存の人物とまとめる';

  @override
  String get newPerson => '新しい人物';

  @override
  String get addName => '名前を追加';

  @override
  String get add => '追加';

  @override
  String extraPhotosFoundFor({required String text}) {
    return '$text の写真が見つかりました';
  }

  @override
  String get extraPhotosFound => '追加の写真が見つかりました';

  @override
  String get configuration => '設定';

  @override
  String get localIndexing => 'このデバイス上での実行';

  @override
  String get processed => '処理完了';

  @override
  String get resetPerson => '削除';

  @override
  String get areYouSureYouWantToResetThisPerson => 'この人を忘れてもよろしいですね？';

  @override
  String get allPersonGroupingWillReset =>
      'この人のグループ化がリセットされ、この人かもしれない写真への提案もなくなります';

  @override
  String get yesResetPerson => 'リセット';

  @override
  String get onlyThem => 'この人のみ';

  @override
  String get checkingModels => 'モデルを確認しています...';

  @override
  String get enableMachineLearningBanner => 'マジック検索と顔認識のため、機械学習を有効にする';

  @override
  String get searchDiscoverEmptySection => '処理と同期が完了すると、画像がここに表示されます';

  @override
  String get searchPersonsEmptySection => '処理と同期が完了すると、ここに人々が表示されます';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count人のコラボレーターを追加',
      one: '$count人のコラボレーターを追加',
      zero: '$count人のコラボレーターを追加',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'アカウントが既に設定されています';

  @override
  String get sessionIdMismatch => 'セッションIDが一致しません';

  @override
  String get failedToFetchActiveSessions => 'アクティブなセッションの取得に失敗しました';

  @override
  String get failedToRefreshStripeSubscription => 'サブスクリプションの更新に失敗しました';

  @override
  String get failedToPlayVideo => '動画の再生に失敗しました';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return '以下の理由によりアップロードは無視されます: $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'このギャラリーのタイプ $galleryType は名前の変更には対応していません';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'アップロードするにはタップしてください。 以下の理由のためアップロードは現在無視されています: $ignoreReason';
  }

  @override
  String get tapToUpload => 'タップしてアップロード';

  @override
  String get info => '情報';

  @override
  String get addFiles => 'ファイルを追加';

  @override
  String get castAlbum => 'アルバムをキャスト';

  @override
  String get imageNotAnalyzed => '画像が分析されていません';

  @override
  String get noFacesFound => '顔が見つかりません';

  @override
  String get fileNotUploadedYet => 'ファイルがまだアップロードされていません';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return '$personName の候補はありません';
  }

  @override
  String get month => '月';

  @override
  String get yearShort => '年';

  @override
  String get currentlyRunning => '現在実行中';

  @override
  String get ignored => '無視された';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'ファイル';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'セクションの長さの不一致: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'メールアプリを選択';

  @override
  String get selectAllShort => 'すべて';

  @override
  String get selectCoverPhoto => 'カバー写真を選択';

  @override
  String get newLocation => '新しいロケーション';

  @override
  String get faceNotClusteredYet => '顔がまだ集まっていません。後で戻ってきてください';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'アクセスしようとしているリンクの期限が切れています。';

  @override
  String get openFile => 'ファイルを開く';

  @override
  String get backupFile => 'バックアップファイル';

  @override
  String get openAlbumInBrowser => 'ブラウザでアルバムを開く';

  @override
  String get openAlbumInBrowserTitle => 'このアルバムに写真を追加するには、Webアプリを使用してください';

  @override
  String get allow => '許可';

  @override
  String get allowAppToOpenSharedAlbumLinks => '共有アルバムリンクを開くことをアプリに許可する';

  @override
  String get seePublicAlbumLinksInApp => 'アプリ内で公開アルバムのリンクを見る';

  @override
  String get emergencyContacts => '緊急連絡先';

  @override
  String get acceptTrustInvite => '招待を受け入れる';

  @override
  String get declineTrustInvite => '招待を拒否する';

  @override
  String get removeYourselfAsTrustedContact => 'あなた自身を信頼できる連絡先から削除';

  @override
  String get legacy => 'レガシー';

  @override
  String get legacyPageDesc =>
      'レガシーでは、信頼できる連絡先が不在時(あなたが亡くなった時など)にアカウントにアクセスできます。';

  @override
  String get legacyPageDesc2 =>
      '信頼できる連絡先はアカウントの回復を開始することができます。30日以内にあなたが拒否しない場合は、その信頼する人がパスワードをリセットしてあなたのアカウントにアクセスできるようになります。';

  @override
  String get legacyAccounts => 'レガシーアカウント';

  @override
  String get trustedContacts => '信頼する連絡先';

  @override
  String get addTrustedContact => '信頼する連絡先を追加';

  @override
  String get removeInvite => '招待を削除';

  @override
  String get recoveryWarning => '信頼する連絡先の持ち主があなたのアカウントにアクセスしようとしています';

  @override
  String get rejectRecovery => 'リカバリを拒否する';

  @override
  String get recoveryInitiated => 'リカバリが開始されました';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return '$days 日後にアカウントにアクセスできます。通知は $emailに送信されます。';
  }

  @override
  String get cancelAccountRecovery => 'リカバリをキャンセル';

  @override
  String get recoveryAccount => 'アカウントを復元';

  @override
  String get cancelAccountRecoveryBody => 'リカバリをキャンセルしてもよろしいですか？';

  @override
  String get startAccountRecoveryTitle => 'リカバリを開始';

  @override
  String get whyAddTrustContact => '信頼する連絡先は、データの復旧が必要な際に役立ちます。';

  @override
  String recoveryReady({required String email}) {
    return '$emailのアカウントを復元できるようになりました。新しいパスワードを設定してください。';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email はあなたのアカウントを復元しようとしています。';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'あなたは $emailから信頼する連絡先になってもらうよう、お願いされています。';
  }

  @override
  String get warning => '警告';

  @override
  String get proceed => '続行';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return '$email を信頼する連絡先として追加しようとしています。 $numOfDays 日間あなたの利用がなくなった場合、アカウントを復旧することができるようになります。';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email があなたを信頼する連絡先として招待しました';
  }

  @override
  String get authToManageLegacy => '信頼する連絡先を管理するために認証してください';

  @override
  String get hideSharedItemsFromHomeGallery => 'ホームギャラリーから共有された写真等を非表示';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'ギャラリー';

  @override
  String get joinAlbum => 'アルバムに参加';

  @override
  String get joinAlbumSubtext => '写真を表示したり、追加したりするために';

  @override
  String get joinAlbumSubtextViewer => 'これを共有アルバムに追加するために';

  @override
  String get join => '参加する';

  @override
  String get linkEmail => 'メールアドレスをリンクする';

  @override
  String get link => 'リンク';

  @override
  String get noEnteAccountExclamation => 'アカウントがありません！';

  @override
  String get orPickFromYourContacts => 'または連絡先から選択';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email は Ente アカウントを持っていません。';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (私)';
  }

  @override
  String get reassignMe => '\"自分\" を再割り当て';

  @override
  String get me => '自分';

  @override
  String get linkEmailToContactBannerCaption => '共有を高速化するために';

  @override
  String get selectPersonToLink => 'リンクする人を選択';

  @override
  String linkPersonToEmail({required String email}) {
    return 'この人物を $emailに紐づけ';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return '$personName を $email に紐づけします';
  }

  @override
  String get selectYourFace => 'あなたの顔を選択';

  @override
  String get reassigningLoading => '再割り当て中...';

  @override
  String reassignedToName({required String name}) {
    return 'あなたを $name に紐づけました';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'その前に変更を保存しますか？';

  @override
  String get dontSave => '保存しない';

  @override
  String get thisIsMeExclamation => 'これは私です';

  @override
  String get linkPerson => '人を紐づけ';

  @override
  String get linkPersonCaption => '良い経験を分かち合うために';

  @override
  String get videoStreaming => 'Streamable videos';

  @override
  String get processingVideos => '動画を処理中';

  @override
  String get streamDetails => '動画の詳細';

  @override
  String get processing => '処理中';

  @override
  String get queued => '処理待ち';

  @override
  String get ineligible => '対象外';

  @override
  String get failed => '失敗';

  @override
  String get playStream => '再生';

  @override
  String get playOriginal => '元動画を再生';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'アルバムに参加すると、参加者にメールアドレスが公開されます。';

  @override
  String get pleaseWaitThisWillTakeAWhile => 'しばらくお待ちください。時間がかかります。';

  @override
  String get editTime => '時刻を編集';

  @override
  String get selectTime => '時刻を選択';

  @override
  String get selectDate => '日付を選択する';

  @override
  String get previous => '前';

  @override
  String get selectOneDateAndTimeForAll => 'すべてに対して日付と時刻を1つ選択してください';

  @override
  String get selectStartOfRange => '範囲の開始位置を選択';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      '選択したすべての写真の日付と時刻が同じになります。';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'これはグループ内の最初のものです。他の選択した写真は、この新しい日付に基づいて自動的にシフトされます';

  @override
  String get newRange => '範囲を追加';

  @override
  String get selectOneDateAndTime => '日付と時刻を1つ選択してください';

  @override
  String get moveSelectedPhotosToOneDate => '選択した写真を1つの日付に移動';

  @override
  String get shiftDatesAndTime => '日付と時間のシフト';

  @override
  String get photosKeepRelativeTimeDifference => '写真はお互いの相対的な時間差を維持します';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 枚の写真',
      one: '1枚の写真',
      zero: '0枚の写真',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'アプリアイコン';

  @override
  String get notThisPerson => 'この人ではありませんか？';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      '選択したアイテムはこの人としての登録が解除されますが、ライブラリからは削除されません。';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat から年';
  }

  @override
  String get thisWeekThroughTheYears => '毎年のこの週';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count年前の今週',
      one: '$count 1年前の今週',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'あなたと$name';
  }

  @override
  String admiringThem({required Object name}) {
    return '$nameに注目！';
  }

  @override
  String embracingThem({required Object name}) {
    return '$name抱きしめて！';
  }

  @override
  String partyWithThem({required Object name}) {
    return '$nameとパーティー！';
  }

  @override
  String hikingWithThem({required Object name}) {
    return '$nameとハイキング！';
  }

  @override
  String feastingWithThem({required Object name}) {
    return '$nameとご飯！';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return '$nameとセルフィー！';
  }

  @override
  String posingWithThem({required Object name}) {
    return '$nameと一緒にポーズ！';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return '$nameと見た美しい景色！';
  }

  @override
  String sportsWithThem({required Object name}) {
    return '$nameとスポーツ！';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return '$nameと車で旅行！';
  }

  @override
  String get spotlightOnYourself => 'あなた自身にスポットライト！';

  @override
  String spotlightOnThem({required Object name}) {
    return '$nameにスポットライト！';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$nameが$age才！';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$nameが$age才になった！';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return '前回の$nameとの時間';
  }

  @override
  String tripToLocation({required Object location}) {
    return '$locationへの旅行';
  }

  @override
  String tripInYear({required Object year}) {
    return '$year年の旅行';
  }

  @override
  String get lastYearsTrip => '昨年の旅行';

  @override
  String get sunrise => '水平線';

  @override
  String get mountains => '丘を超えて';

  @override
  String get greenery => '緑の生活';

  @override
  String get beach => '砂浜と海';

  @override
  String get city => '市街';

  @override
  String get moon => '月明かりの中';

  @override
  String get onTheRoad => '再び道で';

  @override
  String get food => '料理を楽しむ';

  @override
  String get pets => '毛むくじゃらな仲間たち';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memories';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Past years\' memories';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Happy birthday! 🥳';

  @override
  String get birthdays => 'Birthdays';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Other detected faces';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Save as another person';

  @override
  String get showLessFaces => 'Show less faces';

  @override
  String get showMoreFaces => 'Show more faces';

  @override
  String get ignore => 'Ignore';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'リチュアルのご紹介';

  @override
  String get cLDesc1 =>
      '2026年の目標を計画中ですか？リチュアルを使えば、Ente Photosでリマインダーを設定し、写真を撮って進捗を追跡できます。トレーニング、食習慣、大切な人との日々の瞬間など、習慣にしたいことに使いましょう。';

  @override
  String get cLTitle2 => '公開リンクが全員に';

  @override
  String get cLDesc2 =>
      '無料プランのすべてのEnteユーザーが、写真やアルバムへの公開リンクを作成・共有できるようになりました。悪用防止のため、リンクには閲覧可能な人数の制限があります。';

  @override
  String get cLTitle3 => '手動で人物をタグ付け';

  @override
  String get cLDesc3 =>
      'デバイス上のAIが顔を検出しない場合でも、人物をタグ付けできるようになりました。ペット、一部しか見えない顔、実際には写真に写っていないが含めたい人物に便利です。';

  @override
  String get cLTitle4 => 'その他の更新';

  @override
  String get cLDesc4 =>
      '共有アルバムをピン留めできるようになりました。アルバムリンクは共同作業者や閲覧者に表示され、共有がさらに簡単になりました。iOSのスワイプバグを修正し、新しいお気に入りアイコンを含むフォトビューを更新しました（今後の機能のためのスペースを確保）。';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
