// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class AppLocalizationsIt extends AppLocalizations {
  AppLocalizationsIt([String locale = 'it']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Inserisci il tuo indirizzo email';

  @override
  String get enterYourNewEmailAddress =>
      'Inserisci il tuo nuovo indirizzo email';

  @override
  String get accountWelcomeBack => 'Bentornato!';

  @override
  String get emailAlreadyRegistered => 'Email già registrata.';

  @override
  String get emailNotRegistered => 'Email non registrata.';

  @override
  String get email => 'Email';

  @override
  String get cancel => 'Annulla';

  @override
  String get verify => 'Verifica';

  @override
  String get invalidEmailAddress => 'Indirizzo email non valido';

  @override
  String get enterValidEmail => 'Inserisci un indirizzo email valido.';

  @override
  String get deleteAccount => 'Elimina account';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Qual è il motivo principale per cui stai cancellando il tuo account?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Ci dispiace vederti andare via. Facci sapere se hai bisogno di aiuto o se vuoi aiutarci a migliorare.';

  @override
  String get feedback => 'Suggerimenti';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Aiutaci con queste informazioni';

  @override
  String get confirmDeletePrompt =>
      'Sì, voglio eliminare definitivamente questo account e i dati associati a esso su tutte le applicazioni.';

  @override
  String get confirmAccountDeletion => 'Conferma eliminazione account';

  @override
  String get deleteAccountPermanentlyButton =>
      'Cancella definitivamente il tuo account';

  @override
  String get yourAccountHasBeenDeleted => 'Il tuo account è stato eliminato';

  @override
  String get selectReason => 'Seleziona un motivo';

  @override
  String get deleteReason1 =>
      'Manca una caratteristica chiave di cui ho bisogno';

  @override
  String get deleteReason2 =>
      'L\'app o una determinata funzionalità non si comporta come dovrebbe';

  @override
  String get deleteReason3 =>
      'Ho trovato un altro servizio che mi piace di più';

  @override
  String get deleteReason4 => 'Il motivo non è elencato';

  @override
  String get sendEmail => 'Invia email';

  @override
  String get deleteRequestSLAText =>
      'La tua richiesta verrà elaborata entro 72 ore.';

  @override
  String get deleteEmailRequest =>
      'Invia un\'email a <warning>account-deletion@ente.io</warning> dal tuo indirizzo email registrato.';

  @override
  String get entePhotosPerm =>
      'Ente <i>necessita del permesso per</i> preservare le tue foto';

  @override
  String get ok => 'Ok';

  @override
  String get createAccount => 'Crea account';

  @override
  String get createNewAccount => 'Crea un nuovo account';

  @override
  String get password => 'Password';

  @override
  String get confirmPassword => 'Conferma password';

  @override
  String get activeSessions => 'Sessioni attive';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Ooops';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Qualcosa è andato storto, per favore riprova';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Verrai disconnesso dal tuo dispositivo!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Verrai disconnesso dai seguenti dispositivi:';

  @override
  String get terminateSession => 'Termina sessione?';

  @override
  String get terminate => 'Terminata';

  @override
  String get thisDevice => 'Questo dispositivo';

  @override
  String get recoverButton => 'Recupera';

  @override
  String get recoverySuccessful => 'Recupero riuscito!';

  @override
  String get decrypting => 'Decriptando...';

  @override
  String get incorrectRecoveryKeyTitle => 'Chiave di recupero errata';

  @override
  String get incorrectRecoveryKeyBody =>
      'Il codice che hai inserito non è corretto';

  @override
  String get forgotPassword => 'Password dimenticata';

  @override
  String get enterYourRecoveryKey => 'Inserisci la tua chiave di recupero';

  @override
  String get noRecoveryKey => 'Nessuna chiave di recupero?';

  @override
  String get sorry => 'Siamo spiacenti';

  @override
  String get noRecoveryKeyNoDecryption =>
      'A causa della natura del nostro protocollo di crittografia end-to-end, i tuoi dati non possono essere decifrati senza password o chiave di ripristino';

  @override
  String get verifyEmail => 'Verifica email';

  @override
  String get toResetVerifyEmail =>
      'Per reimpostare la tua password, verifica prima la tua email.';

  @override
  String get checkInboxAndSpamFolder =>
      'Per favore, controlla la tua casella di posta (e lo spam) per completare la verifica';

  @override
  String get tapToEnterCode => 'Tocca per inserire il codice';

  @override
  String get resendEmail => 'Rinvia email';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Abbiamo inviato una mail a <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Imposta password';

  @override
  String get changePasswordTitle => 'Modifica password';

  @override
  String get resetPasswordTitle => 'Reimposta password';

  @override
  String get encryptionKeys => 'Chiavi di crittografia';

  @override
  String get passwordWarning =>
      'Noi non memorizziamo la tua password, quindi se te la dimentichi, <underline>non possiamo decriptare i tuoi dati</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Inserisci una password per criptare i tuoi dati';

  @override
  String get enterNewPasswordToEncrypt =>
      'Inserisci una nuova password per criptare i tuoi dati';

  @override
  String get weakStrength => 'Debole';

  @override
  String get strongStrength => 'Forte';

  @override
  String get moderateStrength => 'Mediocre';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Sicurezza password: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Password modificata con successo';

  @override
  String get generatingEncryptionKeys =>
      'Generazione delle chiavi di crittografia...';

  @override
  String get pleaseWait => 'Attendere...';

  @override
  String get continueLabel => 'Continua';

  @override
  String get insecureDevice => 'Dispositivo non sicuro';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Siamo spiacenti, non possiamo generare le chiavi sicure su questo dispositivo.\n\nPer favore, accedi da un altro dispositivo.';

  @override
  String get howItWorks => 'Come funziona';

  @override
  String get encryption => 'Crittografia';

  @override
  String get ackPasswordLostWarning =>
      'Comprendo che se perdo la password potrei perdere l\'accesso ai miei dati poiché sono <underline>criptati end-to-end</underline>.';

  @override
  String get privacyPolicyTitle => 'Privacy Policy';

  @override
  String get termsOfServicesTitle => 'Termini d\'uso';

  @override
  String get signUpTerms =>
      'Accetto i <u-terms>termini di servizio</u-terms> e la <u-policy>politica sulla privacy</u-policy>';

  @override
  String get logInLabel => 'Accedi';

  @override
  String get loginTerms =>
      'Cliccando sul pulsante Accedi, accetti i <u-terms>termini di servizio</u-terms> e la <u-policy>politica sulla privacy</u-policy>';

  @override
  String get changeEmail => 'Modifica email';

  @override
  String get enterYourPassword => 'Inserisci la tua password';

  @override
  String get welcomeBack => 'Bentornato/a!';

  @override
  String get contactSupport => 'Contatta il supporto';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Password sbagliata';

  @override
  String get pleaseTryAgain => 'Riprova';

  @override
  String get recreatePasswordTitle => 'Reimposta password';

  @override
  String get useRecoveryKey => 'Utilizza un codice di recupero';

  @override
  String get recreatePasswordBody =>
      'Il dispositivo attuale non è abbastanza potente per verificare la tua password, ma la possiamo rigenerare in un modo che funzioni su tutti i dispositivi.\n\nEffettua il login utilizzando la tua chiave di recupero e rigenera la tua password (puoi utilizzare nuovamente la stessa se vuoi).';

  @override
  String get verifyPassword => 'Verifica password';

  @override
  String get recoveryKey => 'Chiave di recupero';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Se dimentichi la password, questa chiave è l\'unico modo per recuperare i tuoi dati.';

  @override
  String get recoveryKeySaveDescription =>
      'Noi non memorizziamo questa chiave, per favore salva queste 24 parole in un posto sicuro.';

  @override
  String get doThisLater => 'In seguito';

  @override
  String get saveKey => 'Salva chiave';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Chiave di recupero copiata negli appunti';

  @override
  String get recoverAccount => 'Recupera account';

  @override
  String get recover => 'Recupera';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Per favore invia un\'email a $supportEmail dall\'indirizzo email con cui ti sei registrato';
  }

  @override
  String get twofactorSetup => 'Configura autenticazione a due fattori';

  @override
  String get enterCode => 'Inserisci codice';

  @override
  String get scanCode => 'Scansiona codice';

  @override
  String get codeCopiedToClipboard => 'Codice copiato negli appunti';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Copia-incolla questo codice\nnella tua app di autenticazione';

  @override
  String get tapToCopy => 'tocca per copiare';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Scansione questo codice QR\ncon la tua app di autenticazione';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Inserisci il codice di 6 cifre\ndalla tua app di autenticazione';

  @override
  String get confirm => 'Conferma';

  @override
  String get setupComplete => 'Configurazione completata';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Salva la tua chiave di recupero se non l\'hai ancora fatto';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Può essere utilizzata per recuperare il tuo account in caso tu non possa usare l\'autenticazione a due fattori';

  @override
  String get twofactorAuthenticationPageTitle => 'Autenticazione a due fattori';

  @override
  String get lostDevice => 'Dispositivo perso?';

  @override
  String get verifyingRecoveryKey => 'Verifica della chiave di recupero...';

  @override
  String get recoveryKeyVerified => 'Chiave di recupero verificata';

  @override
  String get recoveryKeySuccessBody =>
      'Ottimo! La tua chiave di recupero è valida. Grazie per averla verificata.\n\nRicordati di salvare la tua chiave di recupero in un posto sicuro.';

  @override
  String get invalidRecoveryKey =>
      'La chiave di recupero che hai inserito non è valida. Assicurati che contenga 24 parole e controlla l\'ortografia di ciascuna parola.\n\nSe hai inserito un vecchio codice di recupero, assicurati che sia lungo 64 caratteri e controlla ciascuno di essi.';

  @override
  String get invalidKey => 'Chiave non valida';

  @override
  String get tryAgain => 'Riprova';

  @override
  String get viewRecoveryKey => 'Visualizza chiave di recupero';

  @override
  String get confirmRecoveryKey => 'Conferma chiave di recupero';

  @override
  String get recoveryKeyVerifyReason =>
      'Se hai dimenticato la password, la tua chiave di ripristino è l\'unico modo per recuperare le tue foto. La puoi trovare in Impostazioni > Account.\n\nInserisci la tua chiave di recupero per verificare di averla salvata correttamente.';

  @override
  String get confirmYourRecoveryKey => 'Conferma la tua chiave di recupero';

  @override
  String get addViewer => 'Aggiungi in sola lettura';

  @override
  String get addCollaborator => 'Aggiungi collaboratore';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Aggiungi una nuova email';

  @override
  String get orPickAnExistingOne => 'Oppure scegline una esistente';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'I collaboratori possono aggiungere foto e video all\'album condiviso.';

  @override
  String get enterEmail => 'Inserisci email';

  @override
  String get albumOwner => 'Proprietario';

  @override
  String get you => 'Tu';

  @override
  String get collaborator => 'Collaboratore';

  @override
  String get addMore => 'Aggiungi altri';

  @override
  String get viewer => 'Sola lettura';

  @override
  String get remove => 'Rimuovi';

  @override
  String get removeParticipant => 'Rimuovi partecipante';

  @override
  String get manage => 'Gestisci';

  @override
  String get addedAs => 'Aggiunto come';

  @override
  String get changePermissions => 'Cambio i permessi?';

  @override
  String get yesConvertToViewer => 'Sì, converti in sola lettura';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user non sarà più in grado di aggiungere altre foto a questo album\n\nSarà ancora in grado di rimuovere le foto esistenti aggiunte da lui o lei';
  }

  @override
  String get allowAddingPhotos => 'Consenti l\'aggiunta di foto';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Permetti anche alle persone con il link di aggiungere foto all\'album condiviso.';

  @override
  String get passwordLock => 'Blocco con password';

  @override
  String get canNotOpenTitle => 'Impossibile aprire questo album';

  @override
  String get canNotOpenBody =>
      'Spiacente, questo album non può essere aperto nell\'app.';

  @override
  String get disableDownloadWarningTitle => 'Nota bene';

  @override
  String get disableDownloadWarningBody =>
      'I visualizzatori possono scattare screenshot o salvare una copia delle foto utilizzando strumenti esterni';

  @override
  String get allowDownloads => 'Consenti download';

  @override
  String get linkDeviceLimit => 'Limite dei dispositivi';

  @override
  String get noDeviceLimit => 'Nessuno';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Scadenza del link';

  @override
  String get linkExpired => 'Scaduto';

  @override
  String get linkEnabled => 'Attivato';

  @override
  String get linkNeverExpires => 'Mai';

  @override
  String get expiredLinkInfo =>
      'Questo link è scaduto. Si prega di selezionare un nuovo orario di scadenza o disabilitare la scadenza del link.';

  @override
  String get setAPassword => 'Imposta una password';

  @override
  String get lockButtonLabel => 'Blocca';

  @override
  String get enterPassword => 'Inserisci password';

  @override
  String get removeLink => 'Elimina link';

  @override
  String get manageLink => 'Gestisci link';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Il link scadrà il $expiryTime';
  }

  @override
  String get albumUpdated => 'Album aggiornato';

  @override
  String get never => 'Mai';

  @override
  String get custom => 'Personalizza';

  @override
  String get after1Hour => 'Dopo un’ora ';

  @override
  String get after1Day => 'Dopo un giorno';

  @override
  String get after1Week => 'Dopo una settimana';

  @override
  String get after1Month => 'Dopo un mese';

  @override
  String get after1Year => 'Dopo un anno';

  @override
  String get manageParticipants => 'Gestisci';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Partecipanti',
      one: '1 Partecipante',
      zero: 'Nessun partecipante',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Crea un link per consentire alle persone di aggiungere e visualizzare foto nel tuo album condiviso senza bisogno di un\'applicazione o di un account Ente. Ottimo per raccogliere foto di un evento.';

  @override
  String get collectPhotos => 'Raccogli le foto';

  @override
  String get collaborativeLink => 'Link collaborativo';

  @override
  String get shareWithNonenteUsers =>
      'Condividi con utenti che non hanno un account Ente';

  @override
  String get createPublicLink => 'Crea link pubblico';

  @override
  String get sendLink => 'Invia link';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Invia QR code';

  @override
  String get copyLink => 'Copia link';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Il link è scaduto';

  @override
  String get publicLinkEnabled => 'Link pubblico abilitato';

  @override
  String get shareALink => 'Condividi un link';

  @override
  String get sharedAlbumSectionDescription =>
      'Crea album condivisi e collaborativi con altri utenti di Ente, inclusi gli utenti con piani gratuiti.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Condividi con $numberOfPeople persone',
      one: 'Condividi con una persona',
      zero: 'Condividi con persone specifiche',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Questo è il tuo ID di verifica';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Chi condivide gli album con te deve vedere lo stesso ID sul proprio dispositivo.';

  @override
  String get howToViewShareeVerificationID =>
      'Chiedi di premere a lungo il loro indirizzo email nella schermata delle impostazioni e verificare che gli ID su entrambi i dispositivi corrispondano.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Questo è l\'ID di verifica di $email';
  }

  @override
  String get verificationId => 'ID di verifica';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verifica $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email non ha un account Ente.\n\nInvia un invito per condividere foto.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Ecco il mio ID di verifica: $verificationID per ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Hey, puoi confermare che questo è il tuo ID di verifica: $verificationID su ente.io';
  }

  @override
  String get somethingWentWrong => 'Qualcosa è andato storto';

  @override
  String get sendInvite => 'Invita';

  @override
  String get shareTextRecommendUsingEnte =>
      'Scarica Ente in modo da poter facilmente condividere foto e video in qualità originale\n\nhttps://ente.io';

  @override
  String get done => 'Completato';

  @override
  String get applyCodeTitle => 'Applica codice';

  @override
  String get enterCodeDescription =>
      'Inserisci il codice fornito dal tuo amico per richiedere spazio gratuito per entrambi';

  @override
  String get apply => 'Applica';

  @override
  String get failedToApplyCode => 'Impossibile applicare il codice';

  @override
  String get enterReferralCode => 'Inserisci il codice di invito';

  @override
  String get codeAppliedPageTitle => 'Codice applicato';

  @override
  String get changeYourReferralCode => 'Cambia il tuo codice invito';

  @override
  String get change => 'Cambia';

  @override
  String get unavailableReferralCode =>
      'Siamo spiacenti, questo codice non è disponibile.';

  @override
  String get codeChangeLimitReached =>
      'Siamo spiacenti, hai raggiunto il limite di modifiche del codice.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Per favore contatta $familyAdminEmail per cambiare il tuo codice.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Riscattato';

  @override
  String get details => 'Dettagli';

  @override
  String get claimMore => 'Richiedine di più!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Anche loro riceveranno $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB ogni volta che qualcuno si iscrive a un piano a pagamento e applica il tuo codice';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Codice invito Ente: $referralCode \n\nInseriscilo in Impostazioni → Generali → Inviti per ottenere $referralStorageInGB GB gratis dopo la sottoscrizione a un piano a pagamento\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Richiedi spazio gratuito';

  @override
  String get inviteYourFriends => 'Invita i tuoi amici';

  @override
  String get failedToFetchReferralDetails =>
      'Impossibile recuperare i dettagli. Per favore, riprova più tardi.';

  @override
  String get referralStep1 => '1. Condividi questo codice con i tuoi amici';

  @override
  String get referralStep2 => '2. Si iscrivono per un piano a pagamento';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Ottenete entrambi $storageInGB GB* gratis';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'I referral code sono attualmente in pausa';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Puoi al massimo raddoppiare il tuo spazio';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true':
          'Il tuo piano famiglia ha già richiesto $storageAmountInGb GB finora',
      'false': 'Hai già richiesto $storageAmountInGb GB finora',
      'other': 'Hai già richiesto $storageAmountInGb GB finora!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'FAQ';

  @override
  String get help => 'Aiuto';

  @override
  String get oopsSomethingWentWrong => 'Oops! Qualcosa è andato storto';

  @override
  String get peopleUsingYourCode => 'Persone che hanno usato il tuo codice';

  @override
  String get eligible => 'idoneo';

  @override
  String get total => 'totale';

  @override
  String get codeUsedByYou => 'Codice utilizzato da te';

  @override
  String get freeStorageClaimed => 'Spazio gratuito richiesto';

  @override
  String get freeStorageUsable => 'Spazio libero utilizzabile';

  @override
  String get usableReferralStorageInfo =>
      'Lo spazio disponibile è limitato dal tuo piano corrente. L\'archiviazione in eccesso diventerà automaticamente utilizzabile quando aggiornerai il tuo piano.';

  @override
  String get removeFromAlbumTitle => 'Rimuovi dall\'album?';

  @override
  String get removeFromAlbum => 'Rimuovi dall\'album';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Gli elementi selezionati saranno rimossi da questo album';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Aggiunto ai preferiti...';

  @override
  String get removingFromFavorites => 'Rimosso dai preferiti...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Spiacenti, non è stato possibile aggiungere ai preferiti!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Siamo spiacenti, non è stato possibile rimuovere dai preferiti!';

  @override
  String get subscribeToEnableSharing =>
      'È necessario un abbonamento a pagamento attivo per abilitare la condivisione.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'Iscriviti';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Puoi rimuovere solo i file di tua proprietà';

  @override
  String get deleteSharedAlbum => 'Eliminare l\'album condiviso?';

  @override
  String get deleteAlbum => 'Elimina album';

  @override
  String get deleteAlbumDialog =>
      'Eliminare anche le foto (e i video) presenti in questo album da <bold>tutti</bold> gli altri album di cui fanno parte?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'L\'album verrà eliminato per tutti\n\nPerderai l\'accesso alle foto condivise in questo album che sono di proprietà di altri';

  @override
  String get yesRemove => 'Sì, rimuovi';

  @override
  String get creatingLink => 'Creazione link...';

  @override
  String get removeWithQuestionMark => 'Rimuovi?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail verrà rimosso da questo album condiviso\n\nQualsiasi foto aggiunta dall\'utente verrà rimossa dall\'album';
  }

  @override
  String get keepPhotos => 'Mantieni foto';

  @override
  String get deletePhotos => 'Elimina foto';

  @override
  String get inviteToEnte => 'Invita su Ente';

  @override
  String get removePublicLink => 'Rimuovi link pubblico';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Questo rimuoverà il link pubblico per accedere a \"$albumName\".';
  }

  @override
  String get sharing => 'Condivisione in corso...';

  @override
  String get youCannotShareWithYourself => 'Non puoi condividere con te stesso';

  @override
  String get archive => 'Archivio';

  @override
  String get createAlbumActionHint =>
      'Premi a lungo per selezionare le foto e fai clic su + per creare un album';

  @override
  String get importing => 'Importazione in corso....';

  @override
  String get failedToLoadAlbums => 'Impossibile caricare gli album';

  @override
  String get hidden => 'Nascosti';

  @override
  String get authToViewYourHiddenFiles =>
      'Autenticati per visualizzare i file nascosti';

  @override
  String get authToViewTrashedFiles =>
      'Autenticati per visualizzare i file cancellati';

  @override
  String get trash => 'Cestino';

  @override
  String get uncategorized => 'Senza categoria';

  @override
  String get videoSmallCase => 'video';

  @override
  String get photoSmallCase => 'foto';

  @override
  String get singleFileDeleteHighlight => 'Verrà eliminato da tutti gli album.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Questo $fileType è sia su Ente che sul tuo dispositivo.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Questo $fileType verrà eliminato da Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Questo $fileType verrà eliminato dal tuo dispositivo.';
  }

  @override
  String get deleteFromEnte => 'Elimina da Ente';

  @override
  String get yesDelete => 'Sì, elimina';

  @override
  String get movedToTrash => 'Spostato nel cestino';

  @override
  String get deleteFromDevice => 'Elimina dal dispositivo';

  @override
  String get deleteFromBoth => 'Elimina da entrambi';

  @override
  String get newAlbum => 'Nuovo album';

  @override
  String get albums => 'Album';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount ricordi',
      one: '$formattedCount ricordo',
      zero: 'nessun ricordo',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count selezionati';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count selezionato ($yourCount tuoi)';
  }

  @override
  String get advancedSettings => 'Avanzate';

  @override
  String get photoGridSize => 'Dimensione griglia foto';

  @override
  String get manageDeviceStorage => 'Gestisci cache dispositivo';

  @override
  String get manageDeviceStorageDesc =>
      'Verifica e svuota la memoria cache locale.';

  @override
  String get machineLearning => 'Apprendimento automatico (ML)';

  @override
  String get mlConsent => 'Abilita l\'apprendimento automatico';

  @override
  String get mlConsentTitle => 'Abilita l\'apprendimento automatico?';

  @override
  String get mlConsentDescription =>
      'Se abiliti il Machine Learning, Ente estrarrà informazioni come la geometria del volto dai file, inclusi quelli condivisi con te.\n\nQuesto accadrà sul tuo dispositivo, e qualsiasi informazione biometrica generata sarà crittografata end-to-end.';

  @override
  String get mlConsentPrivacy =>
      'Clicca qui per maggiori dettagli su questa funzione nella nostra informativa sulla privacy';

  @override
  String get mlConsentConfirmation =>
      'Comprendo e desidero abilitare l\'apprendimento automatico';

  @override
  String get magicSearch => 'Ricerca magica';

  @override
  String get discover => 'Scopri';

  @override
  String get discover_identity => 'Identità';

  @override
  String get discover_screenshots => 'Schermate';

  @override
  String get discover_receipts => 'Ricette';

  @override
  String get discover_notes => 'Note';

  @override
  String get discover_memes => 'Meme';

  @override
  String get discover_visiting_cards => 'Biglietti da Visita';

  @override
  String get discover_babies => 'Neonati';

  @override
  String get discover_pets => 'Animali domestici';

  @override
  String get discover_selfies => 'Selfie';

  @override
  String get discover_wallpapers => 'Sfondi';

  @override
  String get discover_food => 'Cibo';

  @override
  String get discover_celebrations => 'Festeggiamenti';

  @override
  String get discover_sunset => 'Tramonto';

  @override
  String get discover_hills => 'Colline';

  @override
  String get discover_greenery => 'Vegetazione';

  @override
  String get mlIndexingDescription =>
      'Si prega di notare che l\'attivazione dell\'apprendimento automatico si tradurrà in un maggior utilizzo della connessione e della batteria fino a quando tutti gli elementi non saranno indicizzati. Valuta di utilizzare l\'applicazione desktop per un\'indicizzazione più veloce, tutti i risultati verranno sincronizzati automaticamente.';

  @override
  String get loadingModel => 'Scaricamento modelli...';

  @override
  String get waitingForWifi => 'In attesa del WiFi...';

  @override
  String get status => 'Stato';

  @override
  String get indexedItems => 'Elementi indicizzati';

  @override
  String get pendingItems => 'Elementi in sospeso';

  @override
  String get clearIndexes => 'Cancella indici';

  @override
  String get selectFoldersForBackup => 'Seleziona cartelle per il backup';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Le cartelle selezionate verranno crittografate e salvate su ente';

  @override
  String get unselectAll => 'Deseleziona tutto';

  @override
  String get selectAll => 'Seleziona tutto';

  @override
  String get skip => 'Salta';

  @override
  String get updatingFolderSelection =>
      'Aggiornamento della selezione delle cartelle...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementi',
      one: '$count elemento',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Elimina $count elementi',
      one: 'Elimina $count elemento',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count file, $formattedSize l\'uno';
  }

  @override
  String get showMemories => 'Mostra ricordi';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count anni fa',
      one: '$count anno fa',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Impostazioni backup';

  @override
  String get backupStatus => 'Stato backup';

  @override
  String get backupStatusDescription =>
      'Gli elementi che sono stati sottoposti a backup verranno mostrati qui';

  @override
  String get backupOverMobileData => 'Backup su dati mobili';

  @override
  String get backupVideos => 'Backup dei video';

  @override
  String get disableAutoLock => 'Disabilita blocco automatico';

  @override
  String get deviceLockExplanation =>
      'Disabilita il blocco schermo del dispositivo quando Ente è in primo piano e c\'è un backup in corso. Questo normalmente non è necessario ma può aiutare a completare più velocemente grossi caricamenti e l\'importazione iniziale di grandi librerie.';

  @override
  String get about => 'Info';

  @override
  String get weAreOpenSource => 'Siamo open source!';

  @override
  String get privacy => 'Privacy';

  @override
  String get terms => 'Termini d\'uso';

  @override
  String get checkForUpdates => 'Controlla aggiornamenti';

  @override
  String get checkStatus => 'Verifica stato';

  @override
  String get checking => 'Controllo in corso...';

  @override
  String get youAreOnTheLatestVersion => 'Stai utilizzando l\'ultima versione';

  @override
  String get account => 'Account';

  @override
  String get manageSubscription => 'Gestisci abbonamento';

  @override
  String get authToChangeYourEmail => 'Autenticati per cambiare la tua email';

  @override
  String get changePassword => 'Cambia password';

  @override
  String get authToChangeYourPassword =>
      'Autenticati per cambiare la tua password';

  @override
  String get emailVerificationToggle => 'Verifica Email';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Autenticati per modificare la verifica email';

  @override
  String get exportYourData => 'Esporta dati';

  @override
  String get logout => 'Disconnetti';

  @override
  String get authToInitiateAccountDeletion =>
      'Autenticati per avviare l\'eliminazione dell\'account';

  @override
  String get areYouSureYouWantToLogout =>
      'Sei sicuro di volerti disconnettere?';

  @override
  String get yesLogout => 'Sì, disconnetti';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Una nuova versione di Ente è disponibile.';

  @override
  String get update => 'Aggiorna';

  @override
  String get installManually => 'Installa manualmente';

  @override
  String get criticalUpdateAvailable =>
      'Un aggiornamento importante è disponibile';

  @override
  String get updateAvailable => 'Aggiornamento disponibile';

  @override
  String get ignoreUpdate => 'Ignora';

  @override
  String get downloading => 'Scaricamento in corso...';

  @override
  String get cannotDeleteSharedFiles =>
      'Impossibile eliminare i file condivisi';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Il download non può essere completato';

  @override
  String get retry => 'Riprova';

  @override
  String get backedUpFolders => 'Cartelle salvate';

  @override
  String get backup => 'Backup';

  @override
  String get freeUpDeviceSpace => 'Libera spazio';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Risparmia spazio sul tuo dispositivo cancellando i file che sono già stati salvati online.';

  @override
  String get allClear => '✨ Tutto pulito';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Non hai file su questo dispositivo che possono essere eliminati';

  @override
  String get removeDuplicates => 'Rimuovi i doppioni';

  @override
  String get removeDuplicatesDesc =>
      'Verifica e rimuovi i file che sono esattamente duplicati.';

  @override
  String get viewLargeFiles => 'File di grandi dimensioni';

  @override
  String get viewLargeFilesDesc =>
      'Visualizza i file che stanno occupando la maggior parte dello spazio di archiviazione.';

  @override
  String get noDuplicates => '✨ Nessun doppione';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Non ci sono file duplicati che possono essere eliminati';

  @override
  String get success => 'Operazione riuscita';

  @override
  String get rateUs => 'Lascia una recensione';

  @override
  String get remindToEmptyDeviceTrash =>
      'Vuota anche \"Cancellati di recente\" da \"Impostazioni\" -> \"Storage\" per avere più spazio libero';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Hai liberato con successo $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Svuota anche il tuo \"Cestino\" per avere più spazio libero';

  @override
  String get sparkleSuccess => '✨ Operazione riuscita';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count doppioni',
      one: '$count doppione',
    );
    return 'Hai ripulito $_temp0, salvando ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Piano famiglia';

  @override
  String get referrals => 'Invita un Amico';

  @override
  String get notifications => 'Notifiche';

  @override
  String get sharedPhotoNotifications => 'Nuove foto condivise';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Ricevi notifiche quando qualcuno aggiunge una foto a un album condiviso, di cui fai parte';

  @override
  String get advanced => 'Avanzate';

  @override
  String get general => 'Generali';

  @override
  String get security => 'Sicurezza';

  @override
  String get authToViewYourRecoveryKey =>
      'Autenticati per visualizzare la tua chiave di recupero';

  @override
  String get twofactor => 'Due fattori';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Autenticati per configurare l\'autenticazione a due fattori';

  @override
  String get lockscreen => 'Schermata di blocco';

  @override
  String get authToChangeLockscreenSetting =>
      'Autenticati per modificare le impostazioni della schermata di blocco';

  @override
  String get viewActiveSessions => 'Visualizza sessioni attive';

  @override
  String get authToViewYourActiveSessions =>
      'Autenticati per visualizzare le sessioni attive';

  @override
  String get disableTwofactor => 'Disabilita autenticazione a due fattori';

  @override
  String get confirm2FADisable =>
      'Sei sicuro di voler disattivare l\'autenticazione a due fattori?';

  @override
  String get no => 'No';

  @override
  String get yes => 'Si';

  @override
  String get social => 'Social';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Valutaci su $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Merchandise';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Impossibile recuperare i dettagli di archiviazione';

  @override
  String get reportABug => 'Segnala un bug';

  @override
  String get reportBug => 'Segnala un bug';

  @override
  String get suggestFeatures => 'Suggerisci una funzionalità';

  @override
  String get support => 'Assistenza';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Chiaro';

  @override
  String get darkTheme => 'Scuro';

  @override
  String get systemTheme => 'Sistema';

  @override
  String get freeTrial => 'Prova gratuita';

  @override
  String get selectYourPlan => 'Seleziona un piano';

  @override
  String get enteSubscriptionPitch =>
      'Ente conserva i tuoi ricordi in modo che siano sempre a disposizione, anche se perdi il tuo dispositivo.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Aggiungi la tua famiglia al tuo piano.';

  @override
  String get currentUsageIs => 'Spazio attualmente utilizzato ';

  @override
  String get faqs => 'FAQ';

  @override
  String renewsOn({required Object endDate}) {
    return 'Si rinnova il $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'La prova gratuita termina il $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Valido fino al $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Il tuo spazio aggiuntivo di $storageAmount è valido fino al $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Prova gratuita valida fino al $endDate.\nIn seguito potrai scegliere un piano a pagamento.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'L\'abbonamento verrà cancellato il $endDate';
  }

  @override
  String get subscription => 'Abbonamento';

  @override
  String get paymentDetails => 'Dettagli di Pagamento';

  @override
  String get manageFamily => 'Gestisci Piano famiglia';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Scrivi all\'indirizzo support@ente.io per gestire il tuo abbonamento $provider.';
  }

  @override
  String get renewSubscription => 'Rinnova abbonamento';

  @override
  String get cancelSubscription => 'Annulla abbonamento';

  @override
  String get areYouSureYouWantToRenew => 'Sei sicuro di volere rinnovare?';

  @override
  String get yesRenew => 'Sì, Rinnova';

  @override
  String get areYouSureYouWantToCancel => 'Sicuro di volerlo cancellare?';

  @override
  String get yesCancel => 'Sì, cancella';

  @override
  String get failedToRenew => 'Rinnovo fallito';

  @override
  String get failedToCancel => 'Impossibile annullare';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 mesi gratis sui piani annuali';

  @override
  String get monthly => 'Mensile';

  @override
  String get yearly => 'Annuale';

  @override
  String get confirmPlanChange => 'Conferma le modifiche al piano';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Sei sicuro di voler cambiare il piano?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Non puoi effettuare il downgrade su questo piano';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Annulla prima il tuo abbonamento esistente da $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Facoltativo, breve quanto vuoi...';

  @override
  String get send => 'Invia';

  @override
  String get askCancelReason =>
      'Il tuo abbonamento è stato annullato. Vuoi condividere il motivo?';

  @override
  String get thankYouForSubscribing => 'Grazie per esserti iscritto!';

  @override
  String get yourPurchaseWasSuccessful => 'Acquisto andato a buon fine';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Il tuo piano è stato aggiornato con successo';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Il tuo piano è stato aggiornato con successo';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Il tuo abbonamento è stato modificato correttamente';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'Abbonamento su PlayStore';

  @override
  String get appstoreSubscription => 'abbonamento AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Il tuo $id è già collegato a un altro account Ente.\nSe desideri utilizzare il tuo $id con questo account, per favore contatta il nostro supporto\'\'';
  }

  @override
  String get visitWebToManage =>
      'Visita web.ente.io per gestire il tuo abbonamento';

  @override
  String get couldNotUpdateSubscription =>
      'Impossibile aggiornare l\'abbonamento';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Contatta support@ente.io e saremo felici di aiutarti!';

  @override
  String get paymentFailed => 'Pagamento non riuscito';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Si prega di parlare con il supporto di $providerName se ti è stato addebitato qualcosa';
  }

  @override
  String get continueOnFreeTrial => 'Continua la prova gratuita';

  @override
  String get areYouSureYouWantToExit => 'Sei sicuro di voler uscire?';

  @override
  String get thankYou => 'Grazie';

  @override
  String get failedToVerifyPaymentStatus =>
      'Impossibile verificare lo stato del pagamento';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Riprova tra qualche minuto';

  @override
  String get paymentFailedMessage =>
      'Purtroppo il tuo pagamento non è riuscito. Contatta l\'assistenza e ti aiuteremo!';

  @override
  String get youAreOnAFamilyPlan => 'Sei un utente con piano famiglia!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Contatta <green>$familyAdminEmail</green> per gestire il tuo abbonamento';
  }

  @override
  String get leaveFamily => 'Abbandona il piano famiglia';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Sei sicuro di voler uscire dal piano famiglia?';

  @override
  String get leave => 'Lascia';

  @override
  String get rateTheApp => 'Valuta l\'app';

  @override
  String get startBackup => 'Avvia backup';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Il backup delle foto attualmente non viene eseguito';

  @override
  String get preserveMore => 'Salva più foto';

  @override
  String get grantFullAccessPrompt =>
      'Consenti l\'accesso a tutte le foto nelle Impostazioni';

  @override
  String get allowPermTitle => 'Consenti l\'accesso alle foto';

  @override
  String get allowPermBody =>
      'Permetti l\'accesso alle tue foto da Impostazioni in modo che Ente possa visualizzare e fare il backup della tua libreria.';

  @override
  String get openSettings => 'Apri Impostazioni';

  @override
  String get selectMorePhotos => 'Seleziona più foto';

  @override
  String get existingUser => 'Accedi';

  @override
  String get privateBackups => 'Backup privato';

  @override
  String get forYourMemories => 'per i tuoi ricordi';

  @override
  String get endtoendEncryptedByDefault => 'Crittografia end-to-end';

  @override
  String get safelyStored => 'Salvati in sicurezza';

  @override
  String get atAFalloutShelter => 'in un rifugio antiatomico';

  @override
  String get designedToOutlive => 'Progettato per sopravvivere';

  @override
  String get available => 'Disponibile';

  @override
  String get everywhere => 'ovunque';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobile, Web, Desktop';

  @override
  String get newToEnte => 'Prima volta con Ente';

  @override
  String get pleaseLoginAgain => 'Effettua nuovamente l\'accesso';

  @override
  String get autoLogoutMessage =>
      'A causa di problemi tecnici, sei stato disconnesso. Ci scusiamo per l\'inconveniente.';

  @override
  String get yourSubscriptionHasExpired => 'Il tuo abbonamento è scaduto';

  @override
  String get storageLimitExceeded => 'Limite d\'archiviazione superato';

  @override
  String get upgrade => 'Acquista altro spazio';

  @override
  String get raiseTicket => 'Invia ticket';

  @override
  String get backupFailed => 'Backup fallito';

  @override
  String get sorryBackupFailedDesc =>
      'Purtroppo non è stato possibile eseguire il backup del file in questo momento, riproveremo più tardi.';

  @override
  String get couldNotBackUpTryLater =>
      'Impossibile eseguire il backup dei tuoi dati.\nRiproveremo più tardi.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente può criptare e conservare i file solo se gliene concedi l\'accesso';

  @override
  String get pleaseGrantPermissions => 'Concedi i permessi';

  @override
  String get grantPermission => 'Concedi il permesso';

  @override
  String get privateSharing => 'Condivisioni private';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Condividi solo con le persone che vuoi';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Usa link pubblici per persone non registrate su Ente';

  @override
  String get allowPeopleToAddPhotos =>
      'Permetti alle persone di aggiungere foto';

  @override
  String get shareAnAlbumNow => 'Condividi un album';

  @override
  String get collectEventPhotos => 'Raccogli le foto di un evento';

  @override
  String get sessionExpired => 'Sessione scaduta';

  @override
  String get loggingOut => 'Disconnessione...';

  @override
  String get onDevice => 'Sul dispositivo';

  @override
  String get onEnte => 'Su <branding>ente</branding>';

  @override
  String get name => 'Nome';

  @override
  String get newest => 'Più recenti';

  @override
  String get lastUpdated => 'Ultimo aggiornamento';

  @override
  String get deleteEmptyAlbums => 'Elimina gli album vuoti';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Eliminare gli album vuoti?';

  @override
  String get deleteAlbumsDialogBody =>
      'Questo eliminerà tutti gli album vuoti. È utile quando si desidera ridurre l\'ingombro nella lista degli album.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Eliminazione di $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Elaborazione $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Elimina definitivamente';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Puoi creare solo link per i file di tua proprietà';

  @override
  String get publicLinkCreated => 'Link pubblico creato';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Puoi gestire i tuoi link nella scheda condivisione.';

  @override
  String get linkCopiedToClipboard => 'Link copiato negli appunti';

  @override
  String get restore => 'Ripristina';

  @override
  String get moveToAlbum => 'Sposta nell\'album';

  @override
  String get unhide => 'Mostra';

  @override
  String get unarchive => 'Rimuovi dall\'archivio';

  @override
  String get favorite => 'Preferito';

  @override
  String get removeFromFavorite => 'Rimuovi dai preferiti';

  @override
  String get shareLink => 'Condividi link';

  @override
  String get createCollage => 'Crea un collage';

  @override
  String get saveCollage => 'Salva il collage';

  @override
  String get collageSaved => 'Collage salvato nella galleria';

  @override
  String get collageLayout => 'Disposizione';

  @override
  String get addToEnte => 'Aggiungi a Ente';

  @override
  String get addToAlbum => 'Aggiungi all\'album';

  @override
  String get delete => 'Cancella';

  @override
  String get hide => 'Nascondi';

  @override
  String get share => 'Condividi';

  @override
  String get unhideToAlbum => 'Non nascondere l\'album';

  @override
  String get restoreToAlbum => 'Ripristina l\'album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Sposta elementi',
      one: 'Sposta elemento',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Aggiungi elementi',
      one: 'Aggiungi elemento',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Crea o seleziona album';

  @override
  String get selectAlbum => 'Seleziona album';

  @override
  String get searchByAlbumNameHint => 'Nome album';

  @override
  String get albumTitle => 'Titolo album';

  @override
  String get enterAlbumName => 'Inserisci il nome dell\'album';

  @override
  String get restoringFiles => 'Ripristinando file...';

  @override
  String get movingFilesToAlbum => 'Spostamento dei file nell\'album...';

  @override
  String get unhidingFilesToAlbum => 'Mostra i file nell\'album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Impossibile caricare su album di proprietà altrui';

  @override
  String get uploadingFilesToAlbum => 'Caricamento dei file nell\'album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Aggiunto con successo su $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Spostato con successo su $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Questo album ha già un link collaborativo';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Link collaborativo creato per $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Invita amici, amiche e parenti su ente';

  @override
  String get invite => 'Invita';

  @override
  String get shareYourFirstAlbum => 'Condividi il tuo primo album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Condiviso con $emailIDs';
  }

  @override
  String get sharedWithMe => 'Condivisi con me';

  @override
  String get sharedByMe => 'Condiviso da me';

  @override
  String get doubleYourStorage => 'Raddoppia il tuo spazio';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Invita un amico e raddoppia il tuo spazio';

  @override
  String get shareAlbumHint =>
      'Apri un album e tocca il pulsante di condivisione in alto a destra per condividerlo.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Gli elementi mostrano il numero di giorni rimanenti prima della cancellazione permanente';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count giorni',
      one: '1 giorno',
      zero: 'Presto',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Elimina tutto';

  @override
  String get renameAlbum => 'Rinomina album';

  @override
  String get convertToAlbum => 'Converti in album';

  @override
  String get setCover => 'Imposta copertina';

  @override
  String get sortAlbumsBy => 'Ordina per';

  @override
  String get sortNewestFirst => 'Prima le più nuove';

  @override
  String get sortOldestFirst => 'Prima le più vecchie';

  @override
  String get rename => 'Rinomina';

  @override
  String get leaveSharedAlbum => 'Abbandonare l\'album condiviso?';

  @override
  String get leaveAlbum => 'Abbandona l\'album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Le foto aggiunte da te verranno rimosse dall\'album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Non hai file in questo album che possono essere eliminati';

  @override
  String get youDontHaveAnyArchivedItems => 'Non hai nulla di archiviato.';

  @override
  String get ignoredFolderUploadReason =>
      'Alcuni file in questo album vengono ignorati dal caricamento perché erano stati precedentemente eliminati da Ente.';

  @override
  String get resetIgnoredFiles => 'Ripristina i file ignorati';

  @override
  String get deviceFilesAutoUploading =>
      'I file aggiunti a questo album del dispositivo verranno automaticamente caricati su Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Attiva il backup per caricare automaticamente i file aggiunti a questa cartella del dispositivo su Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Nessuna foto o video nascosti';

  @override
  String get toHideAPhotoOrVideo => 'Per nascondere una foto o un video';

  @override
  String get openTheItem => '• Apri la foto o il video';

  @override
  String get clickOnTheOverflowMenu => '• Fai clic sul menu';

  @override
  String get click => '• Clic';

  @override
  String get nothingToSeeHere => 'Nulla da vedere qui! 👀';

  @override
  String get unarchiveAlbum => 'Rimuovi album dall\'archivio';

  @override
  String get archiveAlbum => 'Archivia album';

  @override
  String get calculating => 'Calcolando...';

  @override
  String get pleaseWaitDeletingAlbum => 'Attendere, sto eliminando l\'album';

  @override
  String get searchByExamples =>
      '• Nomi degli album (es. \"Camera\")\n• Tipi di file (es. \"Video\", \".gif\")\n• Anni e mesi (e.. \"2022\", \"gennaio\")\n• Vacanze (ad es. \"Natale\")\n• Descrizioni delle foto (ad es. “#mare”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Prova con una ricerca differente.';

  @override
  String get noResultsFound => 'Nessun risultato trovato';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Aggiunto da $emailOrName';
  }

  @override
  String get loadingExifData => 'Caricamento dati EXIF...';

  @override
  String get viewAllExifData => 'Mostra tutti i dati EXIF';

  @override
  String get noExifData => 'Nessun dato EXIF';

  @override
  String get thisImageHasNoExifData => 'Questa immagine non ha dati EXIF';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Nessun risultato';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Non puoi modificare foto e album che non possiedi';

  @override
  String get failedToFetchOriginalForEdit =>
      'Impossibile recuperare l\'originale per la modifica';

  @override
  String get close => 'Chiudi';

  @override
  String get setAs => 'Imposta come';

  @override
  String get fileSavedToGallery => 'File salvato nella galleria';

  @override
  String get filesSavedToGallery => 'File salvati nella galleria';

  @override
  String get fileFailedToSaveToGallery =>
      'Impossibile salvare il file nella galleria';

  @override
  String get download => 'Scarica';

  @override
  String get pressAndHoldToPlayVideo => 'Tieni premuto per riprodurre il video';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Tieni premuto sull\'immagine per riprodurre il video';

  @override
  String get downloadFailed => 'Scaricamento fallito';

  @override
  String get deduplicateFiles => 'File Duplicati';

  @override
  String get deselectAll => 'Deseleziona tutti';

  @override
  String get reviewDeduplicateItems =>
      'Controlla ed elimina gli elementi che credi siano dei doppioni.';

  @override
  String get clubByCaptureTime => 'Club per tempo di cattura';

  @override
  String get clubByFileName => 'Unisci per nome file';

  @override
  String get count => 'Conteggio';

  @override
  String get totalSize => 'Dimensioni totali';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Premi a lungo su un elemento per visualizzarlo a schermo intero';

  @override
  String get decryptingVideo => 'Decifratura video...';

  @override
  String get authToViewYourMemories =>
      'Autenticati per visualizzare le tue foto';

  @override
  String get unlock => 'Sblocca';

  @override
  String get freeUpSpace => 'Libera spazio';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Possono essere cancellati per liberare $formattedSize',
      one: 'Può essere cancellato per liberare $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber file',
      one: '1 file',
    );
    return '$_temp0 di quest\'album sono stati salvati in modo sicuro';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber file',
      one: '1 file',
    );
    return '$_temp0 di quest\'album sono stati salvati in modo sicuro';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Libera $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Questo indirizzo email è già registrato';

  @override
  String get incorrectCode => 'Codice sbagliato';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Autenticazione non riuscita, prova di nuovo';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verifica fallita, per favore prova di nuovo';

  @override
  String get authenticating => 'Autenticazione...';

  @override
  String get authenticationSuccessful => 'Autenticazione riuscita!';

  @override
  String get incorrectRecoveryKey => 'Chiave di recupero errata';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'La chiave di recupero inserita non è corretta';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Autenticazione a due fattori resettata con successo';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Verifica il codice che hai inserito';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Riprova. Se il problema persiste, ti invitiamo a contattare l\'assistenza';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'L\'autenticazione a due fattori è stata disabilitata';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Il codice immesso non è corretto';

  @override
  String get yourVerificationCodeHasExpired =>
      'Il tuo codice di verifica è scaduto';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Email cambiata in $newEmail';
  }

  @override
  String get verifying => 'Verifica in corso...';

  @override
  String get disablingTwofactorAuthentication =>
      'Disattivazione autenticazione a due fattori...';

  @override
  String get allMemoriesPreserved => 'Tutti i ricordi conservati';

  @override
  String get loadingGallery => 'Caricamento galleria...';

  @override
  String get syncing => 'Sincronizzazione in corso...';

  @override
  String get encryptingBackup => 'Crittografando il backup...';

  @override
  String get syncStopped => 'Sincronizzazione interrotta';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total ricordi conservati';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Conservando $count ricordi...';
  }

  @override
  String get uploadingSingleMemory => 'Conservando 1 ricordo...';

  @override
  String get archiving => 'Archiviazione...';

  @override
  String get unarchiving => 'Togliendo dall\'archivio...';

  @override
  String get successfullyArchived => 'Archiviato correttamente';

  @override
  String get successfullyUnarchived => 'Rimosso dall\'archivio correttamente';

  @override
  String get renameFile => 'Rinomina file';

  @override
  String get enterFileName => 'Inserisci un nome per il file';

  @override
  String get filesDeleted => 'File eliminati';

  @override
  String get selectedFilesAreNotOnEnte => 'I file selezionati non sono su Ente';

  @override
  String get thisActionCannotBeUndone =>
      'Questa azione non può essere annullata';

  @override
  String get emptyTrash => 'Vuoi svuotare il cestino?';

  @override
  String get permDeleteWarning =>
      'Tutti gli elementi nel cestino verranno eliminati definitivamente\n\nQuesta azione non può essere annullata';

  @override
  String get empty => 'Svuota';

  @override
  String get couldNotFreeUpSpace => 'Impossibile liberare lo spazio';

  @override
  String get permanentlyDeleteFromDevice =>
      'Eliminare definitivamente dal dispositivo?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Alcuni dei file che si sta tentando di eliminare sono disponibili solo sul dispositivo e non possono essere recuperati se cancellati';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Verranno eliminati da tutti gli album.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Alcuni elementi sono sia su Ente che sul tuo dispositivo.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Gli elementi selezionati verranno eliminati da tutti gli album e spostati nel cestino.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Questi file verranno eliminati dal tuo dispositivo.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Sembra che qualcosa sia andato storto. Riprova tra un po\'. Se l\'errore persiste, contatta il nostro team di supporto.';

  @override
  String get error => 'Errore';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Sembra che qualcosa sia andato storto. Riprova tra un po\'. Se l\'errore persiste, contatta il nostro team di supporto.';

  @override
  String get networkHostLookUpErr =>
      'Impossibile connettersi a Ente, controlla le impostazioni di rete e contatta l\'assistenza se l\'errore persiste.';

  @override
  String get networkConnectionRefusedErr =>
      'Impossibile connettersi a Ente, riprova tra un po\' di tempo. Se l\'errore persiste, contatta l\'assistenza.';

  @override
  String get cachedData => 'Dati nella cache';

  @override
  String get clearCaches => 'Svuota cache';

  @override
  String get remoteImages => 'Immagini remote';

  @override
  String get remoteVideos => 'Video remoti';

  @override
  String get remoteThumbnails => 'Miniature remote';

  @override
  String get pendingSync => 'Sincronizzazione in sospeso';

  @override
  String get localGallery => 'Galleria locale';

  @override
  String get todaysLogs => 'Log di oggi';

  @override
  String get viewLogs => 'Visualizza i log';

  @override
  String get logsDialogBody =>
      'Invia i log per aiutarci a risolvere il tuo problema. Si prega di notare che i nomi dei file saranno inclusi per aiutare a tenere traccia di problemi con file specifici.';

  @override
  String get preparingLogs => 'Preparando i log...';

  @override
  String get emailYourLogs => 'Invia una mail con i tuoi log';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Invia i log a \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copia indirizzo email';

  @override
  String get exportLogs => 'Esporta log';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Per favore invia un\'email a $toEmail';
  }

  @override
  String get dismiss => 'Ignora';

  @override
  String get didYouKnow => 'Lo sapevi che?';

  @override
  String get loadingMessage => 'Caricando le tue foto...';

  @override
  String get loadMessage1 =>
      'Puoi condividere il tuo abbonamento con la tua famiglia';

  @override
  String get loadMessage2 =>
      'Finora abbiamo conservato oltre 200 milioni di ricordi';

  @override
  String get loadMessage3 =>
      'Teniamo 3 copie dei tuoi dati, uno in un rifugio sotterraneo antiatomico';

  @override
  String get loadMessage4 => 'Tutte le nostre app sono open source';

  @override
  String get loadMessage5 =>
      'Il nostro codice sorgente e la crittografia hanno ricevuto audit esterni';

  @override
  String get loadMessage6 =>
      'Puoi condividere i link ai tuoi album con i tuoi cari';

  @override
  String get loadMessage7 =>
      'Le nostre app per smartphone vengono eseguite in background per crittografare e eseguire il backup di qualsiasi nuova foto o video';

  @override
  String get loadMessage8 => 'web.ente.io ha un uploader intuitivo';

  @override
  String get loadMessage9 =>
      'Usiamo Xchacha20Poly1305 per crittografare in modo sicuro i tuoi dati';

  @override
  String get photoDescriptions => 'Descrizioni delle foto';

  @override
  String get fileTypesAndNames => 'Tipi e nomi di file';

  @override
  String get location => 'Luogo';

  @override
  String get moments => 'Momenti';

  @override
  String get searchFaceEmptySection =>
      'Le persone saranno mostrate qui una volta completata l\'indicizzazione';

  @override
  String get searchDatesEmptySection => 'Ricerca per data, mese o anno';

  @override
  String get searchLocationEmptySection =>
      'Raggruppa foto scattate entro un certo raggio da una foto';

  @override
  String get searchPeopleEmptySection =>
      'Invita persone e vedrai qui tutte le foto condivise da loro';

  @override
  String get searchAlbumsEmptySection => 'Album';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Tipi e nomi di file';

  @override
  String get searchCaptionEmptySection =>
      'Aggiungi descrizioni come \"#viaggio\" nelle informazioni delle foto per trovarle rapidamente qui';

  @override
  String get language => 'Lingua';

  @override
  String get selectLanguage => 'Seleziona una lingua';

  @override
  String get locationName => 'Nome della località';

  @override
  String get addLocation => 'Aggiungi luogo';

  @override
  String get groupNearbyPhotos => 'Raggruppa foto nelle vicinanze';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Aggiungi';

  @override
  String get radius => 'Raggio';

  @override
  String get locationTagFeatureDescription =>
      'Un tag di localizzazione raggruppa tutte le foto scattate entro il raggio di una foto';

  @override
  String get galleryMemoryLimitInfo =>
      'Fino a 1000 ricordi mostrati nella galleria';

  @override
  String get save => 'Salva';

  @override
  String get centerPoint => 'Punto centrale';

  @override
  String get pickCenterPoint => 'Selezionare il punto centrale';

  @override
  String get useSelectedPhoto => 'Usa la foto selezionata';

  @override
  String get resetToDefault => 'Ripristina predefinita';

  @override
  String get edit => 'Modifica';

  @override
  String get deleteLocation => 'Elimina posizione';

  @override
  String get rotateLeft => 'Ruota a sinistra';

  @override
  String get flip => 'Capovolgi';

  @override
  String get rotateRight => 'Ruota a destra';

  @override
  String get saveCopy => 'Salva una copia';

  @override
  String get light => 'Chiaro';

  @override
  String get color => 'Colore';

  @override
  String get yesDiscardChanges => 'Sì, ignora le mie modifiche';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Vuoi scartare le modifiche che hai fatto?';

  @override
  String get saving => 'Salvataggio...';

  @override
  String get editsSaved => 'Modifiche salvate';

  @override
  String get oopsCouldNotSaveEdits => 'Ops, impossibile salvare le modifiche';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Oggi';

  @override
  String get dayYesterday => 'Ieri';

  @override
  String get storage => 'Spazio di archiviazione';

  @override
  String get usedSpace => 'Spazio utilizzato';

  @override
  String get storageBreakupFamily => 'Famiglia';

  @override
  String get storageBreakupYou => 'Tu';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit di $totalAmount $totalStorageUnit utilizzati';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit liberi';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versione: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verifica';

  @override
  String get fileInfoAddDescHint => 'Aggiungi descrizione...';

  @override
  String get editLocationTagTitle => 'Modifica luogo';

  @override
  String get setLabel => 'Imposta';

  @override
  String get setRadius => 'Imposta raggio';

  @override
  String get familyPlanPortalTitle => 'Famiglia';

  @override
  String get familyPlanOverview =>
      'Aggiungi 5 membri della famiglia al tuo piano esistente senza pagare extra.\n\nOgni membro ottiene il proprio spazio privato e non può vedere i file dell\'altro a meno che non siano condivisi.\n\nI piani familiari sono disponibili per i clienti che hanno un abbonamento Ente a pagamento.\n\nIscriviti ora per iniziare!';

  @override
  String get androidBiometricHint => 'Verifica l\'identità';

  @override
  String get androidBiometricNotRecognized => 'Non riconosciuto. Riprova.';

  @override
  String get androidBiometricSuccess => 'Operazione riuscita';

  @override
  String get androidCancelButton => 'Annulla';

  @override
  String get androidSignInTitle => 'Autenticazione necessaria';

  @override
  String get androidBiometricRequiredTitle => 'Autenticazione biometrica';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Inserisci le credenziali del dispositivo';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Inserisci le credenziali del dispositivo';

  @override
  String get goToSettings => 'Vai alle impostazioni';

  @override
  String get androidGoToSettingsDescription =>
      'L\'autenticazione biometrica non è impostata sul tuo dispositivo. Vai a \'Impostazioni > Sicurezza\' per impostarla.';

  @override
  String get iOSLockOut =>
      'L\'autenticazione biometrica è disabilitata. Blocca e sblocca lo schermo per abilitarla.';

  @override
  String get iOSGoToSettingsDescription =>
      'L\'autenticazione biometrica non è impostata sul tuo dispositivo. Abilita Touch ID o Face ID sul tuo telefono.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Collaboratori di OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Ospitato presso OSM France';

  @override
  String get map => 'Mappa';

  @override
  String get maps => 'Mappe';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Abilita le Mappe';

  @override
  String get quickLinks => 'Collegamenti rapidi';

  @override
  String get selectItemsToAdd => 'Seleziona gli elementi da aggiungere';

  @override
  String get addSelected => 'Aggiungi selezionate';

  @override
  String get addFromDevice => 'Aggiungi dal dispositivo';

  @override
  String get addPhotos => 'Aggiungi foto';

  @override
  String get noPhotosFoundHere => 'Nessuna foto trovata';

  @override
  String get zoomOutToSeePhotos => 'Zoom indietro per visualizzare le foto';

  @override
  String get noImagesWithLocation => 'Nessuna immagine con posizione';

  @override
  String get unpinAlbum => 'Non fissare album';

  @override
  String get pinAlbum => 'Fissa l\'album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Crea';

  @override
  String get viewAll => 'Visualizza tutte';

  @override
  String get nothingSharedWithYouYet => 'Ancora nulla di condiviso con te';

  @override
  String get noAlbumsSharedByYouYet => 'Ancora nessun album condiviso da te';

  @override
  String get sharedWithYou => 'Condivise con te';

  @override
  String get sharedByYou => 'Condivise da te';

  @override
  String get inviteYourFriendsToEnte => 'Invita i tuoi amici a Ente';

  @override
  String get failedToDownloadVideo => 'Download del video non riuscito';

  @override
  String get hiding => 'Nascondendo...';

  @override
  String get unhiding => 'Rivelando...';

  @override
  String get successfullyHid => 'Nascosta con successo';

  @override
  String get successfullyUnhid => 'Rimossa dal nascondiglio con successo';

  @override
  String get crashReporting => 'Segnalazione di crash';

  @override
  String get resumableUploads => 'Caricamenti riattivabili';

  @override
  String get addToHiddenAlbum => 'Aggiungi ad album nascosto';

  @override
  String get moveToHiddenAlbum => 'Sposta in album nascosto';

  @override
  String get fileTypes => 'Tipi di file';

  @override
  String get deleteConfirmDialogBody =>
      'Questo account è collegato ad altre app di Ente, se ne utilizzi. I tuoi dati caricati, su tutte le app di Ente, saranno pianificati per la cancellazione e il tuo account verrà eliminato definitivamente.';

  @override
  String get hearUsWhereTitle =>
      'Come hai sentito parlare di Ente? (opzionale)';

  @override
  String get hearUsExplanation =>
      'Non teniamo traccia del numero di installazioni dell\'app. Sarebbe utile se ci dicesse dove ci ha trovato!';

  @override
  String get viewAddOnButton => 'Visualizza componenti aggiuntivi';

  @override
  String get addOns => 'Componenti aggiuntivi';

  @override
  String get addOnPageSubtitle => 'Dettagli dei componenti aggiuntivi';

  @override
  String get yourMap => 'La tua mappa';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modifica la tua ricerca o prova con';

  @override
  String get blackFridaySale => 'Offerta del Black Friday';

  @override
  String get upto50OffUntil4thDec => 'Sconto del 50%, fino al 4 dicembre.';

  @override
  String get photos => 'Foto';

  @override
  String get videos => 'Video';

  @override
  String get livePhotos => 'Live Photo';

  @override
  String get searchHint1 => 'Ricerca rapida sul dispositivo';

  @override
  String get searchHint2 => 'Date delle foto, descrizioni';

  @override
  String get searchHint3 => 'Album, nomi di file e tipi';

  @override
  String get searchHint4 => 'Luogo';

  @override
  String get searchHint5 => 'In arrivo: Facce & ricerca magica ✨';

  @override
  String get addYourPhotosNow => 'Aggiungi le tue foto ora';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count risultati trovati',
      one: '$count risultato trovato',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Volti';

  @override
  String get people => 'Persone';

  @override
  String get contents => 'Contenuti';

  @override
  String get addNew => 'Aggiungi nuovo';

  @override
  String get contacts => 'Contatti';

  @override
  String get noInternetConnection => 'Nessuna connessione internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Si prega di verificare la propria connessione Internet e riprovare.';

  @override
  String get signOutFromOtherDevices => 'Esci dagli altri dispositivi';

  @override
  String get signOutOtherBody =>
      'Se pensi che qualcuno possa conoscere la tua password, puoi forzare tutti gli altri dispositivi che usano il tuo account ad uscire.';

  @override
  String get signOutOtherDevices => 'Esci dagli altri dispositivi';

  @override
  String get doNotSignOut => 'Non uscire';

  @override
  String get editLocation => 'Modifica luogo';

  @override
  String get selectALocation => 'Seleziona un luogo';

  @override
  String get selectALocationFirst => 'Scegli prima una posizione';

  @override
  String get changeLocationOfSelectedItems =>
      'Cambiare la posizione degli elementi selezionati?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Le modifiche alla posizione saranno visibili solo all\'interno di Ente';

  @override
  String get cleanUncategorized => 'Pulisci Senza Categoria';

  @override
  String get cleanUncategorizedDescription =>
      'Rimuovi tutti i file da Senza Categoria che sono presenti in altri album';

  @override
  String get waitingForVerification => 'In attesa di verifica...';

  @override
  String get passkey => 'Passkey';

  @override
  String get passkeyAuthTitle => 'Verifica della passkey';

  @override
  String get loginWithTOTP => 'Login con TOTP';

  @override
  String get passKeyPendingVerification => 'La verifica è ancora in corso';

  @override
  String get loginSessionExpired => 'Sessione scaduta';

  @override
  String get loginSessionExpiredDetails =>
      'La sessione è scaduta. Si prega di accedere nuovamente.';

  @override
  String get verifyPasskey => 'Verifica passkey';

  @override
  String get playOnTv => 'Riproduci album sulla TV';

  @override
  String get pair => 'Abbina';

  @override
  String get deviceNotFound => 'Dispositivo non trovato';

  @override
  String get castInstruction =>
      'Visita cast.ente.io sul dispositivo che vuoi abbinare.\n\nInserisci il codice qui sotto per riprodurre l\'album sulla tua TV.';

  @override
  String get deviceCodeHint => 'Inserisci il codice';

  @override
  String get joinDiscord => 'Unisciti a Discord';

  @override
  String get locations => 'Luoghi';

  @override
  String get addAName => 'Aggiungi un nome';

  @override
  String get findThemQuickly => 'Trovali rapidamente';

  @override
  String get findPeopleByName => 'Trova rapidamente le persone per nome';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Aggiungi visualizzatori',
      one: 'Add viewer',
      zero: 'Aggiungi visualizzatore',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Aggiungi collaboratori',
      one: 'Aggiungi collaboratore',
      zero: 'Aggiungi collaboratore',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Premi a lungo un\'email per verificare la crittografia end to end.';

  @override
  String get developerSettingsWarning =>
      'Sei sicuro di voler modificare le Impostazioni sviluppatore?';

  @override
  String get developerSettings => 'Impostazioni sviluppatore';

  @override
  String get serverEndpoint => 'Endpoint del server';

  @override
  String get invalidEndpoint => 'Endpoint invalido';

  @override
  String get invalidEndpointMessage =>
      'Spiacenti, l\'endpoint inserito non è valido. Inserisci un endpoint valido e riprova.';

  @override
  String get endpointUpdatedMessage => 'Endpoint aggiornato con successo';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Connesso a $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Crea link collaborativo';

  @override
  String get search => 'Cerca';

  @override
  String get enterPersonName => 'Inserisci il nome della persona';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Questa email è già collegata a $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Visualizza $name per scollegare';
  }

  @override
  String get enterName => 'Aggiungi nome';

  @override
  String get savePerson => 'Salva persona';

  @override
  String get editPerson => 'Modifica persona';

  @override
  String get mergedPhotos => 'Fotografie unite';

  @override
  String get orMergeWithExistingPerson => 'O unisci con esistente';

  @override
  String get enterDateOfBirth => 'Compleanno (Opzionale)';

  @override
  String get birthday => 'Compleanno';

  @override
  String get removePersonLabel => 'Rimuovi etichetta persona';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'L\'associazione automatica funziona solo con i dispositivi che supportano Chromecast.';

  @override
  String get manualPairDesc =>
      'L\'associazione con PIN funziona con qualsiasi schermo dove desideri visualizzare il tuo album.';

  @override
  String get connectToDevice => 'Connetti al dispositivo';

  @override
  String get autoCastDialogBody =>
      'Qui vedrai i dispositivi disponibili per la trasmissione.';

  @override
  String get autoCastiOSPermission =>
      'Assicurarsi che le autorizzazioni della rete locale siano attivate per l\'app Ente Photos nelle Impostazioni.';

  @override
  String get noDeviceFound => 'Nessun dispositivo trovato';

  @override
  String get stopCastingTitle => 'Interrompi la trasmissione';

  @override
  String get stopCastingBody => 'Vuoi interrompere la trasmissione?';

  @override
  String get castIPMismatchTitle => 'Errore nel trasmettere l\'album';

  @override
  String get castIPMismatchBody =>
      'Assicurati di essere sulla stessa rete della TV.';

  @override
  String get pairingComplete => 'Associazione completata';

  @override
  String get savingEdits => 'Salvataggio modifiche...';

  @override
  String get autoPair => 'Associazione automatica';

  @override
  String get pairWithPin => 'Associa con PIN';

  @override
  String get faceRecognition => 'Riconoscimento facciale';

  @override
  String get foundFaces => 'Volti trovati';

  @override
  String get clusteringProgress => 'Progresso del raggruppamento';

  @override
  String get trim => 'Taglia';

  @override
  String get crop => 'Ritaglia';

  @override
  String get rotate => 'Ruota';

  @override
  String get left => 'Sinistra';

  @override
  String get right => 'Destra';

  @override
  String get whatsNew => 'Novità';

  @override
  String get reviewSuggestions => 'Esamina i suggerimenti';

  @override
  String get review => 'Revisiona';

  @override
  String get useAsCover => 'Usa come copertina';

  @override
  String notPersonLabel({required String name}) {
    return 'Non è $name?';
  }

  @override
  String get enable => 'Abilita';

  @override
  String get enabled => 'Abilitato';

  @override
  String get moreDetails => 'Più dettagli';

  @override
  String get enableMLIndexingDesc =>
      'Ente supporta l\'apprendimento automatico eseguito sul dispositivo per il riconoscimento dei volti, la ricerca magica e altre funzioni di ricerca avanzata';

  @override
  String get magicSearchHint =>
      'La ricerca magica ti permette di cercare le foto in base al loro contenuto, ad esempio \'fiore\', \'auto rossa\', \'documenti d\'identità\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Reinserisci la password';

  @override
  String get reenterPin => 'Reinserisci il PIN';

  @override
  String get deviceLock => 'Blocco del dispositivo';

  @override
  String get pinLock => 'Blocco con PIN';

  @override
  String get next => 'Successivo';

  @override
  String get setNewPassword => 'Imposta una nuova password';

  @override
  String get enterPin => 'Inserisci PIN';

  @override
  String get setNewPin => 'Imposta un nuovo PIN';

  @override
  String get appLock => 'Blocco app';

  @override
  String get noSystemLockFound => 'Nessun blocco di sistema trovato';

  @override
  String get tapToUnlock => 'Tocca per sbloccare';

  @override
  String get tooManyIncorrectAttempts => 'Troppi tentativi errati';

  @override
  String get videoInfo => 'Informazioni video';

  @override
  String get autoLock => 'Blocco automatico';

  @override
  String get immediately => 'Immediatamente';

  @override
  String get autoLockFeatureDescription =>
      'Tempo dopo il quale l\'applicazione si blocca dopo essere stata messa in background';

  @override
  String get hideContent => 'Nascondi il contenuto';

  @override
  String get hideContentDescriptionAndroid =>
      'Nasconde il contenuto nel selettore delle app e disabilita gli screenshot';

  @override
  String get hideContentDescriptionIos =>
      'Nasconde il contenuto nel selettore delle app';

  @override
  String get passwordStrengthInfo =>
      'La sicurezza della password viene calcolata considerando la lunghezza della password, i caratteri usati e se la password appare o meno nelle prime 10.000 password più usate';

  @override
  String get noQuickLinksSelected => 'Nessun link rapido selezionato';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Si prega di selezionare i link rapidi da rimuovere';

  @override
  String get removePublicLinks => 'Rimuovi i link pubblici';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Questo rimuoverà i link pubblici di tutti i link rapidi selezionati.';

  @override
  String get guestView => 'Vista ospite';

  @override
  String get guestViewEnablePreSteps =>
      'Per abilitare la vista ospite, configura il codice di accesso del dispositivo o il blocco schermo nelle impostazioni di sistema.';

  @override
  String get nameTheAlbum => 'Dai un nome all\'album';

  @override
  String get collectPhotosDescription =>
      'Crea un link dove i tuoi amici possono caricare le foto in qualità originale.';

  @override
  String get collect => 'Raccogli';

  @override
  String get appLockDescriptions =>
      'Scegli tra la schermata di blocco predefinita del dispositivo e una schermata di blocco personalizzata con PIN o password.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Per abilitare il blocco dell\'app, configura il codice di accesso del dispositivo o il blocco schermo nelle impostazioni di sistema.';

  @override
  String get authToViewPasskey => 'Autenticati per visualizzare le tue passkey';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Sembra che qualcosa sia andato storto dal momento che la sincronizzazione delle foto locali richiede più tempo del previsto. Si prega di contattare il nostro team di supporto';

  @override
  String get showPerson => 'Mostra persona';

  @override
  String get sort => 'Ordina';

  @override
  String get mostRecent => 'Più recenti';

  @override
  String get mostRelevant => 'Più rilevanti';

  @override
  String get loadingYourPhotos => 'Caricando le tue foto...';

  @override
  String processingImport({required Object folderName}) {
    return 'Elaborando $folderName...';
  }

  @override
  String get personName => 'Nome della persona';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Aggiungi nuova persona';

  @override
  String get addNameOrMerge => 'Aggiungi nome o unisci';

  @override
  String get mergeWithExisting => 'Unisci con esistente';

  @override
  String get newPerson => 'Nuova persona';

  @override
  String get addName => 'Aggiungi nome';

  @override
  String get add => 'Aggiungi';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Trovate foto aggiuntive per $text';
  }

  @override
  String get extraPhotosFound => 'Trovate foto aggiuntive';

  @override
  String get configuration => 'Configurazione';

  @override
  String get localIndexing => 'Indicizzazione locale';

  @override
  String get processed => 'Processato';

  @override
  String get resetPerson => 'Rimuovi';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Sei sicuro di voler resettare questa persona?';

  @override
  String get allPersonGroupingWillReset =>
      'Tutti i raggruppamenti per questa persona saranno resettati e perderai tutti i suggerimenti fatti per questa persona';

  @override
  String get yesResetPerson => 'Sì, resetta persona';

  @override
  String get onlyThem => 'Solo loro';

  @override
  String get checkingModels => 'Verifica dei modelli...';

  @override
  String get enableMachineLearningBanner =>
      'Abilita l\'apprendimento automatico per la ricerca magica e il riconoscimento facciale';

  @override
  String get searchDiscoverEmptySection =>
      'Le immagini saranno mostrate qui una volta che l\'elaborazione e la sincronizzazione saranno completate';

  @override
  String get searchPersonsEmptySection =>
      'Le persone saranno mostrate qui una volta che l\'elaborazione e la sincronizzazione saranno completate';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count visualizzatori',
      one: 'Added 1 visualizzatore',
      zero: 'Added 0 visualizzatori',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Aggiunti $count collaboratori',
      one: 'Aggiunto 1 collaboratore',
      zero: 'Aggiunti 0 collaboratori',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'L\'account è già configurato.';

  @override
  String get sessionIdMismatch => 'ID sessione non corrispondente';

  @override
  String get failedToFetchActiveSessions =>
      'Recupero delle sessioni attive non riuscito';

  @override
  String get failedToRefreshStripeSubscription =>
      'Impossibile aggiornare l\'abbonamento';

  @override
  String get failedToPlayVideo => 'Impossibile riprodurre il video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Il caricamento è ignorato a causa di $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Il tipo di galleria $galleryType non è supportato per la rinomina';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Tocca per caricare, il caricamento è attualmente ignorato a causa di $ignoreReason';
  }

  @override
  String get tapToUpload => 'Premi per caricare';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Aggiungi File';

  @override
  String get castAlbum => 'Trasmetti album';

  @override
  String get imageNotAnalyzed => 'Immagine non analizzata';

  @override
  String get noFacesFound => 'Nessun volto trovato';

  @override
  String get fileNotUploadedYet => 'File non ancora caricato';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Nessun suggerimento per $personName';
  }

  @override
  String get month => 'mese';

  @override
  String get yearShort => 'anno';

  @override
  String get currentlyRunning => 'attualmente in esecuzione';

  @override
  String get ignored => 'ignorato';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count foto',
      one: '1 foto',
      zero: '0 foto',
    );
    return '$_temp0';
  }

  @override
  String get file => 'File';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Lunghezza sezioni non corrisponde: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Seleziona app email';

  @override
  String get selectAllShort => 'Tutte';

  @override
  String get selectCoverPhoto => 'Seleziona foto di copertina';

  @override
  String get newLocation => 'Nuova posizione';

  @override
  String get faceNotClusteredYet =>
      'Faccia non ancora raggruppata, per favore torna più tardi';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Il link a cui stai cercando di accedere è scaduto.';

  @override
  String get openFile => 'Apri file';

  @override
  String get backupFile => 'File di backup';

  @override
  String get openAlbumInBrowser => 'Apri album nel browser';

  @override
  String get openAlbumInBrowserTitle =>
      'Utilizza l\'app web per aggiungere foto a questo album';

  @override
  String get allow => 'Consenti';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Consenti all\'app di aprire link all\'album condiviso';

  @override
  String get seePublicAlbumLinksInApp => 'Vedi link album pubblici nell\'app';

  @override
  String get emergencyContacts => 'Contatti di emergenza';

  @override
  String get acceptTrustInvite => 'Accetta l\'invito';

  @override
  String get declineTrustInvite => 'Rifiuta l\'invito';

  @override
  String get removeYourselfAsTrustedContact =>
      'Rimuovi te stesso come contatto fidato';

  @override
  String get legacy => 'Legacy';

  @override
  String get legacyPageDesc =>
      'Legacy consente ai contatti fidati di accedere al tuo account in tua assenza.';

  @override
  String get legacyPageDesc2 =>
      'I contatti fidati possono avviare il recupero dell\'account e, se non sono bloccati entro 30 giorni, reimpostare la password e accedere al tuo account.';

  @override
  String get legacyAccounts => 'Account Legacy';

  @override
  String get trustedContacts => 'Contatti fidati';

  @override
  String get addTrustedContact => 'Aggiungi contatto fidato';

  @override
  String get removeInvite => 'Rimuovi invito';

  @override
  String get recoveryWarning =>
      'Un contatto fidato sta tentando di accedere al tuo account';

  @override
  String get rejectRecovery => 'Rifiuta il recupero';

  @override
  String get recoveryInitiated => 'Recupero avviato';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Puoi accedere all\'account dopo $days giorni. Una notifica verrà inviata a $email.';
  }

  @override
  String get cancelAccountRecovery => 'Annulla il recupero';

  @override
  String get recoveryAccount => 'Recupera l\'account';

  @override
  String get cancelAccountRecoveryBody =>
      'Sei sicuro di voler annullare il recupero?';

  @override
  String get startAccountRecoveryTitle => 'Avvia il recupero';

  @override
  String get whyAddTrustContact =>
      'Un contatto fidato può aiutare a recuperare i tuoi dati.';

  @override
  String recoveryReady({required String email}) {
    return 'Ora puoi recuperare l\'account di $email impostando una nuova password.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email sta cercando di recuperare il tuo account.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Sei stato invitato a essere un contatto Legacy da $email.';
  }

  @override
  String get warning => 'Attenzione';

  @override
  String get proceed => 'Prosegui';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Stai per aggiungere $email come contatto fidato. Potranno recuperare il tuo account se sei assente per $numOfDays giorni.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email ti ha invitato a essere un contatto fidato';
  }

  @override
  String get authToManageLegacy =>
      'Autenticati per gestire i tuoi contatti fidati';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Nascondi gli elementi condivisi dalla galleria principale';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galleria';

  @override
  String get joinAlbum => 'Unisciti all\'album';

  @override
  String get joinAlbumSubtext => 'per visualizzare e aggiungere le tue foto';

  @override
  String get joinAlbumSubtextViewer => 'per aggiungerla agli album condivisi';

  @override
  String get join => 'Unisciti';

  @override
  String get linkEmail => 'Link Email';

  @override
  String get link => 'Link';

  @override
  String get noEnteAccountExclamation => 'Nessun account Ente!';

  @override
  String get orPickFromYourContacts => 'o scegli tra i tuoi contatti';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email non ha un account Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Io)';
  }

  @override
  String get reassignMe => 'Riassegna \"Io\"';

  @override
  String get me => 'Io';

  @override
  String get linkEmailToContactBannerCaption =>
      'per una condivisione più veloce';

  @override
  String get selectPersonToLink => 'Seleziona persona da collegare';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Collega persona a $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Questo collegherà $personName a $email';
  }

  @override
  String get selectYourFace => 'Seleziona il tuo volto';

  @override
  String get reassigningLoading => 'Riassegnando...';

  @override
  String reassignedToName({required String name}) {
    return 'Riassegnato a $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Salvare le modifiche prima di uscire?';

  @override
  String get dontSave => 'Non salvare';

  @override
  String get thisIsMeExclamation => 'Questo sono io!';

  @override
  String get linkPerson => 'Collega persona';

  @override
  String get linkPersonCaption => 'per una migliore esperienza di condivisione';

  @override
  String get videoStreaming => 'Video in streaming';

  @override
  String get processingVideos => 'Elaborando video';

  @override
  String get streamDetails => 'Dettagli dello streaming';

  @override
  String get processing => 'In elaborazione';

  @override
  String get queued => 'In coda';

  @override
  String get ineligible => 'Non idoneo';

  @override
  String get failed => 'Non riuscito';

  @override
  String get playStream => 'Riproduci lo streaming';

  @override
  String get playOriginal => 'Riproduci originale';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Unirsi a un album renderà visibile la tua email ai suoi partecipanti.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Attendere, potrebbe volerci un po\' di tempo.';

  @override
  String get editTime => 'Modifica orario';

  @override
  String get selectTime => 'Imposta ora';

  @override
  String get selectDate => 'Imposta data';

  @override
  String get previous => 'Precedente';

  @override
  String get selectOneDateAndTimeForAll =>
      'Seleziona una data e un\'ora per tutti';

  @override
  String get selectStartOfRange => 'Seleziona inizio dell\'intervallo';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'In questo modo la data e l\'ora di tutte le foto selezionate saranno uguali.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Questo è il primo nel gruppo. Altre foto selezionate si sposteranno automaticamente in base a questa nuova data';

  @override
  String get newRange => 'Nuovo intervallo';

  @override
  String get selectOneDateAndTime => 'Seleziona data e orario';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Sposta foto selezionate in una data specifica';

  @override
  String get shiftDatesAndTime => 'Sposta date e orari';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Le foto mantengono una differenza di tempo relativa';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count foto',
      one: '1 foto',
      zero: 'Nessuna foto',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Icona dell\'app';

  @override
  String get notThisPerson => 'Non è questa persona?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Gli elementi selezionati verranno rimossi da questa persona, ma non eliminati dalla tua libreria.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat negli anni';
  }

  @override
  String get thisWeekThroughTheYears => 'Questa settimana negli anni';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Questa settimana, $count anni fa',
      one: 'Questa settimana, $count anno fa',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Tu e $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Ammirando $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Abbracciando $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Festa con $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Escursioni con $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Festeggiando con $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfie con $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'In posa con $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Bellissimi panorami con $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sport con $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Viaggio con $name';
  }

  @override
  String get spotlightOnYourself => 'Tu in primo piano';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Riflettori su $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name ha $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name sta per compiere $age anni';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Ultima volta con $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Viaggio a $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Viaggio nel $year';
  }

  @override
  String get lastYearsTrip => 'Viaggio dello scorso anno';

  @override
  String get sunrise => 'All\'orizzonte';

  @override
  String get mountains => 'Oltre le colline';

  @override
  String get greenery => 'In mezzo al verde';

  @override
  String get beach => 'Sabbia e mare';

  @override
  String get city => 'In città';

  @override
  String get moon => 'Al chiaro di luna';

  @override
  String get onTheRoad => 'Un altro viaggio su strada';

  @override
  String get food => 'Delizia culinaria';

  @override
  String get pets => 'Compagni pelosetti';

  @override
  String get curatedMemories => 'Ricordi importanti';

  @override
  String get widgets => 'Widget';

  @override
  String get memories => 'Ricordi';

  @override
  String get peopleWidgetDesc =>
      'Seleziona le persone che desideri vedere nella schermata principale.';

  @override
  String get albumsWidgetDesc =>
      'Seleziona gli album che desideri vedere nella schermata principale.';

  @override
  String get memoriesWidgetDesc =>
      'Seleziona il tipo di ricordi che desideri vedere nella schermata principale.';

  @override
  String get smartMemories => 'Ricordi intelligenti';

  @override
  String get pastYearsMemories => 'Ricordi degli ultimi anni';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Eliminare anche le foto (e i video) presenti su $count album da <bold>tutti</bold> gli altri album di cui fanno parte?';
  }

  @override
  String get addParticipants => 'Aggiungi Partecipanti';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selezionati';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Questa azione non è supportata nei Preferiti';

  @override
  String get onThisDayMemories => 'Ricordi di questo giorno';

  @override
  String get onThisDay => 'In questo giorno';

  @override
  String get lookBackOnYourMemories => 'Rivivi i tuoi ricordi 🌄';

  @override
  String get newPhotosEmoji => ' nuova 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Spiacenti, abbiamo dovuto mettere in pausa i backup';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Clicca per installare l\'ultima versione dell\'app';

  @override
  String get onThisDayNotificationExplanation =>
      'Ricevi promemoria sui ricordi da questo giorno negli anni precedenti.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Aggiungi un widget dei ricordi nella schermata iniziale e torna qui per personalizzarlo.';

  @override
  String get addAlbumWidgetPrompt =>
      'Aggiungi un widget per gli album nella schermata iniziale e torna qui per personalizzarlo.';

  @override
  String get addPeopleWidgetPrompt =>
      'Aggiungi un widget delle persone nella schermata iniziale e torna qui per personalizzarlo.';

  @override
  String get birthdayNotifications => 'Notifiche dei compleanni';

  @override
  String get receiveRemindersOnBirthdays =>
      'Ricevi promemoria quando è il compleanno di qualcuno. Toccare la notifica ti porterà alle foto della persona che compie gli anni.';

  @override
  String get happyBirthday => 'Buon compleanno! 🥳';

  @override
  String get birthdays => 'Compleanni';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Auguri ad $name un buon compleanno! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Sei sicuro di voler rimuovere questo volto da questa persona?';

  @override
  String get otherDetectedFaces => 'Altre facce rilevate';

  @override
  String get areThey => 'Sono loro ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Salva come un\'altra persona';

  @override
  String get showLessFaces => 'Mostra meno facce';

  @override
  String get showMoreFaces => 'Mostra altre facce';

  @override
  String get ignore => 'Ignora';

  @override
  String get merge => 'Unisci';

  @override
  String get reset => 'Reimposta';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Sei sicuro di voler resettare questa persona?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Sei sicuro di voler resettare questa persona?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'I gruppi di persone non saranno più visualizzati nella sezione persone. Le foto rimarranno intatte.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'La persona non verrà più visualizzata nella sezione della gente. Le foto rimarranno intatte.';

  @override
  String get areYouSureYouWantToMergeThem => 'Sei sicuro di volerli unire?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Tutti i gruppi senza nome saranno uniti nella persona selezionata. Questo può ancora essere annullato dalla panoramica della cronologia dei suggerimenti della persona.';

  @override
  String get yesIgnore => 'Sì, ignora';

  @override
  String get same => 'Uguale';

  @override
  String get different => 'Diverso';

  @override
  String get sameperson => 'Stessa persona?';

  @override
  String get indexingPausedStatusDescription =>
      'L\'indicizzazione è in pausa. Riprenderà automaticamente quando il dispositivo è pronto. Il dispositivo è considerato pronto quando il suo livello di batteria, la salute della batteria e lo stato termico rientrano in una gamma sana.';

  @override
  String get thisWeek => 'Questa settimana';

  @override
  String get lastWeek => 'Settimana scorsa';

  @override
  String get thisMonth => 'Questo mese';

  @override
  String get thisYear => 'Quest\'anno';

  @override
  String get groupBy => 'Raggruppa per';

  @override
  String get faceThumbnailGenerationFailed =>
      'Impossibile generare le miniature del viso';

  @override
  String get fileAnalysisFailed => 'Impossibile analizzare il file';

  @override
  String get editAutoAddPeople => 'Modifica auto-aggiungi persone';

  @override
  String get autoAddPeople => 'Aggiunta automatica persone';

  @override
  String get autoAddToAlbum => 'Aggiunta automatica all\'album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'I file relativi alla persona che sono stati selezionati in precedenza negli album intelligenti devono essere rimossi?';

  @override
  String get addingPhotos => 'Aggiunta foto';

  @override
  String get gettingReady => 'In preparazione';

  @override
  String get addSomePhotosDesc1 => 'Aggiungi alcune foto o scegli ';

  @override
  String get addSomePhotosDesc2 => 'facce familiari';

  @override
  String get addSomePhotosDesc3 => '\nper iniziare con';

  @override
  String get ignorePerson => 'Ignora persona';

  @override
  String get mixedGrouping => 'Raggruppamento misto?';

  @override
  String get analysis => 'Analisi';

  @override
  String get doesGroupContainMultiplePeople =>
      'Questo raggruppamento contiene più persone?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Analizzeremo automaticamente il raggruppamento per determinare se ci sono più persone presenti, e li separeremo di nuovo. Questo potrebbe richiedere alcuni secondi.';

  @override
  String get layout => 'Disposizione';

  @override
  String get day => 'Giorno';

  @override
  String get undo => 'Annulla';

  @override
  String get redo => 'Ripristina';

  @override
  String get filter => '﻿Filtra';

  @override
  String get adjust => 'Regola';

  @override
  String get draw => 'Traccia';

  @override
  String get sticker => 'Etichetta';

  @override
  String get brushColor => 'Colore pennello';

  @override
  String get font => 'Carattere';

  @override
  String get background => 'Sfondo';

  @override
  String get align => 'Allineamento';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Aggiunto con successo a $count album',
      one: 'Aggiunto con successo a 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Video elaborati';

  @override
  String get totalVideos => 'Totale video';

  @override
  String get skippedVideos => 'Video saltati';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Riproduci video istantaneamente su qualsiasi dispositivo.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Abilita per elaborare flussi video su questo dispositivo.';

  @override
  String get videoStreamingNote =>
      'Solo i video degli ultimi 60 giorni e meno di 1 minuto sono elaborati su questo dispositivo. Per i video più vecchi / più lunghi, abilita lo streaming nell\'app desktop.';

  @override
  String get createStream => 'Crea flusso';

  @override
  String get recreateStream => 'Ricrea stream';

  @override
  String get addedToStreamCreationQueue =>
      'Aggiunta alla coda di creazione dello stream';

  @override
  String get addedToStreamRecreationQueue =>
      'Aggiunta alla coda di creazione dello stream';

  @override
  String get videoPreviewAlreadyExists => 'L\'anteprima video esiste già';

  @override
  String get videoAlreadyInQueue => 'File video già presente nella coda';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Aggiunto alla coda';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Immagini simili';

  @override
  String get findSimilarImages => 'Trova immagini simili';

  @override
  String get noSimilarImagesFound => 'Nessuna immagine simile trovata';

  @override
  String get yourPhotosLookUnique => 'Le tue foto sembrano uniche';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Controlla e rimuovi immagini simili';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Elimina $count foto ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Annulla selezione';

  @override
  String similarImagesCount({required int count}) {
    return '$count immagini simili';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Elimina ($count)';
  }

  @override
  String get deleteFiles => 'Elimina file';

  @override
  String get areYouSureDeleteFiles =>
      'Sei sicuro di voler eliminare questi file?';

  @override
  String get greatJob => 'Ottimo lavoro!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Hai liberato $size di spazio';
  }

  @override
  String get size => 'Dimensione';

  @override
  String get similarity => 'Somiglianza';

  @override
  String get analyzingPhotosLocally => 'Analizzando le tue foto localmente...';

  @override
  String get lookingForVisualSimilarities =>
      'Alla ricerca di somiglianze visive...';

  @override
  String get comparingImageDetails =>
      'Confrontando i dettagli dell\'immagine...';

  @override
  String get findingSimilarImages => 'Cercando immagini simili...';

  @override
  String get almostDone => 'Ci siamo quasi...';

  @override
  String get processingLocally => 'Elaborazione locale';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'Tutti';

  @override
  String get similar => 'Simili';

  @override
  String get identical => 'Identici';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Correlate';

  @override
  String get hoorayyyy => 'Evviva!';

  @override
  String get nothingToTidyUpHere => 'Niente da sistemare qui';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Introduzione ai Rituali';

  @override
  String get cLDesc1 =>
      'Stai pianificando i buoni propositi per il 2026? Con i Rituali, puoi impostare un promemoria su Ente Photos e monitorare i tuoi progressi scattando foto. Usalo per allenamenti, abitudini alimentari, momenti quotidiani con i tuoi cari – qualsiasi cosa tu voglia trasformare in un\'abitudine.';

  @override
  String get cLTitle2 => 'Link pubblici, ora per tutti';

  @override
  String get cLDesc2 =>
      'Tutti gli utenti Ente con piano gratuito possono ora creare e condividere link pubblici a foto e album. Per prevenire abusi, i link avranno limiti sul numero di persone che possono visualizzarli.';

  @override
  String get cLTitle3 => 'Tagga manualmente le persone';

  @override
  String get cLDesc3 =>
      'Ora puoi taggare le persone anche quando la nostra IA sul dispositivo non rileva un volto. Utile per animali domestici, volti parzialmente visibili, o momenti in cui qualcuno non è realmente nella foto ma dovrebbe comunque essere incluso.';

  @override
  String get cLTitle4 => 'E altro ancora';

  @override
  String get cLDesc4 =>
      'Ora puoi fissare gli album condivisi. I link degli album sono visibili a collaboratori e visualizzatori per rendere la condivisione ancora più facile. Abbiamo corretto alcuni bug di scorrimento su iOS e aggiornato la visualizzazione delle foto, inclusa una nuova icona preferiti (facendo spazio per le funzionalità in arrivo).';

  @override
  String get closeBy => 'Vicine';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
