// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Indonesian (`id`).
class AppLocalizationsId extends AppLocalizations {
  AppLocalizationsId([String locale = 'id']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Masukkan alamat email kamu';

  @override
  String get enterYourNewEmailAddress => 'Masukkan alamat email baru anda';

  @override
  String get accountWelcomeBack => 'Selamat datang kembali!';

  @override
  String get emailAlreadyRegistered => 'Email sudah terdaftar.';

  @override
  String get emailNotRegistered => 'Email belum terdaftar.';

  @override
  String get email => 'Email';

  @override
  String get cancel => 'Batal';

  @override
  String get verify => 'Verifikasi';

  @override
  String get invalidEmailAddress => 'Alamat email tidak sah';

  @override
  String get enterValidEmail => 'Harap masukkan alamat email yang sah.';

  @override
  String get deleteAccount => 'Hapus akun';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason => 'Apa alasan utama kamu dalam menghapus akun?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Kami sedih kamu pergi. Silakan bagikan masukanmu agar kami bisa jadi lebih baik.';

  @override
  String get feedback => 'Masukan';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Harap bantu kami dengan informasi ini';

  @override
  String get confirmDeletePrompt =>
      'Ya, saya ingin menghapus akun ini dan seluruh datanya secara permanen di semua aplikasi.';

  @override
  String get confirmAccountDeletion => 'Konfirmasi Penghapusan Akun';

  @override
  String get deleteAccountPermanentlyButton => 'Hapus Akun Secara Permanen';

  @override
  String get yourAccountHasBeenDeleted => 'Akunmu telah dihapus';

  @override
  String get selectReason => 'Pilih alasan';

  @override
  String get deleteReason1 => 'Fitur penting yang saya perlukan tidak ada';

  @override
  String get deleteReason2 =>
      'App ini atau fitur tertentu tidak bekerja sesuai harapan saya';

  @override
  String get deleteReason3 => 'Saya menemukan layanan lain yang lebih baik';

  @override
  String get deleteReason4 => 'Alasan saya tidak ada di daftar';

  @override
  String get sendEmail => 'Kirim email';

  @override
  String get deleteRequestSLAText =>
      'Permintaan kamu akan diproses dalam waktu 72 jam.';

  @override
  String get deleteEmailRequest =>
      'Silakan kirim email ke <warning>account-deletion@ente.io</warning> dari alamat email kamu yang terdaftar.';

  @override
  String get entePhotosPerm =>
      'Ente <i>memerlukan izin untuk</i> menyimpan fotomu';

  @override
  String get ok => 'Oke';

  @override
  String get createAccount => 'Buat akun';

  @override
  String get createNewAccount => 'Buat akun baru';

  @override
  String get password => 'Sandi';

  @override
  String get confirmPassword => 'Konfirmasi sandi';

  @override
  String get activeSessions => 'Sesi aktif';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Aduh';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Terjadi kesalahan, silakan coba lagi';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Ini akan mengeluarkan akunmu dari perangkat ini!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Ini akan mengeluarkan akunmu dari perangkat berikut:';

  @override
  String get terminateSession => 'Akhiri sesi?';

  @override
  String get terminate => 'Akhiri';

  @override
  String get thisDevice => 'Perangkat ini';

  @override
  String get recoverButton => 'Pulihkan';

  @override
  String get recoverySuccessful => 'Pemulihan berhasil!';

  @override
  String get decrypting => 'Mendekripsi...';

  @override
  String get incorrectRecoveryKeyTitle => 'Kunci pemulihan salah';

  @override
  String get incorrectRecoveryKeyBody =>
      'Kunci pemulihan yang kamu masukkan salah';

  @override
  String get forgotPassword => 'Lupa sandi';

  @override
  String get enterYourRecoveryKey => 'Masukkan kunci pemulihan kamu';

  @override
  String get noRecoveryKey => 'Tidak punya kunci pemulihan?';

  @override
  String get sorry => 'Maaf';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Karena sifat protokol enkripsi ujung ke ujung kami, data kamu tidak dapat didekripsi tanpa sandi atau kunci pemulihan kamu';

  @override
  String get verifyEmail => 'Verifikasi email';

  @override
  String get toResetVerifyEmail =>
      'Untuk mengatur ulang sandimu, harap verifikasi email kamu terlebih dahulu.';

  @override
  String get checkInboxAndSpamFolder =>
      'Silakan periksa kotak masuk (serta kotak spam) untuk menyelesaikan verifikasi';

  @override
  String get tapToEnterCode => 'Ketuk untuk masukkan kode';

  @override
  String get resendEmail => 'Kirim ulang email';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Kami telah mengirimkan email ke <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Atur sandi';

  @override
  String get changePasswordTitle => 'Ubah sandi';

  @override
  String get resetPasswordTitle => 'Atur ulang sandi';

  @override
  String get encryptionKeys => 'Kunci enkripsi';

  @override
  String get passwordWarning =>
      'Kami tidak menyimpan sandi ini, jadi jika kamu melupakannya, <underline>kami tidak akan bisa mendekripsi data kamu</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Masukkan sandi yang bisa kami gunakan untuk mengenkripsi data kamu';

  @override
  String get enterNewPasswordToEncrypt =>
      'Masukkan sandi baru yang bisa kami gunakan untuk mengenkripsi data kamu';

  @override
  String get weakStrength => 'Lemah';

  @override
  String get strongStrength => 'Kuat';

  @override
  String get moderateStrength => 'Sedang';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Keamanan sandi: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Sandi berhasil diubah';

  @override
  String get generatingEncryptionKeys => 'Menghasilkan kunci enkripsi...';

  @override
  String get pleaseWait => 'Harap tunggu...';

  @override
  String get continueLabel => 'Lanjut';

  @override
  String get insecureDevice => 'Perangkat tidak aman';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Maaf, kami tidak dapat menghasilkan kunci yang aman di perangkat ini.\n\nHarap mendaftar dengan perangkat lain.';

  @override
  String get howItWorks => 'Cara kerjanya';

  @override
  String get encryption => 'Enkripsi';

  @override
  String get ackPasswordLostWarning =>
      'Saya mengerti bahwa jika saya lupa sandi saya, data saya bisa hilang karena <underline>dienkripsi dari ujung ke ujung</underline>.';

  @override
  String get privacyPolicyTitle => 'Kebijakan Privasi';

  @override
  String get termsOfServicesTitle => 'Ketentuan';

  @override
  String get signUpTerms =>
      'Saya menyetujui <u-terms>ketentuan layanan</u-terms> dan <u-policy>kebijakan privasi</u-policy> Ente';

  @override
  String get logInLabel => 'Masuk akun';

  @override
  String get loginTerms =>
      'Dengan mengklik masuk akun, saya menyetujui <u-terms>ketentuan layanan</u-terms> dan <u-policy>kebijakan privasi</u-policy> Ente';

  @override
  String get changeEmail => 'Ubah email';

  @override
  String get enterYourPassword => 'Masukkan sandi kamu';

  @override
  String get welcomeBack => 'Selamat datang kembali!';

  @override
  String get contactSupport => 'Hubungi dukungan';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Sandi salah';

  @override
  String get pleaseTryAgain => 'Silakan coba lagi';

  @override
  String get recreatePasswordTitle => 'Buat ulang sandi';

  @override
  String get useRecoveryKey => 'Gunakan kunci pemulihan';

  @override
  String get recreatePasswordBody =>
      'Perangkat ini tidak cukup kuat untuk memverifikasi kata sandi kamu, tetapi kami dapat membuat ulang kata sandi kamu sehingga dapat digunakan di semua perangkat.\n\nSilakan masuk menggunakan kunci pemulihan dan buat ulang kata sandi kamu (kamu dapat menggunakan kata sandi yang sama lagi jika mau).';

  @override
  String get verifyPassword => 'Verifikasi sandi';

  @override
  String get recoveryKey => 'Kunci pemulihan';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Saat kamu lupa sandi, satu-satunya cara untuk memulihkan data kamu adalah dengan kunci ini.';

  @override
  String get recoveryKeySaveDescription =>
      'Kami tidak menyimpan kunci ini, jadi harap simpan kunci yang berisi 24 kata ini dengan aman.';

  @override
  String get doThisLater => 'Lakukan lain kali';

  @override
  String get saveKey => 'Simpan kunci';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Kunci pemulihan tersalin ke papan klip';

  @override
  String get recoverAccount => 'Pulihkan akun';

  @override
  String get recover => 'Pulihkan';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Silakan kirimkan email ke $supportEmail dari alamat email terdaftar kamu';
  }

  @override
  String get twofactorSetup => 'Penyiapan autentikasi dua langkah';

  @override
  String get enterCode => 'Masukkan kode';

  @override
  String get scanCode => 'Pindai kode';

  @override
  String get codeCopiedToClipboard => 'Kode tersalin ke papan klip';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Salin lalu tempel kode ini\ndi app autentikator kamu';

  @override
  String get tapToCopy => 'ketuk untuk salin';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Pindai barcode ini dengan\napp autentikator kamu';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Masukkan kode 6 angka dari\napp autentikator kamu';

  @override
  String get confirm => 'Konfirmasi';

  @override
  String get setupComplete => 'Penyiapan selesai';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Jika belum, simpan kunci pemulihan kamu';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Ini dapat digunakan untuk memulihkan akunmu jika kehilangan metode autentikasi dua langkah kamu';

  @override
  String get twofactorAuthenticationPageTitle => 'Autentikasi dua langkah';

  @override
  String get lostDevice => 'Perangkat hilang?';

  @override
  String get verifyingRecoveryKey => 'Memverifikasi kunci pemulihan...';

  @override
  String get recoveryKeyVerified => 'Kunci pemulihan terverifikasi';

  @override
  String get recoveryKeySuccessBody =>
      'Bagus! Kunci pemulihan kamu sah. Terima kasih telah melakukan verifikasi.\n\nHarap simpan selalu kunci pemulihan kamu dengan aman.';

  @override
  String get invalidRecoveryKey =>
      'Kunci pemulihan yang kamu masukkan tidak sah. Pastikan kunci tersebut berisi 24 kata, dan teliti ejaan masing-masing kata.\n\nJika kamu memasukkan kode pemulihan lama, pastikan kode tersebut berisi 64 karakter, dan teliti setiap karakter yang ada.';

  @override
  String get invalidKey => 'Kunci tidak sah';

  @override
  String get tryAgain => 'Coba lagi';

  @override
  String get viewRecoveryKey => 'Lihat kunci pemulihan';

  @override
  String get confirmRecoveryKey => 'Konfirmasi kunci pemulihan';

  @override
  String get recoveryKeyVerifyReason =>
      'Kunci pemulihan kamu adalah satu-satunya cara untuk memulihkan foto-foto kamu jika kamu lupa kata sandi. Kamu bisa lihat kunci pemulihan kamu di Pengaturan > Akun.\n\nHarap masukkan kunci pemulihan kamu di sini untuk memastikan bahwa kamu telah menyimpannya dengan baik.';

  @override
  String get confirmYourRecoveryKey => 'Konfirmasi kunci pemulihan kamu';

  @override
  String get addViewer => 'Tambahkan pemirsa';

  @override
  String get addCollaborator => 'Tambah kolaborator';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Tambah email baru';

  @override
  String get orPickAnExistingOne => 'Atau pilih yang sudah ada';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Kolaborator bisa menambahkan foto dan video ke album bersama ini.';

  @override
  String get enterEmail => 'Masukkan email';

  @override
  String get albumOwner => 'Pemilik';

  @override
  String get you => 'Kamu';

  @override
  String get collaborator => 'Kolaborator';

  @override
  String get addMore => 'Tambah lagi';

  @override
  String get viewer => 'Pemirsa';

  @override
  String get remove => 'Hapus';

  @override
  String get removeParticipant => 'Hapus peserta';

  @override
  String get manage => 'Atur';

  @override
  String get addedAs => 'Ditambahkan sebagai';

  @override
  String get changePermissions => 'Ubah izin?';

  @override
  String get yesConvertToViewer => 'Ya, ubah ke pemirsa';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user tidak akan dapat menambahkan foto lagi ke album ini\n\nIa masih dapat menghapus foto yang ditambahkan olehnya sendiri';
  }

  @override
  String get allowAddingPhotos => 'Izinkan menambah foto';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Izinkan orang yang memiliki link untuk menambahkan foto ke album berbagi ini.';

  @override
  String get passwordLock => 'Kunci dengan sandi';

  @override
  String get canNotOpenTitle => 'Tidak dapat membuka album ini';

  @override
  String get canNotOpenBody =>
      'Maaf, album ini tidak dapat dibuka di aplikasi.';

  @override
  String get disableDownloadWarningTitle => 'Perlu diketahui';

  @override
  String get disableDownloadWarningBody =>
      'Orang yang melihat masih bisa mengambil tangkapan layar atau menyalin foto kamu menggunakan alat eksternal';

  @override
  String get allowDownloads => 'Izinkan pengunduhan';

  @override
  String get linkDeviceLimit => 'Batas perangkat';

  @override
  String get noDeviceLimit => 'Tidak ada';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Waktu kedaluwarsa link';

  @override
  String get linkExpired => 'Kedaluwarsa';

  @override
  String get linkEnabled => 'Aktif';

  @override
  String get linkNeverExpires => 'Tidak pernah';

  @override
  String get expiredLinkInfo =>
      'Link ini telah kedaluwarsa. Silakan pilih waktu kedaluwarsa baru atau nonaktifkan waktu kedaluwarsa.';

  @override
  String get setAPassword => 'Atur sandi';

  @override
  String get lockButtonLabel => 'Kunci';

  @override
  String get enterPassword => 'Masukkan sandi';

  @override
  String get removeLink => 'Hapus link';

  @override
  String get manageLink => 'Atur link';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Link akan kedaluwarsa pada $expiryTime';
  }

  @override
  String get albumUpdated => 'Album diperbarui';

  @override
  String get never => 'Tidak pernah';

  @override
  String get custom => 'Kustom';

  @override
  String get after1Hour => 'Setelah 1 jam';

  @override
  String get after1Day => 'Setelah 1 hari';

  @override
  String get after1Week => 'Setelah 1 minggu';

  @override
  String get after1Month => 'Setelah 1 bulan';

  @override
  String get after1Year => 'Setelah 1 tahun';

  @override
  String get manageParticipants => 'Atur';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Peserta',
      one: '1 Peserta',
      zero: '0 Peserta',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Buat link untuk memungkinkan orang lain menambahkan dan melihat foto yang ada pada album bersama kamu tanpa memerlukan app atau akun Ente. Ideal untuk mengumpulkan foto pada suatu acara.';

  @override
  String get collectPhotos => 'Kumpulkan foto';

  @override
  String get collaborativeLink => 'Link kolaborasi';

  @override
  String get shareWithNonenteUsers => 'Bagikan ke pengguna non-Ente';

  @override
  String get createPublicLink => 'Buat link publik';

  @override
  String get sendLink => 'Kirim link';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Salin link';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Link telah kedaluwarsa';

  @override
  String get publicLinkEnabled => 'Link publik aktif';

  @override
  String get shareALink => 'Bagikan link';

  @override
  String get sharedAlbumSectionDescription =>
      'Buat album bersama dan kolaborasi dengan pengguna Ente lain, termasuk pengguna paket gratis.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Berbagi dengan $numberOfPeople orang',
      one: 'Berbagi dengan 1 orang',
      zero: 'Bagikan dengan orang tertentu',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Ini adalah ID Verifikasi kamu';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Orang yang membagikan album denganmu bisa melihat ID yang sama di perangkat mereka.';

  @override
  String get howToViewShareeVerificationID =>
      'Silakan minta dia untuk menekan lama alamat email-nya di layar pengaturan, dan pastikan bahwa ID di perangkatnya sama.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Ini adalah ID Verifikasi milik $email';
  }

  @override
  String get verificationId => 'ID Verifikasi';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verifikasi $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email tidak punya akun Ente.\n\nUndang dia untuk berbagi foto.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Ini ID Verifikasi saya di ente.io: $verificationID.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Halo, bisakah kamu pastikan bahwa ini adalah ID Verifikasi ente.io milikmu: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Terjadi kesalahan';

  @override
  String get sendInvite => 'Kirim undangan';

  @override
  String get shareTextRecommendUsingEnte =>
      'Unduh Ente agar kita bisa berbagi foto dan video kualitas asli dengan mudah\n\nhttps://ente.io';

  @override
  String get done => 'Selesai';

  @override
  String get applyCodeTitle => 'Terapkan kode';

  @override
  String get enterCodeDescription =>
      'Masukkan kode yang diberikan temanmu untuk memperoleh kuota gratis untuk kalian berdua';

  @override
  String get apply => 'Terapkan';

  @override
  String get failedToApplyCode => 'Gagal menerapkan kode';

  @override
  String get enterReferralCode => 'Masukkan kode rujukan';

  @override
  String get codeAppliedPageTitle => 'Kode diterapkan';

  @override
  String get changeYourReferralCode => 'Ganti kode rujukan kamu';

  @override
  String get change => 'Ubah';

  @override
  String get unavailableReferralCode => 'Maaf, kode ini tidak tersedia.';

  @override
  String get codeChangeLimitReached =>
      'Maaf, kamu telah mencapai batas perubahan kode.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Harap hubungi $familyAdminEmail untuk mengubah kode kamu.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Diperoleh';

  @override
  String get details => 'Rincian';

  @override
  String get claimMore => 'Peroleh lebih banyak!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Ia juga mendapat $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB setiap kali orang mendaftar dengan paket berbayar lalu menerapkan kode milikmu';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Kode rujukan Ente: $referralCode \n\nTerapkan pada Pengaturan → Umum → Rujukan untuk mendapatkan $referralStorageInGB GB gratis setelah kamu mendaftar paket berbayar\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Peroleh kuota gratis';

  @override
  String get inviteYourFriends => 'Undang teman-temanmu';

  @override
  String get failedToFetchReferralDetails =>
      'Tidak dapat mengambil kode rujukan. Harap ulang lagi nanti.';

  @override
  String get referralStep1 => '1. Berikan kode ini ke teman kamu';

  @override
  String get referralStep2 => '2. Ia perlu daftar ke paket berbayar';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Kalian berdua mendapat $storageInGB GB* gratis';
  }

  @override
  String get referralsAreCurrentlyPaused => 'Rujukan sedang dijeda';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Maksimal dua kali lipat dari kuota penyimpananmu';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Keluargamu saat ini telah memperoleh $storageAmountInGb GB',
      'false': 'Kamu saat ini telah memperoleh $storageAmountInGb GB',
      'other': 'Kamu saat ini telah memperoleh $storageAmountInGb GB!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Tanya Jawab Umum';

  @override
  String get help => 'Bantuan';

  @override
  String get oopsSomethingWentWrong => 'Aduh, terjadi kesalahan';

  @override
  String get peopleUsingYourCode => 'Orang yang telah menggunakan kodemu';

  @override
  String get eligible => 'memenuhi syarat';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Kode yang telah kamu gunakan';

  @override
  String get freeStorageClaimed => 'Kuota gratis diperoleh';

  @override
  String get freeStorageUsable => 'Kuota gratis yang dapat digunakan';

  @override
  String get usableReferralStorageInfo =>
      'Kuota yang dapat digunakan dibatasi oleh paket kamu saat ini. Kelebihan kuota yang diklaim akan dapat digunakan secara otomatis saat meningkatkan paket kamu.';

  @override
  String get removeFromAlbumTitle => 'Hapus dari album?';

  @override
  String get removeFromAlbum => 'Hapus dari album';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Item yang dipilih akan dihapus dari album ini';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Menambahkan ke favorit...';

  @override
  String get removingFromFavorites => 'Menghapus dari favorit...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Maaf, tidak dapat menambahkan ke favorit!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Maaf, tidak dapat menghapus dari favorit!';

  @override
  String get subscribeToEnableSharing =>
      'Anda memerlukan langganan berbayar yang aktif untuk bisa berbagi.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'Berlangganan';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Hanya dapat menghapus berkas yang dimiliki oleh mu';

  @override
  String get deleteSharedAlbum => 'Hapus album bersama?';

  @override
  String get deleteAlbum => 'Hapus album';

  @override
  String get deleteAlbumDialog =>
      'Hapus foto (dan video) yang ada dalam album ini dari <bold>semua</bold> album lain yang juga menampungnya?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Album ini akan di hapus untuk semua\n\nKamu akan kehilangan akses ke foto yang di bagikan dalam album ini yang di miliki oleh pengguna lain';

  @override
  String get yesRemove => 'Ya, hapus';

  @override
  String get creatingLink => 'Membuat link...';

  @override
  String get removeWithQuestionMark => 'Hapus?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail akan dikeluarkan dari album berbagi ini\n\nSemua foto yang ia tambahkan juga akan dihapus dari album ini';
  }

  @override
  String get keepPhotos => 'Simpan foto';

  @override
  String get deletePhotos => 'Hapus foto';

  @override
  String get inviteToEnte => 'Undang ke Ente';

  @override
  String get removePublicLink => 'Hapus link publik';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Ini akan menghapus link publik yang digunakan untuk mengakses \"$albumName\".';
  }

  @override
  String get sharing => 'Membagikan...';

  @override
  String get youCannotShareWithYourself =>
      'Kamu tidak bisa berbagi dengan dirimu sendiri';

  @override
  String get archive => 'Arsip';

  @override
  String get createAlbumActionHint =>
      'Tekan dan tahan foto lalu klik + untuk membuat album baru';

  @override
  String get importing => 'Mengimpor....';

  @override
  String get failedToLoadAlbums => 'Gagal memuat album';

  @override
  String get hidden => 'Tersembunyi';

  @override
  String get authToViewYourHiddenFiles =>
      'Harap autentikasi untuk melihat file tersembunyi kamu';

  @override
  String get authToViewTrashedFiles =>
      'Silakan autentikasi untuk melihat file anda yang ada di tong sampah';

  @override
  String get trash => 'Sampah';

  @override
  String get uncategorized => 'Tak Berkategori';

  @override
  String get videoSmallCase => 'video';

  @override
  String get photoSmallCase => 'foto';

  @override
  String get singleFileDeleteHighlight => 'Ia akan dihapus dari semua album.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return '$fileType ini tersimpan di Ente dan juga di perangkat ini.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return '$fileType ini akan dihapus dari Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return '$fileType ini akan dihapus dari perangkat ini.';
  }

  @override
  String get deleteFromEnte => 'Hapus dari Ente';

  @override
  String get yesDelete => 'Ya, hapus';

  @override
  String get movedToTrash => 'Pindah ke sampah';

  @override
  String get deleteFromDevice => 'Hapus dari perangkat ini';

  @override
  String get deleteFromBoth => 'Hapus dari keduanya';

  @override
  String get newAlbum => 'Album baru';

  @override
  String get albums => 'Album';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount memori',
      one: '$formattedCount memori',
      zero: 'tidak ada memori',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count terpilih';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count dipilih ($yourCount milikmu)';
  }

  @override
  String get advancedSettings => 'Lanjutan';

  @override
  String get photoGridSize => 'Ukuran kotak foto';

  @override
  String get manageDeviceStorage => 'Mengelola cache perangkat';

  @override
  String get manageDeviceStorageDesc =>
      'Tinjau dan hapus penyimpanan cache lokal.';

  @override
  String get machineLearning => 'Pemelajaran mesin';

  @override
  String get mlConsent => 'Aktifkan pemelajaran mesin';

  @override
  String get mlConsentTitle => 'Aktifkan pemelajaran mesin?';

  @override
  String get mlConsentDescription =>
      'Jika kamu mengaktifkan pemelajaran mesin, Ente akan memproses informasi seperti geometri wajah dari file yang ada, termasuk file yang dibagikan kepadamu.\n\nIni dijalankan pada perangkatmu, dan setiap informasi biometrik yang dibuat akan terenkripsi ujung ke ujung.';

  @override
  String get mlConsentPrivacy =>
      'Klik di sini untuk detail lebih lanjut tentang fitur ini pada kebijakan privasi kami';

  @override
  String get mlConsentConfirmation =>
      'Saya memahami, dan bersedia mengaktifkan pemelajaran mesin';

  @override
  String get magicSearch => 'Penelusuran ajaib';

  @override
  String get discover => 'Temukan';

  @override
  String get discover_identity => 'Identitas';

  @override
  String get discover_screenshots => 'Tangkapan layar';

  @override
  String get discover_receipts => 'Tanda Terima';

  @override
  String get discover_notes => 'Catatan';

  @override
  String get discover_memes => 'Meme';

  @override
  String get discover_visiting_cards => 'Kartu Nama';

  @override
  String get discover_babies => 'Bayi';

  @override
  String get discover_pets => 'Hewan';

  @override
  String get discover_selfies => 'Swafoto';

  @override
  String get discover_wallpapers => 'Gambar latar';

  @override
  String get discover_food => 'Makanan';

  @override
  String get discover_celebrations => 'Perayaan';

  @override
  String get discover_sunset => 'Senja';

  @override
  String get discover_hills => 'Bukit';

  @override
  String get discover_greenery => 'Hijau-hijauan';

  @override
  String get mlIndexingDescription =>
      'Perlu diperhatikan bahwa pemelajaran mesin dapat meningkatkan penggunaan data dan baterai perangkat hingga seluruh item selesai terindeks. Gunakan aplikasi desktop untuk pengindeksan lebih cepat, seluruh hasil akan tersinkronkan secara otomatis.';

  @override
  String get loadingModel => 'Mengunduh model...';

  @override
  String get waitingForWifi => 'Menunggu WiFi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Item terindeks';

  @override
  String get pendingItems => 'Item menunggu';

  @override
  String get clearIndexes => 'Hapus indeks';

  @override
  String get selectFoldersForBackup => 'Pilih folder yang perlu dicadangkan';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Folder yang terpilih akan dienkripsi dan dicadangkan';

  @override
  String get unselectAll => 'Batalkan semua pilihan';

  @override
  String get selectAll => 'Pilih semua';

  @override
  String get skip => 'Lewati';

  @override
  String get updatingFolderSelection => 'Memperbaharui pilihan folder...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count item',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Hapus $count item',
      one: 'Hapus $count item',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count berkas, masing-masing $formattedSize';
  }

  @override
  String get showMemories => 'Lihat kenangan';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tahun lalu',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Pengaturan pencadangan';

  @override
  String get backupStatus => 'Status pencadangan';

  @override
  String get backupStatusDescription =>
      'Item yang sudah dicadangkan akan terlihat di sini';

  @override
  String get backupOverMobileData => 'Cadangkan dengan data seluler';

  @override
  String get backupVideos => 'Cadangkan video';

  @override
  String get disableAutoLock => 'Nonaktifkan kunci otomatis';

  @override
  String get deviceLockExplanation =>
      'Nonaktfikan kunci layar perangkat saat Ente berada di latar depan dan ada pencadangan yang sedang berlangsung. Hal ini biasanya tidak diperlukan, namun dapat membantu unggahan dan import awal berkas berkas besar selesai lebih cepat.';

  @override
  String get about => 'Tentang';

  @override
  String get weAreOpenSource => 'Kode sumber kami terbuka!';

  @override
  String get privacy => 'Privasi';

  @override
  String get terms => 'Ketentuan';

  @override
  String get checkForUpdates => 'Periksa pembaruan';

  @override
  String get checkStatus => 'Periksa status';

  @override
  String get checking => 'Memeriksa...';

  @override
  String get youAreOnTheLatestVersion => 'Kamu menggunakan versi terbaru';

  @override
  String get account => 'Akun';

  @override
  String get manageSubscription => 'Atur langganan';

  @override
  String get authToChangeYourEmail =>
      'Harap autentikasi untuk mengubah email kamu';

  @override
  String get changePassword => 'Ubah sandi';

  @override
  String get authToChangeYourPassword =>
      'Harap autentikasi untuk mengubah sandi kamu';

  @override
  String get emailVerificationToggle => 'Verifikasi email';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Harap autentikasi untuk mengatur verifikasi email';

  @override
  String get exportYourData => 'Ekspor data kamu';

  @override
  String get logout => 'Keluar akun';

  @override
  String get authToInitiateAccountDeletion =>
      'Harap autentikasi untuk mulai penghapusan akun';

  @override
  String get areYouSureYouWantToLogout =>
      'Apakah kamu yakin ingin keluar akun?';

  @override
  String get yesLogout => 'Ya, keluar';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Versi baru dari Ente telah tersedia.';

  @override
  String get update => 'Perbarui';

  @override
  String get installManually => 'Instal secara manual';

  @override
  String get criticalUpdateAvailable => 'Pembaruan penting tersedia';

  @override
  String get updateAvailable => 'Pembaruan tersedia';

  @override
  String get ignoreUpdate => 'Abaikan';

  @override
  String get downloading => 'Mengunduh...';

  @override
  String get cannotDeleteSharedFiles => 'Tidak dapat menghapus file berbagi';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Unduhan tidak dapat diselesaikan';

  @override
  String get retry => 'Coba lagi';

  @override
  String get backedUpFolders => 'Folder yang dicadangkan';

  @override
  String get backup => 'Pencadangan';

  @override
  String get freeUpDeviceSpace => 'Bersihkan penyimpanan perangkat';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Hemat ruang penyimpanan di perangkatmu dengan membersihkan file yang sudah tercadangkan.';

  @override
  String get allClear => '✨ Sudah bersih';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Tidak ada file yang perlu dihapus dari perangkat ini';

  @override
  String get removeDuplicates => 'Hapus duplikat';

  @override
  String get removeDuplicatesDesc => 'Lihat dan hapus file yang sama persis.';

  @override
  String get viewLargeFiles => 'File berukuran besar';

  @override
  String get viewLargeFilesDesc =>
      'Tampilkan file yang paling besar mengonsumsi ruang penyimpanan.';

  @override
  String get noDuplicates => '✨ Tak ada file duplikat';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Anda tidak memiliki file duplikat yang dapat dihapus';

  @override
  String get success => 'Berhasil';

  @override
  String get rateUs => 'Beri kami nilai';

  @override
  String get remindToEmptyDeviceTrash =>
      'Kosongkan juga “Baru Dihapus” dari “Pengaturan” -> “Penyimpanan” untuk memperoleh ruang yang baru saja dibersihkan';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Kamu telah berhasil membersihkan $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Kosongkan juga \"Sampah\" untuk memperoleh ruang yang baru dikosongkan';

  @override
  String get sparkleSuccess => '✨ Berhasil';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count file duplikat',
    );
    return 'Kamu telah menghapus $_temp0 dan membersihkan ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Paket keluarga';

  @override
  String get referrals => 'Referensi';

  @override
  String get notifications => 'Notifikasi';

  @override
  String get sharedPhotoNotifications => 'Foto terbagi baru';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Terima notifikasi apabila seseorang menambahkan foto ke album bersama yang kamu ikuti';

  @override
  String get advanced => 'Lanjutan';

  @override
  String get general => 'Umum';

  @override
  String get security => 'Keamanan';

  @override
  String get authToViewYourRecoveryKey =>
      'Harap autentikasi untuk melihat kunci pemulihan kamu';

  @override
  String get twofactor => 'Autentikasi dua langkah';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Harap autentikasi untuk mengatur autentikasi dua langkah';

  @override
  String get lockscreen => 'Kunci layar';

  @override
  String get authToChangeLockscreenSetting =>
      'Lakukan autentikasi untuk mengubah pengaturan kunci layar';

  @override
  String get viewActiveSessions => 'Lihat sesi aktif';

  @override
  String get authToViewYourActiveSessions =>
      'Harap autentikasi untuk melihat sesi aktif kamu';

  @override
  String get disableTwofactor => 'Nonaktifkan autentikasi dua langkah';

  @override
  String get confirm2FADisable =>
      'Apakah kamu yakin ingin menonaktifkan autentikasi dua langkah?';

  @override
  String get no => 'Tidak';

  @override
  String get yes => 'Ya';

  @override
  String get social => 'Sosial';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Beri nilai di $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Merchandise';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Rincian penyimpananmu tidak dapat dimuat';

  @override
  String get reportABug => 'Laporkan bug';

  @override
  String get reportBug => 'Laporkan bug';

  @override
  String get suggestFeatures => 'Sarankan fitur';

  @override
  String get support => 'Dukungan';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Cerah';

  @override
  String get darkTheme => 'Gelap';

  @override
  String get systemTheme => 'Sistem';

  @override
  String get freeTrial => 'Percobaan gratis';

  @override
  String get selectYourPlan => 'Pilih paket kamu';

  @override
  String get enteSubscriptionPitch =>
      'Ente memelihara kenanganmu, sehingga ia selalu tersedia untukmu, bahkan jika kamu kehilangan perangkatmu.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Anggota keluargamu juga bisa ditambahkan ke paketmu.';

  @override
  String get currentUsageIs => 'Pemakaian saat ini sebesar ';

  @override
  String get faqs => 'Tanya Jawab Umum';

  @override
  String renewsOn({required Object endDate}) {
    return 'Langganan akan diperpanjang pada $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Percobaan gratis berlaku hingga $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Berlaku hingga $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Add-on $storageAmount kamu berlaku sampai $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Percobaan gratis berlaku hingga $endDate.\nKamu dapat memilih paket berbayar setelahnya.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Langganan kamu akan dibatalkan pada $endDate';
  }

  @override
  String get subscription => 'Langganan';

  @override
  String get paymentDetails => 'Rincian pembayaran';

  @override
  String get manageFamily => 'Atur Keluarga';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Silakan hubungi kami di support@ente.io untuk mengatur langganan $provider kamu.';
  }

  @override
  String get renewSubscription => 'Perpanjang langganan';

  @override
  String get cancelSubscription => 'Batalkan langganan';

  @override
  String get areYouSureYouWantToRenew =>
      'Apakah kamu yakin ingin memperpanjang?';

  @override
  String get yesRenew => 'Ya, Perpanjang';

  @override
  String get areYouSureYouWantToCancel =>
      'Apakah kamu yakin ingin membatalkan?';

  @override
  String get yesCancel => 'Ya, batalkan';

  @override
  String get failedToRenew => 'Gagal memperpanjang';

  @override
  String get failedToCancel => 'Gagal membatalkan';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 bulan gratis dengan paket tahunan';

  @override
  String get monthly => 'Bulanan';

  @override
  String get yearly => 'Tahunan';

  @override
  String get confirmPlanChange => 'Konfirmasi perubahan paket';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Apakah kamu yakin ingin mengubah paket kamu?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Kamu tidak dapat turun ke paket ini';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Harap batalkan langganan kamu di $paymentProvider terlebih dahulu';
  }

  @override
  String get optionalAsShortAsYouLike => 'Opsional, pendek pun tak apa...';

  @override
  String get send => 'Kirim';

  @override
  String get askCancelReason =>
      'Langganan kamu telah dibatalkan. Apakah kamu ingin membagikan alasannya?';

  @override
  String get thankYouForSubscribing => 'Terima kasih telah berlangganan!';

  @override
  String get yourPurchaseWasSuccessful => 'Pembelianmu berhasil';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Paket kamu berhasil ditingkatkan';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Paket kamu berhasil di turunkan';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Langgananmu telah berhasil diperbarui';

  @override
  String get googlePlayId => 'ID Google Play';

  @override
  String get appleId => 'ID Apple';

  @override
  String get playstoreSubscription => 'Langganan PlayStore';

  @override
  String get appstoreSubscription => 'Langganan AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return '$id kamu telah terhubung dengan akun Ente lain.\nJika kamu ingin menggunakan $id kamu untuk akun ini, silahkan hubungi tim bantuan kami';
  }

  @override
  String get visitWebToManage =>
      'Silakan buka web.ente.io untuk mengatur langgananmu';

  @override
  String get couldNotUpdateSubscription => 'Tidak dapat memperbarui langganan';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Silakan hubungi support@ente.io dan kami akan dengan senang hati membantu!';

  @override
  String get paymentFailed => 'Pembayaran gagal';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Harap hubungi dukungan $providerName jika kamu dikenai biaya';
  }

  @override
  String get continueOnFreeTrial => 'Lanjut dengan percobaan gratis';

  @override
  String get areYouSureYouWantToExit => 'Apakah kamu yakin ingin keluar?';

  @override
  String get thankYou => 'Terima kasih';

  @override
  String get failedToVerifyPaymentStatus => 'Gagal memeriksa status pembayaran';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Harap tunggu beberapa saat sebelum mencoba lagi';

  @override
  String get paymentFailedMessage =>
      'Sayangnya, pembayaranmu gagal. Silakan hubungi tim bantuan agar dapat kami bantu!';

  @override
  String get youAreOnAFamilyPlan => 'Kamu menggunakan paket keluarga!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Silakan hubungi <green>$familyAdminEmail</green> untuk mengatur langgananmu';
  }

  @override
  String get leaveFamily => 'Tinggalkan keluarga';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Apakah kamu yakin ingin meninggalkan paket keluarga ini?';

  @override
  String get leave => 'Tinggalkan';

  @override
  String get rateTheApp => 'Nilai app ini';

  @override
  String get startBackup => 'Mulai pencadangan';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Tidak ada foto yang sedang dicadangkan sekarang';

  @override
  String get preserveMore => 'Amankan lebih banyak';

  @override
  String get grantFullAccessPrompt =>
      'Harap berikan akses ke semua foto di app Pengaturan';

  @override
  String get allowPermTitle => 'Izinkan akses ke foto';

  @override
  String get allowPermBody =>
      'Ijinkan akses ke foto Anda dari Pengaturan agar Ente dapat menampilkan dan mencadangkan pustaka Anda.';

  @override
  String get openSettings => 'Buka Pengaturan';

  @override
  String get selectMorePhotos => 'Pilih lebih banyak foto';

  @override
  String get existingUser => 'Masuk';

  @override
  String get privateBackups => 'Cadangan pribadi';

  @override
  String get forYourMemories => 'untuk kenanganmu';

  @override
  String get endtoendEncryptedByDefault =>
      'Dirancang dengan enkripsi ujung ke ujung';

  @override
  String get safelyStored => 'Tersimpan aman';

  @override
  String get atAFalloutShelter => 'di tempat pengungsian';

  @override
  String get designedToOutlive => 'Dibuat untuk melestarikan';

  @override
  String get available => 'Tersedia';

  @override
  String get everywhere => 'di mana saja';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Seluler, Web, Desktop';

  @override
  String get newToEnte => 'Baru di Ente';

  @override
  String get pleaseLoginAgain => 'Silakan masuk akun lagi';

  @override
  String get autoLogoutMessage =>
      'Akibat kesalahan teknis, kamu telah keluar dari akunmu. Kami mohon maaf atas ketidaknyamanannya.';

  @override
  String get yourSubscriptionHasExpired => 'Langgananmu telah berakhir';

  @override
  String get storageLimitExceeded => 'Batas penyimpanan terlampaui';

  @override
  String get upgrade => 'Tingkatkan';

  @override
  String get raiseTicket => 'Buat tiket dukungan';

  @override
  String get backupFailed => 'Pencadangan gagal';

  @override
  String get sorryBackupFailedDesc =>
      'Maaf, kami tidak dapat mencadangkan berkas ini sekarang, kami akan mencobanya kembali nanti.';

  @override
  String get couldNotBackUpTryLater =>
      'Kami tidak dapat mencadangkan data kamu.\nKami akan coba lagi nanti.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente hanya dapat mengenkripsi dan menyimpan file jika kamu berikan izin';

  @override
  String get pleaseGrantPermissions => 'Harap berikan izin';

  @override
  String get grantPermission => 'Berikan izin';

  @override
  String get privateSharing => 'Berbagi secara privat';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Bagikan hanya dengan orang yang kamu inginkan';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Bagikan link publik ke orang yang tidak menggunakan Ente';

  @override
  String get allowPeopleToAddPhotos => 'Izinkan orang lain menambahkan foto';

  @override
  String get shareAnAlbumNow => 'Bagikan album sekarang';

  @override
  String get collectEventPhotos => 'Kumpulkan foto acara';

  @override
  String get sessionExpired => 'Sesi berakhir';

  @override
  String get loggingOut => 'Mengeluarkan akun...';

  @override
  String get onDevice => 'Di perangkat ini';

  @override
  String get onEnte => 'Di <branding>ente</branding>';

  @override
  String get name => 'Nama';

  @override
  String get newest => 'Terbaru';

  @override
  String get lastUpdated => 'Terakhir diperbarui';

  @override
  String get deleteEmptyAlbums => 'Hapus album kosong';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Hapus album yang kosong?';

  @override
  String get deleteAlbumsDialogBody =>
      'Ini akan menghapus semua album kosong. Ini berguna ketika anda ingin mengurangi kekacauan di daftar album anda.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Menghapus $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Memproses $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Hapus secara permanen';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Hanya dapat membuat tautan untuk file yang dimiliki oleh anda';

  @override
  String get publicLinkCreated => 'Link publik dibuat';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Kamu bisa atur link yang telah kamu buat di tab berbagi.';

  @override
  String get linkCopiedToClipboard => 'Link tersalin ke papan klip';

  @override
  String get restore => 'Pulihkan';

  @override
  String get moveToAlbum => 'Pindahkan ke album';

  @override
  String get unhide => 'Tampilkan';

  @override
  String get unarchive => 'Keluarkan dari arsip';

  @override
  String get favorite => 'Favorit';

  @override
  String get removeFromFavorite => 'Hapus dari favorit';

  @override
  String get shareLink => 'Bagikan link';

  @override
  String get createCollage => 'Buat kolase';

  @override
  String get saveCollage => 'Simpan kolase';

  @override
  String get collageSaved => 'Kolase tersimpan ke galeri';

  @override
  String get collageLayout => 'Tata letak';

  @override
  String get addToEnte => 'Tambah ke Ente';

  @override
  String get addToAlbum => 'Tambah ke album';

  @override
  String get delete => 'Hapus';

  @override
  String get hide => 'Sembunyikan';

  @override
  String get share => 'Bagikan';

  @override
  String get unhideToAlbum => 'Tampikan ke album';

  @override
  String get restoreToAlbum => 'Pulihkan ke album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pindahkan item',
      one: 'Pindahkan item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tambahkan item',
      one: 'Tambahkan item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Buat atau pilih album';

  @override
  String get selectAlbum => 'Pilih album';

  @override
  String get searchByAlbumNameHint => 'Nama album';

  @override
  String get albumTitle => 'Judul album';

  @override
  String get enterAlbumName => 'Masukkan nama album';

  @override
  String get restoringFiles => 'Memulihkan file...';

  @override
  String get movingFilesToAlbum => 'Memindahkan file ke album...';

  @override
  String get unhidingFilesToAlbum => 'Tampilkan berkas ke album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Tidak dapat mengunggah album yang dimiliki oleh orang lain';

  @override
  String get uploadingFilesToAlbum => 'Mengunggah file ke album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Berhasil ditambahkan ke $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Berhasil dipindahkan ke $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Link kolaborasi untuk album ini sudah terbuat';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Link kolaborasi terbuat untuk $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Minta orang terkasih anda untuk berbagi';

  @override
  String get invite => 'Undang';

  @override
  String get shareYourFirstAlbum => 'Bagikan album pertamamu';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Dibagikan dengan $emailIDs';
  }

  @override
  String get sharedWithMe => 'Dibagikan dengan saya';

  @override
  String get sharedByMe => 'Dibagikan oleh saya';

  @override
  String get doubleYourStorage => 'Gandakan kuota kamu';

  @override
  String get referFriendsAnd2xYourPlan => 'Ajak teman dan gandakan paket anda';

  @override
  String get shareAlbumHint =>
      'Buka album lalu ketuk tombol bagikan di sudut kanan atas untuk berbagi.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Item menampilkan jumlah hari yang tersisa sebelum dihapus permanen';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hari',
      one: '1 hari',
      zero: 'Segera',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Hapus Semua';

  @override
  String get renameAlbum => 'Ubah nama album';

  @override
  String get convertToAlbum => 'Ubah menjadi album';

  @override
  String get setCover => 'Ubah sampul';

  @override
  String get sortAlbumsBy => 'Urut berdasarkan';

  @override
  String get sortNewestFirst => 'Terbaru dulu';

  @override
  String get sortOldestFirst => 'Terlama dulu';

  @override
  String get rename => 'Ubah nama';

  @override
  String get leaveSharedAlbum => 'Tinggalkan album bersama?';

  @override
  String get leaveAlbum => 'Tinggalkan album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Foto yang telah kamu tambahkan akan dihapus dari album ini';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Anda tidak memiliki file di album ini yang dapat dihapus';

  @override
  String get youDontHaveAnyArchivedItems =>
      'Kamu tidak memiliki item di arsip.';

  @override
  String get ignoredFolderUploadReason =>
      'Sejumlah file di album ini tidak terunggah karena telah dihapus sebelumnya dari Ente.';

  @override
  String get resetIgnoredFiles => 'Atur ulang file yang diabaikan';

  @override
  String get deviceFilesAutoUploading =>
      'File yang ditambahkan ke album perangkat ini akan diunggah ke Ente secara otomatis.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Aktifkan pencadangan untuk mengunggah file yang ditambahkan ke folder ini ke Ente secara otomatis.';

  @override
  String get noHiddenPhotosOrVideos => 'Tidak ada foto atau video tersembunyi';

  @override
  String get toHideAPhotoOrVideo => 'Untuk menyembunyikan foto atau video';

  @override
  String get openTheItem => '• Buka item-nya';

  @override
  String get clickOnTheOverflowMenu => '• Klik pada menu overflow';

  @override
  String get click => '• Click';

  @override
  String get nothingToSeeHere => 'Tidak ada apa-apa di sini! 👀';

  @override
  String get unarchiveAlbum => 'Keluarkan album dari arsip';

  @override
  String get archiveAlbum => 'Arsipkan album';

  @override
  String get calculating => 'Menghitung...';

  @override
  String get pleaseWaitDeletingAlbum => 'Harap tunggu, sedang menghapus album';

  @override
  String get searchByExamples =>
      '• Nama album (cth. \"Kamera\")\n• Jenis file (cth. \"Video\", \".gif\")\n• Tahun atau bulan (cth. \"2022\", \"Januari\")\n• Musim liburan (cth. \"Natal\")\n• Keterangan foto (cth. “#seru”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Anda dapat mencoba mencari dengan kata-kata yang berbeda';

  @override
  String get noResultsFound => 'Tidak ditemukan hasil';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Ditambahkan oleh $emailOrName';
  }

  @override
  String get loadingExifData => 'Memuat data EXIF...';

  @override
  String get viewAllExifData => 'Lihat seluruh data EXIF';

  @override
  String get noExifData => 'Tidak ada data EXIF';

  @override
  String get thisImageHasNoExifData => 'Gambar ini tidak memiliki data exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Tidak ada hasil';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Kami belum mendukung pengeditan foto dan album yang bukan milik anda';

  @override
  String get failedToFetchOriginalForEdit =>
      'Gagal memuat file asli untuk mengedit';

  @override
  String get close => 'Tutup';

  @override
  String get setAs => 'Pasang sebagai';

  @override
  String get fileSavedToGallery => 'File tersimpan ke galeri';

  @override
  String get filesSavedToGallery => 'File tersimpan ke galeri';

  @override
  String get fileFailedToSaveToGallery => 'Gagal menyimpan file ke galeri';

  @override
  String get download => 'Unduh';

  @override
  String get pressAndHoldToPlayVideo => 'Tekan dan tahan untuk memutar video';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Tekan dan tahan gambar untuk memutar video';

  @override
  String get downloadFailed => 'Gagal mengunduh';

  @override
  String get deduplicateFiles => 'Hilangkan Duplikasi File';

  @override
  String get deselectAll => 'Batalkan semua pilihan';

  @override
  String get reviewDeduplicateItems =>
      'Silakan lihat dan hapus item yang merupakan duplikat.';

  @override
  String get clubByCaptureTime => 'Kelompokkan berdasarkan waktu pengambilan';

  @override
  String get clubByFileName => 'Kelompokkan berdasarkan nama berkas';

  @override
  String get count => 'Jumlah';

  @override
  String get totalSize => 'Ukuran total';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Tekan lama pada item untuk melihat dalam layar penuh';

  @override
  String get decryptingVideo => 'Mendekripsi video...';

  @override
  String get authToViewYourMemories =>
      'Harap autentikasi untuk melihat kenanganmu';

  @override
  String get unlock => 'Buka';

  @override
  String get freeUpSpace => 'Bersihkan ruang';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          'Itu dapat dihapus dari perangkat untuk mengosongkan $formattedSize',
      one: 'Itu dapat dihapus dari perangkat untuk mengosongkan $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber file',
    );
    return '$_temp0 dalam album ini telah berhasil dicadangkan';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber file',
    );
    return '$_temp0 di perangkat ini telah berhasil dicadangkan';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'mereka',
      one: 'itu',
    );
    return 'anda masih dapat mengakses $_temp0 di Ente selama anda memiliki langganan aktif';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Bersihkan $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Email ini telah digunakan';

  @override
  String get incorrectCode => 'Kode salah';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Autentikasi gagal, silakan coba lagi';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verifikasi gagal, silakan coba lagi';

  @override
  String get authenticating => 'Autentikasi...';

  @override
  String get authenticationSuccessful => 'Autentikasi berhasil!';

  @override
  String get incorrectRecoveryKey => 'Kunci pemulihan salah';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Kunci pemulihan yang kamu masukkan salah';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Autentikasi dua langkah berhasil direset';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Harap periksa kode yang kamu masukkan';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Silakan hubungi tim bantuan jika masalah terus terjadi';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Autentikasi dua langkah telah dinonaktifkan';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Maaf, kode yang kamu masukkan salah';

  @override
  String get yourVerificationCodeHasExpired =>
      'Kode verifikasi kamu telah kedaluwarsa';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Email diubah menjadi $newEmail';
  }

  @override
  String get verifying => 'Memverifikasi...';

  @override
  String get disablingTwofactorAuthentication =>
      'Menonaktifkan autentikasi dua langkah...';

  @override
  String get allMemoriesPreserved => 'Semua kenangan terpelihara';

  @override
  String get loadingGallery => 'Memuat galeri...';

  @override
  String get syncing => 'Menyinkronkan...';

  @override
  String get encryptingBackup => 'Mengenkripsi cadangan...';

  @override
  String get syncStopped => 'Sinkronisasi terhenti';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total memori tersimpan';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Menyimpan $count memori...';
  }

  @override
  String get uploadingSingleMemory => 'Menyimpan 1 memori...';

  @override
  String get archiving => 'Mengarsipkan...';

  @override
  String get unarchiving => 'Mengeluarkan dari arsip...';

  @override
  String get successfullyArchived => 'Berhasil diarsipkan';

  @override
  String get successfullyUnarchived => 'Berhasil dikeluarkan dari arsip';

  @override
  String get renameFile => 'Ubah nama file';

  @override
  String get enterFileName => 'Masukkan nama file';

  @override
  String get filesDeleted => 'File terhapus';

  @override
  String get selectedFilesAreNotOnEnte =>
      'File terpilih tidak tersimpan di Ente';

  @override
  String get thisActionCannotBeUndone => 'Tindakan ini tidak dapat dibatalkan';

  @override
  String get emptyTrash => 'Kosongkan sampah?';

  @override
  String get permDeleteWarning =>
      'Semua item di sampah akan dihapus secara permanen\n\nTindakan ini tidak dapat dibatalkan';

  @override
  String get empty => 'Kosongkan';

  @override
  String get couldNotFreeUpSpace => 'Tidak dapat membersihkan ruang';

  @override
  String get permanentlyDeleteFromDevice =>
      'Hapus dari perangkat secara permanen?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Beberapa file yang anda coba hapus hanya tersedia di perangkat anda dan tidak dapat dipulihkan jika dihapus';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Mereka akan dihapus dari semua album.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Sejumlah item tersimpan di Ente serta di perangkat ini.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Item terpilih akan dihapus dari semua album dan dipindahkan ke sampah.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Item ini akan dihapus dari perangkat ini.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Sepertinya terjadi kesalahan. Silakan coba lagi setelah beberapa saat. Jika kesalahan terus terjadi, silakan hubungi tim dukungan kami.';

  @override
  String get error => 'Kesalahan';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Sepertinya terjadi kesalahan. Silakan coba lagi setelah beberapa saat. Jika kesalahan terus terjadi, silakan hubungi tim dukungan kami.';

  @override
  String get networkHostLookUpErr =>
      'Tidak dapat terhubung dengan Ente, harap periksa pengaturan jaringan kamu dan hubungi dukungan jika masalah berlanjut.';

  @override
  String get networkConnectionRefusedErr =>
      'Tidak dapat terhubung dengan Ente, silakan coba lagi setelah beberapa saat. Jika masalah berlanjut, harap hubungi dukungan.';

  @override
  String get cachedData => 'Data cache';

  @override
  String get clearCaches => 'Bersihkan cache';

  @override
  String get remoteImages => 'Gambar jarak jauh';

  @override
  String get remoteVideos => 'Video jarak jauh';

  @override
  String get remoteThumbnails => 'Thumbnail jarak jauh';

  @override
  String get pendingSync => 'Sinkronisasi tertunda';

  @override
  String get localGallery => 'Galeri lokal';

  @override
  String get todaysLogs => 'Log hari ini';

  @override
  String get viewLogs => 'Lihat log';

  @override
  String get logsDialogBody =>
      'Ini akan mengirimkan log untuk membantu kami memperbaiki masalah anda. Harap diperhatikan bahwa nama file akan disertakan untuk membantu melacak masalah pada file tertentu.';

  @override
  String get preparingLogs => 'Menyiapkan log...';

  @override
  String get emailYourLogs => 'Kirim log anda melalui email';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Silakan kirim log-nya ke \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Salin alamat email';

  @override
  String get exportLogs => 'Ekspor log';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Silakan kirimi kami email di $toEmail';
  }

  @override
  String get dismiss => 'Dismiss';

  @override
  String get didYouKnow => 'Tahukah kamu?';

  @override
  String get loadingMessage => 'Memuat fotomu...';

  @override
  String get loadMessage1 => 'Kamu bisa membagikan langgananmu dengan keluarga';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'Kami menyimpan 3 salinan dari data kamu, salah satunya di tempat pengungsian bawah tanah';

  @override
  String get loadMessage4 => 'All our apps are open source';

  @override
  String get loadMessage5 =>
      'Our source code and cryptography have been externally audited';

  @override
  String get loadMessage6 =>
      'You can share links to your albums with your loved ones';

  @override
  String get loadMessage7 =>
      'App seluler kami berjalan di latar belakang untuk mengenkripsi dan mencadangkan foto yang kamu potret';

  @override
  String get loadMessage8 =>
      'web.ente.io menyediakan alat pengunggah yang bagus';

  @override
  String get loadMessage9 =>
      'Kami menggunakan Xchacha20Poly1305 untuk mengenkripsi data-mu dengan aman';

  @override
  String get photoDescriptions => 'Keterangan foto';

  @override
  String get fileTypesAndNames => 'Nama dan jenis file';

  @override
  String get location => 'Location';

  @override
  String get moments => 'Momen';

  @override
  String get searchFaceEmptySection =>
      'Orang akan ditampilkan di sini setelah pengindeksan selesai';

  @override
  String get searchDatesEmptySection =>
      'Telusuri dengan tanggal, bulan, atau tahun';

  @override
  String get searchLocationEmptySection =>
      'Group photos that are taken within some radius of a photo';

  @override
  String get searchPeopleEmptySection =>
      'Invite people, and you\'ll see all photos shared by them here';

  @override
  String get searchAlbumsEmptySection => 'Album';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Nama dan jenis file';

  @override
  String get searchCaptionEmptySection =>
      'Tambah keterangan seperti \"#trip\" pada info foto agar mudah ditemukan di sini';

  @override
  String get language => 'Bahasa';

  @override
  String get selectLanguage => 'Pilih Bahasa';

  @override
  String get locationName => 'Nama tempat';

  @override
  String get addLocation => 'Tambah tempat';

  @override
  String get groupNearbyPhotos => 'Kelompokkan foto yang berdekatan';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Tambah';

  @override
  String get radius => 'Radius';

  @override
  String get locationTagFeatureDescription =>
      'A location tag groups all photos that were taken within some radius of a photo';

  @override
  String get galleryMemoryLimitInfo => 'Up to 1000 memories shown in gallery';

  @override
  String get save => 'Simpan';

  @override
  String get centerPoint => 'Center point';

  @override
  String get pickCenterPoint => 'Pick center point';

  @override
  String get useSelectedPhoto => 'Gunakan foto terpilih';

  @override
  String get resetToDefault => 'Reset to default';

  @override
  String get edit => 'Edit';

  @override
  String get deleteLocation => 'Delete location';

  @override
  String get rotateLeft => 'Putar ke kiri';

  @override
  String get flip => 'Balik';

  @override
  String get rotateRight => 'Putar ke kanan';

  @override
  String get saveCopy => 'Save copy';

  @override
  String get light => 'Cahaya';

  @override
  String get color => 'Warna';

  @override
  String get yesDiscardChanges => 'Ya, buang perubahan';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Apakah kamu ingin membuang edit yang telah kamu buat?';

  @override
  String get saving => 'Menyimpan...';

  @override
  String get editsSaved => 'Perubahan tersimpan';

  @override
  String get oopsCouldNotSaveEdits => 'Aduh, tidak dapat menyimpan perubahan';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Hari Ini';

  @override
  String get dayYesterday => 'Kemarin';

  @override
  String get storage => 'Penyimpanan';

  @override
  String get usedSpace => 'Used space';

  @override
  String get storageBreakupFamily => 'Keluarga';

  @override
  String get storageBreakupYou => 'Kamu';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit dari $totalAmount $totalStorageUnit terpakai';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit tersedia';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versi: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verify';

  @override
  String get fileInfoAddDescHint => 'Tambahkan keterangan...';

  @override
  String get editLocationTagTitle => 'Edit lokasi';

  @override
  String get setLabel => 'Set';

  @override
  String get setRadius => 'Set radius';

  @override
  String get familyPlanPortalTitle => 'Keluarga';

  @override
  String get familyPlanOverview =>
      'Tambahkan 5 anggota keluarga ke paket kamu tanpa perlu bayar lebih.\n\nSetiap anggota mendapat ruang pribadi mereka sendiri, dan tidak dapat melihat file orang lain kecuali dibagikan.\n\nPaket keluarga tersedia bagi pelanggan yang memiliki langganan berbayar Ente.\n\nLangganan sekarang untuk mulai!';

  @override
  String get androidBiometricHint => 'Verifikasi identitas';

  @override
  String get androidBiometricNotRecognized => 'Tidak dikenal. Coba lagi.';

  @override
  String get androidBiometricSuccess => 'Berhasil';

  @override
  String get androidCancelButton => 'Batal';

  @override
  String get androidSignInTitle => 'Autentikasi diperlukan';

  @override
  String get androidBiometricRequiredTitle => 'Biometrik diperlukan';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Device credentials required';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Device credentials required';

  @override
  String get goToSettings => 'Buka pengaturan';

  @override
  String get androidGoToSettingsDescription =>
      'Autentikasi biometrik belum aktif di perangkatmu. Buka \'Setelan > Keamanan\' untuk mengaktifkan autentikasi biometrik.';

  @override
  String get iOSLockOut =>
      'Biometric authentication is disabled. Please lock and unlock your screen to enable it.';

  @override
  String get iOSGoToSettingsDescription =>
      'Autentikasi biometrik belum aktif di perangkatmu. Silakan aktifkan Touch ID atau Face ID pada ponselmu.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Kontributor OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Dihosting oleh OSM France';

  @override
  String get map => 'Peta';

  @override
  String get maps => 'Peta';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Aktifkan Peta';

  @override
  String get quickLinks => 'Quick links';

  @override
  String get selectItemsToAdd => 'Pilih item untuk ditambahkan';

  @override
  String get addSelected => 'Tambahkan yang dipilih';

  @override
  String get addFromDevice => 'Tambahkan dari perangkat';

  @override
  String get addPhotos => 'Tambah foto';

  @override
  String get noPhotosFoundHere => 'Tidak ada foto di sini';

  @override
  String get zoomOutToSeePhotos => 'Perkecil peta untuk melihat foto lainnya';

  @override
  String get noImagesWithLocation => 'No images with location';

  @override
  String get unpinAlbum => 'Unpin album';

  @override
  String get pinAlbum => 'Pin album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Buat';

  @override
  String get viewAll => 'Lihat semua';

  @override
  String get nothingSharedWithYouYet => 'Belum ada yang dibagikan denganmu';

  @override
  String get noAlbumsSharedByYouYet => 'Belum ada album yang kamu bagikan';

  @override
  String get sharedWithYou => 'Dibagikan dengan kamu';

  @override
  String get sharedByYou => 'Dibagikan oleh kamu';

  @override
  String get inviteYourFriendsToEnte => 'Undang temanmu ke Ente';

  @override
  String get failedToDownloadVideo => 'Gagal mengunduh video';

  @override
  String get hiding => 'Menyembunyikan...';

  @override
  String get unhiding => 'Unhiding...';

  @override
  String get successfullyHid => 'Berhasil disembunyikan';

  @override
  String get successfullyUnhid => 'Successfully unhid';

  @override
  String get crashReporting => 'Pelaporan crash';

  @override
  String get resumableUploads => 'Resumable uploads';

  @override
  String get addToHiddenAlbum => 'Tambah ke album tersembunyi';

  @override
  String get moveToHiddenAlbum => 'Pindahkan ke album tersembunyi';

  @override
  String get fileTypes => 'Jenis file';

  @override
  String get deleteConfirmDialogBody =>
      'This account is linked to other Ente apps, if you use any. Your uploaded data, across all Ente apps, will be scheduled for deletion, and your account will be permanently deleted.';

  @override
  String get hearUsWhereTitle => 'Dari mana Anda menemukan Ente? (opsional)';

  @override
  String get hearUsExplanation =>
      'We don\'t track app installs. It\'d help if you told us where you found us!';

  @override
  String get viewAddOnButton => 'View add-ons';

  @override
  String get addOns => 'Add-ons';

  @override
  String get addOnPageSubtitle => 'Details of add-ons';

  @override
  String get yourMap => 'Peta kamu';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modify your query, or try searching for';

  @override
  String get blackFridaySale => 'Penawaran Black Friday';

  @override
  String get upto50OffUntil4thDec => 'Potongan hingga 50%, sampai 4 Des.';

  @override
  String get photos => 'Foto';

  @override
  String get videos => 'Video';

  @override
  String get livePhotos => 'Live Photos';

  @override
  String get searchHint1 => 'Fast, on-device search';

  @override
  String get searchHint2 => 'Tanggal, keterangan foto';

  @override
  String get searchHint3 => 'Album, nama dan jenis file';

  @override
  String get searchHint4 => 'Location';

  @override
  String get searchHint5 => 'Segera tiba: Penelusuran wajah & ajaib ✨';

  @override
  String get addYourPhotosNow => 'Add your photos now';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hasil ditemukan',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Wajah';

  @override
  String get people => 'Orang';

  @override
  String get contents => 'Contents';

  @override
  String get addNew => 'Add new';

  @override
  String get contacts => 'Kontak';

  @override
  String get noInternetConnection => 'Tidak ada koneksi internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Silakan periksa koneksi internet kamu, lalu coba lagi.';

  @override
  String get signOutFromOtherDevices => 'Keluarkan akun dari perangkat lain';

  @override
  String get signOutOtherBody =>
      'Jika kamu merasa ada yang mengetahui sandimu, kamu bisa mengeluarkan akunmu secara paksa dari perangkat lain.';

  @override
  String get signOutOtherDevices => 'Keluar di perangkat lain';

  @override
  String get doNotSignOut => 'Jangan keluarkan akun';

  @override
  String get editLocation => 'Edit lokasi';

  @override
  String get selectALocation => 'Pilih lokasi';

  @override
  String get selectALocationFirst => 'Pilih lokasi terlebih dahulu';

  @override
  String get changeLocationOfSelectedItems => 'Ubah lokasi pada item terpilih?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Perubahan lokasi hanya akan terlihat di Ente';

  @override
  String get cleanUncategorized => 'Clean Uncategorized';

  @override
  String get cleanUncategorizedDescription =>
      'Remove all files from Uncategorized that are present in other albums';

  @override
  String get waitingForVerification => 'Menunggu verifikasi...';

  @override
  String get passkey => 'Passkey';

  @override
  String get passkeyAuthTitle => 'Verifikasi passkey';

  @override
  String get loginWithTOTP => 'Login with TOTP';

  @override
  String get passKeyPendingVerification => 'Verification is still pending';

  @override
  String get loginSessionExpired => 'Sesi berakhir';

  @override
  String get loginSessionExpiredDetails =>
      'Sesi kamu telah berakhir. Silakan masuk akun kembali.';

  @override
  String get verifyPasskey => 'Verifikasi passkey';

  @override
  String get playOnTv => 'Putar album di TV';

  @override
  String get pair => 'Tautkan';

  @override
  String get deviceNotFound => 'Perangkat tidak ditemukan';

  @override
  String get castInstruction =>
      'Buka cast.ente.io pada perangkat yang ingin kamu tautkan.\n\nMasukkan kode yang ditampilkan untuk memutar album di TV.';

  @override
  String get deviceCodeHint => 'Masukkan kode';

  @override
  String get joinDiscord => 'Bergabung ke Discord';

  @override
  String get locations => 'Locations';

  @override
  String get addAName => 'Tambahkan nama';

  @override
  String get findThemQuickly => 'Find them quickly';

  @override
  String get findPeopleByName => 'Telusuri orang dengan mudah menggunakan nama';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Tekan dan tahan email untuk membuktikan enkripsi ujung ke ujung.';

  @override
  String get developerSettingsWarning =>
      'Apakah kamu yakin ingin mengubah pengaturan pengembang?';

  @override
  String get developerSettings => 'Pengaturan pengembang';

  @override
  String get serverEndpoint => 'Endpoint server';

  @override
  String get invalidEndpoint => 'Endpoint tidak sah';

  @override
  String get invalidEndpointMessage =>
      'Maaf, endpoint yang kamu masukkan tidak sah. Harap masukkan endpoint yang sah dan coba lagi.';

  @override
  String get endpointUpdatedMessage => 'Endpoint berhasil diubah';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Terhubung ke $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Buat link kolaborasi';

  @override
  String get search => 'Telusuri';

  @override
  String get enterPersonName => 'Masukkan nama orang';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Enter name';

  @override
  String get savePerson => 'Save person';

  @override
  String get editPerson => 'Edit person';

  @override
  String get mergedPhotos => 'Merged photos';

  @override
  String get orMergeWithExistingPerson => 'Or merge with existing';

  @override
  String get enterDateOfBirth => 'Birthday (optional)';

  @override
  String get birthday => 'Birthday';

  @override
  String get removePersonLabel => 'Hapus label orang';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'Taut otomatis hanya tersedia di perangkat yang mendukung Chromecast.';

  @override
  String get manualPairDesc =>
      'Tautkan dengan PIN berfungsi di layar mana pun yang kamu inginkan.';

  @override
  String get connectToDevice => 'Hubungkan ke perangkat';

  @override
  String get autoCastDialogBody =>
      'Perangkat Cast yang tersedia akan ditampilkan di sini.';

  @override
  String get autoCastiOSPermission =>
      'Pastikan izin Jaringan Lokal untuk app Ente Foto aktif di Pengaturan.';

  @override
  String get noDeviceFound => 'Tidak ditemukan perangkat';

  @override
  String get stopCastingTitle => 'Hentikan transmisi';

  @override
  String get stopCastingBody => 'Apakah kamu ingin menghentikan transmisi?';

  @override
  String get castIPMismatchTitle => 'Gagal mentransmisikan album';

  @override
  String get castIPMismatchBody =>
      'Harap pastikan kamu berada pada jaringan yang sama dengan TV-nya.';

  @override
  String get pairingComplete => 'Penautan berhasil';

  @override
  String get savingEdits => 'Menyimpan edit...';

  @override
  String get autoPair => 'Taut otomatis';

  @override
  String get pairWithPin => 'Tautkan dengan PIN';

  @override
  String get faceRecognition => 'Pengenalan wajah';

  @override
  String get foundFaces => 'Wajah yang ditemukan';

  @override
  String get clusteringProgress => 'Clustering progress';

  @override
  String get trim => 'Pangkas';

  @override
  String get crop => 'Potong';

  @override
  String get rotate => 'Putar';

  @override
  String get left => 'Kiri';

  @override
  String get right => 'Kanan';

  @override
  String get whatsNew => 'Hal yang baru';

  @override
  String get reviewSuggestions => 'Review suggestions';

  @override
  String get review => 'Review';

  @override
  String get useAsCover => 'Use as cover';

  @override
  String notPersonLabel({required String name}) {
    return 'Not $name?';
  }

  @override
  String get enable => 'Enable';

  @override
  String get enabled => 'Enabled';

  @override
  String get moreDetails => 'More details';

  @override
  String get enableMLIndexingDesc =>
      'Ente supports on-device machine learning for face recognition, magic search and other advanced search features';

  @override
  String get magicSearchHint =>
      'Magic search allows to search photos by their contents, e.g. \'flower\', \'red car\', \'identity documents\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Re-enter password';

  @override
  String get reenterPin => 'Re-enter PIN';

  @override
  String get deviceLock => 'Device lock';

  @override
  String get pinLock => 'PIN lock';

  @override
  String get next => 'Next';

  @override
  String get setNewPassword => 'Set new password';

  @override
  String get enterPin => 'Enter PIN';

  @override
  String get setNewPin => 'Set new PIN';

  @override
  String get appLock => 'App lock';

  @override
  String get noSystemLockFound => 'No system lock found';

  @override
  String get tapToUnlock => 'Tap to unlock';

  @override
  String get tooManyIncorrectAttempts => 'Too many incorrect attempts';

  @override
  String get videoInfo => 'Video Info';

  @override
  String get autoLock => 'Auto lock';

  @override
  String get immediately => 'Immediately';

  @override
  String get autoLockFeatureDescription =>
      'Time after which the app locks after being put in the background';

  @override
  String get hideContent => 'Hide content';

  @override
  String get hideContentDescriptionAndroid =>
      'Hides app content in the app switcher and disables screenshots';

  @override
  String get hideContentDescriptionIos =>
      'Hides app content in the app switcher';

  @override
  String get passwordStrengthInfo =>
      'Password strength is calculated considering the length of the password, used characters, and whether or not the password appears in the top 10,000 most used passwords';

  @override
  String get noQuickLinksSelected => 'No quick links selected';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Please select quick links to remove';

  @override
  String get removePublicLinks => 'Remove public links';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'This will remove public links of all selected quick links.';

  @override
  String get guestView => 'Guest view';

  @override
  String get guestViewEnablePreSteps =>
      'To enable guest view, please setup device passcode or screen lock in your system settings.';

  @override
  String get nameTheAlbum => 'Name the album';

  @override
  String get collectPhotosDescription =>
      'Create a link where your friends can upload photos in original quality.';

  @override
  String get collect => 'Collect';

  @override
  String get appLockDescriptions =>
      'Choose between your device\'s default lock screen and a custom lock screen with a PIN or password.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'To enable app lock, please setup device passcode or screen lock in your system settings.';

  @override
  String get authToViewPasskey => 'Please authenticate to view your passkey';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Looks like something went wrong since local photos sync is taking more time than expected. Please reach out to our support team';

  @override
  String get showPerson => 'Show person';

  @override
  String get sort => 'Sort';

  @override
  String get mostRecent => 'Most recent';

  @override
  String get mostRelevant => 'Most relevant';

  @override
  String get loadingYourPhotos => 'Loading your photos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processing $folderName...';
  }

  @override
  String get personName => 'Person name';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Add new person';

  @override
  String get addNameOrMerge => 'Add name or merge';

  @override
  String get mergeWithExisting => 'Merge with existing';

  @override
  String get newPerson => 'New person';

  @override
  String get addName => 'Add name';

  @override
  String get add => 'Add';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Extra photos found for $text';
  }

  @override
  String get extraPhotosFound => 'Extra photos found';

  @override
  String get configuration => 'Configuration';

  @override
  String get localIndexing => 'Local indexing';

  @override
  String get processed => 'Processed';

  @override
  String get resetPerson => 'Remove';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Are you sure you want to reset this person?';

  @override
  String get allPersonGroupingWillReset =>
      'All groupings for this person will be reset, and you will lose all suggestions made for this person';

  @override
  String get yesResetPerson => 'Yes, reset person';

  @override
  String get onlyThem => 'Only them';

  @override
  String get checkingModels => 'Checking models...';

  @override
  String get enableMachineLearningBanner =>
      'Enable machine learning for magic search and face recognition';

  @override
  String get searchDiscoverEmptySection =>
      'Images will be shown here once processing and syncing is complete';

  @override
  String get searchPersonsEmptySection =>
      'People will be shown here once processing and syncing is complete';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count collaborators',
      one: 'Added 1 collaborator',
      zero: 'Added 0 collaborator',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Account is already configured.';

  @override
  String get sessionIdMismatch => 'Session ID mismatch';

  @override
  String get failedToFetchActiveSessions => 'Failed to fetch active sessions';

  @override
  String get failedToRefreshStripeSubscription =>
      'Failed to refresh subscription';

  @override
  String get failedToPlayVideo => 'Failed to play video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Upload is ignored due to $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Type of gallery $galleryType is not supported for rename';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Tap to upload, upload is currently ignored due to $ignoreReason';
  }

  @override
  String get tapToUpload => 'Tap to upload';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Add Files';

  @override
  String get castAlbum => 'Cast album';

  @override
  String get imageNotAnalyzed => 'Image not analyzed';

  @override
  String get noFacesFound => 'No faces found';

  @override
  String get fileNotUploadedYet => 'File not uploaded yet';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'No suggestions for $personName';
  }

  @override
  String get month => 'month';

  @override
  String get yearShort => 'yr';

  @override
  String get currentlyRunning => 'currently running';

  @override
  String get ignored => 'ignored';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'File';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Sections length mismatch: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Select mail app';

  @override
  String get selectAllShort => 'All';

  @override
  String get selectCoverPhoto => 'Select cover photo';

  @override
  String get newLocation => 'New location';

  @override
  String get faceNotClusteredYet =>
      'Face not clustered yet, please come back later';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'The link you are trying to access has expired.';

  @override
  String get openFile => 'Open file';

  @override
  String get backupFile => 'Backup file';

  @override
  String get openAlbumInBrowser => 'Open album in browser';

  @override
  String get openAlbumInBrowserTitle =>
      'Please use the web app to add photos to this album';

  @override
  String get allow => 'Allow';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Allow app to open shared album links';

  @override
  String get seePublicAlbumLinksInApp => 'See public album links in app';

  @override
  String get emergencyContacts => 'Emergency Contacts';

  @override
  String get acceptTrustInvite => 'Accept Invite';

  @override
  String get declineTrustInvite => 'Decline Invite';

  @override
  String get removeYourselfAsTrustedContact =>
      'Remove yourself as trusted contact';

  @override
  String get legacy => 'Legacy';

  @override
  String get legacyPageDesc =>
      'Legacy allows trusted contacts to access your account in your absence.';

  @override
  String get legacyPageDesc2 =>
      'Trusted contacts can initiate account recovery, and if not blocked within 30 days, reset your password and access your account.';

  @override
  String get legacyAccounts => 'Legacy accounts';

  @override
  String get trustedContacts => 'Trusted contacts';

  @override
  String get addTrustedContact => 'Add Trusted Contact';

  @override
  String get removeInvite => 'Remove invite';

  @override
  String get recoveryWarning =>
      'A trusted contact is trying to access your account';

  @override
  String get rejectRecovery => 'Reject recovery';

  @override
  String get recoveryInitiated => 'Recovery initiated';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'You can access the account after $days days. A notification will be sent to $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancel recovery';

  @override
  String get recoveryAccount => 'Recover account';

  @override
  String get cancelAccountRecoveryBody =>
      'Are you sure you want to cancel recovery?';

  @override
  String get startAccountRecoveryTitle => 'Start recovery';

  @override
  String get whyAddTrustContact =>
      'Trusted contact can help in recovering your data.';

  @override
  String recoveryReady({required String email}) {
    return 'You can now recover $email\'s account by setting a new password.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email is trying to recover your account.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'You have been invited to be a legacy contact by $email.';
  }

  @override
  String get warning => 'Warning';

  @override
  String get proceed => 'Proceed';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'You are about to add $email as a trusted contact. They will be able to recover your account if you are absent for $numOfDays days.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email has invited you to be a trusted contact';
  }

  @override
  String get authToManageLegacy =>
      'Please authenticate to manage your trusted contacts';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Hide shared items from home gallery';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Gallery';

  @override
  String get joinAlbum => 'Join album';

  @override
  String get joinAlbumSubtext => 'to view and add your photos';

  @override
  String get joinAlbumSubtextViewer => 'to add this to shared albums';

  @override
  String get join => 'Join';

  @override
  String get linkEmail => 'Link email';

  @override
  String get link => 'Link';

  @override
  String get noEnteAccountExclamation => 'No Ente account!';

  @override
  String get orPickFromYourContacts => 'or pick from your contacts';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email does not have an Ente account.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Me)';
  }

  @override
  String get reassignMe => 'Reassign \"Me\"';

  @override
  String get me => 'Me';

  @override
  String get linkEmailToContactBannerCaption => 'for faster sharing';

  @override
  String get selectPersonToLink => 'Select person to link';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Link person to $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'This will link $personName to $email';
  }

  @override
  String get selectYourFace => 'Select your face';

  @override
  String get reassigningLoading => 'Reassigning...';

  @override
  String reassignedToName({required String name}) {
    return 'Reassigned you to $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'Save changes before leaving?';

  @override
  String get dontSave => 'Don\'t save';

  @override
  String get thisIsMeExclamation => 'This is me!';

  @override
  String get linkPerson => 'Link person';

  @override
  String get linkPersonCaption => 'for better sharing experience';

  @override
  String get videoStreaming => 'Streamable videos';

  @override
  String get processingVideos => 'Processing videos';

  @override
  String get streamDetails => 'Stream details';

  @override
  String get processing => 'Processing';

  @override
  String get queued => 'Queued';

  @override
  String get ineligible => 'Ineligible';

  @override
  String get failed => 'Failed';

  @override
  String get playStream => 'Play stream';

  @override
  String get playOriginal => 'Play original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Joining an album will make your email visible to its participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Please wait, this will take a while.';

  @override
  String get editTime => 'Edit time';

  @override
  String get selectTime => 'Select time';

  @override
  String get selectDate => 'Select date';

  @override
  String get previous => 'Previous';

  @override
  String get selectOneDateAndTimeForAll => 'Select one date and time for all';

  @override
  String get selectStartOfRange => 'Select start of range';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'This will make the date and time of all selected photos the same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'This is the first in the group. Other selected photos will automatically shift based on this new date';

  @override
  String get newRange => 'New range';

  @override
  String get selectOneDateAndTime => 'Select one date and time';

  @override
  String get moveSelectedPhotosToOneDate => 'Move selected photos to one date';

  @override
  String get shiftDatesAndTime => 'Shift dates and time';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Photos keep relative time difference';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'App icon';

  @override
  String get notThisPerson => 'Not this person?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Selected items will be removed from this person, but not deleted from your library.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat through the years';
  }

  @override
  String get thisWeekThroughTheYears => 'This week through the years';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'This week, $count years ago',
      one: 'This week, $count year ago',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'You and $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admiring $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embracing $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Party with $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Hiking with $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feasting with $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies with $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posing with $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Beautiful views with $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sports with $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Road trip with $name';
  }

  @override
  String get spotlightOnYourself => 'Spotlight on yourself';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spotlight on $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name is $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name turning $age soon';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Last time with $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Trip to $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Trip in $year';
  }

  @override
  String get lastYearsTrip => 'Last year\'s trip';

  @override
  String get sunrise => 'On the horizon';

  @override
  String get mountains => 'Over the hills';

  @override
  String get greenery => 'The green life';

  @override
  String get beach => 'Sand and sea';

  @override
  String get city => 'In the city';

  @override
  String get moon => 'In the moonlight';

  @override
  String get onTheRoad => 'On the road again';

  @override
  String get food => 'Culinary delight';

  @override
  String get pets => 'Furry companions';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memories';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Past years\' memories';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Happy birthday! 🥳';

  @override
  String get birthdays => 'Birthdays';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Other detected faces';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Save as another person';

  @override
  String get showLessFaces => 'Show less faces';

  @override
  String get showMoreFaces => 'Show more faces';

  @override
  String get ignore => 'Ignore';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Introducing Rituals';

  @override
  String get cLDesc1 =>
      'Planning resolutions for 2026? With Rituals, you can set a reminder on Ente Photos and track your progress by taking photos. Use it for workouts, eating habits, daily moments with loved ones—anything you want to make a habit.';

  @override
  String get cLTitle2 => 'Public links, now for everyone';

  @override
  String get cLDesc2 =>
      'All Ente users on the free plan can now create and share public links to photos and albums. To prevent abuse, links will have limits on how many people can view them.';

  @override
  String get cLTitle3 => 'Manually tag people';

  @override
  String get cLDesc3 =>
      'You can now tag people even when our on-device AI doesn\'t detect a face. Handy for pets, partially visible faces, or moments where someone isn\'t actually in the photo but should still be included.';

  @override
  String get cLTitle4 => 'And more';

  @override
  String get cLDesc4 =>
      'You can now pin shared albums. Album links are visible to collaborators and viewers to make sharing even easier. We\'ve fixed some iOS swiping bugs and updated the photo view, including a new favorite icon (making room for upcoming features).';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
